/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.hardware.usb.UsbAccessory;
import android.hardware.usb.UsbDevice;
import android.os.Binder;
import android.os.UserHandle;
import android.util.Slog;
import android.util.SparseBooleanArray;
import com.android.internal.util.IndentingPrintWriter;
import java.util.HashMap;

class UsbUserSettingsManager {
    private static final String TAG = "UsbUserSettingsManager";
    private static final boolean DEBUG = false;
    private final UserHandle mUser;
    private final boolean mDisablePermissionDialogs;
    private final Context mUserContext;
    private final PackageManager mPackageManager;
    private final HashMap<String, SparseBooleanArray> mDevicePermissionMap = new HashMap();
    private final HashMap<UsbAccessory, SparseBooleanArray> mAccessoryPermissionMap = new HashMap();
    private final Object mLock = new Object();

    public UsbUserSettingsManager(Context context, UserHandle user) {
        try {
            this.mUserContext = context.createPackageContextAsUser("android", 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Missing android package");
        }
        this.mPackageManager = this.mUserContext.getPackageManager();
        this.mUser = user;
        this.mDisablePermissionDialogs = context.getResources().getBoolean(17956925);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDevicePermissions(UsbDevice device) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDevicePermissionMap.remove(device.getDeviceName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAccessoryPermissions(UsbAccessory accessory) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessoryPermissionMap.remove(accessory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(UsbDevice device) {
        Object object = this.mLock;
        synchronized (object) {
            int uid = Binder.getCallingUid();
            if (uid == 1000 || this.mDisablePermissionDialogs) {
                return true;
            }
            SparseBooleanArray uidList = this.mDevicePermissionMap.get(device.getDeviceName());
            if (uidList == null) {
                return false;
            }
            return uidList.get(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermission(UsbAccessory accessory) {
        Object object = this.mLock;
        synchronized (object) {
            int uid = Binder.getCallingUid();
            if (uid == 1000 || this.mDisablePermissionDialogs) {
                return true;
            }
            SparseBooleanArray uidList = this.mAccessoryPermissionMap.get(accessory);
            if (uidList == null) {
                return false;
            }
            return uidList.get(uid);
        }
    }

    public void checkPermission(UsbDevice device) {
        if (!this.hasPermission(device)) {
            throw new SecurityException("User has not given permission to device " + device);
        }
    }

    public void checkPermission(UsbAccessory accessory) {
        if (!this.hasPermission(accessory)) {
            throw new SecurityException("User has not given permission to accessory " + accessory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestPermissionDialog(Intent intent, String packageName, PendingIntent pi) {
        int uid = Binder.getCallingUid();
        try {
            ApplicationInfo aInfo = this.mPackageManager.getApplicationInfo(packageName, 0);
            if (aInfo.uid != uid) {
                throw new IllegalArgumentException("package " + packageName + " does not match caller's uid " + uid);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException("package " + packageName + " not found");
        }
        long identity = Binder.clearCallingIdentity();
        intent.setClassName("com.android.systemui", "com.android.systemui.usb.UsbPermissionActivity");
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.INTENT", pi);
        intent.putExtra("package", packageName);
        intent.putExtra("android.intent.extra.UID", uid);
        try {
            this.mUserContext.startActivityAsUser(intent, this.mUser);
        }
        catch (ActivityNotFoundException e) {
            Slog.e(TAG, "unable to start UsbPermissionActivity");
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public void requestPermission(UsbDevice device, String packageName, PendingIntent pi) {
        Intent intent = new Intent();
        if (this.hasPermission(device)) {
            intent.putExtra("device", device);
            intent.putExtra("permission", true);
            try {
                pi.send(this.mUserContext, 0, intent);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
            return;
        }
        intent.putExtra("device", device);
        this.requestPermissionDialog(intent, packageName, pi);
    }

    public void requestPermission(UsbAccessory accessory, String packageName, PendingIntent pi) {
        Intent intent = new Intent();
        if (this.hasPermission(accessory)) {
            intent.putExtra("accessory", accessory);
            intent.putExtra("permission", true);
            try {
                pi.send(this.mUserContext, 0, intent);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
            return;
        }
        intent.putExtra("accessory", accessory);
        this.requestPermissionDialog(intent, packageName, pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantDevicePermission(UsbDevice device, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            String deviceName = device.getDeviceName();
            SparseBooleanArray uidList = this.mDevicePermissionMap.get(deviceName);
            if (uidList == null) {
                uidList = new SparseBooleanArray(1);
                this.mDevicePermissionMap.put(deviceName, uidList);
            }
            uidList.put(uid, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantAccessoryPermission(UsbAccessory accessory, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            SparseBooleanArray uidList = this.mAccessoryPermissionMap.get(accessory);
            if (uidList == null) {
                uidList = new SparseBooleanArray(1);
                this.mAccessoryPermissionMap.put(accessory, uidList);
            }
            uidList.put(uid, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            int count;
            SparseBooleanArray uidList;
            pw.println("Device permissions:");
            for (String deviceName : this.mDevicePermissionMap.keySet()) {
                pw.print("  " + deviceName + ": ");
                uidList = this.mDevicePermissionMap.get(deviceName);
                count = uidList.size();
                for (i = 0; i < count; ++i) {
                    pw.print(Integer.toString(uidList.keyAt(i)) + " ");
                }
                pw.println();
            }
            pw.println("Accessory permissions:");
            for (UsbAccessory accessory : this.mAccessoryPermissionMap.keySet()) {
                pw.print("  " + accessory + ": ");
                uidList = this.mAccessoryPermissionMap.get(accessory);
                count = uidList.size();
                for (i = 0; i < count; ++i) {
                    pw.print(Integer.toString(uidList.keyAt(i)) + " ");
                }
                pw.println();
            }
        }
    }
}

