/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb;

import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Base64;
import android.util.Slog;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.FgThread;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class UsbDebuggingManager {
    private static final String TAG = "UsbDebuggingManager";
    private static final boolean DEBUG = false;
    private final String ADBD_SOCKET = "adbd";
    private final String ADB_DIRECTORY = "misc/adb";
    private final String ADB_KEYS_FILE = "adb_keys";
    private final int BUFFER_SIZE = 4096;
    private final Context mContext;
    private final Handler mHandler = new UsbDebuggingHandler(FgThread.get().getLooper());
    private UsbDebuggingThread mThread;
    private boolean mAdbEnabled = false;
    private String mFingerprints;

    public UsbDebuggingManager(Context context) {
        this.mContext = context;
    }

    private String getFingerprints(String key) {
        byte[] digest;
        MessageDigest digester;
        String hex = "0123456789ABCDEF";
        StringBuilder sb = new StringBuilder();
        if (key == null) {
            return "";
        }
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (Exception ex) {
            Slog.e(TAG, "Error getting digester", ex);
            return "";
        }
        byte[] base64_data = key.split("\\s+")[0].getBytes();
        try {
            digest = digester.digest(Base64.decode(base64_data, 0));
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "error doing base64 decoding", e);
            return "";
        }
        for (int i = 0; i < digest.length; ++i) {
            sb.append(hex.charAt(digest[i] >> 4 & 0xF));
            sb.append(hex.charAt(digest[i] & 0xF));
            if (i >= digest.length - 1) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    private void startConfirmation(String key, String fingerprints) {
        int currentUserId = ActivityManager.getCurrentUser();
        UserInfo userInfo = UserManager.get(this.mContext).getUserInfo(currentUserId);
        String componentString = userInfo.isAdmin() ? Resources.getSystem().getString(17039630) : Resources.getSystem().getString(17039631);
        ComponentName componentName = ComponentName.unflattenFromString(componentString);
        if (this.startConfirmationActivity(componentName, userInfo.getUserHandle(), key, fingerprints) || this.startConfirmationService(componentName, userInfo.getUserHandle(), key, fingerprints)) {
            return;
        }
        Slog.e(TAG, "unable to start customAdbPublicKeyConfirmation[SecondaryUser]Component " + componentString + " as an Activity or a Service");
    }

    private boolean startConfirmationActivity(ComponentName componentName, UserHandle userHandle, String key, String fingerprints) {
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent intent = this.createConfirmationIntent(componentName, key, fingerprints);
        intent.addFlags(0x10000000);
        if (packageManager.resolveActivity(intent, 65536) != null) {
            try {
                this.mContext.startActivityAsUser(intent, userHandle);
                return true;
            }
            catch (ActivityNotFoundException e) {
                Slog.e(TAG, "unable to start adb whitelist activity: " + componentName, e);
            }
        }
        return false;
    }

    private boolean startConfirmationService(ComponentName componentName, UserHandle userHandle, String key, String fingerprints) {
        Intent intent = this.createConfirmationIntent(componentName, key, fingerprints);
        try {
            if (this.mContext.startServiceAsUser(intent, userHandle) != null) {
                return true;
            }
        }
        catch (SecurityException e) {
            Slog.e(TAG, "unable to start adb whitelist service: " + componentName, e);
        }
        return false;
    }

    private Intent createConfirmationIntent(ComponentName componentName, String key, String fingerprints) {
        Intent intent = new Intent();
        intent.setClassName(componentName.getPackageName(), componentName.getClassName());
        intent.putExtra("key", key);
        intent.putExtra("fingerprints", fingerprints);
        return intent;
    }

    private File getUserKeyFile() {
        File dataDir = Environment.getDataDirectory();
        File adbDir = new File(dataDir, "misc/adb");
        if (!adbDir.exists()) {
            Slog.e(TAG, "ADB data directory does not exist");
            return null;
        }
        return new File(adbDir, "adb_keys");
    }

    private void writeKey(String key) {
        try {
            File keyFile = this.getUserKeyFile();
            if (keyFile == null) {
                return;
            }
            if (!keyFile.exists()) {
                keyFile.createNewFile();
                FileUtils.setPermissions(keyFile.toString(), 416, -1, -1);
            }
            FileOutputStream fo = new FileOutputStream(keyFile, true);
            fo.write(key.getBytes());
            fo.write(10);
            fo.close();
        }
        catch (IOException ex) {
            Slog.e(TAG, "Error writing key:" + ex);
        }
    }

    private void deleteKeyFile() {
        File keyFile = this.getUserKeyFile();
        if (keyFile != null) {
            keyFile.delete();
        }
    }

    public void setAdbEnabled(boolean enabled) {
        this.mHandler.sendEmptyMessage(enabled ? 1 : 2);
    }

    public void allowUsbDebugging(boolean alwaysAllow, String publicKey) {
        Message msg = this.mHandler.obtainMessage(3);
        msg.arg1 = alwaysAllow ? 1 : 0;
        msg.obj = publicKey;
        this.mHandler.sendMessage(msg);
    }

    public void denyUsbDebugging() {
        this.mHandler.sendEmptyMessage(4);
    }

    public void clearUsbDebuggingKeys() {
        this.mHandler.sendEmptyMessage(6);
    }

    public void dump(IndentingPrintWriter pw) {
        pw.println("USB Debugging State:");
        pw.println("  Connected to adbd: " + (this.mThread != null));
        pw.println("  Last key received: " + this.mFingerprints);
        pw.println("  User keys:");
        try {
            pw.println(FileUtils.readTextFile(new File("/data/misc/adb/adb_keys"), 0, null));
        }
        catch (IOException e) {
            pw.println("IOException: " + e);
        }
        pw.println("  System keys:");
        try {
            pw.println(FileUtils.readTextFile(new File("/adb_keys"), 0, null));
        }
        catch (IOException e) {
            pw.println("IOException: " + e);
        }
    }

    class UsbDebuggingHandler
    extends Handler {
        private static final int MESSAGE_ADB_ENABLED = 1;
        private static final int MESSAGE_ADB_DISABLED = 2;
        private static final int MESSAGE_ADB_ALLOW = 3;
        private static final int MESSAGE_ADB_DENY = 4;
        private static final int MESSAGE_ADB_CONFIRM = 5;
        private static final int MESSAGE_ADB_CLEAR = 6;

        public UsbDebuggingHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (UsbDebuggingManager.this.mAdbEnabled) break;
                    UsbDebuggingManager.this.mAdbEnabled = true;
                    UsbDebuggingManager.this.mThread = new UsbDebuggingThread();
                    UsbDebuggingManager.this.mThread.start();
                    break;
                }
                case 2: {
                    if (!UsbDebuggingManager.this.mAdbEnabled) break;
                    UsbDebuggingManager.this.mAdbEnabled = false;
                    if (UsbDebuggingManager.this.mThread == null) break;
                    UsbDebuggingManager.this.mThread.stopListening();
                    UsbDebuggingManager.this.mThread = null;
                    break;
                }
                case 3: {
                    String key = (String)msg.obj;
                    String fingerprints = UsbDebuggingManager.this.getFingerprints(key);
                    if (!fingerprints.equals(UsbDebuggingManager.this.mFingerprints)) {
                        Slog.e(UsbDebuggingManager.TAG, "Fingerprints do not match. Got " + fingerprints + ", expected " + UsbDebuggingManager.this.mFingerprints);
                        break;
                    }
                    if (msg.arg1 == 1) {
                        UsbDebuggingManager.this.writeKey(key);
                    }
                    if (UsbDebuggingManager.this.mThread == null) break;
                    UsbDebuggingManager.this.mThread.sendResponse("OK");
                    break;
                }
                case 4: {
                    if (UsbDebuggingManager.this.mThread == null) break;
                    UsbDebuggingManager.this.mThread.sendResponse("NO");
                    break;
                }
                case 5: {
                    if ("trigger_restart_min_framework".equals(SystemProperties.get("vold.decrypt"))) {
                        Slog.d(UsbDebuggingManager.TAG, "Deferring adb confirmation until after vold decrypt");
                        if (UsbDebuggingManager.this.mThread == null) break;
                        UsbDebuggingManager.this.mThread.sendResponse("NO");
                        break;
                    }
                    String key = (String)msg.obj;
                    String fingerprints = UsbDebuggingManager.this.getFingerprints(key);
                    if ("".equals(fingerprints)) {
                        if (UsbDebuggingManager.this.mThread == null) break;
                        UsbDebuggingManager.this.mThread.sendResponse("NO");
                        break;
                    }
                    UsbDebuggingManager.this.mFingerprints = fingerprints;
                    UsbDebuggingManager.this.startConfirmation(key, UsbDebuggingManager.this.mFingerprints);
                    break;
                }
                case 6: {
                    UsbDebuggingManager.this.deleteKeyFile();
                }
            }
        }
    }

    class UsbDebuggingThread
    extends Thread {
        private boolean mStopped;
        private LocalSocket mSocket;
        private OutputStream mOutputStream;
        private InputStream mInputStream;

        UsbDebuggingThread() {
            super(UsbDebuggingManager.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                UsbDebuggingThread usbDebuggingThread = this;
                synchronized (usbDebuggingThread) {
                    if (this.mStopped) {
                        return;
                    }
                    try {
                        this.openSocketLocked();
                    }
                    catch (Exception e) {
                        SystemClock.sleep(1000L);
                    }
                }
                try {
                    this.listenToSocket();
                    continue;
                }
                catch (Exception e) {
                    SystemClock.sleep(1000L);
                    continue;
                }
                break;
            }
        }

        private void openSocketLocked() throws IOException {
            try {
                LocalSocketAddress address = new LocalSocketAddress("adbd", LocalSocketAddress.Namespace.RESERVED);
                this.mInputStream = null;
                this.mSocket = new LocalSocket();
                this.mSocket.connect(address);
                this.mOutputStream = this.mSocket.getOutputStream();
                this.mInputStream = this.mSocket.getInputStream();
            }
            catch (IOException ioe) {
                this.closeSocketLocked();
                throw ioe;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void listenToSocket() throws IOException {
            block11: {
                try {
                    byte[] buffer = new byte[4096];
                    while (true) {
                        int count;
                        if ((count = this.mInputStream.read(buffer)) < 0) {
                            break block11;
                        }
                        if (buffer[0] != 80 || buffer[1] != 75) break;
                        String key = new String(Arrays.copyOfRange(buffer, 2, count));
                        Slog.d(UsbDebuggingManager.TAG, "Received public key: " + key);
                        Message msg = UsbDebuggingManager.this.mHandler.obtainMessage(5);
                        msg.obj = key;
                        UsbDebuggingManager.this.mHandler.sendMessage(msg);
                    }
                    Slog.e(UsbDebuggingManager.TAG, "Wrong message: " + new String(Arrays.copyOfRange(buffer, 0, 2)));
                }
                finally {
                    UsbDebuggingThread usbDebuggingThread = this;
                    synchronized (usbDebuggingThread) {
                        this.closeSocketLocked();
                    }
                }
            }
        }

        private void closeSocketLocked() {
            try {
                if (this.mOutputStream != null) {
                    this.mOutputStream.close();
                    this.mOutputStream = null;
                }
            }
            catch (IOException e) {
                Slog.e(UsbDebuggingManager.TAG, "Failed closing output stream: " + e);
            }
            try {
                if (this.mSocket != null) {
                    this.mSocket.close();
                    this.mSocket = null;
                }
            }
            catch (IOException ex) {
                Slog.e(UsbDebuggingManager.TAG, "Failed closing socket: " + ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopListening() {
            UsbDebuggingThread usbDebuggingThread = this;
            synchronized (usbDebuggingThread) {
                this.mStopped = true;
                this.closeSocketLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendResponse(String msg) {
            UsbDebuggingThread usbDebuggingThread = this;
            synchronized (usbDebuggingThread) {
                if (!this.mStopped && this.mOutputStream != null) {
                    try {
                        this.mOutputStream.write(msg.getBytes());
                    }
                    catch (IOException ex) {
                        Slog.e(UsbDebuggingManager.TAG, "Failed to write response:", ex);
                    }
                }
            }
        }
    }
}

