/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.telecom;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManagerInternal;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.telecom.DefaultDialerManager;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomManager;
import android.util.IntArray;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.telephony.SmsApplication;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.pm.UserManagerService;

public class TelecomLoaderService
extends SystemService {
    private static final String TAG = "TelecomLoaderService";
    private static final ComponentName SERVICE_COMPONENT = new ComponentName("com.android.server.telecom", "com.android.server.telecom.components.TelecomService");
    private static final String SERVICE_ACTION = "com.android.ITelecomService";
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private IntArray mDefaultSmsAppRequests;
    @GuardedBy(value="mLock")
    private IntArray mDefaultDialerAppRequests;
    @GuardedBy(value="mLock")
    private IntArray mDefaultSimCallManagerRequests;
    private final Context mContext;
    @GuardedBy(value="mLock")
    private TelecomServiceConnection mServiceConnection;

    public TelecomLoaderService(Context context) {
        super(context);
        this.mContext = context;
        this.registerDefaultAppProviders();
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 550) {
            this.registerDefaultAppNotifier();
            this.registerCarrierConfigChangedReceiver();
            this.connectToTelecom();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToTelecom() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                this.mContext.unbindService(this.mServiceConnection);
                this.mServiceConnection = null;
            }
            TelecomServiceConnection serviceConnection = new TelecomServiceConnection();
            Intent intent = new Intent(SERVICE_ACTION);
            intent.setComponent(SERVICE_COMPONENT);
            int flags = 0x4000041;
            if (this.mContext.bindServiceAsUser(intent, serviceConnection, flags, UserHandle.SYSTEM)) {
                this.mServiceConnection = serviceConnection;
            }
        }
    }

    private void registerDefaultAppProviders() {
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        packageManagerInternal.setSmsAppPackagesProvider(new PackageManagerInternal.PackagesProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getPackages(int userId) {
                Object object = TelecomLoaderService.this.mLock;
                synchronized (object) {
                    if (TelecomLoaderService.this.mServiceConnection == null) {
                        if (TelecomLoaderService.this.mDefaultSmsAppRequests == null) {
                            TelecomLoaderService.this.mDefaultSmsAppRequests = new IntArray();
                        }
                        TelecomLoaderService.this.mDefaultSmsAppRequests.add(userId);
                        return null;
                    }
                }
                ComponentName smsComponent = SmsApplication.getDefaultSmsApplication(TelecomLoaderService.this.mContext, true);
                if (smsComponent != null) {
                    return new String[]{smsComponent.getPackageName()};
                }
                return null;
            }
        });
        packageManagerInternal.setDialerAppPackagesProvider(new PackageManagerInternal.PackagesProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getPackages(int userId) {
                Object object = TelecomLoaderService.this.mLock;
                synchronized (object) {
                    if (TelecomLoaderService.this.mServiceConnection == null) {
                        if (TelecomLoaderService.this.mDefaultDialerAppRequests == null) {
                            TelecomLoaderService.this.mDefaultDialerAppRequests = new IntArray();
                        }
                        TelecomLoaderService.this.mDefaultDialerAppRequests.add(userId);
                        return null;
                    }
                }
                String packageName = DefaultDialerManager.getDefaultDialerApplication(TelecomLoaderService.this.mContext);
                if (packageName != null) {
                    return new String[]{packageName};
                }
                return null;
            }
        });
        packageManagerInternal.setSimCallManagerPackagesProvider(new PackageManagerInternal.PackagesProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getPackages(int userId) {
                Object object = TelecomLoaderService.this.mLock;
                synchronized (object) {
                    if (TelecomLoaderService.this.mServiceConnection == null) {
                        if (TelecomLoaderService.this.mDefaultSimCallManagerRequests == null) {
                            TelecomLoaderService.this.mDefaultSimCallManagerRequests = new IntArray();
                        }
                        TelecomLoaderService.this.mDefaultSimCallManagerRequests.add(userId);
                        return null;
                    }
                }
                TelecomManager telecomManager = (TelecomManager)TelecomLoaderService.this.mContext.getSystemService("telecom");
                PhoneAccountHandle phoneAccount = telecomManager.getSimCallManager(userId);
                if (phoneAccount != null) {
                    return new String[]{phoneAccount.getComponentName().getPackageName()};
                }
                return null;
            }
        });
    }

    private void registerDefaultAppNotifier() {
        final PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        final Uri defaultSmsAppUri = Settings.Secure.getUriFor("sms_default_application");
        final Uri defaultDialerAppUri = Settings.Secure.getUriFor("dialer_default_application");
        ContentObserver contentObserver = new ContentObserver(new Handler(Looper.getMainLooper())){

            @Override
            public void onChange(boolean selfChange, Uri uri, int userId) {
                if (defaultSmsAppUri.equals(uri)) {
                    ComponentName smsComponent = SmsApplication.getDefaultSmsApplication(TelecomLoaderService.this.mContext, true);
                    if (smsComponent != null) {
                        packageManagerInternal.grantDefaultPermissionsToDefaultSmsApp(smsComponent.getPackageName(), userId);
                    }
                } else if (defaultDialerAppUri.equals(uri)) {
                    String packageName = DefaultDialerManager.getDefaultDialerApplication(TelecomLoaderService.this.mContext);
                    if (packageName != null) {
                        packageManagerInternal.grantDefaultPermissionsToDefaultDialerApp(packageName, userId);
                    }
                    TelecomLoaderService.this.updateSimCallManagerPermissions(packageManagerInternal, userId);
                }
            }
        };
        this.mContext.getContentResolver().registerContentObserver(defaultSmsAppUri, false, contentObserver, -1);
        this.mContext.getContentResolver().registerContentObserver(defaultDialerAppUri, false, contentObserver, -1);
    }

    private void registerCarrierConfigChangedReceiver() {
        final PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        BroadcastReceiver receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                    for (int userId : UserManagerService.getInstance().getUserIds()) {
                        TelecomLoaderService.this.updateSimCallManagerPermissions(packageManagerInternal, userId);
                    }
                }
            }
        };
        this.mContext.registerReceiverAsUser(receiver, UserHandle.ALL, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"), null, null);
    }

    private void updateSimCallManagerPermissions(PackageManagerInternal packageManagerInternal, int userId) {
        TelecomManager telecomManager = (TelecomManager)this.mContext.getSystemService("telecom");
        PhoneAccountHandle phoneAccount = telecomManager.getSimCallManager(userId);
        if (phoneAccount != null) {
            Slog.i(TAG, "updating sim call manager permissions for userId:" + userId);
            String packageName = phoneAccount.getComponentName().getPackageName();
            packageManagerInternal.grantDefaultPermissionsToDefaultSimCallManager(packageName, userId);
        }
    }

    private class TelecomServiceConnection
    implements ServiceConnection {
        private TelecomServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                service.linkToDeath(new IBinder.DeathRecipient(){

                    @Override
                    public void binderDied() {
                        TelecomLoaderService.this.connectToTelecom();
                    }
                }, 0);
                SmsApplication.getDefaultMmsApplication(TelecomLoaderService.this.mContext, false);
                ServiceManager.addService("telecom", service);
                Object object = TelecomLoaderService.this.mLock;
                synchronized (object) {
                    if (TelecomLoaderService.this.mDefaultSmsAppRequests != null || TelecomLoaderService.this.mDefaultDialerAppRequests != null || TelecomLoaderService.this.mDefaultSimCallManagerRequests != null) {
                        TelecomManager telecomManager;
                        PhoneAccountHandle phoneAccount;
                        String packageName;
                        int i;
                        int requestCount;
                        ComponentName smsComponent;
                        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
                        if (TelecomLoaderService.this.mDefaultSmsAppRequests != null && (smsComponent = SmsApplication.getDefaultSmsApplication(TelecomLoaderService.this.mContext, true)) != null) {
                            requestCount = TelecomLoaderService.this.mDefaultSmsAppRequests.size();
                            for (i = requestCount - 1; i >= 0; --i) {
                                int userid = TelecomLoaderService.this.mDefaultSmsAppRequests.get(i);
                                TelecomLoaderService.this.mDefaultSmsAppRequests.remove(i);
                                packageManagerInternal.grantDefaultPermissionsToDefaultSmsApp(smsComponent.getPackageName(), userid);
                            }
                        }
                        if (TelecomLoaderService.this.mDefaultDialerAppRequests != null && (packageName = DefaultDialerManager.getDefaultDialerApplication(TelecomLoaderService.this.mContext)) != null) {
                            requestCount = TelecomLoaderService.this.mDefaultDialerAppRequests.size();
                            for (i = requestCount - 1; i >= 0; --i) {
                                int userId = TelecomLoaderService.this.mDefaultDialerAppRequests.get(i);
                                TelecomLoaderService.this.mDefaultDialerAppRequests.remove(i);
                                packageManagerInternal.grantDefaultPermissionsToDefaultDialerApp(packageName, userId);
                            }
                        }
                        if (TelecomLoaderService.this.mDefaultSimCallManagerRequests != null && (phoneAccount = (telecomManager = (TelecomManager)TelecomLoaderService.this.mContext.getSystemService("telecom")).getSimCallManager()) != null) {
                            int requestCount2 = TelecomLoaderService.this.mDefaultSimCallManagerRequests.size();
                            String packageName2 = phoneAccount.getComponentName().getPackageName();
                            for (int i2 = requestCount2 - 1; i2 >= 0; --i2) {
                                int userId = TelecomLoaderService.this.mDefaultSimCallManagerRequests.get(i2);
                                TelecomLoaderService.this.mDefaultSimCallManagerRequests.remove(i2);
                                packageManagerInternal.grantDefaultPermissionsToDefaultSimCallManager(packageName2, userId);
                            }
                        }
                    }
                }
            }
            catch (RemoteException e) {
                Slog.w(TelecomLoaderService.TAG, "Failed linking to death.");
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            TelecomLoaderService.this.connectToTelecom();
        }
    }
}

