/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.storage;

import android.os.ParcelFileDescriptor;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.FuseUnavailableMountException;
import com.android.internal.util.Preconditions;
import com.android.server.NativeDaemonConnectorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.CountDownLatch;
import libcore.io.IoUtils;

public class AppFuseBridge
implements Runnable {
    public static final String TAG = "AppFuseBridge";
    private static final String APPFUSE_MOUNT_NAME_TEMPLATE = "/mnt/appfuse/%d_%d";
    @GuardedBy(value="this")
    private final SparseArray<MountScope> mScopes = new SparseArray();
    @GuardedBy(value="this")
    private long mNativeLoop = this.native_new();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor addBridge(MountScope mountScope) throws FuseUnavailableMountException, NativeDaemonConnectorException {
        try {
            AppFuseBridge appFuseBridge = this;
            synchronized (appFuseBridge) {
                Preconditions.checkArgument(this.mScopes.indexOfKey(mountScope.mountId) < 0);
                if (this.mNativeLoop == 0L) {
                    throw new FuseUnavailableMountException(mountScope.mountId);
                }
                int fd = this.native_add_bridge(this.mNativeLoop, mountScope.mountId, mountScope.open().detachFd());
                if (fd == -1) {
                    throw new FuseUnavailableMountException(mountScope.mountId);
                }
                ParcelFileDescriptor result = ParcelFileDescriptor.adoptFd(fd);
                this.mScopes.put(mountScope.mountId, mountScope);
                mountScope = null;
                ParcelFileDescriptor parcelFileDescriptor = result;
                return parcelFileDescriptor;
            }
        }
        finally {
            IoUtils.closeQuietly(mountScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.native_start_loop(this.mNativeLoop);
        AppFuseBridge appFuseBridge = this;
        synchronized (appFuseBridge) {
            this.native_delete(this.mNativeLoop);
            this.mNativeLoop = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParcelFileDescriptor openFile(int pid, int mountId, int fileId, int mode) throws FuseUnavailableMountException, InterruptedException {
        MountScope scope;
        AppFuseBridge appFuseBridge = this;
        synchronized (appFuseBridge) {
            scope = this.mScopes.get(mountId);
            if (scope == null) {
                throw new FuseUnavailableMountException(mountId);
            }
        }
        if (scope.pid != pid) {
            throw new SecurityException("PID does not match");
        }
        boolean result = scope.waitForMount();
        if (!result) {
            throw new FuseUnavailableMountException(mountId);
        }
        try {
            return ParcelFileDescriptor.open(new File(scope.mountPoint, String.valueOf(fileId)), mode);
        }
        catch (FileNotFoundException error) {
            throw new FuseUnavailableMountException(mountId);
        }
    }

    private synchronized void onMount(int mountId) {
        MountScope scope = this.mScopes.get(mountId);
        if (scope != null) {
            scope.setMountResultLocked(true);
        }
    }

    private synchronized void onClosed(int mountId) {
        MountScope scope = this.mScopes.get(mountId);
        if (scope != null) {
            scope.setMountResultLocked(false);
            IoUtils.closeQuietly(scope);
            this.mScopes.remove(mountId);
        }
    }

    private native long native_new();

    private native void native_delete(long var1);

    private native void native_start_loop(long var1);

    private native int native_add_bridge(long var1, int var3, int var4);

    public static abstract class MountScope
    implements AutoCloseable {
        public final int uid;
        public final int pid;
        public final int mountId;
        public final File mountPoint;
        private final CountDownLatch mMounted = new CountDownLatch(1);
        private boolean mMountResult = false;

        public MountScope(int uid, int pid, int mountId) {
            this.uid = uid;
            this.pid = pid;
            this.mountId = mountId;
            this.mountPoint = new File(String.format(AppFuseBridge.APPFUSE_MOUNT_NAME_TEMPLATE, uid, mountId));
        }

        @GuardedBy(value="AppFuseBridge.this")
        void setMountResultLocked(boolean result) {
            if (this.mMounted.getCount() == 0L) {
                return;
            }
            this.mMountResult = result;
            this.mMounted.countDown();
        }

        boolean waitForMount() throws InterruptedException {
            this.mMounted.await();
            return this.mMountResult;
        }

        public abstract ParcelFileDescriptor open() throws NativeDaemonConnectorException;
    }
}

