/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.annotation.IntDef;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.PowerSaveState;
import android.provider.Settings;
import android.util.KeyValueListParser;
import android.util.Slog;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BatterySaverPolicy
extends ContentObserver {
    private static final String TAG = "BatterySaverPolicy";
    public static final int GPS_MODE_NO_CHANGE = 0;
    public static final int GPS_MODE_DISABLED_WHEN_SCREEN_OFF = 1;
    public static final String SECURE_KEY_GPS_MODE = "batterySaverGpsMode";
    private static final String KEY_GPS_MODE = "gps_mode";
    private static final String KEY_VIBRATION_DISABLED = "vibration_disabled";
    private static final String KEY_ANIMATION_DISABLED = "animation_disabled";
    private static final String KEY_SOUNDTRIGGER_DISABLED = "soundtrigger_disabled";
    private static final String KEY_FIREWALL_DISABLED = "firewall_disabled";
    private static final String KEY_ADJUST_BRIGHTNESS_DISABLED = "adjust_brightness_disabled";
    private static final String KEY_DATASAVER_DISABLED = "datasaver_disabled";
    private static final String KEY_ADJUST_BRIGHTNESS_FACTOR = "adjust_brightness_factor";
    private static final String KEY_FULLBACKUP_DEFERRED = "fullbackup_deferred";
    private static final String KEY_KEYVALUE_DEFERRED = "keyvaluebackup_deferred";
    private final KeyValueListParser mParser = new KeyValueListParser(',');
    private boolean mVibrationDisabled;
    private boolean mAnimationDisabled;
    private boolean mSoundTriggerDisabled;
    private boolean mFullBackupDeferred;
    private boolean mKeyValueBackupDeferred;
    private boolean mFireWallDisabled;
    private boolean mAdjustBrightnessDisabled;
    private boolean mDataSaverDisabled;
    private int mGpsMode;
    private float mAdjustBrightnessFactor;
    private ContentResolver mContentResolver;

    public BatterySaverPolicy(Handler handler) {
        super(handler);
    }

    public void start(ContentResolver contentResolver) {
        this.mContentResolver = contentResolver;
        this.mContentResolver.registerContentObserver(Settings.Global.getUriFor("battery_saver_constants"), false, this);
        this.onChange(true, null);
    }

    @Override
    public void onChange(boolean selfChange, Uri uri) {
        String value = Settings.Global.getString(this.mContentResolver, "battery_saver_constants");
        this.updateConstants(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConstants(String value) {
        BatterySaverPolicy batterySaverPolicy = this;
        synchronized (batterySaverPolicy) {
            try {
                this.mParser.setString(value);
            }
            catch (IllegalArgumentException e) {
                Slog.e(TAG, "Bad battery saver constants");
            }
            this.mVibrationDisabled = this.mParser.getBoolean(KEY_VIBRATION_DISABLED, true);
            this.mAnimationDisabled = this.mParser.getBoolean(KEY_ANIMATION_DISABLED, true);
            this.mSoundTriggerDisabled = this.mParser.getBoolean(KEY_SOUNDTRIGGER_DISABLED, true);
            this.mFullBackupDeferred = this.mParser.getBoolean(KEY_FULLBACKUP_DEFERRED, true);
            this.mKeyValueBackupDeferred = this.mParser.getBoolean(KEY_KEYVALUE_DEFERRED, true);
            this.mFireWallDisabled = this.mParser.getBoolean(KEY_FIREWALL_DISABLED, false);
            this.mAdjustBrightnessDisabled = this.mParser.getBoolean(KEY_ADJUST_BRIGHTNESS_DISABLED, false);
            this.mAdjustBrightnessFactor = this.mParser.getFloat(KEY_ADJUST_BRIGHTNESS_FACTOR, 0.5f);
            this.mDataSaverDisabled = this.mParser.getBoolean(KEY_DATASAVER_DISABLED, true);
            int defaultGpsMode = Settings.Secure.getInt(this.mContentResolver, SECURE_KEY_GPS_MODE, 1);
            this.mGpsMode = this.mParser.getInt(KEY_GPS_MODE, defaultGpsMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerSaveState getBatterySaverPolicy(int type, boolean realMode) {
        BatterySaverPolicy batterySaverPolicy = this;
        synchronized (batterySaverPolicy) {
            PowerSaveState.Builder builder = new PowerSaveState.Builder().setGlobalBatterySaverEnabled(realMode);
            if (!realMode) {
                return builder.setBatterySaverEnabled(realMode).build();
            }
            switch (type) {
                case 1: {
                    return builder.setBatterySaverEnabled(realMode).setGpsMode(this.mGpsMode).build();
                }
                case 3: {
                    return builder.setBatterySaverEnabled(this.mAnimationDisabled).build();
                }
                case 4: {
                    return builder.setBatterySaverEnabled(this.mFullBackupDeferred).build();
                }
                case 5: {
                    return builder.setBatterySaverEnabled(this.mKeyValueBackupDeferred).build();
                }
                case 6: {
                    return builder.setBatterySaverEnabled(!this.mFireWallDisabled).build();
                }
                case 7: {
                    return builder.setBatterySaverEnabled(!this.mAdjustBrightnessDisabled).setBrightnessFactor(this.mAdjustBrightnessFactor).build();
                }
                case 10: {
                    return builder.setBatterySaverEnabled(!this.mDataSaverDisabled).build();
                }
                case 8: {
                    return builder.setBatterySaverEnabled(this.mSoundTriggerDisabled).build();
                }
                case 2: {
                    return builder.setBatterySaverEnabled(this.mVibrationDisabled).build();
                }
            }
            return builder.setBatterySaverEnabled(realMode).build();
        }
    }

    public void dump(PrintWriter pw) {
        pw.println();
        pw.println("Battery saver policy");
        pw.println("  Settings battery_saver_constants");
        pw.println("  value: " + Settings.Global.getString(this.mContentResolver, "battery_saver_constants"));
        pw.println();
        pw.println("  vibration_disabled=" + this.mVibrationDisabled);
        pw.println("  animation_disabled=" + this.mAnimationDisabled);
        pw.println("  fullbackup_deferred=" + this.mFullBackupDeferred);
        pw.println("  keyvaluebackup_deferred=" + this.mKeyValueBackupDeferred);
        pw.println("  firewall_disabled=" + this.mFireWallDisabled);
        pw.println("  datasaver_disabled=" + this.mDataSaverDisabled);
        pw.println("  adjust_brightness_disabled=" + this.mAdjustBrightnessDisabled);
        pw.println("  adjust_brightness_factor=" + this.mAdjustBrightnessFactor);
        pw.println("  gps_mode=" + this.mGpsMode);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L})
    public static @interface ServiceType {
        public static final int NULL = 0;
        public static final int GPS = 1;
        public static final int VIBRATION = 2;
        public static final int ANIMATION = 3;
        public static final int FULL_BACKUP = 4;
        public static final int KEYVALUE_BACKUP = 5;
        public static final int NETWORK_FIREWALL = 6;
        public static final int SCREEN_BRIGHTNESS = 7;
        public static final int SOUND = 8;
        public static final int BATTERY_STATS = 9;
        public static final int DATA_SAVER = 10;
    }
}

