/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.XmlResourceParser;
import android.os.UserHandle;
import android.util.SparseArray;
import android.view.KeyEvent;
import com.android.internal.util.XmlUtils;
import java.io.PrintWriter;

final class GlobalKeyManager {
    private static final String TAG = "GlobalKeyManager";
    private static final String TAG_GLOBAL_KEYS = "global_keys";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_KEY = "key";
    private static final String ATTR_KEY_CODE = "keyCode";
    private static final String ATTR_COMPONENT = "component";
    private static final int GLOBAL_KEY_FILE_VERSION = 1;
    private SparseArray<ComponentName> mKeyMapping = new SparseArray();

    public GlobalKeyManager(Context context) {
        this.loadGlobalKeys(context);
    }

    boolean handleGlobalKey(Context context, int keyCode, KeyEvent event) {
        ComponentName component;
        if (this.mKeyMapping.size() > 0 && (component = this.mKeyMapping.get(keyCode)) != null) {
            Intent intent = new Intent("android.intent.action.GLOBAL_BUTTON").setComponent(component).setFlags(0x10000000).putExtra("android.intent.extra.KEY_EVENT", event);
            context.sendBroadcastAsUser(intent, UserHandle.CURRENT, null);
            return true;
        }
        return false;
    }

    boolean shouldHandleGlobalKey(int keyCode, KeyEvent event) {
        return this.mKeyMapping.get(keyCode) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGlobalKeys(Context context) {
        block12: {
            try (XmlResourceParser parser = null;){
                parser = context.getResources().getXml(18284550);
                XmlUtils.beginDocument(parser, TAG_GLOBAL_KEYS);
                int version = parser.getAttributeIntValue(null, ATTR_VERSION, 0);
                if (1 != version) break block12;
                while (true) {
                    XmlUtils.nextElement(parser);
                    String element = parser.getName();
                    if (element == null) {
                        break;
                    }
                    if (!TAG_KEY.equals(element)) continue;
                    String keyCodeName = parser.getAttributeValue(null, ATTR_KEY_CODE);
                    String componentName = parser.getAttributeValue(null, ATTR_COMPONENT);
                    int keyCode = KeyEvent.keyCodeFromString(keyCodeName);
                    if (keyCode == 0) continue;
                    this.mKeyMapping.put(keyCode, ComponentName.unflattenFromString(componentName));
                }
            }
        }
    }

    public void dump(String prefix, PrintWriter pw) {
        int numKeys = this.mKeyMapping.size();
        if (numKeys == 0) {
            pw.print(prefix);
            pw.println("mKeyMapping.size=0");
            return;
        }
        pw.print(prefix);
        pw.println("mKeyMapping={");
        for (int i = 0; i < numKeys; ++i) {
            pw.print("  ");
            pw.print(prefix);
            pw.print(KeyEvent.keyCodeToString(this.mKeyMapping.keyAt(i)));
            pw.print("=");
            pw.println(this.mKeyMapping.valueAt(i).flattenToString());
        }
        pw.print(prefix);
        pw.println("}");
    }
}

