/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.os.FileUtils;
import android.util.AtomicFile;
import android.util.Log;
import com.android.server.pm.AbstractStatsBase;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import libcore.io.IoUtils;

class PackageUsage
extends AbstractStatsBase<Map<String, PackageParser.Package>> {
    private static final String USAGE_FILE_MAGIC = "PACKAGE_USAGE__VERSION_";
    private static final String USAGE_FILE_MAGIC_VERSION_1 = "PACKAGE_USAGE__VERSION_1";
    private boolean mIsHistoricalPackageUsageAvailable = true;

    PackageUsage() {
        super("package-usage.list", "PackageUsage_DiskWriter", true);
    }

    boolean isHistoricalPackageUsageAvailable() {
        return this.mIsHistoricalPackageUsageAvailable;
    }

    @Override
    protected void writeInternal(Map<String, PackageParser.Package> packages) {
        AtomicFile file = this.getFile();
        FileOutputStream f = null;
        try {
            f = file.startWrite();
            BufferedOutputStream out = new BufferedOutputStream(f);
            FileUtils.setPermissions(file.getBaseFile().getPath(), 416, 1000, 1032);
            StringBuilder sb = new StringBuilder();
            sb.append(USAGE_FILE_MAGIC_VERSION_1);
            sb.append('\n');
            out.write(sb.toString().getBytes(StandardCharsets.US_ASCII));
            for (PackageParser.Package pkg : packages.values()) {
                if (pkg.getLatestPackageUseTimeInMills() == 0L) continue;
                sb.setLength(0);
                sb.append(pkg.packageName);
                for (long usageTimeInMillis : pkg.mLastPackageUsageTimeInMills) {
                    sb.append(' ');
                    sb.append(usageTimeInMillis);
                }
                sb.append('\n');
                out.write(sb.toString().getBytes(StandardCharsets.US_ASCII));
            }
            out.flush();
            file.finishWrite(f);
        }
        catch (IOException e) {
            if (f != null) {
                file.failWrite(f);
            }
            Log.e("PackageManager", "Failed to write package usage times", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void readInternal(Map<String, PackageParser.Package> packages) {
        BufferedInputStream in;
        block7: {
            AtomicFile file = this.getFile();
            in = null;
            try {
                in = new BufferedInputStream(file.openRead());
                StringBuffer sb = new StringBuffer();
                String firstLine = this.readLine(in, sb);
                if (firstLine == null) break block7;
                if (USAGE_FILE_MAGIC_VERSION_1.equals(firstLine)) {
                    this.readVersion1LP(packages, in, sb);
                    break block7;
                }
                this.readVersion0LP(packages, in, sb, firstLine);
            }
            catch (FileNotFoundException expected) {
                this.mIsHistoricalPackageUsageAvailable = false;
                IoUtils.closeQuietly(in);
            }
            catch (IOException e) {
                Log.w("PackageManager", "Failed to read package usage times", e);
                {
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(in);
            }
        }
        IoUtils.closeQuietly(in);
    }

    private void readVersion0LP(Map<String, PackageParser.Package> packages, InputStream in, StringBuffer sb, String firstLine) throws IOException {
        String line = firstLine;
        while (line != null) {
            String[] tokens = line.split(" ");
            if (tokens.length != 2) {
                throw new IOException("Failed to parse " + line + " as package-timestamp pair.");
            }
            String packageName = tokens[0];
            PackageParser.Package pkg = packages.get(packageName);
            if (pkg != null) {
                long timestamp = this.parseAsLong(tokens[1]);
                for (int reason = 0; reason < 8; ++reason) {
                    pkg.mLastPackageUsageTimeInMills[reason] = timestamp;
                }
            }
            line = this.readLine(in, sb);
        }
    }

    private void readVersion1LP(Map<String, PackageParser.Package> packages, InputStream in, StringBuffer sb) throws IOException {
        String line;
        while ((line = this.readLine(in, sb)) != null) {
            String[] tokens = line.split(" ");
            if (tokens.length != 9) {
                throw new IOException("Failed to parse " + line + " as a timestamp array.");
            }
            String packageName = tokens[0];
            PackageParser.Package pkg = packages.get(packageName);
            if (pkg == null) continue;
            for (int reason = 0; reason < 8; ++reason) {
                pkg.mLastPackageUsageTimeInMills[reason] = this.parseAsLong(tokens[reason + 1]);
            }
        }
    }

    private long parseAsLong(String token) throws IOException {
        try {
            return Long.parseLong(token);
        }
        catch (NumberFormatException e) {
            throw new IOException("Failed to parse " + token + " as a long.", e);
        }
    }

    private String readLine(InputStream in, StringBuffer sb) throws IOException {
        return this.readToken(in, sb, '\n');
    }

    private String readToken(InputStream in, StringBuffer sb, char endOfToken) throws IOException {
        sb.setLength(0);
        while (true) {
            int ch;
            if ((ch = in.read()) == -1) {
                if (sb.length() == 0) {
                    return null;
                }
                throw new IOException("Unexpected EOF");
            }
            if (ch == endOfToken) {
                return sb.toString();
            }
            sb.append((char)ch);
        }
    }
}

