/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.notification.NotificationManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class ManagedServices {
    protected final String TAG = this.getClass().getSimpleName();
    protected final boolean DEBUG = Log.isLoggable(this.TAG, 3);
    protected static final String ENABLED_SERVICES_SEPARATOR = ":";
    protected final Context mContext;
    protected final Object mMutex;
    private final UserProfiles mUserProfiles;
    private final SettingsObserver mSettingsObserver;
    private final IPackageManager mPm;
    private final Config mConfig;
    private ArraySet<String> mRestored;
    private final ArrayList<ManagedServiceInfo> mServices = new ArrayList();
    private final ArrayList<String> mServicesBinding = new ArrayList();
    private ArraySet<ComponentName> mEnabledServicesForCurrentProfiles = new ArraySet();
    private ArraySet<String> mEnabledServicesPackageNames = new ArraySet();
    private ArraySet<String> mRestoredPackages = new ArraySet();
    private ArraySet<ComponentName> mSnoozingForCurrentProfiles = new ArraySet();
    private int[] mLastSeenProfileIds;
    private final BroadcastReceiver mRestoreReceiver;

    public ManagedServices(Context context, Handler handler, Object mutex, UserProfiles userProfiles) {
        this.mContext = context;
        this.mMutex = mutex;
        this.mUserProfiles = userProfiles;
        this.mPm = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
        this.mConfig = this.getConfig();
        this.mSettingsObserver = new SettingsObserver(handler);
        this.mRestoreReceiver = new SettingRestoredReceiver();
        IntentFilter filter = new IntentFilter("android.os.action.SETTING_RESTORED");
        context.registerReceiver(this.mRestoreReceiver, filter);
        this.rebuildRestoredPackages();
    }

    protected abstract Config getConfig();

    private String getCaption() {
        return this.mConfig.caption;
    }

    protected abstract IInterface asInterface(IBinder var1);

    protected abstract boolean checkType(IInterface var1);

    protected abstract void onServiceAdded(ManagedServiceInfo var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ManagedServiceInfo> getServices() {
        Object object = this.mMutex;
        synchronized (object) {
            ArrayList<ManagedServiceInfo> services = new ArrayList<ManagedServiceInfo>(this.mServices);
            return services;
        }
    }

    protected void onServiceRemovedLocked(ManagedServiceInfo removed) {
    }

    private ManagedServiceInfo newServiceInfo(IInterface service, ComponentName component, int userid, boolean isSystem, ServiceConnection connection, int targetSdkVersion) {
        return new ManagedServiceInfo(service, component, userid, isSystem, connection, targetSdkVersion);
    }

    public void onBootPhaseAppsCanStart() {
        this.mSettingsObserver.observe();
    }

    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        pw.println("    All " + this.getCaption() + "s (" + this.mEnabledServicesForCurrentProfiles.size() + ") enabled for current profiles:");
        for (ComponentName cmpt : this.mEnabledServicesForCurrentProfiles) {
            if (filter != null && !filter.matches(cmpt)) continue;
            pw.println("      " + cmpt);
        }
        pw.println("    Live " + this.getCaption() + "s (" + this.mServices.size() + "):");
        for (ManagedServiceInfo info : this.mServices) {
            if (filter != null && !filter.matches(info.component)) continue;
            pw.println("      " + info.component + " (user " + info.userid + "): " + info.service + (info.isSystem ? " SYSTEM" : "") + (info.isGuest(this) ? " GUEST" : ""));
        }
        pw.println("    Snoozed " + this.getCaption() + "s (" + this.mSnoozingForCurrentProfiles.size() + "):");
        for (ComponentName name : this.mSnoozingForCurrentProfiles) {
            pw.println("      " + name.flattenToShortString());
        }
    }

    public static String restoredSettingName(String setting) {
        return setting + ":restored";
    }

    public void settingRestored(String element, String oldValue, String newValue, int userid) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "Restored managed service setting: " + element + " ovalue=" + oldValue + " nvalue=" + newValue);
        }
        if ((this.mConfig.secureSettingName.equals(element) || this.mConfig.secondarySettingName.equals(element)) && element != null) {
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), ManagedServices.restoredSettingName(element), newValue, userid);
            if (this.mConfig.secureSettingName.equals(element)) {
                this.updateSettingsAccordingToInstalledServices(element, userid);
            }
            this.rebuildRestoredPackages();
        }
    }

    public boolean isComponentEnabledForPackage(String pkg) {
        return this.mEnabledServicesPackageNames.contains(pkg);
    }

    public void onPackagesChanged(boolean removingPackage, String[] pkgList) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onPackagesChanged removingPackage=" + removingPackage + " pkgList=" + (pkgList == null ? null : Arrays.asList(pkgList)) + " mEnabledServicesPackageNames=" + this.mEnabledServicesPackageNames);
        }
        boolean anyServicesInvolved = false;
        if (pkgList != null && pkgList.length > 0) {
            for (String pkgName : pkgList) {
                if (!this.mEnabledServicesPackageNames.contains(pkgName) && !this.mRestoredPackages.contains(pkgName)) continue;
                anyServicesInvolved = true;
            }
        }
        if (anyServicesInvolved) {
            if (removingPackage) {
                this.updateSettingsAccordingToInstalledServices();
                this.rebuildRestoredPackages();
            }
            this.rebindServices(false);
        }
    }

    public void onUserSwitched(int user) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onUserSwitched u=" + user);
        }
        this.rebuildRestoredPackages();
        if (Arrays.equals(this.mLastSeenProfileIds, this.mUserProfiles.getCurrentProfileIds())) {
            if (this.DEBUG) {
                Slog.d(this.TAG, "Current profile IDs didn't change, skipping rebindServices().");
            }
            return;
        }
        this.rebindServices(true);
    }

    public void onUserUnlocked(int user) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onUserUnlocked u=" + user);
        }
        this.rebuildRestoredPackages();
        this.rebindServices(false);
    }

    public ManagedServiceInfo getServiceFromTokenLocked(IInterface service) {
        if (service == null) {
            return null;
        }
        IBinder token = service.asBinder();
        int N = this.mServices.size();
        for (int i = 0; i < N; ++i) {
            ManagedServiceInfo info = this.mServices.get(i);
            if (info.service.asBinder() != token) continue;
            return info;
        }
        return null;
    }

    public ManagedServiceInfo checkServiceTokenLocked(IInterface service) {
        this.checkNotNull(service);
        ManagedServiceInfo info = this.getServiceFromTokenLocked(service);
        if (info != null) {
            return info;
        }
        throw new SecurityException("Disallowed call from unknown " + this.getCaption() + ": " + service);
    }

    public void unregisterService(IInterface service, int userid) {
        this.checkNotNull(service);
        this.unregisterServiceImpl(service, userid);
    }

    public void registerService(IInterface service, ComponentName component, int userid) {
        this.checkNotNull(service);
        ManagedServiceInfo info = this.registerServiceImpl(service, component, userid);
        if (info != null) {
            this.onServiceAdded(info);
        }
    }

    public void registerGuestService(ManagedServiceInfo guest) {
        this.checkNotNull(guest.service);
        if (!this.checkType(guest.service)) {
            throw new IllegalArgumentException();
        }
        if (this.registerServiceImpl(guest) != null) {
            this.onServiceAdded(guest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComponentState(ComponentName component, boolean enabled) {
        boolean previous;
        boolean bl = previous = !this.mSnoozingForCurrentProfiles.contains(component);
        if (previous == enabled) {
            return;
        }
        if (enabled) {
            this.mSnoozingForCurrentProfiles.remove(component);
        } else {
            this.mSnoozingForCurrentProfiles.add(component);
        }
        if (this.DEBUG) {
            Slog.d(this.TAG, (enabled ? "Enabling " : "Disabling ") + "component " + component.flattenToShortString());
        }
        Object object = this.mMutex;
        synchronized (object) {
            int[] userIds;
            for (int userId : userIds = this.mUserProfiles.getCurrentProfileIds()) {
                if (enabled) {
                    this.registerServiceLocked(component, userId);
                    continue;
                }
                this.unregisterServiceLocked(component, userId);
            }
        }
    }

    private void rebuildRestoredPackages() {
        this.mRestoredPackages.clear();
        String secureSettingName = ManagedServices.restoredSettingName(this.mConfig.secureSettingName);
        String secondarySettingName = this.mConfig.secondarySettingName == null ? null : ManagedServices.restoredSettingName(this.mConfig.secondarySettingName);
        int[] userIds = this.mUserProfiles.getCurrentProfileIds();
        int N = userIds.length;
        for (int i = 0; i < N; ++i) {
            ArraySet<ComponentName> names = this.loadComponentNamesFromSetting(secureSettingName, userIds[i]);
            if (secondarySettingName != null) {
                names.addAll(this.loadComponentNamesFromSetting(secondarySettingName, userIds[i]));
            }
            for (ComponentName name : names) {
                this.mRestoredPackages.add(name.getPackageName());
            }
        }
    }

    protected ArraySet<ComponentName> loadComponentNamesFromSetting(String settingName, int userId) {
        ContentResolver cr = this.mContext.getContentResolver();
        String settingValue = Settings.Secure.getStringForUser(cr, settingName, userId);
        if (TextUtils.isEmpty(settingValue)) {
            return new ArraySet<ComponentName>();
        }
        String[] restored = settingValue.split(ENABLED_SERVICES_SEPARATOR);
        ArraySet<ComponentName> result = new ArraySet<ComponentName>(restored.length);
        for (int i = 0; i < restored.length; ++i) {
            ComponentName value = ComponentName.unflattenFromString(restored[i]);
            if (null == value) continue;
            result.add(value);
        }
        return result;
    }

    private void storeComponentsToSetting(Set<ComponentName> components, String settingName, int userId) {
        Object[] componentNames = null;
        if (null != components) {
            componentNames = new String[components.size()];
            int index = 0;
            for (ComponentName c : components) {
                componentNames[index++] = c.flattenToString();
            }
        }
        String value = componentNames == null ? "" : TextUtils.join((CharSequence)ENABLED_SERVICES_SEPARATOR, componentNames);
        ContentResolver cr = this.mContext.getContentResolver();
        Settings.Secure.putStringForUser(cr, settingName, value, userId);
    }

    private void updateSettingsAccordingToInstalledServices() {
        int[] userIds = this.mUserProfiles.getCurrentProfileIds();
        int N = userIds.length;
        for (int i = 0; i < N; ++i) {
            this.updateSettingsAccordingToInstalledServices(this.mConfig.secureSettingName, userIds[i]);
            if (this.mConfig.secondarySettingName == null) continue;
            this.updateSettingsAccordingToInstalledServices(this.mConfig.secondarySettingName, userIds[i]);
        }
        this.rebuildRestoredPackages();
    }

    protected Set<ComponentName> queryPackageForServices(String packageName, int userId) {
        ArraySet<ComponentName> installed = new ArraySet<ComponentName>();
        PackageManager pm = this.mContext.getPackageManager();
        Intent queryIntent = new Intent(this.mConfig.serviceInterface);
        if (!TextUtils.isEmpty(packageName)) {
            queryIntent.setPackage(packageName);
        }
        List<ResolveInfo> installedServices = pm.queryIntentServicesAsUser(queryIntent, 132, userId);
        if (this.DEBUG) {
            Slog.v(this.TAG, this.mConfig.serviceInterface + " services: " + installedServices);
        }
        if (installedServices != null) {
            int count = installedServices.size();
            for (int i = 0; i < count; ++i) {
                ResolveInfo resolveInfo = installedServices.get(i);
                ServiceInfo info = resolveInfo.serviceInfo;
                ComponentName component = new ComponentName(info.packageName, info.name);
                if (!this.mConfig.bindPermission.equals(info.permission)) {
                    Slog.w(this.TAG, "Skipping " + this.getCaption() + " service " + info.packageName + "/" + info.name + ": it does not require the permission " + this.mConfig.bindPermission);
                    continue;
                }
                installed.add(component);
            }
        }
        return installed;
    }

    private void updateSettingsAccordingToInstalledServices(String setting, int userId) {
        boolean restoredChanged = false;
        boolean currentChanged = false;
        ArraySet<ComponentName> restored = this.loadComponentNamesFromSetting(ManagedServices.restoredSettingName(setting), userId);
        ArraySet<ComponentName> current = this.loadComponentNamesFromSetting(setting, userId);
        Set<ComponentName> installed = this.queryPackageForServices(null, userId);
        ArraySet<ComponentName> retained = new ArraySet<ComponentName>();
        for (ComponentName component : installed) {
            boolean wasRestored;
            if (null != restored && (wasRestored = restored.remove(component))) {
                if (this.DEBUG) {
                    Slog.v(this.TAG, "Restoring " + component + " for user " + userId);
                }
                restoredChanged = true;
                currentChanged = true;
                retained.add(component);
                continue;
            }
            if (null == current || !current.contains(component)) continue;
            retained.add(component);
        }
        if (currentChanged |= (current == null ? 0 : current.size()) != retained.size()) {
            if (this.DEBUG) {
                Slog.v(this.TAG, "List of  " + this.getCaption() + " services was updated " + current);
            }
            this.storeComponentsToSetting(retained, setting, userId);
        }
        if (restoredChanged) {
            if (this.DEBUG) {
                Slog.v(this.TAG, "List of  " + this.getCaption() + " restored services was updated " + restored);
            }
            this.storeComponentsToSetting(restored, ManagedServices.restoredSettingName(setting), userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebindServices(boolean forceRebind) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "rebindServices");
        }
        int[] userIds = this.mUserProfiles.getCurrentProfileIds();
        int nUserIds = userIds.length;
        SparseArray<ArraySet<ComponentName>> componentsByUser = new SparseArray<ArraySet<ComponentName>>();
        for (int i = 0; i < nUserIds; ++i) {
            componentsByUser.put(userIds[i], this.loadComponentNamesFromSetting(this.mConfig.secureSettingName, userIds[i]));
            if (this.mConfig.secondarySettingName == null) continue;
            ((ArraySet)componentsByUser.get(userIds[i])).addAll(this.loadComponentNamesFromSetting(this.mConfig.secondarySettingName, userIds[i]));
        }
        ArrayList<ManagedServiceInfo> removableBoundServices = new ArrayList<ManagedServiceInfo>();
        SparseArray toAdd = new SparseArray();
        Iterator iterator = this.mMutex;
        synchronized (iterator) {
            for (ManagedServiceInfo service : this.mServices) {
                if (service.isSystem || service.isGuest(this)) continue;
                removableBoundServices.add(service);
            }
            this.mEnabledServicesForCurrentProfiles.clear();
            this.mEnabledServicesPackageNames.clear();
            for (int i = 0; i < nUserIds; ++i) {
                ArraySet userComponents = (ArraySet)componentsByUser.get(userIds[i]);
                if (null == userComponents) {
                    toAdd.put(userIds[i], new ArraySet());
                    continue;
                }
                HashSet add = new HashSet(userComponents);
                add.removeAll(this.mSnoozingForCurrentProfiles);
                toAdd.put(userIds[i], add);
                this.mEnabledServicesForCurrentProfiles.addAll(userComponents);
                for (int j = 0; j < userComponents.size(); ++j) {
                    ComponentName component = (ComponentName)userComponents.valueAt(j);
                    this.mEnabledServicesPackageNames.add(component.getPackageName());
                }
            }
        }
        for (ManagedServiceInfo info : removableBoundServices) {
            ComponentName component = info.component;
            int oldUser = info.userid;
            Set allowedComponents = (Set)toAdd.get(info.userid);
            if (allowedComponents == null) continue;
            if (allowedComponents.contains(component) && !forceRebind) {
                allowedComponents.remove(component);
                continue;
            }
            Slog.v(this.TAG, "disabling " + this.getCaption() + " for user " + oldUser + ": " + component);
            this.unregisterService(component, oldUser);
        }
        for (int i = 0; i < nUserIds; ++i) {
            Set add = (Set)toAdd.get(userIds[i]);
            for (ComponentName component : add) {
                try {
                    ServiceInfo info = this.mPm.getServiceInfo(component, 786432, userIds[i]);
                    if (info == null || !this.mConfig.bindPermission.equals(info.permission)) {
                        Slog.w(this.TAG, "Skipping " + this.getCaption() + " service " + component + ": it does not require the permission " + this.mConfig.bindPermission);
                        continue;
                    }
                    Slog.v(this.TAG, "enabling " + this.getCaption() + " for " + userIds[i] + ": " + component);
                    this.registerService(component, userIds[i]);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
        }
        this.mLastSeenProfileIds = userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(ComponentName name, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            this.registerServiceLocked(name, userid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSystemService(ComponentName name, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            this.registerServiceLocked(name, userid, true);
        }
    }

    private void registerServiceLocked(ComponentName name, int userid) {
        this.registerServiceLocked(name, userid, false);
    }

    private void registerServiceLocked(ComponentName name, final int userid, final boolean isSystem) {
        String servicesBindingTag;
        if (this.DEBUG) {
            Slog.v(this.TAG, "registerService: " + name + " u=" + userid);
        }
        if (this.mServicesBinding.contains(servicesBindingTag = name.toString() + "/" + userid)) {
            return;
        }
        this.mServicesBinding.add(servicesBindingTag);
        int N = this.mServices.size();
        for (int i = N - 1; i >= 0; --i) {
            ManagedServiceInfo info = this.mServices.get(i);
            if (!name.equals(info.component) || info.userid != userid) continue;
            if (this.DEBUG) {
                Slog.v(this.TAG, "    disconnecting old " + this.getCaption() + ": " + info.service);
            }
            this.removeServiceLocked(i);
            if (info.connection == null) continue;
            this.mContext.unbindService(info.connection);
        }
        Intent intent = new Intent(this.mConfig.serviceInterface);
        intent.setComponent(name);
        intent.putExtra("android.intent.extra.client_label", this.mConfig.clientLabel);
        PendingIntent pendingIntent = PendingIntent.getActivity(this.mContext, 0, new Intent(this.mConfig.settingsAction), 0);
        intent.putExtra("android.intent.extra.client_intent", pendingIntent);
        ApplicationInfo appInfo = null;
        try {
            appInfo = this.mContext.getPackageManager().getApplicationInfo(name.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        final int targetSdkVersion = appInfo != null ? appInfo.targetSdkVersion : 1;
        try {
            ServiceConnection serviceConnection;
            if (this.DEBUG) {
                Slog.v(this.TAG, "binding: " + intent);
            }
            if (!this.mContext.bindServiceAsUser(intent, serviceConnection = new ServiceConnection(){
                IInterface mService;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceConnected(ComponentName name, IBinder binder) {
                    boolean added = false;
                    ManagedServiceInfo info = null;
                    Object object = ManagedServices.this.mMutex;
                    synchronized (object) {
                        ManagedServices.this.mServicesBinding.remove(servicesBindingTag);
                        try {
                            this.mService = ManagedServices.this.asInterface(binder);
                            info = ManagedServices.this.newServiceInfo(this.mService, name, userid, isSystem, this, targetSdkVersion);
                            binder.linkToDeath(info, 0);
                            added = ManagedServices.this.mServices.add(info);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    if (added) {
                        ManagedServices.this.onServiceAdded(info);
                    }
                }

                @Override
                public void onServiceDisconnected(ComponentName name) {
                    Slog.v(ManagedServices.this.TAG, ManagedServices.this.getCaption() + " connection lost: " + name);
                }
            }, 0x5000001, new UserHandle(userid))) {
                this.mServicesBinding.remove(servicesBindingTag);
                Slog.w(this.TAG, "Unable to bind " + this.getCaption() + " service: " + intent);
                return;
            }
        }
        catch (SecurityException ex) {
            Slog.e(this.TAG, "Unable to bind " + this.getCaption() + " service: " + intent, ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterService(ComponentName name, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            this.unregisterServiceLocked(name, userid);
        }
    }

    private void unregisterServiceLocked(ComponentName name, int userid) {
        int N = this.mServices.size();
        for (int i = N - 1; i >= 0; --i) {
            ManagedServiceInfo info = this.mServices.get(i);
            if (!name.equals(info.component) || info.userid != userid) continue;
            this.removeServiceLocked(i);
            if (info.connection == null) continue;
            try {
                this.mContext.unbindService(info.connection);
                continue;
            }
            catch (IllegalArgumentException ex) {
                Slog.e(this.TAG, this.getCaption() + " " + name + " could not be unbound: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedServiceInfo removeServiceImpl(IInterface service, int userid) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "removeServiceImpl service=" + service + " u=" + userid);
        }
        ManagedServiceInfo serviceInfo = null;
        Object object = this.mMutex;
        synchronized (object) {
            int N = this.mServices.size();
            for (int i = N - 1; i >= 0; --i) {
                ManagedServiceInfo info = this.mServices.get(i);
                if (info.service.asBinder() != service.asBinder() || info.userid != userid) continue;
                if (this.DEBUG) {
                    Slog.d(this.TAG, "Removing active service " + info.component);
                }
                serviceInfo = this.removeServiceLocked(i);
            }
        }
        return serviceInfo;
    }

    private ManagedServiceInfo removeServiceLocked(int i) {
        ManagedServiceInfo info = this.mServices.remove(i);
        this.onServiceRemovedLocked(info);
        return info;
    }

    private void checkNotNull(IInterface service) {
        if (service == null) {
            throw new IllegalArgumentException(this.getCaption() + " must not be null");
        }
    }

    private ManagedServiceInfo registerServiceImpl(IInterface service, ComponentName component, int userid) {
        ManagedServiceInfo info = this.newServiceInfo(service, component, userid, true, null, 21);
        return this.registerServiceImpl(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedServiceInfo registerServiceImpl(ManagedServiceInfo info) {
        Object object = this.mMutex;
        synchronized (object) {
            try {
                info.service.asBinder().linkToDeath(info, 0);
                this.mServices.add(info);
                return info;
            }
            catch (RemoteException remoteException) {
            }
        }
        return null;
    }

    private void unregisterServiceImpl(IInterface service, int userid) {
        ManagedServiceInfo info = this.removeServiceImpl(service, userid);
        if (info != null && info.connection != null && !info.isGuest(this)) {
            this.mContext.unbindService(info.connection);
        }
    }

    public boolean isComponentEnabledForCurrentProfiles(ComponentName component) {
        return this.mEnabledServicesForCurrentProfiles.contains(component);
    }

    public static class Config {
        public String caption;
        public String serviceInterface;
        public String secureSettingName;
        public String secondarySettingName;
        public String bindPermission;
        public String settingsAction;
        public int clientLabel;
    }

    public static class UserProfiles {
        private final SparseArray<UserInfo> mCurrentProfiles = new SparseArray();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCache(Context context) {
            UserManager userManager = (UserManager)context.getSystemService("user");
            if (userManager != null) {
                int currentUserId = ActivityManager.getCurrentUser();
                List<UserInfo> profiles = userManager.getProfiles(currentUserId);
                SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
                synchronized (sparseArray) {
                    this.mCurrentProfiles.clear();
                    for (UserInfo user : profiles) {
                        this.mCurrentProfiles.put(user.id, user);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getCurrentProfileIds() {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                int[] users = new int[this.mCurrentProfiles.size()];
                int N = this.mCurrentProfiles.size();
                for (int i = 0; i < N; ++i) {
                    users[i] = this.mCurrentProfiles.keyAt(i);
                }
                return users;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCurrentProfile(int userId) {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                return this.mCurrentProfiles.get(userId) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isManagedProfile(int userId) {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                UserInfo user = this.mCurrentProfiles.get(userId);
                return user != null && user.isManagedProfile();
            }
        }
    }

    public class ManagedServiceInfo
    implements IBinder.DeathRecipient {
        public IInterface service;
        public ComponentName component;
        public int userid;
        public boolean isSystem;
        public ServiceConnection connection;
        public int targetSdkVersion;

        public ManagedServiceInfo(IInterface service, ComponentName component, int userid, boolean isSystem, ServiceConnection connection, int targetSdkVersion) {
            this.service = service;
            this.component = component;
            this.userid = userid;
            this.isSystem = isSystem;
            this.connection = connection;
            this.targetSdkVersion = targetSdkVersion;
        }

        public boolean isGuest(ManagedServices host) {
            return ManagedServices.this != host;
        }

        public ManagedServices getOwner() {
            return ManagedServices.this;
        }

        public String toString() {
            return "ManagedServiceInfo[" + "component=" + this.component + ",userid=" + this.userid + ",isSystem=" + this.isSystem + ",targetSdkVersion=" + this.targetSdkVersion + ",connection=" + (this.connection == null ? null : "<connection>") + ",service=" + this.service + ']';
        }

        public boolean enabledAndUserMatches(int nid) {
            if (!this.isEnabledForCurrentProfiles()) {
                return false;
            }
            if (this.userid == -1) {
                return true;
            }
            if (this.isSystem) {
                return true;
            }
            if (nid == -1 || nid == this.userid) {
                return true;
            }
            return this.supportsProfiles() && ManagedServices.this.mUserProfiles.isCurrentProfile(nid) && this.isPermittedForProfile(nid);
        }

        public boolean supportsProfiles() {
            return this.targetSdkVersion >= 21;
        }

        @Override
        public void binderDied() {
            if (ManagedServices.this.DEBUG) {
                Slog.d(ManagedServices.this.TAG, "binderDied");
            }
            ManagedServices.this.removeServiceImpl(this.service, this.userid);
        }

        public boolean isEnabledForCurrentProfiles() {
            if (this.isSystem) {
                return true;
            }
            if (this.connection == null) {
                return false;
            }
            return ManagedServices.this.mEnabledServicesForCurrentProfiles.contains(this.component);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPermittedForProfile(int userId) {
            if (!ManagedServices.this.mUserProfiles.isManagedProfile(userId)) {
                return true;
            }
            DevicePolicyManager dpm = (DevicePolicyManager)ManagedServices.this.mContext.getSystemService("device_policy");
            long identity = Binder.clearCallingIdentity();
            try {
                boolean bl = dpm.isNotificationListenerServicePermitted(this.component.getPackageName(), userId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        private final Uri mSecureSettingsUri;
        private final Uri mSecondarySettingsUri;

        private SettingsObserver(Handler handler) {
            super(handler);
            this.mSecureSettingsUri = Settings.Secure.getUriFor(((ManagedServices)ManagedServices.this).mConfig.secureSettingName);
            this.mSecondarySettingsUri = ((ManagedServices)ManagedServices.this).mConfig.secondarySettingName != null ? Settings.Secure.getUriFor(((ManagedServices)ManagedServices.this).mConfig.secondarySettingName) : null;
        }

        private void observe() {
            ContentResolver resolver = ManagedServices.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.mSecureSettingsUri, false, this, -1);
            if (this.mSecondarySettingsUri != null) {
                resolver.registerContentObserver(this.mSecondarySettingsUri, false, this, -1);
            }
            this.update(null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.update(uri);
        }

        private void update(Uri uri) {
            if (uri == null || this.mSecureSettingsUri.equals(uri) || uri.equals(this.mSecondarySettingsUri)) {
                if (ManagedServices.this.DEBUG) {
                    Slog.d(ManagedServices.this.TAG, "Setting changed: uri=" + uri);
                }
                ManagedServices.this.rebindServices(false);
                ManagedServices.this.rebuildRestoredPackages();
            }
        }
    }

    class SettingRestoredReceiver
    extends BroadcastReceiver {
        SettingRestoredReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String element;
            if ("android.os.action.SETTING_RESTORED".equals(intent.getAction()) && (Objects.equals(element = intent.getStringExtra("setting_name"), ((ManagedServices)ManagedServices.this).mConfig.secureSettingName) || Objects.equals(element, ((ManagedServices)ManagedServices.this).mConfig.secondarySettingName))) {
                String prevValue = intent.getStringExtra("previous_value");
                String newValue = intent.getStringExtra("new_value");
                ManagedServices.this.settingRestored(element, prevValue, newValue, this.getSendingUserId());
            }
        }
    }
}

