/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Intent;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.content.SyncOperation;

public class SyncJobService
extends JobService {
    private static final String TAG = "SyncManager";
    public static final String EXTRA_MESSENGER = "messenger";
    private Messenger mMessenger;
    private SparseArray<JobParameters> jobParamsMap = new SparseArray();

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        this.mMessenger = (Messenger)intent.getParcelableExtra(EXTRA_MESSENGER);
        Message m = Message.obtain();
        m.what = 7;
        m.obj = this;
        this.sendMessage(m);
        return 2;
    }

    private void sendMessage(Message message) {
        if (this.mMessenger == null) {
            Slog.e(TAG, "Messenger not initialized.");
            return;
        }
        try {
            this.mMessenger.send(message);
        }
        catch (RemoteException e) {
            Slog.e(TAG, e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStartJob(JobParameters params) {
        boolean isLoggable = Log.isLoggable(TAG, 2);
        SparseArray<JobParameters> sparseArray = this.jobParamsMap;
        synchronized (sparseArray) {
            this.jobParamsMap.put(params.getJobId(), params);
        }
        Message m = Message.obtain();
        m.what = 10;
        SyncOperation op = SyncOperation.maybeCreateFromJobExtras(params.getExtras());
        if (op == null) {
            Slog.e(TAG, "Got invalid job " + params.getJobId());
            return false;
        }
        if (isLoggable) {
            Slog.v(TAG, "Got start job message " + op.target);
        }
        m.obj = op;
        this.sendMessage(m);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStopJob(JobParameters params) {
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "onStopJob called " + params.getJobId() + ", reason: " + params.getStopReason());
        }
        SparseArray<JobParameters> sparseArray = this.jobParamsMap;
        synchronized (sparseArray) {
            this.jobParamsMap.remove(params.getJobId());
        }
        Message m = Message.obtain();
        m.what = 11;
        m.obj = SyncOperation.maybeCreateFromJobExtras(params.getExtras());
        if (m.obj == null) {
            return false;
        }
        m.arg1 = params.getStopReason() != 0 ? 1 : 0;
        m.arg2 = params.getStopReason() == 3 ? 1 : 0;
        this.sendMessage(m);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callJobFinished(int jobId, boolean needsReschedule) {
        SparseArray<JobParameters> sparseArray = this.jobParamsMap;
        synchronized (sparseArray) {
            JobParameters params = this.jobParamsMap.get(jobId);
            if (params != null) {
                this.jobFinished(params, needsReschedule);
                this.jobParamsMap.remove(jobId);
            } else {
                Slog.e(TAG, "Job params not found for " + String.valueOf(jobId));
            }
        }
    }
}

