/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.content.Context;
import android.net.ConnectivityManager;
import android.telephony.TelephonyManager;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringJoiner;

public class TetheringConfiguration {
    private static final String TAG = TetheringConfiguration.class.getSimpleName();
    public static final int DUN_NOT_REQUIRED = 0;
    public static final int DUN_REQUIRED = 1;
    public static final int DUN_UNSPECIFIED = 2;
    private static final String[] DHCP_DEFAULT_RANGE = new String[]{"192.168.42.2", "192.168.42.254", "192.168.43.2", "192.168.43.254", "192.168.44.2", "192.168.44.254", "192.168.45.2", "192.168.45.254", "192.168.46.2", "192.168.46.254", "192.168.47.2", "192.168.47.254", "192.168.48.2", "192.168.48.254", "192.168.49.2", "192.168.49.254"};
    private final String[] DEFAULT_IPV4_DNS = new String[]{"8.8.4.4", "8.8.8.8"};
    public final String[] tetherableUsbRegexs;
    public final String[] tetherableWifiRegexs;
    public final String[] tetherableBluetoothRegexs;
    public final boolean isDunRequired;
    public final Collection<Integer> preferredUpstreamIfaceTypes;
    public final String[] dhcpRanges;
    public final String[] defaultIPv4DNS;

    public TetheringConfiguration(Context ctx) {
        this.tetherableUsbRegexs = ctx.getResources().getStringArray(17236037);
        this.tetherableWifiRegexs = ctx.getResources().getStringArray(17236038);
        this.tetherableBluetoothRegexs = ctx.getResources().getStringArray(17236034);
        int dunCheck = TetheringConfiguration.checkDunRequired(ctx);
        this.preferredUpstreamIfaceTypes = TetheringConfiguration.getUpstreamIfaceTypes(ctx, dunCheck);
        this.isDunRequired = this.preferredUpstreamIfaceTypes.contains(4);
        this.dhcpRanges = TetheringConfiguration.getDhcpRanges(ctx);
        this.defaultIPv4DNS = TetheringConfiguration.copy(this.DEFAULT_IPV4_DNS);
    }

    public boolean isUsb(String iface) {
        return TetheringConfiguration.matchesDownstreamRegexs(iface, this.tetherableUsbRegexs);
    }

    public boolean isWifi(String iface) {
        return TetheringConfiguration.matchesDownstreamRegexs(iface, this.tetherableWifiRegexs);
    }

    public boolean isBluetooth(String iface) {
        return TetheringConfiguration.matchesDownstreamRegexs(iface, this.tetherableBluetoothRegexs);
    }

    public void dump(PrintWriter pw) {
        TetheringConfiguration.dumpStringArray(pw, "tetherableUsbRegexs", this.tetherableUsbRegexs);
        TetheringConfiguration.dumpStringArray(pw, "tetherableWifiRegexs", this.tetherableWifiRegexs);
        TetheringConfiguration.dumpStringArray(pw, "tetherableBluetoothRegexs", this.tetherableBluetoothRegexs);
        pw.print("isDunRequired: ");
        pw.println(this.isDunRequired);
        String[] upstreamTypes = null;
        if (this.preferredUpstreamIfaceTypes != null) {
            upstreamTypes = new String[this.preferredUpstreamIfaceTypes.size()];
            int i = 0;
            for (Integer netType : this.preferredUpstreamIfaceTypes) {
                upstreamTypes[i] = ConnectivityManager.getNetworkTypeName(netType);
                ++i;
            }
        }
        TetheringConfiguration.dumpStringArray(pw, "preferredUpstreamIfaceTypes", upstreamTypes);
        TetheringConfiguration.dumpStringArray(pw, "dhcpRanges", this.dhcpRanges);
        TetheringConfiguration.dumpStringArray(pw, "defaultIPv4DNS", this.defaultIPv4DNS);
    }

    private static void dumpStringArray(PrintWriter pw, String label, String[] values) {
        pw.print(label);
        pw.print(": ");
        if (values != null) {
            StringJoiner sj = new StringJoiner(", ", "[", "]");
            for (String value : values) {
                sj.add(value);
            }
            pw.print(sj.toString());
        } else {
            pw.print("null");
        }
        pw.println();
    }

    private static int checkDunRequired(Context ctx) {
        TelephonyManager tm = (TelephonyManager)ctx.getSystemService("phone");
        return tm != null ? tm.getTetherApnRequired() : 2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Collection<Integer> getUpstreamIfaceTypes(Context ctx, int dunCheck) {
        int[] ifaceTypes = ctx.getResources().getIntArray(17236036);
        ArrayList<Integer> upstreamIfaceTypes = new ArrayList<Integer>(ifaceTypes.length);
        block4: for (int i : ifaceTypes) {
            switch (i) {
                case 0: 
                case 5: {
                    if (dunCheck != 1) break;
                    continue block4;
                }
                case 4: {
                    if (dunCheck == 0) continue block4;
                }
            }
            upstreamIfaceTypes.add(i);
        }
        if (dunCheck == 1) {
            if (upstreamIfaceTypes.contains(4)) return upstreamIfaceTypes;
            upstreamIfaceTypes.add(4);
            return upstreamIfaceTypes;
        }
        if (dunCheck != 0) {
            if (upstreamIfaceTypes.contains(4)) return upstreamIfaceTypes;
            if (upstreamIfaceTypes.contains(0)) return upstreamIfaceTypes;
            if (upstreamIfaceTypes.contains(5)) return upstreamIfaceTypes;
            upstreamIfaceTypes.add(0);
            upstreamIfaceTypes.add(5);
            return upstreamIfaceTypes;
        }
        if (!upstreamIfaceTypes.contains(0)) {
            upstreamIfaceTypes.add(0);
        }
        if (upstreamIfaceTypes.contains(5)) return upstreamIfaceTypes;
        upstreamIfaceTypes.add(5);
        return upstreamIfaceTypes;
    }

    private static boolean matchesDownstreamRegexs(String iface, String[] regexs) {
        for (String regex : regexs) {
            if (!iface.matches(regex)) continue;
            return true;
        }
        return false;
    }

    private static String[] getDhcpRanges(Context ctx) {
        String[] fromResource = ctx.getResources().getStringArray(17236035);
        if (fromResource.length > 0 && fromResource.length % 2 == 0) {
            return fromResource;
        }
        return TetheringConfiguration.copy(DHCP_DEFAULT_RANGE);
    }

    private static String[] copy(String[] strarray) {
        return Arrays.copyOf(strarray, strarray.length);
    }
}

