/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.net.ConnectivityMetricsEvent;
import android.net.IIpConnectivityMetrics;
import android.net.INetdEventCallback;
import android.net.metrics.ApfProgramEvent;
import android.os.Binder;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.TokenBucket;
import com.android.server.SystemService;
import com.android.server.connectivity.IpConnectivityEventBuilder;
import com.android.server.connectivity.NetdEventListenerService;
import com.android.server.connectivity.metrics.nano.IpConnectivityLogClass;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.ToIntFunction;

public final class IpConnectivityMetrics
extends SystemService {
    private static final String TAG = IpConnectivityMetrics.class.getSimpleName();
    private static final boolean DBG = false;
    private static final int NYC = 0;
    private static final int NYC_MR1 = 1;
    private static final int NYC_MR2 = 2;
    public static final int VERSION = 2;
    private static final String SERVICE_NAME = "connmetrics";
    private static final int DEFAULT_BUFFER_SIZE = 2000;
    private static final int MAXIMUM_BUFFER_SIZE = 20000;
    private static final int MAXIMUM_CONNECT_LATENCY_RECORDS = 20000;
    private static final int ERROR_RATE_LIMITED = -1;
    private final Object mLock = new Object();
    public final Impl impl = new Impl();
    NetdEventListenerService mNetdListener;
    @GuardedBy(value="mLock")
    private ArrayList<ConnectivityMetricsEvent> mBuffer;
    @GuardedBy(value="mLock")
    private int mDropped;
    @GuardedBy(value="mLock")
    private int mCapacity;
    @GuardedBy(value="mLock")
    private final ArrayMap<Class<?>, TokenBucket> mBuckets = IpConnectivityMetrics.makeRateLimitingBuckets();
    private final ToIntFunction<Context> mCapacityGetter;
    private static final ToIntFunction<Context> READ_BUFFER_SIZE = ctx -> {
        int size = Settings.Global.getInt(ctx.getContentResolver(), "connectivity_metrics_buffer_size", 2000);
        if (size <= 0) {
            return 2000;
        }
        return Math.min(size, 20000);
    };

    public IpConnectivityMetrics(Context ctx, ToIntFunction<Context> capacityGetter) {
        super(ctx);
        this.mCapacityGetter = capacityGetter;
        this.initBuffer();
    }

    public IpConnectivityMetrics(Context ctx) {
        this(ctx, READ_BUFFER_SIZE);
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.mNetdListener = new NetdEventListenerService(this.getContext());
            this.publishBinderService(SERVICE_NAME, this.impl);
            this.publishBinderService("netd_listener", this.mNetdListener);
        }
    }

    public int bufferCapacity() {
        return this.mCapacityGetter.applyAsInt(this.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBuffer() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDropped = 0;
            this.mCapacity = this.bufferCapacity();
            this.mBuffer = new ArrayList(this.mCapacity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int append(ConnectivityMetricsEvent event) {
        Object object = this.mLock;
        synchronized (object) {
            int left = this.mCapacity - this.mBuffer.size();
            if (event == null) {
                return left;
            }
            if (this.isRateLimited(event)) {
                return -1;
            }
            if (left == 0) {
                ++this.mDropped;
                return 0;
            }
            this.mBuffer.add(event);
            return left - 1;
        }
    }

    private boolean isRateLimited(ConnectivityMetricsEvent event) {
        TokenBucket tb = this.mBuckets.get(event.data.getClass());
        return tb != null && !tb.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String flushEncodedOutput() {
        byte[] data;
        int dropped;
        ArrayList<ConnectivityMetricsEvent> events;
        Object object = this.mLock;
        synchronized (object) {
            events = this.mBuffer;
            dropped = this.mDropped;
            this.initBuffer();
        }
        List<IpConnectivityLogClass.IpConnectivityEvent> protoEvents = IpConnectivityEventBuilder.toProto(events);
        if (this.mNetdListener != null) {
            this.mNetdListener.flushStatistics(protoEvents);
        }
        try {
            data = IpConnectivityEventBuilder.serialize(dropped, protoEvents);
        }
        catch (IOException e) {
            Log.e(TAG, "could not serialize events", e);
            return "";
        }
        return Base64.encodeToString(data, 0);
    }

    private void cmdFlush(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.print(this.flushEncodedOutput());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmdList(FileDescriptor fd, PrintWriter pw, String[] args) {
        ArrayList<ConnectivityMetricsEvent> events;
        Iterator<Object> iterator = this.mLock;
        synchronized (iterator) {
            events = new ArrayList<ConnectivityMetricsEvent>(this.mBuffer);
        }
        if (args.length > 1 && args[1].equals("proto")) {
            for (IpConnectivityLogClass.IpConnectivityEvent ev : IpConnectivityEventBuilder.toProto(events)) {
                pw.print(ev.toString());
            }
            if (this.mNetdListener != null) {
                this.mNetdListener.listAsProtos(pw);
            }
            return;
        }
        for (ConnectivityMetricsEvent ev : events) {
            pw.println(ev.toString());
        }
        if (this.mNetdListener != null) {
            this.mNetdListener.list(pw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmdStats(FileDescriptor fd, PrintWriter pw, String[] args) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Buffered events: " + this.mBuffer.size());
            pw.println("Buffer capacity: " + this.mCapacity);
            pw.println("Dropped events: " + this.mDropped);
        }
        if (this.mNetdListener != null) {
            this.mNetdListener.dump(pw);
        }
    }

    private void cmdDefault(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (args.length == 0) {
            pw.println("No command");
            return;
        }
        pw.println("Unknown command " + TextUtils.join((CharSequence)" ", args));
    }

    private static ArrayMap<Class<?>, TokenBucket> makeRateLimitingBuckets() {
        ArrayMap map = new ArrayMap();
        map.put(ApfProgramEvent.class, new TokenBucket(60000, 50));
        return map;
    }

    public final class Impl
    extends IIpConnectivityMetrics.Stub {
        static final String CMD_FLUSH = "flush";
        static final String CMD_LIST = "list";
        static final String CMD_STATS = "stats";
        static final String CMD_DUMPSYS = "-a";
        static final String CMD_DEFAULT = "stats";

        @Override
        public int logEvent(ConnectivityMetricsEvent event) {
            this.enforceConnectivityInternalPermission();
            return IpConnectivityMetrics.this.append(event);
        }

        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            String cmd;
            this.enforceDumpPermission();
            switch (cmd = args.length > 0 ? args[0] : "stats") {
                case "flush": {
                    IpConnectivityMetrics.this.cmdFlush(fd, pw, args);
                    return;
                }
                case "-a": 
                case "list": {
                    IpConnectivityMetrics.this.cmdList(fd, pw, args);
                    return;
                }
                case "stats": {
                    IpConnectivityMetrics.this.cmdStats(fd, pw, args);
                    return;
                }
            }
            IpConnectivityMetrics.this.cmdDefault(fd, pw, args);
        }

        private void enforceConnectivityInternalPermission() {
            this.enforcePermission("android.permission.CONNECTIVITY_INTERNAL");
        }

        private void enforceDumpPermission() {
            this.enforcePermission("android.permission.DUMP");
        }

        private void enforcePermission(String what) {
            IpConnectivityMetrics.this.getContext().enforceCallingOrSelfPermission(what, "IpConnectivityMetrics");
        }

        private void enforceNetdEventListeningPermission() {
            int uid = Binder.getCallingUid();
            if (uid != 1000) {
                throw new SecurityException(String.format("Uid %d has no permission to listen for netd events.", uid));
            }
        }

        @Override
        public boolean registerNetdEventCallback(INetdEventCallback callback) {
            this.enforceNetdEventListeningPermission();
            if (IpConnectivityMetrics.this.mNetdListener == null) {
                return false;
            }
            return IpConnectivityMetrics.this.mNetdListener.registerNetdEventCallback(callback);
        }

        @Override
        public boolean unregisterNetdEventCallback() {
            this.enforceNetdEventListeningPermission();
            if (IpConnectivityMetrics.this.mNetdListener == null) {
                return true;
            }
            return IpConnectivityMetrics.this.mNetdListener.unregisterNetdEventCallback();
        }
    }
}

