/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.content.Context;
import android.media.AudioSystem;
import android.os.Handler;
import android.util.Log;
import android.view.OrientationEventListener;
import android.view.WindowManager;
import com.android.server.policy.WindowOrientationListener;

class RotationHelper {
    private static final String TAG = "AudioService.RotationHelper";
    private static AudioOrientationListener sOrientationListener;
    private static AudioWindowOrientationListener sWindowOrientationListener;
    private static final Object sRotationLock;
    private static int sDeviceRotation;
    private static Context sContext;

    RotationHelper() {
    }

    static void init(Context context, Handler handler) {
        if (context == null) {
            throw new IllegalArgumentException("Invalid null context");
        }
        sContext = context;
        sWindowOrientationListener = new AudioWindowOrientationListener(context, handler);
        sWindowOrientationListener.enable();
        if (!sWindowOrientationListener.canDetectOrientation()) {
            Log.i(TAG, "Not using WindowOrientationListener, reverting to OrientationListener");
            sWindowOrientationListener.disable();
            sWindowOrientationListener = null;
            sOrientationListener = new AudioOrientationListener(context);
            sOrientationListener.enable();
        }
    }

    static void enable() {
        if (sWindowOrientationListener != null) {
            sWindowOrientationListener.enable();
        } else {
            sOrientationListener.enable();
        }
        RotationHelper.updateOrientation();
    }

    static void disable() {
        if (sWindowOrientationListener != null) {
            sWindowOrientationListener.disable();
        } else {
            sOrientationListener.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateOrientation() {
        int newRotation = ((WindowManager)sContext.getSystemService("window")).getDefaultDisplay().getRotation();
        Object object = sRotationLock;
        synchronized (object) {
            if (newRotation != sDeviceRotation) {
                sDeviceRotation = newRotation;
                RotationHelper.publishRotation(sDeviceRotation);
            }
        }
    }

    private static void publishRotation(int rotation) {
        Log.v(TAG, "publishing device rotation =" + rotation + " (x90deg)");
        switch (rotation) {
            case 0: {
                AudioSystem.setParameters("rotation=0");
                break;
            }
            case 1: {
                AudioSystem.setParameters("rotation=90");
                break;
            }
            case 2: {
                AudioSystem.setParameters("rotation=180");
                break;
            }
            case 3: {
                AudioSystem.setParameters("rotation=270");
                break;
            }
            default: {
                Log.e(TAG, "Unknown device rotation");
            }
        }
    }

    static {
        sRotationLock = new Object();
        sDeviceRotation = 0;
    }

    static final class RotationCheckThread
    extends Thread {
        private final int[] WAIT_TIMES_MS = new int[]{10, 20, 50, 100, 100, 200, 200, 500};
        private int mWaitCounter;
        private final Object mCounterLock = new Object();

        RotationCheckThread() {
            super("RotationCheck");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void beginCheck() {
            Object object = this.mCounterLock;
            synchronized (object) {
                this.mWaitCounter = 0;
            }
            try {
                this.start();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endCheck() {
            Object object = this.mCounterLock;
            synchronized (object) {
                this.mWaitCounter = this.WAIT_TIMES_MS.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.mWaitCounter < this.WAIT_TIMES_MS.length) {
                int waitTimeMs;
                Object object = this.mCounterLock;
                synchronized (object) {
                    waitTimeMs = this.mWaitCounter < this.WAIT_TIMES_MS.length ? this.WAIT_TIMES_MS[this.mWaitCounter] : 0;
                    ++this.mWaitCounter;
                }
                try {
                    if (waitTimeMs <= 0) continue;
                    RotationCheckThread.sleep(waitTimeMs);
                    RotationHelper.updateOrientation();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    static final class AudioWindowOrientationListener
    extends WindowOrientationListener {
        private static RotationCheckThread sRotationCheckThread;

        AudioWindowOrientationListener(Context context, Handler handler) {
            super(context, handler);
        }

        @Override
        public void onProposedRotationChanged(int rotation) {
            RotationHelper.updateOrientation();
            if (sRotationCheckThread != null) {
                sRotationCheckThread.endCheck();
            }
            sRotationCheckThread = new RotationCheckThread();
            sRotationCheckThread.beginCheck();
        }
    }

    static final class AudioOrientationListener
    extends OrientationEventListener {
        AudioOrientationListener(Context context) {
            super(context);
        }

        @Override
        public void onOrientationChanged(int orientation) {
            RotationHelper.updateOrientation();
        }
    }
}

