/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.content.Intent;
import android.hardware.GeomagneticField;
import android.hardware.Sensor;
import android.hardware.SensorAdditionalInfo;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Slog;
import com.android.server.LocalServices;
import com.android.server.SystemService;

public class SensorNotificationService
extends SystemService
implements SensorEventListener,
LocationListener {
    private static final boolean DBG = false;
    private static final String TAG = "SensorNotificationService";
    private static final long MINUTE_IN_MS = 60000L;
    private static final long KM_IN_M = 1000L;
    private static final long LOCATION_MIN_TIME = 1800000L;
    private static final long LOCATION_MIN_DISTANCE = 100000L;
    private static final String PROPERTY_USE_MOCKED_LOCATION = "sensor.notification.use_mocked";
    private static final long MILLIS_2010_1_1 = 1262358000000L;
    private Context mContext;
    private SensorManager mSensorManager;
    private LocationManager mLocationManager;
    private Sensor mMetaSensor;
    private long mLocalGeomagneticFieldUpdateTime = -1800000L;

    public SensorNotificationService(Context context) {
        super(context);
        this.mContext = context;
    }

    @Override
    public void onStart() {
        LocalServices.addService(SensorNotificationService.class, this);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 600) {
            this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
            this.mMetaSensor = this.mSensorManager.getDefaultSensor(32);
            if (this.mMetaSensor != null) {
                this.mSensorManager.registerListener(this, this.mMetaSensor, 0);
            }
        }
        if (phase == 1000) {
            this.mLocationManager = (LocationManager)this.mContext.getSystemService("location");
            if (this.mLocationManager != null) {
                this.mLocationManager.requestLocationUpdates("passive", 1800000L, 100000.0f, this);
            }
        }
    }

    private void broadcastDynamicSensorChanged() {
        Intent i = new Intent("android.intent.action.DYNAMIC_SENSOR_CHANGED");
        i.setFlags(0x40000000);
        this.mContext.sendBroadcastAsUser(i, UserHandle.ALL);
    }

    @Override
    public void onSensorChanged(SensorEvent event) {
        if (event.sensor == this.mMetaSensor) {
            this.broadcastDynamicSensorChanged();
        }
    }

    @Override
    public void onLocationChanged(Location location) {
        if (location.getLatitude() == 0.0 && location.getLongitude() == 0.0) {
            return;
        }
        if (SystemClock.elapsedRealtime() - this.mLocalGeomagneticFieldUpdateTime < 600000L) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.useMockedLocation() == location.isFromMockProvider() || time < 1262358000000L) {
            return;
        }
        GeomagneticField field = new GeomagneticField((float)location.getLatitude(), (float)location.getLongitude(), (float)location.getAltitude(), time);
        try {
            SensorAdditionalInfo info = SensorAdditionalInfo.createLocalGeomagneticField(field.getFieldStrength() / 1000.0f, (float)((double)field.getDeclination() * Math.PI / 180.0), (float)((double)field.getInclination() * Math.PI / 180.0));
            if (info != null) {
                this.mSensorManager.setOperationParameter(info);
                this.mLocalGeomagneticFieldUpdateTime = SystemClock.elapsedRealtime();
            }
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "Invalid local geomagnetic field, ignore.");
        }
    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    @Override
    public void onProviderEnabled(String provider) {
    }

    @Override
    public void onProviderDisabled(String provider) {
    }

    private boolean useMockedLocation() {
        return "false".equals(System.getProperty(PROPERTY_USE_MOCKED_LOCATION, "false"));
    }
}

