/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.net.IIpSecService;
import android.net.INetd;
import android.net.IpSecAlgorithm;
import android.net.IpSecConfig;
import android.net.util.NetdService;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;

public class IpSecService
extends IIpSecService.Stub {
    private static final String TAG = "IpSecService";
    private static final boolean DBG = Log.isLoggable("IpSecService", 3);
    private static final String NETD_SERVICE_NAME = "netd";
    private static final int[] DIRECTIONS = new int[]{1, 0};
    private final Context mContext;
    private Object mLock = new Object();
    private static final int NETD_FETCH_TIMEOUT = 5000;
    private AtomicInteger mNextResourceId = new AtomicInteger(16441040);
    @GuardedBy(value="mSpiRecords")
    private final SparseArray<SpiRecord> mSpiRecords = new SparseArray();
    @GuardedBy(value="mTransformRecords")
    private final SparseArray<TransformRecord> mTransformRecords = new SparseArray();

    private IpSecService(Context context) {
        this.mContext = context;
    }

    static IpSecService create(Context context) throws InterruptedException {
        IpSecService service = new IpSecService(context);
        service.connectNativeNetdService();
        return service;
    }

    public void systemReady() {
        if (this.isNetdAlive()) {
            Slog.d(TAG, "IpSecService is ready");
        } else {
            Slog.wtf(TAG, "IpSecService not ready: failed to connect to NetD Native Service!");
        }
    }

    private void connectNativeNetdService() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = IpSecService.this.mLock;
                synchronized (object) {
                    NetdService.get(5000L);
                }
            }
        });
        t.run();
    }

    INetd getNetdInstance() throws RemoteException {
        INetd netd = NetdService.getInstance();
        if (netd == null) {
            throw new RemoteException("Failed to Get Netd Instance");
        }
        return netd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNetdAlive() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                INetd netd = this.getNetdInstance();
                if (netd == null) {
                    return false;
                }
                return netd.isAlive();
            }
            catch (RemoteException re) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle reserveSecurityParameterIndex(int direction, String remoteAddress, int requestedSpi, IBinder binder) throws RemoteException {
        int resourceId = this.mNextResourceId.getAndIncrement();
        int spi = 0;
        String localAddress = "";
        Bundle retBundle = new Bundle(3);
        try {
            spi = this.getNetdInstance().ipSecAllocateSpi(resourceId, direction, localAddress, remoteAddress, requestedSpi);
            Log.d(TAG, "Allocated SPI " + spi);
            retBundle.putInt("status", 0);
            retBundle.putInt("resourceId", resourceId);
            retBundle.putInt("spi", spi);
            SparseArray<SpiRecord> sparseArray = this.mSpiRecords;
            synchronized (sparseArray) {
                this.mSpiRecords.put(resourceId, new SpiRecord(resourceId, direction, localAddress, remoteAddress, spi, binder));
            }
        }
        catch (ServiceSpecificException e) {
            retBundle.putInt("status", 2);
            retBundle.putInt("resourceId", resourceId);
            retBundle.putInt("spi", spi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return retBundle;
    }

    @Override
    public void releaseSecurityParameterIndex(int resourceId) throws RemoteException {
    }

    @Override
    public Bundle openUdpEncapsulationSocket(int port, IBinder binder) throws RemoteException {
        return null;
    }

    @Override
    public void closeUdpEncapsulationSocket(ParcelFileDescriptor socket) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle createTransportModeTransform(IpSecConfig c, IBinder binder) throws RemoteException {
        int resourceId = this.mNextResourceId.getAndIncrement();
        for (int direction : DIRECTIONS) {
            IpSecAlgorithm auth = c.getAuthentication(direction);
            IpSecAlgorithm crypt = c.getEncryption(direction);
            try {
                int result = this.getNetdInstance().ipSecAddSecurityAssociation(resourceId, c.getMode(), direction, c.getLocalAddress() != null ? c.getLocalAddress().getHostAddress() : "", c.getRemoteAddress() != null ? c.getRemoteAddress().getHostAddress() : "", c.getNetwork() != null ? c.getNetwork().getNetworkHandle() : 0L, c.getSpi(direction), auth != null ? auth.getName() : "", auth != null ? auth.getKey() : null, auth != null ? auth.getTruncationLengthBits() : 0, crypt != null ? crypt.getName() : "", crypt != null ? crypt.getKey() : null, crypt != null ? crypt.getTruncationLengthBits() : 0, c.getEncapType(), c.getEncapLocalPort(), c.getEncapRemotePort());
                if (result == c.getSpi(direction)) continue;
                Bundle retBundle = new Bundle(2);
                retBundle.putInt("status", 2);
                retBundle.putInt("resourceId", 0);
                return retBundle;
            }
            catch (ServiceSpecificException serviceSpecificException) {
                // empty catch block
            }
        }
        SparseArray<TransformRecord> sparseArray = this.mTransformRecords;
        synchronized (sparseArray) {
            this.mTransformRecords.put(resourceId, new TransformRecord(c, resourceId, binder));
        }
        Bundle bundle = new Bundle(2);
        bundle.putInt("status", 0);
        bundle.putInt("resourceId", resourceId);
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTransportModeTransform(int resourceId) throws RemoteException {
        SparseArray<TransformRecord> sparseArray = this.mTransformRecords;
        synchronized (sparseArray) {
            TransformRecord record = this.mTransformRecords.get(resourceId);
            if (record == null) {
                throw new IllegalArgumentException("Transform " + resourceId + " is not available to be deleted");
            }
            if (record.pid != Binder.getCallingPid() || record.uid != Binder.getCallingUid()) {
                throw new SecurityException("Only the owner of an IpSec Transform may delete it!");
            }
            record.releaseResources();
            this.mTransformRecords.remove(resourceId);
            record.nullifyRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTransportModeTransform(ParcelFileDescriptor socket, int resourceId) throws RemoteException {
        SparseArray<TransformRecord> sparseArray = this.mTransformRecords;
        synchronized (sparseArray) {
            TransformRecord info = this.mTransformRecords.get(resourceId);
            if (info == null) {
                throw new IllegalArgumentException("Transform " + resourceId + " is not active");
            }
            if (info.pid != IpSecService.getCallingPid() || info.uid != IpSecService.getCallingUid()) {
                throw new SecurityException("Only the owner of an IpSec Transform may apply it!");
            }
            IpSecConfig c = info.getConfig();
            try {
                for (int direction : DIRECTIONS) {
                    this.getNetdInstance().ipSecApplyTransportModeTransform(socket.getFileDescriptor(), resourceId, direction, c.getLocalAddress() != null ? c.getLocalAddress().getHostAddress() : "", c.getRemoteAddress() != null ? c.getRemoteAddress().getHostAddress() : "", c.getSpi(direction));
                }
            }
            catch (ServiceSpecificException serviceSpecificException) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeTransportModeTransform(ParcelFileDescriptor socket, int resourceId) throws RemoteException {
        try {
            this.getNetdInstance().ipSecRemoveTransportModeTransform(socket.getFileDescriptor());
        }
        catch (ServiceSpecificException serviceSpecificException) {
            // empty catch block
        }
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        pw.println("IpSecService Log:");
        pw.println("NetdNativeService Connection: " + (this.isNetdAlive() ? "alive" : "dead"));
        pw.println();
    }

    private final class SpiRecord
    extends ManagedResource {
        private final int mDirection;
        private final String mLocalAddress;
        private final String mRemoteAddress;
        private final IBinder mBinder;
        private int mSpi;
        private int mResourceId;

        SpiRecord(int resourceId, int direction, String localAddress, String remoteAddress, int spi, IBinder binder) {
            super(binder);
            this.mResourceId = resourceId;
            this.mDirection = direction;
            this.mLocalAddress = localAddress;
            this.mRemoteAddress = remoteAddress;
            this.mSpi = spi;
            this.mBinder = binder;
        }

        @Override
        protected void releaseResources() {
            try {
                IpSecService.this.getNetdInstance().ipSecDeleteSecurityAssociation(this.mResourceId, this.mDirection, this.mLocalAddress, this.mRemoteAddress, this.mSpi);
            }
            catch (ServiceSpecificException serviceSpecificException) {
            }
            catch (RemoteException e) {
                Log.e(IpSecService.TAG, "Failed to delete SPI reservation with ID: " + this.mResourceId);
            }
        }

        @Override
        protected void nullifyRecord() {
            this.mSpi = 0;
            this.mResourceId = 0;
        }
    }

    private final class TransformRecord
    extends ManagedResource {
        private IpSecConfig mConfig;
        private int mResourceId;

        TransformRecord(IpSecConfig config, int resourceId, IBinder binder) {
            super(binder);
            this.mConfig = config;
            this.mResourceId = resourceId;
        }

        public IpSecConfig getConfig() {
            return this.mConfig;
        }

        @Override
        protected void releaseResources() {
            for (int direction : DIRECTIONS) {
                try {
                    IpSecService.this.getNetdInstance().ipSecDeleteSecurityAssociation(this.mResourceId, direction, this.mConfig.getLocalAddress() != null ? this.mConfig.getLocalAddress().getHostAddress() : "", this.mConfig.getRemoteAddress() != null ? this.mConfig.getRemoteAddress().getHostAddress() : "", this.mConfig.getSpi(direction));
                }
                catch (ServiceSpecificException serviceSpecificException) {
                }
                catch (RemoteException e) {
                    Log.e(IpSecService.TAG, "Failed to delete SA with ID: " + this.mResourceId);
                }
            }
        }

        @Override
        protected void nullifyRecord() {
            this.mConfig = null;
            this.mResourceId = 0;
        }
    }

    private abstract class ManagedResource
    implements IBinder.DeathRecipient {
        final int pid;
        final int uid;
        private IBinder mBinder;

        ManagedResource(IBinder binder) {
            this.mBinder = binder;
            this.pid = Binder.getCallingPid();
            this.uid = Binder.getCallingUid();
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        public final void release() {
            this.releaseResources();
            if (this.mBinder != null) {
                this.mBinder.unlinkToDeath(this, 0);
            }
            this.mBinder = null;
            this.nullifyRecord();
        }

        @Override
        public final void binderDied() {
            this.release();
        }

        protected abstract void nullifyRecord();

        protected abstract void releaseResources();
    }
}

