/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.ArrayUtils;
import com.android.org.conscrypt.EmptyArray;
import com.android.org.conscrypt.GCMParameters;
import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.NativeRef;
import com.android.org.conscrypt.Platform;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class OpenSSLCipher
extends CipherSpi {
    protected Mode mode = Mode.ECB;
    private Padding padding = Padding.PKCS5PADDING;
    protected byte[] encodedKey;
    protected byte[] iv;
    private boolean encrypting;
    private int blockSize;

    protected OpenSSLCipher() {
    }

    protected OpenSSLCipher(Mode mode, Padding padding) {
        this.mode = mode;
        this.padding = padding;
        this.blockSize = this.getCipherBlockSize();
    }

    protected abstract void engineInitInternal(byte[] var1, AlgorithmParameterSpec var2, SecureRandom var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract int updateInternal(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws ShortBufferException;

    protected abstract int doFinalInternal(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException;

    protected abstract String getBaseCipherName();

    protected abstract void checkSupportedKeySize(int var1) throws InvalidKeyException;

    protected abstract void checkSupportedMode(Mode var1) throws NoSuchAlgorithmException;

    protected abstract void checkSupportedPadding(Padding var1) throws NoSuchPaddingException;

    protected abstract int getCipherBlockSize();

    protected boolean supportsVariableSizeKey() {
        return false;
    }

    protected boolean supportsVariableSizeIv() {
        return false;
    }

    @Override
    protected void engineSetMode(String modeStr) throws NoSuchAlgorithmException {
        Mode mode;
        try {
            mode = Mode.valueOf(modeStr.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            NoSuchAlgorithmException newE = new NoSuchAlgorithmException("No such mode: " + modeStr);
            newE.initCause(e);
            throw newE;
        }
        this.checkSupportedMode(mode);
        this.mode = mode;
    }

    @Override
    protected void engineSetPadding(String paddingStr) throws NoSuchPaddingException {
        Padding padding;
        String paddingStrUpper = paddingStr.toUpperCase(Locale.US);
        try {
            padding = Padding.valueOf(paddingStrUpper);
        }
        catch (IllegalArgumentException e) {
            NoSuchPaddingException newE = new NoSuchPaddingException("No such padding: " + paddingStr);
            newE.initCause(e);
            throw newE;
        }
        this.checkSupportedPadding(padding);
        this.padding = padding;
    }

    protected Padding getPadding() {
        return this.padding;
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    protected abstract int getOutputSizeForFinal(int var1);

    protected abstract int getOutputSizeForUpdate(int var1);

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.getOutputSizeForFinal(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.iv != null && this.iv.length > 0) {
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance(this.getBaseCipherName());
                params.init(this.iv);
                return params;
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.checkAndSetEncodedKey(opmode, key);
        try {
            this.engineInitInternal(this.encodedKey, null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.checkAndSetEncodedKey(opmode, key);
        this.engineInitInternal(this.encodedKey, params, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec spec;
        if (params != null) {
            try {
                spec = params.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("Params must be convertible to IvParameterSpec", e);
            }
        } else {
            spec = null;
        }
        this.engineInit(opmode, key, spec, random);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        int bytesWritten;
        int maximumLen = this.getOutputSizeForUpdate(inputLen);
        byte[] output = maximumLen > 0 ? new byte[maximumLen] : EmptyArray.BYTE;
        try {
            bytesWritten = this.updateInternal(input, inputOffset, inputLen, output, 0, maximumLen);
        }
        catch (ShortBufferException e) {
            throw new RuntimeException("calculated buffer size was wrong: " + maximumLen);
        }
        if (output.length == bytesWritten) {
            return output;
        }
        if (bytesWritten == 0) {
            return EmptyArray.BYTE;
        }
        return Arrays.copyOfRange(output, 0, bytesWritten);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int maximumLen = this.getOutputSizeForUpdate(inputLen);
        return this.updateInternal(input, inputOffset, inputLen, output, outputOffset, maximumLen);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int bytesWritten;
        int maximumLen = this.getOutputSizeForFinal(inputLen);
        byte[] output = new byte[maximumLen];
        if (inputLen > 0) {
            try {
                bytesWritten = this.updateInternal(input, inputOffset, inputLen, output, 0, maximumLen);
            }
            catch (ShortBufferException e) {
                throw new RuntimeException("our calculated buffer was too small", e);
            }
        } else {
            bytesWritten = 0;
        }
        try {
            bytesWritten += this.doFinalInternal(output, bytesWritten, maximumLen - bytesWritten);
        }
        catch (ShortBufferException e) {
            throw new RuntimeException("our calculated buffer was too small", e);
        }
        if (bytesWritten == output.length) {
            return output;
        }
        if (bytesWritten == 0) {
            return EmptyArray.BYTE;
        }
        return Arrays.copyOfRange(output, 0, bytesWritten);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int bytesWritten;
        if (output == null) {
            throw new NullPointerException("output == null");
        }
        int maximumLen = this.getOutputSizeForFinal(inputLen);
        if (inputLen > 0) {
            bytesWritten = this.updateInternal(input, inputOffset, inputLen, output, outputOffset, maximumLen);
            outputOffset += bytesWritten;
            maximumLen -= bytesWritten;
        } else {
            bytesWritten = 0;
        }
        return bytesWritten + this.doFinalInternal(output, outputOffset, maximumLen);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        try {
            byte[] encoded = key.getEncoded();
            return this.engineDoFinal(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e) {
            IllegalBlockSizeException newE = new IllegalBlockSizeException();
            newE.initCause(e);
            throw newE;
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            byte[] encoded = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
            if (wrappedKeyType == 1) {
                KeyFactory keyFactory = KeyFactory.getInstance(wrappedKeyAlgorithm);
                return keyFactory.generatePublic(new X509EncodedKeySpec(encoded));
            }
            if (wrappedKeyType == 2) {
                KeyFactory keyFactory = KeyFactory.getInstance(wrappedKeyAlgorithm);
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encoded));
            }
            if (wrappedKeyType == 3) {
                return new SecretKeySpec(encoded, wrappedKeyAlgorithm);
            }
            throw new UnsupportedOperationException("wrappedKeyType == " + wrappedKeyType);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException(e);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e);
        }
    }

    private byte[] checkAndSetEncodedKey(int opmode, Key key) throws InvalidKeyException {
        if (opmode == 1 || opmode == 3) {
            this.encrypting = true;
        } else if (opmode == 2 || opmode == 4) {
            this.encrypting = false;
        } else {
            throw new InvalidParameterException("Unsupported opmode " + opmode);
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey is supported");
        }
        byte[] encodedKey = key.getEncoded();
        if (encodedKey == null) {
            throw new InvalidKeyException("key.getEncoded() == null");
        }
        this.checkSupportedKeySize(encodedKey.length);
        this.encodedKey = encodedKey;
        return encodedKey;
    }

    protected boolean isEncrypting() {
        return this.encrypting;
    }

    public static abstract class EVP_AEAD
    extends OpenSSLCipher {
        private static final int DEFAULT_TAG_SIZE_BITS = 128;
        private static int lastGlobalMessageSize = 32;
        protected byte[] buf;
        protected int bufCount;
        protected long evpAead;
        private byte[] aad;
        private int tagLengthInBytes;

        public EVP_AEAD(Mode mode) {
            super(mode, Padding.NOPADDING);
        }

        private void expand(int i) {
            if (this.bufCount + i <= this.buf.length) {
                return;
            }
            byte[] newbuf = new byte[(this.bufCount + i) * 2];
            System.arraycopy((byte[])this.buf, (int)0, (byte[])newbuf, (int)0, (int)this.bufCount);
            this.buf = newbuf;
        }

        private void reset() {
            this.aad = null;
            int lastBufSize = lastGlobalMessageSize;
            if (this.buf == null) {
                this.buf = new byte[lastBufSize];
            } else if (this.bufCount > 0 && this.bufCount != lastBufSize) {
                lastGlobalMessageSize = this.bufCount;
                if (this.buf.length != this.bufCount) {
                    this.buf = new byte[this.bufCount];
                }
            }
            this.bufCount = 0;
        }

        @Override
        protected void engineInitInternal(byte[] encodedKey, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            int tagLenBits;
            byte[] iv;
            if (params == null) {
                iv = null;
                tagLenBits = 128;
            } else {
                GCMParameters gcmParams = Platform.fromGCMParameterSpec(params);
                if (gcmParams != null) {
                    iv = gcmParams.getIV();
                    tagLenBits = gcmParams.getTLen();
                } else if (params instanceof IvParameterSpec) {
                    IvParameterSpec ivParams = (IvParameterSpec)params;
                    iv = ivParams.getIV();
                    tagLenBits = 128;
                } else {
                    iv = null;
                    tagLenBits = 128;
                }
            }
            if (tagLenBits % 8 != 0) {
                throw new InvalidAlgorithmParameterException("Tag length must be a multiple of 8; was " + this.tagLengthInBytes);
            }
            this.tagLengthInBytes = tagLenBits / 8;
            boolean encrypting = this.isEncrypting();
            this.evpAead = this.getEVP_AEAD(encodedKey.length);
            int expectedIvLength = NativeCrypto.EVP_AEAD_nonce_length(this.evpAead);
            if (iv == null && expectedIvLength != 0) {
                if (!encrypting) {
                    throw new InvalidAlgorithmParameterException("IV must be specified in " + (Object)((Object)this.mode) + " mode");
                }
                iv = new byte[expectedIvLength];
                if (random != null) {
                    random.nextBytes(iv);
                } else {
                    NativeCrypto.RAND_bytes(iv);
                }
            } else {
                if (expectedIvLength == 0 && iv != null) {
                    throw new InvalidAlgorithmParameterException("IV not used in " + (Object)((Object)this.mode) + " mode");
                }
                if (iv != null && iv.length != expectedIvLength) {
                    throw new InvalidAlgorithmParameterException("Expected IV length of " + expectedIvLength + " but was " + iv.length);
                }
            }
            this.iv = iv;
            this.reset();
        }

        @Override
        protected int updateInternal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, int maximumLen) throws ShortBufferException {
            if (this.buf == null) {
                throw new IllegalStateException("Cipher not initialized");
            }
            ArrayUtils.checkOffsetAndCount(input.length, inputOffset, inputLen);
            if (inputLen > 0) {
                this.expand(inputLen);
                System.arraycopy((byte[])input, (int)inputOffset, (byte[])this.buf, (int)this.bufCount, (int)inputLen);
                this.bufCount += inputLen;
            }
            return 0;
        }

        private void throwAEADBadTagExceptionIfAvailable(String message, Throwable cause) throws BadPaddingException {
            Constructor<?> aeadBadTagConstructor;
            try {
                aeadBadTagConstructor = Class.forName("javax.crypto.AEADBadTagException").getConstructor(String.class);
            }
            catch (Exception ignored) {
                return;
            }
            BadPaddingException badTagException = null;
            try {
                badTagException = (BadPaddingException)aeadBadTagConstructor.newInstance(message);
                badTagException.initCause(cause);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (InvocationTargetException e2) {
                throw (BadPaddingException)new BadPaddingException().initCause(e2.getTargetException());
            }
            if (badTagException != null) {
                throw badTagException;
            }
        }

        @Override
        protected int doFinalInternal(byte[] output, int outputOffset, int maximumLen) throws IllegalBlockSizeException, BadPaddingException {
            int bytesWritten;
            try {
                bytesWritten = this.isEncrypting() ? NativeCrypto.EVP_AEAD_CTX_seal(this.evpAead, this.encodedKey, this.tagLengthInBytes, output, outputOffset, this.iv, this.buf, 0, this.bufCount, this.aad) : NativeCrypto.EVP_AEAD_CTX_open(this.evpAead, this.encodedKey, this.tagLengthInBytes, output, outputOffset, this.iv, this.buf, 0, this.bufCount, this.aad);
            }
            catch (BadPaddingException e) {
                this.throwAEADBadTagExceptionIfAvailable(e.getMessage(), e.getCause());
                throw e;
            }
            this.reset();
            return bytesWritten;
        }

        @Override
        protected void checkSupportedPadding(Padding padding) throws NoSuchPaddingException {
            if (padding != Padding.NOPADDING) {
                throw new NoSuchPaddingException("Must be NoPadding for AEAD ciphers");
            }
        }

        @Override
        protected int getOutputSizeForFinal(int inputLen) {
            return this.bufCount + inputLen + (this.isEncrypting() ? NativeCrypto.EVP_AEAD_max_overhead(this.evpAead) : 0);
        }

        @Override
        protected void engineUpdateAAD(byte[] input, int inputOffset, int inputLen) {
            if (this.aad == null) {
                this.aad = Arrays.copyOfRange(input, inputOffset, inputOffset + inputLen);
            } else {
                int newSize = this.aad.length + inputLen;
                byte[] newaad = new byte[newSize];
                System.arraycopy((byte[])this.aad, (int)0, (byte[])newaad, (int)0, (int)this.aad.length);
                System.arraycopy((byte[])input, (int)inputOffset, (byte[])newaad, (int)this.aad.length, (int)inputLen);
                this.aad = newaad;
            }
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            if (this.iv == null) {
                return null;
            }
            AlgorithmParameterSpec spec = Platform.toGCMParameterSpec(this.tagLengthInBytes * 8, this.iv);
            if (spec == null) {
                return super.engineGetParameters();
            }
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance("GCM");
                params.init(spec);
                return params;
            }
            catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
                return null;
            }
        }

        protected abstract long getEVP_AEAD(int var1) throws InvalidKeyException;

        public static abstract class AES
        extends EVP_AEAD {
            private static final int AES_BLOCK_SIZE = 16;

            protected AES(Mode mode) {
                super(mode);
            }

            @Override
            protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                switch (keyLength) {
                    case 16: 
                    case 32: {
                        return;
                    }
                }
                throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes (must be 16 or 32)");
            }

            @Override
            protected String getBaseCipherName() {
                return "AES";
            }

            @Override
            protected int getCipherBlockSize() {
                return 16;
            }

            @Override
            protected int getOutputSizeForUpdate(int inputLen) {
                return 0;
            }

            public static class GCM
            extends AES {
                private byte[] previousKey;
                private byte[] previousIv;
                private boolean mustInitialize;

                public GCM() {
                    super(Mode.GCM);
                }

                private void checkInitialization() {
                    if (this.mustInitialize) {
                        throw new IllegalStateException("Cannot re-use same key and IV for multiple encryptions");
                    }
                }

                private boolean arraysAreEqual(byte[] a, byte[] b) {
                    if (a.length != b.length) {
                        return false;
                    }
                    int diff = 0;
                    for (int i = 0; i < a.length; ++i) {
                        diff |= a[i] ^ b[i];
                    }
                    return diff == 0;
                }

                @Override
                protected void engineInitInternal(byte[] encodedKey, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
                    super.engineInitInternal(encodedKey, params, random);
                    if (this.isEncrypting() && this.iv != null) {
                        if (this.previousKey != null && this.previousIv != null && this.arraysAreEqual(this.previousKey, encodedKey) && this.arraysAreEqual(this.previousIv, this.iv)) {
                            this.mustInitialize = true;
                            throw new InvalidAlgorithmParameterException("In GCM mode key and IV must not be re-used");
                        }
                        this.previousKey = encodedKey;
                        this.previousIv = this.iv;
                    }
                    this.mustInitialize = false;
                }

                @Override
                protected int updateInternal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, int maximumLen) throws ShortBufferException {
                    this.checkInitialization();
                    return super.updateInternal(input, inputOffset, inputLen, output, outputOffset, maximumLen);
                }

                @Override
                protected int doFinalInternal(byte[] output, int outputOffset, int maximumLen) throws IllegalBlockSizeException, BadPaddingException {
                    this.checkInitialization();
                    int retVal = super.doFinalInternal(output, outputOffset, maximumLen);
                    if (this.isEncrypting()) {
                        this.mustInitialize = true;
                    }
                    return retVal;
                }

                @Override
                protected void engineUpdateAAD(byte[] input, int inputOffset, int inputLen) {
                    this.checkInitialization();
                    super.engineUpdateAAD(input, inputOffset, inputLen);
                }

                @Override
                protected void checkSupportedMode(Mode mode) throws NoSuchAlgorithmException {
                    if (mode != Mode.GCM) {
                        throw new NoSuchAlgorithmException("Mode must be GCM");
                    }
                }

                @Override
                protected long getEVP_AEAD(int keyLength) throws InvalidKeyException {
                    if (keyLength == 16) {
                        return NativeCrypto.EVP_aead_aes_128_gcm();
                    }
                    if (keyLength == 32) {
                        return NativeCrypto.EVP_aead_aes_256_gcm();
                    }
                    throw new RuntimeException("Unexpected key length: " + keyLength);
                }

                public static class AES_256
                extends GCM {
                    @Override
                    protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                        if (keyLength != 32) {
                            throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes (must be 32)");
                        }
                    }
                }

                public static class AES_128
                extends GCM {
                    @Override
                    protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                        if (keyLength != 16) {
                            throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes (must be 16)");
                        }
                    }
                }
            }
        }
    }

    public static abstract class EVP_CIPHER
    extends OpenSSLCipher {
        private final NativeRef.EVP_CIPHER_CTX cipherCtx = new NativeRef.EVP_CIPHER_CTX(NativeCrypto.EVP_CIPHER_CTX_new());
        protected boolean calledUpdate;
        private int modeBlockSize;

        public EVP_CIPHER(Mode mode, Padding padding) {
            super(mode, padding);
        }

        @Override
        protected void engineInitInternal(byte[] encodedKey, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            byte[] iv;
            if (params instanceof IvParameterSpec) {
                IvParameterSpec ivParams = (IvParameterSpec)params;
                iv = ivParams.getIV();
            } else {
                iv = null;
            }
            long cipherType = NativeCrypto.EVP_get_cipherbyname(this.getCipherName(encodedKey.length, this.mode));
            if (cipherType == 0L) {
                throw new InvalidAlgorithmParameterException("Cannot find name for key length = " + encodedKey.length * 8 + " and mode = " + (Object)((Object)this.mode));
            }
            boolean encrypting = this.isEncrypting();
            int expectedIvLength = NativeCrypto.EVP_CIPHER_iv_length(cipherType);
            if (iv == null && expectedIvLength != 0) {
                if (!encrypting) {
                    throw new InvalidAlgorithmParameterException("IV must be specified in " + (Object)((Object)this.mode) + " mode");
                }
                iv = new byte[expectedIvLength];
                if (random != null) {
                    random.nextBytes(iv);
                } else {
                    NativeCrypto.RAND_bytes(iv);
                }
            } else {
                if (expectedIvLength == 0 && iv != null) {
                    throw new InvalidAlgorithmParameterException("IV not used in " + (Object)((Object)this.mode) + " mode");
                }
                if (iv != null && iv.length != expectedIvLength) {
                    throw new InvalidAlgorithmParameterException("expected IV length of " + expectedIvLength + " but was " + iv.length);
                }
            }
            this.iv = iv;
            if (this.supportsVariableSizeKey()) {
                NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, cipherType, null, null, encrypting);
                NativeCrypto.EVP_CIPHER_CTX_set_key_length(this.cipherCtx, encodedKey.length);
                NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, 0L, encodedKey, iv, this.isEncrypting());
            } else {
                NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, cipherType, encodedKey, iv, encrypting);
            }
            NativeCrypto.EVP_CIPHER_CTX_set_padding(this.cipherCtx, this.getPadding() == Padding.PKCS5PADDING);
            this.modeBlockSize = NativeCrypto.EVP_CIPHER_CTX_block_size(this.cipherCtx);
            this.calledUpdate = false;
        }

        @Override
        protected int updateInternal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, int maximumLen) throws ShortBufferException {
            int intialOutputOffset = outputOffset;
            int bytesLeft = output.length - outputOffset;
            if (bytesLeft < maximumLen) {
                throw new ShortBufferException("output buffer too small during update: " + bytesLeft + " < " + maximumLen);
            }
            outputOffset += NativeCrypto.EVP_CipherUpdate(this.cipherCtx, output, outputOffset, input, inputOffset, inputLen);
            this.calledUpdate = true;
            return outputOffset - intialOutputOffset;
        }

        @Override
        protected int doFinalInternal(byte[] output, int outputOffset, int maximumLen) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
            int writtenBytes;
            int initialOutputOffset = outputOffset;
            if (!this.isEncrypting() && !this.calledUpdate) {
                return 0;
            }
            int bytesLeft = output.length - outputOffset;
            if (bytesLeft >= maximumLen) {
                writtenBytes = NativeCrypto.EVP_CipherFinal_ex(this.cipherCtx, output, outputOffset);
            } else {
                byte[] lastBlock = new byte[maximumLen];
                writtenBytes = NativeCrypto.EVP_CipherFinal_ex(this.cipherCtx, lastBlock, 0);
                if (writtenBytes > bytesLeft) {
                    throw new ShortBufferException("buffer is too short: " + writtenBytes + " > " + bytesLeft);
                }
                if (writtenBytes > 0) {
                    System.arraycopy((byte[])lastBlock, (int)0, (byte[])output, (int)outputOffset, (int)writtenBytes);
                }
            }
            this.reset();
            return (outputOffset += writtenBytes) - initialOutputOffset;
        }

        @Override
        protected int getOutputSizeForFinal(int inputLen) {
            if (this.modeBlockSize == 1) {
                return inputLen;
            }
            int buffered = NativeCrypto.get_EVP_CIPHER_CTX_buf_len(this.cipherCtx);
            if (this.getPadding() == Padding.NOPADDING) {
                return buffered + inputLen;
            }
            boolean finalUsed = NativeCrypto.get_EVP_CIPHER_CTX_final_used(this.cipherCtx);
            int totalLen = inputLen + buffered + (finalUsed ? this.modeBlockSize : 0);
            return (totalLen += totalLen % this.modeBlockSize != 0 || this.isEncrypting() ? this.modeBlockSize : 0) - totalLen % this.modeBlockSize;
        }

        @Override
        protected int getOutputSizeForUpdate(int inputLen) {
            return this.getOutputSizeForFinal(inputLen);
        }

        protected abstract String getCipherName(int var1, Mode var2);

        private void reset() {
            NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, 0L, this.encodedKey, this.iv, this.isEncrypting());
            this.calledUpdate = false;
        }

        public static class ARC4
        extends EVP_CIPHER {
            public ARC4() {
                super(Mode.ECB, Padding.NOPADDING);
            }

            @Override
            protected String getBaseCipherName() {
                return "ARCFOUR";
            }

            @Override
            protected String getCipherName(int keySize, Mode mode) {
                return "rc4";
            }

            @Override
            protected void checkSupportedKeySize(int keySize) throws InvalidKeyException {
            }

            @Override
            protected void checkSupportedMode(Mode mode) throws NoSuchAlgorithmException {
                throw new NoSuchAlgorithmException("ARC4 does not support modes");
            }

            @Override
            protected void checkSupportedPadding(Padding padding) throws NoSuchPaddingException {
                throw new NoSuchPaddingException("ARC4 does not support padding");
            }

            @Override
            protected int getCipherBlockSize() {
                return 0;
            }

            @Override
            protected boolean supportsVariableSizeKey() {
                return true;
            }
        }

        public static class DESEDE
        extends EVP_CIPHER {
            private static final int DES_BLOCK_SIZE = 8;

            public DESEDE(Mode mode, Padding padding) {
                super(mode, padding);
            }

            @Override
            protected String getBaseCipherName() {
                return "DESede";
            }

            @Override
            protected String getCipherName(int keySize, Mode mode) {
                String baseCipherName = keySize == 16 ? "des-ede" : "des-ede3";
                return baseCipherName + "-" + mode.toString().toLowerCase(Locale.US);
            }

            @Override
            protected void checkSupportedKeySize(int keySize) throws InvalidKeyException {
                if (keySize != 16 && keySize != 24) {
                    throw new InvalidKeyException("key size must be 128 or 192 bits");
                }
            }

            @Override
            protected void checkSupportedMode(Mode mode) throws NoSuchAlgorithmException {
                if (mode != Mode.CBC) {
                    throw new NoSuchAlgorithmException("Unsupported mode " + mode.toString());
                }
            }

            @Override
            protected void checkSupportedPadding(Padding padding) throws NoSuchPaddingException {
                switch (padding) {
                    case NOPADDING: 
                    case PKCS5PADDING: {
                        return;
                    }
                }
                throw new NoSuchPaddingException("Unsupported padding " + padding.toString());
            }

            @Override
            protected int getCipherBlockSize() {
                return 8;
            }

            public static class CBC
            extends DESEDE {
                public CBC(Padding padding) {
                    super(Mode.CBC, padding);
                }

                public static class PKCS5Padding
                extends CBC {
                    public PKCS5Padding() {
                        super(Padding.PKCS5PADDING);
                    }
                }

                public static class NoPadding
                extends CBC {
                    public NoPadding() {
                        super(Padding.NOPADDING);
                    }
                }
            }
        }

        public static class AES_256
        extends AES_BASE {
            protected AES_256(Mode mode, Padding padding) {
                super(mode, padding);
            }

            @Override
            protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                if (keyLength != 32) {
                    throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes");
                }
            }

            public static class ECB
            extends AES_256 {
                public ECB(Padding padding) {
                    super(Mode.ECB, padding);
                }

                public static class PKCS5Padding
                extends ECB {
                    public PKCS5Padding() {
                        super(Padding.PKCS5PADDING);
                    }
                }

                public static class NoPadding
                extends ECB {
                    public NoPadding() {
                        super(Padding.NOPADDING);
                    }
                }
            }

            public static class CTR
            extends AES_256 {
                public CTR() {
                    super(Mode.CTR, Padding.NOPADDING);
                }
            }

            public static class CBC
            extends AES_256 {
                public CBC(Padding padding) {
                    super(Mode.CBC, padding);
                }

                public static class PKCS5Padding
                extends CBC {
                    public PKCS5Padding() {
                        super(Padding.PKCS5PADDING);
                    }
                }

                public static class NoPadding
                extends CBC {
                    public NoPadding() {
                        super(Padding.NOPADDING);
                    }
                }
            }
        }

        public static class AES_128
        extends AES_BASE {
            protected AES_128(Mode mode, Padding padding) {
                super(mode, padding);
            }

            @Override
            protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                if (keyLength != 16) {
                    throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes");
                }
            }

            public static class ECB
            extends AES_128 {
                public ECB(Padding padding) {
                    super(Mode.ECB, padding);
                }

                public static class PKCS5Padding
                extends ECB {
                    public PKCS5Padding() {
                        super(Padding.PKCS5PADDING);
                    }
                }

                public static class NoPadding
                extends ECB {
                    public NoPadding() {
                        super(Padding.NOPADDING);
                    }
                }
            }

            public static class CTR
            extends AES_128 {
                public CTR() {
                    super(Mode.CTR, Padding.NOPADDING);
                }
            }

            public static class CBC
            extends AES_128 {
                public CBC(Padding padding) {
                    super(Mode.CBC, padding);
                }

                public static class PKCS5Padding
                extends CBC {
                    public PKCS5Padding() {
                        super(Padding.PKCS5PADDING);
                    }
                }

                public static class NoPadding
                extends CBC {
                    public NoPadding() {
                        super(Padding.NOPADDING);
                    }
                }
            }
        }

        public static class AES
        extends AES_BASE {
            protected AES(Mode mode, Padding padding) {
                super(mode, padding);
            }

            @Override
            protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                switch (keyLength) {
                    case 16: 
                    case 24: 
                    case 32: {
                        return;
                    }
                }
                throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes");
            }

            public static class ECB
            extends AES {
                public ECB(Padding padding) {
                    super(Mode.ECB, padding);
                }

                public static class PKCS5Padding
                extends ECB {
                    public PKCS5Padding() {
                        super(Padding.PKCS5PADDING);
                    }
                }

                public static class NoPadding
                extends ECB {
                    public NoPadding() {
                        super(Padding.NOPADDING);
                    }
                }
            }

            public static class CTR
            extends AES {
                public CTR() {
                    super(Mode.CTR, Padding.NOPADDING);
                }
            }

            public static class CBC
            extends AES {
                public CBC(Padding padding) {
                    super(Mode.CBC, padding);
                }

                public static class PKCS5Padding
                extends CBC {
                    public PKCS5Padding() {
                        super(Padding.PKCS5PADDING);
                    }
                }

                public static class NoPadding
                extends CBC {
                    public NoPadding() {
                        super(Padding.NOPADDING);
                    }
                }
            }
        }

        protected static abstract class AES_BASE
        extends EVP_CIPHER {
            private static final int AES_BLOCK_SIZE = 16;

            protected AES_BASE(Mode mode, Padding padding) {
                super(mode, padding);
            }

            @Override
            protected void checkSupportedMode(Mode mode) throws NoSuchAlgorithmException {
                switch (mode) {
                    case CBC: 
                    case CTR: 
                    case ECB: {
                        return;
                    }
                }
                throw new NoSuchAlgorithmException("Unsupported mode " + mode.toString());
            }

            @Override
            protected void checkSupportedPadding(Padding padding) throws NoSuchPaddingException {
                switch (padding) {
                    case NOPADDING: 
                    case PKCS5PADDING: {
                        return;
                    }
                }
                throw new NoSuchPaddingException("Unsupported padding " + padding.toString());
            }

            @Override
            protected String getBaseCipherName() {
                return "AES";
            }

            @Override
            protected String getCipherName(int keyLength, Mode mode) {
                return "aes-" + keyLength * 8 + "-" + mode.toString().toLowerCase(Locale.US);
            }

            @Override
            protected int getCipherBlockSize() {
                return 16;
            }
        }
    }

    protected static enum Padding {
        NOPADDING,
        PKCS5PADDING,
        ISO10126PADDING;

    }

    protected static enum Mode {
        CBC,
        CTR,
        ECB,
        GCM;

    }
}

