/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ReceiverCallNotAllowedException;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SwipeDismissLayout
extends FrameLayout
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "SwipeDismissLayout";
    private static float MAX_DIST_THRESHOLD = 0.33f;
    private static float MIN_DIST_THRESHOLD = 0.1f;
    private boolean mIsWindowNativelyTranslucent;
    private int mSlop;
    private int mMinFlingVelocity;
    private int mActiveTouchId;
    private float mDownX;
    private float mDownY;
    private float mLastX;
    private boolean mSwiping;
    private boolean mDismissed;
    private boolean mDiscardIntercept;
    private VelocityTracker mVelocityTracker;
    private boolean mBlockGesture;
    private boolean mActivityTranslucencyConverted;
    private DismissAnimator mDismissAnimator;
    private OnDismissedListener mDismissedListener;
    private OnSwipeProgressChangedListener mProgressListener;
    private BroadcastReceiver mScreenOffReceiver;
    private IntentFilter mScreenOffFilter;
    private boolean mDismissable;

    private void $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(Context context) {
        this.mBlockGesture = false;
        this.mActivityTranslucencyConverted = false;
        this.mDismissAnimator = new DismissAnimator(this);
        this.mScreenOffFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
        this.mDismissable = true;
        this.init(context);
    }

    private void $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(Context context, AttributeSet attrs) {
        this.mBlockGesture = false;
        this.mActivityTranslucencyConverted = false;
        this.mDismissAnimator = new DismissAnimator(this);
        this.mScreenOffFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
        this.mDismissable = true;
        this.init(context);
    }

    private void $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(Context context, AttributeSet attrs, int defStyle) {
        this.mBlockGesture = false;
        this.mActivityTranslucencyConverted = false;
        this.mDismissAnimator = new DismissAnimator(this);
        this.mScreenOffFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
        this.mDismissable = true;
        this.init(context);
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$init(Context context) {
        ViewConfiguration vc = ViewConfiguration.get(context);
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        TypedArray a = context.getTheme().obtainStyledAttributes(R.styleable.Theme);
        this.mIsWindowNativelyTranslucent = a.getBoolean(5, false);
        a.recycle();
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnDismissedListener(OnDismissedListener listener) {
        this.mDismissedListener = listener;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnSwipeProgressChangedListener(OnSwipeProgressChangedListener listener) {
        this.mProgressListener = listener;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$onAttachedToWindow() {
        super.onAttachedToWindow();
        try {
            this.mScreenOffReceiver = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ SwipeDismissLayout this$0;

                private void $$robo$$com_android_internal_widget_SwipeDismissLayout_1$__constructor__(SwipeDismissLayout this$0) {
                }

                private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_1$onReceive(Context context, Intent intent) {
                    this.this$0.post(() -> {
                        if (this.this$0.mDismissed) {
                            this.this$0.dismiss();
                        } else {
                            this.this$0.cancel();
                        }
                        this.this$0.resetMembers();
                    });
                }

                private void __constructor__(SwipeDismissLayout swipeDismissLayout) {
                    this.$$robo$$com_android_internal_widget_SwipeDismissLayout_1$__constructor__(swipeDismissLayout);
                }
                {
                    this.this$0 = swipeDismissLayout;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout_1$__constructor__(com.android.internal.widget.SwipeDismissLayout ), this, swipeDismissLayout);
                }

                @Override
                public void onReceive(Context context, Intent intent) {
                    InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_widget_SwipeDismissLayout_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.getContext().registerReceiver(this.mScreenOffReceiver, this.mScreenOffFilter);
        }
        catch (ReceiverCallNotAllowedException e) {
            this.mScreenOffReceiver = null;
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$onDetachedFromWindow() {
        if (this.mScreenOffReceiver != null) {
            this.getContext().unregisterReceiver(this.mScreenOffReceiver);
            this.mScreenOffReceiver = null;
        }
        super.onDetachedFromWindow();
    }

    private final boolean $$robo$$com_android_internal_widget_SwipeDismissLayout$onInterceptTouchEvent(MotionEvent ev) {
        this.checkGesture(ev);
        if (this.mBlockGesture) {
            return true;
        }
        if (!this.mDismissable) {
            return super.onInterceptTouchEvent(ev);
        }
        ev.offsetLocation(ev.getRawX() - ev.getX(), 0.0f);
        switch (ev.getActionMasked()) {
            case 0: {
                this.resetMembers();
                this.mDownX = ev.getRawX();
                this.mDownY = ev.getRawY();
                this.mActiveTouchId = ev.getPointerId(0);
                this.mVelocityTracker = VelocityTracker.obtain("int1");
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 5: {
                int actionIndex = ev.getActionIndex();
                this.mActiveTouchId = ev.getPointerId(actionIndex);
                break;
            }
            case 6: {
                int actionIndex = ev.getActionIndex();
                int pointerId = ev.getPointerId(actionIndex);
                if (pointerId != this.mActiveTouchId) break;
                int newActionIndex = actionIndex == 0 ? 1 : 0;
                this.mActiveTouchId = ev.getPointerId(newActionIndex);
                break;
            }
            case 1: 
            case 3: {
                this.resetMembers();
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mDiscardIntercept) break;
                int pointerIndex = ev.findPointerIndex(this.mActiveTouchId);
                if (pointerIndex == -1) {
                    Log.e("SwipeDismissLayout", "Invalid pointer index: ignoring.");
                    this.mDiscardIntercept = true;
                    break;
                }
                float dx = ev.getRawX() - this.mDownX;
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                if (dx != 0.0f && this.canScroll(this, false, dx, x, y)) {
                    this.mDiscardIntercept = true;
                    break;
                }
                this.updateSwiping(ev);
            }
        }
        return !this.mDiscardIntercept && this.mSwiping;
    }

    private final boolean $$robo$$com_android_internal_widget_SwipeDismissLayout$onTouchEvent(MotionEvent ev) {
        this.checkGesture(ev);
        if (this.mBlockGesture) {
            return true;
        }
        if (this.mVelocityTracker == null || !this.mDismissable) {
            return super.onTouchEvent(ev);
        }
        ev.offsetLocation(ev.getRawX() - ev.getX(), 0.0f);
        switch (ev.getActionMasked()) {
            case 1: {
                this.updateDismiss(ev);
                if (this.mDismissed) {
                    this.mDismissAnimator.animateDismissal(ev.getRawX() - this.mDownX);
                } else if (this.mSwiping && this.mLastX != -2.1474836E9f) {
                    this.mDismissAnimator.animateRecovery(ev.getRawX() - this.mDownX);
                }
                this.resetMembers();
                break;
            }
            case 3: {
                this.cancel();
                this.resetMembers();
                break;
            }
            case 2: {
                this.mVelocityTracker.addMovement(ev);
                this.mLastX = ev.getRawX();
                this.updateSwiping(ev);
                if (!this.mSwiping) break;
                this.setProgress(ev.getRawX() - this.mDownX);
            }
        }
        return true;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$setProgress(float deltaX) {
        if (this.mProgressListener != null && deltaX >= 0.0f) {
            this.mProgressListener.onSwipeProgressChanged(this, this.progressToAlpha(deltaX / (float)this.getWidth()), deltaX);
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$dismiss() {
        if (this.mDismissedListener != null) {
            this.mDismissedListener.onDismissed(this);
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$cancel() {
        Activity activity;
        if (!this.mIsWindowNativelyTranslucent && (activity = this.findActivity()) != null && this.mActivityTranslucencyConverted) {
            activity.convertFromTranslucent();
            this.mActivityTranslucencyConverted = false;
        }
        if (this.mProgressListener != null) {
            this.mProgressListener.onSwipeCancelled(this);
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$resetMembers() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = null;
        this.mDownX = 0.0f;
        this.mLastX = -2.1474836E9f;
        this.mDownY = 0.0f;
        this.mSwiping = false;
        this.mDismissed = false;
        this.mDiscardIntercept = false;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$updateSwiping(MotionEvent ev) {
        Activity activity;
        boolean oldSwiping = this.mSwiping;
        if (!this.mSwiping) {
            float deltaY;
            float deltaX = ev.getRawX() - this.mDownX;
            this.mSwiping = deltaX * deltaX + (deltaY = ev.getRawY() - this.mDownY) * deltaY > (float)(this.mSlop * this.mSlop) ? deltaX > (float)(this.mSlop * 2) && Math.abs(deltaY) < Math.abs(deltaX) : false;
        }
        if (this.mSwiping && !oldSwiping && !this.mIsWindowNativelyTranslucent && (activity = this.findActivity()) != null) {
            this.mActivityTranslucencyConverted = activity.convertToTranslucent(null, null);
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$updateDismiss(MotionEvent ev) {
        float distanceThreshold;
        float deltaX = ev.getRawX() - this.mDownX;
        this.mVelocityTracker.computeCurrentVelocity(1000);
        float xVelocity = this.mVelocityTracker.getXVelocity();
        if (this.mLastX == -2.1474836E9f) {
            xVelocity = deltaX / (float)((ev.getEventTime() - ev.getDownTime()) / 1000L);
        }
        if (!this.mDismissed && (deltaX > (distanceThreshold = (float)this.getWidth() * Math.max(Math.min(-0.23000002f * xVelocity / (float)this.mMinFlingVelocity + 0.33f, 0.33f), 0.1f)) && ev.getRawX() >= this.mLastX || xVelocity >= (float)this.mMinFlingVelocity)) {
            this.mDismissed = true;
        }
        if (this.mDismissed && this.mSwiping && xVelocity < (float)(-this.mMinFlingVelocity)) {
            this.mDismissed = false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_SwipeDismissLayout$canScroll(View v, boolean checkV, float dx, float x, float y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (!(x + (float)scrollX >= (float)child.getLeft()) || !(x + (float)scrollX < (float)child.getRight()) || !(y + (float)scrollY >= (float)child.getTop()) || !(y + (float)scrollY < (float)child.getBottom()) || !this.canScroll(child, true, dx, x + (float)scrollX - (float)child.getLeft(), y + (float)scrollY - (float)child.getTop())) continue;
                return true;
            }
        }
        return checkV && v.canScrollHorizontally((int)(-dx));
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$setDismissable(boolean dismissable) {
        if (!dismissable && this.mDismissable) {
            this.cancel();
            this.resetMembers();
        }
        this.mDismissable = dismissable;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$checkGesture(MotionEvent ev) {
        if (ev.getActionMasked() == 0) {
            this.mBlockGesture = this.mDismissAnimator.isAnimating();
        }
    }

    private final float $$robo$$com_android_internal_widget_SwipeDismissLayout$progressToAlpha(float progress) {
        return 1.0f - progress * progress * progress;
    }

    private final Activity $$robo$$com_android_internal_widget_SwipeDismissLayout$findActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(context);
    }

    public SwipeDismissLayout(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(context, attributeSet);
    }

    public SwipeDismissLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(context, attributeSet, n);
    }

    public SwipeDismissLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void init(Context context) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_widget_SwipeDismissLayout$init(android.content.Context ), this, context);
    }

    public void setOnDismissedListener(OnDismissedListener onDismissedListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissedListener", $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnDismissedListener(com.android.internal.widget.SwipeDismissLayout$OnDismissedListener ), this, onDismissedListener);
    }

    public void setOnSwipeProgressChangedListener(OnSwipeProgressChangedListener onSwipeProgressChangedListener) {
        InvokeDynamicSupport.bootstrap("setOnSwipeProgressChangedListener", $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnSwipeProgressChangedListener(com.android.internal.widget.SwipeDismissLayout$OnSwipeProgressChangedListener ), this, onSwipeProgressChangedListener);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_widget_SwipeDismissLayout$onAttachedToWindow(), this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_SwipeDismissLayout$onDetachedFromWindow(), this);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_SwipeDismissLayout$onInterceptTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_SwipeDismissLayout$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    private void setProgress(float f) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$com_android_internal_widget_SwipeDismissLayout$setProgress(float ), this, f);
    }

    private void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_widget_SwipeDismissLayout$dismiss(), this);
    }

    protected void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$com_android_internal_widget_SwipeDismissLayout$cancel(), this);
    }

    private void resetMembers() {
        InvokeDynamicSupport.bootstrap("resetMembers", $$robo$$com_android_internal_widget_SwipeDismissLayout$resetMembers(), this);
    }

    private void updateSwiping(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("updateSwiping", $$robo$$com_android_internal_widget_SwipeDismissLayout$updateSwiping(android.view.MotionEvent ), this, motionEvent);
    }

    private void updateDismiss(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("updateDismiss", $$robo$$com_android_internal_widget_SwipeDismissLayout$updateDismiss(android.view.MotionEvent ), this, motionEvent);
    }

    protected boolean canScroll(View view, boolean bl, float f, float f2, float f3) {
        return (boolean)InvokeDynamicSupport.bootstrap("canScroll", $$robo$$com_android_internal_widget_SwipeDismissLayout$canScroll(android.view.View boolean float float float ), this, view, bl, f, f2, f3);
    }

    public void setDismissable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDismissable", $$robo$$com_android_internal_widget_SwipeDismissLayout$setDismissable(boolean ), this, bl);
    }

    private void checkGesture(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("checkGesture", $$robo$$com_android_internal_widget_SwipeDismissLayout$checkGesture(android.view.MotionEvent ), this, motionEvent);
    }

    private float progressToAlpha(float f) {
        return (float)InvokeDynamicSupport.bootstrap("progressToAlpha", $$robo$$com_android_internal_widget_SwipeDismissLayout$progressToAlpha(float ), this, f);
    }

    private Activity findActivity() {
        return InvokeDynamicSupport.bootstrap("findActivity", $$robo$$com_android_internal_widget_SwipeDismissLayout$findActivity(), this);
    }

    public /* synthetic */ SwipeDismissLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SwipeDismissLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class DismissAnimator
    implements ValueAnimator.AnimatorUpdateListener,
    Animator.AnimatorListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private TimeInterpolator DISMISS_INTERPOLATOR;
        private long DISMISS_DURATION = 250L;
        private ValueAnimator mDismissAnimator;
        private boolean mWasCanceled;
        private boolean mDismissOnComplete;
        /* synthetic */ SwipeDismissLayout this$0;

        private void $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$__constructor__(SwipeDismissLayout swipeDismissLayout) {
            this.DISMISS_INTERPOLATOR = new DecelerateInterpolator(1.5f);
            this.DISMISS_DURATION = 250L;
            this.mDismissAnimator = new ValueAnimator();
            this.mWasCanceled = false;
            this.mDismissOnComplete = false;
            this.mDismissAnimator.addUpdateListener(this);
            this.mDismissAnimator.addListener(this);
        }

        private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$animateDismissal(float currentTranslation) {
            this.animate(currentTranslation / (float)this.this$0.getWidth(), 1.0f, 250L, this.DISMISS_INTERPOLATOR, true);
        }

        private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$animateRecovery(float currentTranslation) {
            this.animate(currentTranslation / (float)this.this$0.getWidth(), 0.0f, 250L, this.DISMISS_INTERPOLATOR, false);
        }

        private final boolean $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$isAnimating() {
            return this.mDismissAnimator.isStarted();
        }

        private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$animate(float from, float to, long duration, TimeInterpolator interpolator2, boolean dismissOnComplete) {
            this.mDismissAnimator.cancel();
            this.mDismissOnComplete = dismissOnComplete;
            this.mDismissAnimator.setFloatValues(from, to);
            this.mDismissAnimator.setDuration(duration);
            this.mDismissAnimator.setInterpolator(interpolator2);
            this.mDismissAnimator.start();
        }

        private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            this.this$0.setProgress(value * (float)this.this$0.getWidth());
        }

        private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$onAnimationStart(Animator animation) {
            this.mWasCanceled = false;
        }

        private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$onAnimationCancel(Animator animation) {
            this.mWasCanceled = true;
        }

        private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$onAnimationEnd(Animator animation) {
            if (!this.mWasCanceled) {
                if (this.mDismissOnComplete) {
                    this.this$0.dismiss();
                } else {
                    this.this$0.cancel();
                }
            }
        }

        private final void $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$onAnimationRepeat(Animator animation) {
        }

        private void __constructor__(SwipeDismissLayout swipeDismissLayout) {
            this.$$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$__constructor__(swipeDismissLayout);
        }

        public DismissAnimator(SwipeDismissLayout swipeDismissLayout) {
            this.this$0 = swipeDismissLayout;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$__constructor__(com.android.internal.widget.SwipeDismissLayout ), this, swipeDismissLayout);
        }

        void animateDismissal(float f) {
            InvokeDynamicSupport.bootstrap("animateDismissal", $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$animateDismissal(float ), this, f);
        }

        void animateRecovery(float f) {
            InvokeDynamicSupport.bootstrap("animateRecovery", $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$animateRecovery(float ), this, f);
        }

        boolean isAnimating() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAnimating", $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$isAnimating(), this);
        }

        private void animate(float f, float f2, long l, TimeInterpolator timeInterpolator, boolean bl) {
            InvokeDynamicSupport.bootstrap("animate", $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$animate(float float long android.animation.TimeInterpolator boolean ), this, f, f2, l, timeInterpolator, bl);
        }

        @Override
        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            InvokeDynamicSupport.bootstrap("onAnimationUpdate", $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$onAnimationUpdate(android.animation.ValueAnimator ), this, valueAnimator);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$onAnimationStart(android.animation.Animator ), this, animator2);
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$onAnimationCancel(android.animation.Animator ), this, animator2);
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$onAnimationEnd(android.animation.Animator ), this, animator2);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$com_android_internal_widget_SwipeDismissLayout_DismissAnimator$onAnimationRepeat(android.animation.Animator ), this, animator2);
        }

        public /* synthetic */ DismissAnimator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DismissAnimator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnSwipeProgressChangedListener
    extends InstrumentedInterface {
        public void onSwipeProgressChanged(SwipeDismissLayout var1, float var2, float var3);

        public void onSwipeCancelled(SwipeDismissLayout var1);
    }

    public static interface OnDismissedListener
    extends InstrumentedInterface {
        public void onDismissed(SwipeDismissLayout var1);
    }
}

