/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TypedProperties
extends HashMap<String, Object> {
    public /* synthetic */ Object __robo_data__;
    static String NULL_STRING;
    static int TYPE_UNSET = 120;
    static int TYPE_BOOLEAN = 90;
    static int TYPE_BYTE = 329;
    static int TYPE_SHORT = 585;
    static int TYPE_INT = 1097;
    static int TYPE_LONG = 2121;
    static int TYPE_FLOAT = 1094;
    static int TYPE_DOUBLE = 2118;
    static int TYPE_STRING = 29516;
    static int TYPE_ERROR = -1;
    public static int STRING_TYPE_MISMATCH = -2;
    public static int STRING_NOT_SET = -1;
    public static int STRING_NULL = 0;
    public static int STRING_SET = 1;

    private static final StreamTokenizer $$robo$$com_android_internal_util_TypedProperties$initTokenizer(Reader r) {
        StreamTokenizer st = new StreamTokenizer(r);
        st.resetSyntax();
        st.wordChars(48, 57);
        st.wordChars(65, 90);
        st.wordChars(97, 122);
        st.wordChars(95, 95);
        st.wordChars(36, 36);
        st.wordChars(46, 46);
        st.wordChars(45, 45);
        st.wordChars(43, 43);
        st.ordinaryChar(61);
        st.whitespaceChars(32, 32);
        st.whitespaceChars(9, 9);
        st.whitespaceChars(10, 10);
        st.whitespaceChars(13, 13);
        st.quoteChar(34);
        st.slashStarComments(true);
        st.slashSlashComments(true);
        return st;
    }

    private static final int $$robo$$com_android_internal_util_TypedProperties$interpretType(String typeName) {
        if ("unset".equals(typeName)) {
            return 120;
        }
        if ("boolean".equals(typeName)) {
            return 90;
        }
        if ("byte".equals(typeName)) {
            return 329;
        }
        if ("short".equals(typeName)) {
            return 585;
        }
        if ("int".equals(typeName)) {
            return 1097;
        }
        if ("long".equals(typeName)) {
            return 2121;
        }
        if ("float".equals(typeName)) {
            return 1094;
        }
        if ("double".equals(typeName)) {
            return 2118;
        }
        if ("String".equals(typeName)) {
            return 29516;
        }
        return -1;
    }

    private static final void $$robo$$com_android_internal_util_TypedProperties$parse(Reader r, Map<String, Object> map) throws ParseException, IOException {
        int token;
        StreamTokenizer st = TypedProperties.initTokenizer(r);
        String identifierPattern = "[a-zA-Z_$][0-9a-zA-Z_$]*";
        Pattern propertyNamePattern = Pattern.compile("([a-zA-Z_$][0-9a-zA-Z_$]*\\.)*[a-zA-Z_$][0-9a-zA-Z_$]*");
        while ((token = st.nextToken()) != -1) {
            if (token != -3) {
                throw new ParseException(st, "type name");
            }
            int type = TypedProperties.interpretType(st.sval);
            if (type == -1) {
                throw new ParseException(st, "valid type name");
            }
            st.sval = null;
            if (type == 120 && (token = st.nextToken()) != 40) {
                throw new ParseException(st, "'('");
            }
            token = st.nextToken();
            if (token != -3) {
                throw new ParseException(st, "property name");
            }
            String propertyName = st.sval;
            if (!propertyNamePattern.matcher(propertyName).matches()) {
                throw new ParseException(st, "valid property name");
            }
            st.sval = null;
            if (type == 120) {
                token = st.nextToken();
                if (token != 41) {
                    throw new ParseException(st, "')'");
                }
                map.remove(propertyName);
            } else {
                token = st.nextToken();
                if (token != 61) {
                    throw new ParseException(st, "'='");
                }
                Object value = TypedProperties.parseValue(st, type);
                Object oldValue = map.remove(propertyName);
                if (oldValue != null && value.getClass() != oldValue.getClass()) {
                    throw new ParseException(st, "(property previously declared as a different type)");
                }
                map.put(propertyName, value);
            }
            if ((token = st.nextToken()) == 59) continue;
            throw new ParseException(st, "';'");
        }
    }

    private static final Object $$robo$$com_android_internal_util_TypedProperties$parseValue(StreamTokenizer st, int type) throws IOException {
        int token = st.nextToken();
        if (type == 90) {
            if (token != -3) {
                throw new ParseException(st, "boolean constant");
            }
            if ("true".equals(st.sval)) {
                return Boolean.TRUE;
            }
            if ("false".equals(st.sval)) {
                return Boolean.FALSE;
            }
            throw new ParseException(st, "boolean constant");
        }
        if ((type & 0xFF) == 73) {
            long value;
            if (token != -3) {
                throw new ParseException(st, "integer constant");
            }
            try {
                value = Long.decode(st.sval);
            }
            catch (NumberFormatException ex) {
                throw new ParseException(st, "integer constant");
            }
            int width = type >> 8 & 0xFF;
            switch (width) {
                case 1: {
                    if (value < -128L || value > 127L) {
                        throw new ParseException(st, "8-bit integer constant");
                    }
                    return new Byte((byte)value);
                }
                case 2: {
                    if (value < -32768L || value > 32767L) {
                        throw new ParseException(st, "16-bit integer constant");
                    }
                    return new Short((short)value);
                }
                case 4: {
                    if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                        throw new ParseException(st, "32-bit integer constant");
                    }
                    return new Integer((int)value);
                }
                case 8: {
                    if (value < Long.MIN_VALUE || value > Long.MAX_VALUE) {
                        throw new ParseException(st, "64-bit integer constant");
                    }
                    return new Long(value);
                }
            }
            throw new IllegalStateException("Internal error; unexpected integer type width " + width);
        }
        if ((type & 0xFF) == 70) {
            double value;
            if (token != -3) {
                throw new ParseException(st, "float constant");
            }
            try {
                value = Double.parseDouble(st.sval);
            }
            catch (NumberFormatException ex) {
                throw new ParseException(st, "float constant");
            }
            if ((type >> 8 & 0xFF) == 4) {
                double absValue = Math.abs(value);
                if (absValue != 0.0 && !Double.isInfinite(value) && !Double.isNaN(value) && (absValue < (double)1.4E-45f || absValue > 3.4028234663852886E38)) {
                    throw new ParseException(st, "32-bit float constant");
                }
                return new Float((float)value);
            }
            return new Double(value);
        }
        if (type == 29516) {
            if (token == 34) {
                return st.sval;
            }
            if (token == -3 && "null".equals(st.sval)) {
                return NULL_STRING;
            }
            throw new ParseException(st, "double-quoted string or 'null'");
        }
        throw new IllegalStateException("Internal error; unknown type " + type);
    }

    private void $$robo$$com_android_internal_util_TypedProperties$__constructor__() {
    }

    private final void $$robo$$com_android_internal_util_TypedProperties$load(Reader r) throws IOException {
        TypedProperties.parse(r, this);
    }

    private final Object $$robo$$com_android_internal_util_TypedProperties$get(Object key) {
        Object value = super.get(key);
        if (value == NULL_STRING) {
            return null;
        }
        return value;
    }

    private final boolean $$robo$$com_android_internal_util_TypedProperties$getBoolean(String property, boolean def) {
        Object value = super.get(property);
        if (value == null) {
            return def;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new TypeException(property, value, "boolean");
    }

    private final byte $$robo$$com_android_internal_util_TypedProperties$getByte(String property, byte def) {
        Object value = super.get(property);
        if (value == null) {
            return def;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        throw new TypeException(property, value, "byte");
    }

    private final short $$robo$$com_android_internal_util_TypedProperties$getShort(String property, short def) {
        Object value = super.get(property);
        if (value == null) {
            return def;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        throw new TypeException(property, value, "short");
    }

    private final int $$robo$$com_android_internal_util_TypedProperties$getInt(String property, int def) {
        Object value = super.get(property);
        if (value == null) {
            return def;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new TypeException(property, value, "int");
    }

    private final long $$robo$$com_android_internal_util_TypedProperties$getLong(String property, long def) {
        Object value = super.get(property);
        if (value == null) {
            return def;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new TypeException(property, value, "long");
    }

    private final float $$robo$$com_android_internal_util_TypedProperties$getFloat(String property, float def) {
        Object value = super.get(property);
        if (value == null) {
            return def;
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        throw new TypeException(property, value, "float");
    }

    private final double $$robo$$com_android_internal_util_TypedProperties$getDouble(String property, double def) {
        Object value = super.get(property);
        if (value == null) {
            return def;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new TypeException(property, value, "double");
    }

    private final String $$robo$$com_android_internal_util_TypedProperties$getString(String property, String def) {
        Object value = super.get(property);
        if (value == null) {
            return def;
        }
        if (value == NULL_STRING) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new TypeException(property, value, "string");
    }

    private final boolean $$robo$$com_android_internal_util_TypedProperties$getBoolean(String property) {
        return this.getBoolean(property, false);
    }

    private final byte $$robo$$com_android_internal_util_TypedProperties$getByte(String property) {
        return this.getByte(property, (byte)0);
    }

    private final short $$robo$$com_android_internal_util_TypedProperties$getShort(String property) {
        return this.getShort(property, (short)0);
    }

    private final int $$robo$$com_android_internal_util_TypedProperties$getInt(String property) {
        return this.getInt(property, 0);
    }

    private final long $$robo$$com_android_internal_util_TypedProperties$getLong(String property) {
        return this.getLong(property, 0L);
    }

    private final float $$robo$$com_android_internal_util_TypedProperties$getFloat(String property) {
        return this.getFloat(property, 0.0f);
    }

    private final double $$robo$$com_android_internal_util_TypedProperties$getDouble(String property) {
        return this.getDouble(property, 0.0);
    }

    private final String $$robo$$com_android_internal_util_TypedProperties$getString(String property) {
        return this.getString(property, "");
    }

    private final int $$robo$$com_android_internal_util_TypedProperties$getStringInfo(String property) {
        Object value = super.get(property);
        if (value == null) {
            return -1;
        }
        if (value == NULL_STRING) {
            return 0;
        }
        if (value instanceof String) {
            return 1;
        }
        return -2;
    }

    static void __staticInitializer__() {
        NULL_STRING = new String("<TypedProperties:NULL_STRING>");
    }

    static StreamTokenizer initTokenizer(Reader reader) {
        return InvokeDynamicSupport.bootstrapStatic("initTokenizer", $$robo$$com_android_internal_util_TypedProperties$initTokenizer(java.io.Reader ), (Reader)reader);
    }

    static int interpretType(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("interpretType", $$robo$$com_android_internal_util_TypedProperties$interpretType(java.lang.String ), (String)string2);
    }

    static void parse(Reader reader, Map<String, Object> map) throws ParseException, IOException {
        InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$com_android_internal_util_TypedProperties$parse(java.io.Reader java.util.Map<java.lang.String, java.lang.Object> ), (Reader)reader, map);
    }

    static Object parseValue(StreamTokenizer streamTokenizer, int n) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("parseValue", $$robo$$com_android_internal_util_TypedProperties$parseValue(java.io.StreamTokenizer int ), (StreamTokenizer)streamTokenizer, (int)n);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_TypedProperties$__constructor__();
    }

    public TypedProperties() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_TypedProperties$__constructor__(), this);
    }

    public void load(Reader reader) throws IOException {
        InvokeDynamicSupport.bootstrap("load", $$robo$$com_android_internal_util_TypedProperties$load(java.io.Reader ), this, reader);
    }

    @Override
    public Object get(Object object) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$com_android_internal_util_TypedProperties$get(java.lang.Object ), this, object);
    }

    public boolean getBoolean(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$com_android_internal_util_TypedProperties$getBoolean(java.lang.String boolean ), this, string2, bl);
    }

    public byte getByte(String string2, byte by) {
        return (byte)InvokeDynamicSupport.bootstrap("getByte", $$robo$$com_android_internal_util_TypedProperties$getByte(java.lang.String byte ), this, string2, by);
    }

    public short getShort(String string2, short s) {
        return (short)InvokeDynamicSupport.bootstrap("getShort", $$robo$$com_android_internal_util_TypedProperties$getShort(java.lang.String short ), this, string2, s);
    }

    public int getInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$com_android_internal_util_TypedProperties$getInt(java.lang.String int ), this, string2, n);
    }

    public long getLong(String string2, long l) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$com_android_internal_util_TypedProperties$getLong(java.lang.String long ), this, string2, l);
    }

    public float getFloat(String string2, float f) {
        return (float)InvokeDynamicSupport.bootstrap("getFloat", $$robo$$com_android_internal_util_TypedProperties$getFloat(java.lang.String float ), this, string2, f);
    }

    public double getDouble(String string2, double d) {
        return (double)InvokeDynamicSupport.bootstrap("getDouble", $$robo$$com_android_internal_util_TypedProperties$getDouble(java.lang.String double ), this, string2, d);
    }

    public String getString(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$com_android_internal_util_TypedProperties$getString(java.lang.String java.lang.String ), this, string2, string3);
    }

    public boolean getBoolean(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$com_android_internal_util_TypedProperties$getBoolean(java.lang.String ), this, string2);
    }

    public byte getByte(String string2) {
        return (byte)InvokeDynamicSupport.bootstrap("getByte", $$robo$$com_android_internal_util_TypedProperties$getByte(java.lang.String ), this, string2);
    }

    public short getShort(String string2) {
        return (short)InvokeDynamicSupport.bootstrap("getShort", $$robo$$com_android_internal_util_TypedProperties$getShort(java.lang.String ), this, string2);
    }

    public int getInt(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$com_android_internal_util_TypedProperties$getInt(java.lang.String ), this, string2);
    }

    public long getLong(String string2) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$com_android_internal_util_TypedProperties$getLong(java.lang.String ), this, string2);
    }

    public float getFloat(String string2) {
        return (float)InvokeDynamicSupport.bootstrap("getFloat", $$robo$$com_android_internal_util_TypedProperties$getFloat(java.lang.String ), this, string2);
    }

    public double getDouble(String string2) {
        return (double)InvokeDynamicSupport.bootstrap("getDouble", $$robo$$com_android_internal_util_TypedProperties$getDouble(java.lang.String ), this, string2);
    }

    public String getString(String string2) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$com_android_internal_util_TypedProperties$getString(java.lang.String ), this, string2);
    }

    public int getStringInfo(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getStringInfo", $$robo$$com_android_internal_util_TypedProperties$getStringInfo(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(TypedProperties.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TypedProperties)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TypeException
    extends IllegalArgumentException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_util_TypedProperties_TypeException$__constructor__(String property, Object value, String requestedType) {
        }

        private void __constructor__(String string2, Object object, String string3) {
            this.$$robo$$com_android_internal_util_TypedProperties_TypeException$__constructor__(string2, object, string3);
        }

        public TypeException(String string2, Object object, String string3) {
            super(string2 + " has type " + object.getClass().getName() + ", not " + string3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_TypedProperties_TypeException$__constructor__(java.lang.String java.lang.Object java.lang.String ), this, string2, object, string3);
        }

        public /* synthetic */ TypeException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TypeException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParseException
    extends IllegalArgumentException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_util_TypedProperties_ParseException$__constructor__(StreamTokenizer state, String expected) {
        }

        private void __constructor__(StreamTokenizer streamTokenizer, String string2) {
            this.$$robo$$com_android_internal_util_TypedProperties_ParseException$__constructor__(streamTokenizer, string2);
        }

        public ParseException(StreamTokenizer streamTokenizer, String string2) {
            super("expected " + string2 + ", saw " + streamTokenizer.toString());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_TypedProperties_ParseException$__constructor__(java.io.StreamTokenizer java.lang.String ), this, streamTokenizer, string2);
        }

        public /* synthetic */ ParseException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParseException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

