/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.text.TextUtils;
import java.util.Collection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Preconditions
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;

    private void $$robo$$com_android_internal_util_Preconditions$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_util_Preconditions$checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    private static final void $$robo$$com_android_internal_util_Preconditions$checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    private static final void $$robo$$com_android_internal_util_Preconditions$checkArgument(boolean expression, String messageTemplate, Object ... messageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(messageTemplate, messageArgs));
        }
    }

    private static final <T extends CharSequence> T $$robo$$com_android_internal_util_Preconditions$checkStringNotEmpty(T string2) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException();
        }
        return string2;
    }

    private static final <T extends CharSequence> T $$robo$$com_android_internal_util_Preconditions$checkStringNotEmpty(T string2, Object errorMessage) {
        if (TextUtils.isEmpty(string2)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return string2;
    }

    private static final <T> T $$robo$$com_android_internal_util_Preconditions$checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    private static final <T> T $$robo$$com_android_internal_util_Preconditions$checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    private static final <T> T $$robo$$com_android_internal_util_Preconditions$checkNotNull(T reference, String messageTemplate, Object ... messageArgs) {
        if (reference == null) {
            throw new NullPointerException(String.format(messageTemplate, messageArgs));
        }
        return reference;
    }

    private static final void $$robo$$com_android_internal_util_Preconditions$checkState(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    private static final void $$robo$$com_android_internal_util_Preconditions$checkState(boolean expression) {
        Preconditions.checkState(expression, null);
    }

    private static final int $$robo$$com_android_internal_util_Preconditions$checkFlagsArgument(int requestedFlags, int allowedFlags) {
        if ((requestedFlags & allowedFlags) != requestedFlags) {
            throw new IllegalArgumentException("Requested flags 0x" + Integer.toHexString(requestedFlags) + ", but only 0x" + Integer.toHexString(allowedFlags) + " are allowed");
        }
        return requestedFlags;
    }

    private static final int $$robo$$com_android_internal_util_Preconditions$checkArgumentNonnegative(int value, String errorMessage) {
        if (value < 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    private static final int $$robo$$com_android_internal_util_Preconditions$checkArgumentNonnegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    private static final long $$robo$$com_android_internal_util_Preconditions$checkArgumentNonnegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException();
        }
        return value;
    }

    private static final long $$robo$$com_android_internal_util_Preconditions$checkArgumentNonnegative(long value, String errorMessage) {
        if (value < 0L) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    private static final int $$robo$$com_android_internal_util_Preconditions$checkArgumentPositive(int value, String errorMessage) {
        if (value <= 0) {
            throw new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    private static final float $$robo$$com_android_internal_util_Preconditions$checkArgumentFinite(float value, String valueName) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException(valueName + " must not be NaN");
        }
        if (Float.isInfinite(value)) {
            throw new IllegalArgumentException(valueName + " must not be infinite");
        }
        return value;
    }

    private static final float $$robo$$com_android_internal_util_Preconditions$checkArgumentInRange(float value, float lower, float upper, String valueName) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException(valueName + " must not be NaN");
        }
        if (value < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too low)", valueName, Float.valueOf(lower), Float.valueOf(upper)));
        }
        if (value > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%f, %f] (too high)", valueName, Float.valueOf(lower), Float.valueOf(upper)));
        }
        return value;
    }

    private static final int $$robo$$com_android_internal_util_Preconditions$checkArgumentInRange(int value, int lower, int upper, String valueName) {
        if (value < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too low)", valueName, lower, upper));
        }
        if (value > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too high)", valueName, lower, upper));
        }
        return value;
    }

    private static final long $$robo$$com_android_internal_util_Preconditions$checkArgumentInRange(long value, long lower, long upper, String valueName) {
        if (value < lower) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too low)", valueName, lower, upper));
        }
        if (value > upper) {
            throw new IllegalArgumentException(String.format("%s is out of range of [%d, %d] (too high)", valueName, lower, upper));
        }
        return value;
    }

    private static final <T> T[] $$robo$$com_android_internal_util_Preconditions$checkArrayElementsNotNull(T[] value, String valueName) {
        if (value == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        for (int i = 0; i < value.length; ++i) {
            if (value[i] != null) continue;
            throw new NullPointerException(String.format("%s[%d] must not be null", valueName, i));
        }
        return value;
    }

    private static final <C extends Collection<T>, T> C $$robo$$com_android_internal_util_Preconditions$checkCollectionElementsNotNull(C value, String valueName) {
        if (value == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        long ctr = 0L;
        for (T elem : value) {
            if (elem == null) {
                throw new NullPointerException(String.format("%s[%d] must not be null", valueName, ctr));
            }
            ++ctr;
        }
        return value;
    }

    private static final <T> Collection<T> $$robo$$com_android_internal_util_Preconditions$checkCollectionNotEmpty(Collection<T> value, String valueName) {
        if (value == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException(valueName + " is empty");
        }
        return value;
    }

    private static final float[] $$robo$$com_android_internal_util_Preconditions$checkArrayElementsInRange(float[] value, float lower, float upper, String valueName) {
        Preconditions.checkNotNull(value, valueName + " must not be null");
        for (int i = 0; i < value.length; ++i) {
            float v = value[i];
            if (Float.isNaN(v)) {
                throw new IllegalArgumentException(valueName + "[" + i + "] must not be NaN");
            }
            if (v < lower) {
                throw new IllegalArgumentException(String.format("%s[%d] is out of range of [%f, %f] (too low)", valueName, i, Float.valueOf(lower), Float.valueOf(upper)));
            }
            if (!(v > upper)) continue;
            throw new IllegalArgumentException(String.format("%s[%d] is out of range of [%f, %f] (too high)", valueName, i, Float.valueOf(lower), Float.valueOf(upper)));
        }
        return value;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_Preconditions$__constructor__();
    }

    public Preconditions() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_Preconditions$__constructor__(), this);
    }

    public static void checkArgument(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("checkArgument", $$robo$$com_android_internal_util_Preconditions$checkArgument(boolean ), (boolean)bl);
    }

    public static void checkArgument(boolean bl, Object object) {
        InvokeDynamicSupport.bootstrapStatic("checkArgument", $$robo$$com_android_internal_util_Preconditions$checkArgument(boolean java.lang.Object ), (boolean)bl, (Object)object);
    }

    public static void checkArgument(boolean bl, String string2, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("checkArgument", $$robo$$com_android_internal_util_Preconditions$checkArgument(boolean java.lang.String java.lang.Object[] ), (boolean)bl, (String)string2, (Object[])objectArray);
    }

    public static <T extends CharSequence> T checkStringNotEmpty(T t) {
        return (T)InvokeDynamicSupport.bootstrapStatic("checkStringNotEmpty", $$robo$$com_android_internal_util_Preconditions$checkStringNotEmpty(T ), t);
    }

    public static <T extends CharSequence> T checkStringNotEmpty(T t, Object object) {
        return (T)InvokeDynamicSupport.bootstrapStatic("checkStringNotEmpty", $$robo$$com_android_internal_util_Preconditions$checkStringNotEmpty(T java.lang.Object ), t, (Object)object);
    }

    public static <T> T checkNotNull(T t) {
        return (T)InvokeDynamicSupport.bootstrapStatic("checkNotNull", $$robo$$com_android_internal_util_Preconditions$checkNotNull(T ), t);
    }

    public static <T> T checkNotNull(T t, Object object) {
        return (T)InvokeDynamicSupport.bootstrapStatic("checkNotNull", $$robo$$com_android_internal_util_Preconditions$checkNotNull(T java.lang.Object ), t, (Object)object);
    }

    public static <T> T checkNotNull(T t, String string2, Object ... objectArray) {
        return (T)InvokeDynamicSupport.bootstrapStatic("checkNotNull", $$robo$$com_android_internal_util_Preconditions$checkNotNull(T java.lang.String java.lang.Object[] ), t, (String)string2, (Object[])objectArray);
    }

    public static void checkState(boolean bl, String string2) {
        InvokeDynamicSupport.bootstrapStatic("checkState", $$robo$$com_android_internal_util_Preconditions$checkState(boolean java.lang.String ), (boolean)bl, (String)string2);
    }

    public static void checkState(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("checkState", $$robo$$com_android_internal_util_Preconditions$checkState(boolean ), (boolean)bl);
    }

    public static int checkFlagsArgument(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkFlagsArgument", $$robo$$com_android_internal_util_Preconditions$checkFlagsArgument(int int ), (int)n, (int)n2);
    }

    public static int checkArgumentNonnegative(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkArgumentNonnegative", $$robo$$com_android_internal_util_Preconditions$checkArgumentNonnegative(int java.lang.String ), (int)n, (String)string2);
    }

    public static int checkArgumentNonnegative(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkArgumentNonnegative", $$robo$$com_android_internal_util_Preconditions$checkArgumentNonnegative(int ), (int)n);
    }

    public static long checkArgumentNonnegative(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("checkArgumentNonnegative", $$robo$$com_android_internal_util_Preconditions$checkArgumentNonnegative(long ), (long)l);
    }

    public static long checkArgumentNonnegative(long l, String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("checkArgumentNonnegative", $$robo$$com_android_internal_util_Preconditions$checkArgumentNonnegative(long java.lang.String ), (long)l, (String)string2);
    }

    public static int checkArgumentPositive(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkArgumentPositive", $$robo$$com_android_internal_util_Preconditions$checkArgumentPositive(int java.lang.String ), (int)n, (String)string2);
    }

    public static float checkArgumentFinite(float f, String string2) {
        return (float)InvokeDynamicSupport.bootstrapStatic("checkArgumentFinite", $$robo$$com_android_internal_util_Preconditions$checkArgumentFinite(float java.lang.String ), (float)f, (String)string2);
    }

    public static float checkArgumentInRange(float f, float f2, float f3, String string2) {
        return (float)InvokeDynamicSupport.bootstrapStatic("checkArgumentInRange", $$robo$$com_android_internal_util_Preconditions$checkArgumentInRange(float float float java.lang.String ), (float)f, (float)f2, (float)f3, (String)string2);
    }

    public static int checkArgumentInRange(int n, int n2, int n3, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkArgumentInRange", $$robo$$com_android_internal_util_Preconditions$checkArgumentInRange(int int int java.lang.String ), (int)n, (int)n2, (int)n3, (String)string2);
    }

    public static long checkArgumentInRange(long l, long l2, long l3, String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("checkArgumentInRange", $$robo$$com_android_internal_util_Preconditions$checkArgumentInRange(long long long java.lang.String ), (long)l, (long)l2, (long)l3, (String)string2);
    }

    public static <T> T[] checkArrayElementsNotNull(T[] TArray, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("checkArrayElementsNotNull", $$robo$$com_android_internal_util_Preconditions$checkArrayElementsNotNull(T[] java.lang.String ), (Object[])TArray, (String)string2);
    }

    public static <C extends Collection<T>, T> C checkCollectionElementsNotNull(C c, String string2) {
        return (C)InvokeDynamicSupport.bootstrapStatic("checkCollectionElementsNotNull", $$robo$$com_android_internal_util_Preconditions$checkCollectionElementsNotNull(C java.lang.String ), c, (String)string2);
    }

    public static <T> Collection<T> checkCollectionNotEmpty(Collection<T> collection, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("checkCollectionNotEmpty", $$robo$$com_android_internal_util_Preconditions$checkCollectionNotEmpty(java.util.Collection<T> java.lang.String ), collection, (String)string2);
    }

    public static float[] checkArrayElementsInRange(float[] fArray, float f, float f2, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("checkArrayElementsInRange", $$robo$$com_android_internal_util_Preconditions$checkArrayElementsInRange(float[] float float java.lang.String ), (float[])fArray, (float)f, (float)f2, (String)string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Preconditions)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

