/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.os.FileUtils;
import com.android.internal.util.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import libcore.io.IoUtils;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FileRotator
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "FileRotator";
    private static boolean LOGD = false;
    private File mBasePath;
    private String mPrefix;
    private long mRotateAgeMillis;
    private long mDeleteAgeMillis;
    private static String SUFFIX_BACKUP = ".backup";
    private static String SUFFIX_NO_BACKUP = ".no_backup";

    private void $$robo$$com_android_internal_util_FileRotator$__constructor__(File basePath, String prefix, long rotateAgeMillis, long deleteAgeMillis) {
        this.mBasePath = Preconditions.checkNotNull(basePath);
        this.mPrefix = Preconditions.checkNotNull(prefix);
        this.mRotateAgeMillis = rotateAgeMillis;
        this.mDeleteAgeMillis = deleteAgeMillis;
        this.mBasePath.mkdirs();
        for (String name : this.mBasePath.list()) {
            File file;
            if (!name.startsWith(this.mPrefix)) continue;
            if (name.endsWith(".backup")) {
                File backupFile = new File(this.mBasePath, name);
                file = new File(this.mBasePath, name.substring(0, name.length() - ".backup".length()));
                backupFile.renameTo(file);
                continue;
            }
            if (!name.endsWith(".no_backup")) continue;
            File noBackupFile = new File(this.mBasePath, name);
            file = new File(this.mBasePath, name.substring(0, name.length() - ".no_backup".length()));
            noBackupFile.delete();
            file.delete();
        }
    }

    private final void $$robo$$com_android_internal_util_FileRotator$deleteAll() {
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name)) continue;
            new File(this.mBasePath, name).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_util_FileRotator$dumpAll(OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        try {
            FileInfo info = new FileInfo(this.mPrefix);
            for (String name : this.mBasePath.list()) {
                if (!info.parse(name)) continue;
                ZipEntry entry = new ZipEntry(name);
                zos.putNextEntry(entry);
                File file = new File(this.mBasePath, name);
                FileInputStream is = new FileInputStream(file);
                try {
                    Streams.copy(is, zos);
                }
                finally {
                    IoUtils.closeQuietly(is);
                }
                zos.closeEntry();
            }
        }
        finally {
            IoUtils.closeQuietly(zos);
        }
    }

    private final void $$robo$$com_android_internal_util_FileRotator$rewriteActive(Rewriter rewriter, long currentTimeMillis) throws IOException {
        String activeName = this.getActiveName(currentTimeMillis);
        this.rewriteSingle(rewriter, activeName);
    }

    @Deprecated
    private final void $$robo$$com_android_internal_util_FileRotator$combineActive(Reader reader, Writer writer, long currentTimeMillis) throws IOException {
        this.rewriteActive(new Rewriter(this, reader, writer){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ Reader val$reader;
            /* synthetic */ Writer val$writer;
            /* synthetic */ FileRotator this$0;

            private void $$robo$$com_android_internal_util_FileRotator_1$__constructor__(FileRotator this$0, Reader reader, Writer writer) {
                this.val$reader = reader;
                this.val$writer = writer;
            }

            private final void $$robo$$com_android_internal_util_FileRotator_1$reset() {
            }

            private final void $$robo$$com_android_internal_util_FileRotator_1$read(InputStream in) throws IOException {
                this.val$reader.read(in);
            }

            private final boolean $$robo$$com_android_internal_util_FileRotator_1$shouldWrite() {
                return true;
            }

            private final void $$robo$$com_android_internal_util_FileRotator_1$write(OutputStream out) throws IOException {
                this.val$writer.write(out);
            }

            private void __constructor__(FileRotator fileRotator, Reader reader, Writer writer) {
                this.$$robo$$com_android_internal_util_FileRotator_1$__constructor__(fileRotator, reader, writer);
            }
            {
                this.this$0 = fileRotator;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FileRotator_1$__constructor__(com.android.internal.util.FileRotator com.android.internal.util.FileRotator$Reader com.android.internal.util.FileRotator$Writer ), this, fileRotator, reader, writer);
            }

            @Override
            public void reset() {
                InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_util_FileRotator_1$reset(), this);
            }

            @Override
            public void read(InputStream inputStream) throws IOException {
                InvokeDynamicSupport.bootstrap("read", $$robo$$com_android_internal_util_FileRotator_1$read(java.io.InputStream ), this, inputStream);
            }

            @Override
            public boolean shouldWrite() {
                return (boolean)InvokeDynamicSupport.bootstrap("shouldWrite", $$robo$$com_android_internal_util_FileRotator_1$shouldWrite(), this);
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                InvokeDynamicSupport.bootstrap("write", $$robo$$com_android_internal_util_FileRotator_1$write(java.io.OutputStream ), this, outputStream);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, currentTimeMillis);
    }

    private final void $$robo$$com_android_internal_util_FileRotator$rewriteAll(Rewriter rewriter) throws IOException {
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name)) continue;
            this.rewriteSingle(rewriter, name);
        }
    }

    private final void $$robo$$com_android_internal_util_FileRotator$rewriteSingle(Rewriter rewriter, String name) throws IOException {
        File file = new File(this.mBasePath, name);
        rewriter.reset();
        if (file.exists()) {
            FileRotator.readFile(file, rewriter);
            if (!rewriter.shouldWrite()) {
                return;
            }
            File backupFile = new File(this.mBasePath, name + ".backup");
            file.renameTo(backupFile);
            try {
                FileRotator.writeFile(file, rewriter);
                backupFile.delete();
            }
            catch (Throwable t) {
                file.delete();
                backupFile.renameTo(file);
                throw FileRotator.rethrowAsIoException(t);
            }
        }
        File backupFile = new File(this.mBasePath, name + ".no_backup");
        backupFile.createNewFile();
        try {
            FileRotator.writeFile(file, rewriter);
            backupFile.delete();
        }
        catch (Throwable t) {
            file.delete();
            backupFile.delete();
            throw FileRotator.rethrowAsIoException(t);
        }
    }

    private final void $$robo$$com_android_internal_util_FileRotator$readMatching(Reader reader, long matchStartMillis, long matchEndMillis) throws IOException {
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name) || info.startMillis > matchEndMillis || matchStartMillis > info.endMillis) continue;
            File file = new File(this.mBasePath, name);
            FileRotator.readFile(file, reader);
        }
    }

    private final String $$robo$$com_android_internal_util_FileRotator$getActiveName(long currentTimeMillis) {
        String oldestActiveName = null;
        long oldestActiveStart = Long.MAX_VALUE;
        FileInfo info = new FileInfo(this.mPrefix);
        for (String name : this.mBasePath.list()) {
            if (!info.parse(name) || !info.isActive() || info.startMillis >= currentTimeMillis || info.startMillis >= oldestActiveStart) continue;
            oldestActiveName = name;
            oldestActiveStart = info.startMillis;
        }
        if (oldestActiveName != null) {
            return oldestActiveName;
        }
        info.startMillis = currentTimeMillis;
        info.endMillis = Long.MAX_VALUE;
        return info.build();
    }

    private final void $$robo$$com_android_internal_util_FileRotator$maybeRotate(long currentTimeMillis) {
        long rotateBefore = currentTimeMillis - this.mRotateAgeMillis;
        long deleteBefore = currentTimeMillis - this.mDeleteAgeMillis;
        FileInfo info = new FileInfo(this.mPrefix);
        String[] baseFiles = this.mBasePath.list();
        if (baseFiles == null) {
            return;
        }
        for (String name : baseFiles) {
            File file;
            if (!info.parse(name)) continue;
            if (info.isActive()) {
                if (info.startMillis > rotateBefore) continue;
                info.endMillis = currentTimeMillis;
                file = new File(this.mBasePath, name);
                File destFile = new File(this.mBasePath, info.build());
                file.renameTo(destFile);
                continue;
            }
            if (info.endMillis > deleteBefore) continue;
            file = new File(this.mBasePath, name);
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_util_FileRotator$readFile(File file, Reader reader) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        try {
            reader.read(bis);
        }
        finally {
            IoUtils.closeQuietly(bis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_util_FileRotator$writeFile(File file, Writer writer) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            writer.write(bos);
            bos.flush();
        }
        finally {
            FileUtils.sync(fos);
            IoUtils.closeQuietly(bos);
        }
    }

    private static final IOException $$robo$$com_android_internal_util_FileRotator$rethrowAsIoException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new IOException(t.getMessage(), t);
    }

    private void __constructor__(File file, String string2, long l, long l2) {
        this.$$robo$$com_android_internal_util_FileRotator$__constructor__(file, string2, l, l2);
    }

    public FileRotator(File file, String string2, long l, long l2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FileRotator$__constructor__(java.io.File java.lang.String long long ), this, file, string2, l, l2);
    }

    public void deleteAll() {
        InvokeDynamicSupport.bootstrap("deleteAll", $$robo$$com_android_internal_util_FileRotator$deleteAll(), this);
    }

    public void dumpAll(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("dumpAll", $$robo$$com_android_internal_util_FileRotator$dumpAll(java.io.OutputStream ), this, outputStream);
    }

    public void rewriteActive(Rewriter rewriter, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("rewriteActive", $$robo$$com_android_internal_util_FileRotator$rewriteActive(com.android.internal.util.FileRotator$Rewriter long ), this, rewriter, l);
    }

    @Deprecated
    public void combineActive(Reader reader, Writer writer, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("combineActive", $$robo$$com_android_internal_util_FileRotator$combineActive(com.android.internal.util.FileRotator$Reader com.android.internal.util.FileRotator$Writer long ), this, reader, writer, l);
    }

    public void rewriteAll(Rewriter rewriter) throws IOException {
        InvokeDynamicSupport.bootstrap("rewriteAll", $$robo$$com_android_internal_util_FileRotator$rewriteAll(com.android.internal.util.FileRotator$Rewriter ), this, rewriter);
    }

    private void rewriteSingle(Rewriter rewriter, String string2) throws IOException {
        InvokeDynamicSupport.bootstrap("rewriteSingle", $$robo$$com_android_internal_util_FileRotator$rewriteSingle(com.android.internal.util.FileRotator$Rewriter java.lang.String ), this, rewriter, string2);
    }

    public void readMatching(Reader reader, long l, long l2) throws IOException {
        InvokeDynamicSupport.bootstrap("readMatching", $$robo$$com_android_internal_util_FileRotator$readMatching(com.android.internal.util.FileRotator$Reader long long ), this, reader, l, l2);
    }

    private String getActiveName(long l) {
        return InvokeDynamicSupport.bootstrap("getActiveName", $$robo$$com_android_internal_util_FileRotator$getActiveName(long ), this, l);
    }

    public void maybeRotate(long l) {
        InvokeDynamicSupport.bootstrap("maybeRotate", $$robo$$com_android_internal_util_FileRotator$maybeRotate(long ), this, l);
    }

    private static void readFile(File file, Reader reader) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("readFile", $$robo$$com_android_internal_util_FileRotator$readFile(java.io.File com.android.internal.util.FileRotator$Reader ), (File)file, (Reader)reader);
    }

    private static void writeFile(File file, Writer writer) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeFile", $$robo$$com_android_internal_util_FileRotator$writeFile(java.io.File com.android.internal.util.FileRotator$Writer ), (File)file, (Writer)writer);
    }

    private static IOException rethrowAsIoException(Throwable throwable) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("rethrowAsIoException", $$robo$$com_android_internal_util_FileRotator$rethrowAsIoException(java.lang.Throwable ), (Throwable)throwable);
    }

    public /* synthetic */ FileRotator() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileRotator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class FileInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String prefix;
        public long startMillis;
        public long endMillis;

        private void $$robo$$com_android_internal_util_FileRotator_FileInfo$__constructor__(String prefix) {
            this.prefix = Preconditions.checkNotNull(prefix);
        }

        private final boolean $$robo$$com_android_internal_util_FileRotator_FileInfo$parse(String name) {
            this.endMillis = -1L;
            this.startMillis = -1L;
            int dotIndex = name.lastIndexOf(46);
            int dashIndex = name.lastIndexOf(45);
            if (dotIndex == -1 || dashIndex == -1) {
                return false;
            }
            if (!this.prefix.equals(name.substring(0, dotIndex))) {
                return false;
            }
            try {
                this.startMillis = Long.parseLong(name.substring(dotIndex + 1, dashIndex));
                this.endMillis = name.length() - dashIndex == 1 ? Long.MAX_VALUE : Long.parseLong(name.substring(dashIndex + 1));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private final String $$robo$$com_android_internal_util_FileRotator_FileInfo$build() {
            StringBuilder name = new StringBuilder();
            name.append(this.prefix).append('.').append(this.startMillis).append('-');
            if (this.endMillis != Long.MAX_VALUE) {
                name.append(this.endMillis);
            }
            return name.toString();
        }

        private final boolean $$robo$$com_android_internal_util_FileRotator_FileInfo$isActive() {
            return this.endMillis == Long.MAX_VALUE;
        }

        private void __constructor__(String string2) {
            this.$$robo$$com_android_internal_util_FileRotator_FileInfo$__constructor__(string2);
        }

        public FileInfo(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_FileRotator_FileInfo$__constructor__(java.lang.String ), this, string2);
        }

        public boolean parse(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("parse", $$robo$$com_android_internal_util_FileRotator_FileInfo$parse(java.lang.String ), this, string2);
        }

        public String build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$com_android_internal_util_FileRotator_FileInfo$build(), this);
        }

        public boolean isActive() {
            return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$com_android_internal_util_FileRotator_FileInfo$isActive(), this);
        }

        public /* synthetic */ FileInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Rewriter
    extends Reader,
    Writer,
    InstrumentedInterface {
        public void reset();

        public boolean shouldWrite();
    }

    public static interface Writer
    extends InstrumentedInterface {
        public void write(OutputStream var1) throws IOException;
    }

    public static interface Reader
    extends InstrumentedInterface {
        public void read(InputStream var1) throws IOException;
    }
}

