/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.util;

import android.app.NotificationChannel;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.util.NotificationChannelController;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class VoicemailNotificationSettingsUtil
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String VOICEMAIL_NOTIFICATION_RINGTONE_SHARED_PREFS_KEY_PREFIX = "voicemail_notification_ringtone_";
    private static String VOICEMAIL_NOTIFICATION_VIBRATION_SHARED_PREFS_KEY_PREFIX = "voicemail_notification_vibrate_";
    private static String OLD_VOICEMAIL_NOTIFICATION_RINGTONE_SHARED_PREFS_KEY = "button_voicemail_notification_ringtone_key";
    private static String OLD_VOICEMAIL_NOTIFICATION_VIBRATION_SHARED_PREFS_KEY = "button_voicemail_notification_vibrate_key";
    private static String OLD_VOICEMAIL_VIBRATE_WHEN_SHARED_PREFS_KEY = "button_voicemail_notification_vibrate_when_key";
    private static String OLD_VOICEMAIL_RINGTONE_SHARED_PREFS_KEY = "button_voicemail_notification_ringtone_key";
    private static String OLD_VOICEMAIL_VIBRATION_ALWAYS = "always";
    private static String OLD_VOICEMAIL_VIBRATION_NEVER = "never";

    private void $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$setVibrationEnabled(Context context, boolean isEnabled) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean(VoicemailNotificationSettingsUtil.getVoicemailVibrationSharedPrefsKey(), isEnabled);
        editor.commit();
    }

    private static final boolean $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$isVibrationEnabled(Context context) {
        NotificationChannel channel = NotificationChannelController.getChannel("voiceMail", context);
        return channel != null ? channel.shouldVibrate() : VoicemailNotificationSettingsUtil.getVibrationPreference(context);
    }

    private static final boolean $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$getVibrationPreference(Context context) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        VoicemailNotificationSettingsUtil.migrateVoicemailVibrationSettingsIfNeeded(context, prefs);
        return prefs.getBoolean(VoicemailNotificationSettingsUtil.getVoicemailVibrationSharedPrefsKey(), false);
    }

    private static final void $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$setRingtoneUri(Context context, Uri ringtoneUri) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        String ringtoneUriStr = ringtoneUri != null ? ringtoneUri.toString() : "";
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(VoicemailNotificationSettingsUtil.getVoicemailRingtoneSharedPrefsKey(), ringtoneUriStr);
        editor.commit();
    }

    private static final Uri $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$getRingtoneUri(Context context) {
        NotificationChannel channel = NotificationChannelController.getChannel("voiceMail", context);
        return channel != null ? channel.getSound() : VoicemailNotificationSettingsUtil.getRingTonePreference(context);
    }

    private static final Uri $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$getRingTonePreference(Context context) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
        VoicemailNotificationSettingsUtil.migrateVoicemailRingtoneSettingsIfNeeded(context, prefs);
        String uriString = prefs.getString(VoicemailNotificationSettingsUtil.getVoicemailRingtoneSharedPrefsKey(), Settings.System.DEFAULT_NOTIFICATION_URI.toString());
        return !TextUtils.isEmpty(uriString) ? Uri.parse(uriString) : null;
    }

    private static final void $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$migrateVoicemailVibrationSettingsIfNeeded(Context context, SharedPreferences prefs) {
        String key = VoicemailNotificationSettingsUtil.getVoicemailVibrationSharedPrefsKey();
        TelephonyManager telephonyManager = TelephonyManager.from(context);
        if (prefs.contains(key) || telephonyManager.getPhoneCount() != 1) {
            return;
        }
        if (prefs.contains("button_voicemail_notification_vibrate_key")) {
            boolean voicemailVibrate = prefs.getBoolean("button_voicemail_notification_vibrate_key", false);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putBoolean(key, voicemailVibrate).remove("button_voicemail_notification_vibrate_when_key").commit();
        }
        if (prefs.contains("button_voicemail_notification_vibrate_when_key")) {
            String vibrateWhen = prefs.getString("button_voicemail_notification_vibrate_when_key", "never");
            boolean voicemailVibrate = vibrateWhen.equals("always");
            SharedPreferences.Editor editor = prefs.edit();
            editor.putBoolean(key, voicemailVibrate).remove("button_voicemail_notification_vibrate_key").commit();
        }
    }

    private static final void $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$migrateVoicemailRingtoneSettingsIfNeeded(Context context, SharedPreferences prefs) {
        String key = VoicemailNotificationSettingsUtil.getVoicemailRingtoneSharedPrefsKey();
        TelephonyManager telephonyManager = TelephonyManager.from(context);
        if (prefs.contains(key) || telephonyManager.getPhoneCount() != 1) {
            return;
        }
        if (prefs.contains("button_voicemail_notification_ringtone_key")) {
            String uriString = prefs.getString("button_voicemail_notification_ringtone_key", null);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(key, uriString).remove("button_voicemail_notification_ringtone_key").commit();
        }
    }

    private static final String $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$getVoicemailVibrationSharedPrefsKey() {
        return "voicemail_notification_vibrate_" + SubscriptionManager.getDefaultSubscriptionId();
    }

    private static final String $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$getVoicemailRingtoneSharedPrefsKey() {
        return "voicemail_notification_ringtone_" + SubscriptionManager.getDefaultSubscriptionId();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$__constructor__();
    }

    public VoicemailNotificationSettingsUtil() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$__constructor__(), this);
    }

    public static void setVibrationEnabled(Context context, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setVibrationEnabled", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$setVibrationEnabled(android.content.Context boolean ), (Context)context, (boolean)bl);
    }

    public static boolean isVibrationEnabled(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isVibrationEnabled", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$isVibrationEnabled(android.content.Context ), (Context)context);
    }

    public static boolean getVibrationPreference(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getVibrationPreference", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$getVibrationPreference(android.content.Context ), (Context)context);
    }

    public static void setRingtoneUri(Context context, Uri uri) {
        InvokeDynamicSupport.bootstrapStatic("setRingtoneUri", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$setRingtoneUri(android.content.Context android.net.Uri ), (Context)context, (Uri)uri);
    }

    public static Uri getRingtoneUri(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getRingtoneUri", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$getRingtoneUri(android.content.Context ), (Context)context);
    }

    public static Uri getRingTonePreference(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getRingTonePreference", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$getRingTonePreference(android.content.Context ), (Context)context);
    }

    private static void migrateVoicemailVibrationSettingsIfNeeded(Context context, SharedPreferences sharedPreferences) {
        InvokeDynamicSupport.bootstrapStatic("migrateVoicemailVibrationSettingsIfNeeded", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$migrateVoicemailVibrationSettingsIfNeeded(android.content.Context android.content.SharedPreferences ), (Context)context, (SharedPreferences)sharedPreferences);
    }

    private static void migrateVoicemailRingtoneSettingsIfNeeded(Context context, SharedPreferences sharedPreferences) {
        InvokeDynamicSupport.bootstrapStatic("migrateVoicemailRingtoneSettingsIfNeeded", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$migrateVoicemailRingtoneSettingsIfNeeded(android.content.Context android.content.SharedPreferences ), (Context)context, (SharedPreferences)sharedPreferences);
    }

    private static String getVoicemailVibrationSharedPrefsKey() {
        return InvokeDynamicSupport.bootstrapStatic("getVoicemailVibrationSharedPrefsKey", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$getVoicemailVibrationSharedPrefsKey());
    }

    private static String getVoicemailRingtoneSharedPrefsKey() {
        return InvokeDynamicSupport.bootstrapStatic("getVoicemailRingtoneSharedPrefsKey", $$robo$$com_android_internal_telephony_util_VoicemailNotificationSettingsUtil$getVoicemailRingtoneSharedPrefsKey());
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VoicemailNotificationSettingsUtil)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

