/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telecom.ConferenceParticipant;
import android.telecom.Connection;
import android.telecom.VideoProfile;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ims.ImsServiceProxy;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.util.SparseIntArray;
import com.android.ims.ImsCall;
import com.android.ims.ImsCallProfile;
import com.android.ims.ImsConfigListener;
import com.android.ims.ImsConnectionStateListener;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.ims.ImsMultiEndpoint;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsSuppServiceNotification;
import com.android.ims.ImsUtInterface;
import com.android.ims.internal.IImsVideoCallProvider;
import com.android.ims.internal.ImsVideoCallProviderWrapper;
import com.android.internal.os.SomeArgs;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import com.android.internal.telephony.imsphone.ImsPullCall;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsPhoneCallTracker
extends CallTracker
implements ImsPullCall,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "ImsPhoneCallTracker";
    static String VERBOSE_STATE_TAG = "IPCTState";
    private static boolean DBG = true;
    private static boolean FORCE_VERBOSE_STATE_LOGGING = false;
    private static boolean VERBOSE_STATE_LOGGING;
    private boolean[] mImsFeatureEnabled;
    private String[] mImsFeatureStrings;
    private TelephonyMetrics mMetrics;
    private BroadcastReceiver mReceiver;
    static int MAX_CONNECTIONS = 7;
    static int MAX_CONNECTIONS_PER_CALL = 5;
    private static int EVENT_HANGUP_PENDINGMO = 18;
    private static int EVENT_RESUME_BACKGROUND = 19;
    private static int EVENT_DIAL_PENDINGMO = 20;
    private static int EVENT_EXIT_ECBM_BEFORE_PENDINGMO = 21;
    private static int EVENT_VT_DATA_USAGE_UPDATE = 22;
    private static int EVENT_DATA_ENABLED_CHANGED = 23;
    private static int EVENT_GET_IMS_SERVICE = 24;
    private static int EVENT_CHECK_FOR_WIFI_HANDOVER = 25;
    private static int EVENT_ON_FEATURE_CAPABILITY_CHANGED = 26;
    private static int TIMEOUT_HANGUP_PENDINGMO = 500;
    private static int IMS_RETRY_STARTING_TIMEOUT_MS = 500;
    private static int CEILING_SERVICE_RETRY_COUNT = 6;
    private static int HANDOVER_TO_WIFI_TIMEOUT_MS = 60000;
    private ArrayList<ImsPhoneConnection> mConnections;
    private RegistrantList mVoiceCallEndedRegistrants;
    private RegistrantList mVoiceCallStartedRegistrants;
    public ImsPhoneCall mRingingCall;
    public ImsPhoneCall mForegroundCall;
    public ImsPhoneCall mBackgroundCall;
    public ImsPhoneCall mHandoverCall;
    private HashMap<Integer, Long> mVtDataUsageMap;
    private volatile long mTotalVtDataUsage;
    private ImsPhoneConnection mPendingMO;
    private int mClirMode;
    private Object mSyncHold;
    private ImsCall mUssdSession;
    private Message mPendingUssd;
    ImsPhone mPhone;
    private boolean mDesiredMute;
    private boolean mOnHoldToneStarted;
    private int mOnHoldToneId;
    private PhoneConstants.State mState;
    private int mImsServiceRetryCount;
    private ImsManager mImsManager;
    private int mServiceId;
    private Call.SrvccState mSrvccState;
    private boolean mIsInEmergencyCall;
    private boolean mIsDataEnabled;
    private int pendingCallClirMode;
    private int mPendingCallVideoState;
    private Bundle mPendingIntentExtras;
    private boolean pendingCallInEcm;
    private boolean mSwitchingFgAndBgCalls;
    private ImsCall mCallExpectedToResume;
    private boolean mAllowEmergencyVideoCalls;
    private boolean mIgnoreDataEnabledChangedForVideoCalls;
    private List<PhoneStateListener> mPhoneStateListeners;
    private boolean mTreatDowngradedVideoCallsAsVideoCalls;
    private boolean mDropVideoCallWhenAnsweringAudioCall;
    private boolean mAllowAddCallDuringVideoCall;
    private boolean mNotifyVtHandoverToWifiFail;
    private boolean mSupportDowngradeVtToAudio;
    private static SparseIntArray PRECISE_CAUSE_MAP;
    private boolean mNotifyHandoverVideoFromWifiToLTE;
    private boolean mSupportPauseVideo;
    private Map<Pair<Integer, String>, Integer> mImsReasonCodeMap;
    private boolean mShouldUpdateImsConfigOnDisconnect;
    private ImsServiceProxy.INotifyStatusChanged mNotifyStatusChangedCallback;
    public IRetryTimeout mRetryTimeout;
    private ImsCall.Listener mImsCallListener;
    private ImsCall.Listener mImsUssdListener;
    private ImsConnectionStateListener mImsConnectionStateListener;
    private ImsConfigListener.Stub mImsConfigListener;

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$__constructor__(ImsPhone phone) {
        this.mImsFeatureEnabled = new boolean[]{false, false, false, false, false, false};
        this.mImsFeatureStrings = new String[]{"VoLTE", "ViLTE", "VoWiFi", "ViWiFi", "UTLTE", "UTWiFi"};
        this.mReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$onReceive(Context context, Intent intent) {
                int subId;
                if (intent.getAction().equals("com.android.ims.IMS_INCOMING_CALL")) {
                    this.this$0.log("onReceive : incoming call intent");
                    if (this.this$0.mImsManager == null) {
                        return;
                    }
                    if (this.this$0.mServiceId < 0) {
                        return;
                    }
                    try {
                        ImsCall activeCall;
                        boolean isUssd = intent.getBooleanExtra("android:ussd", false);
                        if (isUssd) {
                            this.this$0.log("onReceive : USSD");
                            this.this$0.mUssdSession = this.this$0.mImsManager.takeCall(this.this$0.mServiceId, intent, this.this$0.mImsUssdListener);
                            if (this.this$0.mUssdSession != null) {
                                this.this$0.mUssdSession.accept(2);
                            }
                            return;
                        }
                        boolean isUnknown = intent.getBooleanExtra("android:isUnknown", false);
                        this.this$0.log("onReceive : isUnknown = " + isUnknown + " fg = " + (Object)((Object)this.this$0.mForegroundCall.getState()) + " bg = " + (Object)((Object)this.this$0.mBackgroundCall.getState()));
                        ImsCall imsCall = this.this$0.mImsManager.takeCall(this.this$0.mServiceId, intent, this.this$0.mImsCallListener);
                        ImsPhoneConnection conn = new ImsPhoneConnection((Phone)this.this$0.mPhone, imsCall, this.this$0, isUnknown ? this.this$0.mForegroundCall : this.this$0.mRingingCall, isUnknown);
                        if (this.this$0.mForegroundCall.hasConnections() && (activeCall = this.this$0.mForegroundCall.getFirstConnection().getImsCall()) != null && imsCall != null) {
                            boolean answeringWillDisconnect = this.this$0.shouldDisconnectActiveCallOnAnswer(activeCall, imsCall);
                            conn.setActiveCallDisconnectedOnAnswer(answeringWillDisconnect);
                        }
                        conn.setAllowAddCallDuringVideoCall(this.this$0.mAllowAddCallDuringVideoCall);
                        this.this$0.addConnection(conn);
                        this.this$0.setVideoCallProvider(conn, imsCall);
                        TelephonyMetrics.getInstance().writeOnImsCallReceive(this.this$0.mPhone.getPhoneId(), imsCall.getSession());
                        if (isUnknown) {
                            this.this$0.mPhone.notifyUnknownConnection(conn);
                        } else {
                            if (this.this$0.mForegroundCall.getState() != Call.State.IDLE || this.this$0.mBackgroundCall.getState() != Call.State.IDLE) {
                                conn.update(imsCall, Call.State.WAITING);
                            }
                            this.this$0.mPhone.notifyNewRingingConnection(conn);
                            this.this$0.mPhone.notifyIncomingRing();
                        }
                        this.this$0.updatePhoneState();
                        this.this$0.mPhone.notifyPreciseCallStateChanged();
                    }
                    catch (ImsException e) {
                        this.this$0.loge("onReceive : exception " + e);
                    }
                    catch (RemoteException e) {}
                } else if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED") && (subId = intent.getIntExtra("subscription", -1)) == this.this$0.mPhone.getSubId()) {
                    this.this$0.cacheCarrierConfiguration(subId);
                    this.this$0.log("onReceive : Updating mAllowEmergencyVideoCalls = " + this.this$0.mAllowEmergencyVideoCalls);
                }
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), this, imsPhoneCallTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnections = new ArrayList();
        this.mVoiceCallEndedRegistrants = new RegistrantList();
        this.mVoiceCallStartedRegistrants = new RegistrantList();
        this.mRingingCall = new ImsPhoneCall(this, "RG");
        this.mForegroundCall = new ImsPhoneCall(this, "FG");
        this.mBackgroundCall = new ImsPhoneCall(this, "BG");
        this.mHandoverCall = new ImsPhoneCall(this, "HO");
        this.mVtDataUsageMap = new HashMap();
        this.mTotalVtDataUsage = 0L;
        this.mClirMode = 0;
        this.mSyncHold = new Object();
        this.mUssdSession = null;
        this.mPendingUssd = null;
        this.mDesiredMute = false;
        this.mOnHoldToneStarted = false;
        this.mOnHoldToneId = -1;
        this.mState = PhoneConstants.State.IDLE;
        this.mServiceId = -1;
        this.mSrvccState = Call.SrvccState.NONE;
        this.mIsInEmergencyCall = false;
        this.mIsDataEnabled = false;
        this.pendingCallInEcm = false;
        this.mSwitchingFgAndBgCalls = false;
        this.mCallExpectedToResume = null;
        this.mAllowEmergencyVideoCalls = false;
        this.mIgnoreDataEnabledChangedForVideoCalls = false;
        this.mPhoneStateListeners = new ArrayList<PhoneStateListener>();
        this.mTreatDowngradedVideoCallsAsVideoCalls = false;
        this.mDropVideoCallWhenAnsweringAudioCall = false;
        this.mAllowAddCallDuringVideoCall = true;
        this.mNotifyVtHandoverToWifiFail = false;
        this.mSupportDowngradeVtToAudio = false;
        this.mNotifyHandoverVideoFromWifiToLTE = false;
        this.mSupportPauseVideo = false;
        this.mImsReasonCodeMap = new ArrayMap<Pair<Integer, String>, Integer>();
        this.mShouldUpdateImsConfigOnDisconnect = false;
        this.mNotifyStatusChangedCallback = () -> {
            try {
                int status = this.mImsManager.getImsServiceStatus();
                this.log("Status Changed: " + status);
                switch (status) {
                    case 2: {
                        this.startListeningForCalls();
                        break;
                    }
                    case 0: 
                    case 1: {
                        this.stopListeningForCalls();
                        break;
                    }
                    default: {
                        Log.w("ImsPhoneCallTracker", "Unexpected State!");
                        break;
                    }
                }
            }
            catch (ImsException e) {
                this.retryGetImsService();
            }
        };
        this.mRetryTimeout = () -> {
            int timeout = (1 << this.mImsServiceRetryCount) * 500;
            if (this.mImsServiceRetryCount <= 6) {
                ++this.mImsServiceRetryCount;
            }
            return timeout;
        };
        this.mImsCallListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallProgressing(ImsCall imsCall) {
                this.this$0.log("onCallProgressing");
                this.this$0.mPendingMO = null;
                this.this$0.processCallStateChange(imsCall, Call.State.ALERTING, 0);
                this.this$0.mMetrics.writeOnImsCallProgressing(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession());
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallStarted(ImsCall imsCall) {
                this.this$0.log("onCallStarted");
                if (this.this$0.mSwitchingFgAndBgCalls && this.this$0.mCallExpectedToResume != null && this.this$0.mCallExpectedToResume == imsCall) {
                    this.this$0.log("onCallStarted: starting a call as a result of a switch.");
                    this.this$0.mSwitchingFgAndBgCalls = false;
                    this.this$0.mCallExpectedToResume = null;
                }
                this.this$0.mPendingMO = null;
                this.this$0.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
                if (this.this$0.mNotifyVtHandoverToWifiFail && !imsCall.isWifiCall() && imsCall.isVideoCall() && this.this$0.isWifiConnected()) {
                    this.this$0.sendMessageDelayed(this.this$0.obtainMessage(25, imsCall), 60000L);
                }
                this.this$0.mMetrics.writeOnImsCallStarted(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession());
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallUpdated(ImsCall imsCall) {
                this.this$0.log("onCallUpdated");
                if (imsCall == null) {
                    return;
                }
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                if (conn != null) {
                    this.this$0.processCallStateChange(imsCall, ((ImsPhoneCall)conn.getCall()).mState, 0, true);
                    this.this$0.mMetrics.writeImsCallState(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession(), ((ImsPhoneCall)conn.getCall()).mState);
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallStartFailed reasonCode=" + reasonInfo.getCode());
                if (this.this$0.mSwitchingFgAndBgCalls && this.this$0.mCallExpectedToResume != null && this.this$0.mCallExpectedToResume == imsCall) {
                    this.this$0.log("onCallStarted: starting a call as a result of a switch.");
                    this.this$0.mSwitchingFgAndBgCalls = false;
                    this.this$0.mCallExpectedToResume = null;
                }
                if (this.this$0.mPendingMO != null) {
                    if (reasonInfo.getCode() == 146 && this.this$0.mBackgroundCall.getState() == Call.State.IDLE && this.this$0.mRingingCall.getState() == Call.State.IDLE) {
                        this.this$0.mForegroundCall.detach(this.this$0.mPendingMO);
                        this.this$0.removeConnection(this.this$0.mPendingMO);
                        this.this$0.mPendingMO.finalize();
                        this.this$0.mPendingMO = null;
                        this.this$0.mPhone.initiateSilentRedial();
                        return;
                    }
                    this.this$0.mPendingMO = null;
                    int cause = this.this$0.getDisconnectCauseFromReasonInfo(reasonInfo);
                    ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                    if (conn != null) {
                        conn.setPreciseDisconnectCause(this.this$0.getPreciseDisconnectCauseFromReasonInfo(reasonInfo));
                    }
                    this.this$0.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
                    this.this$0.mMetrics.writeOnImsCallStartFailed(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                Connection.VideoProvider videoProvider;
                this.this$0.log("onCallTerminated reasonCode=" + reasonInfo.getCode());
                int cause = this.this$0.getDisconnectCauseFromReasonInfo(reasonInfo);
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                this.this$0.log("cause = " + cause + " conn = " + conn);
                if (conn != null && (videoProvider = conn.getVideoProvider()) instanceof ImsVideoCallProviderWrapper) {
                    ImsVideoCallProviderWrapper wrapper = (ImsVideoCallProviderWrapper)videoProvider;
                    wrapper.removeImsVideoProviderCallback(conn);
                }
                if (this.this$0.mOnHoldToneId == System.identityHashCode(conn)) {
                    if (conn != null && this.this$0.mOnHoldToneStarted) {
                        this.this$0.mPhone.stopOnHoldTone(conn);
                    }
                    this.this$0.mOnHoldToneStarted = false;
                    this.this$0.mOnHoldToneId = -1;
                }
                if (conn != null) {
                    if (conn.isPulledCall() && (reasonInfo.getCode() == 1015 || reasonInfo.getCode() == 336 || reasonInfo.getCode() == 332) && this.this$0.mPhone != null && this.this$0.mPhone.getExternalCallTracker() != null) {
                        this.this$0.log("Call pull failed.");
                        conn.onCallPullFailed(this.this$0.mPhone.getExternalCallTracker().getConnectionById(conn.getPulledDialogId()));
                        cause = 0;
                    } else if (conn.isIncoming() && conn.getConnectTime() == 0L && cause != 52) {
                        cause = cause == 2 ? 1 : 16;
                        this.this$0.log("Incoming connection of 0 connect time detected - translated cause = " + cause);
                    }
                }
                if (cause == 2 && conn != null && conn.getImsCall().isMerged()) {
                    cause = 45;
                }
                this.this$0.mMetrics.writeOnImsCallTerminated(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
                if (conn != null) {
                    conn.setPreciseDisconnectCause(this.this$0.getPreciseDisconnectCauseFromReasonInfo(reasonInfo));
                }
                this.this$0.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
                if (this.this$0.mForegroundCall.getState() != Call.State.ACTIVE) {
                    if (this.this$0.mRingingCall.getState().isRinging()) {
                        this.this$0.mPendingMO = null;
                    } else if (this.this$0.mPendingMO != null) {
                        this.this$0.sendEmptyMessage(20);
                    }
                }
                if (this.this$0.mSwitchingFgAndBgCalls) {
                    this.this$0.log("onCallTerminated: Call terminated in the midst of Switching Fg and Bg calls.");
                    if (imsCall == this.this$0.mCallExpectedToResume) {
                        this.this$0.log("onCallTerminated: switching " + this.this$0.mForegroundCall + " with " + this.this$0.mBackgroundCall);
                        this.this$0.mForegroundCall.switchWith(this.this$0.mBackgroundCall);
                    }
                    this.this$0.log("onCallTerminated: foreground call in state " + (Object)((Object)this.this$0.mForegroundCall.getState()) + " and ringing call in state " + (this.this$0.mRingingCall == null ? "null" : this.this$0.mRingingCall.getState().toString()));
                    if (this.this$0.mForegroundCall.getState() == Call.State.HOLDING || this.this$0.mRingingCall.getState() == Call.State.WAITING) {
                        this.this$0.sendEmptyMessage(19);
                        this.this$0.mSwitchingFgAndBgCalls = false;
                        this.this$0.mCallExpectedToResume = null;
                    }
                }
                if (this.this$0.mShouldUpdateImsConfigOnDisconnect) {
                    ImsManager.updateImsServiceConfig(this.this$0.mPhone.getContext(), this.this$0.mPhone.getPhoneId(), true);
                    this.this$0.mShouldUpdateImsConfigOnDisconnect = false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallHeld(ImsCall imsCall) {
                if (this.this$0.mForegroundCall.getImsCall() == imsCall) {
                    this.this$0.log("onCallHeld (fg) " + imsCall);
                } else if (this.this$0.mBackgroundCall.getImsCall() == imsCall) {
                    this.this$0.log("onCallHeld (bg) " + imsCall);
                }
                Object object = this.this$0.mSyncHold;
                synchronized (object) {
                    Call.State oldState = this.this$0.mBackgroundCall.getState();
                    this.this$0.processCallStateChange(imsCall, Call.State.HOLDING, 0);
                    if (oldState == Call.State.ACTIVE) {
                        if (this.this$0.mForegroundCall.getState() == Call.State.HOLDING || this.this$0.mRingingCall.getState() == Call.State.WAITING) {
                            this.this$0.sendEmptyMessage(19);
                        } else {
                            if (this.this$0.mPendingMO != null) {
                                this.this$0.dialPendingMO();
                            }
                            this.this$0.mSwitchingFgAndBgCalls = false;
                        }
                    } else if (oldState == Call.State.IDLE && this.this$0.mSwitchingFgAndBgCalls && this.this$0.mForegroundCall.getState() == Call.State.HOLDING) {
                        this.this$0.sendEmptyMessage(19);
                        this.this$0.mSwitchingFgAndBgCalls = false;
                        this.this$0.mCallExpectedToResume = null;
                    }
                }
                this.this$0.mMetrics.writeOnImsCallHeld(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallHoldFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallHoldFailed reasonCode=" + reasonInfo.getCode());
                Object object = this.this$0.mSyncHold;
                synchronized (object) {
                    Call.State bgState = this.this$0.mBackgroundCall.getState();
                    if (reasonInfo.getCode() == 148) {
                        if (this.this$0.mPendingMO != null) {
                            this.this$0.dialPendingMO();
                        }
                    } else if (bgState == Call.State.ACTIVE) {
                        this.this$0.mForegroundCall.switchWith(this.this$0.mBackgroundCall);
                        if (this.this$0.mPendingMO != null) {
                            this.this$0.mPendingMO.setDisconnectCause(36);
                            this.this$0.sendEmptyMessageDelayed(18, 500L);
                        }
                    }
                    this.this$0.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HOLD);
                }
                this.this$0.mMetrics.writeOnImsCallHoldFailed(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallResumed(ImsCall imsCall) {
                this.this$0.log("onCallResumed");
                if (this.this$0.mSwitchingFgAndBgCalls) {
                    if (imsCall != this.this$0.mCallExpectedToResume) {
                        this.this$0.log("onCallResumed : switching " + this.this$0.mForegroundCall + " with " + this.this$0.mBackgroundCall);
                        this.this$0.mForegroundCall.switchWith(this.this$0.mBackgroundCall);
                    } else {
                        this.this$0.log("onCallResumed : expected call resumed.");
                    }
                    this.this$0.mSwitchingFgAndBgCalls = false;
                    this.this$0.mCallExpectedToResume = null;
                }
                this.this$0.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
                this.this$0.mMetrics.writeOnImsCallResumed(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession());
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallResumeFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                if (this.this$0.mSwitchingFgAndBgCalls) {
                    if (imsCall == this.this$0.mCallExpectedToResume) {
                        this.this$0.log("onCallResumeFailed : switching " + this.this$0.mForegroundCall + " with " + this.this$0.mBackgroundCall);
                        this.this$0.mForegroundCall.switchWith(this.this$0.mBackgroundCall);
                        if (this.this$0.mForegroundCall.getState() == Call.State.HOLDING) {
                            this.this$0.sendEmptyMessage(19);
                        }
                    }
                    this.this$0.mCallExpectedToResume = null;
                    this.this$0.mSwitchingFgAndBgCalls = false;
                }
                this.this$0.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.RESUME);
                this.this$0.mMetrics.writeOnImsCallResumeFailed(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession(), reasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallResumeReceived(ImsCall imsCall) {
                this.this$0.log("onCallResumeReceived");
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                if (conn != null) {
                    if (this.this$0.mOnHoldToneStarted) {
                        this.this$0.mPhone.stopOnHoldTone(conn);
                        this.this$0.mOnHoldToneStarted = false;
                    }
                    conn.onConnectionEvent("android.telecom.event.CALL_REMOTELY_UNHELD", null);
                }
                SuppServiceNotification supp = new SuppServiceNotification();
                supp.notificationType = 1;
                supp.code = 3;
                this.this$0.mPhone.notifySuppSvcNotification(supp);
                this.this$0.mMetrics.writeOnImsCallResumeReceived(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession());
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallHoldReceived(ImsCall imsCall) {
                this.this$0.log("onCallHoldReceived");
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                if (conn != null) {
                    if (!this.this$0.mOnHoldToneStarted && ImsPhoneCall.isLocalTone(imsCall) && conn.getState() == Call.State.ACTIVE) {
                        this.this$0.mPhone.startOnHoldTone(conn);
                        this.this$0.mOnHoldToneStarted = true;
                        this.this$0.mOnHoldToneId = System.identityHashCode(conn);
                    }
                    conn.onConnectionEvent("android.telecom.event.CALL_REMOTELY_HELD", null);
                }
                SuppServiceNotification supp = new SuppServiceNotification();
                supp.notificationType = 1;
                supp.code = 2;
                this.this$0.mPhone.notifySuppSvcNotification(supp);
                this.this$0.mMetrics.writeOnImsCallHoldReceived(this.this$0.mPhone.getPhoneId(), imsCall.getCallSession());
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallSuppServiceReceived(ImsCall call, ImsSuppServiceNotification suppServiceInfo) {
                this.this$0.log("onCallSuppServiceReceived: suppServiceInfo=" + suppServiceInfo);
                SuppServiceNotification supp = new SuppServiceNotification();
                supp.notificationType = suppServiceInfo.notificationType;
                supp.code = suppServiceInfo.code;
                supp.index = suppServiceInfo.index;
                supp.number = suppServiceInfo.number;
                supp.history = suppServiceInfo.history;
                this.this$0.mPhone.notifySuppSvcNotification(supp);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallMerged(ImsCall call, ImsCall peerCall, boolean swapCalls) {
                Call peerImsPhoneCall;
                this.this$0.log("onCallMerged");
                Call foregroundImsPhoneCall = this.this$0.findConnection(call).getCall();
                ImsPhoneConnection peerConnection = this.this$0.findConnection(peerCall);
                Call call2 = peerImsPhoneCall = peerConnection == null ? null : peerConnection.getCall();
                if (swapCalls) {
                    this.this$0.switchAfterConferenceSuccess();
                }
                ((ImsPhoneCall)foregroundImsPhoneCall).merge((ImsPhoneCall)peerImsPhoneCall, Call.State.ACTIVE);
                try {
                    ImsPhoneConnection conn = this.this$0.findConnection(call);
                    this.this$0.log("onCallMerged: ImsPhoneConnection=" + conn);
                    this.this$0.log("onCallMerged: CurrentVideoProvider=" + conn.getVideoProvider());
                    this.this$0.setVideoCallProvider(conn, call);
                    this.this$0.log("onCallMerged: CurrentVideoProvider=" + conn.getVideoProvider());
                }
                catch (Exception e) {
                    this.this$0.loge("onCallMerged: exception " + e);
                }
                this.this$0.processCallStateChange(this.this$0.mForegroundCall.getImsCall(), Call.State.ACTIVE, 0);
                if (peerConnection != null) {
                    this.this$0.processCallStateChange(this.this$0.mBackgroundCall.getImsCall(), Call.State.HOLDING, 0);
                }
                if (!call.isMergeRequestedByConf()) {
                    this.this$0.log("onCallMerged :: calling onMultipartyStateChanged()");
                    this.onMultipartyStateChanged(call, true);
                } else {
                    this.this$0.log("onCallMerged :: Merge requested by existing conference.");
                    call.resetIsMergeRequestedByConf(false);
                }
                this.this$0.logState();
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallMergeFailed(ImsCall call, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallMergeFailed reasonInfo=" + reasonInfo);
                this.this$0.mPhone.notifySuppServiceFailed(PhoneInternalInterface.SuppService.CONFERENCE);
                ImsPhoneConnection conn = this.this$0.findConnection(call);
                if (conn != null) {
                    conn.onConferenceMergeFailed();
                    conn.onConnectionEvent("android.telecom.event.MERGE_COMPLETE", null);
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onConferenceParticipantsStateChanged(ImsCall call, List<ConferenceParticipant> participants) {
                this.this$0.log("onConferenceParticipantsStateChanged");
                ImsPhoneConnection conn = this.this$0.findConnection(call);
                if (conn != null) {
                    conn.updateConferenceParticipants(participants);
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallSessionTtyModeReceived(ImsCall call, int mode) {
                this.this$0.mPhone.onTtyModeReceived(mode);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallHandover(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
                boolean isHandoverFromWifi;
                boolean isHandoverToWifi;
                this.this$0.log("onCallHandover ::  srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
                boolean bl = isHandoverToWifi = srcAccessTech != 18 && targetAccessTech == 18;
                if (isHandoverToWifi) {
                    this.this$0.removeMessages(25);
                }
                boolean bl2 = isHandoverFromWifi = srcAccessTech == 18 && targetAccessTech != 18;
                if (this.this$0.mNotifyHandoverVideoFromWifiToLTE && isHandoverFromWifi && imsCall.isVideoCall()) {
                    this.this$0.log("onCallHandover :: notifying of WIFI to LTE handover.");
                    ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                    if (conn != null) {
                        conn.onConnectionEvent("android.telephony.event.EVENT_HANDOVER_VIDEO_FROM_WIFI_TO_LTE", null);
                    } else {
                        this.this$0.loge("onCallHandover :: failed to notify of handover; connection is null.");
                    }
                }
                this.this$0.mMetrics.writeOnImsCallHandoverEvent(this.this$0.mPhone.getPhoneId(), 18, imsCall.getCallSession(), srcAccessTech, targetAccessTech, reasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallHandoverFailed(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
                this.this$0.log("onCallHandoverFailed :: srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
                this.this$0.mMetrics.writeOnImsCallHandoverEvent(this.this$0.mPhone.getPhoneId(), 19, imsCall.getCallSession(), srcAccessTech, targetAccessTech, reasonInfo);
                boolean isHandoverToWifi = srcAccessTech != 18 && targetAccessTech == 18;
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                if (conn != null && isHandoverToWifi) {
                    this.this$0.log("onCallHandoverFailed - handover to WIFI Failed");
                    this.this$0.removeMessages(25);
                    if (this.this$0.mNotifyVtHandoverToWifiFail) {
                        conn.onHandoverToWifiFailed();
                    }
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onMultipartyStateChanged(ImsCall imsCall, boolean isMultiParty) {
                this.this$0.log("onMultipartyStateChanged to " + (isMultiParty ? "Y" : "N"));
                ImsPhoneConnection conn = this.this$0.findConnection(imsCall);
                if (conn != null) {
                    conn.updateMultipartyState(isMultiParty);
                }
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), this, imsPhoneCallTracker);
            }

            @Override
            public void onCallProgressing(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallProgressing", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallProgressing(com.android.ims.ImsCall ), this, imsCall);
            }

            @Override
            public void onCallStarted(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallStarted(com.android.ims.ImsCall ), this, imsCall);
            }

            @Override
            public void onCallUpdated(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallUpdated", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallUpdated(com.android.ims.ImsCall ), this, imsCall);
            }

            @Override
            public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallStartFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallStartFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), this, imsCall, imsReasonInfo);
            }

            @Override
            public void onCallTerminated(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallTerminated", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallTerminated(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), this, imsCall, imsReasonInfo);
            }

            @Override
            public void onCallHeld(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallHeld", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallHeld(com.android.ims.ImsCall ), this, imsCall);
            }

            @Override
            public void onCallHoldFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallHoldFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallHoldFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), this, imsCall, imsReasonInfo);
            }

            @Override
            public void onCallResumed(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallResumed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallResumed(com.android.ims.ImsCall ), this, imsCall);
            }

            @Override
            public void onCallResumeFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallResumeFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallResumeFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), this, imsCall, imsReasonInfo);
            }

            @Override
            public void onCallResumeReceived(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallResumeReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallResumeReceived(com.android.ims.ImsCall ), this, imsCall);
            }

            @Override
            public void onCallHoldReceived(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallHoldReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallHoldReceived(com.android.ims.ImsCall ), this, imsCall);
            }

            @Override
            public void onCallSuppServiceReceived(ImsCall imsCall, ImsSuppServiceNotification imsSuppServiceNotification) {
                InvokeDynamicSupport.bootstrap("onCallSuppServiceReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallSuppServiceReceived(com.android.ims.ImsCall com.android.ims.ImsSuppServiceNotification ), this, imsCall, imsSuppServiceNotification);
            }

            @Override
            public void onCallMerged(ImsCall imsCall, ImsCall imsCall2, boolean bl) {
                InvokeDynamicSupport.bootstrap("onCallMerged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallMerged(com.android.ims.ImsCall com.android.ims.ImsCall boolean ), this, imsCall, imsCall2, bl);
            }

            @Override
            public void onCallMergeFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallMergeFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallMergeFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), this, imsCall, imsReasonInfo);
            }

            @Override
            public void onConferenceParticipantsStateChanged(ImsCall imsCall, List<ConferenceParticipant> list) {
                InvokeDynamicSupport.bootstrap("onConferenceParticipantsStateChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onConferenceParticipantsStateChanged(com.android.ims.ImsCall java.util.List<android.telecom.ConferenceParticipant> ), this, imsCall, list);
            }

            @Override
            public void onCallSessionTtyModeReceived(ImsCall imsCall, int n) {
                InvokeDynamicSupport.bootstrap("onCallSessionTtyModeReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallSessionTtyModeReceived(com.android.ims.ImsCall int ), this, imsCall, n);
            }

            @Override
            public void onCallHandover(ImsCall imsCall, int n, int n2, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallHandover", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallHandover(com.android.ims.ImsCall int int com.android.ims.ImsReasonInfo ), this, imsCall, n, n2, imsReasonInfo);
            }

            @Override
            public void onCallHandoverFailed(ImsCall imsCall, int n, int n2, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallHandoverFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onCallHandoverFailed(com.android.ims.ImsCall int int com.android.ims.ImsReasonInfo ), this, imsCall, n, n2, imsReasonInfo);
            }

            @Override
            public void onMultipartyStateChanged(ImsCall imsCall, boolean bl) {
                InvokeDynamicSupport.bootstrap("onMultipartyStateChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_2$onMultipartyStateChanged(com.android.ims.ImsCall boolean ), this, imsCall, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsUssdListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStarted(ImsCall imsCall) {
                this.this$0.log("mImsUssdListener onCallStarted");
                if (imsCall == this.this$0.mUssdSession && this.this$0.mPendingUssd != null) {
                    AsyncResult.forMessage(this.this$0.mPendingUssd);
                    this.this$0.mPendingUssd.sendToTarget();
                    this.this$0.mPendingUssd = null;
                }
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("mImsUssdListener onCallStartFailed reasonCode=" + reasonInfo.getCode());
                this.onCallTerminated(imsCall, reasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
                this.this$0.log("mImsUssdListener onCallTerminated reasonCode=" + reasonInfo.getCode());
                this.this$0.removeMessages(25);
                if (imsCall == this.this$0.mUssdSession) {
                    this.this$0.mUssdSession = null;
                    if (this.this$0.mPendingUssd != null) {
                        CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                        AsyncResult.forMessage(this.this$0.mPendingUssd, null, ex);
                        this.this$0.mPendingUssd.sendToTarget();
                        this.this$0.mPendingUssd = null;
                    }
                }
                imsCall.close();
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallUssdMessageReceived(ImsCall call, int mode, String ussdMessage) {
                this.this$0.log("mImsUssdListener onCallUssdMessageReceived mode=" + mode);
                int ussdMode = -1;
                switch (mode) {
                    case 1: {
                        ussdMode = 1;
                        break;
                    }
                    case 0: {
                        ussdMode = 0;
                    }
                }
                this.this$0.mPhone.onIncomingUSSD(ussdMode, ussdMessage);
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), this, imsPhoneCallTracker);
            }

            @Override
            public void onCallStarted(ImsCall imsCall) {
                InvokeDynamicSupport.bootstrap("onCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStarted(com.android.ims.ImsCall ), this, imsCall);
            }

            @Override
            public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallStartFailed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallStartFailed(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), this, imsCall, imsReasonInfo);
            }

            @Override
            public void onCallTerminated(ImsCall imsCall, ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onCallTerminated", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallTerminated(com.android.ims.ImsCall com.android.ims.ImsReasonInfo ), this, imsCall, imsReasonInfo);
            }

            @Override
            public void onCallUssdMessageReceived(ImsCall imsCall, int n, String string2) {
                InvokeDynamicSupport.bootstrap("onCallUssdMessageReceived", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_3$onCallUssdMessageReceived(com.android.ims.ImsCall int java.lang.String ), this, imsCall, n, string2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsConnectionStateListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onImsConnected(int imsRadioTech) {
                this.this$0.log("onImsConnected imsRadioTech=" + imsRadioTech);
                this.this$0.mPhone.setServiceState(0);
                this.this$0.mPhone.setImsRegistered(true);
                this.this$0.mMetrics.writeOnImsConnectionState(this.this$0.mPhone.getPhoneId(), 1, null);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onImsDisconnected(ImsReasonInfo imsReasonInfo) {
                this.this$0.log("onImsDisconnected imsReasonInfo=" + imsReasonInfo);
                this.this$0.resetImsCapabilities();
                this.this$0.mPhone.setServiceState(1);
                this.this$0.mPhone.setImsRegistered(false);
                this.this$0.mPhone.processDisconnectReason(imsReasonInfo);
                this.this$0.mMetrics.writeOnImsConnectionState(this.this$0.mPhone.getPhoneId(), 3, imsReasonInfo);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onImsProgressing(int imsRadioTech) {
                this.this$0.log("onImsProgressing imsRadioTech=" + imsRadioTech);
                this.this$0.mPhone.setServiceState(1);
                this.this$0.mPhone.setImsRegistered(false);
                this.this$0.mMetrics.writeOnImsConnectionState(this.this$0.mPhone.getPhoneId(), 2, null);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onImsResumed() {
                this.this$0.log("onImsResumed");
                this.this$0.mPhone.setServiceState(0);
                this.this$0.mMetrics.writeOnImsConnectionState(this.this$0.mPhone.getPhoneId(), 4, null);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onImsSuspended() {
                this.this$0.log("onImsSuspended");
                this.this$0.mPhone.setServiceState(1);
                this.this$0.mMetrics.writeOnImsConnectionState(this.this$0.mPhone.getPhoneId(), 5, null);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) {
                this.this$0.log("onFeatureCapabilityChanged");
                SomeArgs args = SomeArgs.obtain();
                args.argi1 = serviceClass;
                args.arg1 = enabledFeatures;
                args.arg2 = disabledFeatures;
                this.this$0.removeMessages(26);
                this.this$0.obtainMessage(26, args).sendToTarget();
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onVoiceMessageCountChanged(int count) {
                this.this$0.log("onVoiceMessageCountChanged :: count=" + count);
                this.this$0.mPhone.mDefaultPhone.setVoiceMessageCount(count);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$registrationAssociatedUriChanged(Uri[] uris) {
                this.this$0.log("registrationAssociatedUriChanged");
                this.this$0.mPhone.setCurrentSubscriberUris(uris);
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), this, imsPhoneCallTracker);
            }

            @Override
            public void onImsConnected(int n) {
                InvokeDynamicSupport.bootstrap("onImsConnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onImsConnected(int ), this, n);
            }

            @Override
            public void onImsDisconnected(ImsReasonInfo imsReasonInfo) {
                InvokeDynamicSupport.bootstrap("onImsDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onImsDisconnected(com.android.ims.ImsReasonInfo ), this, imsReasonInfo);
            }

            @Override
            public void onImsProgressing(int n) {
                InvokeDynamicSupport.bootstrap("onImsProgressing", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onImsProgressing(int ), this, n);
            }

            @Override
            public void onImsResumed() {
                InvokeDynamicSupport.bootstrap("onImsResumed", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onImsResumed(), this);
            }

            @Override
            public void onImsSuspended() {
                InvokeDynamicSupport.bootstrap("onImsSuspended", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onImsSuspended(), this);
            }

            @Override
            public void onFeatureCapabilityChanged(int n, int[] nArray, int[] nArray2) {
                InvokeDynamicSupport.bootstrap("onFeatureCapabilityChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onFeatureCapabilityChanged(int int[] int[] ), this, n, nArray, nArray2);
            }

            @Override
            public void onVoiceMessageCountChanged(int n) {
                InvokeDynamicSupport.bootstrap("onVoiceMessageCountChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$onVoiceMessageCountChanged(int ), this, n);
            }

            @Override
            public void registrationAssociatedUriChanged(Uri[] uriArray) {
                InvokeDynamicSupport.bootstrap("registrationAssociatedUriChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_4$registrationAssociatedUriChanged(android.net.Uri[] ), this, uriArray);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsConfigListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhoneCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$__constructor__(ImsPhoneCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onGetFeatureResponse(int feature, int network, int value, int status) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onSetFeatureResponse(int feature, int network, int value, int status) {
                this.this$0.mMetrics.writeImsSetFeatureValue(this.this$0.mPhone.getPhoneId(), feature, network, value, status);
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onGetVideoQuality(int status, int quality) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onSetVideoQuality(int status) {
            }

            private void __constructor__(ImsPhoneCallTracker imsPhoneCallTracker) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$__constructor__(imsPhoneCallTracker);
            }
            {
                this.this$0 = imsPhoneCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$__constructor__(com.android.internal.telephony.imsphone.ImsPhoneCallTracker ), this, imsPhoneCallTracker);
            }

            @Override
            public void onGetFeatureResponse(int n, int n2, int n3, int n4) {
                InvokeDynamicSupport.bootstrap("onGetFeatureResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onGetFeatureResponse(int int int int ), this, n, n2, n3, n4);
            }

            @Override
            public void onSetFeatureResponse(int n, int n2, int n3, int n4) {
                InvokeDynamicSupport.bootstrap("onSetFeatureResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onSetFeatureResponse(int int int int ), this, n, n2, n3, n4);
            }

            @Override
            public void onGetVideoQuality(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onGetVideoQuality", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onGetVideoQuality(int int ), this, n, n2);
            }

            @Override
            public void onSetVideoQuality(int n) {
                InvokeDynamicSupport.bootstrap("onSetVideoQuality", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker_5$onSetVideoQuality(int ), this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mMetrics = TelephonyMetrics.getInstance();
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction("com.android.ims.IMS_INCOMING_CALL");
        intentfilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mReceiver, intentfilter);
        this.cacheCarrierConfiguration(this.mPhone.getSubId());
        this.mPhone.getDefaultPhone().registerForDataEnabledChanged(this, 23, null);
        this.mImsServiceRetryCount = 0;
        this.sendEmptyMessage(24);
    }

    private final PendingIntent $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$createIncomingCallPendingIntent() {
        Intent intent = new Intent("com.android.ims.IMS_INCOMING_CALL");
        intent.addFlags(0x10000000);
        return PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getImsService() throws ImsException {
        this.log("getImsService");
        this.mImsManager = ImsManager.getInstance(this.mPhone.getContext(), this.mPhone.getPhoneId());
        this.mImsManager.addNotifyStatusChangedCallbackIfAvailable(this.mNotifyStatusChangedCallback);
        this.mNotifyStatusChangedCallback.notifyStatusChanged();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$startListeningForCalls() throws ImsException {
        this.mImsServiceRetryCount = 0;
        this.mServiceId = this.mImsManager.open(1, this.createIncomingCallPendingIntent(), this.mImsConnectionStateListener);
        this.mImsManager.setImsConfigListener(this.mImsConfigListener);
        this.getEcbmInterface().setEcbmStateListener(this.mPhone.getImsEcbmStateListener());
        if (this.mPhone.isInEcm()) {
            this.mPhone.exitEmergencyCallbackMode();
        }
        int mPreferredTtyMode = Settings.Secure.getInt(this.mPhone.getContext().getContentResolver(), "preferred_tty_mode", 0);
        this.mImsManager.setUiTTYMode(this.mPhone.getContext(), mPreferredTtyMode, null);
        ImsMultiEndpoint multiEndpoint = this.getMultiEndpointInterface();
        if (multiEndpoint != null) {
            multiEndpoint.setExternalCallStateListener(this.mPhone.getExternalCallTracker().getExternalCallStateListener());
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$stopListeningForCalls() {
        try {
            if (this.mImsManager != null && this.mServiceId > 0) {
                this.mImsManager.close(this.mServiceId);
                this.mServiceId = -1;
            }
        }
        catch (ImsException imsException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dispose() {
        this.log("dispose");
        this.mRingingCall.dispose();
        this.mBackgroundCall.dispose();
        this.mForegroundCall.dispose();
        this.mHandoverCall.dispose();
        this.clearDisconnected();
        this.mPhone.getContext().unregisterReceiver(this.mReceiver);
        this.mPhone.getDefaultPhone().unregisterForDataEnabledChanged(this);
        this.removeMessages(24);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$finalize() {
        this.log("ImsPhoneCallTracker finalized");
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(String dialString, int videoState, Bundle intentExtras) throws CallStateException {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        int oirMode = sp.getInt("clir_key", 0);
        return this.dial(dialString, oirMode, videoState, intentExtras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(String dialString, int clirMode, int videoState, Bundle intentExtras) throws CallStateException {
        boolean isPhoneInEcmMode = this.isPhoneInEcbMode();
        boolean isEmergencyNumber = PhoneNumberUtils.isEmergencyNumber(dialString);
        this.log("dial clirMode=" + clirMode);
        this.clearDisconnected();
        if (this.mImsManager == null) {
            throw new CallStateException("service not available");
        }
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        if (isPhoneInEcmMode && isEmergencyNumber) {
            this.handleEcmTimer(1);
        }
        if (isEmergencyNumber && VideoProfile.isVideo(videoState) && !this.mAllowEmergencyVideoCalls) {
            this.loge("dial: carrier does not support video emergency calls; downgrade to audio-only");
            videoState = 0;
        }
        boolean holdBeforeDial = false;
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            if (this.mBackgroundCall.getState() != Call.State.IDLE) {
                throw new CallStateException("cannot dial in current state");
            }
            holdBeforeDial = true;
            this.mPendingCallVideoState = videoState;
            this.mPendingIntentExtras = intentExtras;
            this.switchWaitingOrHoldingAndActive();
        }
        Call.State fgState = Call.State.IDLE;
        Call.State bgState = Call.State.IDLE;
        this.mClirMode = clirMode;
        Object object = this.mSyncHold;
        synchronized (object) {
            if (holdBeforeDial) {
                fgState = this.mForegroundCall.getState();
                bgState = this.mBackgroundCall.getState();
                if (fgState == Call.State.ACTIVE) {
                    throw new CallStateException("cannot dial in current state");
                }
                if (bgState == Call.State.HOLDING) {
                    holdBeforeDial = false;
                }
            }
            this.mPendingMO = new ImsPhoneConnection((Phone)this.mPhone, this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall, isEmergencyNumber);
            this.mPendingMO.setVideoState(videoState);
        }
        this.addConnection(this.mPendingMO);
        if (!holdBeforeDial) {
            if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyNumber) {
                this.dialInternal(this.mPendingMO, clirMode, videoState, intentExtras);
            } else {
                try {
                    this.getEcbmInterface().exitEmergencyCallbackMode();
                }
                catch (ImsException e) {
                    e.printStackTrace();
                    throw new CallStateException("service not available");
                }
                this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                this.pendingCallClirMode = clirMode;
                this.mPendingCallVideoState = videoState;
                this.pendingCallInEcm = true;
            }
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cacheCarrierConfiguration(int subId) {
        CarrierConfigManager carrierConfigManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (carrierConfigManager == null) {
            this.loge("cacheCarrierConfiguration: No carrier config service found.");
            return;
        }
        PersistableBundle carrierConfig = carrierConfigManager.getConfigForSubId(subId);
        if (carrierConfig == null) {
            this.loge("cacheCarrierConfiguration: Empty carrier config.");
            return;
        }
        this.mAllowEmergencyVideoCalls = carrierConfig.getBoolean("allow_emergency_video_calls_bool");
        this.mTreatDowngradedVideoCallsAsVideoCalls = carrierConfig.getBoolean("treat_downgraded_video_calls_as_video_calls_bool");
        this.mDropVideoCallWhenAnsweringAudioCall = carrierConfig.getBoolean("drop_video_call_when_answering_audio_call_bool");
        this.mAllowAddCallDuringVideoCall = carrierConfig.getBoolean("allow_add_call_during_video_call");
        this.mNotifyVtHandoverToWifiFail = carrierConfig.getBoolean("notify_vt_handover_to_wifi_failure_bool");
        this.mSupportDowngradeVtToAudio = carrierConfig.getBoolean("support_downgrade_vt_to_audio_bool");
        this.mNotifyHandoverVideoFromWifiToLTE = carrierConfig.getBoolean("notify_vt_handover_to_wifi_failure_bool");
        this.mIgnoreDataEnabledChangedForVideoCalls = carrierConfig.getBoolean("ignore_data_enabled_changed_for_video_calls");
        this.mSupportPauseVideo = carrierConfig.getBoolean("support_pause_ims_video_calls_bool");
        String[] mappings = carrierConfig.getStringArray("ims_reasoninfo_mapping_string_array");
        if (mappings != null && mappings.length > 0) {
            for (String mapping : mappings) {
                String[] values = mapping.split(Pattern.quote("|"));
                if (values.length != 3) continue;
                try {
                    Integer fromCode = values[0].equals("*") ? null : Integer.valueOf(Integer.parseInt(values[0]));
                    String message = values[1];
                    int toCode = Integer.parseInt(values[2]);
                    this.addReasonCodeRemapping(fromCode, message, toCode);
                    this.log("Loaded ImsReasonInfo mapping : fromCode = " + fromCode == null ? "any" : fromCode + " ; message = " + message + " ; toCode = " + toCode);
                }
                catch (NumberFormatException nfe) {
                    this.loge("Invalid ImsReasonInfo mapping found: " + mapping);
                }
            }
        } else {
            this.log("No carrier ImsReasonInfo mappings defined.");
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleEcmTimer(int action) {
        this.mPhone.handleTimerInEmergencyCallbackMode(action);
        switch (action) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.log("handleEcmTimer, unsupported action " + action);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dialInternal(ImsPhoneConnection conn, int clirMode, int videoState, Bundle intentExtras) {
        if (conn == null) {
            return;
        }
        if (conn.getAddress() == null || conn.getAddress().length() == 0 || conn.getAddress().indexOf(78) >= 0) {
            conn.setDisconnectCause(7);
            this.sendEmptyMessageDelayed(18, 500L);
            return;
        }
        this.setMute(false);
        int serviceType = PhoneNumberUtils.isEmergencyNumber(conn.getAddress()) ? 2 : 1;
        int callType = ImsCallProfile.getCallTypeFromVideoState(videoState);
        conn.setVideoState(videoState);
        try {
            String[] callees = new String[]{conn.getAddress()};
            ImsCallProfile profile = this.mImsManager.createCallProfile(this.mServiceId, serviceType, callType);
            profile.setCallExtraInt("oir", clirMode);
            if (intentExtras != null) {
                if (intentExtras.containsKey("android.telecom.extra.CALL_SUBJECT")) {
                    intentExtras.putString("DisplayText", this.cleanseInstantLetteringMessage(intentExtras.getString("android.telecom.extra.CALL_SUBJECT")));
                }
                if (intentExtras.containsKey("CallPull")) {
                    profile.mCallExtras.putBoolean("CallPull", intentExtras.getBoolean("CallPull"));
                    int dialogId = intentExtras.getInt("android.telephony.ImsExternalCallTracker.extra.EXTERNAL_CALL_ID");
                    conn.setIsPulledCall(true);
                    conn.setPulledDialogId(dialogId);
                }
                profile.mCallExtras.putBundle("OemCallExtras", intentExtras);
            }
            ImsCall imsCall = this.mImsManager.makeCall(this.mServiceId, profile, callees, this.mImsCallListener);
            conn.setImsCall(imsCall);
            this.mMetrics.writeOnImsCallStart(this.mPhone.getPhoneId(), imsCall.getSession());
            this.setVideoCallProvider(conn, imsCall);
            conn.setAllowAddCallDuringVideoCall(this.mAllowAddCallDuringVideoCall);
        }
        catch (ImsException e) {
            this.loge("dialInternal : " + e);
            conn.setDisconnectCause(36);
            this.sendEmptyMessageDelayed(18, 500L);
            this.retryGetImsService();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$acceptCall(int videoState) throws CallStateException {
        this.log("acceptCall");
        if (this.mForegroundCall.getState().isAlive() && this.mBackgroundCall.getState().isAlive()) {
            throw new CallStateException("cannot accept call");
        }
        if (this.mRingingCall.getState() == Call.State.WAITING && this.mForegroundCall.getState().isAlive()) {
            this.setMute(false);
            boolean answeringWillDisconnect = false;
            ImsCall activeCall = this.mForegroundCall.getImsCall();
            ImsCall ringingCall = this.mRingingCall.getImsCall();
            if (this.mForegroundCall.hasConnections() && this.mRingingCall.hasConnections()) {
                answeringWillDisconnect = this.shouldDisconnectActiveCallOnAnswer(activeCall, ringingCall);
            }
            this.mPendingCallVideoState = videoState;
            if (answeringWillDisconnect) {
                this.mForegroundCall.hangup();
                try {
                    ringingCall.accept(ImsCallProfile.getCallTypeFromVideoState(videoState));
                }
                catch (ImsException e) {
                    throw new CallStateException("cannot accept call");
                }
            } else {
                this.switchWaitingOrHoldingAndActive();
            }
        } else if (this.mRingingCall.getState().isRinging()) {
            this.log("acceptCall: incoming...");
            this.setMute(false);
            try {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall == null) {
                    throw new CallStateException("no valid ims call");
                }
                imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(videoState));
                this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 2);
            }
            catch (ImsException e) {
                throw new CallStateException("cannot accept call");
            }
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$rejectCall() throws CallStateException {
        this.log("rejectCall");
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.hangup(this.mRingingCall);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$switchAfterConferenceSuccess() {
        this.log("switchAfterConferenceSuccess fg =" + (Object)((Object)this.mForegroundCall.getState()) + ", bg = " + (Object)((Object)this.mBackgroundCall.getState()));
        if (this.mBackgroundCall.getState() == Call.State.HOLDING) {
            this.log("switchAfterConferenceSuccess");
            this.mForegroundCall.switchWith(this.mBackgroundCall);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$switchWaitingOrHoldingAndActive() throws CallStateException {
        this.log("switchWaitingOrHoldingAndActive");
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            ImsCall imsCall = this.mForegroundCall.getImsCall();
            if (imsCall == null) {
                throw new CallStateException("no ims call");
            }
            boolean switchingWithWaitingCall = this.mBackgroundCall.getImsCall() == null && this.mRingingCall != null && this.mRingingCall.getState() == Call.State.WAITING;
            this.mSwitchingFgAndBgCalls = true;
            this.mCallExpectedToResume = switchingWithWaitingCall ? this.mRingingCall.getImsCall() : this.mBackgroundCall.getImsCall();
            this.mForegroundCall.switchWith(this.mBackgroundCall);
            try {
                imsCall.hold();
                this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 5);
                if (this.mCallExpectedToResume != null) return;
                this.log("mCallExpectedToResume is null");
                this.mSwitchingFgAndBgCalls = false;
                return;
            }
            catch (ImsException e) {
                this.mForegroundCall.switchWith(this.mBackgroundCall);
                throw new CallStateException(e.getMessage());
            }
        } else {
            if (this.mBackgroundCall.getState() != Call.State.HOLDING) return;
            this.resumeWaitingOrHolding();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$conference() {
        ImsPhoneConnection backgroundConnection;
        long conferenceConnectTime;
        this.log("conference");
        ImsCall fgImsCall = this.mForegroundCall.getImsCall();
        if (fgImsCall == null) {
            this.log("conference no foreground ims call");
            return;
        }
        ImsCall bgImsCall = this.mBackgroundCall.getImsCall();
        if (bgImsCall == null) {
            this.log("conference no background ims call");
            return;
        }
        long foregroundConnectTime = this.mForegroundCall.getEarliestConnectTime();
        long backgroundConnectTime = this.mBackgroundCall.getEarliestConnectTime();
        if (foregroundConnectTime > 0L && backgroundConnectTime > 0L) {
            conferenceConnectTime = Math.min(this.mForegroundCall.getEarliestConnectTime(), this.mBackgroundCall.getEarliestConnectTime());
            this.log("conference - using connect time = " + conferenceConnectTime);
        } else if (foregroundConnectTime > 0L) {
            this.log("conference - bg call connect time is 0; using fg = " + foregroundConnectTime);
            conferenceConnectTime = foregroundConnectTime;
        } else {
            this.log("conference - fg call connect time is 0; using bg = " + backgroundConnectTime);
            conferenceConnectTime = backgroundConnectTime;
        }
        ImsPhoneConnection foregroundConnection = this.mForegroundCall.getFirstConnection();
        if (foregroundConnection != null) {
            foregroundConnection.setConferenceConnectTime(conferenceConnectTime);
            foregroundConnection.onConnectionEvent("android.telecom.event.MERGE_START", null);
        }
        if ((backgroundConnection = this.findConnection(bgImsCall)) != null) {
            backgroundConnection.onConnectionEvent("android.telecom.event.MERGE_START", null);
        }
        try {
            fgImsCall.merge(bgImsCall);
        }
        catch (ImsException e) {
            this.log("conference " + e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$explicitCallTransfer() {
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$clearDisconnected() {
        this.log("clearDisconnected");
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canDial() {
        int serviceState = this.mPhone.getServiceState().getState();
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean ret = serviceState != 3 && this.mPendingMO == null && !this.mRingingCall.isRinging() && !disableCall.equals("true") && (!this.mForegroundCall.getState().isAlive() || !this.mBackgroundCall.getState().isAlive());
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canTransfer() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
        this.mHandoverCall.clearDisconnected();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$updatePhoneState() {
        boolean isPendingMOIdle;
        PhoneConstants.State oldState = this.mState;
        boolean bl = isPendingMOIdle = this.mPendingMO == null || !this.mPendingMO.getState().isAlive();
        this.mState = this.mRingingCall.isRinging() ? PhoneConstants.State.RINGING : (!isPendingMOIdle || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle() ? PhoneConstants.State.OFFHOOK : PhoneConstants.State.IDLE);
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("updatePhoneState pendingMo = " + (this.mPendingMO == null ? "null" : this.mPendingMO.getState()) + ", fg= " + (Object)((Object)this.mForegroundCall.getState()) + "(" + this.mForegroundCall.getConnections().size() + "), bg= " + (Object)((Object)this.mBackgroundCall.getState()) + "(" + this.mBackgroundCall.getConnections().size() + ")");
        this.log("updatePhoneState oldState=" + (Object)((Object)oldState) + ", newState=" + (Object)((Object)this.mState));
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
            this.mMetrics.writePhoneState(this.mPhone.getPhoneId(), this.mState);
            this.notifyPhoneStateChanged(oldState, this.mState);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dumpState() {
        int i;
        this.log("Phone State:" + (Object)((Object)this.mState));
        this.log("Ringing call: " + this.mRingingCall.toString());
        List<Connection> l = this.mRingingCall.getConnections();
        int s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Foreground call: " + this.mForegroundCall.toString());
        l = this.mForegroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Background call: " + this.mBackgroundCall.toString());
        l = this.mBackgroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setUiTTYMode(int uiTtyMode, Message onComplete) {
        if (this.mImsManager == null) {
            this.mPhone.sendErrorResponse(onComplete, this.getImsManagerIsNullException());
            return;
        }
        try {
            this.mImsManager.setUiTTYMode(this.mPhone.getContext(), uiTtyMode, onComplete);
        }
        catch (ImsException e) {
            this.loge("setTTYMode : " + e);
            this.mPhone.sendErrorResponse(onComplete, e);
            this.retryGetImsService();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mForegroundCall.setMute(mute);
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getMute() {
        return this.mDesiredMute;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendDtmf(char c, Message result) {
        this.log("sendDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.sendDtmf(c, result);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$startDtmf(char c) {
        this.log("startDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.startDtmf(c);
        } else {
            this.loge("startDtmf : no foreground call");
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$stopDtmf() {
        this.log("stopDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.stopDtmf();
        } else {
            this.loge("stopDtmf : no foreground call");
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(ImsPhoneConnection conn) throws CallStateException {
        this.log("hangup connection");
        if (conn.getOwner() != this) {
            throw new CallStateException("ImsPhoneConnection " + conn + "does not belong to ImsPhoneCallTracker " + this);
        }
        this.hangup((ImsPhoneCall)conn.getCall());
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(ImsPhoneCall call) throws CallStateException {
        this.log("hangup call");
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections");
        }
        ImsCall imsCall = call.getImsCall();
        boolean rejectCall = false;
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup incoming");
            rejectCall = true;
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
            } else {
                this.log("(foregnd) hangup foreground");
            }
        } else if (call == this.mBackgroundCall) {
            this.log("(backgnd) hangup waiting or background");
        } else {
            throw new CallStateException("ImsPhoneCall " + call + "does not belong to ImsPhoneCallTracker " + this);
        }
        call.onHangupLocal();
        try {
            if (imsCall != null) {
                if (rejectCall) {
                    imsCall.reject(504);
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 3);
                } else {
                    imsCall.terminate(501);
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 4);
                }
            } else if (this.mPendingMO != null && call == this.mForegroundCall) {
                this.mPendingMO.update(null, Call.State.DISCONNECTED);
                this.mPendingMO.onDisconnect();
                this.removeConnection(this.mPendingMO);
                this.mPendingMO = null;
                this.updatePhoneState();
                this.removeMessages(20);
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$callEndCleanupHandOverCallIfAny() {
        if (this.mHandoverCall.mConnections.size() > 0) {
            this.log("callEndCleanupHandOverCallIfAny, mHandoverCall.mConnections=" + this.mHandoverCall.mConnections);
            this.mHandoverCall.mConnections.clear();
            this.mConnections.clear();
            this.mState = PhoneConstants.State.IDLE;
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$resumeWaitingOrHolding() throws CallStateException {
        this.log("resumeWaitingOrHolding");
        try {
            if (this.mForegroundCall.getState().isAlive()) {
                ImsCall imsCall = this.mForegroundCall.getImsCall();
                if (imsCall != null) {
                    imsCall.resume();
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 6);
                }
            } else if (this.mRingingCall.getState() == Call.State.WAITING) {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall != null) {
                    imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(this.mPendingCallVideoState));
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 2);
                }
            } else {
                ImsCall imsCall = this.mBackgroundCall.getImsCall();
                if (imsCall != null) {
                    imsCall.resume();
                    this.mMetrics.writeOnImsCommand(this.mPhone.getPhoneId(), imsCall.getSession(), 6);
                }
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendUSSD(String ussdString, Message response) {
        this.log("sendUSSD");
        try {
            if (this.mUssdSession != null) {
                this.mUssdSession.sendUssd(ussdString);
                AsyncResult.forMessage(response, null, null);
                response.sendToTarget();
                return;
            }
            if (this.mImsManager == null) {
                this.mPhone.sendErrorResponse(response, this.getImsManagerIsNullException());
                return;
            }
            String[] callees = new String[]{ussdString};
            ImsCallProfile profile = this.mImsManager.createCallProfile(this.mServiceId, 1, 2);
            profile.setCallExtraInt("dialstring", 2);
            this.mUssdSession = this.mImsManager.makeCall(this.mServiceId, profile, callees, this.mImsUssdListener);
        }
        catch (ImsException e) {
            this.loge("sendUSSD : " + e);
            this.mPhone.sendErrorResponse(response, e);
            this.retryGetImsService();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cancelUSSD() {
        if (this.mUssdSession == null) {
            return;
        }
        try {
            this.mUssdSession.terminate(501);
        }
        catch (ImsException imsException) {
            // empty catch block
        }
    }

    private final synchronized ImsPhoneConnection $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$findConnection(ImsCall imsCall) {
        for (ImsPhoneConnection conn : this.mConnections) {
            if (conn.getImsCall() != imsCall) continue;
            return conn;
        }
        return null;
    }

    private final synchronized void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$removeConnection(ImsPhoneConnection conn) {
        this.mConnections.remove(conn);
        if (this.mIsInEmergencyCall) {
            boolean isEmergencyCallInList = false;
            for (ImsPhoneConnection imsPhoneConnection : this.mConnections) {
                if (imsPhoneConnection == null || !imsPhoneConnection.isEmergency()) continue;
                isEmergencyCallInList = true;
                break;
            }
            if (!isEmergencyCallInList) {
                this.mIsInEmergencyCall = false;
                this.mPhone.sendEmergencyCallStateChange(false);
            }
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$addConnection(ImsPhoneConnection conn) {
        this.mConnections.add(conn);
        if (conn.isEmergency()) {
            this.mIsInEmergencyCall = true;
            this.mPhone.sendEmergencyCallStateChange(true);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$processCallStateChange(ImsCall imsCall, Call.State state, int cause) {
        this.log("processCallStateChange " + imsCall + " state=" + (Object)((Object)state) + " cause=" + cause);
        this.processCallStateChange(imsCall, state, cause, false);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$processCallStateChange(ImsCall imsCall, Call.State state, int cause, boolean ignoreState) {
        this.log("processCallStateChange state=" + (Object)((Object)state) + " cause=" + cause + " ignoreState=" + ignoreState);
        if (imsCall == null) {
            return;
        }
        boolean changed = false;
        ImsPhoneConnection conn = this.findConnection(imsCall);
        if (conn == null) {
            return;
        }
        conn.updateMediaCapabilities(imsCall);
        if (ignoreState) {
            conn.updateAddressDisplay(imsCall);
            conn.updateExtras(imsCall);
            this.maybeSetVideoCallProvider(conn, imsCall);
            return;
        }
        changed = conn.update(imsCall, state);
        if (state == Call.State.DISCONNECTED) {
            changed = conn.onDisconnect(cause) || changed;
            ((ImsPhoneCall)conn.getCall()).detach(conn);
            this.removeConnection(conn);
        }
        if (changed) {
            if (conn.getCall() == this.mHandoverCall) {
                return;
            }
            this.updatePhoneState();
            this.mPhone.notifyPreciseCallStateChanged();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$maybeSetVideoCallProvider(ImsPhoneConnection conn, ImsCall imsCall) {
        Connection.VideoProvider connVideoProvider = conn.getVideoProvider();
        if (connVideoProvider != null || imsCall.getCallSession().getVideoCallProvider() == null) {
            return;
        }
        try {
            this.setVideoCallProvider(conn, imsCall);
        }
        catch (RemoteException e) {
            this.loge("maybeSetVideoCallProvider: exception " + e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$addReasonCodeRemapping(Integer fromCode, String message, Integer toCode) {
        this.mImsReasonCodeMap.put(new Pair<Integer, String>(fromCode, message), toCode);
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$maybeRemapReasonCode(ImsReasonInfo reasonInfo) {
        int code = reasonInfo.getCode();
        Pair<Integer, String> toCheck = new Pair<Integer, String>(code, reasonInfo.getExtraMessage());
        Pair<Object, String> wildcardToCheck = new Pair<Object, String>(null, reasonInfo.getExtraMessage());
        if (this.mImsReasonCodeMap.containsKey(toCheck)) {
            int toCode = this.mImsReasonCodeMap.get(toCheck);
            this.log("maybeRemapReasonCode : fromCode = " + reasonInfo.getCode() + " ; message = " + reasonInfo.getExtraMessage() + " ; toCode = " + toCode);
            return toCode;
        }
        if (this.mImsReasonCodeMap.containsKey(wildcardToCheck)) {
            int toCode = this.mImsReasonCodeMap.get(wildcardToCheck);
            this.log("maybeRemapReasonCode : fromCode(wildcard) = " + reasonInfo.getCode() + " ; message = " + reasonInfo.getExtraMessage() + " ; toCode = " + toCode);
            return toCode;
        }
        return code;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getDisconnectCauseFromReasonInfo(ImsReasonInfo reasonInfo) {
        int cause = 36;
        int code = this.maybeRemapReasonCode(reasonInfo);
        switch (code) {
            case 337: 
            case 341: {
                return 8;
            }
            case 338: {
                return 4;
            }
            case 501: {
                return 3;
            }
            case 108: {
                return 45;
            }
            case 143: 
            case 1404: {
                return 16;
            }
            case 510: {
                return 2;
            }
            case 332: {
                return 12;
            }
            case 321: 
            case 331: 
            case 340: 
            case 361: 
            case 362: {
                return 12;
            }
            case 333: 
            case 352: 
            case 354: {
                return 9;
            }
            case 106: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 131: 
            case 132: 
            case 144: {
                return 18;
            }
            case 201: 
            case 202: 
            case 203: 
            case 335: {
                return 13;
            }
            case 111: 
            case 112: {
                return 17;
            }
            case 241: {
                return 21;
            }
            case 1014: {
                return 52;
            }
            case 1016: {
                return 51;
            }
            case 1403: {
                return 53;
            }
            case 1406: {
                return 54;
            }
            case 1405: {
                return 55;
            }
            case 1407: {
                return 59;
            }
        }
        return cause;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getPreciseDisconnectCauseFromReasonInfo(ImsReasonInfo reasonInfo) {
        return PRECISE_CAUSE_MAP.get(this.maybeRemapReasonCode(reasonInfo), 65535);
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isPhoneInEcbMode() {
        return this.mPhone.isInEcm();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dialPendingMO() {
        boolean isPhoneInEcmMode = this.isPhoneInEcbMode();
        boolean isEmergencyNumber = this.mPendingMO.isEmergency();
        if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyNumber) {
            this.sendEmptyMessage(20);
        } else {
            this.sendEmptyMessage(21);
        }
    }

    private final ImsUtInterface $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getUtInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw this.getImsManagerIsNullException();
        }
        ImsUtInterface ut = this.mImsManager.getSupplementaryServiceConfiguration();
        return ut;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$transferHandoverConnections(ImsPhoneCall call) {
        if (call.mConnections != null) {
            for (Connection c : call.mConnections) {
                c.mPreHandoverState = call.mState;
                this.log("Connection state before handover is " + (Object)((Object)c.getStateBeforeHandover()));
            }
        }
        if (this.mHandoverCall.mConnections == null) {
            this.mHandoverCall.mConnections = call.mConnections;
        } else {
            this.mHandoverCall.mConnections.addAll(call.mConnections);
        }
        if (this.mHandoverCall.mConnections != null) {
            if (call.getImsCall() != null) {
                call.getImsCall().close();
            }
            for (Connection c : this.mHandoverCall.mConnections) {
                ((ImsPhoneConnection)c).changeParent(this.mHandoverCall);
                ((ImsPhoneConnection)c).releaseWakeLock();
            }
        }
        if (call.getState().isAlive()) {
            this.log("Call is alive and state is " + (Object)((Object)call.mState));
            this.mHandoverCall.mState = call.mState;
        }
        call.mConnections.clear();
        call.mState = Call.State.IDLE;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$notifySrvccState(Call.SrvccState state) {
        this.log("notifySrvccState state=" + (Object)((Object)state));
        this.mSrvccState = state;
        if (this.mSrvccState == Call.SrvccState.COMPLETED) {
            this.transferHandoverConnections(this.mForegroundCall);
            this.transferHandoverConnections(this.mBackgroundCall);
            this.transferHandoverConnections(this.mRingingCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleMessage(Message msg) {
        this.log("handleMessage what=" + msg.what);
        switch (msg.what) {
            case 18: {
                if (this.mPendingMO != null) {
                    this.mPendingMO.onDisconnect();
                    this.removeConnection(this.mPendingMO);
                    this.mPendingMO = null;
                }
                this.mPendingIntentExtras = null;
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                break;
            }
            case 19: {
                try {
                    this.resumeWaitingOrHolding();
                }
                catch (CallStateException e) {
                    this.loge("handleMessage EVENT_RESUME_BACKGROUND exception=" + e);
                }
                break;
            }
            case 20: {
                this.dialInternal(this.mPendingMO, this.mClirMode, this.mPendingCallVideoState, this.mPendingIntentExtras);
                this.mPendingIntentExtras = null;
                break;
            }
            case 21: {
                if (this.mPendingMO == null) break;
                try {
                    this.getEcbmInterface().exitEmergencyCallbackMode();
                    this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                    this.pendingCallClirMode = this.mClirMode;
                    this.pendingCallInEcm = true;
                }
                catch (ImsException e) {
                    e.printStackTrace();
                    this.mPendingMO.setDisconnectCause(36);
                    this.sendEmptyMessageDelayed(18, 500L);
                }
                break;
            }
            case 14: {
                if (this.pendingCallInEcm) {
                    this.dialInternal(this.mPendingMO, this.pendingCallClirMode, this.mPendingCallVideoState, this.mPendingIntentExtras);
                    this.mPendingIntentExtras = null;
                    this.pendingCallInEcm = false;
                }
                this.mPhone.unsetOnEcbModeExitResponse(this);
                break;
            }
            case 22: {
                AsyncResult ar = (AsyncResult)msg.obj;
                ImsCall call = (ImsCall)ar.userObj;
                Long usage = (long)((Long)ar.result);
                this.log("VT data usage update. usage = " + usage + ", imsCall = " + call);
                Long oldUsage = 0L;
                if (this.mVtDataUsageMap.containsKey(call.uniqueId)) {
                    oldUsage = this.mVtDataUsageMap.get(call.uniqueId);
                }
                this.mTotalVtDataUsage += usage - oldUsage;
                this.mVtDataUsageMap.put(call.uniqueId, usage);
                break;
            }
            case 23: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (!(ar.result instanceof Pair)) break;
                Pair p = (Pair)ar.result;
                this.onDataEnabledChanged((Boolean)p.first, (Integer)p.second);
                break;
            }
            case 24: {
                try {
                    this.getImsService();
                }
                catch (ImsException e) {
                    this.loge("getImsService: " + e);
                    this.retryGetImsService();
                }
                break;
            }
            case 25: {
                ImsPhoneConnection conn;
                ImsCall imsCall;
                if (!(msg.obj instanceof ImsCall) || (imsCall = (ImsCall)msg.obj).isWifiCall() || (conn = this.findConnection(imsCall)) == null) break;
                conn.onHandoverToWifiFailed();
                break;
            }
            case 26: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    int serviceClass = args.argi1;
                    int[] enabledFeatures = (int[])args.arg1;
                    int[] disabledFeatures = (int[])args.arg2;
                    this.handleFeatureCapabilityChanged(serviceClass, enabledFeatures, disabledFeatures);
                    break;
                }
                finally {
                    args.recycle();
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$log(String msg) {
        Rlog.d("ImsPhoneCallTracker", "[ImsPhoneCallTracker] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$loge(String msg) {
        Rlog.e("ImsPhoneCallTracker", "[ImsPhoneCallTracker] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$logState() {
        if (!VERBOSE_STATE_LOGGING) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Current IMS PhoneCall State:\n");
        sb.append(" Foreground: ");
        sb.append(this.mForegroundCall);
        sb.append("\n");
        sb.append(" Background: ");
        sb.append(this.mBackgroundCall);
        sb.append("\n");
        sb.append(" Ringing: ");
        sb.append(this.mRingingCall);
        sb.append("\n");
        sb.append(" Handover: ");
        sb.append(this.mHandoverCall);
        sb.append("\n");
        Rlog.v("ImsPhoneCallTracker", sb.toString());
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsPhoneCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mHandoverCall=" + this.mHandoverCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mState=" + (Object)((Object)this.mState));
        for (int i = 0; i < this.mImsFeatureEnabled.length; ++i) {
            pw.println(" " + this.mImsFeatureStrings[i] + ": " + (this.mImsFeatureEnabled[i] ? "enabled" : "disabled"));
        }
        pw.println(" mTotalVtDataUsage=" + this.mTotalVtDataUsage);
        for (Map.Entry<Integer, Long> entry : this.mVtDataUsageMap.entrySet()) {
            pw.println("    id=" + entry.getKey() + " ,usage=" + entry.getValue());
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            if (this.mImsManager != null) {
                this.mImsManager.dump(fd, pw, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mConnections != null && this.mConnections.size() > 0) {
            pw.println("mConnections:");
            for (int i = 0; i < this.mConnections.size(); ++i) {
                pw.println("  [" + i + "]: " + this.mConnections.get(i));
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handlePollCalls(AsyncResult ar) {
    }

    private final ImsEcbm $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getEcbmInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw this.getImsManagerIsNullException();
        }
        ImsEcbm ecbm = this.mImsManager.getEcbmInterface(this.mServiceId);
        return ecbm;
    }

    private final ImsMultiEndpoint $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getMultiEndpointInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw this.getImsManagerIsNullException();
        }
        try {
            return this.mImsManager.getMultiEndpointInterface(this.mServiceId);
        }
        catch (ImsException e) {
            if (e.getCode() == 902) {
                return null;
            }
            throw e;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVolteEnabled() {
        return this.mImsFeatureEnabled[0];
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVowifiEnabled() {
        return this.mImsFeatureEnabled[2];
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVideoCallEnabled() {
        return this.mImsFeatureEnabled[1] || this.mImsFeatureEnabled[3];
    }

    private final PhoneConstants.State $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getState() {
        return this.mState;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$retryGetImsService() {
        if (this.mImsManager.isServiceAvailable()) {
            return;
        }
        this.mImsManager = null;
        this.loge("getImsService: Retrying getting ImsService...");
        this.removeMessages(24);
        this.sendEmptyMessageDelayed(24, this.mRetryTimeout.get());
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setVideoCallProvider(ImsPhoneConnection conn, ImsCall imsCall) throws RemoteException {
        IImsVideoCallProvider imsVideoCallProvider = imsCall.getCallSession().getVideoCallProvider();
        if (imsVideoCallProvider != null) {
            boolean useVideoPauseWorkaround = this.mPhone.getContext().getResources().getBoolean(17957034);
            ImsVideoCallProviderWrapper imsVideoCallProviderWrapper = new ImsVideoCallProviderWrapper(imsVideoCallProvider);
            if (useVideoPauseWorkaround) {
                imsVideoCallProviderWrapper.setUseVideoPauseWorkaround(useVideoPauseWorkaround);
            }
            conn.setVideoProvider(imsVideoCallProviderWrapper);
            imsVideoCallProviderWrapper.registerForDataUsageUpdate(this, 22, imsCall);
            imsVideoCallProviderWrapper.addImsVideoProviderCallback(conn);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isUtEnabled() {
        return this.mImsFeatureEnabled[4] || this.mImsFeatureEnabled[5];
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cleanseInstantLetteringMessage(String callSubject) {
        String escapedCharacters;
        if (TextUtils.isEmpty(callSubject)) {
            return callSubject;
        }
        CarrierConfigManager configMgr = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        if (configMgr == null) {
            return callSubject;
        }
        PersistableBundle carrierConfig = configMgr.getConfigForSubId(this.mPhone.getSubId());
        if (carrierConfig == null) {
            return callSubject;
        }
        String invalidCharacters = carrierConfig.getString("carrier_instant_lettering_invalid_chars_string");
        if (!TextUtils.isEmpty(invalidCharacters)) {
            callSubject = callSubject.replaceAll(invalidCharacters, "");
        }
        if (!TextUtils.isEmpty(escapedCharacters = carrierConfig.getString("carrier_instant_lettering_escaped_chars_string"))) {
            callSubject = this.escapeChars(escapedCharacters, callSubject);
        }
        return callSubject;
    }

    private final String $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$escapeChars(String toEscape, String source) {
        StringBuilder escaped = new StringBuilder();
        for (char c : source.toCharArray()) {
            if (toEscape.contains(Character.toString(c))) {
                escaped.append("\\");
            }
            escaped.append(c);
        }
        return escaped.toString();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$pullExternalCall(String number, int videoState, int dialogId) {
        Bundle extras = new Bundle();
        extras.putBoolean("CallPull", true);
        extras.putInt("android.telephony.ImsExternalCallTracker.extra.EXTERNAL_CALL_ID", dialogId);
        try {
            Connection connection = this.dial(number, videoState, extras);
            this.mPhone.notifyUnknownConnection(connection);
        }
        catch (CallStateException e) {
            this.loge("pullExternalCall failed - " + e);
        }
    }

    private final ImsException $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getImsManagerIsNullException() {
        return new ImsException("no ims manager", 102);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$shouldDisconnectActiveCallOnAnswer(ImsCall activeCall, ImsCall incomingCall) {
        if (activeCall == null || incomingCall == null) {
            return false;
        }
        if (!this.mDropVideoCallWhenAnsweringAudioCall) {
            return false;
        }
        isActiveCallVideo = activeCall.isVideoCall() != false || this.mTreatDowngradedVideoCallsAsVideoCalls != false && activeCall.wasVideoCall() != false;
        isActiveCallOnWifi = activeCall.isWifiCall();
        if (!ImsManager.isWfcEnabledByPlatform(this.mPhone.getContext())) ** GOTO lbl-1000
        if (ImsManager.isWfcEnabledByUser(this.mPhone.getContext())) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isVoWifiEnabled = v0;
        isIncomingCallAudio = incomingCall.isVideoCall() == false;
        this.log("shouldDisconnectActiveCallOnAnswer : isActiveCallVideo=" + isActiveCallVideo + " isActiveCallOnWifi=" + isActiveCallOnWifi + " isIncomingCallAudio=" + isIncomingCallAudio + " isVowifiEnabled=" + isVoWifiEnabled);
        return isActiveCallVideo != false && isActiveCallOnWifi != false && isIncomingCallAudio != false && isVoWifiEnabled == false;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getVtDataUsage() {
        if (this.mState != PhoneConstants.State.IDLE) {
            for (ImsPhoneConnection conn : this.mConnections) {
                Connection.VideoProvider videoProvider = conn.getVideoProvider();
                if (videoProvider == null) continue;
                videoProvider.onRequestConnectionDataUsage();
            }
        }
        return this.mTotalVtDataUsage;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerPhoneStateListener(PhoneStateListener listener) {
        this.mPhoneStateListeners.add(listener);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterPhoneStateListener(PhoneStateListener listener) {
        this.mPhoneStateListeners.remove(listener);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$notifyPhoneStateChanged(PhoneConstants.State oldState, PhoneConstants.State newState) {
        for (PhoneStateListener listener : this.mPhoneStateListeners) {
            listener.onPhoneStateChanged(oldState, newState);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$modifyVideoCall(ImsCall imsCall, int newVideoState) {
        ImsPhoneConnection conn = this.findConnection(imsCall);
        if (conn != null) {
            int oldVideoState = conn.getVideoState();
            if (conn.getVideoProvider() != null) {
                conn.getVideoProvider().onSendSessionModifyRequest(new VideoProfile(oldVideoState), new VideoProfile(newVideoState));
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$onDataEnabledChanged(boolean enabled, int reason) {
        this.log("onDataEnabledChanged: enabled=" + enabled + ", reason=" + reason);
        ImsManager.getInstance(this.mPhone.getContext(), this.mPhone.getPhoneId()).setDataEnabled(enabled);
        this.mIsDataEnabled = enabled;
        if (this.mIgnoreDataEnabledChangedForVideoCalls) {
            this.log("Ignore data " + (enabled ? "enabled" : "disabled") + " due to carrier policy.");
            return;
        }
        if (this.mIgnoreDataEnabledChangedForVideoCalls) {
            this.log("Ignore data " + (enabled ? "enabled" : "disabled") + " due to carrier policy.");
            return;
        }
        if (!enabled) {
            int reasonCode = reason == 3 ? 1405 : (reason == 2 ? 1406 : 1406);
            for (ImsPhoneConnection conn : this.mConnections) {
                ImsCall imsCall = conn.getImsCall();
                if (imsCall == null || !imsCall.isVideoCall() || imsCall.isWifiCall()) continue;
                if (conn.hasCapabilities(3)) {
                    if (reasonCode == 1406) {
                        conn.onConnectionEvent("android.telephony.event.EVENT_DOWNGRADE_DATA_DISABLED", null);
                    } else if (reasonCode == 1405) {
                        conn.onConnectionEvent("android.telephony.event.EVENT_DOWNGRADE_DATA_LIMIT_REACHED", null);
                    }
                    this.modifyVideoCall(imsCall, 0);
                    continue;
                }
                if (this.mSupportPauseVideo) {
                    this.mShouldUpdateImsConfigOnDisconnect = true;
                    conn.pauseVideo(2);
                    continue;
                }
                try {
                    imsCall.terminate(501, reasonCode);
                }
                catch (ImsException ie) {
                    this.loge("Couldn't terminate call " + imsCall);
                }
            }
        } else if (this.mSupportPauseVideo) {
            for (ImsPhoneConnection conn : this.mConnections) {
                this.log("onDataEnabledChanged - resuming " + conn);
                if (!VideoProfile.isPaused(conn.getVideoState()) || !conn.wasVideoPausedFromSource(2)) continue;
                conn.resumeVideo(2);
            }
            this.mShouldUpdateImsConfigOnDisconnect = false;
        }
        if (!this.mShouldUpdateImsConfigOnDisconnect) {
            ImsManager.updateImsServiceConfig(this.mPhone.getContext(), this.mPhone.getPhoneId(), true);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$resetImsCapabilities() {
        this.log("Resetting Capabilities...");
        for (int i = 0; i < this.mImsFeatureEnabled.length; ++i) {
            this.mImsFeatureEnabled[i] = false;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isWifiConnected() {
        NetworkInfo ni;
        ConnectivityManager cm = (ConnectivityManager)this.mPhone.getContext().getSystemService("connectivity");
        if (cm != null && (ni = cm.getActiveNetworkInfo()) != null && ni.isConnected()) {
            return ni.getType() == 1;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isCarrierDowngradeOfVtCallSupported() {
        return this.mSupportDowngradeVtToAudio;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) {
        if (serviceClass == 1) {
            boolean tmpIsVideoCallEnabled = this.isVideoCallEnabled();
            StringBuilder sb = new StringBuilder(120);
            sb.append("handleFeatureCapabilityChanged: ");
            for (int i = 0; i <= 5 && i < enabledFeatures.length; ++i) {
                if (enabledFeatures[i] == i) {
                    sb.append(this.mImsFeatureStrings[i]);
                    sb.append(":true ");
                    this.mImsFeatureEnabled[i] = true;
                    continue;
                }
                if (enabledFeatures[i] == -1) {
                    sb.append(this.mImsFeatureStrings[i]);
                    sb.append(":false ");
                    this.mImsFeatureEnabled[i] = false;
                    continue;
                }
                this.loge("handleFeatureCapabilityChanged(" + i + ", " + this.mImsFeatureStrings[i] + "): unexpectedValue=" + enabledFeatures[i]);
            }
            boolean isVideoEnabled = this.isVideoCallEnabled();
            boolean isVideoEnabledStatechanged = tmpIsVideoCallEnabled != isVideoEnabled;
            sb.append(" isVideoEnabledStateChanged=");
            sb.append(isVideoEnabledStatechanged);
            if (isVideoEnabledStatechanged) {
                this.log("handleFeatureCapabilityChanged - notifyForVideoCapabilityChanged=" + isVideoEnabled);
                this.mPhone.notifyForVideoCapabilityChanged(isVideoEnabled);
            }
            this.log(sb.toString());
            this.log("handleFeatureCapabilityChanged: isVolteEnabled=" + this.isVolteEnabled() + ", isVideoCallEnabled=" + this.isVideoCallEnabled() + ", isVowifiEnabled=" + this.isVowifiEnabled() + ", isUtEnabled=" + this.isUtEnabled());
            this.mPhone.onFeatureCapabilityChanged();
            this.mMetrics.writeOnImsCapabilities(this.mPhone.getPhoneId(), this.mImsFeatureEnabled);
        }
    }

    static void __staticInitializer__() {
        VERBOSE_STATE_LOGGING = Rlog.isLoggable("IPCTState", 2);
        PRECISE_CAUSE_MAP = new SparseIntArray();
        PRECISE_CAUSE_MAP.append(101, 1200);
        PRECISE_CAUSE_MAP.append(102, 1201);
        PRECISE_CAUSE_MAP.append(103, 1202);
        PRECISE_CAUSE_MAP.append(106, 1203);
        PRECISE_CAUSE_MAP.append(107, 1204);
        PRECISE_CAUSE_MAP.append(108, 16);
        PRECISE_CAUSE_MAP.append(111, 1205);
        PRECISE_CAUSE_MAP.append(112, 1206);
        PRECISE_CAUSE_MAP.append(121, 1207);
        PRECISE_CAUSE_MAP.append(122, 1208);
        PRECISE_CAUSE_MAP.append(123, 1209);
        PRECISE_CAUSE_MAP.append(124, 1210);
        PRECISE_CAUSE_MAP.append(131, 1211);
        PRECISE_CAUSE_MAP.append(132, 1212);
        PRECISE_CAUSE_MAP.append(141, 1213);
        PRECISE_CAUSE_MAP.append(143, 1214);
        PRECISE_CAUSE_MAP.append(144, 1215);
        PRECISE_CAUSE_MAP.append(145, 1216);
        PRECISE_CAUSE_MAP.append(146, 1217);
        PRECISE_CAUSE_MAP.append(147, 1218);
        PRECISE_CAUSE_MAP.append(148, 1219);
        PRECISE_CAUSE_MAP.append(149, 1220);
        PRECISE_CAUSE_MAP.append(201, 1221);
        PRECISE_CAUSE_MAP.append(202, 1222);
        PRECISE_CAUSE_MAP.append(203, 1223);
        PRECISE_CAUSE_MAP.append(241, 241);
        PRECISE_CAUSE_MAP.append(321, 1300);
        PRECISE_CAUSE_MAP.append(331, 1310);
        PRECISE_CAUSE_MAP.append(332, 1311);
        PRECISE_CAUSE_MAP.append(333, 1312);
        PRECISE_CAUSE_MAP.append(334, 1313);
        PRECISE_CAUSE_MAP.append(335, 1314);
        PRECISE_CAUSE_MAP.append(336, 1315);
        PRECISE_CAUSE_MAP.append(337, 1316);
        PRECISE_CAUSE_MAP.append(338, 1317);
        PRECISE_CAUSE_MAP.append(339, 1318);
        PRECISE_CAUSE_MAP.append(340, 1319);
        PRECISE_CAUSE_MAP.append(341, 1320);
        PRECISE_CAUSE_MAP.append(342, 1321);
        PRECISE_CAUSE_MAP.append(351, 1330);
        PRECISE_CAUSE_MAP.append(352, 1331);
        PRECISE_CAUSE_MAP.append(353, 1332);
        PRECISE_CAUSE_MAP.append(354, 1333);
        PRECISE_CAUSE_MAP.append(361, 1340);
        PRECISE_CAUSE_MAP.append(362, 1341);
        PRECISE_CAUSE_MAP.append(363, 1342);
        PRECISE_CAUSE_MAP.append(364, 1343);
        PRECISE_CAUSE_MAP.append(401, 1400);
        PRECISE_CAUSE_MAP.append(402, 1401);
        PRECISE_CAUSE_MAP.append(403, 1402);
        PRECISE_CAUSE_MAP.append(404, 1403);
        PRECISE_CAUSE_MAP.append(501, 1500);
        PRECISE_CAUSE_MAP.append(502, 1501);
        PRECISE_CAUSE_MAP.append(503, 1502);
        PRECISE_CAUSE_MAP.append(504, 1503);
        PRECISE_CAUSE_MAP.append(505, 1504);
        PRECISE_CAUSE_MAP.append(506, 1505);
        PRECISE_CAUSE_MAP.append(510, 1510);
        PRECISE_CAUSE_MAP.append(801, 1800);
        PRECISE_CAUSE_MAP.append(802, 1801);
        PRECISE_CAUSE_MAP.append(803, 1802);
        PRECISE_CAUSE_MAP.append(804, 1803);
        PRECISE_CAUSE_MAP.append(821, 1804);
        PRECISE_CAUSE_MAP.append(901, 1900);
        PRECISE_CAUSE_MAP.append(902, 1901);
        PRECISE_CAUSE_MAP.append(1100, 2000);
        PRECISE_CAUSE_MAP.append(1014, 2100);
        PRECISE_CAUSE_MAP.append(1015, 2101);
        PRECISE_CAUSE_MAP.append(1016, 2102);
        PRECISE_CAUSE_MAP.append(1201, 2300);
        PRECISE_CAUSE_MAP.append(1202, 2301);
        PRECISE_CAUSE_MAP.append(1203, 2302);
        PRECISE_CAUSE_MAP.append(1300, 2400);
        PRECISE_CAUSE_MAP.append(1400, 2500);
        PRECISE_CAUSE_MAP.append(1401, 2501);
        PRECISE_CAUSE_MAP.append(1402, 2502);
        PRECISE_CAUSE_MAP.append(1403, 2503);
        PRECISE_CAUSE_MAP.append(1404, 2504);
        PRECISE_CAUSE_MAP.append(1405, 2505);
        PRECISE_CAUSE_MAP.append(1406, 2506);
        PRECISE_CAUSE_MAP.append(1407, 2507);
        PRECISE_CAUSE_MAP.append(1500, 247);
        PRECISE_CAUSE_MAP.append(1501, 249);
        PRECISE_CAUSE_MAP.append(1502, 250);
        PRECISE_CAUSE_MAP.append(1503, 251);
        PRECISE_CAUSE_MAP.append(1504, 252);
        PRECISE_CAUSE_MAP.append(1505, 253);
        PRECISE_CAUSE_MAP.append(1506, 254);
        PRECISE_CAUSE_MAP.append(1507, 255);
        PRECISE_CAUSE_MAP.append(1508, 256);
        PRECISE_CAUSE_MAP.append(1509, 257);
        PRECISE_CAUSE_MAP.append(1510, 258);
        PRECISE_CAUSE_MAP.append(1511, 259);
        PRECISE_CAUSE_MAP.append(1512, 260);
        PRECISE_CAUSE_MAP.append(1513, 261);
        PRECISE_CAUSE_MAP.append(61441, 61441);
        PRECISE_CAUSE_MAP.append(61442, 61442);
        PRECISE_CAUSE_MAP.append(61443, 61443);
        PRECISE_CAUSE_MAP.append(61444, 61444);
        PRECISE_CAUSE_MAP.append(61445, 61445);
        PRECISE_CAUSE_MAP.append(61446, 61446);
        PRECISE_CAUSE_MAP.append(61447, 61447);
        PRECISE_CAUSE_MAP.append(61448, 61448);
        PRECISE_CAUSE_MAP.append(61449, 61449);
        PRECISE_CAUSE_MAP.append(61450, 61450);
        PRECISE_CAUSE_MAP.append(61451, 61451);
        PRECISE_CAUSE_MAP.append(61452, 61452);
        PRECISE_CAUSE_MAP.append(61453, 61453);
        PRECISE_CAUSE_MAP.append(61454, 61454);
        PRECISE_CAUSE_MAP.append(61455, 61455);
    }

    private void __constructor__(ImsPhone imsPhone) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$__constructor__(imsPhone);
    }

    public ImsPhoneCallTracker(ImsPhone imsPhone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$__constructor__(com.android.internal.telephony.imsphone.ImsPhone ), this, imsPhone);
    }

    private PendingIntent createIncomingCallPendingIntent() {
        return InvokeDynamicSupport.bootstrap("createIncomingCallPendingIntent", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$createIncomingCallPendingIntent(), this);
    }

    private void getImsService() throws ImsException {
        InvokeDynamicSupport.bootstrap("getImsService", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getImsService(), this);
    }

    private void startListeningForCalls() throws ImsException {
        InvokeDynamicSupport.bootstrap("startListeningForCalls", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$startListeningForCalls(), this);
    }

    private void stopListeningForCalls() {
        InvokeDynamicSupport.bootstrap("stopListeningForCalls", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$stopListeningForCalls(), this);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dispose(), this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$finalize(), this);
    }

    @Override
    public void registerForVoiceCallStarted(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallStarted(android.os.Handler int java.lang.Object ), this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallStarted", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallStarted(android.os.Handler ), this, handler);
    }

    @Override
    public void registerForVoiceCallEnded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallEnded", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerForVoiceCallEnded(android.os.Handler int java.lang.Object ), this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallEnded", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterForVoiceCallEnded(android.os.Handler ), this, handler);
    }

    public Connection dial(String string2, int n, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(java.lang.String int android.os.Bundle ), this, string2, n, bundle);
    }

    synchronized Connection dial(String string2, int n, int n2, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dial(java.lang.String int int android.os.Bundle ), this, string2, n, n2, bundle);
    }

    private void cacheCarrierConfiguration(int n) {
        InvokeDynamicSupport.bootstrap("cacheCarrierConfiguration", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cacheCarrierConfiguration(int ), this, n);
    }

    private void handleEcmTimer(int n) {
        InvokeDynamicSupport.bootstrap("handleEcmTimer", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleEcmTimer(int ), this, n);
    }

    private void dialInternal(ImsPhoneConnection imsPhoneConnection, int n, int n2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dialInternal(com.android.internal.telephony.imsphone.ImsPhoneConnection int int android.os.Bundle ), this, imsPhoneConnection, n, n2, bundle);
    }

    public void acceptCall(int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$acceptCall(int ), this, n);
    }

    public void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$rejectCall(), this);
    }

    private void switchAfterConferenceSuccess() {
        InvokeDynamicSupport.bootstrap("switchAfterConferenceSuccess", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$switchAfterConferenceSuccess(), this);
    }

    public void switchWaitingOrHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchWaitingOrHoldingAndActive", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$switchWaitingOrHoldingAndActive(), this);
    }

    public void conference() {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$conference(), this);
    }

    public void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$explicitCallTransfer(), this);
    }

    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$clearDisconnected(), this);
    }

    public boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canConference(), this);
    }

    public boolean canDial() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDial", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canDial(), this);
    }

    public boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$canTransfer(), this);
    }

    private void internalClearDisconnected() {
        InvokeDynamicSupport.bootstrap("internalClearDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$internalClearDisconnected(), this);
    }

    private void updatePhoneState() {
        InvokeDynamicSupport.bootstrap("updatePhoneState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$updatePhoneState(), this);
    }

    private void handleRadioNotAvailable() {
        InvokeDynamicSupport.bootstrap("handleRadioNotAvailable", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleRadioNotAvailable(), this);
    }

    private void dumpState() {
        InvokeDynamicSupport.bootstrap("dumpState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dumpState(), this);
    }

    public void setUiTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setUiTTYMode", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setUiTTYMode(int android.os.Message ), this, n, message);
    }

    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setMute(boolean ), this, bl);
    }

    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getMute(), this);
    }

    public void sendDtmf(char c, Message message) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendDtmf(char android.os.Message ), this, c, message);
    }

    public void startDtmf(char c) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$startDtmf(char ), this, c);
    }

    public void stopDtmf() {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$stopDtmf(), this);
    }

    public void hangup(ImsPhoneConnection imsPhoneConnection) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(com.android.internal.telephony.imsphone.ImsPhoneConnection ), this, imsPhoneConnection);
    }

    public void hangup(ImsPhoneCall imsPhoneCall) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$hangup(com.android.internal.telephony.imsphone.ImsPhoneCall ), this, imsPhoneCall);
    }

    void callEndCleanupHandOverCallIfAny() {
        InvokeDynamicSupport.bootstrap("callEndCleanupHandOverCallIfAny", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$callEndCleanupHandOverCallIfAny(), this);
    }

    void resumeWaitingOrHolding() throws CallStateException {
        InvokeDynamicSupport.bootstrap("resumeWaitingOrHolding", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$resumeWaitingOrHolding(), this);
    }

    public void sendUSSD(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$sendUSSD(java.lang.String android.os.Message ), this, string2, message);
    }

    public void cancelUSSD() {
        InvokeDynamicSupport.bootstrap("cancelUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cancelUSSD(), this);
    }

    private synchronized ImsPhoneConnection findConnection(ImsCall imsCall) {
        return InvokeDynamicSupport.bootstrap("findConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$findConnection(com.android.ims.ImsCall ), this, imsCall);
    }

    private synchronized void removeConnection(ImsPhoneConnection imsPhoneConnection) {
        InvokeDynamicSupport.bootstrap("removeConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$removeConnection(com.android.internal.telephony.imsphone.ImsPhoneConnection ), this, imsPhoneConnection);
    }

    private synchronized void addConnection(ImsPhoneConnection imsPhoneConnection) {
        InvokeDynamicSupport.bootstrap("addConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$addConnection(com.android.internal.telephony.imsphone.ImsPhoneConnection ), this, imsPhoneConnection);
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int n) {
        InvokeDynamicSupport.bootstrap("processCallStateChange", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$processCallStateChange(com.android.ims.ImsCall com.android.internal.telephony.Call$State int ), this, imsCall, state, n);
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("processCallStateChange", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$processCallStateChange(com.android.ims.ImsCall com.android.internal.telephony.Call$State int boolean ), this, imsCall, state, n, bl);
    }

    private void maybeSetVideoCallProvider(ImsPhoneConnection imsPhoneConnection, ImsCall imsCall) {
        InvokeDynamicSupport.bootstrap("maybeSetVideoCallProvider", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$maybeSetVideoCallProvider(com.android.internal.telephony.imsphone.ImsPhoneConnection com.android.ims.ImsCall ), this, imsPhoneConnection, imsCall);
    }

    public void addReasonCodeRemapping(Integer n, String string2, Integer n2) {
        InvokeDynamicSupport.bootstrap("addReasonCodeRemapping", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$addReasonCodeRemapping(java.lang.Integer java.lang.String java.lang.Integer ), this, n, string2, n2);
    }

    public int maybeRemapReasonCode(ImsReasonInfo imsReasonInfo) {
        return (int)InvokeDynamicSupport.bootstrap("maybeRemapReasonCode", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$maybeRemapReasonCode(com.android.ims.ImsReasonInfo ), this, imsReasonInfo);
    }

    private int getDisconnectCauseFromReasonInfo(ImsReasonInfo imsReasonInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getDisconnectCauseFromReasonInfo", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getDisconnectCauseFromReasonInfo(com.android.ims.ImsReasonInfo ), this, imsReasonInfo);
    }

    private int getPreciseDisconnectCauseFromReasonInfo(ImsReasonInfo imsReasonInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getPreciseDisconnectCauseFromReasonInfo", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getPreciseDisconnectCauseFromReasonInfo(com.android.ims.ImsReasonInfo ), this, imsReasonInfo);
    }

    private boolean isPhoneInEcbMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneInEcbMode", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isPhoneInEcbMode(), this);
    }

    private void dialPendingMO() {
        InvokeDynamicSupport.bootstrap("dialPendingMO", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dialPendingMO(), this);
    }

    public ImsUtInterface getUtInterface() throws ImsException {
        return InvokeDynamicSupport.bootstrap("getUtInterface", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getUtInterface(), this);
    }

    private void transferHandoverConnections(ImsPhoneCall imsPhoneCall) {
        InvokeDynamicSupport.bootstrap("transferHandoverConnections", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$transferHandoverConnections(com.android.internal.telephony.imsphone.ImsPhoneCall ), this, imsPhoneCall);
    }

    void notifySrvccState(Call.SrvccState srvccState) {
        InvokeDynamicSupport.bootstrap("notifySrvccState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$notifySrvccState(com.android.internal.telephony.Call$SrvccState ), this, srvccState);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleMessage(android.os.Message ), this, message);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$log(java.lang.String ), this, string2);
    }

    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$loge(java.lang.String ), this, string2);
    }

    void logState() {
        InvokeDynamicSupport.bootstrap("logState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$logState(), this);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    protected void handlePollCalls(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handlePollCalls", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handlePollCalls(android.os.AsyncResult ), this, asyncResult);
    }

    ImsEcbm getEcbmInterface() throws ImsException {
        return InvokeDynamicSupport.bootstrap("getEcbmInterface", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getEcbmInterface(), this);
    }

    ImsMultiEndpoint getMultiEndpointInterface() throws ImsException {
        return InvokeDynamicSupport.bootstrap("getMultiEndpointInterface", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getMultiEndpointInterface(), this);
    }

    public boolean isInEmergencyCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEmergencyCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isInEmergencyCall(), this);
    }

    public boolean isVolteEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolteEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVolteEnabled(), this);
    }

    public boolean isVowifiEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVowifiEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVowifiEnabled(), this);
    }

    public boolean isVideoCallEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoCallEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isVideoCallEnabled(), this);
    }

    @Override
    public PhoneConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getState(), this);
    }

    private void retryGetImsService() {
        InvokeDynamicSupport.bootstrap("retryGetImsService", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$retryGetImsService(), this);
    }

    private void setVideoCallProvider(ImsPhoneConnection imsPhoneConnection, ImsCall imsCall) throws RemoteException {
        InvokeDynamicSupport.bootstrap("setVideoCallProvider", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$setVideoCallProvider(com.android.internal.telephony.imsphone.ImsPhoneConnection com.android.ims.ImsCall ), this, imsPhoneConnection, imsCall);
    }

    public boolean isUtEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUtEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isUtEnabled(), this);
    }

    private String cleanseInstantLetteringMessage(String string2) {
        return InvokeDynamicSupport.bootstrap("cleanseInstantLetteringMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$cleanseInstantLetteringMessage(java.lang.String ), this, string2);
    }

    private String escapeChars(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("escapeChars", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$escapeChars(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void pullExternalCall(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("pullExternalCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$pullExternalCall(java.lang.String int int ), this, string2, n, n2);
    }

    private ImsException getImsManagerIsNullException() {
        return InvokeDynamicSupport.bootstrap("getImsManagerIsNullException", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getImsManagerIsNullException(), this);
    }

    private boolean shouldDisconnectActiveCallOnAnswer(ImsCall imsCall, ImsCall imsCall2) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDisconnectActiveCallOnAnswer", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$shouldDisconnectActiveCallOnAnswer(com.android.ims.ImsCall com.android.ims.ImsCall ), this, imsCall, imsCall2);
    }

    public long getVtDataUsage() {
        return (long)InvokeDynamicSupport.bootstrap("getVtDataUsage", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$getVtDataUsage(), this);
    }

    public void registerPhoneStateListener(PhoneStateListener phoneStateListener) {
        InvokeDynamicSupport.bootstrap("registerPhoneStateListener", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$registerPhoneStateListener(com.android.internal.telephony.imsphone.ImsPhoneCallTracker$PhoneStateListener ), this, phoneStateListener);
    }

    public void unregisterPhoneStateListener(PhoneStateListener phoneStateListener) {
        InvokeDynamicSupport.bootstrap("unregisterPhoneStateListener", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$unregisterPhoneStateListener(com.android.internal.telephony.imsphone.ImsPhoneCallTracker$PhoneStateListener ), this, phoneStateListener);
    }

    private void notifyPhoneStateChanged(PhoneConstants.State state, PhoneConstants.State state2) {
        InvokeDynamicSupport.bootstrap("notifyPhoneStateChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$notifyPhoneStateChanged(com.android.internal.telephony.PhoneConstants$State com.android.internal.telephony.PhoneConstants$State ), this, state, state2);
    }

    private void modifyVideoCall(ImsCall imsCall, int n) {
        InvokeDynamicSupport.bootstrap("modifyVideoCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$modifyVideoCall(com.android.ims.ImsCall int ), this, imsCall, n);
    }

    private void onDataEnabledChanged(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("onDataEnabledChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$onDataEnabledChanged(boolean int ), this, bl, n);
    }

    private void resetImsCapabilities() {
        InvokeDynamicSupport.bootstrap("resetImsCapabilities", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$resetImsCapabilities(), this);
    }

    private boolean isWifiConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWifiConnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isWifiConnected(), this);
    }

    public boolean isCarrierDowngradeOfVtCallSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCarrierDowngradeOfVtCallSupported", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$isCarrierDowngradeOfVtCallSupported(), this);
    }

    private void handleFeatureCapabilityChanged(int n, int[] nArray, int[] nArray2) {
        InvokeDynamicSupport.bootstrap("handleFeatureCapabilityChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhoneCallTracker$handleFeatureCapabilityChanged(int int[] int[] ), this, n, nArray, nArray2);
    }

    static {
        RobolectricInternals.classInitializing(ImsPhoneCallTracker.class);
    }

    public /* synthetic */ ImsPhoneCallTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsPhoneCallTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface IRetryTimeout
    extends InstrumentedInterface {
        public int get();
    }

    public static interface PhoneStateListener
    extends InstrumentedInterface {
        public void onPhoneStateChanged(PhoneConstants.State var1, PhoneConstants.State var2);
    }
}

