/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.ResultReceiver;
import android.os.SystemProperties;
import android.telephony.CarrierConfigManager;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UssdResponse;
import android.text.TextUtils;
import com.android.ims.ImsCallForwardInfo;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsEcbmStateListener;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsSsInfo;
import com.android.ims.ImsUtInterface;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.imsphone.ImsExternalCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneBase;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneMmiCode;
import com.android.internal.telephony.uicc.IccRecords;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsPhone
extends ImsPhoneBase
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsPhone";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static int EVENT_SET_CALL_BARRING_DONE = 45;
    private static int EVENT_GET_CALL_BARRING_DONE = 46;
    private static int EVENT_SET_CALL_WAITING_DONE = 47;
    private static int EVENT_GET_CALL_WAITING_DONE = 48;
    private static int EVENT_SET_CLIR_DONE = 49;
    private static int EVENT_GET_CLIR_DONE = 50;
    private static int EVENT_DEFAULT_PHONE_DATA_STATE_CHANGED = 51;
    private static int EVENT_SERVICE_STATE_CHANGED = 52;
    private static int EVENT_VOICE_CALL_ENDED = 53;
    static int RESTART_ECM_TIMER = 0;
    static int CANCEL_ECM_TIMER = 1;
    private static int DEFAULT_ECM_EXIT_TIMER_VALUE = 300000;
    Phone mDefaultPhone;
    ImsPhoneCallTracker mCT;
    ImsExternalCallTracker mExternalCallTracker;
    private ArrayList<ImsPhoneMmiCode> mPendingMMIs;
    private ServiceState mSS;
    private String mLastDialString;
    private PowerManager.WakeLock mWakeLock;
    private Registrant mEcmExitRespRegistrant;
    private RegistrantList mSilentRedialRegistrants;
    private boolean mImsRegistered;
    private boolean mRoaming;
    private RegistrantList mSsnRegistrants;
    private Runnable mExitEcmRunnable;
    private Uri[] mCurrentSubscriberUris;
    private ImsEcbmStateListener mImsEcbmStateListener;
    private BroadcastReceiver mResultReceiver;

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCurrentSubscriberUris(Uri[] currentSubscriberUris) {
        this.mCurrentSubscriberUris = currentSubscriberUris;
    }

    private final Uri[] $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCurrentSubscriberUris() {
        return this.mCurrentSubscriberUris;
    }

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$__constructor__(Context context, PhoneNotifier notifier, Phone defaultPhone) {
    }

    private void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$__constructor__(Context context, PhoneNotifier notifier, Phone defaultPhone, boolean unitTestMode) {
        this.mPendingMMIs = new ArrayList();
        this.mSS = new ServiceState();
        this.mSilentRedialRegistrants = new RegistrantList();
        this.mImsRegistered = false;
        this.mRoaming = false;
        this.mSsnRegistrants = new RegistrantList();
        this.mExitEcmRunnable = new Runnable(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhone this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhone_1$__constructor__(ImsPhone this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone_1$run() {
                this.this$0.exitEmergencyCallbackMode();
            }

            private void __constructor__(ImsPhone imsPhone) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhone_1$__constructor__(imsPhone);
            }
            {
                this.this$0 = imsPhone;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhone_1$__constructor__(com.android.internal.telephony.imsphone.ImsPhone ), this, imsPhone);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_imsphone_ImsPhone_1$run(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mImsEcbmStateListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhone this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhone_2$__constructor__(ImsPhone this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone_2$onECBMEntered() {
                Rlog.d("ImsPhone", "onECBMEntered");
                this.this$0.handleEnterEmergencyCallbackMode();
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone_2$onECBMExited() {
                Rlog.d("ImsPhone", "onECBMExited");
                this.this$0.handleExitEmergencyCallbackMode();
            }

            private void __constructor__(ImsPhone imsPhone) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhone_2$__constructor__(imsPhone);
            }
            {
                this.this$0 = imsPhone;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhone_2$__constructor__(com.android.internal.telephony.imsphone.ImsPhone ), this, imsPhone);
            }

            @Override
            public void onECBMEntered() {
                InvokeDynamicSupport.bootstrap("onECBMEntered", $$robo$$com_android_internal_telephony_imsphone_ImsPhone_2$onECBMEntered(), this);
            }

            @Override
            public void onECBMExited() {
                InvokeDynamicSupport.bootstrap("onECBMExited", $$robo$$com_android_internal_telephony_imsphone_ImsPhone_2$onECBMExited(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mResultReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsPhone this$0;

            private void $$robo$$com_android_internal_telephony_imsphone_ImsPhone_3$__constructor__(ImsPhone this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone_3$onReceive(Context context, Intent intent) {
                if (this.getResultCode() == -1) {
                    CharSequence title = intent.getCharSequenceExtra("alertTitle");
                    CharSequence messageAlert = intent.getCharSequenceExtra("alertMessage");
                    CharSequence messageNotification = intent.getCharSequenceExtra("notificationMessage");
                    Intent resultIntent = new Intent("android.intent.action.MAIN");
                    resultIntent.setClassName("com.android.settings", "com.android.settings.Settings$WifiCallingSettingsActivity");
                    resultIntent.putExtra("alertShow", true);
                    resultIntent.putExtra("alertTitle", title);
                    resultIntent.putExtra("alertMessage", messageAlert);
                    PendingIntent resultPendingIntent = PendingIntent.getActivity(this.this$0.mContext, 0, resultIntent, 0x8000000);
                    Notification notification = new Notification.Builder(this.this$0.mContext).setSmallIcon(17301642).setContentTitle(title).setContentText(messageNotification).setAutoCancel(true).setContentIntent(resultPendingIntent).setStyle(new Notification.BigTextStyle().bigText(messageNotification)).setChannelId("wfc").build();
                    String notificationTag = "wifi_calling";
                    boolean notificationId = true;
                    NotificationManager notificationManager = (NotificationManager)this.this$0.mContext.getSystemService("notification");
                    notificationManager.notify("wifi_calling", 1, notification);
                }
            }

            private void __constructor__(ImsPhone imsPhone) {
                this.$$robo$$com_android_internal_telephony_imsphone_ImsPhone_3$__constructor__(imsPhone);
            }
            {
                this.this$0 = imsPhone;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhone_3$__constructor__(com.android.internal.telephony.imsphone.ImsPhone ), this, imsPhone);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_imsphone_ImsPhone_3$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mDefaultPhone = defaultPhone;
        this.mExternalCallTracker = TelephonyComponentFactory.getInstance().makeImsExternalCallTracker(this);
        this.mCT = TelephonyComponentFactory.getInstance().makeImsPhoneCallTracker(this);
        this.mCT.registerPhoneStateListener(this.mExternalCallTracker);
        this.mExternalCallTracker.setCallPuller(this.mCT);
        this.mSS.setStateOff();
        this.mPhoneId = this.mDefaultPhone.getPhoneId();
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "ImsPhone");
        this.mWakeLock.setReferenceCounted(false);
        if (this.mDefaultPhone.getServiceStateTracker() != null) {
            this.mDefaultPhone.getServiceStateTracker().registerForDataRegStateOrRatChanged(this, 51, null);
        }
        this.updateDataServiceState();
        this.mDefaultPhone.registerForServiceStateChanged(this, 52, null);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dispose() {
        Rlog.d("ImsPhone", "dispose");
        this.mPendingMMIs.clear();
        this.mExternalCallTracker.tearDown();
        this.mCT.unregisterPhoneStateListener(this.mExternalCallTracker);
        this.mCT.unregisterForVoiceCallEnded(this);
        this.mCT.dispose();
        if (this.mDefaultPhone != null && this.mDefaultPhone.getServiceStateTracker() != null) {
            this.mDefaultPhone.getServiceStateTracker().unregisterForDataRegStateOrRatChanged(this);
            this.mDefaultPhone.unregisterForServiceStateChanged(this);
        }
    }

    private final ServiceState $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getServiceState() {
        return this.mSS;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setServiceState(int state) {
        this.mSS.setVoiceRegState(state);
        this.updateDataServiceState();
    }

    private final CallTracker $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCallTracker() {
        return this.mCT;
    }

    private final ImsExternalCallTracker $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getExternalCallTracker() {
        return this.mExternalCallTracker;
    }

    private final List<? extends ImsPhoneMmiCode> $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$acceptCall(int videoState) throws CallStateException {
        this.mCT.acceptCall(videoState);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$canConference() {
        return this.mCT.canConference();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$canDial() {
        return this.mCT.canDial();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$conference() {
        this.mCT.conference();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$canTransfer() {
        return this.mCT.canTransfer();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$explicitCallTransfer() {
        this.mCT.explicitCallTransfer();
    }

    private final ImsPhoneCall $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getForegroundCall() {
        return this.mCT.mForegroundCall;
    }

    private final ImsPhoneCall $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getBackgroundCall() {
        return this.mCT.mBackgroundCall;
    }

    private final ImsPhoneCall $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getRingingCall() {
        return this.mCT.mRingingCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCallDeflectionIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        if (this.getRingingCall().getState() != Call.State.IDLE) {
            Rlog.d("ImsPhone", "MmiCode 0: rejectCall");
            try {
                this.mCT.rejectCall();
            }
            catch (CallStateException e) {
                Rlog.d("ImsPhone", "reject failed", e);
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.REJECT);
            }
        } else if (this.getBackgroundCall().getState() != Call.State.IDLE) {
            Rlog.d("ImsPhone", "MmiCode 0: hangupWaitingOrBackground");
            try {
                this.mCT.hangup((ImsPhoneCall)this.getBackgroundCall());
            }
            catch (CallStateException e) {
                Rlog.d("ImsPhone", "hangup failed", e);
            }
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendUssdResponse(String ussdRequest, CharSequence message, int returnCode, ResultReceiver wrappedCallback) {
        UssdResponse response = new UssdResponse(ussdRequest, message);
        Bundle returnData = new Bundle();
        returnData.putParcelable("USSD_RESPONSE", response);
        wrappedCallback.send(returnCode, returnData);
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleUssdRequest(String ussdRequest, ResultReceiver wrappedCallback) throws CallStateException {
        if (this.mPendingMMIs.size() > 0) {
            Rlog.i("ImsPhone", "handleUssdRequest: queue full: " + Rlog.pii("ImsPhone", (Object)ussdRequest));
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
            return true;
        }
        try {
            this.dialInternal(ussdRequest, 0, null, wrappedCallback);
        }
        catch (CallStateException cse) {
            if ("cs_fallback".equals(cse.getMessage())) {
                throw cse;
            }
            Rlog.w("ImsPhone", "Could not execute USSD " + cse);
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
        }
        catch (Exception e) {
            Rlog.w("ImsPhone", "Could not execute USSD " + e);
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
            return false;
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCallWaitingIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        Call call = this.getForegroundCall();
        try {
            if (len > 1) {
                Rlog.d("ImsPhone", "not support 1X SEND");
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HANGUP);
            } else if (call.getState() != Call.State.IDLE) {
                Rlog.d("ImsPhone", "MmiCode 1: hangup foreground");
                this.mCT.hangup((ImsPhoneCall)call);
            } else {
                Rlog.d("ImsPhone", "MmiCode 1: switchWaitingOrHoldingAndActive");
                this.mCT.switchWaitingOrHoldingAndActive();
            }
        }
        catch (CallStateException e) {
            Rlog.d("ImsPhone", "hangup failed", e);
            this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HANGUP);
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCallHoldIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        if (len > 1) {
            Rlog.d("ImsPhone", "separate not supported");
            this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SEPARATE);
        } else {
            try {
                if (this.getRingingCall().getState() != Call.State.IDLE) {
                    Rlog.d("ImsPhone", "MmiCode 2: accept ringing call");
                    this.mCT.acceptCall(2);
                } else {
                    Rlog.d("ImsPhone", "MmiCode 2: switchWaitingOrHoldingAndActive");
                    this.mCT.switchWaitingOrHoldingAndActive();
                }
            }
            catch (CallStateException e) {
                Rlog.d("ImsPhone", "switch failed", e);
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SWITCH);
            }
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleMultipartyIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.d("ImsPhone", "MmiCode 3: merge calls");
        this.conference();
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleEctIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len != 1) {
            return false;
        }
        Rlog.d("ImsPhone", "MmiCode 4: not support explicit call transfer");
        this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.TRANSFER);
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCcbsIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.i("ImsPhone", "MmiCode 5: CCBS not supported!");
        this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.UNKNOWN);
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifySuppSvcNotification(SuppServiceNotification suppSvc) {
        Rlog.d("ImsPhone", "notifySuppSvcNotification: suppSvc = " + suppSvc);
        AsyncResult ar = new AsyncResult(null, suppSvc, null);
        this.mSsnRegistrants.notifyRegistrants(ar);
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleInCallMmiCommands(String dialString) {
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(dialString)) {
            return false;
        }
        boolean result = false;
        char ch = dialString.charAt(0);
        switch (ch) {
            case '0': {
                result = this.handleCallDeflectionIncallSupplementaryService(dialString);
                break;
            }
            case '1': {
                result = this.handleCallWaitingIncallSupplementaryService(dialString);
                break;
            }
            case '2': {
                result = this.handleCallHoldIncallSupplementaryService(dialString);
                break;
            }
            case '3': {
                result = this.handleMultipartyIncallSupplementaryService(dialString);
                break;
            }
            case '4': {
                result = this.handleEctIncallSupplementaryService(dialString);
                break;
            }
            case '5': {
                result = this.handleCcbsIncallSupplementaryService(dialString);
                break;
            }
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isInEcm() {
        return this.mDefaultPhone.isInEcm();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setIsInEcm(boolean isInEcm) {
        this.mDefaultPhone.setIsInEcm(isInEcm);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifyNewRingingConnection(Connection c) {
        this.mDefaultPhone.notifyNewRingingConnectionP(c);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifyUnknownConnection(Connection c) {
        this.mDefaultPhone.notifyUnknownConnectionP(c);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifyForVideoCapabilityChanged(boolean isVideoCapable) {
        this.mIsVideoCapable = isVideoCapable;
        this.mDefaultPhone.notifyForVideoCapabilityChanged(isVideoCapable);
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dial(String dialString, int videoState) throws CallStateException {
        return this.dialInternal(dialString, videoState, null, null);
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dial(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        return this.dialInternal(dialString, videoState, intentExtras, null);
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dialInternal(String dialString, int videoState, Bundle intentExtras) throws CallStateException {
        return this.dialInternal(dialString, videoState, intentExtras, null);
    }

    private final Connection $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dialInternal(String dialString, int videoState, Bundle intentExtras, ResultReceiver wrappedCallback) throws CallStateException {
        block7: {
            String newDialString = PhoneNumberUtils.stripSeparators(dialString);
            if (this.handleInCallMmiCommands(newDialString)) {
                return null;
            }
            if (this.mDefaultPhone.getPhoneType() == 2) {
                return this.mCT.dial(dialString, videoState, intentExtras);
            }
            String networkPortion = PhoneNumberUtils.extractNetworkPortionAlt(newDialString);
            ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newFromDialString(networkPortion, this, wrappedCallback);
            Rlog.d("ImsPhone", "dialInternal: dialing w/ mmi '" + mmi + "'...");
            if (mmi == null) {
                return this.mCT.dial(dialString, videoState, intentExtras);
            }
            if (mmi.isTemporaryModeCLIR()) {
                return this.mCT.dial(mmi.getDialingNumber(), mmi.getCLIRMode(), videoState, intentExtras);
            }
            if (!mmi.isSupportedOverImsPhone()) {
                Rlog.i("ImsPhone", "dialInternal: USSD not supported by IMS; fallback to CS.");
                throw new CallStateException("cs_fallback");
            }
            this.mPendingMMIs.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            try {
                mmi.processCode();
            }
            catch (CallStateException cse) {
                if (!"cs_fallback".equals(cse.getMessage())) break block7;
                Rlog.i("ImsPhone", "dialInternal: fallback to GSM required.");
                this.mPendingMMIs.remove(mmi);
                throw cse;
            }
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e("ImsPhone", "sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.getState() == PhoneConstants.State.OFFHOOK) {
            this.mCT.sendDtmf(c, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$startDtmf(char c) {
        if (!(PhoneNumberUtils.is12Key(c) || c >= 'A' && c <= 'D')) {
            Rlog.e("ImsPhone", "startDtmf called with invalid character '" + c + "'");
        } else {
            this.mCT.startDtmf(c);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$stopDtmf() {
        this.mCT.stopDtmf();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifyIncomingRing() {
        Rlog.d("ImsPhone", "notifyIncomingRing");
        AsyncResult ar = new AsyncResult(null, null, null);
        this.sendMessage(this.obtainMessage(14, ar));
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setUiTTYMode(int uiTtyMode, Message onComplete) {
        this.mCT.setUiTTYMode(uiTtyMode, onComplete);
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getMute() {
        return this.mCT.getMute();
    }

    private final PhoneConstants.State $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getState() {
        return this.mCT.getState();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isValidCommandInterfaceCFReason(int commandInterfaceCFReason) {
        switch (commandInterfaceCFReason) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isValidCommandInterfaceCFAction(int commandInterfaceCFAction) {
        switch (commandInterfaceCFAction) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isCfEnable(int action) {
        return action == 1 || action == 3;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getConditionFromCFReason(int reason) {
        switch (reason) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCFReasonFromCondition(int condition) {
        switch (condition) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return 3;
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getActionFromCFAction(int action) {
        switch (action) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return -1;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getOutgoingCallerIdDisplay(Message onComplete) {
        Rlog.d("ImsPhone", "getCLIR");
        Message resp = this.obtainMessage(50, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCLIR(resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setOutgoingCallerIdDisplay(int clirMode, Message onComplete) {
        Rlog.d("ImsPhone", "setCLIR action= " + clirMode);
        Message resp = this.obtainMessage(49, clirMode, 0, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCLIR(clirMode, resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        Rlog.d("ImsPhone", "getCallForwardingOption reason=" + commandInterfaceCFReason);
        if (this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Rlog.d("ImsPhone", "requesting call forwarding query.");
            Message resp = this.obtainMessage(13, onComplete);
            try {
                ImsUtInterface ut = this.mCT.getUtInterface();
                ut.queryCallForward(this.getConditionFromCFReason(commandInterfaceCFReason), null, resp);
            }
            catch (ImsException e) {
                this.sendErrorResponse(onComplete, e);
            }
        } else if (onComplete != null) {
            this.sendErrorResponse(onComplete);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        this.setCallForwardingOption(commandInterfaceCFAction, commandInterfaceCFReason, dialingNumber, 1, timerSeconds, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int serviceClass, int timerSeconds, Message onComplete) {
        Rlog.d("ImsPhone", "setCallForwardingOption action=" + commandInterfaceCFAction + ", reason=" + commandInterfaceCFReason + " serviceClass=" + serviceClass);
        if (this.isValidCommandInterfaceCFAction(commandInterfaceCFAction) && this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Cf cf = new Cf(dialingNumber, commandInterfaceCFReason == 0, onComplete);
            Message resp = this.obtainMessage(12, this.isCfEnable(commandInterfaceCFAction) ? 1 : 0, 0, cf);
            try {
                ImsUtInterface ut = this.mCT.getUtInterface();
                ut.updateCallForward(this.getActionFromCFAction(commandInterfaceCFAction), this.getConditionFromCFReason(commandInterfaceCFReason), dialingNumber, serviceClass, timerSeconds, resp);
            }
            catch (ImsException e) {
                this.sendErrorResponse(onComplete, e);
            }
        } else if (onComplete != null) {
            this.sendErrorResponse(onComplete);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCallWaiting(Message onComplete) {
        Rlog.d("ImsPhone", "getCallWaiting");
        Message resp = this.obtainMessage(48, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCallWaiting(resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCallWaiting(boolean enable, Message onComplete) {
        this.setCallWaiting(enable, 1, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCallWaiting(boolean enable, int serviceClass, Message onComplete) {
        Rlog.d("ImsPhone", "setCallWaiting enable=" + enable);
        Message resp = this.obtainMessage(47, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCallWaiting(enable, serviceClass, resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCBTypeFromFacility(String facility) {
        if ("AO".equals(facility)) {
            return 2;
        }
        if ("OI".equals(facility)) {
            return 3;
        }
        if ("OX".equals(facility)) {
            return 4;
        }
        if ("AI".equals(facility)) {
            return 1;
        }
        if ("IR".equals(facility)) {
            return 5;
        }
        if ("AB".equals(facility)) {
            return 7;
        }
        if ("AG".equals(facility)) {
            return 8;
        }
        if ("AC".equals(facility)) {
            return 9;
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCallBarring(String facility, Message onComplete) {
        Rlog.d("ImsPhone", "getCallBarring facility=" + facility);
        Message resp = this.obtainMessage(46, onComplete);
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.queryCallBarring(this.getCBTypeFromFacility(facility), resp);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCallBarring(String facility, boolean lockState, String password, Message onComplete) {
        Rlog.d("ImsPhone", "setCallBarring facility=" + facility + ", lockState=" + lockState);
        Message resp = this.obtainMessage(45, onComplete);
        int action = lockState ? 1 : 0;
        try {
            ImsUtInterface ut = this.mCT.getUtInterface();
            ut.updateCallBarring(this.getCBTypeFromFacility(facility), action, resp, null);
        }
        catch (ImsException e) {
            this.sendErrorResponse(onComplete, e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendUssdResponse(String ussdMessge) {
        Rlog.d("ImsPhone", "sendUssdResponse");
        ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newFromUssdUserInput(ussdMessge, this);
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.sendUssd(ussdMessge);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendUSSD(String ussdString, Message response) {
        this.mCT.sendUSSD(ussdString, response);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$cancelUSSD() {
        this.mCT.cancelUSSD();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendErrorResponse(Message onComplete) {
        Rlog.d("ImsPhone", "sendErrorResponse");
        if (onComplete != null) {
            AsyncResult.forMessage(onComplete, null, new CommandException(CommandException.Error.GENERIC_FAILURE));
            onComplete.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendErrorResponse(Message onComplete, Throwable e) {
        Rlog.d("ImsPhone", "sendErrorResponse");
        if (onComplete != null) {
            AsyncResult.forMessage(onComplete, null, this.getCommandException(e));
            onComplete.sendToTarget();
        }
    }

    private final CommandException $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCommandException(int code, String errorString) {
        Rlog.d("ImsPhone", "getCommandException code= " + code + ", errorString= " + errorString);
        CommandException.Error error = CommandException.Error.GENERIC_FAILURE;
        switch (code) {
            case 801: {
                error = CommandException.Error.REQUEST_NOT_SUPPORTED;
                break;
            }
            case 821: {
                error = CommandException.Error.PASSWORD_INCORRECT;
                break;
            }
            case 802: {
                error = CommandException.Error.RADIO_NOT_AVAILABLE;
            }
        }
        return new CommandException(error, errorString);
    }

    private final CommandException $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCommandException(Throwable e) {
        CommandException ex = null;
        if (e instanceof ImsException) {
            ex = this.getCommandException(((ImsException)e).getCode(), e.getMessage());
        } else {
            Rlog.d("ImsPhone", "getCommandException generic failure");
            ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
        }
        return ex;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$onNetworkInitiatedUssd(ImsPhoneMmiCode mmi) {
        Rlog.d("ImsPhone", "onNetworkInitiatedUssd");
        this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$onIncomingUSSD(int ussdMode, String ussdMessage) {
        Rlog.d("ImsPhone", "onIncomingUSSD ussdMode=" + ussdMode);
        boolean isUssdRequest = ussdMode == 1;
        boolean isUssdError = ussdMode != 0 && ussdMode != 1;
        ImsPhoneMmiCode found = null;
        int s = this.mPendingMMIs.size();
        for (int i = 0; i < s; ++i) {
            if (!this.mPendingMMIs.get(i).isPendingUSSD()) continue;
            found = this.mPendingMMIs.get(i);
            break;
        }
        if (found != null) {
            if (isUssdError) {
                found.onUssdFinishedError();
            } else {
                found.onUssdFinished(ussdMessage, isUssdRequest);
            }
        } else if (!isUssdError && ussdMessage != null) {
            ImsPhoneMmiCode mmi = ImsPhoneMmiCode.newNetworkInitiatedUssd(ussdMessage, isUssdRequest, this);
            this.onNetworkInitiatedUssd(mmi);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$onMMIDone(ImsPhoneMmiCode mmi) {
        Rlog.d("ImsPhone", "onMMIDone: mmi=" + mmi);
        if (this.mPendingMMIs.remove(mmi) || mmi.isUssdRequest()) {
            ResultReceiver receiverCallback = mmi.getUssdCallbackReceiver();
            if (receiverCallback != null) {
                int returnCode = mmi.getState() == MmiCode.State.COMPLETE ? 100 : -1;
                this.sendUssdResponse(mmi.getDialString(), mmi.getMessage(), returnCode, receiverCallback);
            } else {
                Rlog.v("ImsPhone", "onMMIDone: notifyRegistrants");
                this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            }
        }
    }

    private final ArrayList<Connection> $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getHandoverConnection() {
        ArrayList<Connection> connList = new ArrayList<Connection>();
        connList.addAll(((ImsPhoneCall)this.getForegroundCall()).mConnections);
        connList.addAll(((ImsPhoneCall)this.getBackgroundCall()).mConnections);
        connList.addAll(((ImsPhoneCall)this.getRingingCall()).mConnections);
        if (connList.size() > 0) {
            return connList;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifySrvccState(Call.SrvccState state) {
        this.mCT.notifySrvccState(state);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$initiateSilentRedial() {
        String result = this.mLastDialString;
        AsyncResult ar = new AsyncResult(null, result, null);
        if (ar != null) {
            this.mSilentRedialRegistrants.notifyRegistrants(ar);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$registerForSilentRedial(Handler h, int what, Object obj) {
        this.mSilentRedialRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$unregisterForSilentRedial(Handler h) {
        this.mSilentRedialRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$registerForSuppServiceNotification(Handler h, int what, Object obj) {
        this.mSsnRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$unregisterForSuppServiceNotification(Handler h) {
        this.mSsnRegistrants.remove(h);
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getSubId() {
        return this.mDefaultPhone.getSubId();
    }

    private final int $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getPhoneId() {
        return this.mDefaultPhone.getPhoneId();
    }

    private final CallForwardInfo $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCallForwardInfo(ImsCallForwardInfo info) {
        CallForwardInfo cfInfo = new CallForwardInfo();
        cfInfo.status = info.mStatus;
        cfInfo.reason = this.getCFReasonFromCondition(info.mCondition);
        cfInfo.serviceClass = 1;
        cfInfo.toa = info.mToA;
        cfInfo.number = info.mNumber;
        cfInfo.timeSeconds = info.mTimeSeconds;
        return cfInfo;
    }

    private final CallForwardInfo[] $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCfQueryResult(ImsCallForwardInfo[] infos) {
        CallForwardInfo[] cfInfos = null;
        if (infos != null && infos.length != 0) {
            cfInfos = new CallForwardInfo[infos.length];
        }
        IccRecords r = this.mDefaultPhone.getIccRecords();
        if (infos == null || infos.length == 0) {
            if (r != null) {
                this.setVoiceCallForwardingFlag(r, 1, false, null);
            }
        } else {
            int s = infos.length;
            for (int i = 0; i < s; ++i) {
                if (infos[i].mCondition == 0 && r != null) {
                    this.setVoiceCallForwardingFlag(r, 1, infos[i].mStatus == 1, infos[i].mNumber);
                }
                cfInfos[i] = this.getCallForwardInfo(infos[i]);
            }
        }
        return cfInfos;
    }

    private final int[] $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCbQueryResult(ImsSsInfo[] infos) {
        int[] cbInfos = new int[]{0};
        if (infos[0].mStatus == 1) {
            cbInfos[0] = 1;
        }
        return cbInfos;
    }

    private final int[] $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCwQueryResult(ImsSsInfo[] infos) {
        int[] cwInfos = new int[2];
        cwInfos[0] = 0;
        if (infos[0].mStatus == 1) {
            cwInfos[0] = 1;
            cwInfos[1] = 1;
        }
        return cwInfos;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendResponse(Message onComplete, Object result, Throwable e) {
        if (onComplete != null) {
            CommandException ex = null;
            if (e != null) {
                ex = this.getCommandException(e);
            }
            AsyncResult.forMessage(onComplete, result, ex);
            onComplete.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$updateDataServiceState() {
        if (this.mSS != null && this.mDefaultPhone.getServiceStateTracker() != null && this.mDefaultPhone.getServiceStateTracker().mSS != null) {
            ServiceState ss = this.mDefaultPhone.getServiceStateTracker().mSS;
            this.mSS.setDataRegState(ss.getDataRegState());
            this.mSS.setRilDataRadioTechnology(ss.getRilDataRadioTechnology());
            Rlog.d("ImsPhone", "updateDataServiceState: defSs = " + ss + " imsSs = " + this.mSS);
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleMessage(Message msg) {
        AsyncResult ar = (AsyncResult)msg.obj;
        Rlog.d("ImsPhone", "handleMessage what=" + msg.what);
        switch (msg.what) {
            case 12: {
                IccRecords r = this.mDefaultPhone.getIccRecords();
                Cf cf = (Cf)ar.userObj;
                if (cf.mIsCfu && ar.exception == null && r != null) {
                    this.setVoiceCallForwardingFlag(r, 1, msg.arg1 == 1, cf.mSetCfNumber);
                }
                this.sendResponse(cf.mOnComplete, null, ar.exception);
                break;
            }
            case 13: {
                CallForwardInfo[] cfInfos = null;
                if (ar.exception == null) {
                    cfInfos = this.handleCfQueryResult((ImsCallForwardInfo[])ar.result);
                }
                this.sendResponse((Message)ar.userObj, cfInfos, ar.exception);
                break;
            }
            case 46: 
            case 48: {
                int[] ssInfos = null;
                if (ar.exception == null) {
                    if (msg.what == 46) {
                        ssInfos = this.handleCbQueryResult((ImsSsInfo[])ar.result);
                    } else if (msg.what == 48) {
                        ssInfos = this.handleCwQueryResult((ImsSsInfo[])ar.result);
                    }
                }
                this.sendResponse((Message)ar.userObj, ssInfos, ar.exception);
                break;
            }
            case 50: {
                Bundle ssInfo = (Bundle)ar.result;
                int[] clirInfo = null;
                if (ssInfo != null) {
                    clirInfo = ssInfo.getIntArray("queryClir");
                }
                this.sendResponse((Message)ar.userObj, clirInfo, ar.exception);
                break;
            }
            case 49: {
                if (ar.exception == null) {
                    this.saveClirSetting(msg.arg1);
                }
            }
            case 45: 
            case 47: {
                this.sendResponse((Message)ar.userObj, null, ar.exception);
                break;
            }
            case 51: {
                Rlog.d("ImsPhone", "EVENT_DEFAULT_PHONE_DATA_STATE_CHANGED");
                this.updateDataServiceState();
                break;
            }
            case 52: {
                ar = (AsyncResult)msg.obj;
                ServiceState newServiceState = (ServiceState)ar.result;
                if (this.mRoaming == newServiceState.getRoaming()) break;
                Rlog.d("ImsPhone", "Roaming state changed");
                this.updateRoamingState(newServiceState.getRoaming());
                break;
            }
            case 53: {
                Rlog.d("ImsPhone", "Voice call ended. Handle pending updateRoamingState.");
                this.mCT.unregisterForVoiceCallEnded(this);
                boolean newRoaming = this.getCurrentRoaming();
                if (this.mRoaming == newRoaming) break;
                this.updateRoamingState(newRoaming);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final ImsEcbmStateListener $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getImsEcbmStateListener() {
        return this.mImsEcbmStateListener;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isInEmergencyCall() {
        return this.mCT.isInEmergencyCall();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendEmergencyCallbackModeChange() {
        Intent intent = new Intent("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        intent.putExtra("phoneinECMState", this.isInEcm());
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.getPhoneId());
        ActivityManager.broadcastStickyIntent(intent, -1);
        Rlog.d("ImsPhone", "sendEmergencyCallbackModeChange");
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$exitEmergencyCallbackMode() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        Rlog.d("ImsPhone", "exitEmergencyCallbackMode()");
        try {
            ImsEcbm ecbm = this.mCT.getEcbmInterface();
            ecbm.exitEmergencyCallbackMode();
        }
        catch (ImsException e) {
            e.printStackTrace();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleEnterEmergencyCallbackMode() {
        Rlog.d("ImsPhone", "handleEnterEmergencyCallbackMode,mIsPhoneInEcmState= " + this.isInEcm());
        if (!this.isInEcm()) {
            this.setIsInEcm(true);
            this.sendEmergencyCallbackModeChange();
            long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
            this.postDelayed(this.mExitEcmRunnable, delayInMillis);
            this.mWakeLock.acquire();
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleExitEmergencyCallbackMode() {
        Rlog.d("ImsPhone", "handleExitEmergencyCallbackMode: mIsPhoneInEcmState = " + this.isInEcm());
        if (this.isInEcm()) {
            this.setIsInEcm(false);
        }
        this.removeCallbacks(this.mExitEcmRunnable);
        if (this.mEcmExitRespRegistrant != null) {
            this.mEcmExitRespRegistrant.notifyResult(Boolean.TRUE);
        }
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        this.sendEmergencyCallbackModeChange();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleTimerInEmergencyCallbackMode(int action) {
        switch (action) {
            case 1: {
                this.removeCallbacks(this.mExitEcmRunnable);
                ((GsmCdmaPhone)this.mDefaultPhone).notifyEcbmTimerReset(Boolean.TRUE);
                break;
            }
            case 0: {
                long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
                this.postDelayed(this.mExitEcmRunnable, delayInMillis);
                ((GsmCdmaPhone)this.mDefaultPhone).notifyEcbmTimerReset(Boolean.FALSE);
                break;
            }
            default: {
                Rlog.e("ImsPhone", "handleTimerInEmergencyCallbackMode, unsupported action " + action);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        this.mEcmExitRespRegistrant = new Registrant(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$unsetOnEcbModeExitResponse(Handler h) {
        this.mEcmExitRespRegistrant.clear();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$onFeatureCapabilityChanged() {
        this.mDefaultPhone.getServiceStateTracker().onImsCapabilityChanged();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isVolteEnabled() {
        return this.mCT.isVolteEnabled();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isWifiCallingEnabled() {
        return this.mCT.isVowifiEnabled();
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isVideoEnabled() {
        return this.mCT.isVideoCallEnabled();
    }

    private final Phone $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getDefaultPhone() {
        return this.mDefaultPhone;
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isImsRegistered() {
        return this.mImsRegistered;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setImsRegistered(boolean value) {
        this.mImsRegistered = value;
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$callEndCleanupHandOverCallIfAny() {
        this.mCT.callEndCleanupHandOverCallIfAny();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$processDisconnectReason(ImsReasonInfo imsReasonInfo) {
        if (imsReasonInfo.mCode == 1000 && imsReasonInfo.mExtraMessage != null) {
            CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
            if (configManager == null) {
                Rlog.e("ImsPhone", "processDisconnectReason: CarrierConfigManager is not ready");
                return;
            }
            PersistableBundle pb = configManager.getConfigForSubId(this.getSubId());
            if (pb == null) {
                Rlog.e("ImsPhone", "processDisconnectReason: no config for subId " + this.getSubId());
                return;
            }
            String[] wfcOperatorErrorCodes = pb.getStringArray("wfc_operator_error_codes_string_array");
            if (wfcOperatorErrorCodes == null) {
                return;
            }
            String[] wfcOperatorErrorAlertMessages = this.mContext.getResources().getStringArray(17236064);
            String[] wfcOperatorErrorNotificationMessages = this.mContext.getResources().getStringArray(17236065);
            for (int i = 0; i < wfcOperatorErrorCodes.length; ++i) {
                char nextChar;
                int codeStringLength;
                char lastChar;
                String[] codes = wfcOperatorErrorCodes[i].split("\\|");
                if (codes.length != 2) {
                    Rlog.e("ImsPhone", "Invalid carrier config: " + wfcOperatorErrorCodes[i]);
                    continue;
                }
                if (!imsReasonInfo.mExtraMessage.startsWith(codes[0]) || Character.isLetterOrDigit(lastChar = codes[0].charAt((codeStringLength = codes[0].length()) - 1)) && imsReasonInfo.mExtraMessage.length() > codeStringLength && Character.isLetterOrDigit(nextChar = imsReasonInfo.mExtraMessage.charAt(codeStringLength))) continue;
                CharSequence title = this.mContext.getText(17040956);
                int idx = Integer.parseInt(codes[1]);
                if (idx < 0 || idx >= wfcOperatorErrorAlertMessages.length || idx >= wfcOperatorErrorNotificationMessages.length) {
                    Rlog.e("ImsPhone", "Invalid index: " + wfcOperatorErrorCodes[i]);
                    continue;
                }
                String messageAlert = imsReasonInfo.mExtraMessage;
                String messageNotification = imsReasonInfo.mExtraMessage;
                if (!wfcOperatorErrorAlertMessages[idx].isEmpty()) {
                    messageAlert = wfcOperatorErrorAlertMessages[idx];
                }
                if (!wfcOperatorErrorNotificationMessages[idx].isEmpty()) {
                    messageNotification = wfcOperatorErrorNotificationMessages[idx];
                }
                ImsManager.setWfcSetting(this.mContext, false);
                Intent intent = new Intent("com.android.ims.REGISTRATION_ERROR");
                intent.putExtra("alertTitle", title);
                intent.putExtra("alertMessage", (CharSequence)messageAlert);
                intent.putExtra("notificationMessage", (CharSequence)messageNotification);
                this.mContext.sendOrderedBroadcast(intent, null, this.mResultReceiver, null, -1, null, null);
                break;
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isUtEnabled() {
        return this.mCT.isUtEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendEmergencyCallStateChange(boolean callActive) {
        this.mDefaultPhone.sendEmergencyCallStateChange(callActive);
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setBroadcastEmergencyCallStateChanges(boolean broadcast) {
        this.mDefaultPhone.setBroadcastEmergencyCallStateChanges(broadcast);
    }

    private final PowerManager.WakeLock $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getWakeLock() {
        return this.mWakeLock;
    }

    private final long $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getVtDataUsage() {
        return this.mCT.getVtDataUsage();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$updateRoamingState(boolean newRoaming) {
        if (this.mCT.getState() == PhoneConstants.State.IDLE) {
            Rlog.d("ImsPhone", "updateRoamingState now: " + newRoaming);
            this.mRoaming = newRoaming;
            ImsManager.setWfcMode(this.mContext, ImsManager.getWfcMode(this.mContext, newRoaming), newRoaming);
        } else {
            Rlog.d("ImsPhone", "updateRoamingState postponed: " + newRoaming);
            this.mCT.registerForVoiceCallEnded(this, 53, null);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCurrentRoaming() {
        TelephonyManager tm = (TelephonyManager)this.mContext.getSystemService("phone");
        return tm.isNetworkRoaming();
    }

    private final void $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsPhone extends:");
        super.dump(fd, pw, args);
        pw.flush();
        pw.println("ImsPhone:");
        pw.println("  mDefaultPhone = " + this.mDefaultPhone);
        pw.println("  mPendingMMIs = " + this.mPendingMMIs);
        pw.println("  mPostDialHandler = " + this.mPostDialHandler);
        pw.println("  mSS = " + this.mSS);
        pw.println("  mWakeLock = " + this.mWakeLock);
        pw.println("  mIsPhoneInEcmState = " + this.isInEcm());
        pw.println("  mEcmExitRespRegistrant = " + this.mEcmExitRespRegistrant);
        pw.println("  mSilentRedialRegistrants = " + this.mSilentRedialRegistrants);
        pw.println("  mImsRegistered = " + this.mImsRegistered);
        pw.println("  mRoaming = " + this.mRoaming);
        pw.println("  mSsnRegistrants = " + this.mSsnRegistrants);
        pw.flush();
    }

    protected void setCurrentSubscriberUris(Uri[] uriArray) {
        InvokeDynamicSupport.bootstrap("setCurrentSubscriberUris", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCurrentSubscriberUris(android.net.Uri[] ), this, uriArray);
    }

    @Override
    public Uri[] getCurrentSubscriberUris() {
        return InvokeDynamicSupport.bootstrap("getCurrentSubscriberUris", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCurrentSubscriberUris(), this);
    }

    private void __constructor__(Context context, PhoneNotifier phoneNotifier, Phone phone) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhone$__constructor__(context, phoneNotifier, phone);
    }

    public ImsPhone(Context context, PhoneNotifier phoneNotifier, Phone phone) {
        this(context, phoneNotifier, phone, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$__constructor__(android.content.Context com.android.internal.telephony.PhoneNotifier com.android.internal.telephony.Phone ), this, context, phoneNotifier, phone);
    }

    private void __constructor__(Context context, PhoneNotifier phoneNotifier, Phone phone, boolean bl) {
        this.$$robo$$com_android_internal_telephony_imsphone_ImsPhone$__constructor__(context, phoneNotifier, phone, bl);
    }

    public ImsPhone(Context context, PhoneNotifier phoneNotifier, Phone phone, boolean bl) {
        super("ImsPhone", context, phoneNotifier, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$__constructor__(android.content.Context com.android.internal.telephony.PhoneNotifier com.android.internal.telephony.Phone boolean ), this, context, phoneNotifier, phone, bl);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dispose(), this);
    }

    @Override
    public ServiceState getServiceState() {
        return InvokeDynamicSupport.bootstrap("getServiceState", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getServiceState(), this);
    }

    void setServiceState(int n) {
        InvokeDynamicSupport.bootstrap("setServiceState", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setServiceState(int ), this, n);
    }

    @Override
    public CallTracker getCallTracker() {
        return InvokeDynamicSupport.bootstrap("getCallTracker", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCallTracker(), this);
    }

    public ImsExternalCallTracker getExternalCallTracker() {
        return InvokeDynamicSupport.bootstrap("getExternalCallTracker", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getExternalCallTracker(), this);
    }

    public List<? extends ImsPhoneMmiCode> getPendingMmiCodes() {
        return InvokeDynamicSupport.bootstrap("getPendingMmiCodes", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getPendingMmiCodes(), this);
    }

    @Override
    public void acceptCall(int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$acceptCall(int ), this, n);
    }

    @Override
    public void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$rejectCall(), this);
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchHoldingAndActive", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$switchHoldingAndActive(), this);
    }

    @Override
    public boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$canConference(), this);
    }

    @Override
    public boolean canDial() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDial", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$canDial(), this);
    }

    @Override
    public void conference() {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$conference(), this);
    }

    @Override
    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$clearDisconnected(), this);
    }

    @Override
    public boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$canTransfer(), this);
    }

    @Override
    public void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$explicitCallTransfer(), this);
    }

    @Override
    public ImsPhoneCall getForegroundCall() {
        return InvokeDynamicSupport.bootstrap("getForegroundCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getForegroundCall(), this);
    }

    @Override
    public ImsPhoneCall getBackgroundCall() {
        return InvokeDynamicSupport.bootstrap("getBackgroundCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getBackgroundCall(), this);
    }

    @Override
    public ImsPhoneCall getRingingCall() {
        return InvokeDynamicSupport.bootstrap("getRingingCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getRingingCall(), this);
    }

    private boolean handleCallDeflectionIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCallDeflectionIncallSupplementaryService", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCallDeflectionIncallSupplementaryService(java.lang.String ), this, string2);
    }

    private void sendUssdResponse(String string2, CharSequence charSequence, int n, ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("sendUssdResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendUssdResponse(java.lang.String java.lang.CharSequence int android.os.ResultReceiver ), this, string2, charSequence, n, resultReceiver);
    }

    @Override
    public boolean handleUssdRequest(String string2, ResultReceiver resultReceiver) throws CallStateException {
        return (boolean)InvokeDynamicSupport.bootstrap("handleUssdRequest", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleUssdRequest(java.lang.String android.os.ResultReceiver ), this, string2, resultReceiver);
    }

    private boolean handleCallWaitingIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCallWaitingIncallSupplementaryService", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCallWaitingIncallSupplementaryService(java.lang.String ), this, string2);
    }

    private boolean handleCallHoldIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCallHoldIncallSupplementaryService", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCallHoldIncallSupplementaryService(java.lang.String ), this, string2);
    }

    private boolean handleMultipartyIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMultipartyIncallSupplementaryService", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleMultipartyIncallSupplementaryService(java.lang.String ), this, string2);
    }

    private boolean handleEctIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleEctIncallSupplementaryService", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleEctIncallSupplementaryService(java.lang.String ), this, string2);
    }

    private boolean handleCcbsIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCcbsIncallSupplementaryService", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCcbsIncallSupplementaryService(java.lang.String ), this, string2);
    }

    public void notifySuppSvcNotification(SuppServiceNotification suppServiceNotification) {
        InvokeDynamicSupport.bootstrap("notifySuppSvcNotification", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifySuppSvcNotification(com.android.internal.telephony.gsm.SuppServiceNotification ), this, suppServiceNotification);
    }

    @Override
    public boolean handleInCallMmiCommands(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleInCallMmiCommands", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleInCallMmiCommands(java.lang.String ), this, string2);
    }

    @Override
    boolean isInCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isInCall(), this);
    }

    @Override
    public boolean isInEcm() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEcm", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isInEcm(), this);
    }

    @Override
    public void setIsInEcm(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsInEcm", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setIsInEcm(boolean ), this, bl);
    }

    public void notifyNewRingingConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyNewRingingConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifyNewRingingConnection(com.android.internal.telephony.Connection ), this, connection);
    }

    void notifyUnknownConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyUnknownConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifyUnknownConnection(com.android.internal.telephony.Connection ), this, connection);
    }

    @Override
    public void notifyForVideoCapabilityChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyForVideoCapabilityChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifyForVideoCapabilityChanged(boolean ), this, bl);
    }

    @Override
    public Connection dial(String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dial(java.lang.String int ), this, string2, n);
    }

    @Override
    public Connection dial(String string2, UUSInfo uUSInfo, int n, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dial(java.lang.String com.android.internal.telephony.UUSInfo int android.os.Bundle ), this, string2, uUSInfo, n, bundle);
    }

    protected Connection dialInternal(String string2, int n, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dialInternal(java.lang.String int android.os.Bundle ), this, string2, n, bundle);
    }

    private Connection dialInternal(String string2, int n, Bundle bundle, ResultReceiver resultReceiver) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dialInternal(java.lang.String int android.os.Bundle android.os.ResultReceiver ), this, string2, n, bundle, resultReceiver);
    }

    @Override
    public void sendDtmf(char c) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendDtmf(char ), this, c);
    }

    @Override
    public void startDtmf(char c) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$startDtmf(char ), this, c);
    }

    @Override
    public void stopDtmf() {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$stopDtmf(), this);
    }

    public void notifyIncomingRing() {
        InvokeDynamicSupport.bootstrap("notifyIncomingRing", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifyIncomingRing(), this);
    }

    @Override
    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setMute(boolean ), this, bl);
    }

    @Override
    public void setUiTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setUiTTYMode", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setUiTTYMode(int android.os.Message ), this, n, message);
    }

    @Override
    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getMute(), this);
    }

    @Override
    public PhoneConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getState(), this);
    }

    private boolean isValidCommandInterfaceCFReason(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidCommandInterfaceCFReason", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isValidCommandInterfaceCFReason(int ), this, n);
    }

    private boolean isValidCommandInterfaceCFAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidCommandInterfaceCFAction", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isValidCommandInterfaceCFAction(int ), this, n);
    }

    private boolean isCfEnable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCfEnable", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isCfEnable(int ), this, n);
    }

    private int getConditionFromCFReason(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getConditionFromCFReason", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getConditionFromCFReason(int ), this, n);
    }

    private int getCFReasonFromCondition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCFReasonFromCondition", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCFReasonFromCondition(int ), this, n);
    }

    private int getActionFromCFAction(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getActionFromCFAction", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getActionFromCFAction(int ), this, n);
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        InvokeDynamicSupport.bootstrap("getOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getOutgoingCallerIdDisplay(android.os.Message ), this, message);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setOutgoingCallerIdDisplay(int android.os.Message ), this, n, message);
    }

    @Override
    public void getCallForwardingOption(int n, Message message) {
        InvokeDynamicSupport.bootstrap("getCallForwardingOption", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCallForwardingOption(int android.os.Message ), this, n, message);
    }

    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
        InvokeDynamicSupport.bootstrap("setCallForwardingOption", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCallForwardingOption(int int java.lang.String int android.os.Message ), this, n, n2, string2, n3, message);
    }

    public void setCallForwardingOption(int n, int n2, String string2, int n3, int n4, Message message) {
        InvokeDynamicSupport.bootstrap("setCallForwardingOption", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCallForwardingOption(int int java.lang.String int int android.os.Message ), this, n, n2, string2, n3, n4, message);
    }

    @Override
    public void getCallWaiting(Message message) {
        InvokeDynamicSupport.bootstrap("getCallWaiting", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCallWaiting(android.os.Message ), this, message);
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setCallWaiting", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCallWaiting(boolean android.os.Message ), this, bl, message);
    }

    public void setCallWaiting(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCallWaiting", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCallWaiting(boolean int android.os.Message ), this, bl, n, message);
    }

    private int getCBTypeFromFacility(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getCBTypeFromFacility", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCBTypeFromFacility(java.lang.String ), this, string2);
    }

    public void getCallBarring(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("getCallBarring", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCallBarring(java.lang.String android.os.Message ), this, string2, message);
    }

    public void setCallBarring(String string2, boolean bl, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setCallBarring", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setCallBarring(java.lang.String boolean java.lang.String android.os.Message ), this, string2, bl, string3, message);
    }

    @Override
    public void sendUssdResponse(String string2) {
        InvokeDynamicSupport.bootstrap("sendUssdResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendUssdResponse(java.lang.String ), this, string2);
    }

    public void sendUSSD(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendUSSD(java.lang.String android.os.Message ), this, string2, message);
    }

    @Override
    public void cancelUSSD() {
        InvokeDynamicSupport.bootstrap("cancelUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$cancelUSSD(), this);
    }

    private void sendErrorResponse(Message message) {
        InvokeDynamicSupport.bootstrap("sendErrorResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendErrorResponse(android.os.Message ), this, message);
    }

    public void sendErrorResponse(Message message, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("sendErrorResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendErrorResponse(android.os.Message java.lang.Throwable ), this, message, throwable);
    }

    private CommandException getCommandException(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getCommandException", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCommandException(int java.lang.String ), this, n, string2);
    }

    private CommandException getCommandException(Throwable throwable) {
        return InvokeDynamicSupport.bootstrap("getCommandException", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCommandException(java.lang.Throwable ), this, throwable);
    }

    private void onNetworkInitiatedUssd(ImsPhoneMmiCode imsPhoneMmiCode) {
        InvokeDynamicSupport.bootstrap("onNetworkInitiatedUssd", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$onNetworkInitiatedUssd(com.android.internal.telephony.imsphone.ImsPhoneMmiCode ), this, imsPhoneMmiCode);
    }

    void onIncomingUSSD(int n, String string2) {
        InvokeDynamicSupport.bootstrap("onIncomingUSSD", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$onIncomingUSSD(int java.lang.String ), this, n, string2);
    }

    public void onMMIDone(ImsPhoneMmiCode imsPhoneMmiCode) {
        InvokeDynamicSupport.bootstrap("onMMIDone", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$onMMIDone(com.android.internal.telephony.imsphone.ImsPhoneMmiCode ), this, imsPhoneMmiCode);
    }

    @Override
    public ArrayList<Connection> getHandoverConnection() {
        return InvokeDynamicSupport.bootstrap("getHandoverConnection", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getHandoverConnection(), this);
    }

    @Override
    public void notifySrvccState(Call.SrvccState srvccState) {
        InvokeDynamicSupport.bootstrap("notifySrvccState", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$notifySrvccState(com.android.internal.telephony.Call$SrvccState ), this, srvccState);
    }

    void initiateSilentRedial() {
        InvokeDynamicSupport.bootstrap("initiateSilentRedial", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$initiateSilentRedial(), this);
    }

    @Override
    public void registerForSilentRedial(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSilentRedial", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$registerForSilentRedial(android.os.Handler int java.lang.Object ), this, handler, n, object);
    }

    @Override
    public void unregisterForSilentRedial(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSilentRedial", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$unregisterForSilentRedial(android.os.Handler ), this, handler);
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSuppServiceNotification", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$registerForSuppServiceNotification(android.os.Handler int java.lang.Object ), this, handler, n, object);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSuppServiceNotification", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$unregisterForSuppServiceNotification(android.os.Handler ), this, handler);
    }

    @Override
    public int getSubId() {
        return (int)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getSubId(), this);
    }

    @Override
    public int getPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getPhoneId(), this);
    }

    private CallForwardInfo getCallForwardInfo(ImsCallForwardInfo imsCallForwardInfo) {
        return InvokeDynamicSupport.bootstrap("getCallForwardInfo", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCallForwardInfo(com.android.ims.ImsCallForwardInfo ), this, imsCallForwardInfo);
    }

    private CallForwardInfo[] handleCfQueryResult(ImsCallForwardInfo[] imsCallForwardInfoArray) {
        return InvokeDynamicSupport.bootstrap("handleCfQueryResult", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCfQueryResult(com.android.ims.ImsCallForwardInfo[] ), this, imsCallForwardInfoArray);
    }

    private int[] handleCbQueryResult(ImsSsInfo[] imsSsInfoArray) {
        return InvokeDynamicSupport.bootstrap("handleCbQueryResult", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCbQueryResult(com.android.ims.ImsSsInfo[] ), this, imsSsInfoArray);
    }

    private int[] handleCwQueryResult(ImsSsInfo[] imsSsInfoArray) {
        return InvokeDynamicSupport.bootstrap("handleCwQueryResult", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleCwQueryResult(com.android.ims.ImsSsInfo[] ), this, imsSsInfoArray);
    }

    private void sendResponse(Message message, Object object, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("sendResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendResponse(android.os.Message java.lang.Object java.lang.Throwable ), this, message, object, throwable);
    }

    private void updateDataServiceState() {
        InvokeDynamicSupport.bootstrap("updateDataServiceState", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$updateDataServiceState(), this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleMessage(android.os.Message ), this, message);
    }

    public ImsEcbmStateListener getImsEcbmStateListener() {
        return InvokeDynamicSupport.bootstrap("getImsEcbmStateListener", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getImsEcbmStateListener(), this);
    }

    @Override
    public boolean isInEmergencyCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEmergencyCall", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isInEmergencyCall(), this);
    }

    private void sendEmergencyCallbackModeChange() {
        InvokeDynamicSupport.bootstrap("sendEmergencyCallbackModeChange", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendEmergencyCallbackModeChange(), this);
    }

    @Override
    public void exitEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$exitEmergencyCallbackMode(), this);
    }

    private void handleEnterEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("handleEnterEmergencyCallbackMode", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleEnterEmergencyCallbackMode(), this);
    }

    private void handleExitEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("handleExitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleExitEmergencyCallbackMode(), this);
    }

    void handleTimerInEmergencyCallbackMode(int n) {
        InvokeDynamicSupport.bootstrap("handleTimerInEmergencyCallbackMode", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$handleTimerInEmergencyCallbackMode(int ), this, n);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setOnEcbModeExitResponse(android.os.Handler int java.lang.Object ), this, handler, n, object);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler handler) {
        InvokeDynamicSupport.bootstrap("unsetOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$unsetOnEcbModeExitResponse(android.os.Handler ), this, handler);
    }

    public void onFeatureCapabilityChanged() {
        InvokeDynamicSupport.bootstrap("onFeatureCapabilityChanged", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$onFeatureCapabilityChanged(), this);
    }

    @Override
    public boolean isVolteEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolteEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isVolteEnabled(), this);
    }

    @Override
    public boolean isWifiCallingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWifiCallingEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isWifiCallingEnabled(), this);
    }

    @Override
    public boolean isVideoEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isVideoEnabled(), this);
    }

    @Override
    public Phone getDefaultPhone() {
        return InvokeDynamicSupport.bootstrap("getDefaultPhone", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getDefaultPhone(), this);
    }

    @Override
    public boolean isImsRegistered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImsRegistered", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isImsRegistered(), this);
    }

    public void setImsRegistered(boolean bl) {
        InvokeDynamicSupport.bootstrap("setImsRegistered", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setImsRegistered(boolean ), this, bl);
    }

    @Override
    public void callEndCleanupHandOverCallIfAny() {
        InvokeDynamicSupport.bootstrap("callEndCleanupHandOverCallIfAny", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$callEndCleanupHandOverCallIfAny(), this);
    }

    public void processDisconnectReason(ImsReasonInfo imsReasonInfo) {
        InvokeDynamicSupport.bootstrap("processDisconnectReason", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$processDisconnectReason(com.android.ims.ImsReasonInfo ), this, imsReasonInfo);
    }

    @Override
    public boolean isUtEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUtEnabled", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$isUtEnabled(), this);
    }

    @Override
    public void sendEmergencyCallStateChange(boolean bl) {
        InvokeDynamicSupport.bootstrap("sendEmergencyCallStateChange", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$sendEmergencyCallStateChange(boolean ), this, bl);
    }

    @Override
    public void setBroadcastEmergencyCallStateChanges(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBroadcastEmergencyCallStateChanges", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$setBroadcastEmergencyCallStateChanges(boolean ), this, bl);
    }

    public PowerManager.WakeLock getWakeLock() {
        return InvokeDynamicSupport.bootstrap("getWakeLock", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getWakeLock(), this);
    }

    @Override
    public long getVtDataUsage() {
        return (long)InvokeDynamicSupport.bootstrap("getVtDataUsage", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getVtDataUsage(), this);
    }

    private void updateRoamingState(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateRoamingState", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$updateRoamingState(boolean ), this, bl);
    }

    private boolean getCurrentRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCurrentRoaming", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$getCurrentRoaming(), this);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_imsphone_ImsPhone$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ ImsPhone() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsPhone)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Cf
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String mSetCfNumber;
        Message mOnComplete;
        boolean mIsCfu;

        private void $$robo$$com_android_internal_telephony_imsphone_ImsPhone_Cf$__constructor__(String cfNumber, boolean isCfu, Message onComplete) {
            this.mSetCfNumber = cfNumber;
            this.mIsCfu = isCfu;
            this.mOnComplete = onComplete;
        }

        private void __constructor__(String string2, boolean bl, Message message) {
            this.$$robo$$com_android_internal_telephony_imsphone_ImsPhone_Cf$__constructor__(string2, bl, message);
        }

        public Cf(String string2, boolean bl, Message message) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_imsphone_ImsPhone_Cf$__constructor__(java.lang.String boolean android.os.Message ), this, string2, bl, message);
        }

        public /* synthetic */ Cf() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cf)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

