/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.PendingIntent;
import android.content.Intent;
import android.net.Uri;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.ImsSMSDispatcher;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.cdma.sms.UserData;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CdmaSMSDispatcher
extends SMSDispatcher
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "CdmaSMSDispatcher";
    private static boolean VDBG = false;

    private void $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$__constructor__(Phone phone, SmsUsageMonitor usageMonitor, ImsSMSDispatcher imsSMSDispatcher) {
        Rlog.d("CdmaSMSDispatcher", "CdmaSMSDispatcher created");
    }

    private final String $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$getFormat() {
        return "3gpp2";
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendStatusReportMessage(SmsMessage sms) {
        this.sendMessage(this.obtainMessage(10, sms));
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$handleStatusReport(Object o) {
        if (o instanceof SmsMessage) {
            this.handleCdmaStatusReport((SmsMessage)o);
        } else {
            Rlog.e("CdmaSMSDispatcher", "handleStatusReport() called for object type " + o.getClass().getName());
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$handleCdmaStatusReport(SmsMessage sms) {
        int count = this.deliveryPendingList.size();
        for (int i = 0; i < count; ++i) {
            SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
            if (tracker.mMessageRef != sms.mMessageRef) continue;
            this.deliveryPendingList.remove(i);
            tracker.updateSentMessageStatus(this.mContext, 0);
            PendingIntent intent = tracker.mDeliveryIntent;
            Intent fillIn = new Intent();
            fillIn.putExtra("pdu", sms.getPdu());
            fillIn.putExtra("format", this.getFormat());
            try {
                intent.send(this.mContext, -1, fillIn);
            }
            catch (PendingIntent.CanceledException canceledException) {}
            break;
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, deliveryIntent != null);
        if (pdu != null) {
            HashMap<String, Object> map = this.getSmsTrackerMap(destAddr, scAddr, destPort, data, pdu);
            SMSDispatcher.SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), null, false, null, false, true);
            String carrierPackage = this.getCarrierAppPackageName();
            if (carrierPackage != null) {
                Rlog.d("CdmaSMSDispatcher", "Found carrier package.");
                SMSDispatcher.DataSmsSender smsSender = new SMSDispatcher.DataSmsSender(this, tracker);
                smsSender.sendSmsByCarrierApp(carrierPackage, new SMSDispatcher.SmsSenderCallback(this, smsSender));
            } else {
                Rlog.v("CdmaSMSDispatcher", "No carrier package.");
                this.sendSubmitPdu(tracker);
            }
        } else {
            Rlog.e("CdmaSMSDispatcher", "CdmaSMSDispatcher.sendData(): getSubmitPdu() returned null");
            if (sentIntent != null) {
                try {
                    sentIntent.send(1);
                }
                catch (PendingIntent.CanceledException ex) {
                    Rlog.e("CdmaSMSDispatcher", "Intent has been canceled!");
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, Uri messageUri, String callingPkg, boolean persistMessage) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, deliveryIntent != null, null);
        if (pdu != null) {
            HashMap<String, Object> map = this.getSmsTrackerMap(destAddr, scAddr, text, pdu);
            SMSDispatcher.SmsTracker tracker = this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), messageUri, false, text, true, persistMessage);
            String carrierPackage = this.getCarrierAppPackageName();
            if (carrierPackage != null) {
                Rlog.d("CdmaSMSDispatcher", "Found carrier package.");
                SMSDispatcher.TextSmsSender smsSender = new SMSDispatcher.TextSmsSender(this, tracker);
                smsSender.sendSmsByCarrierApp(carrierPackage, new SMSDispatcher.SmsSenderCallback(this, smsSender));
            } else {
                Rlog.v("CdmaSMSDispatcher", "No carrier package.");
                this.sendSubmitPdu(tracker);
            }
        } else {
            Rlog.e("CdmaSMSDispatcher", "CdmaSMSDispatcher.sendText(): getSubmitPdu() returned null");
            if (sentIntent != null) {
                try {
                    sentIntent.send(1);
                }
                catch (PendingIntent.CanceledException ex) {
                    Rlog.e("CdmaSMSDispatcher", "Intent has been canceled!");
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$injectSmsPdu(byte[] pdu, String format, PendingIntent receivedIntent) {
        throw new IllegalStateException("This method must be called only on ImsSMSDispatcher");
    }

    private final GsmAlphabet.TextEncodingDetails $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        return SmsMessage.calculateLength(messageBody, use7bitOnly, false);
    }

    private final SMSDispatcher.SmsTracker $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$getNewSubmitPduTracker(String destinationAddress, String scAddress, String message, SmsHeader smsHeader, int encoding, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean lastPart, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri, String fullMessageText) {
        UserData uData = new UserData();
        uData.payloadStr = message;
        uData.userDataHeader = smsHeader;
        uData.msgEncoding = encoding == 1 ? 9 : 4;
        uData.msgEncodingSet = true;
        SmsMessage.SubmitPdu submitPdu = SmsMessage.getSubmitPdu(destinationAddress, uData, deliveryIntent != null && lastPart);
        HashMap<String, Object> map = this.getSmsTrackerMap(destinationAddress, scAddress, message, submitPdu);
        return this.getSmsTracker(map, sentIntent, deliveryIntent, this.getFormat(), unsentPartCount, anyPartFailed, messageUri, smsHeader, false, fullMessageText, true, true);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendSubmitPdu(SMSDispatcher.SmsTracker tracker) {
        if (this.mPhone.isInEcm()) {
            tracker.onFailed(this.mContext, 4, 0);
            return;
        }
        this.sendRawPdu(tracker);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendSms(SMSDispatcher.SmsTracker tracker) {
        Rlog.d("CdmaSMSDispatcher", "sendSms:  isIms()=" + this.isIms() + " mRetryCount=" + tracker.mRetryCount + " mImsRetry=" + tracker.mImsRetry + " mMessageRef=" + tracker.mMessageRef + " SS=" + this.mPhone.getServiceState().getState());
        this.sendSmsByPstn(tracker);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendSmsByPstn(SMSDispatcher.SmsTracker tracker) {
        boolean imsSmsDisabled;
        int ss = this.mPhone.getServiceState().getState();
        if (!this.isIms() && ss != 0) {
            tracker.onFailed(this.mContext, CdmaSMSDispatcher.getNotInServiceError(ss), 0);
            return;
        }
        Message reply = this.obtainMessage(2, tracker);
        byte[] pdu = (byte[])tracker.getData().get("pdu");
        int currentDataNetwork = this.mPhone.getServiceState().getDataNetworkType();
        boolean bl = imsSmsDisabled = (currentDataNetwork == 14 || ServiceState.isLte(currentDataNetwork) && !this.mPhone.getServiceStateTracker().isConcurrentVoiceAndDataAllowed()) && this.mPhone.getServiceState().getVoiceNetworkType() == 7 && ((GsmCdmaPhone)this.mPhone).mCT.mState != PhoneConstants.State.IDLE;
        if (0 == tracker.mImsRetry && !this.isIms() || imsSmsDisabled) {
            this.mCi.sendCdmaSms(pdu, reply);
        } else {
            this.mCi.sendImsCdmaSms(pdu, tracker.mImsRetry, tracker.mMessageRef, reply);
            ++tracker.mImsRetry;
        }
    }

    private void __constructor__(Phone phone, SmsUsageMonitor smsUsageMonitor, ImsSMSDispatcher imsSMSDispatcher) {
        this.$$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$__constructor__(phone, smsUsageMonitor, imsSMSDispatcher);
    }

    public CdmaSMSDispatcher(Phone phone, SmsUsageMonitor smsUsageMonitor, ImsSMSDispatcher imsSMSDispatcher) {
        super(phone, smsUsageMonitor, imsSMSDispatcher);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$__constructor__(com.android.internal.telephony.Phone com.android.internal.telephony.SmsUsageMonitor com.android.internal.telephony.ImsSMSDispatcher ), this, phone, smsUsageMonitor, imsSMSDispatcher);
    }

    @Override
    public String getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$getFormat(), this);
    }

    public void sendStatusReportMessage(SmsMessage smsMessage) {
        InvokeDynamicSupport.bootstrap("sendStatusReportMessage", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendStatusReportMessage(com.android.internal.telephony.cdma.SmsMessage ), this, smsMessage);
    }

    @Override
    protected void handleStatusReport(Object object) {
        InvokeDynamicSupport.bootstrap("handleStatusReport", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$handleStatusReport(java.lang.Object ), this, object);
    }

    private void handleCdmaStatusReport(SmsMessage smsMessage) {
        InvokeDynamicSupport.bootstrap("handleCdmaStatusReport", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$handleCdmaStatusReport(com.android.internal.telephony.cdma.SmsMessage ), this, smsMessage);
    }

    @Override
    public void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendData", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendData(java.lang.String java.lang.String int byte[] android.app.PendingIntent android.app.PendingIntent ), this, string2, string3, n, byArray, pendingIntent, pendingIntent2);
    }

    @Override
    public void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2, Uri uri, String string5, boolean bl) {
        InvokeDynamicSupport.bootstrap("sendText", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendText(java.lang.String java.lang.String java.lang.String android.app.PendingIntent android.app.PendingIntent android.net.Uri java.lang.String boolean ), this, string2, string3, string4, pendingIntent, pendingIntent2, uri, string5, bl);
    }

    @Override
    protected void injectSmsPdu(byte[] byArray, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("injectSmsPdu", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$injectSmsPdu(byte[] java.lang.String android.app.PendingIntent ), this, byArray, string2, pendingIntent);
    }

    @Override
    protected GsmAlphabet.TextEncodingDetails calculateLength(CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrap("calculateLength", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$calculateLength(java.lang.CharSequence boolean ), this, charSequence, bl);
    }

    @Override
    protected SMSDispatcher.SmsTracker getNewSubmitPduTracker(String string2, String string3, String string4, SmsHeader smsHeader, int n, PendingIntent pendingIntent, PendingIntent pendingIntent2, boolean bl, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri, String string5) {
        return InvokeDynamicSupport.bootstrap("getNewSubmitPduTracker", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$getNewSubmitPduTracker(java.lang.String java.lang.String java.lang.String com.android.internal.telephony.SmsHeader int android.app.PendingIntent android.app.PendingIntent boolean java.util.concurrent.atomic.AtomicInteger java.util.concurrent.atomic.AtomicBoolean android.net.Uri java.lang.String ), this, string2, string3, string4, smsHeader, n, pendingIntent, pendingIntent2, bl, atomicInteger, atomicBoolean, uri, string5);
    }

    @Override
    protected void sendSubmitPdu(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSubmitPdu", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendSubmitPdu(com.android.internal.telephony.SMSDispatcher$SmsTracker ), this, smsTracker);
    }

    @Override
    public void sendSms(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSms", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendSms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), this, smsTracker);
    }

    @Override
    protected void sendSmsByPstn(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSmsByPstn", $$robo$$com_android_internal_telephony_cdma_CdmaSMSDispatcher$sendSmsByPstn(com.android.internal.telephony.SMSDispatcher$SmsTracker ), this, smsTracker);
    }

    public /* synthetic */ CdmaSMSDispatcher() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CdmaSMSDispatcher)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

