/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Build;
import android.telephony.Rlog;
import com.android.ims.ImsCall;
import com.android.ims.ImsConferenceState;
import com.android.ims.ImsExternalCallState;
import com.android.ims.ImsReasonInfo;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.imsphone.ImsExternalCallTracker;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.test.TestConferenceEventPackageParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TelephonyTester
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "TelephonyTester";
    private static boolean DBG = true;
    private static String ACTION_TEST_CONFERENCE_EVENT_PACKAGE = "com.android.internal.telephony.TestConferenceEventPackage";
    private static String ACTION_TEST_DIALOG_EVENT_PACKAGE = "com.android.internal.telephony.TestDialogEventPackage";
    private static String EXTRA_FILENAME = "filename";
    private static String EXTRA_STARTPACKAGE = "startPackage";
    private static String EXTRA_SENDPACKAGE = "sendPackage";
    private static String EXTRA_DIALOGID = "dialogId";
    private static String EXTRA_NUMBER = "number";
    private static String EXTRA_STATE = "state";
    private static String EXTRA_CANPULL = "canPull";
    private static String ACTION_TEST_HANDOVER_FAIL = "com.android.internal.telephony.TestHandoverFail";
    private static List<ImsExternalCallState> mImsExternalCallStates;
    private Phone mPhone;
    protected BroadcastReceiver mIntentReceiver;

    private void $$robo$$com_android_internal_telephony_TelephonyTester$__constructor__(Phone phone) {
        this.mIntentReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ TelephonyTester this$0;

            private void $$robo$$com_android_internal_telephony_TelephonyTester_1$__constructor__(TelephonyTester this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_TelephonyTester_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                try {
                    TelephonyTester.log("sIntentReceiver.onReceive: action=" + action);
                    if (action.equals(this.this$0.mPhone.getActionDetached())) {
                        TelephonyTester.log("simulate detaching");
                        ((TelephonyTester)this.this$0).mPhone.getServiceStateTracker().mDetachedRegistrants.notifyRegistrants();
                    } else if (action.equals(this.this$0.mPhone.getActionAttached())) {
                        TelephonyTester.log("simulate attaching");
                        ((TelephonyTester)this.this$0).mPhone.getServiceStateTracker().mAttachedRegistrants.notifyRegistrants();
                    } else if (action.equals("com.android.internal.telephony.TestConferenceEventPackage")) {
                        TelephonyTester.log("inject simulated conference event package");
                        this.this$0.handleTestConferenceEventPackage(context, intent.getStringExtra("filename"));
                    } else if (action.equals("com.android.internal.telephony.TestDialogEventPackage")) {
                        TelephonyTester.log("handle test dialog event package intent");
                        this.this$0.handleTestDialogEventPackageIntent(intent);
                    } else if (action.equals("com.android.internal.telephony.TestHandoverFail")) {
                        TelephonyTester.log("handle handover fail test intent");
                        this.this$0.handleHandoverFailedIntent();
                    } else {
                        TelephonyTester.log("onReceive: unknown action=" + action);
                    }
                }
                catch (BadParcelableException e) {
                    Rlog.w("TelephonyTester", e);
                }
            }

            private void __constructor__(TelephonyTester telephonyTester) {
                this.$$robo$$com_android_internal_telephony_TelephonyTester_1$__constructor__(telephonyTester);
            }
            {
                this.this$0 = telephonyTester;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_TelephonyTester_1$__constructor__(com.android.internal.telephony.TelephonyTester ), this, telephonyTester);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_TelephonyTester_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        if (Build.IS_DEBUGGABLE) {
            IntentFilter filter = new IntentFilter();
            filter.addAction(this.mPhone.getActionDetached());
            TelephonyTester.log("register for intent action=" + this.mPhone.getActionDetached());
            filter.addAction(this.mPhone.getActionAttached());
            TelephonyTester.log("register for intent action=" + this.mPhone.getActionAttached());
            if (this.mPhone.getPhoneType() == 5) {
                TelephonyTester.log("register for intent action=com.android.internal.telephony.TestConferenceEventPackage");
                filter.addAction("com.android.internal.telephony.TestConferenceEventPackage");
                filter.addAction("com.android.internal.telephony.TestDialogEventPackage");
                filter.addAction("com.android.internal.telephony.TestHandoverFail");
                mImsExternalCallStates = new ArrayList<ImsExternalCallState>();
            }
            phone.getContext().registerReceiver(this.mIntentReceiver, filter, null, this.mPhone.getHandler());
        }
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$dispose() {
        if (Build.IS_DEBUGGABLE) {
            this.mPhone.getContext().unregisterReceiver(this.mIntentReceiver);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_TelephonyTester$log(String s) {
        Rlog.d("TelephonyTester", s);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$handleHandoverFailedIntent() {
        ImsPhone imsPhone = (ImsPhone)this.mPhone;
        if (imsPhone == null) {
            return;
        }
        Call imsPhoneCall = imsPhone.getForegroundCall();
        if (imsPhoneCall == null) {
            return;
        }
        ImsCall imsCall = ((ImsPhoneCall)imsPhoneCall).getImsCall();
        if (imsCall == null) {
            return;
        }
        imsCall.getImsCallSessionListenerProxy().callSessionHandoverFailed(imsCall.getCallSession(), 14, 18, new ImsReasonInfo());
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$handleTestConferenceEventPackage(Context context, String fileName) {
        FileInputStream is;
        ImsPhone imsPhone = (ImsPhone)this.mPhone;
        if (imsPhone == null) {
            return;
        }
        Call imsPhoneCall = imsPhone.getForegroundCall();
        if (imsPhoneCall == null) {
            return;
        }
        ImsCall imsCall = ((ImsPhoneCall)imsPhoneCall).getImsCall();
        if (imsCall == null) {
            return;
        }
        File packageFile = new File(context.getFilesDir(), fileName);
        try {
            is = new FileInputStream(packageFile);
        }
        catch (FileNotFoundException ex) {
            TelephonyTester.log("Test conference event package file not found: " + packageFile.getAbsolutePath());
            return;
        }
        TestConferenceEventPackageParser parser = new TestConferenceEventPackageParser(is);
        ImsConferenceState imsConferenceState = parser.parse();
        if (imsConferenceState == null) {
            return;
        }
        imsCall.conferenceStateUpdated(imsConferenceState);
    }

    private final void $$robo$$com_android_internal_telephony_TelephonyTester$handleTestDialogEventPackageIntent(Intent intent) {
        ImsPhone imsPhone = (ImsPhone)this.mPhone;
        if (imsPhone == null) {
            return;
        }
        ImsExternalCallTracker externalCallTracker = imsPhone.getExternalCallTracker();
        if (externalCallTracker == null) {
            return;
        }
        if (intent.hasExtra("startPackage")) {
            mImsExternalCallStates.clear();
        } else if (intent.hasExtra("sendPackage")) {
            externalCallTracker.refreshExternalCallState(mImsExternalCallStates);
            mImsExternalCallStates.clear();
        } else if (intent.hasExtra("dialogId")) {
            ImsExternalCallState state = new ImsExternalCallState(intent.getIntExtra("dialogId", 0), Uri.parse(intent.getStringExtra("number")), intent.getBooleanExtra("canPull", true), intent.getIntExtra("state", 1), 2, false);
            mImsExternalCallStates.add(state);
        }
    }

    static void __staticInitializer__() {
        mImsExternalCallStates = null;
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_TelephonyTester$__constructor__(phone);
    }

    public TelephonyTester(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_TelephonyTester$__constructor__(com.android.internal.telephony.Phone ), this, phone);
    }

    void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_TelephonyTester$dispose(), this);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$com_android_internal_telephony_TelephonyTester$log(java.lang.String ), (String)string2);
    }

    private void handleHandoverFailedIntent() {
        InvokeDynamicSupport.bootstrap("handleHandoverFailedIntent", $$robo$$com_android_internal_telephony_TelephonyTester$handleHandoverFailedIntent(), this);
    }

    private void handleTestConferenceEventPackage(Context context, String string2) {
        InvokeDynamicSupport.bootstrap("handleTestConferenceEventPackage", $$robo$$com_android_internal_telephony_TelephonyTester$handleTestConferenceEventPackage(android.content.Context java.lang.String ), this, context, string2);
    }

    private void handleTestDialogEventPackageIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("handleTestDialogEventPackageIntent", $$robo$$com_android_internal_telephony_TelephonyTester$handleTestDialogEventPackageIntent(android.content.Intent ), this, intent);
    }

    static {
        RobolectricInternals.classInitializing(TelephonyTester.class);
    }

    public /* synthetic */ TelephonyTester() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyTester)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

