/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Binder;
import android.os.Process;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import com.android.internal.content.PackageMonitor;
import com.android.internal.logging.MetricsLogger;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SmsApplication
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "SmsApplication";
    private static String PHONE_PACKAGE_NAME = "com.android.phone";
    private static String BLUETOOTH_PACKAGE_NAME = "com.android.bluetooth";
    private static String MMS_SERVICE_PACKAGE_NAME = "com.android.mms.service";
    private static String TELEPHONY_PROVIDER_PACKAGE_NAME = "com.android.providers.telephony";
    private static String SCHEME_SMS = "sms";
    private static String SCHEME_SMSTO = "smsto";
    private static String SCHEME_MMS = "mms";
    private static String SCHEME_MMSTO = "mmsto";
    private static boolean DEBUG_MULTIUSER = false;
    private static SmsPackageMonitor sSmsPackageMonitor;

    private void $$robo$$com_android_internal_telephony_SmsApplication$__constructor__() {
    }

    private static final int $$robo$$com_android_internal_telephony_SmsApplication$getIncomingUserId(Context context) {
        int contextUserId = context.getUserId();
        int callingUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callingUid) < 10000) {
            return contextUserId;
        }
        return UserHandle.getUserId(callingUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Collection<SmsApplicationData> $$robo$$com_android_internal_telephony_SmsApplication$getApplicationCollection(Context context) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            Collection<SmsApplicationData> collection = SmsApplication.getApplicationCollectionInternal(context, userId);
            return collection;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static final Collection<SmsApplicationData> $$robo$$com_android_internal_telephony_SmsApplication$getApplicationCollectionInternal(Context context, int userId) {
        String packageName;
        SmsApplicationData smsApplicationData;
        ActivityInfo activityInfo;
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.provider.Telephony.SMS_DELIVER");
        List<ResolveInfo> smsReceivers = packageManager.queryBroadcastReceiversAsUser(intent, 0, userId);
        HashMap<String, SmsApplicationData> receivers = new HashMap<String, SmsApplicationData>();
        for (ResolveInfo resolveInfo : smsReceivers) {
            String string2;
            ActivityInfo activityInfo2 = resolveInfo.activityInfo;
            if (activityInfo2 == null || !"android.permission.BROADCAST_SMS".equals(activityInfo2.permission) || receivers.containsKey(string2 = activityInfo2.packageName)) continue;
            SmsApplicationData smsApplicationData2 = new SmsApplicationData(string2, activityInfo2.applicationInfo.uid);
            smsApplicationData2.mSmsReceiverClass = activityInfo2.name;
            receivers.put(string2, smsApplicationData2);
        }
        intent = new Intent("android.provider.Telephony.WAP_PUSH_DELIVER");
        intent.setDataAndType(null, "application/vnd.wap.mms-message");
        List<ResolveInfo> mmsReceivers = packageManager.queryBroadcastReceiversAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : mmsReceivers) {
            String string3;
            SmsApplicationData smsApplicationData3;
            ActivityInfo activityInfo3 = resolveInfo.activityInfo;
            if (activityInfo3 == null || !"android.permission.BROADCAST_WAP_PUSH".equals(activityInfo3.permission) || (smsApplicationData3 = (SmsApplicationData)receivers.get(string3 = activityInfo3.packageName)) == null) continue;
            smsApplicationData3.mMmsReceiverClass = activityInfo3.name;
        }
        intent = new Intent("android.intent.action.RESPOND_VIA_MESSAGE", Uri.fromParts("smsto", "", null));
        List<ResolveInfo> list = packageManager.queryIntentServicesAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : list) {
            String string4;
            SmsApplicationData smsApplicationData4;
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null || !"android.permission.SEND_RESPOND_VIA_MESSAGE".equals(serviceInfo.permission) || (smsApplicationData4 = (SmsApplicationData)receivers.get(string4 = serviceInfo.packageName)) == null) continue;
            smsApplicationData4.mRespondViaMessageClass = serviceInfo.name;
        }
        intent = new Intent("android.intent.action.SENDTO", Uri.fromParts("smsto", "", null));
        List<ResolveInfo> list2 = packageManager.queryIntentActivitiesAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : list2) {
            String packageName5;
            SmsApplicationData smsApplicationData5;
            ActivityInfo activityInfo4 = resolveInfo.activityInfo;
            if (activityInfo4 == null || (smsApplicationData5 = (SmsApplicationData)receivers.get(packageName5 = activityInfo4.packageName)) == null) continue;
            smsApplicationData5.mSendToClass = activityInfo4.name;
        }
        intent = new Intent("android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED");
        List<ResolveInfo> list3 = packageManager.queryBroadcastReceiversAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : list3) {
            String packageName6;
            SmsApplicationData smsApplicationData6;
            ActivityInfo activityInfo5 = resolveInfo.activityInfo;
            if (activityInfo5 == null || (smsApplicationData6 = (SmsApplicationData)receivers.get(packageName6 = activityInfo5.packageName)) == null) continue;
            smsApplicationData6.mSmsAppChangedReceiverClass = activityInfo5.name;
        }
        intent = new Intent("android.provider.action.EXTERNAL_PROVIDER_CHANGE");
        List<ResolveInfo> list4 = packageManager.queryBroadcastReceiversAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : list4) {
            String packageName7;
            SmsApplicationData smsApplicationData7;
            ActivityInfo activityInfo6 = resolveInfo.activityInfo;
            if (activityInfo6 == null || (smsApplicationData7 = (SmsApplicationData)receivers.get(packageName7 = activityInfo6.packageName)) == null) continue;
            smsApplicationData7.mProviderChangedReceiverClass = activityInfo6.name;
        }
        intent = new Intent("android.provider.Telephony.SIM_FULL");
        List<ResolveInfo> list5 = packageManager.queryBroadcastReceiversAsUser(intent, 0, userId);
        for (ResolveInfo resolveInfo : list5) {
            activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || (smsApplicationData = (SmsApplicationData)receivers.get(packageName = activityInfo.packageName)) == null) continue;
            smsApplicationData.mSimFullReceiverClass = activityInfo.name;
        }
        for (ResolveInfo resolveInfo : smsReceivers) {
            activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || (smsApplicationData = (SmsApplicationData)receivers.get(packageName = activityInfo.packageName)) == null || smsApplicationData.isComplete()) continue;
            receivers.remove(packageName);
        }
        return receivers.values();
    }

    private static final SmsApplicationData $$robo$$com_android_internal_telephony_SmsApplication$getApplicationForPackage(Collection<SmsApplicationData> applications, String packageName) {
        if (packageName == null) {
            return null;
        }
        for (SmsApplicationData application : applications) {
            if (!application.mPackageName.contentEquals(packageName)) continue;
            return application;
        }
        return null;
    }

    private static final SmsApplicationData $$robo$$com_android_internal_telephony_SmsApplication$getApplication(Context context, boolean updateIfNeeded, int userId) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (!tm.isSmsCapable()) {
            return null;
        }
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollectionInternal(context, userId);
        String defaultApplication = Settings.Secure.getStringForUser(context.getContentResolver(), "sms_default_application", userId);
        SmsApplicationData applicationData = null;
        if (defaultApplication != null) {
            applicationData = SmsApplication.getApplicationForPackage(applications, defaultApplication);
        }
        if (updateIfNeeded && applicationData == null) {
            Resources r = context.getResources();
            String defaultPackage = r.getString(17039748);
            applicationData = SmsApplication.getApplicationForPackage(applications, defaultPackage);
            if (applicationData == null && applications.size() != 0) {
                applicationData = (SmsApplicationData)applications.toArray()[0];
            }
            if (applicationData != null) {
                SmsApplication.setDefaultApplicationInternal(applicationData.mPackageName, context, userId);
            }
        }
        if (applicationData != null) {
            int mode;
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            if ((updateIfNeeded || applicationData.mUid == Process.myUid()) && (mode = appOps.checkOp(15, applicationData.mUid, applicationData.mPackageName)) != 0) {
                Rlog.e("SmsApplication", applicationData.mPackageName + " lost OP_WRITE_SMS: " + (updateIfNeeded ? " (fixing)" : " (no permission to fix)"));
                if (updateIfNeeded) {
                    appOps.setMode(15, applicationData.mUid, applicationData.mPackageName, 0);
                } else {
                    applicationData = null;
                }
            }
            if (updateIfNeeded) {
                PackageManager packageManager = context.getPackageManager();
                SmsApplication.configurePreferredActivity(packageManager, new ComponentName(applicationData.mPackageName, applicationData.mSendToClass), userId);
                SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, "com.android.phone");
                SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, "com.android.bluetooth");
                SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, "com.android.mms.service");
                SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, "com.android.providers.telephony");
                SmsApplication.assignWriteSmsPermissionToSystemUid(appOps, 1001);
            }
        }
        return applicationData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_SmsApplication$setDefaultApplication(String packageName, Context context) {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (!tm.isSmsCapable()) {
            return;
        }
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            SmsApplication.setDefaultApplicationInternal(packageName, context, userId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_SmsApplication$setDefaultApplicationInternal(String packageName, Context context, int userId) {
        String oldPackageName = Settings.Secure.getStringForUser(context.getContentResolver(), "sms_default_application", userId);
        if (packageName != null && oldPackageName != null && packageName.equals(oldPackageName)) {
            return;
        }
        PackageManager packageManager = context.getPackageManager();
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollection(context);
        SmsApplicationData oldAppData = oldPackageName != null ? SmsApplication.getApplicationForPackage(applications, oldPackageName) : null;
        SmsApplicationData applicationData = SmsApplication.getApplicationForPackage(applications, packageName);
        if (applicationData != null) {
            ComponentName component;
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            if (oldPackageName != null) {
                try {
                    PackageInfo info = packageManager.getPackageInfoAsUser(oldPackageName, 0, userId);
                    appOps.setMode(15, info.applicationInfo.uid, oldPackageName, 1);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Rlog.w("SmsApplication", "Old SMS package not found: " + oldPackageName);
                }
            }
            Settings.Secure.putStringForUser(context.getContentResolver(), "sms_default_application", applicationData.mPackageName, userId);
            SmsApplication.configurePreferredActivity(packageManager, new ComponentName(applicationData.mPackageName, applicationData.mSendToClass), userId);
            appOps.setMode(15, applicationData.mUid, applicationData.mPackageName, 0);
            SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, "com.android.phone");
            SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, "com.android.bluetooth");
            SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, "com.android.mms.service");
            SmsApplication.assignWriteSmsPermissionToSystemApp(context, packageManager, appOps, "com.android.providers.telephony");
            SmsApplication.assignWriteSmsPermissionToSystemUid(appOps, 1001);
            if (oldAppData != null && oldAppData.mSmsAppChangedReceiverClass != null) {
                Intent oldAppIntent = new Intent("android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED");
                component = new ComponentName(oldAppData.mPackageName, oldAppData.mSmsAppChangedReceiverClass);
                oldAppIntent.setComponent(component);
                oldAppIntent.putExtra("android.provider.extra.IS_DEFAULT_SMS_APP", false);
                context.sendBroadcast(oldAppIntent);
            }
            if (applicationData.mSmsAppChangedReceiverClass != null) {
                Intent intent = new Intent("android.provider.action.DEFAULT_SMS_PACKAGE_CHANGED");
                component = new ComponentName(applicationData.mPackageName, applicationData.mSmsAppChangedReceiverClass);
                intent.setComponent(component);
                intent.putExtra("android.provider.extra.IS_DEFAULT_SMS_APP", true);
                context.sendBroadcast(intent);
            }
            MetricsLogger.action(context, 266, applicationData.mPackageName);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_SmsApplication$assignWriteSmsPermissionToSystemApp(Context context, PackageManager packageManager, AppOpsManager appOps, String packageName) {
        int result = packageManager.checkSignatures(context.getPackageName(), packageName);
        if (result != 0) {
            Rlog.e("SmsApplication", packageName + " does not have system signature");
            return;
        }
        try {
            PackageInfo info = packageManager.getPackageInfo(packageName, 0);
            int mode = appOps.checkOp(15, info.applicationInfo.uid, packageName);
            if (mode != 0) {
                Rlog.w("SmsApplication", packageName + " does not have OP_WRITE_SMS:  (fixing)");
                appOps.setMode(15, info.applicationInfo.uid, packageName, 0);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Rlog.e("SmsApplication", "Package not found: " + packageName);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_SmsApplication$assignWriteSmsPermissionToSystemUid(AppOpsManager appOps, int uid) {
        appOps.setUidMode(15, uid, 0);
    }

    private static final void $$robo$$com_android_internal_telephony_SmsApplication$initSmsPackageMonitor(Context context) {
        sSmsPackageMonitor = new SmsPackageMonitor(context);
        sSmsPackageMonitor.register(context, context.getMainLooper(), UserHandle.ALL, false);
    }

    private static final void $$robo$$com_android_internal_telephony_SmsApplication$configurePreferredActivity(PackageManager packageManager, ComponentName componentName, int userId) {
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, "sms");
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, "smsto");
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, "mms");
        SmsApplication.replacePreferredActivity(packageManager, componentName, userId, "mmsto");
    }

    private static final void $$robo$$com_android_internal_telephony_SmsApplication$replacePreferredActivity(PackageManager packageManager, ComponentName componentName, int userId, String scheme) {
        Intent intent = new Intent("android.intent.action.SENDTO", Uri.fromParts(scheme, "", null));
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentActivitiesAsUser(intent, 65600, userId);
        int n = resolveInfoList.size();
        ComponentName[] set = new ComponentName[n];
        for (int i = 0; i < n; ++i) {
            ResolveInfo info = resolveInfoList.get(i);
            set[i] = new ComponentName(info.activityInfo.packageName, info.activityInfo.name);
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SENDTO");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        intentFilter.addDataScheme(scheme);
        packageManager.replacePreferredActivityAsUser(intentFilter, 0x208000, set, componentName, userId);
    }

    private static final SmsApplicationData $$robo$$com_android_internal_telephony_SmsApplication$getSmsApplicationData(String packageName, Context context) {
        Collection<SmsApplicationData> applications = SmsApplication.getApplicationCollection(context);
        return SmsApplication.getApplicationForPackage(applications, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ComponentName $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSmsApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSmsReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ComponentName $$robo$$com_android_internal_telephony_SmsApplication$getDefaultMmsApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mMmsReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ComponentName $$robo$$com_android_internal_telephony_SmsApplication$getDefaultRespondViaMessageApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mRespondViaMessageClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ComponentName $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSendToApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSendToClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ComponentName $$robo$$com_android_internal_telephony_SmsApplication$getDefaultExternalTelephonyProviderChangedApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null && smsApplicationData.mProviderChangedReceiverClass != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mProviderChangedReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ComponentName $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSimFullApplication(Context context, boolean updateIfNeeded) {
        int userId = SmsApplication.getIncomingUserId(context);
        long token = Binder.clearCallingIdentity();
        try {
            ComponentName component = null;
            SmsApplicationData smsApplicationData = SmsApplication.getApplication(context, updateIfNeeded, userId);
            if (smsApplicationData != null && smsApplicationData.mSimFullReceiverClass != null) {
                component = new ComponentName(smsApplicationData.mPackageName, smsApplicationData.mSimFullReceiverClass);
            }
            ComponentName componentName = component;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static final boolean $$robo$$com_android_internal_telephony_SmsApplication$shouldWriteMessageForPackage(String packageName, Context context) {
        if (SmsManager.getDefault().getAutoPersisting()) {
            return true;
        }
        return !SmsApplication.isDefaultSmsApplication(context, packageName);
    }

    private static final boolean $$robo$$com_android_internal_telephony_SmsApplication$isDefaultSmsApplication(Context context, String packageName) {
        if (packageName == null) {
            return false;
        }
        String defaultSmsPackage = SmsApplication.getDefaultSmsApplicationPackageName(context);
        return defaultSmsPackage != null && defaultSmsPackage.equals(packageName) || "com.android.bluetooth".equals(packageName);
    }

    private static final String $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSmsApplicationPackageName(Context context) {
        ComponentName component = SmsApplication.getDefaultSmsApplication(context, false);
        if (component != null) {
            return component.getPackageName();
        }
        return null;
    }

    static void __staticInitializer__() {
        sSmsPackageMonitor = null;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_SmsApplication$__constructor__();
    }

    public SmsApplication() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsApplication$__constructor__(), this);
    }

    private static int getIncomingUserId(Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIncomingUserId", $$robo$$com_android_internal_telephony_SmsApplication$getIncomingUserId(android.content.Context ), (Context)context);
    }

    public static Collection<SmsApplicationData> getApplicationCollection(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getApplicationCollection", $$robo$$com_android_internal_telephony_SmsApplication$getApplicationCollection(android.content.Context ), (Context)context);
    }

    private static Collection<SmsApplicationData> getApplicationCollectionInternal(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getApplicationCollectionInternal", $$robo$$com_android_internal_telephony_SmsApplication$getApplicationCollectionInternal(android.content.Context int ), (Context)context, (int)n);
    }

    private static SmsApplicationData getApplicationForPackage(Collection<SmsApplicationData> collection, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getApplicationForPackage", $$robo$$com_android_internal_telephony_SmsApplication$getApplicationForPackage(java.util.Collection<com.android.internal.telephony.SmsApplication$SmsApplicationData> java.lang.String ), collection, (String)string2);
    }

    private static SmsApplicationData getApplication(Context context, boolean bl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getApplication", $$robo$$com_android_internal_telephony_SmsApplication$getApplication(android.content.Context boolean int ), (Context)context, (boolean)bl, (int)n);
    }

    public static void setDefaultApplication(String string2, Context context) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultApplication", $$robo$$com_android_internal_telephony_SmsApplication$setDefaultApplication(java.lang.String android.content.Context ), (String)string2, (Context)context);
    }

    private static void setDefaultApplicationInternal(String string2, Context context, int n) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultApplicationInternal", $$robo$$com_android_internal_telephony_SmsApplication$setDefaultApplicationInternal(java.lang.String android.content.Context int ), (String)string2, (Context)context, (int)n);
    }

    private static void assignWriteSmsPermissionToSystemApp(Context context, PackageManager packageManager, AppOpsManager appOpsManager, String string2) {
        InvokeDynamicSupport.bootstrapStatic("assignWriteSmsPermissionToSystemApp", $$robo$$com_android_internal_telephony_SmsApplication$assignWriteSmsPermissionToSystemApp(android.content.Context android.content.pm.PackageManager android.app.AppOpsManager java.lang.String ), (Context)context, (PackageManager)packageManager, (AppOpsManager)appOpsManager, (String)string2);
    }

    private static void assignWriteSmsPermissionToSystemUid(AppOpsManager appOpsManager, int n) {
        InvokeDynamicSupport.bootstrapStatic("assignWriteSmsPermissionToSystemUid", $$robo$$com_android_internal_telephony_SmsApplication$assignWriteSmsPermissionToSystemUid(android.app.AppOpsManager int ), (AppOpsManager)appOpsManager, (int)n);
    }

    public static void initSmsPackageMonitor(Context context) {
        InvokeDynamicSupport.bootstrapStatic("initSmsPackageMonitor", $$robo$$com_android_internal_telephony_SmsApplication$initSmsPackageMonitor(android.content.Context ), (Context)context);
    }

    private static void configurePreferredActivity(PackageManager packageManager, ComponentName componentName, int n) {
        InvokeDynamicSupport.bootstrapStatic("configurePreferredActivity", $$robo$$com_android_internal_telephony_SmsApplication$configurePreferredActivity(android.content.pm.PackageManager android.content.ComponentName int ), (PackageManager)packageManager, (ComponentName)componentName, (int)n);
    }

    private static void replacePreferredActivity(PackageManager packageManager, ComponentName componentName, int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("replacePreferredActivity", $$robo$$com_android_internal_telephony_SmsApplication$replacePreferredActivity(android.content.pm.PackageManager android.content.ComponentName int java.lang.String ), (PackageManager)packageManager, (ComponentName)componentName, (int)n, (String)string2);
    }

    public static SmsApplicationData getSmsApplicationData(String string2, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getSmsApplicationData", $$robo$$com_android_internal_telephony_SmsApplication$getSmsApplicationData(java.lang.String android.content.Context ), (String)string2, (Context)context);
    }

    public static ComponentName getDefaultSmsApplication(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultSmsApplication", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSmsApplication(android.content.Context boolean ), (Context)context, (boolean)bl);
    }

    public static ComponentName getDefaultMmsApplication(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultMmsApplication", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultMmsApplication(android.content.Context boolean ), (Context)context, (boolean)bl);
    }

    public static ComponentName getDefaultRespondViaMessageApplication(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultRespondViaMessageApplication", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultRespondViaMessageApplication(android.content.Context boolean ), (Context)context, (boolean)bl);
    }

    public static ComponentName getDefaultSendToApplication(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultSendToApplication", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSendToApplication(android.content.Context boolean ), (Context)context, (boolean)bl);
    }

    public static ComponentName getDefaultExternalTelephonyProviderChangedApplication(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultExternalTelephonyProviderChangedApplication", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultExternalTelephonyProviderChangedApplication(android.content.Context boolean ), (Context)context, (boolean)bl);
    }

    public static ComponentName getDefaultSimFullApplication(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultSimFullApplication", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSimFullApplication(android.content.Context boolean ), (Context)context, (boolean)bl);
    }

    public static boolean shouldWriteMessageForPackage(String string2, Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldWriteMessageForPackage", $$robo$$com_android_internal_telephony_SmsApplication$shouldWriteMessageForPackage(java.lang.String android.content.Context ), (String)string2, (Context)context);
    }

    public static boolean isDefaultSmsApplication(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDefaultSmsApplication", $$robo$$com_android_internal_telephony_SmsApplication$isDefaultSmsApplication(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    private static String getDefaultSmsApplicationPackageName(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultSmsApplicationPackageName", $$robo$$com_android_internal_telephony_SmsApplication$getDefaultSmsApplicationPackageName(android.content.Context ), (Context)context);
    }

    static {
        RobolectricInternals.classInitializing(SmsApplication.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsApplication)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SmsPackageMonitor
    extends PackageMonitor
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        Context mContext;

        private void $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$__constructor__(Context context) {
            this.mContext = context;
        }

        private final void $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageDisappeared(String packageName, int reason) {
            this.onPackageChanged();
        }

        private final void $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageAppeared(String packageName, int reason) {
            this.onPackageChanged();
        }

        private final void $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageModified(String packageName) {
            this.onPackageChanged();
        }

        private final void $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageChanged() {
            ComponentName componentName;
            PackageManager packageManager = this.mContext.getPackageManager();
            Context userContext = this.mContext;
            int userId = this.getSendingUserId();
            if (userId != 0) {
                try {
                    userContext = this.mContext.createPackageContextAsUser(this.mContext.getPackageName(), 0, new UserHandle(userId));
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if ((componentName = SmsApplication.getDefaultSendToApplication(userContext, true)) != null) {
                SmsApplication.configurePreferredActivity(packageManager, componentName, userId);
            }
        }

        private void __constructor__(Context context) {
            this.$$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$__constructor__(context);
        }

        public SmsPackageMonitor(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$__constructor__(android.content.Context ), this, context);
        }

        @Override
        public void onPackageDisappeared(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onPackageDisappeared", $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageDisappeared(java.lang.String int ), this, string2, n);
        }

        @Override
        public void onPackageAppeared(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onPackageAppeared", $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageAppeared(java.lang.String int ), this, string2, n);
        }

        @Override
        public void onPackageModified(String string2) {
            InvokeDynamicSupport.bootstrap("onPackageModified", $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageModified(java.lang.String ), this, string2);
        }

        private void onPackageChanged() {
            InvokeDynamicSupport.bootstrap("onPackageChanged", $$robo$$com_android_internal_telephony_SmsApplication_SmsPackageMonitor$onPackageChanged(), this);
        }

        public /* synthetic */ SmsPackageMonitor() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsPackageMonitor)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SmsApplicationData
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mApplicationName;
        public String mPackageName;
        private String mSmsReceiverClass;
        private String mMmsReceiverClass;
        private String mRespondViaMessageClass;
        private String mSendToClass;
        private String mSmsAppChangedReceiverClass;
        private String mProviderChangedReceiverClass;
        private String mSimFullReceiverClass;
        private int mUid;

        private final boolean $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$isComplete() {
            return this.mSmsReceiverClass != null && this.mMmsReceiverClass != null && this.mRespondViaMessageClass != null && this.mSendToClass != null;
        }

        private void $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$__constructor__(String packageName, int uid) {
            this.mPackageName = packageName;
            this.mUid = uid;
        }

        private final String $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$getApplicationName(Context context) {
            if (this.mApplicationName == null) {
                ApplicationInfo appInfo;
                PackageManager pm = context.getPackageManager();
                try {
                    appInfo = pm.getApplicationInfoAsUser(this.mPackageName, 0, UserHandle.getUserId(this.mUid));
                }
                catch (PackageManager.NameNotFoundException e) {
                    return null;
                }
                if (appInfo != null) {
                    CharSequence label = pm.getApplicationLabel(appInfo);
                    this.mApplicationName = label == null ? null : label.toString();
                }
            }
            return this.mApplicationName;
        }

        private final String $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$toString() {
            return " mPackageName: " + this.mPackageName + " mSmsReceiverClass: " + this.mSmsReceiverClass + " mMmsReceiverClass: " + this.mMmsReceiverClass + " mRespondViaMessageClass: " + this.mRespondViaMessageClass + " mSendToClass: " + this.mSendToClass + " mSmsAppChangedClass: " + this.mSmsAppChangedReceiverClass + " mProviderChangedReceiverClass: " + this.mProviderChangedReceiverClass + " mSimFullReceiverClass: " + this.mSimFullReceiverClass + " mUid: " + this.mUid;
        }

        public boolean isComplete() {
            return (boolean)InvokeDynamicSupport.bootstrap("isComplete", $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$isComplete(), this);
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$__constructor__(string2, n);
        }

        public SmsApplicationData(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$__constructor__(java.lang.String int ), this, string2, n);
        }

        public String getApplicationName(Context context) {
            return InvokeDynamicSupport.bootstrap("getApplicationName", $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$getApplicationName(android.content.Context ), this, context);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_SmsApplication_SmsApplicationData$toString(), this);
        }

        public /* synthetic */ SmsApplicationData() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsApplicationData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

