/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.telephony.Phone;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SimActivationTracker
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DBG = true;
    private static String LOG_TAG = "SAT";
    private static boolean VDBG;
    private Phone mPhone;
    private int mVoiceActivationState;
    private int mDataActivationState;
    private LocalLog mVoiceActivationStateLog;
    private LocalLog mDataActivationStateLog;
    private BroadcastReceiver mReceiver;

    private void $$robo$$com_android_internal_telephony_SimActivationTracker$__constructor__(Phone phone) {
        this.mVoiceActivationStateLog = new LocalLog(10);
        this.mDataActivationStateLog = new LocalLog(10);
        this.mPhone = phone;
        this.mVoiceActivationState = 0;
        this.mDataActivationState = 0;
        this.mReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ SimActivationTracker this$0;

            private void $$robo$$com_android_internal_telephony_SimActivationTracker_1$__constructor__(SimActivationTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_SimActivationTracker_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (VDBG) {
                    this.this$0.log("action: " + action);
                }
                if ("android.intent.action.SIM_STATE_CHANGED".equals(action) && "ABSENT".equals(intent.getStringExtra("ss"))) {
                    this.this$0.log("onSimAbsent, reset activation state to UNKNOWN");
                    this.this$0.setVoiceActivationState(0);
                    this.this$0.setDataActivationState(0);
                }
            }

            private void __constructor__(SimActivationTracker simActivationTracker) {
                this.$$robo$$com_android_internal_telephony_SimActivationTracker_1$__constructor__(simActivationTracker);
            }
            {
                this.this$0 = simActivationTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SimActivationTracker_1$__constructor__(com.android.internal.telephony.SimActivationTracker ), this, simActivationTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_SimActivationTracker_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SIM_STATE_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mReceiver, intentFilter);
    }

    private final void $$robo$$com_android_internal_telephony_SimActivationTracker$setVoiceActivationState(int state) {
        if (!SimActivationTracker.isValidActivationState(state) || 4 == state) {
            throw new IllegalArgumentException("invalid voice activation state: " + state);
        }
        this.log("setVoiceActivationState=" + state);
        this.mVoiceActivationState = state;
        this.mVoiceActivationStateLog.log(SimActivationTracker.toString(state));
        this.mPhone.notifyVoiceActivationStateChanged(state);
    }

    private final void $$robo$$com_android_internal_telephony_SimActivationTracker$setDataActivationState(int state) {
        if (!SimActivationTracker.isValidActivationState(state)) {
            throw new IllegalArgumentException("invalid data activation state: " + state);
        }
        this.log("setDataActivationState=" + state);
        this.mDataActivationState = state;
        this.mDataActivationStateLog.log(SimActivationTracker.toString(state));
        this.mPhone.notifyDataActivationStateChanged(state);
    }

    private final int $$robo$$com_android_internal_telephony_SimActivationTracker$getVoiceActivationState() {
        return this.mVoiceActivationState;
    }

    private final int $$robo$$com_android_internal_telephony_SimActivationTracker$getDataActivationState() {
        return this.mDataActivationState;
    }

    private static final boolean $$robo$$com_android_internal_telephony_SimActivationTracker$isValidActivationState(int state) {
        switch (state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private static final String $$robo$$com_android_internal_telephony_SimActivationTracker$toString(int state) {
        switch (state) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "activating";
            }
            case 2: {
                return "activated";
            }
            case 3: {
                return "deactivated";
            }
            case 4: {
                return "restricted";
            }
        }
        return "invalid";
    }

    private final void $$robo$$com_android_internal_telephony_SimActivationTracker$log(String s) {
        Rlog.d("SAT", "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_SimActivationTracker$loge(String s) {
        Rlog.e("SAT", "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_SimActivationTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        pw.println(" mVoiceActivationState Log:");
        ipw.increaseIndent();
        this.mVoiceActivationStateLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        pw.println(" mDataActivationState Log:");
        ipw.increaseIndent();
        this.mDataActivationStateLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
    }

    private final void $$robo$$com_android_internal_telephony_SimActivationTracker$dispose() {
        this.mPhone.getContext().unregisterReceiver(this.mReceiver);
    }

    static void __staticInitializer__() {
        VDBG = Rlog.isLoggable("SAT", 2);
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_SimActivationTracker$__constructor__(phone);
    }

    public SimActivationTracker(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_SimActivationTracker$__constructor__(com.android.internal.telephony.Phone ), this, phone);
    }

    public void setVoiceActivationState(int n) {
        InvokeDynamicSupport.bootstrap("setVoiceActivationState", $$robo$$com_android_internal_telephony_SimActivationTracker$setVoiceActivationState(int ), this, n);
    }

    public void setDataActivationState(int n) {
        InvokeDynamicSupport.bootstrap("setDataActivationState", $$robo$$com_android_internal_telephony_SimActivationTracker$setDataActivationState(int ), this, n);
    }

    public int getVoiceActivationState() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceActivationState", $$robo$$com_android_internal_telephony_SimActivationTracker$getVoiceActivationState(), this);
    }

    public int getDataActivationState() {
        return (int)InvokeDynamicSupport.bootstrap("getDataActivationState", $$robo$$com_android_internal_telephony_SimActivationTracker$getDataActivationState(), this);
    }

    private static boolean isValidActivationState(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidActivationState", $$robo$$com_android_internal_telephony_SimActivationTracker$isValidActivationState(int ), (int)n);
    }

    private static String toString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$com_android_internal_telephony_SimActivationTracker$toString(int ), (int)n);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_SimActivationTracker$log(java.lang.String ), this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_SimActivationTracker$loge(java.lang.String ), this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_SimActivationTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_SimActivationTracker$dispose(), this);
    }

    static {
        RobolectricInternals.classInitializing(SimActivationTracker.class);
    }

    public /* synthetic */ SimActivationTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimActivationTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

