/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Build;
import android.os.PersistableBundle;
import android.os.SystemProperties;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.Pair;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.dataconnection.ApnSetting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RetryManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String LOG_TAG = "RetryManager";
    public static boolean DBG = true;
    public static boolean VDBG = false;
    private static String DEFAULT_DATA_RETRY_CONFIG = "max_retries=3, 5000, 5000, 5000";
    private static String OTHERS_APN_TYPE = "others";
    private static long DEFAULT_INTER_APN_DELAY = 20000L;
    private static long DEFAULT_INTER_APN_DELAY_FOR_PROVISIONING = 3000L;
    public static long NO_RETRY = -1L;
    public static long NO_SUGGESTED_RETRY_DELAY = -2L;
    private static int MAX_SAME_APN_RETRY = 3;
    private long mInterApnDelay;
    private long mFailFastInterApnDelay;
    private long mModemSuggestedDelay;
    private int mSameApnRetryCount;
    private ArrayList<RetryRec> mRetryArray;
    private Phone mPhone;
    private boolean mRetryForever;
    private int mMaxRetryCount;
    private int mRetryCount;
    private Random mRng;
    private String mConfig;
    private ArrayList<ApnSetting> mWaitingApns;
    private int mCurrentApnIndex;
    private String mApnType;

    private void $$robo$$com_android_internal_telephony_RetryManager$__constructor__(Phone phone, String apnType) {
        this.mModemSuggestedDelay = -2L;
        this.mSameApnRetryCount = 0;
        this.mRetryArray = new ArrayList();
        this.mRetryForever = false;
        this.mRetryCount = 0;
        this.mRng = new Random();
        this.mWaitingApns = null;
        this.mCurrentApnIndex = -1;
        this.mPhone = phone;
        this.mApnType = apnType;
    }

    private final boolean $$robo$$com_android_internal_telephony_RetryManager$configure(String configStr) {
        if (configStr.startsWith("\"") && configStr.endsWith("\"")) {
            configStr = configStr.substring(1, configStr.length() - 1);
        }
        this.reset();
        this.log("configure: '" + configStr + "'");
        this.mConfig = configStr;
        if (!TextUtils.isEmpty(configStr)) {
            int defaultRandomization = 0;
            String[] strArray = configStr.split(",");
            for (int i = 0; i < strArray.length; ++i) {
                Pair<Boolean, Integer> value;
                String[] splitStr = strArray[i].split("=", 2);
                splitStr[0] = splitStr[0].trim();
                if (splitStr.length > 1) {
                    splitStr[1] = splitStr[1].trim();
                    if (TextUtils.equals(splitStr[0], "default_randomization")) {
                        value = this.parseNonNegativeInt(splitStr[0], splitStr[1]);
                        if (!((Boolean)value.first).booleanValue()) {
                            return false;
                        }
                        defaultRandomization = (Integer)value.second;
                        continue;
                    }
                    if (TextUtils.equals(splitStr[0], "max_retries")) {
                        if (TextUtils.equals("infinite", splitStr[1])) {
                            this.mRetryForever = true;
                            continue;
                        }
                        value = this.parseNonNegativeInt(splitStr[0], splitStr[1]);
                        if (!((Boolean)value.first).booleanValue()) {
                            return false;
                        }
                        this.mMaxRetryCount = (Integer)value.second;
                        continue;
                    }
                    Rlog.e("RetryManager", "Unrecognized configuration name value pair: " + strArray[i]);
                    return false;
                }
                splitStr = strArray[i].split(":", 2);
                splitStr[0] = splitStr[0].trim();
                RetryRec rr = new RetryRec(0, 0);
                value = this.parseNonNegativeInt("delayTime", splitStr[0]);
                if (!((Boolean)value.first).booleanValue()) {
                    return false;
                }
                rr.mDelayTime = (Integer)value.second;
                if (splitStr.length > 1) {
                    splitStr[1] = splitStr[1].trim();
                    value = this.parseNonNegativeInt("randomizationTime", splitStr[1]);
                    if (!((Boolean)value.first).booleanValue()) {
                        return false;
                    }
                    rr.mRandomizationTime = (Integer)value.second;
                } else {
                    rr.mRandomizationTime = defaultRandomization;
                }
                this.mRetryArray.add(rr);
            }
            if (this.mRetryArray.size() > this.mMaxRetryCount) {
                this.mMaxRetryCount = this.mRetryArray.size();
            }
        } else {
            this.log("configure: cleared");
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$configureRetry() {
        String configString = null;
        String otherConfigString = null;
        try {
            String config;
            if (Build.IS_DEBUGGABLE && !TextUtils.isEmpty(config = SystemProperties.get("test.data_retry_config"))) {
                this.configure(config);
                return;
            }
            CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            PersistableBundle b = configManager.getConfigForSubId(this.mPhone.getSubId());
            this.mInterApnDelay = b.getLong("carrier_data_call_apn_delay_default_long", 20000L);
            this.mFailFastInterApnDelay = b.getLong("carrier_data_call_apn_delay_faster_long", 3000L);
            String[] allConfigStrings = b.getStringArray("carrier_data_call_retry_config_strings");
            if (allConfigStrings != null) {
                for (String s : allConfigStrings) {
                    String[] splitStr;
                    if (TextUtils.isEmpty(s) || (splitStr = s.split(":", 2)).length != 2) continue;
                    String apnType = splitStr[0].trim();
                    if (apnType.equals(this.mApnType)) {
                        configString = splitStr[1];
                        break;
                    }
                    if (!apnType.equals("others")) continue;
                    otherConfigString = splitStr[1];
                }
            }
            if (configString == null) {
                if (otherConfigString != null) {
                    configString = otherConfigString;
                } else {
                    this.log("Invalid APN retry configuration!. Use the default one now.");
                    configString = "max_retries=3, 5000, 5000, 5000";
                }
            }
        }
        catch (NullPointerException ex) {
            this.log("Failed to read configuration! Use the hardcoded default value.");
            this.mInterApnDelay = 20000L;
            this.mFailFastInterApnDelay = 3000L;
            configString = "max_retries=3, 5000, 5000, 5000";
        }
        this.configure(configString);
    }

    private final int $$robo$$com_android_internal_telephony_RetryManager$getRetryTimer() {
        int index = this.mRetryCount < this.mRetryArray.size() ? this.mRetryCount : this.mRetryArray.size() - 1;
        int retVal = index >= 0 && index < this.mRetryArray.size() ? this.mRetryArray.get((int)index).mDelayTime + this.nextRandomizationTime(index) : 0;
        this.log("getRetryTimer: " + retVal);
        return retVal;
    }

    private final Pair<Boolean, Integer> $$robo$$com_android_internal_telephony_RetryManager$parseNonNegativeInt(String name, String stringValue) {
        Pair<Boolean, Integer> retVal;
        try {
            int value = Integer.parseInt(stringValue);
            retVal = new Pair<Boolean, Integer>(this.validateNonNegativeInt(name, value), value);
        }
        catch (NumberFormatException e) {
            Rlog.e("RetryManager", name + " bad value: " + stringValue, e);
            retVal = new Pair<Boolean, Integer>(false, 0);
        }
        return retVal;
    }

    private final boolean $$robo$$com_android_internal_telephony_RetryManager$validateNonNegativeInt(String name, int value) {
        boolean retVal;
        if (value < 0) {
            Rlog.e("RetryManager", name + " bad value: is < 0");
            retVal = false;
        } else {
            retVal = true;
        }
        return retVal;
    }

    private final int $$robo$$com_android_internal_telephony_RetryManager$nextRandomizationTime(int index) {
        int randomTime = this.mRetryArray.get((int)index).mRandomizationTime;
        if (randomTime == 0) {
            return 0;
        }
        return this.mRng.nextInt(randomTime);
    }

    private final ApnSetting $$robo$$com_android_internal_telephony_RetryManager$getNextApnSetting() {
        int index;
        block4: {
            if (this.mWaitingApns == null || this.mWaitingApns.size() == 0) {
                this.log("Waiting APN list is null or empty.");
                return null;
            }
            if (this.mModemSuggestedDelay != -2L && this.mSameApnRetryCount < 3) {
                ++this.mSameApnRetryCount;
                return this.mWaitingApns.get(this.mCurrentApnIndex);
            }
            this.mSameApnRetryCount = 0;
            index = this.mCurrentApnIndex;
            do {
                if (++index == this.mWaitingApns.size()) {
                    index = 0;
                }
                if (!this.mWaitingApns.get((int)index).permanentFailed) break block4;
            } while (index != this.mCurrentApnIndex);
            return null;
        }
        this.mCurrentApnIndex = index;
        return this.mWaitingApns.get(this.mCurrentApnIndex);
    }

    private final long $$robo$$com_android_internal_telephony_RetryManager$getDelayForNextApn(boolean failFastEnabled) {
        long delay;
        int index;
        block9: {
            if (this.mWaitingApns == null || this.mWaitingApns.size() == 0) {
                this.log("Waiting APN list is null or empty.");
                return -1L;
            }
            if (this.mModemSuggestedDelay == -1L) {
                this.log("Modem suggested not retrying.");
                return -1L;
            }
            if (this.mModemSuggestedDelay != -2L && this.mSameApnRetryCount < 3) {
                this.log("Modem suggested retry in " + this.mModemSuggestedDelay + " ms.");
                return this.mModemSuggestedDelay;
            }
            index = this.mCurrentApnIndex;
            do {
                if (++index >= this.mWaitingApns.size()) {
                    index = 0;
                }
                if (!this.mWaitingApns.get((int)index).permanentFailed) break block9;
            } while (index != this.mCurrentApnIndex);
            this.log("All APNs have permanently failed.");
            return -1L;
        }
        if (index <= this.mCurrentApnIndex) {
            if (!this.mRetryForever && this.mRetryCount + 1 > this.mMaxRetryCount) {
                this.log("Reached maximum retry count " + this.mMaxRetryCount + ".");
                return -1L;
            }
            delay = this.getRetryTimer();
            ++this.mRetryCount;
        } else {
            delay = this.mInterApnDelay;
        }
        if (failFastEnabled && delay > this.mFailFastInterApnDelay) {
            delay = this.mFailFastInterApnDelay;
        }
        return delay;
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$markApnPermanentFailed(ApnSetting apn) {
        if (apn != null) {
            apn.permanentFailed = true;
        }
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$reset() {
        this.mMaxRetryCount = 0;
        this.mRetryCount = 0;
        this.mCurrentApnIndex = -1;
        this.mSameApnRetryCount = 0;
        this.mModemSuggestedDelay = -2L;
        this.mRetryArray.clear();
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$setWaitingApns(ArrayList<ApnSetting> waitingApns) {
        if (waitingApns == null) {
            this.log("No waiting APNs provided");
            return;
        }
        this.mWaitingApns = waitingApns;
        this.configureRetry();
        for (ApnSetting apn : this.mWaitingApns) {
            apn.permanentFailed = false;
        }
        this.log("Setting " + this.mWaitingApns.size() + " waiting APNs.");
    }

    private final ArrayList<ApnSetting> $$robo$$com_android_internal_telephony_RetryManager$getWaitingApns() {
        return this.mWaitingApns;
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$setModemSuggestedDelay(long delay) {
        this.mModemSuggestedDelay = delay;
    }

    private final long $$robo$$com_android_internal_telephony_RetryManager$getInterApnDelay(boolean failFastEnabled) {
        return failFastEnabled ? this.mFailFastInterApnDelay : this.mInterApnDelay;
    }

    private final String $$robo$$com_android_internal_telephony_RetryManager$toString() {
        return "mApnType=" + this.mApnType + " mRetryCount=" + this.mRetryCount + " mMaxRetryCount=" + this.mMaxRetryCount + " mCurrentApnIndex=" + this.mCurrentApnIndex + " mSameApnRtryCount=" + this.mSameApnRetryCount + " mModemSuggestedDelay=" + this.mModemSuggestedDelay + " mRetryForever=" + this.mRetryForever + " mConfig={" + this.mConfig + "}";
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("  RetryManager");
        pw.println("***************************************");
        pw.println("    config = " + this.mConfig);
        pw.println("    mApnType = " + this.mApnType);
        pw.println("    mCurrentApnIndex = " + this.mCurrentApnIndex);
        pw.println("    mRetryCount = " + this.mRetryCount);
        pw.println("    mMaxRetryCount = " + this.mMaxRetryCount);
        pw.println("    mSameApnRetryCount = " + this.mSameApnRetryCount);
        pw.println("    mModemSuggestedDelay = " + this.mModemSuggestedDelay);
        if (this.mWaitingApns != null) {
            pw.println("    APN list: ");
            for (int i = 0; i < this.mWaitingApns.size(); ++i) {
                pw.println("      [" + i + "]=" + this.mWaitingApns.get(i));
            }
        }
        pw.println("***************************************");
        pw.flush();
    }

    private final void $$robo$$com_android_internal_telephony_RetryManager$log(String s) {
        Rlog.d("RetryManager", "[" + this.mApnType + "] " + s);
    }

    private void __constructor__(Phone phone, String string2) {
        this.$$robo$$com_android_internal_telephony_RetryManager$__constructor__(phone, string2);
    }

    public RetryManager(Phone phone, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RetryManager$__constructor__(com.android.internal.telephony.Phone java.lang.String ), this, phone, string2);
    }

    private boolean configure(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("configure", $$robo$$com_android_internal_telephony_RetryManager$configure(java.lang.String ), this, string2);
    }

    private void configureRetry() {
        InvokeDynamicSupport.bootstrap("configureRetry", $$robo$$com_android_internal_telephony_RetryManager$configureRetry(), this);
    }

    private int getRetryTimer() {
        return (int)InvokeDynamicSupport.bootstrap("getRetryTimer", $$robo$$com_android_internal_telephony_RetryManager$getRetryTimer(), this);
    }

    private Pair<Boolean, Integer> parseNonNegativeInt(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("parseNonNegativeInt", $$robo$$com_android_internal_telephony_RetryManager$parseNonNegativeInt(java.lang.String java.lang.String ), this, string2, string3);
    }

    private boolean validateNonNegativeInt(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("validateNonNegativeInt", $$robo$$com_android_internal_telephony_RetryManager$validateNonNegativeInt(java.lang.String int ), this, string2, n);
    }

    private int nextRandomizationTime(int n) {
        return (int)InvokeDynamicSupport.bootstrap("nextRandomizationTime", $$robo$$com_android_internal_telephony_RetryManager$nextRandomizationTime(int ), this, n);
    }

    public ApnSetting getNextApnSetting() {
        return InvokeDynamicSupport.bootstrap("getNextApnSetting", $$robo$$com_android_internal_telephony_RetryManager$getNextApnSetting(), this);
    }

    public long getDelayForNextApn(boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getDelayForNextApn", $$robo$$com_android_internal_telephony_RetryManager$getDelayForNextApn(boolean ), this, bl);
    }

    public void markApnPermanentFailed(ApnSetting apnSetting) {
        InvokeDynamicSupport.bootstrap("markApnPermanentFailed", $$robo$$com_android_internal_telephony_RetryManager$markApnPermanentFailed(com.android.internal.telephony.dataconnection.ApnSetting ), this, apnSetting);
    }

    private void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_telephony_RetryManager$reset(), this);
    }

    public void setWaitingApns(ArrayList<ApnSetting> arrayList) {
        InvokeDynamicSupport.bootstrap("setWaitingApns", $$robo$$com_android_internal_telephony_RetryManager$setWaitingApns(java.util.ArrayList<com.android.internal.telephony.dataconnection.ApnSetting> ), this, arrayList);
    }

    public ArrayList<ApnSetting> getWaitingApns() {
        return InvokeDynamicSupport.bootstrap("getWaitingApns", $$robo$$com_android_internal_telephony_RetryManager$getWaitingApns(), this);
    }

    public void setModemSuggestedDelay(long l) {
        InvokeDynamicSupport.bootstrap("setModemSuggestedDelay", $$robo$$com_android_internal_telephony_RetryManager$setModemSuggestedDelay(long ), this, l);
    }

    public long getInterApnDelay(boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getInterApnDelay", $$robo$$com_android_internal_telephony_RetryManager$getInterApnDelay(boolean ), this, bl);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_RetryManager$toString(), this);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_RetryManager$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_RetryManager$log(java.lang.String ), this, string2);
    }

    public /* synthetic */ RetryManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RetryManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class RetryRec
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mDelayTime;
        int mRandomizationTime;

        private void $$robo$$com_android_internal_telephony_RetryManager_RetryRec$__constructor__(int delayTime, int randomizationTime) {
            this.mDelayTime = delayTime;
            this.mRandomizationTime = randomizationTime;
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_telephony_RetryManager_RetryRec$__constructor__(n, n2);
        }

        public RetryRec(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RetryManager_RetryRec$__constructor__(int int ), this, n, n2);
        }

        public /* synthetic */ RetryRec() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RetryRec)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

