/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.SystemClock;
import android.telephony.ClientRequestStats;
import android.telephony.Rlog;
import com.android.internal.telephony.ClientWakelockAccountant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ClientWakelockTracker
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String LOG_TAG = "ClientWakelockTracker";
    public HashMap<String, ClientWakelockAccountant> mClients;
    public ArrayList<ClientWakelockAccountant> mActiveClients;

    private void $$robo$$com_android_internal_telephony_ClientWakelockTracker$__constructor__() {
        this.mClients = new HashMap();
        this.mActiveClients = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ClientWakelockTracker$startTracking(String clientId, int requestId, int token, int numRequestsInQueue) {
        ClientWakelockAccountant client = this.getClientWakelockAccountant(clientId);
        long uptime = SystemClock.uptimeMillis();
        client.startAttributingWakelock(requestId, token, numRequestsInQueue, uptime);
        this.updateConcurrentRequests(numRequestsInQueue, uptime);
        ArrayList<ClientWakelockAccountant> arrayList = this.mActiveClients;
        synchronized (arrayList) {
            if (!this.mActiveClients.contains(client)) {
                this.mActiveClients.add(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ClientWakelockTracker$stopTracking(String clientId, int requestId, int token, int numRequestsInQueue) {
        ClientWakelockAccountant client = this.getClientWakelockAccountant(clientId);
        long uptime = SystemClock.uptimeMillis();
        client.stopAttributingWakelock(requestId, token, uptime);
        if (client.getPendingRequestCount() == 0) {
            ArrayList<ClientWakelockAccountant> arrayList = this.mActiveClients;
            synchronized (arrayList) {
                this.mActiveClients.remove(client);
            }
        }
        this.updateConcurrentRequests(numRequestsInQueue, uptime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ClientWakelockTracker$stopTrackingAll() {
        long uptime = SystemClock.uptimeMillis();
        ArrayList<ClientWakelockAccountant> arrayList = this.mActiveClients;
        synchronized (arrayList) {
            for (ClientWakelockAccountant client : this.mActiveClients) {
                client.stopAllPendingRequests(uptime);
            }
            this.mActiveClients.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<ClientRequestStats> $$robo$$com_android_internal_telephony_ClientWakelockTracker$getClientRequestStats() {
        ArrayList<ClientRequestStats> list;
        long uptime = SystemClock.uptimeMillis();
        HashMap<String, ClientWakelockAccountant> hashMap = this.mClients;
        synchronized (hashMap) {
            list = new ArrayList<ClientRequestStats>(this.mClients.size());
            for (String key : this.mClients.keySet()) {
                ClientWakelockAccountant client = this.mClients.get(key);
                client.updatePendingRequestWakelockTime(uptime);
                list.add(new ClientRequestStats(client.mRequestStats));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ClientWakelockAccountant $$robo$$com_android_internal_telephony_ClientWakelockTracker$getClientWakelockAccountant(String clientId) {
        ClientWakelockAccountant client;
        HashMap<String, ClientWakelockAccountant> hashMap = this.mClients;
        synchronized (hashMap) {
            if (this.mClients.containsKey(clientId)) {
                client = this.mClients.get(clientId);
            } else {
                client = new ClientWakelockAccountant(clientId);
                this.mClients.put(clientId, client);
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ClientWakelockTracker$updateConcurrentRequests(int numRequestsInQueue, long time) {
        if (numRequestsInQueue != 0) {
            ArrayList<ClientWakelockAccountant> arrayList = this.mActiveClients;
            synchronized (arrayList) {
                for (ClientWakelockAccountant cI : this.mActiveClients) {
                    cI.changeConcurrentRequests(numRequestsInQueue, time);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_ClientWakelockTracker$isClientActive(String clientId) {
        ClientWakelockAccountant client = this.getClientWakelockAccountant(clientId);
        ArrayList<ClientWakelockAccountant> arrayList = this.mActiveClients;
        synchronized (arrayList) {
            if (this.mActiveClients.contains(client)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ClientWakelockTracker$dumpClientRequestTracker() {
        Rlog.d("RILJ", "-------mClients---------------");
        HashMap<String, ClientWakelockAccountant> hashMap = this.mClients;
        synchronized (hashMap) {
            for (String key : this.mClients.keySet()) {
                Rlog.d("RILJ", "Client : " + key);
                Rlog.d("RILJ", this.mClients.get(key).toString());
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_ClientWakelockTracker$__constructor__();
    }

    public ClientWakelockTracker() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ClientWakelockTracker$__constructor__(), this);
    }

    public void startTracking(String string2, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("startTracking", $$robo$$com_android_internal_telephony_ClientWakelockTracker$startTracking(java.lang.String int int int ), this, string2, n, n2, n3);
    }

    public void stopTracking(String string2, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("stopTracking", $$robo$$com_android_internal_telephony_ClientWakelockTracker$stopTracking(java.lang.String int int int ), this, string2, n, n2, n3);
    }

    public void stopTrackingAll() {
        InvokeDynamicSupport.bootstrap("stopTrackingAll", $$robo$$com_android_internal_telephony_ClientWakelockTracker$stopTrackingAll(), this);
    }

    List<ClientRequestStats> getClientRequestStats() {
        return InvokeDynamicSupport.bootstrap("getClientRequestStats", $$robo$$com_android_internal_telephony_ClientWakelockTracker$getClientRequestStats(), this);
    }

    private ClientWakelockAccountant getClientWakelockAccountant(String string2) {
        return InvokeDynamicSupport.bootstrap("getClientWakelockAccountant", $$robo$$com_android_internal_telephony_ClientWakelockTracker$getClientWakelockAccountant(java.lang.String ), this, string2);
    }

    private void updateConcurrentRequests(int n, long l) {
        InvokeDynamicSupport.bootstrap("updateConcurrentRequests", $$robo$$com_android_internal_telephony_ClientWakelockTracker$updateConcurrentRequests(int long ), this, n, l);
    }

    public boolean isClientActive(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isClientActive", $$robo$$com_android_internal_telephony_ClientWakelockTracker$isClientActive(java.lang.String ), this, string2);
    }

    void dumpClientRequestTracker() {
        InvokeDynamicSupport.bootstrap("dumpClientRequestTracker", $$robo$$com_android_internal_telephony_ClientWakelockTracker$dumpClientRequestTracker(), this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClientWakelockTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

