/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ServiceStateTracker;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CarrierServiceStateTracker
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "CSST";
    protected static int CARRIER_EVENT_BASE = 100;
    protected static int CARRIER_EVENT_VOICE_REGISTRATION = 101;
    protected static int CARRIER_EVENT_VOICE_DEREGISTRATION = 102;
    protected static int CARRIER_EVENT_DATA_REGISTRATION = 103;
    protected static int CARRIER_EVENT_DATA_DEREGISTRATION = 104;
    private static int SHOW_NOTIFICATION = 200;
    private static int NOTIFICATION_ID = 1000;
    private static int UNINITIALIZED_DELAY_VALUE = -1;
    private int mDelay;
    private Phone mPhone;
    private boolean mIsPhoneRegistered;
    private ServiceStateTracker mSST;
    private BroadcastReceiver mBroadcastReceiver;

    private void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$__constructor__(Phone phone, ServiceStateTracker sst) {
        this.mDelay = -1;
        this.mIsPhoneRegistered = false;
        this.mBroadcastReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CarrierServiceStateTracker this$0;

            private void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_1$__constructor__(CarrierServiceStateTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_1$onReceive(Context context, Intent intent) {
                CarrierConfigManager carrierConfigManager = (CarrierConfigManager)context.getSystemService("carrier_config");
                PersistableBundle b = carrierConfigManager.getConfig();
                this.this$0.mDelay = b.getInt("network_notification_delay_int");
                Rlog.i("CSST", "reading time to delay notification: " + this.this$0.mDelay);
                this.this$0.handleConfigChanges();
            }

            private void __constructor__(CarrierServiceStateTracker carrierServiceStateTracker) {
                this.$$robo$$com_android_internal_telephony_CarrierServiceStateTracker_1$__constructor__(carrierServiceStateTracker);
            }
            {
                this.this$0 = carrierServiceStateTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_1$__constructor__(com.android.internal.telephony.CarrierServiceStateTracker ), this, carrierServiceStateTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mSST = sst;
        phone.getContext().registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$handleMessage(Message msg) {
        switch (msg.what) {
            case 101: 
            case 103: {
                this.mIsPhoneRegistered = true;
                this.handleConfigChanges();
                break;
            }
            case 102: 
            case 104: {
                if (this.isGlobalModeOrRadioOffOrAirplaneMode()) break;
                this.mIsPhoneRegistered = false;
                this.handleConfigChanges();
                break;
            }
            case 200: {
                this.sendNotification();
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isGlobalModeOrRadioOffOrAirplaneMode() {
        Context context = this.mPhone.getContext();
        int preferredNetworkSetting = -1;
        int airplaneMode = -1;
        int subId = this.mPhone.getSubId();
        try {
            preferredNetworkSetting = Settings.Global.getInt(context.getContentResolver(), "preferred_network_mode" + subId, Phone.PREFERRED_NT_MODE);
            airplaneMode = Settings.Global.getInt(context.getContentResolver(), "airplane_mode_on", 0);
        }
        catch (Exception e) {
            Rlog.e("CSST", "Unable to get PREFERRED_NETWORK_MODE.");
            return true;
        }
        return preferredNetworkSetting == 10 || !this.mSST.isRadioOn() || airplaneMode != 0;
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$handleConfigChanges() {
        if (this.mDelay == -1) {
            this.cancelNotification();
            return;
        }
        if (this.mIsPhoneRegistered) {
            this.cancelNotification();
            Rlog.i("CSST", "canceling all notifications. ");
        } else {
            Message notificationMsg = this.obtainMessage(200, null);
            Rlog.i("CSST", "starting timer for notifications. ");
            this.sendMessageDelayed(notificationMsg, this.mDelay);
        }
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$sendNotification() {
        Context context = this.mPhone.getContext();
        Rlog.i("CSST", "w/values: ," + this.mIsPhoneRegistered + "," + this.mDelay + "," + this.isGlobalModeOrRadioOffOrAirplaneMode() + "," + this.mSST.isRadioOn());
        if (this.isGlobalModeOrRadioOffOrAirplaneMode() || this.mIsPhoneRegistered) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Intent notificationIntent = new Intent("android.settings.DATA_ROAMING_SETTINGS");
        PendingIntent settingsIntent = PendingIntent.getActivity(context, 0, notificationIntent, 0x40000000);
        CharSequence title = context.getText(17039404);
        CharSequence details = context.getText(17039403);
        Notification mNotification = new Notification.Builder(context).setWhen((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System")).setAutoCancel(true).setSmallIcon(17301642).setContentTitle(title).setColor(context.getResources().getColor(17170761)).setStyle(new Notification.BigTextStyle().bigText(details)).setContentText(details).setContentIntent(settingsIntent).setChannel("alert").build();
        notificationManager.notify(1000, mNotification);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$cancelNotification() {
        Context context = this.mPhone.getContext();
        this.mIsPhoneRegistered = true;
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(1000);
    }

    private void __constructor__(Phone phone, ServiceStateTracker serviceStateTracker) {
        this.$$robo$$com_android_internal_telephony_CarrierServiceStateTracker$__constructor__(phone, serviceStateTracker);
    }

    public CarrierServiceStateTracker(Phone phone, ServiceStateTracker serviceStateTracker) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$__constructor__(com.android.internal.telephony.Phone com.android.internal.telephony.ServiceStateTracker ), this, phone, serviceStateTracker);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$handleMessage(android.os.Message ), this, message);
    }

    private boolean isGlobalModeOrRadioOffOrAirplaneMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGlobalModeOrRadioOffOrAirplaneMode", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$isGlobalModeOrRadioOffOrAirplaneMode(), this);
    }

    private void handleConfigChanges() {
        InvokeDynamicSupport.bootstrap("handleConfigChanges", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$handleConfigChanges(), this);
    }

    private void sendNotification() {
        InvokeDynamicSupport.bootstrap("sendNotification", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$sendNotification(), this);
    }

    private void cancelNotification() {
        InvokeDynamicSupport.bootstrap("cancelNotification", $$robo$$com_android_internal_telephony_CarrierServiceStateTracker$cancelNotification(), this);
    }

    public /* synthetic */ CarrierServiceStateTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierServiceStateTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

