/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.provider.Settings;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.telephony.Phone;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CarrierActionAgent
extends Handler
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "CarrierActionAgent";
    private static boolean DBG = true;
    private static boolean VDBG;
    public static int CARRIER_ACTION_SET_METERED_APNS_ENABLED = 0;
    public static int CARRIER_ACTION_SET_RADIO_ENABLED = 1;
    public static int CARRIER_ACTION_RESET = 2;
    private Phone mPhone;
    private RegistrantList mMeteredApnEnableRegistrants;
    private RegistrantList mRadioEnableRegistrants;
    private LocalLog mMeteredApnEnabledLog;
    private LocalLog mRadioEnabledLog;
    private Boolean mCarrierActionOnMeteredApnEnabled;
    private Boolean mCarrierActionOnRadioEnabled;
    private SettingsObserver mSettingsObserver;
    private BroadcastReceiver mReceiver;

    private void $$robo$$com_android_internal_telephony_CarrierActionAgent$__constructor__(Phone phone) {
        this.mMeteredApnEnableRegistrants = new RegistrantList();
        this.mRadioEnableRegistrants = new RegistrantList();
        this.mMeteredApnEnabledLog = new LocalLog(10);
        this.mRadioEnabledLog = new LocalLog(10);
        this.mCarrierActionOnMeteredApnEnabled = true;
        this.mCarrierActionOnRadioEnabled = true;
        this.mReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CarrierActionAgent this$0;

            private void $$robo$$com_android_internal_telephony_CarrierActionAgent_1$__constructor__(CarrierActionAgent this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_CarrierActionAgent_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                String iccState = intent.getStringExtra("ss");
                if ("android.intent.action.SIM_STATE_CHANGED".equals(action)) {
                    if (intent.getBooleanExtra("rebroadcastOnUnlock", false)) {
                        return;
                    }
                    if ("LOADED".equals(iccState) || "ABSENT".equals(iccState)) {
                        this.this$0.sendEmptyMessage(2);
                    }
                }
            }

            private void __constructor__(CarrierActionAgent carrierActionAgent) {
                this.$$robo$$com_android_internal_telephony_CarrierActionAgent_1$__constructor__(carrierActionAgent);
            }
            {
                this.this$0 = carrierActionAgent;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierActionAgent_1$__constructor__(com.android.internal.telephony.CarrierActionAgent ), this, carrierActionAgent);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_CarrierActionAgent_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mPhone.getContext().registerReceiver(this.mReceiver, new IntentFilter("android.intent.action.SIM_STATE_CHANGED"));
        this.mSettingsObserver = new SettingsObserver(this);
        this.mPhone.getContext().getContentResolver().registerContentObserver(Settings.Global.getUriFor("airplane_mode_on"), false, this.mSettingsObserver);
        this.log("Creating CarrierActionAgent");
    }

    private final void $$robo$$com_android_internal_telephony_CarrierActionAgent$handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.mCarrierActionOnMeteredApnEnabled = (boolean)((Boolean)msg.obj);
                this.log("SET_METERED_APNS_ENABLED: " + this.mCarrierActionOnMeteredApnEnabled);
                this.mMeteredApnEnabledLog.log("SET_METERED_APNS_ENABLED: " + this.mCarrierActionOnMeteredApnEnabled);
                this.mMeteredApnEnableRegistrants.notifyRegistrants(new AsyncResult(null, this.mCarrierActionOnMeteredApnEnabled, null));
                break;
            }
            case 1: {
                this.mCarrierActionOnRadioEnabled = (boolean)((Boolean)msg.obj);
                this.log("SET_RADIO_ENABLED: " + this.mCarrierActionOnRadioEnabled);
                this.mRadioEnabledLog.log("SET_RADIO_ENABLED: " + this.mCarrierActionOnRadioEnabled);
                this.mRadioEnableRegistrants.notifyRegistrants(new AsyncResult(null, this.mCarrierActionOnRadioEnabled, null));
                break;
            }
            case 2: {
                this.log("CARRIER_ACTION_RESET");
                this.carrierActionSetMeteredApnsEnabled(true);
                this.carrierActionSetRadioEnabled(true);
                this.mPhone.getCarrierSignalAgent().notifyCarrierSignalReceivers(new Intent("com.android.internal.telephony.CARRIER_SIGNAL_RESET"));
                break;
            }
            default: {
                this.loge("Unknown carrier action: " + msg.what);
            }
        }
    }

    private final Object $$robo$$com_android_internal_telephony_CarrierActionAgent$getCarrierActionValue(int action) {
        Object val = this.getCarrierAction(action);
        if (val == null) {
            throw new IllegalArgumentException("invalid carrier action: " + action);
        }
        return val;
    }

    private final void $$robo$$com_android_internal_telephony_CarrierActionAgent$carrierActionSetRadioEnabled(boolean enabled) {
        this.sendMessage(this.obtainMessage(1, enabled));
    }

    private final void $$robo$$com_android_internal_telephony_CarrierActionAgent$carrierActionSetMeteredApnsEnabled(boolean enabled) {
        this.sendMessage(this.obtainMessage(0, enabled));
    }

    private final RegistrantList $$robo$$com_android_internal_telephony_CarrierActionAgent$getRegistrantsFromAction(int action) {
        switch (action) {
            case 0: {
                return this.mMeteredApnEnableRegistrants;
            }
            case 1: {
                return this.mRadioEnableRegistrants;
            }
        }
        this.loge("Unsupported action: " + action);
        return null;
    }

    private final Object $$robo$$com_android_internal_telephony_CarrierActionAgent$getCarrierAction(int action) {
        switch (action) {
            case 0: {
                return this.mCarrierActionOnMeteredApnEnabled;
            }
            case 1: {
                return this.mCarrierActionOnRadioEnabled;
            }
        }
        this.loge("Unsupported action: " + action);
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_CarrierActionAgent$registerForCarrierAction(int action, Handler h, int what, Object obj, boolean notifyNow) {
        Object carrierAction = this.getCarrierAction(action);
        if (carrierAction == null) {
            throw new IllegalArgumentException("invalid carrier action: " + action);
        }
        RegistrantList list = this.getRegistrantsFromAction(action);
        Registrant r = new Registrant(h, what, obj);
        list.add(r);
        if (notifyNow) {
            r.notifyRegistrant(new AsyncResult(null, carrierAction, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_CarrierActionAgent$unregisterForCarrierAction(Handler h, int action) {
        RegistrantList list = this.getRegistrantsFromAction(action);
        if (list == null) {
            throw new IllegalArgumentException("invalid carrier action: " + action);
        }
        list.remove(h);
    }

    private final ContentObserver $$robo$$com_android_internal_telephony_CarrierActionAgent$getContentObserver() {
        return this.mSettingsObserver;
    }

    private final void $$robo$$com_android_internal_telephony_CarrierActionAgent$log(String s) {
        Rlog.d("CarrierActionAgent", "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierActionAgent$loge(String s) {
        Rlog.e("CarrierActionAgent", "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierActionAgent$logv(String s) {
        Rlog.v("CarrierActionAgent", "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private final void $$robo$$com_android_internal_telephony_CarrierActionAgent$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        pw.println(" mCarrierActionOnMeteredApnsEnabled Log:");
        ipw.increaseIndent();
        this.mMeteredApnEnabledLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        pw.println(" mCarrierActionOnRadioEnabled Log:");
        ipw.increaseIndent();
        this.mRadioEnabledLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
    }

    static void __staticInitializer__() {
        VDBG = Rlog.isLoggable("CarrierActionAgent", 2);
    }

    private void __constructor__(Phone phone) {
        this.$$robo$$com_android_internal_telephony_CarrierActionAgent$__constructor__(phone);
    }

    public CarrierActionAgent(Phone phone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierActionAgent$__constructor__(com.android.internal.telephony.Phone ), this, phone);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_CarrierActionAgent$handleMessage(android.os.Message ), this, message);
    }

    public Object getCarrierActionValue(int n) {
        return InvokeDynamicSupport.bootstrap("getCarrierActionValue", $$robo$$com_android_internal_telephony_CarrierActionAgent$getCarrierActionValue(int ), this, n);
    }

    public void carrierActionSetRadioEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("carrierActionSetRadioEnabled", $$robo$$com_android_internal_telephony_CarrierActionAgent$carrierActionSetRadioEnabled(boolean ), this, bl);
    }

    public void carrierActionSetMeteredApnsEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("carrierActionSetMeteredApnsEnabled", $$robo$$com_android_internal_telephony_CarrierActionAgent$carrierActionSetMeteredApnsEnabled(boolean ), this, bl);
    }

    private RegistrantList getRegistrantsFromAction(int n) {
        return InvokeDynamicSupport.bootstrap("getRegistrantsFromAction", $$robo$$com_android_internal_telephony_CarrierActionAgent$getRegistrantsFromAction(int ), this, n);
    }

    private Object getCarrierAction(int n) {
        return InvokeDynamicSupport.bootstrap("getCarrierAction", $$robo$$com_android_internal_telephony_CarrierActionAgent$getCarrierAction(int ), this, n);
    }

    public void registerForCarrierAction(int n, Handler handler, int n2, Object object, boolean bl) {
        InvokeDynamicSupport.bootstrap("registerForCarrierAction", $$robo$$com_android_internal_telephony_CarrierActionAgent$registerForCarrierAction(int android.os.Handler int java.lang.Object boolean ), this, n, handler, n2, object, bl);
    }

    public void unregisterForCarrierAction(Handler handler, int n) {
        InvokeDynamicSupport.bootstrap("unregisterForCarrierAction", $$robo$$com_android_internal_telephony_CarrierActionAgent$unregisterForCarrierAction(android.os.Handler int ), this, handler, n);
    }

    public ContentObserver getContentObserver() {
        return InvokeDynamicSupport.bootstrap("getContentObserver", $$robo$$com_android_internal_telephony_CarrierActionAgent$getContentObserver(), this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_CarrierActionAgent$log(java.lang.String ), this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_CarrierActionAgent$loge(java.lang.String ), this, string2);
    }

    private void logv(String string2) {
        InvokeDynamicSupport.bootstrap("logv", $$robo$$com_android_internal_telephony_CarrierActionAgent$logv(java.lang.String ), this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_CarrierActionAgent$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(CarrierActionAgent.class);
    }

    public /* synthetic */ CarrierActionAgent() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierActionAgent)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SettingsObserver
    extends ContentObserver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ CarrierActionAgent this$0;

        private void $$robo$$com_android_internal_telephony_CarrierActionAgent_SettingsObserver$__constructor__(CarrierActionAgent carrierActionAgent) {
        }

        private final void $$robo$$com_android_internal_telephony_CarrierActionAgent_SettingsObserver$onChange(boolean selfChange) {
            if (Settings.Global.getInt(this.this$0.mPhone.getContext().getContentResolver(), "airplane_mode_on", 0) != 0) {
                this.this$0.sendEmptyMessage(2);
            }
        }

        private void __constructor__(CarrierActionAgent carrierActionAgent) {
            this.$$robo$$com_android_internal_telephony_CarrierActionAgent_SettingsObserver$__constructor__(carrierActionAgent);
        }

        public SettingsObserver(CarrierActionAgent carrierActionAgent) {
            this.this$0 = carrierActionAgent;
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierActionAgent_SettingsObserver$__constructor__(com.android.internal.telephony.CarrierActionAgent ), this, carrierActionAgent);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_telephony_CarrierActionAgent_SettingsObserver$onChange(boolean ), this, bl);
        }

        public /* synthetic */ SettingsObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SettingsObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

