/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.location.Country;
import android.location.CountryDetector;
import android.net.Uri;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.geocoding.PhoneNumberOfflineGeocoder;
import com.android.internal.telephony.CallerInfoAsyncQuery;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CallerInfo
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "CallerInfo";
    private static boolean VDBG;
    public static long USER_TYPE_CURRENT = 0L;
    public static long USER_TYPE_WORK = 1L;
    public String name;
    public String phoneNumber;
    public String normalizedNumber;
    public String geoDescription;
    public String cnapName;
    public int numberPresentation;
    public int namePresentation;
    public boolean contactExists;
    public String phoneLabel;
    public int numberType;
    public String numberLabel;
    public int photoResource;
    public long contactIdOrZero;
    public boolean needUpdate;
    public Uri contactRefUri;
    public String lookupKey;
    public long userType;
    public Uri contactDisplayPhotoUri;
    public Uri contactRingtoneUri;
    public boolean shouldSendToVoicemail;
    public Drawable cachedPhoto;
    public Bitmap cachedPhotoIcon;
    public boolean isCachedPhotoCurrent;
    private boolean mIsEmergency;
    private boolean mIsVoiceMail;

    private void $$robo$$com_android_internal_telephony_CallerInfo$__constructor__() {
        this.mIsEmergency = false;
        this.mIsVoiceMail = false;
        this.userType = 0L;
    }

    private static final CallerInfo $$robo$$com_android_internal_telephony_CallerInfo$getCallerInfo(Context context, Uri contactRef, Cursor cursor) {
        CallerInfo info = new CallerInfo();
        info.photoResource = 0;
        info.phoneLabel = null;
        info.numberType = 0;
        info.numberLabel = null;
        info.cachedPhoto = null;
        info.isCachedPhotoCurrent = false;
        info.contactExists = false;
        info.userType = 0L;
        if (VDBG) {
            Rlog.v("CallerInfo", "getCallerInfo() based on cursor...");
        }
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                int typeColumnIndex;
                int columnIndex = cursor.getColumnIndex("display_name");
                if (columnIndex != -1) {
                    info.name = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("number")) != -1) {
                    info.phoneNumber = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("normalized_number")) != -1) {
                    info.normalizedNumber = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("label")) != -1 && (typeColumnIndex = cursor.getColumnIndex("type")) != -1) {
                    info.numberType = cursor.getInt(typeColumnIndex);
                    info.numberLabel = cursor.getString(columnIndex);
                    info.phoneLabel = ContactsContract.CommonDataKinds.Phone.getDisplayLabel(context, info.numberType, info.numberLabel).toString();
                }
                if ((columnIndex = CallerInfo.getColumnIndexForPersonId(contactRef, cursor)) != -1) {
                    long contactId = cursor.getLong(columnIndex);
                    if (contactId != 0L && !ContactsContract.Contacts.isEnterpriseContactId(contactId)) {
                        info.contactIdOrZero = contactId;
                        if (VDBG) {
                            Rlog.v("CallerInfo", "==> got info.contactIdOrZero: " + info.contactIdOrZero);
                        }
                    }
                    if (ContactsContract.Contacts.isEnterpriseContactId(contactId)) {
                        info.userType = 1L;
                    }
                } else {
                    Rlog.w("CallerInfo", "Couldn't find contact_id column for " + contactRef);
                }
                columnIndex = cursor.getColumnIndex("lookup");
                if (columnIndex != -1) {
                    info.lookupKey = cursor.getString(columnIndex);
                }
                info.contactDisplayPhotoUri = (columnIndex = cursor.getColumnIndex("photo_uri")) != -1 && cursor.getString(columnIndex) != null ? Uri.parse(cursor.getString(columnIndex)) : null;
                columnIndex = cursor.getColumnIndex("custom_ringtone");
                info.contactRingtoneUri = columnIndex != -1 && cursor.getString(columnIndex) != null ? (TextUtils.isEmpty(cursor.getString(columnIndex)) ? Uri.EMPTY : Uri.parse(cursor.getString(columnIndex))) : null;
                columnIndex = cursor.getColumnIndex("send_to_voicemail");
                info.shouldSendToVoicemail = columnIndex != -1 && cursor.getInt(columnIndex) == 1;
                info.contactExists = true;
            }
            cursor.close();
            cursor = null;
        }
        info.needUpdate = false;
        info.name = CallerInfo.normalize(info.name);
        info.contactRefUri = contactRef;
        return info;
    }

    private static final CallerInfo $$robo$$com_android_internal_telephony_CallerInfo$getCallerInfo(Context context, Uri contactRef) {
        CallerInfo info = null;
        ContentResolver cr = CallerInfoAsyncQuery.getCurrentProfileContentResolver(context);
        if (cr != null) {
            try {
                info = CallerInfo.getCallerInfo(context, contactRef, cr.query(contactRef, null, null, null, null));
            }
            catch (RuntimeException re) {
                Rlog.e("CallerInfo", "Error getting caller info.", re);
            }
        }
        return info;
    }

    private static final CallerInfo $$robo$$com_android_internal_telephony_CallerInfo$getCallerInfo(Context context, String number) {
        if (VDBG) {
            Rlog.v("CallerInfo", "getCallerInfo() based on number...");
        }
        int subId = SubscriptionManager.getDefaultSubscriptionId();
        return CallerInfo.getCallerInfo(context, number, subId);
    }

    private static final CallerInfo $$robo$$com_android_internal_telephony_CallerInfo$getCallerInfo(Context context, String number, int subId) {
        if (TextUtils.isEmpty(number)) {
            return null;
        }
        if (PhoneNumberUtils.isLocalEmergencyNumber(context, number)) {
            return new CallerInfo().markAsEmergency(context);
        }
        if (PhoneNumberUtils.isVoiceMailNumber(subId, number)) {
            return new CallerInfo().markAsVoiceMail();
        }
        Uri contactUri = Uri.withAppendedPath(ContactsContract.PhoneLookup.ENTERPRISE_CONTENT_FILTER_URI, Uri.encode(number));
        CallerInfo info = CallerInfo.getCallerInfo(context, contactUri);
        info = CallerInfo.doSecondaryLookupIfNecessary(context, number, info);
        if (TextUtils.isEmpty(info.phoneNumber)) {
            info.phoneNumber = number;
        }
        return info;
    }

    private static final CallerInfo $$robo$$com_android_internal_telephony_CallerInfo$doSecondaryLookupIfNecessary(Context context, String number, CallerInfo previousResult) {
        String username;
        if (!previousResult.contactExists && PhoneNumberUtils.isUriNumber(number) && PhoneNumberUtils.isGlobalPhoneNumber(username = PhoneNumberUtils.getUsernameFromUriNumber(number))) {
            previousResult = CallerInfo.getCallerInfo(context, Uri.withAppendedPath(ContactsContract.PhoneLookup.ENTERPRISE_CONTENT_FILTER_URI, Uri.encode(username)));
        }
        return previousResult;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallerInfo$isEmergencyNumber() {
        return this.mIsEmergency;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallerInfo$isVoiceMailNumber() {
        return this.mIsVoiceMail;
    }

    private final CallerInfo $$robo$$com_android_internal_telephony_CallerInfo$markAsEmergency(Context context) {
        this.phoneNumber = context.getString(17039798);
        this.photoResource = 17302904;
        this.mIsEmergency = true;
        return this;
    }

    private final CallerInfo $$robo$$com_android_internal_telephony_CallerInfo$markAsVoiceMail() {
        int subId = SubscriptionManager.getDefaultSubscriptionId();
        return this.markAsVoiceMail(subId);
    }

    private final CallerInfo $$robo$$com_android_internal_telephony_CallerInfo$markAsVoiceMail(int subId) {
        this.mIsVoiceMail = true;
        try {
            String voiceMailLabel;
            this.phoneNumber = voiceMailLabel = TelephonyManager.getDefault().getVoiceMailAlphaTag(subId);
        }
        catch (SecurityException se) {
            Rlog.e("CallerInfo", "Cannot access VoiceMail.", se);
        }
        return this;
    }

    private static final String $$robo$$com_android_internal_telephony_CallerInfo$normalize(String s) {
        if (s == null || s.length() > 0) {
            return s;
        }
        return null;
    }

    private static final int $$robo$$com_android_internal_telephony_CallerInfo$getColumnIndexForPersonId(Uri contactRef, Cursor cursor) {
        int columnIndex;
        if (VDBG) {
            Rlog.v("CallerInfo", "- getColumnIndexForPersonId: contactRef URI = '" + contactRef + "'...");
        }
        String url = contactRef.toString();
        String columnName = null;
        if (url.startsWith("content://com.android.contacts/data/phones")) {
            if (VDBG) {
                Rlog.v("CallerInfo", "'data/phones' URI; using RawContacts.CONTACT_ID");
            }
            columnName = "contact_id";
        } else if (url.startsWith("content://com.android.contacts/data")) {
            if (VDBG) {
                Rlog.v("CallerInfo", "'data' URI; using Data.CONTACT_ID");
            }
            columnName = "contact_id";
        } else if (url.startsWith("content://com.android.contacts/phone_lookup")) {
            if (VDBG) {
                Rlog.v("CallerInfo", "'phone_lookup' URI; using PhoneLookup._ID");
            }
            columnName = "_id";
        } else {
            Rlog.w("CallerInfo", "Unexpected prefix for contactRef '" + url + "'");
        }
        int n = columnIndex = columnName != null ? cursor.getColumnIndex(columnName) : -1;
        if (VDBG) {
            Rlog.v("CallerInfo", "==> Using column '" + columnName + "' (columnIndex = " + columnIndex + ") for person_id lookup...");
        }
        return columnIndex;
    }

    private final void $$robo$$com_android_internal_telephony_CallerInfo$updateGeoDescription(Context context, String fallbackNumber) {
        String number = TextUtils.isEmpty(this.phoneNumber) ? fallbackNumber : this.phoneNumber;
        this.geoDescription = CallerInfo.getGeoDescription(context, number);
    }

    private static final String $$robo$$com_android_internal_telephony_CallerInfo$getGeoDescription(Context context, String number) {
        if (VDBG) {
            Rlog.v("CallerInfo", "getGeoDescription('" + number + "')...");
        }
        if (TextUtils.isEmpty(number)) {
            return null;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        PhoneNumberOfflineGeocoder geocoder = PhoneNumberOfflineGeocoder.getInstance();
        Locale locale = context.getResources().getConfiguration().locale;
        String countryIso = CallerInfo.getCurrentCountryIso(context, locale);
        Phonenumber.PhoneNumber pn = null;
        try {
            if (VDBG) {
                Rlog.v("CallerInfo", "parsing '" + number + "' for countryIso '" + countryIso + "'...");
            }
            pn = util.parse(number, countryIso);
            if (VDBG) {
                Rlog.v("CallerInfo", "- parsed number: " + pn);
            }
        }
        catch (NumberParseException e) {
            Rlog.w("CallerInfo", "getGeoDescription: NumberParseException for incoming number '" + Rlog.pii("CallerInfo", (Object)number) + "'");
        }
        if (pn != null) {
            String description = geocoder.getDescriptionForNumber(pn, locale);
            if (VDBG) {
                Rlog.v("CallerInfo", "- got description: '" + description + "'");
            }
            return description;
        }
        return null;
    }

    private static final String $$robo$$com_android_internal_telephony_CallerInfo$getCurrentCountryIso(Context context, Locale locale) {
        String countryIso = null;
        CountryDetector detector = (CountryDetector)context.getSystemService("country_detector");
        if (detector != null) {
            Country country = detector.detectCountry();
            if (country != null) {
                countryIso = country.getCountryIso();
            } else {
                Rlog.e("CallerInfo", "CountryDetector.detectCountry() returned null.");
            }
        }
        if (countryIso == null) {
            countryIso = locale.getCountry();
            Rlog.w("CallerInfo", "No CountryDetector; falling back to countryIso based on locale: " + countryIso);
        }
        return countryIso;
    }

    private static final String $$robo$$com_android_internal_telephony_CallerInfo$getCurrentCountryIso(Context context) {
        return CallerInfo.getCurrentCountryIso(context, Locale.getDefault());
    }

    private final String $$robo$$com_android_internal_telephony_CallerInfo$toString() {
        boolean VERBOSE_DEBUG = false;
        return new StringBuilder(128).append(super.toString() + " { ").append("name " + (this.name == null ? "null" : "non-null")).append(", phoneNumber " + (this.phoneNumber == null ? "null" : "non-null")).append(" }").toString();
    }

    static void __staticInitializer__() {
        VDBG = Rlog.isLoggable("CallerInfo", 2);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_CallerInfo$__constructor__();
    }

    public CallerInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CallerInfo$__constructor__(), this);
    }

    public static CallerInfo getCallerInfo(Context context, Uri uri, Cursor cursor) {
        return InvokeDynamicSupport.bootstrapStatic("getCallerInfo", $$robo$$com_android_internal_telephony_CallerInfo$getCallerInfo(android.content.Context android.net.Uri android.database.Cursor ), (Context)context, (Uri)uri, (Cursor)cursor);
    }

    public static CallerInfo getCallerInfo(Context context, Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getCallerInfo", $$robo$$com_android_internal_telephony_CallerInfo$getCallerInfo(android.content.Context android.net.Uri ), (Context)context, (Uri)uri);
    }

    public static CallerInfo getCallerInfo(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCallerInfo", $$robo$$com_android_internal_telephony_CallerInfo$getCallerInfo(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    public static CallerInfo getCallerInfo(Context context, String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCallerInfo", $$robo$$com_android_internal_telephony_CallerInfo$getCallerInfo(android.content.Context java.lang.String int ), (Context)context, (String)string2, (int)n);
    }

    static CallerInfo doSecondaryLookupIfNecessary(Context context, String string2, CallerInfo callerInfo) {
        return InvokeDynamicSupport.bootstrapStatic("doSecondaryLookupIfNecessary", $$robo$$com_android_internal_telephony_CallerInfo$doSecondaryLookupIfNecessary(android.content.Context java.lang.String com.android.internal.telephony.CallerInfo ), (Context)context, (String)string2, (CallerInfo)callerInfo);
    }

    public boolean isEmergencyNumber() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmergencyNumber", $$robo$$com_android_internal_telephony_CallerInfo$isEmergencyNumber(), this);
    }

    public boolean isVoiceMailNumber() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVoiceMailNumber", $$robo$$com_android_internal_telephony_CallerInfo$isVoiceMailNumber(), this);
    }

    CallerInfo markAsEmergency(Context context) {
        return InvokeDynamicSupport.bootstrap("markAsEmergency", $$robo$$com_android_internal_telephony_CallerInfo$markAsEmergency(android.content.Context ), this, context);
    }

    CallerInfo markAsVoiceMail() {
        return InvokeDynamicSupport.bootstrap("markAsVoiceMail", $$robo$$com_android_internal_telephony_CallerInfo$markAsVoiceMail(), this);
    }

    CallerInfo markAsVoiceMail(int n) {
        return InvokeDynamicSupport.bootstrap("markAsVoiceMail", $$robo$$com_android_internal_telephony_CallerInfo$markAsVoiceMail(int ), this, n);
    }

    private static String normalize(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$com_android_internal_telephony_CallerInfo$normalize(java.lang.String ), (String)string2);
    }

    private static int getColumnIndexForPersonId(Uri uri, Cursor cursor) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getColumnIndexForPersonId", $$robo$$com_android_internal_telephony_CallerInfo$getColumnIndexForPersonId(android.net.Uri android.database.Cursor ), (Uri)uri, (Cursor)cursor);
    }

    public void updateGeoDescription(Context context, String string2) {
        InvokeDynamicSupport.bootstrap("updateGeoDescription", $$robo$$com_android_internal_telephony_CallerInfo$updateGeoDescription(android.content.Context java.lang.String ), this, context, string2);
    }

    private static String getGeoDescription(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getGeoDescription", $$robo$$com_android_internal_telephony_CallerInfo$getGeoDescription(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    private static String getCurrentCountryIso(Context context, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrentCountryIso", $$robo$$com_android_internal_telephony_CallerInfo$getCurrentCountryIso(android.content.Context java.util.Locale ), (Context)context, (Locale)locale);
    }

    protected static String getCurrentCountryIso(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getCurrentCountryIso", $$robo$$com_android_internal_telephony_CallerInfo$getCurrentCountryIso(android.content.Context ), (Context)context);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_CallerInfo$toString(), this);
    }

    static {
        RobolectricInternals.classInitializing(CallerInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallerInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

