/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextThemeWrapper;
import android.view.DisplayListCanvas;
import android.view.InputQueue;
import android.view.KeyEvent;
import android.view.KeyboardShortcutGroup;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewStub;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowCallbacks;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import com.android.internal.policy.BackdropFrameRenderer;
import com.android.internal.policy.DecorContext;
import com.android.internal.policy.PhoneWindow;
import com.android.internal.view.FloatingActionMode;
import com.android.internal.view.RootViewSurfaceTaker;
import com.android.internal.view.StandaloneActionMode;
import com.android.internal.view.menu.ContextMenuBuilder;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuHelper;
import com.android.internal.widget.ActionBarContextView;
import com.android.internal.widget.BackgroundFallback;
import com.android.internal.widget.DecorCaptionView;
import com.android.internal.widget.FloatingToolbar;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DecorView
extends FrameLayout
implements RootViewSurfaceTaker,
WindowCallbacks,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "DecorView";
    private static boolean DEBUG_MEASURE = false;
    private static boolean SWEEP_OPEN_MENU = false;
    private static int DECOR_SHADOW_FOCUSED_HEIGHT_IN_DIP = 20;
    private static int DECOR_SHADOW_UNFOCUSED_HEIGHT_IN_DIP = 5;
    public static ColorViewAttributes STATUS_BAR_COLOR_VIEW_ATTRIBUTES;
    public static ColorViewAttributes NAVIGATION_BAR_COLOR_VIEW_ATTRIBUTES;
    private static ViewOutlineProvider PIP_OUTLINE_PROVIDER;
    private boolean mAllowUpdateElevation;
    private boolean mElevationAdjustedForStack;
    private boolean mIsInPictureInPictureMode;
    private ViewOutlineProvider mLastOutlineProvider;
    int mDefaultOpacity;
    private int mFeatureId;
    private Rect mDrawingBounds;
    private Rect mBackgroundPadding;
    private Rect mFramePadding;
    private Rect mFrameOffsets;
    private boolean mHasCaption;
    private boolean mChanging;
    private Drawable mMenuBackground;
    private boolean mWatchingForMenu;
    private int mDownY;
    ActionMode mPrimaryActionMode;
    private ActionMode mFloatingActionMode;
    private ActionBarContextView mPrimaryActionModeView;
    private PopupWindow mPrimaryActionModePopup;
    private Runnable mShowPrimaryActionModePopup;
    private ViewTreeObserver.OnPreDrawListener mFloatingToolbarPreDrawListener;
    private View mFloatingActionModeOriginatingView;
    private FloatingToolbar mFloatingToolbar;
    private ObjectAnimator mFadeAnim;
    private View mStatusGuard;
    private View mNavigationGuard;
    private ColorViewState mStatusColorViewState;
    private ColorViewState mNavigationColorViewState;
    private Interpolator mShowInterpolator;
    private Interpolator mHideInterpolator;
    private int mBarEnterExitDuration;
    boolean mForceWindowDrawsStatusBarBackground;
    private int mSemiTransparentStatusBarColor;
    private BackgroundFallback mBackgroundFallback;
    private int mLastTopInset;
    private int mLastBottomInset;
    private int mLastRightInset;
    private int mLastLeftInset;
    private boolean mLastHasTopStableInset;
    private boolean mLastHasBottomStableInset;
    private boolean mLastHasRightStableInset;
    private boolean mLastHasLeftStableInset;
    private int mLastWindowFlags;
    private boolean mLastShouldAlwaysConsumeNavBar;
    private int mRootScrollY;
    private PhoneWindow mWindow;
    ViewGroup mContentRoot;
    private Rect mTempRect;
    private Rect mOutsets;
    DecorCaptionView mDecorCaptionView;
    int mStackId;
    private boolean mWindowResizeCallbacksAdded;
    private Drawable.Callback mLastBackgroundDrawableCb;
    private BackdropFrameRenderer mBackdropFrameRenderer;
    private Drawable mResizingBackgroundDrawable;
    private Drawable mCaptionBackgroundDrawable;
    private Drawable mUserCaptionBackgroundDrawable;
    private float mAvailableWidth;
    String mLogTag;
    private Rect mFloatingInsets;
    private boolean mApplyFloatingVerticalInsets;
    private boolean mApplyFloatingHorizontalInsets;
    private int mResizeMode;
    private int mResizeShadowSize;
    private Paint mVerticalResizeShadowPaint;
    private Paint mHorizontalResizeShadowPaint;

    private void $$robo$$com_android_internal_policy_DecorView$__constructor__(Context context, int featureId, PhoneWindow window, WindowManager.LayoutParams params) {
        this.mAllowUpdateElevation = false;
        this.mElevationAdjustedForStack = false;
        this.mDefaultOpacity = -1;
        this.mDrawingBounds = new Rect();
        this.mBackgroundPadding = new Rect();
        this.mFramePadding = new Rect();
        this.mFrameOffsets = new Rect();
        this.mHasCaption = false;
        this.mStatusColorViewState = new ColorViewState(STATUS_BAR_COLOR_VIEW_ATTRIBUTES);
        this.mNavigationColorViewState = new ColorViewState(NAVIGATION_BAR_COLOR_VIEW_ATTRIBUTES);
        this.mBackgroundFallback = new BackgroundFallback();
        this.mLastTopInset = 0;
        this.mLastBottomInset = 0;
        this.mLastRightInset = 0;
        this.mLastLeftInset = 0;
        this.mLastHasTopStableInset = false;
        this.mLastHasBottomStableInset = false;
        this.mLastHasRightStableInset = false;
        this.mLastHasLeftStableInset = false;
        this.mLastWindowFlags = 0;
        this.mLastShouldAlwaysConsumeNavBar = false;
        this.mRootScrollY = 0;
        this.mOutsets = new Rect();
        this.mWindowResizeCallbacksAdded = false;
        this.mLastBackgroundDrawableCb = null;
        this.mBackdropFrameRenderer = null;
        this.mLogTag = "DecorView";
        this.mFloatingInsets = new Rect();
        this.mApplyFloatingVerticalInsets = false;
        this.mApplyFloatingHorizontalInsets = false;
        this.mResizeMode = -1;
        this.mVerticalResizeShadowPaint = new Paint();
        this.mHorizontalResizeShadowPaint = new Paint();
        this.mFeatureId = featureId;
        this.mShowInterpolator = AnimationUtils.loadInterpolator(context, 17563662);
        this.mHideInterpolator = AnimationUtils.loadInterpolator(context, 17563663);
        this.mBarEnterExitDuration = context.getResources().getInteger(17694915);
        this.mForceWindowDrawsStatusBarBackground = context.getResources().getBoolean(17956959) && context.getApplicationInfo().targetSdkVersion >= 24;
        this.mSemiTransparentStatusBarColor = context.getResources().getColor(17170760, null);
        this.updateAvailableWidth();
        this.setWindow(window);
        this.updateLogTag(params);
        this.mResizeShadowSize = context.getResources().getDimensionPixelSize(17105210);
        this.initResizingPaints();
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setBackgroundFallback(int resId) {
        this.mBackgroundFallback.setDrawable(resId != 0 ? this.getContext().getDrawable(resId) : null);
        this.setWillNotDraw(this.getBackground() == null && !this.mBackgroundFallback.hasFallback());
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$gatherTransparentRegion(Region region) {
        boolean statusOpaque = this.gatherTransparentRegion(this.mStatusColorViewState, region);
        boolean navOpaque = this.gatherTransparentRegion(this.mNavigationColorViewState, region);
        boolean decorOpaque = super.gatherTransparentRegion(region);
        return statusOpaque || navOpaque || decorOpaque;
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$gatherTransparentRegion(ColorViewState colorViewState, Region region) {
        if (colorViewState.view != null && colorViewState.visible && this.isResizing()) {
            return colorViewState.view.gatherTransparentRegion(region);
        }
        return false;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onDraw(Canvas c) {
        super.onDraw(c);
        this.mBackgroundFallback.draw(this.isResizing() ? this : this.mContentRoot, this.mContentRoot, c, this.mWindow.mContentParent);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$dispatchKeyEvent(KeyEvent event) {
        boolean isDown;
        int keyCode = event.getKeyCode();
        int action = event.getAction();
        boolean bl = isDown = action == 0;
        if (isDown && event.getRepeatCount() == 0) {
            boolean handled;
            if (this.mWindow.mPanelChordingKey > 0 && this.mWindow.mPanelChordingKey != keyCode && (handled = this.dispatchKeyShortcutEvent(event))) {
                return true;
            }
            if (this.mWindow.mPreparedPanel != null && this.mWindow.mPreparedPanel.isOpen && this.mWindow.performPanelShortcut(this.mWindow.mPreparedPanel, keyCode, event, 0)) {
                return true;
            }
        }
        if (!this.mWindow.isDestroyed()) {
            boolean handled;
            Window.Callback cb = this.mWindow.getCallback();
            boolean bl2 = handled = cb != null && this.mFeatureId < 0 ? cb.dispatchKeyEvent(event) : super.dispatchKeyEvent(event);
            if (handled) {
                return true;
            }
        }
        return isDown ? this.mWindow.onKeyDown(this.mFeatureId, event.getKeyCode(), event) : this.mWindow.onKeyUp(this.mFeatureId, event.getKeyCode(), event);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$dispatchKeyShortcutEvent(KeyEvent ev) {
        boolean handled;
        if (this.mWindow.mPreparedPanel != null && (handled = this.mWindow.performPanelShortcut(this.mWindow.mPreparedPanel, ev.getKeyCode(), ev, 1))) {
            if (this.mWindow.mPreparedPanel != null) {
                this.mWindow.mPreparedPanel.isHandled = true;
            }
            return true;
        }
        Window.Callback cb = this.mWindow.getCallback();
        boolean bl = handled = cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchKeyShortcutEvent(ev) : super.dispatchKeyShortcutEvent(ev);
        if (handled) {
            return true;
        }
        PhoneWindow.PanelFeatureState st = this.mWindow.getPanelState(0, false);
        if (st != null && this.mWindow.mPreparedPanel == null) {
            this.mWindow.preparePanel(st, ev);
            handled = this.mWindow.performPanelShortcut(st, ev.getKeyCode(), ev, 1);
            st.isPrepared = false;
            if (handled) {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$dispatchTouchEvent(MotionEvent ev) {
        Window.Callback cb = this.mWindow.getCallback();
        return cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchTouchEvent(ev) : super.dispatchTouchEvent(ev);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$dispatchTrackballEvent(MotionEvent ev) {
        Window.Callback cb = this.mWindow.getCallback();
        return cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchTrackballEvent(ev) : super.dispatchTrackballEvent(ev);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$dispatchGenericMotionEvent(MotionEvent ev) {
        Window.Callback cb = this.mWindow.getCallback();
        return cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0 ? cb.dispatchGenericMotionEvent(ev) : super.dispatchGenericMotionEvent(ev);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$superDispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 4) {
            int action = event.getAction();
            if (this.mPrimaryActionMode != null) {
                if (action == 1) {
                    this.mPrimaryActionMode.finish();
                }
                return true;
            }
        }
        return super.dispatchKeyEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$superDispatchKeyShortcutEvent(KeyEvent event) {
        return super.dispatchKeyShortcutEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$superDispatchTouchEvent(MotionEvent event) {
        return super.dispatchTouchEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$superDispatchTrackballEvent(MotionEvent event) {
        return super.dispatchTrackballEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$superDispatchGenericMotionEvent(MotionEvent event) {
        return super.dispatchGenericMotionEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$onTouchEvent(MotionEvent event) {
        return this.onInterceptTouchEvent(event);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$isOutOfInnerBounds(int x, int y) {
        return x < 0 || y < 0 || x > this.getWidth() || y > this.getHeight();
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$isOutOfBounds(int x, int y) {
        return x < -5 || y < -5 || x > this.getWidth() + 5 || y > this.getHeight() + 5;
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$onInterceptTouchEvent(MotionEvent event) {
        int y;
        int x;
        int action = event.getAction();
        if (this.mHasCaption && this.isShowingCaption() && action == 0 && this.isOutOfInnerBounds(x = (int)event.getX(), y = (int)event.getY())) {
            return true;
        }
        if (this.mFeatureId >= 0 && action == 0 && this.isOutOfBounds(x = (int)event.getX(), y = (int)event.getY())) {
            this.mWindow.closePanel(this.mFeatureId);
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$sendAccessibilityEvent(int eventType) {
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return;
        }
        if ((this.mFeatureId == 0 || this.mFeatureId == 6 || this.mFeatureId == 2 || this.mFeatureId == 5) && this.getChildCount() == 1) {
            this.getChildAt(0).sendAccessibilityEvent(eventType);
        } else {
            super.sendAccessibilityEvent(eventType);
        }
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        Window.Callback cb = this.mWindow.getCallback();
        if (cb != null && !this.mWindow.isDestroyed() && cb.dispatchPopulateAccessibilityEvent(event)) {
            return true;
        }
        return super.dispatchPopulateAccessibilityEventInternal(event);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$setFrame(int l, int t, int r, int b) {
        boolean changed = super.setFrame(l, t, r, b);
        if (changed) {
            Drawable bg;
            Rect drawingBounds = this.mDrawingBounds;
            this.getDrawingRect(drawingBounds);
            Drawable fg = this.getForeground();
            if (fg != null) {
                Rect frameOffsets = this.mFrameOffsets;
                drawingBounds.left += frameOffsets.left;
                drawingBounds.top += frameOffsets.top;
                drawingBounds.right -= frameOffsets.right;
                drawingBounds.bottom -= frameOffsets.bottom;
                fg.setBounds(drawingBounds);
                Rect framePadding = this.mFramePadding;
                drawingBounds.left += framePadding.left - frameOffsets.left;
                drawingBounds.top += framePadding.top - frameOffsets.top;
                drawingBounds.right -= framePadding.right - frameOffsets.right;
                drawingBounds.bottom -= framePadding.bottom - frameOffsets.bottom;
            }
            if ((bg = this.getBackground()) != null) {
                bg.setBounds(drawingBounds);
            }
        }
        return changed;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int mode;
        DisplayMetrics metrics = this.getContext().getResources().getDisplayMetrics();
        boolean isPortrait = this.getResources().getConfiguration().orientation == 1;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean fixedWidth = false;
        this.mApplyFloatingHorizontalInsets = false;
        if (widthMode == Integer.MIN_VALUE) {
            TypedValue tvw;
            TypedValue typedValue = tvw = isPortrait ? this.mWindow.mFixedWidthMinor : this.mWindow.mFixedWidthMajor;
            if (tvw != null && tvw.type != 0) {
                int w = tvw.type == 5 ? (int)tvw.getDimension(metrics) : (tvw.type == 6 ? (int)tvw.getFraction(metrics.widthPixels, metrics.widthPixels) : 0);
                int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
                if (w > 0) {
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(w, widthSize), 0x40000000);
                    fixedWidth = true;
                } else {
                    widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(widthSize - this.mFloatingInsets.left - this.mFloatingInsets.right, Integer.MIN_VALUE);
                    this.mApplyFloatingHorizontalInsets = true;
                }
            }
        }
        this.mApplyFloatingVerticalInsets = false;
        if (heightMode == Integer.MIN_VALUE) {
            TypedValue tvh;
            TypedValue typedValue = tvh = isPortrait ? this.mWindow.mFixedHeightMajor : this.mWindow.mFixedHeightMinor;
            if (tvh != null && tvh.type != 0) {
                int h = tvh.type == 5 ? (int)tvh.getDimension(metrics) : (tvh.type == 6 ? (int)tvh.getFraction(metrics.heightPixels, metrics.heightPixels) : 0);
                int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
                if (h > 0) {
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(h, heightSize), 0x40000000);
                } else if ((this.mWindow.getAttributes().flags & 0x100) == 0) {
                    heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(heightSize - this.mFloatingInsets.top - this.mFloatingInsets.bottom, Integer.MIN_VALUE);
                    this.mApplyFloatingVerticalInsets = true;
                }
            }
        }
        this.getOutsets(this.mOutsets);
        if ((this.mOutsets.top > 0 || this.mOutsets.bottom > 0) && (mode = View.MeasureSpec.getMode(heightMeasureSpec)) != 0) {
            int height = View.MeasureSpec.getSize(heightMeasureSpec);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(height + this.mOutsets.top + this.mOutsets.bottom, mode);
        }
        if ((this.mOutsets.left > 0 || this.mOutsets.right > 0) && (mode = View.MeasureSpec.getMode(widthMeasureSpec)) != 0) {
            int width = View.MeasureSpec.getSize(widthMeasureSpec);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width + this.mOutsets.left + this.mOutsets.right, mode);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = this.getMeasuredWidth();
        boolean measure = false;
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(width, 0x40000000);
        if (!fixedWidth && widthMode == Integer.MIN_VALUE) {
            int min;
            TypedValue tv;
            TypedValue typedValue = tv = isPortrait ? this.mWindow.mMinWidthMinor : this.mWindow.mMinWidthMajor;
            if (tv.type != 0 && width < (min = tv.type == 5 ? (int)tv.getDimension(metrics) : (tv.type == 6 ? (int)tv.getFraction(this.mAvailableWidth, this.mAvailableWidth) : 0))) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(min, 0x40000000);
                measure = true;
            }
        }
        if (measure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.getOutsets(this.mOutsets);
        if (this.mOutsets.left > 0) {
            this.offsetLeftAndRight(-this.mOutsets.left);
        }
        if (this.mOutsets.top > 0) {
            this.offsetTopAndBottom(-this.mOutsets.top);
        }
        if (this.mApplyFloatingVerticalInsets) {
            this.offsetTopAndBottom(this.mFloatingInsets.top);
        }
        if (this.mApplyFloatingHorizontalInsets) {
            this.offsetLeftAndRight(this.mFloatingInsets.left);
        }
        this.updateElevation();
        this.mAllowUpdateElevation = true;
        if (changed && this.mResizeMode == 1) {
            this.getViewRootImpl().requestInvalidateRootRenderNode();
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mMenuBackground != null) {
            this.mMenuBackground.draw(canvas);
        }
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$showContextMenuForChild(View originalView) {
        return this.showContextMenuForChildInternal(originalView, Float.NaN, Float.NaN);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$showContextMenuForChild(View originalView, float x, float y) {
        return this.showContextMenuForChildInternal(originalView, x, y);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$showContextMenuForChildInternal(View originalView, float x, float y) {
        if (this.mWindow.mContextMenuHelper != null) {
            this.mWindow.mContextMenuHelper.dismiss();
            this.mWindow.mContextMenuHelper = null;
        }
        PhoneWindow.PhoneWindowMenuCallback callback = this.mWindow.mContextMenuCallback;
        if (this.mWindow.mContextMenu == null) {
            this.mWindow.mContextMenu = new ContextMenuBuilder(this.getContext());
            this.mWindow.mContextMenu.setCallback(callback);
        } else {
            this.mWindow.mContextMenu.clearAll();
        }
        boolean isPopup = !Float.isNaN(x) && !Float.isNaN(y);
        MenuHelper helper = isPopup ? this.mWindow.mContextMenu.showPopup(this.getContext(), originalView, x, y) : this.mWindow.mContextMenu.showDialog(originalView, originalView.getWindowToken());
        if (helper != null) {
            callback.setShowDialogForSubmenu(!isPopup);
            helper.setPresenterCallback(callback);
        }
        this.mWindow.mContextMenuHelper = helper;
        return helper != null;
    }

    private final ActionMode $$robo$$com_android_internal_policy_DecorView$startActionModeForChild(View originalView, ActionMode.Callback callback) {
        return this.startActionModeForChild(originalView, callback, 0);
    }

    private final ActionMode $$robo$$com_android_internal_policy_DecorView$startActionModeForChild(View child, ActionMode.Callback callback, int type) {
        return this.startActionMode(child, callback, type);
    }

    private final ActionMode $$robo$$com_android_internal_policy_DecorView$startActionMode(ActionMode.Callback callback) {
        return this.startActionMode(callback, 0);
    }

    private final ActionMode $$robo$$com_android_internal_policy_DecorView$startActionMode(ActionMode.Callback callback, int type) {
        return this.startActionMode(this, callback, type);
    }

    private final ActionMode $$robo$$com_android_internal_policy_DecorView$startActionMode(View originatingView, ActionMode.Callback callback, int type) {
        ActionMode mode;
        ActionModeCallback2Wrapper wrappedCallback;
        block16: {
            wrappedCallback = new ActionModeCallback2Wrapper(this, callback);
            mode = null;
            if (this.mWindow.getCallback() != null && !this.mWindow.isDestroyed()) {
                try {
                    mode = this.mWindow.getCallback().onWindowStartingActionMode(wrappedCallback, type);
                }
                catch (AbstractMethodError ame) {
                    if (type != 0) break block16;
                    try {
                        mode = this.mWindow.getCallback().onWindowStartingActionMode(wrappedCallback);
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        // empty catch block
                    }
                }
            }
        }
        if (mode != null) {
            if (mode.getType() == 0) {
                this.cleanupPrimaryActionMode();
                this.mPrimaryActionMode = mode;
            } else if (mode.getType() == 1) {
                if (this.mFloatingActionMode != null) {
                    this.mFloatingActionMode.finish();
                }
                this.mFloatingActionMode = mode;
            }
        } else {
            mode = this.createActionMode(type, wrappedCallback, originatingView);
            if (mode != null && wrappedCallback.onCreateActionMode(mode, mode.getMenu())) {
                this.setHandledActionMode(mode);
            } else {
                mode = null;
            }
        }
        if (mode != null && this.mWindow.getCallback() != null && !this.mWindow.isDestroyed()) {
            try {
                this.mWindow.getCallback().onActionModeStarted(mode);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return mode;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$cleanupPrimaryActionMode() {
        if (this.mPrimaryActionMode != null) {
            this.mPrimaryActionMode.finish();
            this.mPrimaryActionMode = null;
        }
        if (this.mPrimaryActionModeView != null) {
            this.mPrimaryActionModeView.killMode();
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$cleanupFloatingActionModeViews() {
        if (this.mFloatingToolbar != null) {
            this.mFloatingToolbar.dismiss();
            this.mFloatingToolbar = null;
        }
        if (this.mFloatingActionModeOriginatingView != null) {
            if (this.mFloatingToolbarPreDrawListener != null) {
                this.mFloatingActionModeOriginatingView.getViewTreeObserver().removeOnPreDrawListener(this.mFloatingToolbarPreDrawListener);
                this.mFloatingToolbarPreDrawListener = null;
            }
            this.mFloatingActionModeOriginatingView = null;
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$startChanging() {
        this.mChanging = true;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$finishChanging() {
        this.mChanging = false;
        this.drawableChanged();
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setWindowBackground(Drawable drawable2) {
        if (this.getBackground() != drawable2) {
            this.setBackgroundDrawable(drawable2);
            this.mResizingBackgroundDrawable = drawable2 != null ? DecorView.enforceNonTranslucentBackground(drawable2, this.mWindow.isTranslucent() || this.mWindow.isShowingWallpaper()) : DecorView.getResizingBackgroundDrawable(this.getContext(), 0, this.mWindow.mBackgroundFallbackResource, this.mWindow.isTranslucent() || this.mWindow.isShowingWallpaper());
            if (this.mResizingBackgroundDrawable != null) {
                this.mResizingBackgroundDrawable.getPadding(this.mBackgroundPadding);
            } else {
                this.mBackgroundPadding.setEmpty();
            }
            this.drawableChanged();
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setWindowFrame(Drawable drawable2) {
        if (this.getForeground() != drawable2) {
            this.setForeground(drawable2);
            if (drawable2 != null) {
                drawable2.getPadding(this.mFramePadding);
            } else {
                this.mFramePadding.setEmpty();
            }
            this.drawableChanged();
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onWindowSystemUiVisibilityChanged(int visible) {
        this.updateColorViews(null, true);
    }

    private final WindowInsets $$robo$$com_android_internal_policy_DecorView$onApplyWindowInsets(WindowInsets insets) {
        WindowManager.LayoutParams attrs = this.mWindow.getAttributes();
        this.mFloatingInsets.setEmpty();
        if ((attrs.flags & 0x100) == 0) {
            if (attrs.height == -2) {
                this.mFloatingInsets.top = insets.getSystemWindowInsetTop();
                this.mFloatingInsets.bottom = insets.getSystemWindowInsetBottom();
                insets = insets.replaceSystemWindowInsets(insets.getSystemWindowInsetLeft(), 0, insets.getSystemWindowInsetRight(), 0);
            }
            if (this.mWindow.getAttributes().width == -2) {
                this.mFloatingInsets.left = insets.getSystemWindowInsetTop();
                this.mFloatingInsets.right = insets.getSystemWindowInsetBottom();
                insets = insets.replaceSystemWindowInsets(0, insets.getSystemWindowInsetTop(), 0, insets.getSystemWindowInsetBottom());
            }
        }
        this.mFrameOffsets.set(insets.getSystemWindowInsets());
        insets = this.updateColorViews(insets, true);
        insets = this.updateStatusGuard(insets);
        insets = this.updateNavigationGuard(insets);
        if (this.getForeground() != null) {
            this.drawableChanged();
        }
        return insets;
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$isTransitionGroup() {
        return false;
    }

    private static final int $$robo$$com_android_internal_policy_DecorView$getColorViewTopInset(int stableTop, int systemTop) {
        return Math.min(stableTop, systemTop);
    }

    private static final int $$robo$$com_android_internal_policy_DecorView$getColorViewBottomInset(int stableBottom, int systemBottom) {
        return Math.min(stableBottom, systemBottom);
    }

    private static final int $$robo$$com_android_internal_policy_DecorView$getColorViewRightInset(int stableRight, int systemRight) {
        return Math.min(stableRight, systemRight);
    }

    private static final int $$robo$$com_android_internal_policy_DecorView$getColorViewLeftInset(int stableLeft, int systemLeft) {
        return Math.min(stableLeft, systemLeft);
    }

    private static final boolean $$robo$$com_android_internal_policy_DecorView$isNavBarToRightEdge(int bottomInset, int rightInset) {
        return bottomInset == 0 && rightInset > 0;
    }

    private static final boolean $$robo$$com_android_internal_policy_DecorView$isNavBarToLeftEdge(int bottomInset, int leftInset) {
        return bottomInset == 0 && leftInset > 0;
    }

    private static final int $$robo$$com_android_internal_policy_DecorView$getNavBarSize(int bottomInset, int rightInset, int leftInset) {
        return DecorView.isNavBarToRightEdge(bottomInset, rightInset) ? rightInset : (DecorView.isNavBarToLeftEdge(bottomInset, leftInset) ? leftInset : bottomInset);
    }

    private static final void $$robo$$com_android_internal_policy_DecorView$getNavigationBarRect(int canvasWidth, int canvasHeight, Rect stableInsets, Rect contentInsets, Rect outRect) {
        int bottomInset = DecorView.getColorViewBottomInset(stableInsets.bottom, contentInsets.bottom);
        int leftInset = DecorView.getColorViewLeftInset(stableInsets.left, contentInsets.left);
        int rightInset = DecorView.getColorViewLeftInset(stableInsets.right, contentInsets.right);
        int size = DecorView.getNavBarSize(bottomInset, rightInset, leftInset);
        if (DecorView.isNavBarToRightEdge(bottomInset, rightInset)) {
            outRect.set(canvasWidth - size, 0, canvasWidth, canvasHeight);
        } else if (DecorView.isNavBarToLeftEdge(bottomInset, leftInset)) {
            outRect.set(0, 0, size, canvasHeight);
        } else {
            outRect.set(0, canvasHeight - size, canvasWidth, canvasHeight);
        }
    }

    private final WindowInsets $$robo$$com_android_internal_policy_DecorView$updateColorViews(WindowInsets insets, boolean animate) {
        int consumedLeft;
        WindowManager.LayoutParams attrs = this.mWindow.getAttributes();
        int sysUiVisibility = attrs.systemUiVisibility | this.getWindowSystemUiVisibility();
        if (!this.mWindow.mIsFloating && ActivityManager.isHighEndGfx()) {
            boolean statusBarNeedsLeftInset;
            boolean disallowAnimate = !this.isLaidOut();
            disallowAnimate |= ((this.mLastWindowFlags ^ attrs.flags) & Integer.MIN_VALUE) != 0;
            this.mLastWindowFlags = attrs.flags;
            if (insets != null) {
                this.mLastTopInset = DecorView.getColorViewTopInset(insets.getStableInsetTop(), insets.getSystemWindowInsetTop());
                this.mLastBottomInset = DecorView.getColorViewBottomInset(insets.getStableInsetBottom(), insets.getSystemWindowInsetBottom());
                this.mLastRightInset = DecorView.getColorViewRightInset(insets.getStableInsetRight(), insets.getSystemWindowInsetRight());
                this.mLastLeftInset = DecorView.getColorViewRightInset(insets.getStableInsetLeft(), insets.getSystemWindowInsetLeft());
                boolean hasTopStableInset = insets.getStableInsetTop() != 0;
                disallowAnimate |= hasTopStableInset != this.mLastHasTopStableInset;
                this.mLastHasTopStableInset = hasTopStableInset;
                boolean hasBottomStableInset = insets.getStableInsetBottom() != 0;
                disallowAnimate |= hasBottomStableInset != this.mLastHasBottomStableInset;
                this.mLastHasBottomStableInset = hasBottomStableInset;
                boolean hasRightStableInset = insets.getStableInsetRight() != 0;
                disallowAnimate |= hasRightStableInset != this.mLastHasRightStableInset;
                this.mLastHasRightStableInset = hasRightStableInset;
                boolean hasLeftStableInset = insets.getStableInsetLeft() != 0;
                disallowAnimate |= hasLeftStableInset != this.mLastHasLeftStableInset;
                this.mLastHasLeftStableInset = hasLeftStableInset;
                this.mLastShouldAlwaysConsumeNavBar = insets.shouldAlwaysConsumeNavBar();
            }
            boolean navBarToRightEdge = DecorView.isNavBarToRightEdge(this.mLastBottomInset, this.mLastRightInset);
            boolean navBarToLeftEdge = DecorView.isNavBarToLeftEdge(this.mLastBottomInset, this.mLastLeftInset);
            int navBarSize = DecorView.getNavBarSize(this.mLastBottomInset, this.mLastRightInset, this.mLastLeftInset);
            this.updateColorViewInt(this.mNavigationColorViewState, sysUiVisibility, this.mWindow.mNavigationBarColor, navBarSize, navBarToRightEdge || navBarToLeftEdge, navBarToLeftEdge, 0, animate && !disallowAnimate, false);
            boolean statusBarNeedsRightInset = navBarToRightEdge && this.mNavigationColorViewState.present;
            boolean bl = statusBarNeedsLeftInset = navBarToLeftEdge && this.mNavigationColorViewState.present;
            int statusBarSideInset = statusBarNeedsRightInset ? this.mLastRightInset : (statusBarNeedsLeftInset ? this.mLastLeftInset : 0);
            this.updateColorViewInt(this.mStatusColorViewState, sysUiVisibility, this.calculateStatusBarColor(), this.mLastTopInset, false, statusBarNeedsLeftInset, statusBarSideInset, animate && !disallowAnimate, this.mForceWindowDrawsStatusBarBackground);
        }
        boolean consumingNavBar = (attrs.flags & Integer.MIN_VALUE) != 0 && (sysUiVisibility & 0x200) == 0 && (sysUiVisibility & 2) == 0 || this.mLastShouldAlwaysConsumeNavBar;
        boolean consumingStatusBar = (sysUiVisibility & 0x400) == 0 && (sysUiVisibility & Integer.MIN_VALUE) == 0 && (attrs.flags & 0x100) == 0 && (attrs.flags & 0x10000) == 0 && this.mForceWindowDrawsStatusBarBackground && this.mLastTopInset != 0;
        int consumedTop = consumingStatusBar ? this.mLastTopInset : 0;
        int consumedRight = consumingNavBar ? this.mLastRightInset : 0;
        int consumedBottom = consumingNavBar ? this.mLastBottomInset : 0;
        int n = consumedLeft = consumingNavBar ? this.mLastLeftInset : 0;
        if (this.mContentRoot != null && this.mContentRoot.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mContentRoot.getLayoutParams();
            if (lp.topMargin != consumedTop || lp.rightMargin != consumedRight || lp.bottomMargin != consumedBottom || lp.leftMargin != consumedLeft) {
                lp.topMargin = consumedTop;
                lp.rightMargin = consumedRight;
                lp.bottomMargin = consumedBottom;
                lp.leftMargin = consumedLeft;
                this.mContentRoot.setLayoutParams(lp);
                if (insets == null) {
                    this.requestApplyInsets();
                }
            }
            if (insets != null) {
                insets = insets.replaceSystemWindowInsets(insets.getSystemWindowInsetLeft() - consumedLeft, insets.getSystemWindowInsetTop() - consumedTop, insets.getSystemWindowInsetRight() - consumedRight, insets.getSystemWindowInsetBottom() - consumedBottom);
            }
        }
        if (insets != null) {
            insets = insets.consumeStableInsets();
        }
        return insets;
    }

    private final int $$robo$$com_android_internal_policy_DecorView$calculateStatusBarColor() {
        return DecorView.calculateStatusBarColor(this.mWindow.getAttributes().flags, this.mSemiTransparentStatusBarColor, this.mWindow.mStatusBarColor);
    }

    private static final int $$robo$$com_android_internal_policy_DecorView$calculateStatusBarColor(int flags, int semiTransparentStatusBarColor, int statusBarColor) {
        return (flags & 0x4000000) != 0 ? semiTransparentStatusBarColor : ((flags & Integer.MIN_VALUE) != 0 ? statusBarColor : -16777216);
    }

    private final int $$robo$$com_android_internal_policy_DecorView$getCurrentColor(ColorViewState state) {
        if (state.visible) {
            return state.color;
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$updateColorViewInt(ColorViewState state, int sysUiVis, int color2, int size, boolean verticalBar, boolean seascape, int sideMargin, boolean animate, boolean force) {
        int resolvedGravity;
        int resolvedWidth;
        state.present = state.attributes.isPresent(sysUiVis, this.mWindow.getAttributes().flags, force);
        boolean show = state.attributes.isVisible(state.present, color2, this.mWindow.getAttributes().flags, force);
        boolean showView = show && !this.isResizing() && size > 0;
        boolean visibilityChanged = false;
        View view = state.view;
        int resolvedHeight = verticalBar ? -1 : size;
        int n = resolvedWidth = verticalBar ? size : -1;
        int n2 = verticalBar ? (seascape ? state.attributes.seascapeGravity : state.attributes.horizontalGravity) : (resolvedGravity = state.attributes.verticalGravity);
        if (view == null) {
            if (showView) {
                state.view = view = new View(this.mContext);
                view.setBackgroundColor(color2);
                view.setTransitionName(state.attributes.transitionName);
                view.setId(state.attributes.id);
                visibilityChanged = true;
                view.setVisibility(4);
                state.targetVisibility = 0;
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(resolvedWidth, resolvedHeight, resolvedGravity);
                if (seascape) {
                    lp.leftMargin = sideMargin;
                } else {
                    lp.rightMargin = sideMargin;
                }
                this.addView(view, lp);
                this.updateColorViewTranslations();
            }
        } else {
            int leftMargin;
            int vis = showView ? 0 : 4;
            visibilityChanged = state.targetVisibility != vis;
            state.targetVisibility = vis;
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
            int rightMargin = seascape ? 0 : sideMargin;
            int n3 = leftMargin = seascape ? sideMargin : 0;
            if (lp.height != resolvedHeight || lp.width != resolvedWidth || lp.gravity != resolvedGravity || lp.rightMargin != rightMargin || lp.leftMargin != leftMargin) {
                lp.height = resolvedHeight;
                lp.width = resolvedWidth;
                lp.gravity = resolvedGravity;
                lp.rightMargin = rightMargin;
                lp.leftMargin = leftMargin;
                view.setLayoutParams(lp);
            }
            if (showView) {
                view.setBackgroundColor(color2);
            }
        }
        if (visibilityChanged) {
            view.animate().cancel();
            if (animate && !this.isResizing()) {
                if (showView) {
                    if (view.getVisibility() != 0) {
                        view.setVisibility(0);
                        view.setAlpha(0.0f);
                    }
                    view.animate().alpha(1.0f).setInterpolator(this.mShowInterpolator).setDuration(this.mBarEnterExitDuration);
                } else {
                    view.animate().alpha(0.0f).setInterpolator(this.mHideInterpolator).setDuration(this.mBarEnterExitDuration).withEndAction(new Runnable(this, state){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ ColorViewState val$state;
                        /* synthetic */ DecorView this$0;

                        private void $$robo$$com_android_internal_policy_DecorView_2$__constructor__(DecorView this$0, ColorViewState colorViewState) {
                            this.val$state = colorViewState;
                        }

                        private final void $$robo$$com_android_internal_policy_DecorView_2$run() {
                            this.val$state.view.setAlpha(1.0f);
                            this.val$state.view.setVisibility(4);
                        }

                        private void __constructor__(DecorView decorView, ColorViewState colorViewState) {
                            this.$$robo$$com_android_internal_policy_DecorView_2$__constructor__(decorView, colorViewState);
                        }
                        {
                            this.this$0 = decorView;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_2$__constructor__(com.android.internal.policy.DecorView com.android.internal.policy.DecorView$ColorViewState ), this, decorView, colorViewState);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_DecorView_2$run(), this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }
            } else {
                view.setAlpha(1.0f);
                view.setVisibility(showView ? 0 : 4);
            }
        }
        state.visible = show;
        state.color = color2;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$updateColorViewTranslations() {
        int rootScrollY = this.mRootScrollY;
        if (this.mStatusColorViewState.view != null) {
            this.mStatusColorViewState.view.setTranslationY(rootScrollY > 0 ? (float)rootScrollY : 0.0f);
        }
        if (this.mNavigationColorViewState.view != null) {
            this.mNavigationColorViewState.view.setTranslationY(rootScrollY < 0 ? (float)rootScrollY : 0.0f);
        }
    }

    private final WindowInsets $$robo$$com_android_internal_policy_DecorView$updateStatusGuard(WindowInsets insets) {
        boolean showStatusGuard = false;
        if (this.mPrimaryActionModeView != null && this.mPrimaryActionModeView.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.mPrimaryActionModeView.getLayoutParams();
            boolean mlpChanged = false;
            if (this.mPrimaryActionModeView.isShown()) {
                int newMargin;
                if (this.mTempRect == null) {
                    this.mTempRect = new Rect();
                }
                Rect rect = this.mTempRect;
                this.mWindow.mContentParent.computeSystemWindowInsets(insets, rect);
                int n = newMargin = rect.top == 0 ? insets.getSystemWindowInsetTop() : 0;
                if (mlp.topMargin != newMargin) {
                    mlpChanged = true;
                    mlp.topMargin = insets.getSystemWindowInsetTop();
                    if (this.mStatusGuard == null) {
                        this.mStatusGuard = new View(this.mContext);
                        this.mStatusGuard.setBackgroundColor(this.mContext.getColor(17170595));
                        this.addView(this.mStatusGuard, this.indexOfChild(this.mStatusColorViewState.view), new FrameLayout.LayoutParams(-1, mlp.topMargin, 0x800033));
                    } else {
                        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mStatusGuard.getLayoutParams();
                        if (lp.height != mlp.topMargin) {
                            lp.height = mlp.topMargin;
                            this.mStatusGuard.setLayoutParams(lp);
                        }
                    }
                }
                showStatusGuard = this.mStatusGuard != null;
                boolean nonOverlay = (this.mWindow.getLocalFeaturesPrivate() & 0x400) == 0;
                insets = insets.consumeSystemWindowInsets(false, nonOverlay && showStatusGuard, false, false);
            } else if (mlp.topMargin != 0) {
                mlpChanged = true;
                mlp.topMargin = 0;
            }
            if (mlpChanged) {
                this.mPrimaryActionModeView.setLayoutParams(mlp);
            }
        }
        if (this.mStatusGuard != null) {
            this.mStatusGuard.setVisibility(showStatusGuard ? 0 : 8);
        }
        return insets;
    }

    private final WindowInsets $$robo$$com_android_internal_policy_DecorView$updateNavigationGuard(WindowInsets insets) {
        if (this.mWindow.getAttributes().type == 2011 && (this.mWindow.getAttributes().flags & 0x2000000) == 0) {
            if (this.mWindow.mContentParent != null && this.mWindow.mContentParent.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)this.mWindow.mContentParent.getLayoutParams();
                mlp.bottomMargin = insets.getSystemWindowInsetBottom();
                this.mWindow.mContentParent.setLayoutParams(mlp);
            }
            if (this.mNavigationGuard == null) {
                this.mNavigationGuard = new View(this.mContext);
                this.mNavigationGuard.setBackgroundColor(this.mContext.getColor(17170595));
                this.addView(this.mNavigationGuard, this.indexOfChild(this.mNavigationColorViewState.view), new FrameLayout.LayoutParams(-1, insets.getSystemWindowInsetBottom(), 8388691));
            } else {
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mNavigationGuard.getLayoutParams();
                lp.height = insets.getSystemWindowInsetBottom();
                this.mNavigationGuard.setLayoutParams(lp);
            }
            this.updateNavigationGuardColor();
            insets = insets.consumeSystemWindowInsets(false, false, false, true);
        }
        return insets;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$updateNavigationGuardColor() {
        if (this.mNavigationGuard != null) {
            this.mNavigationGuard.setVisibility(this.mWindow.getNavigationBarColor() == 0 ? 4 : 0);
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$updatePictureInPictureOutlineProvider(boolean isInPictureInPictureMode) {
        if (this.mIsInPictureInPictureMode == isInPictureInPictureMode) {
            return;
        }
        if (isInPictureInPictureMode) {
            Window.WindowControllerCallback callback = this.mWindow.getWindowControllerCallback();
            if (callback != null && callback.isTaskRoot()) {
                super.setOutlineProvider(PIP_OUTLINE_PROVIDER);
            }
        } else if (this.getOutlineProvider() != this.mLastOutlineProvider) {
            this.setOutlineProvider(this.mLastOutlineProvider);
        }
        this.mIsInPictureInPictureMode = isInPictureInPictureMode;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setOutlineProvider(ViewOutlineProvider provider) {
        super.setOutlineProvider(provider);
        this.mLastOutlineProvider = provider;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$drawableChanged() {
        if (this.mChanging) {
            return;
        }
        this.setPadding(this.mFramePadding.left + this.mBackgroundPadding.left, this.mFramePadding.top + this.mBackgroundPadding.top, this.mFramePadding.right + this.mBackgroundPadding.right, this.mFramePadding.bottom + this.mBackgroundPadding.bottom);
        this.requestLayout();
        this.invalidate();
        int opacity = -1;
        if (ActivityManager.StackId.hasWindowShadow(this.mStackId)) {
            opacity = -3;
        } else {
            Drawable bg = this.getBackground();
            Drawable fg = this.getForeground();
            if (bg != null) {
                if (fg == null) {
                    opacity = bg.getOpacity();
                } else if (this.mFramePadding.left <= 0 && this.mFramePadding.top <= 0 && this.mFramePadding.right <= 0 && this.mFramePadding.bottom <= 0) {
                    int fop = fg.getOpacity();
                    int bop = bg.getOpacity();
                    opacity = fop == -1 || bop == -1 ? -1 : (fop == 0 ? bop : (bop == 0 ? fop : Drawable.resolveOpacity(fop, bop)));
                } else {
                    opacity = -3;
                }
            }
        }
        this.mDefaultOpacity = opacity;
        if (this.mFeatureId < 0) {
            this.mWindow.setDefaultWindowFormat(opacity);
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onWindowFocusChanged(boolean hasWindowFocus) {
        Window.Callback cb;
        super.onWindowFocusChanged(hasWindowFocus);
        if (this.mWindow.hasFeature(0) && !hasWindowFocus && this.mWindow.mPanelChordingKey != 0) {
            this.mWindow.closePanel(0);
        }
        if ((cb = this.mWindow.getCallback()) != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0) {
            cb.onWindowFocusChanged(hasWindowFocus);
        }
        if (this.mPrimaryActionMode != null) {
            this.mPrimaryActionMode.onWindowFocusChanged(hasWindowFocus);
        }
        if (this.mFloatingActionMode != null) {
            this.mFloatingActionMode.onWindowFocusChanged(hasWindowFocus);
        }
        this.updateElevation();
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onAttachedToWindow() {
        super.onAttachedToWindow();
        Window.Callback cb = this.mWindow.getCallback();
        if (cb != null && !this.mWindow.isDestroyed() && this.mFeatureId < 0) {
            cb.onAttachedToWindow();
        }
        if (this.mFeatureId == -1) {
            this.mWindow.openPanelsAfterRestore();
        }
        if (!this.mWindowResizeCallbacksAdded) {
            this.getViewRootImpl().addWindowCallbacks(this);
            this.mWindowResizeCallbacksAdded = true;
        } else if (this.mBackdropFrameRenderer != null) {
            this.mBackdropFrameRenderer.onConfigurationChange();
        }
        this.mWindow.onViewRootImplSet(this.getViewRootImpl());
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onDetachedFromWindow() {
        PhoneWindow.PanelFeatureState st;
        super.onDetachedFromWindow();
        Window.Callback cb = this.mWindow.getCallback();
        if (cb != null && this.mFeatureId < 0) {
            cb.onDetachedFromWindow();
        }
        if (this.mWindow.mDecorContentParent != null) {
            this.mWindow.mDecorContentParent.dismissPopups();
        }
        if (this.mPrimaryActionModePopup != null) {
            this.removeCallbacks(this.mShowPrimaryActionModePopup);
            if (this.mPrimaryActionModePopup.isShowing()) {
                this.mPrimaryActionModePopup.dismiss();
            }
            this.mPrimaryActionModePopup = null;
        }
        if (this.mFloatingToolbar != null) {
            this.mFloatingToolbar.dismiss();
            this.mFloatingToolbar = null;
        }
        if ((st = this.mWindow.getPanelState(0, false)) != null && st.menu != null && this.mFeatureId < 0) {
            st.menu.close();
        }
        this.releaseThreadedRenderer();
        if (this.mWindowResizeCallbacksAdded) {
            this.getViewRootImpl().removeWindowCallbacks(this);
            this.mWindowResizeCallbacksAdded = false;
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onCloseSystemDialogs(String reason) {
        if (this.mFeatureId >= 0) {
            this.mWindow.closeAllPanels();
        }
    }

    private final SurfaceHolder.Callback2 $$robo$$com_android_internal_policy_DecorView$willYouTakeTheSurface() {
        return this.mFeatureId < 0 ? this.mWindow.mTakeSurfaceCallback : null;
    }

    private final InputQueue.Callback $$robo$$com_android_internal_policy_DecorView$willYouTakeTheInputQueue() {
        return this.mFeatureId < 0 ? this.mWindow.mTakeInputQueueCallback : null;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setSurfaceType(int type) {
        this.mWindow.setType(type);
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setSurfaceFormat(int format) {
        this.mWindow.setFormat(format);
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setSurfaceKeepScreenOn(boolean keepOn) {
        if (keepOn) {
            this.mWindow.addFlags(128);
        } else {
            this.mWindow.clearFlags(128);
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onRootViewScrollYChanged(int rootScrollY) {
        this.mRootScrollY = rootScrollY;
        this.updateColorViewTranslations();
    }

    private final ActionMode $$robo$$com_android_internal_policy_DecorView$createActionMode(int type, ActionMode.Callback2 callback, View originatingView) {
        switch (type) {
            default: {
                return this.createStandaloneActionMode(callback);
            }
            case 1: 
        }
        return this.createFloatingActionMode(originatingView, callback);
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setHandledActionMode(ActionMode mode) {
        if (mode.getType() == 0) {
            this.setHandledPrimaryActionMode(mode);
        } else if (mode.getType() == 1) {
            this.setHandledFloatingActionMode(mode);
        }
    }

    private final ActionMode $$robo$$com_android_internal_policy_DecorView$createStandaloneActionMode(ActionMode.Callback callback) {
        this.endOnGoingFadeAnimation();
        this.cleanupPrimaryActionMode();
        if (this.mPrimaryActionModeView == null || !this.mPrimaryActionModeView.isAttachedToWindow()) {
            if (this.mWindow.isFloating()) {
                Context actionBarContext;
                TypedValue outValue = new TypedValue();
                Resources.Theme baseTheme = this.mContext.getTheme();
                baseTheme.resolveAttribute(16843825, outValue, true);
                if (outValue.resourceId != 0) {
                    Resources.Theme actionBarTheme = this.mContext.getResources().newTheme();
                    actionBarTheme.setTo(baseTheme);
                    actionBarTheme.applyStyle(outValue.resourceId, true);
                    actionBarContext = new ContextThemeWrapper(this.mContext, 0);
                    actionBarContext.getTheme().setTo(actionBarTheme);
                } else {
                    actionBarContext = this.mContext;
                }
                this.mPrimaryActionModeView = new ActionBarContextView(actionBarContext);
                this.mPrimaryActionModePopup = new PopupWindow(actionBarContext, null, 0x1110005);
                this.mPrimaryActionModePopup.setWindowLayoutType(2);
                this.mPrimaryActionModePopup.setContentView(this.mPrimaryActionModeView);
                this.mPrimaryActionModePopup.setWidth(-1);
                actionBarContext.getTheme().resolveAttribute(16843499, outValue, true);
                int height = TypedValue.complexToDimensionPixelSize(outValue.data, actionBarContext.getResources().getDisplayMetrics());
                this.mPrimaryActionModeView.setContentHeight(height);
                this.mPrimaryActionModePopup.setHeight(-2);
                this.mShowPrimaryActionModePopup = new Runnable(this){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ DecorView this$0;

                    private void $$robo$$com_android_internal_policy_DecorView_3$__constructor__(DecorView this$0) {
                    }

                    private final void $$robo$$com_android_internal_policy_DecorView_3$run() {
                        this.this$0.mPrimaryActionModePopup.showAtLocation(this.this$0.mPrimaryActionModeView.getApplicationWindowToken(), 55, 0, 0);
                        this.this$0.endOnGoingFadeAnimation();
                        if (this.this$0.shouldAnimatePrimaryActionModeView()) {
                            this.this$0.mFadeAnim = ObjectAnimator.ofFloat(this.this$0.mPrimaryActionModeView, View.ALPHA, 0.0f, 1.0f);
                            this.this$0.mFadeAnim.addListener((Animator.AnimatorListener)new ShadowedObject(this){
                                public /* synthetic */ Object __robo_data__;
                                /* synthetic */ 3 this$1;

                                private void $$robo$$com_android_internal_policy_DecorView_3_1$__constructor__(3 this$1) {
                                    this.this$1 = this$1;
                                }

                                private final void $$robo$$com_android_internal_policy_DecorView_3_1$onAnimationStart(Animator animation) {
                                    this.this$1.this$0.mPrimaryActionModeView.setVisibility(0);
                                }

                                private final void $$robo$$com_android_internal_policy_DecorView_3_1$onAnimationEnd(Animator animation) {
                                    this.this$1.this$0.mPrimaryActionModeView.setAlpha(1.0f);
                                    this.this$1.this$0.mFadeAnim = null;
                                }

                                private void __constructor__(3 var1_1) {
                                    this.$$robo$$com_android_internal_policy_DecorView_3_1$__constructor__(var1_1);
                                }
                                {
                                    this.$$robo$init();
                                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_3_1$__constructor__(com.android.internal.policy.DecorView$3 ), this, var1_1);
                                }

                                @Override
                                public void onAnimationStart(Animator animator2) {
                                    InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_policy_DecorView_3_1$onAnimationStart(android.animation.Animator ), this, animator2);
                                }

                                @Override
                                public void onAnimationEnd(Animator animator2) {
                                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_policy_DecorView_3_1$onAnimationEnd(android.animation.Animator ), this, animator2);
                                }
                                {
                                    this.$$robo$init();
                                }

                                @Override
                                protected /* synthetic */ void $$robo$init() {
                                    if (this.__robo_data__ == null) {
                                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                    }
                                }

                                @Override
                                public /* synthetic */ Object $$robo$getData() {
                                    return this.__robo_data__;
                                }
                            });
                            this.this$0.mFadeAnim.start();
                        } else {
                            this.this$0.mPrimaryActionModeView.setAlpha(1.0f);
                            this.this$0.mPrimaryActionModeView.setVisibility(0);
                        }
                    }

                    private void __constructor__(DecorView decorView) {
                        this.$$robo$$com_android_internal_policy_DecorView_3$__constructor__(decorView);
                    }
                    {
                        this.this$0 = decorView;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_3$__constructor__(com.android.internal.policy.DecorView ), this, decorView);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_DecorView_3$run(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            } else {
                ViewStub stub = (ViewStub)this.findViewById(16908678);
                if (stub != null) {
                    this.mPrimaryActionModeView = (ActionBarContextView)stub.inflate();
                    this.mPrimaryActionModePopup = null;
                }
            }
        }
        if (this.mPrimaryActionModeView != null) {
            this.mPrimaryActionModeView.killMode();
            StandaloneActionMode mode = new StandaloneActionMode(this.mPrimaryActionModeView.getContext(), this.mPrimaryActionModeView, callback, this.mPrimaryActionModePopup == null);
            return mode;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$endOnGoingFadeAnimation() {
        if (this.mFadeAnim != null) {
            this.mFadeAnim.end();
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setHandledPrimaryActionMode(ActionMode mode) {
        this.endOnGoingFadeAnimation();
        this.mPrimaryActionMode = mode;
        this.mPrimaryActionMode.invalidate();
        this.mPrimaryActionModeView.initForMode(this.mPrimaryActionMode);
        if (this.mPrimaryActionModePopup != null) {
            this.post(this.mShowPrimaryActionModePopup);
        } else if (this.shouldAnimatePrimaryActionModeView()) {
            this.mFadeAnim = ObjectAnimator.ofFloat(this.mPrimaryActionModeView, View.ALPHA, 0.0f, 1.0f);
            this.mFadeAnim.addListener((Animator.AnimatorListener)new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ DecorView this$0;

                private void $$robo$$com_android_internal_policy_DecorView_4$__constructor__(DecorView this$0) {
                }

                private final void $$robo$$com_android_internal_policy_DecorView_4$onAnimationStart(Animator animation) {
                    this.this$0.mPrimaryActionModeView.setVisibility(0);
                }

                private final void $$robo$$com_android_internal_policy_DecorView_4$onAnimationEnd(Animator animation) {
                    this.this$0.mPrimaryActionModeView.setAlpha(1.0f);
                    this.this$0.mFadeAnim = null;
                }

                private void __constructor__(DecorView decorView) {
                    this.$$robo$$com_android_internal_policy_DecorView_4$__constructor__(decorView);
                }
                {
                    this.this$0 = decorView;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_4$__constructor__(com.android.internal.policy.DecorView ), this, decorView);
                }

                @Override
                public void onAnimationStart(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_policy_DecorView_4$onAnimationStart(android.animation.Animator ), this, animator2);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_policy_DecorView_4$onAnimationEnd(android.animation.Animator ), this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mFadeAnim.start();
        } else {
            this.mPrimaryActionModeView.setAlpha(1.0f);
            this.mPrimaryActionModeView.setVisibility(0);
        }
        this.mPrimaryActionModeView.sendAccessibilityEvent(32);
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$shouldAnimatePrimaryActionModeView() {
        return this.isLaidOut();
    }

    private final ActionMode $$robo$$com_android_internal_policy_DecorView$createFloatingActionMode(View originatingView, ActionMode.Callback2 callback) {
        if (this.mFloatingActionMode != null) {
            this.mFloatingActionMode.finish();
        }
        this.cleanupFloatingActionModeViews();
        this.mFloatingToolbar = new FloatingToolbar(this.mContext, this.mWindow);
        FloatingActionMode mode = new FloatingActionMode(this.mContext, callback, originatingView, this.mFloatingToolbar);
        this.mFloatingActionModeOriginatingView = originatingView;
        this.mFloatingToolbarPreDrawListener = new ViewTreeObserver.OnPreDrawListener(this, mode){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ FloatingActionMode val$mode;
            /* synthetic */ DecorView this$0;

            private void $$robo$$com_android_internal_policy_DecorView_5$__constructor__(DecorView this$0, FloatingActionMode floatingActionMode) {
                this.val$mode = floatingActionMode;
            }

            private final boolean $$robo$$com_android_internal_policy_DecorView_5$onPreDraw() {
                this.val$mode.updateViewLocationInWindow();
                return true;
            }

            private void __constructor__(DecorView decorView, FloatingActionMode floatingActionMode) {
                this.$$robo$$com_android_internal_policy_DecorView_5$__constructor__(decorView, floatingActionMode);
            }
            {
                this.this$0 = decorView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_5$__constructor__(com.android.internal.policy.DecorView com.android.internal.view.FloatingActionMode ), this, decorView, floatingActionMode);
            }

            @Override
            public boolean onPreDraw() {
                return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$com_android_internal_policy_DecorView_5$onPreDraw(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        return mode;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setHandledFloatingActionMode(ActionMode mode) {
        this.mFloatingActionMode = mode;
        this.mFloatingActionMode.invalidate();
        this.mFloatingActionModeOriginatingView.getViewTreeObserver().addOnPreDrawListener(this.mFloatingToolbarPreDrawListener);
    }

    private final void $$robo$$com_android_internal_policy_DecorView$enableCaption(boolean attachedAndVisible) {
        if (this.mHasCaption != attachedAndVisible) {
            this.mHasCaption = attachedAndVisible;
            if (this.getForeground() != null) {
                this.drawableChanged();
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setWindow(PhoneWindow phoneWindow) {
        this.mWindow = phoneWindow;
        Context context = this.getContext();
        if (context instanceof DecorContext) {
            DecorContext decorContext = (DecorContext)context;
            decorContext.setPhoneWindow(this.mWindow);
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        int workspaceId = this.getStackId();
        if (this.mStackId != workspaceId) {
            this.mStackId = workspaceId;
            if (this.mDecorCaptionView == null && ActivityManager.StackId.hasWindowDecor(this.mStackId)) {
                LayoutInflater inflater = this.mWindow.getLayoutInflater();
                this.mDecorCaptionView = this.createDecorCaptionView(inflater);
                if (this.mDecorCaptionView != null) {
                    if (this.mDecorCaptionView.getParent() == null) {
                        this.addView((View)this.mDecorCaptionView, 0, new ViewGroup.LayoutParams(-1, -1));
                    }
                    this.removeView(this.mContentRoot);
                    this.mDecorCaptionView.addView((View)this.mContentRoot, new ViewGroup.MarginLayoutParams(-1, -1));
                }
            } else if (this.mDecorCaptionView != null) {
                this.mDecorCaptionView.onConfigurationChanged(ActivityManager.StackId.hasWindowDecor(this.mStackId));
                this.enableCaption(ActivityManager.StackId.hasWindowDecor(workspaceId));
            }
        }
        this.updateAvailableWidth();
        this.initializeElevation();
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onResourcesLoaded(LayoutInflater inflater, int layoutResource) {
        this.mStackId = this.getStackId();
        if (this.mBackdropFrameRenderer != null) {
            this.loadBackgroundDrawablesIfNeeded();
            this.mBackdropFrameRenderer.onResourcesLoaded(this, this.mResizingBackgroundDrawable, this.mCaptionBackgroundDrawable, this.mUserCaptionBackgroundDrawable, this.getCurrentColor(this.mStatusColorViewState), this.getCurrentColor(this.mNavigationColorViewState));
        }
        this.mDecorCaptionView = this.createDecorCaptionView(inflater);
        View root = inflater.inflate(layoutResource, null);
        if (this.mDecorCaptionView != null) {
            if (this.mDecorCaptionView.getParent() == null) {
                this.addView((View)this.mDecorCaptionView, new ViewGroup.LayoutParams(-1, -1));
            }
            this.mDecorCaptionView.addView(root, new ViewGroup.MarginLayoutParams(-1, -1));
        } else {
            this.addView(root, 0, new ViewGroup.LayoutParams(-1, -1));
        }
        this.mContentRoot = (ViewGroup)root;
        this.initializeElevation();
    }

    private final void $$robo$$com_android_internal_policy_DecorView$loadBackgroundDrawablesIfNeeded() {
        if (this.mResizingBackgroundDrawable == null) {
            this.mResizingBackgroundDrawable = DecorView.getResizingBackgroundDrawable(this.getContext(), this.mWindow.mBackgroundResource, this.mWindow.mBackgroundFallbackResource, this.mWindow.isTranslucent() || this.mWindow.isShowingWallpaper());
            if (this.mResizingBackgroundDrawable == null) {
                Log.w(this.mLogTag, "Failed to find background drawable for PhoneWindow=" + this.mWindow);
            }
        }
        if (this.mCaptionBackgroundDrawable == null) {
            this.mCaptionBackgroundDrawable = this.getContext().getDrawable(17302108);
        }
        if (this.mResizingBackgroundDrawable != null) {
            this.mLastBackgroundDrawableCb = this.mResizingBackgroundDrawable.getCallback();
            this.mResizingBackgroundDrawable.setCallback(null);
        }
    }

    private final DecorCaptionView $$robo$$com_android_internal_policy_DecorView$createDecorCaptionView(LayoutInflater inflater) {
        boolean isApplication;
        DecorCaptionView decorCaptionView = null;
        for (int i = this.getChildCount() - 1; i >= 0 && decorCaptionView == null; --i) {
            View view = this.getChildAt(i);
            if (!(view instanceof DecorCaptionView)) continue;
            decorCaptionView = (DecorCaptionView)view;
            this.removeViewAt(i);
        }
        WindowManager.LayoutParams attrs = this.mWindow.getAttributes();
        boolean bl = isApplication = attrs.type == 1 || attrs.type == 2 || attrs.type == 4;
        if (!this.mWindow.isFloating() && isApplication && ActivityManager.StackId.hasWindowDecor(this.mStackId)) {
            if (decorCaptionView == null) {
                decorCaptionView = this.inflateDecorCaptionView(inflater);
            }
            decorCaptionView.setPhoneWindow(this.mWindow, true);
        } else {
            decorCaptionView = null;
        }
        this.enableCaption(decorCaptionView != null);
        return decorCaptionView;
    }

    private final DecorCaptionView $$robo$$com_android_internal_policy_DecorView$inflateDecorCaptionView(LayoutInflater inflater) {
        Context context = this.getContext();
        inflater = LayoutInflater.from(context);
        DecorCaptionView view = (DecorCaptionView)inflater.inflate(17367122, null);
        this.setDecorCaptionShade(context, view);
        return view;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setDecorCaptionShade(Context context, DecorCaptionView view) {
        int shade = this.mWindow.getDecorCaptionShade();
        switch (shade) {
            case 1: {
                this.setLightDecorCaptionShade(view);
                break;
            }
            case 2: {
                this.setDarkDecorCaptionShade(view);
                break;
            }
            default: {
                TypedValue value = new TypedValue();
                context.getTheme().resolveAttribute(16843827, value, true);
                if ((double)Color.luminance(value.data) < 0.5) {
                    this.setLightDecorCaptionShade(view);
                    break;
                }
                this.setDarkDecorCaptionShade(view);
                break;
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$updateDecorCaptionShade() {
        if (this.mDecorCaptionView != null) {
            this.setDecorCaptionShade(this.getContext(), this.mDecorCaptionView);
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setLightDecorCaptionShade(DecorCaptionView view) {
        ((View)view.findViewById(16909031)).setBackgroundResource(17302113);
        ((View)view.findViewById(16908791)).setBackgroundResource(17302111);
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setDarkDecorCaptionShade(DecorCaptionView view) {
        ((View)view.findViewById(16909031)).setBackgroundResource(17302112);
        ((View)view.findViewById(16908791)).setBackgroundResource(17302110);
    }

    private static final Drawable $$robo$$com_android_internal_policy_DecorView$getResizingBackgroundDrawable(Context context, int backgroundRes, int backgroundFallbackRes, boolean windowTranslucent) {
        Drawable fallbackDrawable;
        Drawable drawable2;
        if (backgroundRes != 0 && (drawable2 = context.getDrawable(backgroundRes)) != null) {
            return DecorView.enforceNonTranslucentBackground(drawable2, windowTranslucent);
        }
        if (backgroundFallbackRes != 0 && (fallbackDrawable = context.getDrawable(backgroundFallbackRes)) != null) {
            return DecorView.enforceNonTranslucentBackground(fallbackDrawable, windowTranslucent);
        }
        return new ColorDrawable(-16777216);
    }

    private static final Drawable $$robo$$com_android_internal_policy_DecorView$enforceNonTranslucentBackground(Drawable drawable2, boolean windowTranslucent) {
        ColorDrawable colorDrawable;
        int color2;
        if (!windowTranslucent && drawable2 instanceof ColorDrawable && Color.alpha(color2 = (colorDrawable = (ColorDrawable)drawable2).getColor()) != 255) {
            ColorDrawable copy = (ColorDrawable)colorDrawable.getConstantState().newDrawable().mutate();
            copy.setColor(Color.argb(255, Color.red(color2), Color.green(color2), Color.blue(color2)));
            return copy;
        }
        return drawable2;
    }

    private final int $$robo$$com_android_internal_policy_DecorView$getStackId() {
        int workspaceId = -1;
        Window.WindowControllerCallback callback = this.mWindow.getWindowControllerCallback();
        if (callback != null) {
            try {
                workspaceId = callback.getWindowStackId();
            }
            catch (RemoteException ex) {
                Log.e(this.mLogTag, "Failed to get the workspace ID of a PhoneWindow.");
            }
        }
        if (workspaceId == -1) {
            return 1;
        }
        return workspaceId;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$clearContentView() {
        if (this.mDecorCaptionView != null) {
            this.mDecorCaptionView.removeContentView();
        } else {
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                View v = this.getChildAt(i);
                if (v == this.mStatusColorViewState.view || v == this.mNavigationColorViewState.view || v == this.mStatusGuard || v == this.mNavigationGuard) continue;
                this.removeViewAt(i);
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onWindowSizeIsChanging(Rect newBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
        if (this.mBackdropFrameRenderer != null) {
            this.mBackdropFrameRenderer.setTargetRect(newBounds, fullscreen, systemInsets, stableInsets);
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onWindowDragResizeStart(Rect initialBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets, int resizeMode) {
        if (this.mWindow.isDestroyed()) {
            this.releaseThreadedRenderer();
            return;
        }
        if (this.mBackdropFrameRenderer != null) {
            return;
        }
        ThreadedRenderer renderer = this.getThreadedRenderer();
        if (renderer != null) {
            this.loadBackgroundDrawablesIfNeeded();
            this.mBackdropFrameRenderer = new BackdropFrameRenderer(this, renderer, initialBounds, this.mResizingBackgroundDrawable, this.mCaptionBackgroundDrawable, this.mUserCaptionBackgroundDrawable, this.getCurrentColor(this.mStatusColorViewState), this.getCurrentColor(this.mNavigationColorViewState), fullscreen, systemInsets, stableInsets, resizeMode);
            this.updateElevation();
            this.updateColorViews(null, false);
        }
        this.mResizeMode = resizeMode;
        this.getViewRootImpl().requestInvalidateRootRenderNode();
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onWindowDragResizeEnd() {
        this.releaseThreadedRenderer();
        this.updateColorViews(null, false);
        this.mResizeMode = -1;
        this.getViewRootImpl().requestInvalidateRootRenderNode();
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$onContentDrawn(int offsetX, int offsetY, int sizeX, int sizeY) {
        if (this.mBackdropFrameRenderer == null) {
            return false;
        }
        return this.mBackdropFrameRenderer.onContentDrawn(offsetX, offsetY, sizeX, sizeY);
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onRequestDraw(boolean reportNextDraw) {
        if (this.mBackdropFrameRenderer != null) {
            this.mBackdropFrameRenderer.onRequestDraw(reportNextDraw);
        } else if (reportNextDraw && this.isAttachedToWindow()) {
            this.getViewRootImpl().reportDrawFinish();
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$onPostDraw(DisplayListCanvas canvas) {
        this.drawResizingShadowIfNeeded(canvas);
    }

    private final void $$robo$$com_android_internal_policy_DecorView$initResizingPaints() {
        int startColor = this.mContext.getResources().getColor(17170720, null);
        int endColor = this.mContext.getResources().getColor(17170719, null);
        int middleColor = (startColor + endColor) / 2;
        this.mHorizontalResizeShadowPaint.setShader(new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.mResizeShadowSize, new int[]{startColor, middleColor, endColor}, new float[]{0.0f, 0.3f, 1.0f}, Shader.TileMode.CLAMP));
        this.mVerticalResizeShadowPaint.setShader(new LinearGradient(0.0f, 0.0f, (float)this.mResizeShadowSize, 0.0f, new int[]{startColor, middleColor, endColor}, new float[]{0.0f, 0.3f, 1.0f}, Shader.TileMode.CLAMP));
    }

    private final void $$robo$$com_android_internal_policy_DecorView$drawResizingShadowIfNeeded(DisplayListCanvas canvas) {
        if (this.mResizeMode != 1 || this.mWindow.mIsFloating || this.mWindow.isTranslucent() || this.mWindow.isShowingWallpaper()) {
            return;
        }
        canvas.save();
        canvas.translate(0.0f, this.getHeight() - this.mFrameOffsets.bottom);
        canvas.drawRect(0.0f, 0.0f, this.getWidth(), this.mResizeShadowSize, this.mHorizontalResizeShadowPaint);
        canvas.restore();
        canvas.save();
        canvas.translate(this.getWidth() - this.mFrameOffsets.right, 0.0f);
        canvas.drawRect(0.0f, 0.0f, this.mResizeShadowSize, this.getHeight(), this.mVerticalResizeShadowPaint);
        canvas.restore();
    }

    private final void $$robo$$com_android_internal_policy_DecorView$releaseThreadedRenderer() {
        if (this.mResizingBackgroundDrawable != null && this.mLastBackgroundDrawableCb != null) {
            this.mResizingBackgroundDrawable.setCallback(this.mLastBackgroundDrawableCb);
            this.mLastBackgroundDrawableCb = null;
        }
        if (this.mBackdropFrameRenderer != null) {
            this.mBackdropFrameRenderer.releaseRenderer();
            this.mBackdropFrameRenderer = null;
            this.updateElevation();
        }
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$isResizing() {
        return this.mBackdropFrameRenderer != null;
    }

    private final void $$robo$$com_android_internal_policy_DecorView$initializeElevation() {
        this.mAllowUpdateElevation = false;
        this.updateElevation();
    }

    private final void $$robo$$com_android_internal_policy_DecorView$updateElevation() {
        float elevation = 0.0f;
        boolean wasAdjustedForStack = this.mElevationAdjustedForStack;
        if (this.mStackId == 2 && !this.isResizing()) {
            float f = elevation = this.hasWindowFocus() ? 20.0f : 5.0f;
            if (!this.mAllowUpdateElevation) {
                elevation = 20.0f;
            }
            elevation = this.dipToPx(elevation);
            this.mElevationAdjustedForStack = true;
        } else if (this.mStackId == 4) {
            elevation = this.dipToPx(5.0f);
            this.mElevationAdjustedForStack = true;
        } else {
            this.mElevationAdjustedForStack = false;
        }
        if ((wasAdjustedForStack || this.mElevationAdjustedForStack) && this.getElevation() != elevation) {
            this.mWindow.setElevation(elevation);
        }
    }

    private final boolean $$robo$$com_android_internal_policy_DecorView$isShowingCaption() {
        return this.mDecorCaptionView != null && this.mDecorCaptionView.isCaptionShowing();
    }

    private final int $$robo$$com_android_internal_policy_DecorView$getCaptionHeight() {
        return this.isShowingCaption() ? this.mDecorCaptionView.getCaptionHeight() : 0;
    }

    private final float $$robo$$com_android_internal_policy_DecorView$dipToPx(float dip) {
        return TypedValue.applyDimension(1, dip, this.getResources().getDisplayMetrics());
    }

    private final void $$robo$$com_android_internal_policy_DecorView$setUserCaptionBackgroundDrawable(Drawable drawable2) {
        this.mUserCaptionBackgroundDrawable = drawable2;
        if (this.mBackdropFrameRenderer != null) {
            this.mBackdropFrameRenderer.setUserCaptionBackgroundDrawable(drawable2);
        }
    }

    private static final String $$robo$$com_android_internal_policy_DecorView$getTitleSuffix(WindowManager.LayoutParams params) {
        if (params == null) {
            return "";
        }
        String[] split = params.getTitle().toString().split("\\.");
        if (split.length > 0) {
            return split[split.length - 1];
        }
        return "";
    }

    private final void $$robo$$com_android_internal_policy_DecorView$updateLogTag(WindowManager.LayoutParams params) {
        this.mLogTag = "DecorView[" + DecorView.getTitleSuffix(params) + "]";
    }

    private final void $$robo$$com_android_internal_policy_DecorView$updateAvailableWidth() {
        Resources res = this.getResources();
        this.mAvailableWidth = TypedValue.applyDimension(1, res.getConfiguration().screenWidthDp, res.getDisplayMetrics());
    }

    private final void $$robo$$com_android_internal_policy_DecorView$requestKeyboardShortcuts(List<KeyboardShortcutGroup> list, int deviceId) {
        MenuBuilder menu2;
        PhoneWindow.PanelFeatureState st = this.mWindow.getPanelState(0, false);
        MenuBuilder menuBuilder = menu2 = st != null ? st.menu : null;
        if (!this.mWindow.isDestroyed() && this.mWindow.getCallback() != null) {
            this.mWindow.getCallback().onProvideKeyboardShortcuts(list, menu2, deviceId);
        }
    }

    private final void $$robo$$com_android_internal_policy_DecorView$dispatchPointerCaptureChanged(boolean hasCapture) {
        super.dispatchPointerCaptureChanged(hasCapture);
        if (!this.mWindow.isDestroyed() && this.mWindow.getCallback() != null) {
            this.mWindow.getCallback().onPointerCaptureChanged(hasCapture);
        }
    }

    private final int $$robo$$com_android_internal_policy_DecorView$getAccessibilityViewId() {
        return 0x7FFFFFFE;
    }

    private final String $$robo$$com_android_internal_policy_DecorView$toString() {
        return "DecorView@" + Integer.toHexString(this.hashCode()) + "[" + DecorView.getTitleSuffix(this.mWindow.getAttributes()) + "]";
    }

    static void __staticInitializer__() {
        STATUS_BAR_COLOR_VIEW_ATTRIBUTES = new ColorViewAttributes(4, 0x4000000, 48, 3, 5, "android:status:background", 16908335, 1024, null);
        NAVIGATION_BAR_COLOR_VIEW_ATTRIBUTES = new ColorViewAttributes(2, 0x8000000, 80, 5, 3, "android:navigation:background", 16908336, 0, null);
        PIP_OUTLINE_PROVIDER = new ShadowedObject(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_policy_DecorView_1$__constructor__() {
            }

            private final void $$robo$$com_android_internal_policy_DecorView_1$getOutline(View view, Outline outline) {
                outline.setRect(0, 0, view.getWidth(), view.getHeight());
                outline.setAlpha(1.0f);
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_policy_DecorView_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_1$__constructor__(), this);
            }

            @Override
            public void getOutline(View view, Outline outline) {
                InvokeDynamicSupport.bootstrap("getOutline", $$robo$$com_android_internal_policy_DecorView_1$getOutline(android.view.View android.graphics.Outline ), this, view, outline);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Context context, int n, PhoneWindow phoneWindow, WindowManager.LayoutParams layoutParams) {
        this.$$robo$$com_android_internal_policy_DecorView$__constructor__(context, n, phoneWindow, layoutParams);
    }

    public DecorView(Context context, int n, PhoneWindow phoneWindow, WindowManager.LayoutParams layoutParams) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView$__constructor__(android.content.Context int com.android.internal.policy.PhoneWindow android.view.WindowManager$LayoutParams ), this, context, n, phoneWindow, layoutParams);
    }

    void setBackgroundFallback(int n) {
        InvokeDynamicSupport.bootstrap("setBackgroundFallback", $$robo$$com_android_internal_policy_DecorView$setBackgroundFallback(int ), this, n);
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        return (boolean)InvokeDynamicSupport.bootstrap("gatherTransparentRegion", $$robo$$com_android_internal_policy_DecorView$gatherTransparentRegion(android.graphics.Region ), this, region);
    }

    boolean gatherTransparentRegion(ColorViewState colorViewState, Region region) {
        return (boolean)InvokeDynamicSupport.bootstrap("gatherTransparentRegion", $$robo$$com_android_internal_policy_DecorView$gatherTransparentRegion(com.android.internal.policy.DecorView$ColorViewState android.graphics.Region ), this, colorViewState, region);
    }

    @Override
    public void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_policy_DecorView$onDraw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$com_android_internal_policy_DecorView$dispatchKeyEvent(android.view.KeyEvent ), this, keyEvent);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyShortcutEvent", $$robo$$com_android_internal_policy_DecorView$dispatchKeyShortcutEvent(android.view.KeyEvent ), this, keyEvent);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$com_android_internal_policy_DecorView$dispatchTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTrackballEvent", $$robo$$com_android_internal_policy_DecorView$dispatchTrackballEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchGenericMotionEvent", $$robo$$com_android_internal_policy_DecorView$dispatchGenericMotionEvent(android.view.MotionEvent ), this, motionEvent);
    }

    public boolean superDispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("superDispatchKeyEvent", $$robo$$com_android_internal_policy_DecorView$superDispatchKeyEvent(android.view.KeyEvent ), this, keyEvent);
    }

    public boolean superDispatchKeyShortcutEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("superDispatchKeyShortcutEvent", $$robo$$com_android_internal_policy_DecorView$superDispatchKeyShortcutEvent(android.view.KeyEvent ), this, keyEvent);
    }

    public boolean superDispatchTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("superDispatchTouchEvent", $$robo$$com_android_internal_policy_DecorView$superDispatchTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    public boolean superDispatchTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("superDispatchTrackballEvent", $$robo$$com_android_internal_policy_DecorView$superDispatchTrackballEvent(android.view.MotionEvent ), this, motionEvent);
    }

    public boolean superDispatchGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("superDispatchGenericMotionEvent", $$robo$$com_android_internal_policy_DecorView$superDispatchGenericMotionEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_policy_DecorView$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    private boolean isOutOfInnerBounds(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutOfInnerBounds", $$robo$$com_android_internal_policy_DecorView$isOutOfInnerBounds(int int ), this, n, n2);
    }

    private boolean isOutOfBounds(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutOfBounds", $$robo$$com_android_internal_policy_DecorView$isOutOfBounds(int int ), this, n, n2);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_policy_DecorView$onInterceptTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public void sendAccessibilityEvent(int n) {
        InvokeDynamicSupport.bootstrap("sendAccessibilityEvent", $$robo$$com_android_internal_policy_DecorView$sendAccessibilityEvent(int ), this, n);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEventInternal", $$robo$$com_android_internal_policy_DecorView$dispatchPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFrame", $$robo$$com_android_internal_policy_DecorView$setFrame(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_policy_DecorView$onMeasure(int int ), this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_policy_DecorView$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$com_android_internal_policy_DecorView$draw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    public boolean showContextMenuForChild(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenuForChild", $$robo$$com_android_internal_policy_DecorView$showContextMenuForChild(android.view.View ), this, view);
    }

    @Override
    public boolean showContextMenuForChild(View view, float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenuForChild", $$robo$$com_android_internal_policy_DecorView$showContextMenuForChild(android.view.View float float ), this, view, f, f2);
    }

    private boolean showContextMenuForChildInternal(View view, float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("showContextMenuForChildInternal", $$robo$$com_android_internal_policy_DecorView$showContextMenuForChildInternal(android.view.View float float ), this, view, f, f2);
    }

    @Override
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback) {
        return InvokeDynamicSupport.bootstrap("startActionModeForChild", $$robo$$com_android_internal_policy_DecorView$startActionModeForChild(android.view.View android.view.ActionMode$Callback ), this, view, callback);
    }

    @Override
    public ActionMode startActionModeForChild(View view, ActionMode.Callback callback, int n) {
        return InvokeDynamicSupport.bootstrap("startActionModeForChild", $$robo$$com_android_internal_policy_DecorView$startActionModeForChild(android.view.View android.view.ActionMode$Callback int ), this, view, callback, n);
    }

    @Override
    public ActionMode startActionMode(ActionMode.Callback callback) {
        return InvokeDynamicSupport.bootstrap("startActionMode", $$robo$$com_android_internal_policy_DecorView$startActionMode(android.view.ActionMode$Callback ), this, callback);
    }

    @Override
    public ActionMode startActionMode(ActionMode.Callback callback, int n) {
        return InvokeDynamicSupport.bootstrap("startActionMode", $$robo$$com_android_internal_policy_DecorView$startActionMode(android.view.ActionMode$Callback int ), this, callback, n);
    }

    private ActionMode startActionMode(View view, ActionMode.Callback callback, int n) {
        return InvokeDynamicSupport.bootstrap("startActionMode", $$robo$$com_android_internal_policy_DecorView$startActionMode(android.view.View android.view.ActionMode$Callback int ), this, view, callback, n);
    }

    private void cleanupPrimaryActionMode() {
        InvokeDynamicSupport.bootstrap("cleanupPrimaryActionMode", $$robo$$com_android_internal_policy_DecorView$cleanupPrimaryActionMode(), this);
    }

    private void cleanupFloatingActionModeViews() {
        InvokeDynamicSupport.bootstrap("cleanupFloatingActionModeViews", $$robo$$com_android_internal_policy_DecorView$cleanupFloatingActionModeViews(), this);
    }

    void startChanging() {
        InvokeDynamicSupport.bootstrap("startChanging", $$robo$$com_android_internal_policy_DecorView$startChanging(), this);
    }

    void finishChanging() {
        InvokeDynamicSupport.bootstrap("finishChanging", $$robo$$com_android_internal_policy_DecorView$finishChanging(), this);
    }

    public void setWindowBackground(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setWindowBackground", $$robo$$com_android_internal_policy_DecorView$setWindowBackground(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public void setWindowFrame(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setWindowFrame", $$robo$$com_android_internal_policy_DecorView$setWindowFrame(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    public void onWindowSystemUiVisibilityChanged(int n) {
        InvokeDynamicSupport.bootstrap("onWindowSystemUiVisibilityChanged", $$robo$$com_android_internal_policy_DecorView$onWindowSystemUiVisibilityChanged(int ), this, n);
    }

    @Override
    public WindowInsets onApplyWindowInsets(WindowInsets windowInsets) {
        return InvokeDynamicSupport.bootstrap("onApplyWindowInsets", $$robo$$com_android_internal_policy_DecorView$onApplyWindowInsets(android.view.WindowInsets ), this, windowInsets);
    }

    @Override
    public boolean isTransitionGroup() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransitionGroup", $$robo$$com_android_internal_policy_DecorView$isTransitionGroup(), this);
    }

    public static int getColorViewTopInset(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getColorViewTopInset", $$robo$$com_android_internal_policy_DecorView$getColorViewTopInset(int int ), (int)n, (int)n2);
    }

    public static int getColorViewBottomInset(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getColorViewBottomInset", $$robo$$com_android_internal_policy_DecorView$getColorViewBottomInset(int int ), (int)n, (int)n2);
    }

    public static int getColorViewRightInset(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getColorViewRightInset", $$robo$$com_android_internal_policy_DecorView$getColorViewRightInset(int int ), (int)n, (int)n2);
    }

    public static int getColorViewLeftInset(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getColorViewLeftInset", $$robo$$com_android_internal_policy_DecorView$getColorViewLeftInset(int int ), (int)n, (int)n2);
    }

    public static boolean isNavBarToRightEdge(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNavBarToRightEdge", $$robo$$com_android_internal_policy_DecorView$isNavBarToRightEdge(int int ), (int)n, (int)n2);
    }

    public static boolean isNavBarToLeftEdge(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNavBarToLeftEdge", $$robo$$com_android_internal_policy_DecorView$isNavBarToLeftEdge(int int ), (int)n, (int)n2);
    }

    public static int getNavBarSize(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNavBarSize", $$robo$$com_android_internal_policy_DecorView$getNavBarSize(int int int ), (int)n, (int)n2, (int)n3);
    }

    public static void getNavigationBarRect(int n, int n2, Rect rect, Rect rect2, Rect rect3) {
        InvokeDynamicSupport.bootstrapStatic("getNavigationBarRect", $$robo$$com_android_internal_policy_DecorView$getNavigationBarRect(int int android.graphics.Rect android.graphics.Rect android.graphics.Rect ), (int)n, (int)n2, (Rect)rect, (Rect)rect2, (Rect)rect3);
    }

    WindowInsets updateColorViews(WindowInsets windowInsets, boolean bl) {
        return InvokeDynamicSupport.bootstrap("updateColorViews", $$robo$$com_android_internal_policy_DecorView$updateColorViews(android.view.WindowInsets boolean ), this, windowInsets, bl);
    }

    private int calculateStatusBarColor() {
        return (int)InvokeDynamicSupport.bootstrap("calculateStatusBarColor", $$robo$$com_android_internal_policy_DecorView$calculateStatusBarColor(), this);
    }

    public static int calculateStatusBarColor(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("calculateStatusBarColor", $$robo$$com_android_internal_policy_DecorView$calculateStatusBarColor(int int int ), (int)n, (int)n2, (int)n3);
    }

    private int getCurrentColor(ColorViewState colorViewState) {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentColor", $$robo$$com_android_internal_policy_DecorView$getCurrentColor(com.android.internal.policy.DecorView$ColorViewState ), this, colorViewState);
    }

    private void updateColorViewInt(ColorViewState colorViewState, int n, int n2, int n3, boolean bl, boolean bl2, int n4, boolean bl3, boolean bl4) {
        InvokeDynamicSupport.bootstrap("updateColorViewInt", $$robo$$com_android_internal_policy_DecorView$updateColorViewInt(com.android.internal.policy.DecorView$ColorViewState int int int boolean boolean int boolean boolean ), this, colorViewState, n, n2, n3, bl, bl2, n4, bl3, bl4);
    }

    private void updateColorViewTranslations() {
        InvokeDynamicSupport.bootstrap("updateColorViewTranslations", $$robo$$com_android_internal_policy_DecorView$updateColorViewTranslations(), this);
    }

    private WindowInsets updateStatusGuard(WindowInsets windowInsets) {
        return InvokeDynamicSupport.bootstrap("updateStatusGuard", $$robo$$com_android_internal_policy_DecorView$updateStatusGuard(android.view.WindowInsets ), this, windowInsets);
    }

    private WindowInsets updateNavigationGuard(WindowInsets windowInsets) {
        return InvokeDynamicSupport.bootstrap("updateNavigationGuard", $$robo$$com_android_internal_policy_DecorView$updateNavigationGuard(android.view.WindowInsets ), this, windowInsets);
    }

    void updateNavigationGuardColor() {
        InvokeDynamicSupport.bootstrap("updateNavigationGuardColor", $$robo$$com_android_internal_policy_DecorView$updateNavigationGuardColor(), this);
    }

    public void updatePictureInPictureOutlineProvider(boolean bl) {
        InvokeDynamicSupport.bootstrap("updatePictureInPictureOutlineProvider", $$robo$$com_android_internal_policy_DecorView$updatePictureInPictureOutlineProvider(boolean ), this, bl);
    }

    @Override
    public void setOutlineProvider(ViewOutlineProvider viewOutlineProvider) {
        InvokeDynamicSupport.bootstrap("setOutlineProvider", $$robo$$com_android_internal_policy_DecorView$setOutlineProvider(android.view.ViewOutlineProvider ), this, viewOutlineProvider);
    }

    private void drawableChanged() {
        InvokeDynamicSupport.bootstrap("drawableChanged", $$robo$$com_android_internal_policy_DecorView$drawableChanged(), this);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$com_android_internal_policy_DecorView$onWindowFocusChanged(boolean ), this, bl);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_policy_DecorView$onAttachedToWindow(), this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_policy_DecorView$onDetachedFromWindow(), this);
    }

    @Override
    public void onCloseSystemDialogs(String string2) {
        InvokeDynamicSupport.bootstrap("onCloseSystemDialogs", $$robo$$com_android_internal_policy_DecorView$onCloseSystemDialogs(java.lang.String ), this, string2);
    }

    @Override
    public SurfaceHolder.Callback2 willYouTakeTheSurface() {
        return InvokeDynamicSupport.bootstrap("willYouTakeTheSurface", $$robo$$com_android_internal_policy_DecorView$willYouTakeTheSurface(), this);
    }

    @Override
    public InputQueue.Callback willYouTakeTheInputQueue() {
        return InvokeDynamicSupport.bootstrap("willYouTakeTheInputQueue", $$robo$$com_android_internal_policy_DecorView$willYouTakeTheInputQueue(), this);
    }

    @Override
    public void setSurfaceType(int n) {
        InvokeDynamicSupport.bootstrap("setSurfaceType", $$robo$$com_android_internal_policy_DecorView$setSurfaceType(int ), this, n);
    }

    @Override
    public void setSurfaceFormat(int n) {
        InvokeDynamicSupport.bootstrap("setSurfaceFormat", $$robo$$com_android_internal_policy_DecorView$setSurfaceFormat(int ), this, n);
    }

    @Override
    public void setSurfaceKeepScreenOn(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSurfaceKeepScreenOn", $$robo$$com_android_internal_policy_DecorView$setSurfaceKeepScreenOn(boolean ), this, bl);
    }

    @Override
    public void onRootViewScrollYChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRootViewScrollYChanged", $$robo$$com_android_internal_policy_DecorView$onRootViewScrollYChanged(int ), this, n);
    }

    private ActionMode createActionMode(int n, ActionMode.Callback2 callback2, View view) {
        return InvokeDynamicSupport.bootstrap("createActionMode", $$robo$$com_android_internal_policy_DecorView$createActionMode(int android.view.ActionMode$Callback2 android.view.View ), this, n, callback2, view);
    }

    private void setHandledActionMode(ActionMode actionMode) {
        InvokeDynamicSupport.bootstrap("setHandledActionMode", $$robo$$com_android_internal_policy_DecorView$setHandledActionMode(android.view.ActionMode ), this, actionMode);
    }

    private ActionMode createStandaloneActionMode(ActionMode.Callback callback) {
        return InvokeDynamicSupport.bootstrap("createStandaloneActionMode", $$robo$$com_android_internal_policy_DecorView$createStandaloneActionMode(android.view.ActionMode$Callback ), this, callback);
    }

    private void endOnGoingFadeAnimation() {
        InvokeDynamicSupport.bootstrap("endOnGoingFadeAnimation", $$robo$$com_android_internal_policy_DecorView$endOnGoingFadeAnimation(), this);
    }

    private void setHandledPrimaryActionMode(ActionMode actionMode) {
        InvokeDynamicSupport.bootstrap("setHandledPrimaryActionMode", $$robo$$com_android_internal_policy_DecorView$setHandledPrimaryActionMode(android.view.ActionMode ), this, actionMode);
    }

    boolean shouldAnimatePrimaryActionModeView() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldAnimatePrimaryActionModeView", $$robo$$com_android_internal_policy_DecorView$shouldAnimatePrimaryActionModeView(), this);
    }

    private ActionMode createFloatingActionMode(View view, ActionMode.Callback2 callback2) {
        return InvokeDynamicSupport.bootstrap("createFloatingActionMode", $$robo$$com_android_internal_policy_DecorView$createFloatingActionMode(android.view.View android.view.ActionMode$Callback2 ), this, view, callback2);
    }

    private void setHandledFloatingActionMode(ActionMode actionMode) {
        InvokeDynamicSupport.bootstrap("setHandledFloatingActionMode", $$robo$$com_android_internal_policy_DecorView$setHandledFloatingActionMode(android.view.ActionMode ), this, actionMode);
    }

    void enableCaption(boolean bl) {
        InvokeDynamicSupport.bootstrap("enableCaption", $$robo$$com_android_internal_policy_DecorView$enableCaption(boolean ), this, bl);
    }

    void setWindow(PhoneWindow phoneWindow) {
        InvokeDynamicSupport.bootstrap("setWindow", $$robo$$com_android_internal_policy_DecorView$setWindow(com.android.internal.policy.PhoneWindow ), this, phoneWindow);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$com_android_internal_policy_DecorView$onConfigurationChanged(android.content.res.Configuration ), this, configuration);
    }

    void onResourcesLoaded(LayoutInflater layoutInflater, int n) {
        InvokeDynamicSupport.bootstrap("onResourcesLoaded", $$robo$$com_android_internal_policy_DecorView$onResourcesLoaded(android.view.LayoutInflater int ), this, layoutInflater, n);
    }

    private void loadBackgroundDrawablesIfNeeded() {
        InvokeDynamicSupport.bootstrap("loadBackgroundDrawablesIfNeeded", $$robo$$com_android_internal_policy_DecorView$loadBackgroundDrawablesIfNeeded(), this);
    }

    private DecorCaptionView createDecorCaptionView(LayoutInflater layoutInflater) {
        return InvokeDynamicSupport.bootstrap("createDecorCaptionView", $$robo$$com_android_internal_policy_DecorView$createDecorCaptionView(android.view.LayoutInflater ), this, layoutInflater);
    }

    private DecorCaptionView inflateDecorCaptionView(LayoutInflater layoutInflater) {
        return InvokeDynamicSupport.bootstrap("inflateDecorCaptionView", $$robo$$com_android_internal_policy_DecorView$inflateDecorCaptionView(android.view.LayoutInflater ), this, layoutInflater);
    }

    private void setDecorCaptionShade(Context context, DecorCaptionView decorCaptionView) {
        InvokeDynamicSupport.bootstrap("setDecorCaptionShade", $$robo$$com_android_internal_policy_DecorView$setDecorCaptionShade(android.content.Context com.android.internal.widget.DecorCaptionView ), this, context, decorCaptionView);
    }

    void updateDecorCaptionShade() {
        InvokeDynamicSupport.bootstrap("updateDecorCaptionShade", $$robo$$com_android_internal_policy_DecorView$updateDecorCaptionShade(), this);
    }

    private void setLightDecorCaptionShade(DecorCaptionView decorCaptionView) {
        InvokeDynamicSupport.bootstrap("setLightDecorCaptionShade", $$robo$$com_android_internal_policy_DecorView$setLightDecorCaptionShade(com.android.internal.widget.DecorCaptionView ), this, decorCaptionView);
    }

    private void setDarkDecorCaptionShade(DecorCaptionView decorCaptionView) {
        InvokeDynamicSupport.bootstrap("setDarkDecorCaptionShade", $$robo$$com_android_internal_policy_DecorView$setDarkDecorCaptionShade(com.android.internal.widget.DecorCaptionView ), this, decorCaptionView);
    }

    public static Drawable getResizingBackgroundDrawable(Context context, int n, int n2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getResizingBackgroundDrawable", $$robo$$com_android_internal_policy_DecorView$getResizingBackgroundDrawable(android.content.Context int int boolean ), (Context)context, (int)n, (int)n2, (boolean)bl);
    }

    private static Drawable enforceNonTranslucentBackground(Drawable drawable2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("enforceNonTranslucentBackground", $$robo$$com_android_internal_policy_DecorView$enforceNonTranslucentBackground(android.graphics.drawable.Drawable boolean ), (Drawable)drawable2, (boolean)bl);
    }

    private int getStackId() {
        return (int)InvokeDynamicSupport.bootstrap("getStackId", $$robo$$com_android_internal_policy_DecorView$getStackId(), this);
    }

    void clearContentView() {
        InvokeDynamicSupport.bootstrap("clearContentView", $$robo$$com_android_internal_policy_DecorView$clearContentView(), this);
    }

    @Override
    public void onWindowSizeIsChanging(Rect rect, boolean bl, Rect rect2, Rect rect3) {
        InvokeDynamicSupport.bootstrap("onWindowSizeIsChanging", $$robo$$com_android_internal_policy_DecorView$onWindowSizeIsChanging(android.graphics.Rect boolean android.graphics.Rect android.graphics.Rect ), this, rect, bl, rect2, rect3);
    }

    @Override
    public void onWindowDragResizeStart(Rect rect, boolean bl, Rect rect2, Rect rect3, int n) {
        InvokeDynamicSupport.bootstrap("onWindowDragResizeStart", $$robo$$com_android_internal_policy_DecorView$onWindowDragResizeStart(android.graphics.Rect boolean android.graphics.Rect android.graphics.Rect int ), this, rect, bl, rect2, rect3, n);
    }

    @Override
    public void onWindowDragResizeEnd() {
        InvokeDynamicSupport.bootstrap("onWindowDragResizeEnd", $$robo$$com_android_internal_policy_DecorView$onWindowDragResizeEnd(), this);
    }

    @Override
    public boolean onContentDrawn(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("onContentDrawn", $$robo$$com_android_internal_policy_DecorView$onContentDrawn(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    public void onRequestDraw(boolean bl) {
        InvokeDynamicSupport.bootstrap("onRequestDraw", $$robo$$com_android_internal_policy_DecorView$onRequestDraw(boolean ), this, bl);
    }

    @Override
    public void onPostDraw(DisplayListCanvas displayListCanvas) {
        InvokeDynamicSupport.bootstrap("onPostDraw", $$robo$$com_android_internal_policy_DecorView$onPostDraw(android.view.DisplayListCanvas ), this, displayListCanvas);
    }

    private void initResizingPaints() {
        InvokeDynamicSupport.bootstrap("initResizingPaints", $$robo$$com_android_internal_policy_DecorView$initResizingPaints(), this);
    }

    private void drawResizingShadowIfNeeded(DisplayListCanvas displayListCanvas) {
        InvokeDynamicSupport.bootstrap("drawResizingShadowIfNeeded", $$robo$$com_android_internal_policy_DecorView$drawResizingShadowIfNeeded(android.view.DisplayListCanvas ), this, displayListCanvas);
    }

    private void releaseThreadedRenderer() {
        InvokeDynamicSupport.bootstrap("releaseThreadedRenderer", $$robo$$com_android_internal_policy_DecorView$releaseThreadedRenderer(), this);
    }

    private boolean isResizing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isResizing", $$robo$$com_android_internal_policy_DecorView$isResizing(), this);
    }

    private void initializeElevation() {
        InvokeDynamicSupport.bootstrap("initializeElevation", $$robo$$com_android_internal_policy_DecorView$initializeElevation(), this);
    }

    private void updateElevation() {
        InvokeDynamicSupport.bootstrap("updateElevation", $$robo$$com_android_internal_policy_DecorView$updateElevation(), this);
    }

    boolean isShowingCaption() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowingCaption", $$robo$$com_android_internal_policy_DecorView$isShowingCaption(), this);
    }

    int getCaptionHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getCaptionHeight", $$robo$$com_android_internal_policy_DecorView$getCaptionHeight(), this);
    }

    private float dipToPx(float f) {
        return (float)InvokeDynamicSupport.bootstrap("dipToPx", $$robo$$com_android_internal_policy_DecorView$dipToPx(float ), this, f);
    }

    void setUserCaptionBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setUserCaptionBackgroundDrawable", $$robo$$com_android_internal_policy_DecorView$setUserCaptionBackgroundDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    private static String getTitleSuffix(WindowManager.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrapStatic("getTitleSuffix", $$robo$$com_android_internal_policy_DecorView$getTitleSuffix(android.view.WindowManager$LayoutParams ), (WindowManager.LayoutParams)layoutParams);
    }

    void updateLogTag(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("updateLogTag", $$robo$$com_android_internal_policy_DecorView$updateLogTag(android.view.WindowManager$LayoutParams ), this, layoutParams);
    }

    private void updateAvailableWidth() {
        InvokeDynamicSupport.bootstrap("updateAvailableWidth", $$robo$$com_android_internal_policy_DecorView$updateAvailableWidth(), this);
    }

    @Override
    public void requestKeyboardShortcuts(List<KeyboardShortcutGroup> list, int n) {
        InvokeDynamicSupport.bootstrap("requestKeyboardShortcuts", $$robo$$com_android_internal_policy_DecorView$requestKeyboardShortcuts(java.util.List<android.view.KeyboardShortcutGroup> int ), this, list, n);
    }

    @Override
    public void dispatchPointerCaptureChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchPointerCaptureChanged", $$robo$$com_android_internal_policy_DecorView$dispatchPointerCaptureChanged(boolean ), this, bl);
    }

    @Override
    public int getAccessibilityViewId() {
        return (int)InvokeDynamicSupport.bootstrap("getAccessibilityViewId", $$robo$$com_android_internal_policy_DecorView$getAccessibilityViewId(), this);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_policy_DecorView$toString(), this);
    }

    static {
        RobolectricInternals.classInitializing(DecorView.class);
    }

    public /* synthetic */ DecorView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecorView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ActionModeCallback2Wrapper
    extends ActionMode.Callback2
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ActionMode.Callback mWrapped;
        /* synthetic */ DecorView this$0;

        private void $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$__constructor__(DecorView decorView, ActionMode.Callback wrapped) {
            this.mWrapped = wrapped;
        }

        private final boolean $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$onCreateActionMode(ActionMode mode, Menu menu2) {
            return this.mWrapped.onCreateActionMode(mode, menu2);
        }

        private final boolean $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$onPrepareActionMode(ActionMode mode, Menu menu2) {
            this.this$0.requestFitSystemWindows();
            return this.mWrapped.onPrepareActionMode(mode, menu2);
        }

        private final boolean $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        private final void $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$onDestroyActionMode(ActionMode mode) {
            boolean isFloating;
            boolean isPrimary;
            boolean isMncApp;
            this.mWrapped.onDestroyActionMode(mode);
            boolean bl = isMncApp = ((DecorView)this.this$0).mContext.getApplicationInfo().targetSdkVersion >= 23;
            if (isMncApp) {
                isPrimary = mode == this.this$0.mPrimaryActionMode;
                boolean bl2 = isFloating = mode == this.this$0.mFloatingActionMode;
                if (!isPrimary && mode.getType() == 0) {
                    Log.e(this.this$0.mLogTag, "Destroying unexpected ActionMode instance of TYPE_PRIMARY; " + mode + " was not the current primary action mode! Expected " + this.this$0.mPrimaryActionMode);
                }
                if (!isFloating && mode.getType() == 1) {
                    Log.e(this.this$0.mLogTag, "Destroying unexpected ActionMode instance of TYPE_FLOATING; " + mode + " was not the current floating action mode! Expected " + this.this$0.mFloatingActionMode);
                }
            } else {
                isPrimary = mode.getType() == 0;
                boolean bl3 = isFloating = mode.getType() == 1;
            }
            if (isPrimary) {
                if (this.this$0.mPrimaryActionModePopup != null) {
                    this.this$0.removeCallbacks(this.this$0.mShowPrimaryActionModePopup);
                }
                if (this.this$0.mPrimaryActionModeView != null) {
                    this.this$0.endOnGoingFadeAnimation();
                    ActionBarContextView lastActionModeView = this.this$0.mPrimaryActionModeView;
                    this.this$0.mFadeAnim = ObjectAnimator.ofFloat(this.this$0.mPrimaryActionModeView, View.ALPHA, 1.0f, 0.0f);
                    this.this$0.mFadeAnim.addListener(new Animator.AnimatorListener(this, lastActionModeView){
                        public /* synthetic */ Object __robo_data__;
                        /* synthetic */ ActionBarContextView val$lastActionModeView;
                        /* synthetic */ ActionModeCallback2Wrapper this$1;

                        private void $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$__constructor__(ActionModeCallback2Wrapper this$1, ActionBarContextView actionBarContextView) {
                            this.this$1 = this$1;
                            this.val$lastActionModeView = actionBarContextView;
                        }

                        private final void $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$onAnimationStart(Animator animation) {
                        }

                        private final void $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$onAnimationEnd(Animator animation) {
                            if (this.val$lastActionModeView == this.this$1.this$0.mPrimaryActionModeView) {
                                this.val$lastActionModeView.setVisibility(8);
                                if (this.this$1.this$0.mPrimaryActionModePopup != null) {
                                    this.this$1.this$0.mPrimaryActionModePopup.dismiss();
                                }
                                this.val$lastActionModeView.killMode();
                                this.this$1.this$0.mFadeAnim = null;
                            }
                        }

                        private final void $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$onAnimationCancel(Animator animation) {
                        }

                        private final void $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$onAnimationRepeat(Animator animation) {
                        }

                        private void __constructor__(ActionModeCallback2Wrapper actionModeCallback2Wrapper, ActionBarContextView actionBarContextView) {
                            this.$$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$__constructor__(actionModeCallback2Wrapper, actionBarContextView);
                        }
                        {
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$__constructor__(com.android.internal.policy.DecorView$ActionModeCallback2Wrapper com.android.internal.widget.ActionBarContextView ), this, actionModeCallback2Wrapper, actionBarContextView);
                        }

                        @Override
                        public void onAnimationStart(Animator animator2) {
                            InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$onAnimationStart(android.animation.Animator ), this, animator2);
                        }

                        @Override
                        public void onAnimationEnd(Animator animator2) {
                            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$onAnimationEnd(android.animation.Animator ), this, animator2);
                        }

                        @Override
                        public void onAnimationCancel(Animator animator2) {
                            InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$onAnimationCancel(android.animation.Animator ), this, animator2);
                        }

                        @Override
                        public void onAnimationRepeat(Animator animator2) {
                            InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper_1$onAnimationRepeat(android.animation.Animator ), this, animator2);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                    this.this$0.mFadeAnim.start();
                }
                this.this$0.mPrimaryActionMode = null;
            } else if (isFloating) {
                this.this$0.cleanupFloatingActionModeViews();
                this.this$0.mFloatingActionMode = null;
            }
            if (this.this$0.mWindow.getCallback() != null && !this.this$0.mWindow.isDestroyed()) {
                try {
                    this.this$0.mWindow.getCallback().onActionModeFinished(mode);
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
            }
            this.this$0.requestFitSystemWindows();
        }

        private final void $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$onGetContentRect(ActionMode mode, View view, Rect outRect) {
            if (this.mWrapped instanceof ActionMode.Callback2) {
                ((ActionMode.Callback2)this.mWrapped).onGetContentRect(mode, view, outRect);
            } else {
                super.onGetContentRect(mode, view, outRect);
            }
        }

        private void __constructor__(DecorView decorView, ActionMode.Callback callback) {
            this.$$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$__constructor__(decorView, callback);
        }

        public ActionModeCallback2Wrapper(DecorView decorView, ActionMode.Callback callback) {
            this.this$0 = decorView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$__constructor__(com.android.internal.policy.DecorView android.view.ActionMode$Callback ), this, decorView, callback);
        }

        @Override
        public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onCreateActionMode", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$onCreateActionMode(android.view.ActionMode android.view.Menu ), this, actionMode, menu2);
        }

        @Override
        public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onPrepareActionMode", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$onPrepareActionMode(android.view.ActionMode android.view.Menu ), this, actionMode, menu2);
        }

        @Override
        public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
            return (boolean)InvokeDynamicSupport.bootstrap("onActionItemClicked", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$onActionItemClicked(android.view.ActionMode android.view.MenuItem ), this, actionMode, menuItem);
        }

        @Override
        public void onDestroyActionMode(ActionMode actionMode) {
            InvokeDynamicSupport.bootstrap("onDestroyActionMode", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$onDestroyActionMode(android.view.ActionMode ), this, actionMode);
        }

        @Override
        public void onGetContentRect(ActionMode actionMode, View view, Rect rect) {
            InvokeDynamicSupport.bootstrap("onGetContentRect", $$robo$$com_android_internal_policy_DecorView_ActionModeCallback2Wrapper$onGetContentRect(android.view.ActionMode android.view.View android.graphics.Rect ), this, actionMode, view, rect);
        }

        public /* synthetic */ ActionModeCallback2Wrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionModeCallback2Wrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ColorViewAttributes
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int id;
        int systemUiHideFlag;
        int translucentFlag;
        int verticalGravity;
        int horizontalGravity;
        int seascapeGravity;
        String transitionName;
        int hideWindowFlag;

        private void $$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$__constructor__(int systemUiHideFlag, int translucentFlag, int verticalGravity, int horizontalGravity, int seascapeGravity, String transitionName, int id2, int hideWindowFlag) {
            this.id = id2;
            this.systemUiHideFlag = systemUiHideFlag;
            this.translucentFlag = translucentFlag;
            this.verticalGravity = verticalGravity;
            this.horizontalGravity = horizontalGravity;
            this.seascapeGravity = seascapeGravity;
            this.transitionName = transitionName;
            this.hideWindowFlag = hideWindowFlag;
        }

        private final boolean $$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$isPresent(int sysUiVis, int windowFlags, boolean force) {
            return (sysUiVis & this.systemUiHideFlag) == 0 && (windowFlags & this.hideWindowFlag) == 0 && ((windowFlags & Integer.MIN_VALUE) != 0 || force);
        }

        private final boolean $$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$isVisible(boolean present, int color2, int windowFlags, boolean force) {
            return present && (color2 & 0xFF000000) != 0 && ((windowFlags & this.translucentFlag) == 0 || force);
        }

        private final boolean $$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$isVisible(int sysUiVis, int color2, int windowFlags, boolean force) {
            boolean present = this.isPresent(sysUiVis, windowFlags, force);
            return this.isVisible(present, color2, windowFlags, force);
        }

        private /* synthetic */ void $$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$__constructor__(int x0, int x1, int x2, int x3, int x4, String x5, int x6, int x7, 1 x8) {
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, String string2, int n6, int n7) {
            this.$$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$__constructor__(n, n2, n3, n4, n5, string2, n6, n7);
        }

        public ColorViewAttributes(int n, int n2, int n3, int n4, int n5, String string2, int n6, int n7) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$__constructor__(int int int int int java.lang.String int int ), this, n, n2, n3, n4, n5, string2, n6, n7);
        }

        public boolean isPresent(int n, int n2, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("isPresent", $$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$isPresent(int int boolean ), this, n, n2, bl);
        }

        public boolean isVisible(boolean bl, int n, int n2, boolean bl2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$isVisible(boolean int int boolean ), this, bl, n, n2, bl2);
        }

        public boolean isVisible(int n, int n2, int n3, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$isVisible(int int int boolean ), this, n, n2, n3, bl);
        }

        private /* synthetic */ void __constructor__(int n, int n2, int n3, int n4, int n5, String string2, int n6, int n7, 1 var9_9) {
            this.$$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$__constructor__(n, n2, n3, n4, n5, string2, n6, n7, var9_9);
        }

        public /* synthetic */ ColorViewAttributes(int n, int n2, int n3, int n4, int n5, String string2, int n6, int n7, 1 var9_9) {
            this(n, n2, n3, n4, n5, string2, n6, n7);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_ColorViewAttributes$__constructor__(int int int int int java.lang.String int int com.android.internal.policy.DecorView$1 ), this, n, n2, n3, n4, n5, string2, n6, n7, var9_9);
        }

        public /* synthetic */ ColorViewAttributes() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorViewAttributes)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ColorViewState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        View view;
        int targetVisibility;
        boolean present;
        boolean visible;
        int color;
        ColorViewAttributes attributes;

        private void $$robo$$com_android_internal_policy_DecorView_ColorViewState$__constructor__(ColorViewAttributes attributes) {
            this.view = null;
            this.targetVisibility = 4;
            this.present = false;
            this.attributes = attributes;
        }

        private void __constructor__(ColorViewAttributes colorViewAttributes) {
            this.$$robo$$com_android_internal_policy_DecorView_ColorViewState$__constructor__(colorViewAttributes);
        }

        public ColorViewState(ColorViewAttributes colorViewAttributes) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_DecorView_ColorViewState$__constructor__(com.android.internal.policy.DecorView$ColorViewAttributes ), this, colorViewAttributes);
        }

        public /* synthetic */ ColorViewState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorViewState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

