/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.view.Choreographer;
import android.view.DisplayListCanvas;
import android.view.RenderNode;
import android.view.ThreadedRenderer;
import com.android.internal.policy.DecorView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BackdropFrameRenderer
extends Thread
implements Choreographer.FrameCallback,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private DecorView mDecorView;
    private Rect mTargetRect;
    private ThreadedRenderer mRenderer;
    private RenderNode mFrameAndBackdropNode;
    private RenderNode mSystemBarBackgroundNode;
    private Rect mOldTargetRect;
    private Rect mNewTargetRect;
    private Choreographer mChoreographer;
    private int mLastContentWidth;
    private int mLastContentHeight;
    private int mLastCaptionHeight;
    private int mLastXOffset;
    private int mLastYOffset;
    private boolean mReportNextDraw;
    private Drawable mCaptionBackgroundDrawable;
    private Drawable mUserCaptionBackgroundDrawable;
    private Drawable mResizingBackgroundDrawable;
    private ColorDrawable mStatusBarColor;
    private ColorDrawable mNavigationBarColor;
    private boolean mOldFullscreen;
    private boolean mFullscreen;
    private int mResizeMode;
    private Rect mOldSystemInsets;
    private Rect mOldStableInsets;
    private Rect mSystemInsets;
    private Rect mStableInsets;
    private Rect mTmpRect;

    private void $$robo$$com_android_internal_policy_BackdropFrameRenderer$__constructor__(DecorView decorView, ThreadedRenderer renderer, Rect initialBounds, Drawable resizingBackgroundDrawable, Drawable captionBackgroundDrawable, Drawable userCaptionBackgroundDrawable, int statusBarColor, int navigationBarColor, boolean fullscreen, Rect systemInsets, Rect stableInsets, int resizeMode) {
        this.mTargetRect = new Rect();
        this.mOldTargetRect = new Rect();
        this.mNewTargetRect = new Rect();
        this.mOldSystemInsets = new Rect();
        this.mOldStableInsets = new Rect();
        this.mSystemInsets = new Rect();
        this.mStableInsets = new Rect();
        this.mTmpRect = new Rect();
        this.setName("ResizeFrame");
        this.mRenderer = renderer;
        this.onResourcesLoaded(decorView, resizingBackgroundDrawable, captionBackgroundDrawable, userCaptionBackgroundDrawable, statusBarColor, navigationBarColor);
        this.mFrameAndBackdropNode = RenderNode.create("FrameAndBackdropNode", null);
        this.mRenderer.addRenderNode(this.mFrameAndBackdropNode, true);
        this.mTargetRect.set(initialBounds);
        this.mFullscreen = fullscreen;
        this.mOldFullscreen = fullscreen;
        this.mSystemInsets.set(systemInsets);
        this.mStableInsets.set(stableInsets);
        this.mOldSystemInsets.set(systemInsets);
        this.mOldStableInsets.set(stableInsets);
        this.mResizeMode = resizeMode;
        this.start();
    }

    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$onResourcesLoaded(DecorView decorView, Drawable resizingBackgroundDrawable, Drawable captionBackgroundDrawableDrawable, Drawable userCaptionBackgroundDrawable, int statusBarColor, int navigationBarColor) {
        this.mDecorView = decorView;
        this.mResizingBackgroundDrawable = resizingBackgroundDrawable != null && resizingBackgroundDrawable.getConstantState() != null ? resizingBackgroundDrawable.getConstantState().newDrawable() : null;
        this.mCaptionBackgroundDrawable = captionBackgroundDrawableDrawable != null && captionBackgroundDrawableDrawable.getConstantState() != null ? captionBackgroundDrawableDrawable.getConstantState().newDrawable() : null;
        Drawable drawable2 = this.mUserCaptionBackgroundDrawable = userCaptionBackgroundDrawable != null && userCaptionBackgroundDrawable.getConstantState() != null ? userCaptionBackgroundDrawable.getConstantState().newDrawable() : null;
        if (this.mCaptionBackgroundDrawable == null) {
            this.mCaptionBackgroundDrawable = this.mResizingBackgroundDrawable;
        }
        if (statusBarColor != 0) {
            this.mStatusBarColor = new ColorDrawable(statusBarColor);
            this.addSystemBarNodeIfNeeded();
        } else {
            this.mStatusBarColor = null;
        }
        if (navigationBarColor != 0) {
            this.mNavigationBarColor = new ColorDrawable(navigationBarColor);
            this.addSystemBarNodeIfNeeded();
        } else {
            this.mNavigationBarColor = null;
        }
    }

    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$addSystemBarNodeIfNeeded() {
        if (this.mSystemBarBackgroundNode != null) {
            return;
        }
        this.mSystemBarBackgroundNode = RenderNode.create("SystemBarBackgroundNode", null);
        this.mRenderer.addRenderNode(this.mSystemBarBackgroundNode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$setTargetRect(Rect newTargetBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            this.mFullscreen = fullscreen;
            this.mTargetRect.set(newTargetBounds);
            this.mSystemInsets.set(systemInsets);
            this.mStableInsets.set(stableInsets);
            this.pingRenderLocked(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$onConfigurationChange() {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            if (this.mRenderer != null) {
                this.mOldTargetRect.set(0, 0, 0, 0);
                this.pingRenderLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$releaseRenderer() {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            if (this.mRenderer != null) {
                this.mRenderer.setContentDrawBounds(0, 0, 0, 0);
                this.mRenderer.removeRenderNode(this.mFrameAndBackdropNode);
                if (this.mSystemBarBackgroundNode != null) {
                    this.mRenderer.removeRenderNode(this.mSystemBarBackgroundNode);
                }
                this.mRenderer = null;
                this.pingRenderLocked(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$run() {
        BackdropFrameRenderer backdropFrameRenderer;
        try {
            Looper.prepare();
            backdropFrameRenderer = this;
            synchronized (backdropFrameRenderer) {
                this.mChoreographer = Choreographer.getInstance();
            }
            Looper.loop();
        }
        finally {
            this.releaseRenderer();
        }
        backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            this.mChoreographer = null;
            Choreographer.releaseInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$doFrame(long frameTimeNanos) {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            if (this.mRenderer == null) {
                this.reportDrawIfNeeded();
                Looper.myLooper().quit();
                return;
            }
            this.doFrameUncheckedLocked();
        }
    }

    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$doFrameUncheckedLocked() {
        this.mNewTargetRect.set(this.mTargetRect);
        if (!this.mNewTargetRect.equals(this.mOldTargetRect) || this.mOldFullscreen != this.mFullscreen || !this.mStableInsets.equals(this.mOldStableInsets) || !this.mSystemInsets.equals(this.mOldSystemInsets) || this.mReportNextDraw) {
            this.mOldFullscreen = this.mFullscreen;
            this.mOldTargetRect.set(this.mNewTargetRect);
            this.mOldSystemInsets.set(this.mSystemInsets);
            this.mOldStableInsets.set(this.mStableInsets);
            this.redrawLocked(this.mNewTargetRect, this.mFullscreen, this.mSystemInsets, this.mStableInsets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_policy_BackdropFrameRenderer$onContentDrawn(int xOffset, int yOffset, int xSize, int ySize) {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            boolean firstCall = this.mLastContentWidth == 0;
            this.mLastContentWidth = xSize;
            this.mLastContentHeight = ySize - this.mLastCaptionHeight;
            this.mLastXOffset = xOffset;
            this.mLastYOffset = yOffset;
            this.mRenderer.setContentDrawBounds(this.mLastXOffset, this.mLastYOffset, this.mLastXOffset + this.mLastContentWidth, this.mLastYOffset + this.mLastCaptionHeight + this.mLastContentHeight);
            return firstCall && (this.mLastCaptionHeight != 0 || !this.mDecorView.isShowingCaption());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$onRequestDraw(boolean reportNextDraw) {
        BackdropFrameRenderer backdropFrameRenderer = this;
        synchronized (backdropFrameRenderer) {
            this.mReportNextDraw = reportNextDraw;
            this.mOldTargetRect.set(0, 0, 0, 0);
            this.pingRenderLocked(true);
        }
    }

    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$redrawLocked(Rect newBounds, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
        Drawable drawable2;
        int captionHeight = this.mDecorView.getCaptionHeight();
        if (captionHeight != 0) {
            this.mLastCaptionHeight = captionHeight;
        }
        if (this.mLastCaptionHeight == 0 && this.mDecorView.isShowingCaption() || this.mLastContentWidth == 0 || this.mLastContentHeight == 0) {
            return;
        }
        int left = this.mLastXOffset + newBounds.left;
        int top = this.mLastYOffset + newBounds.top;
        int width = newBounds.width();
        int height = newBounds.height();
        this.mFrameAndBackdropNode.setLeftTopRightBottom(left, top, left + width, top + height);
        DisplayListCanvas canvas = this.mFrameAndBackdropNode.start(width, height);
        Drawable drawable3 = drawable2 = this.mUserCaptionBackgroundDrawable != null ? this.mUserCaptionBackgroundDrawable : this.mCaptionBackgroundDrawable;
        if (drawable2 != null) {
            drawable2.setBounds(0, 0, left + width, top + this.mLastCaptionHeight);
            drawable2.draw(canvas);
        }
        if (this.mResizingBackgroundDrawable != null) {
            this.mResizingBackgroundDrawable.setBounds(0, this.mLastCaptionHeight, left + width, top + height);
            this.mResizingBackgroundDrawable.draw(canvas);
        }
        this.mFrameAndBackdropNode.end(canvas);
        this.drawColorViews(left, top, width, height, fullscreen, systemInsets, stableInsets);
        this.mRenderer.drawRenderNode(this.mFrameAndBackdropNode);
        this.reportDrawIfNeeded();
    }

    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$drawColorViews(int left, int top, int width, int height, boolean fullscreen, Rect systemInsets, Rect stableInsets) {
        if (this.mSystemBarBackgroundNode == null) {
            return;
        }
        DisplayListCanvas canvas = this.mSystemBarBackgroundNode.start(width, height);
        this.mSystemBarBackgroundNode.setLeftTopRightBottom(left, top, left + width, top + height);
        int topInset = DecorView.getColorViewTopInset(this.mStableInsets.top, this.mSystemInsets.top);
        if (this.mStatusBarColor != null) {
            this.mStatusBarColor.setBounds(0, 0, left + width, topInset);
            this.mStatusBarColor.draw(canvas);
        }
        if (this.mNavigationBarColor != null && fullscreen) {
            DecorView.getNavigationBarRect(width, height, stableInsets, systemInsets, this.mTmpRect);
            this.mNavigationBarColor.setBounds(this.mTmpRect);
            this.mNavigationBarColor.draw(canvas);
        }
        this.mSystemBarBackgroundNode.end(canvas);
        this.mRenderer.drawRenderNode(this.mSystemBarBackgroundNode);
    }

    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$reportDrawIfNeeded() {
        if (this.mReportNextDraw) {
            if (this.mDecorView.isAttachedToWindow()) {
                this.mDecorView.getViewRootImpl().reportDrawFinish();
            }
            this.mReportNextDraw = false;
        }
    }

    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$pingRenderLocked(boolean drawImmediate) {
        if (this.mChoreographer != null && !drawImmediate) {
            this.mChoreographer.postFrameCallback(this);
        } else {
            this.doFrameUncheckedLocked();
        }
    }

    private final void $$robo$$com_android_internal_policy_BackdropFrameRenderer$setUserCaptionBackgroundDrawable(Drawable userCaptionBackgroundDrawable) {
        this.mUserCaptionBackgroundDrawable = userCaptionBackgroundDrawable;
    }

    private void __constructor__(DecorView decorView, ThreadedRenderer threadedRenderer, Rect rect, Drawable drawable2, Drawable drawable3, Drawable drawable4, int n, int n2, boolean bl, Rect rect2, Rect rect3, int n3) {
        this.$$robo$$com_android_internal_policy_BackdropFrameRenderer$__constructor__(decorView, threadedRenderer, rect, drawable2, drawable3, drawable4, n, n2, bl, rect2, rect3, n3);
    }

    public BackdropFrameRenderer(DecorView decorView, ThreadedRenderer threadedRenderer, Rect rect, Drawable drawable2, Drawable drawable3, Drawable drawable4, int n, int n2, boolean bl, Rect rect2, Rect rect3, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_BackdropFrameRenderer$__constructor__(com.android.internal.policy.DecorView android.view.ThreadedRenderer android.graphics.Rect android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.drawable.Drawable int int boolean android.graphics.Rect android.graphics.Rect int ), this, decorView, threadedRenderer, rect, drawable2, drawable3, drawable4, n, n2, bl, rect2, rect3, n3);
    }

    void onResourcesLoaded(DecorView decorView, Drawable drawable2, Drawable drawable3, Drawable drawable4, int n, int n2) {
        InvokeDynamicSupport.bootstrap("onResourcesLoaded", $$robo$$com_android_internal_policy_BackdropFrameRenderer$onResourcesLoaded(com.android.internal.policy.DecorView android.graphics.drawable.Drawable android.graphics.drawable.Drawable android.graphics.drawable.Drawable int int ), this, decorView, drawable2, drawable3, drawable4, n, n2);
    }

    private void addSystemBarNodeIfNeeded() {
        InvokeDynamicSupport.bootstrap("addSystemBarNodeIfNeeded", $$robo$$com_android_internal_policy_BackdropFrameRenderer$addSystemBarNodeIfNeeded(), this);
    }

    public void setTargetRect(Rect rect, boolean bl, Rect rect2, Rect rect3) {
        InvokeDynamicSupport.bootstrap("setTargetRect", $$robo$$com_android_internal_policy_BackdropFrameRenderer$setTargetRect(android.graphics.Rect boolean android.graphics.Rect android.graphics.Rect ), this, rect, bl, rect2, rect3);
    }

    public void onConfigurationChange() {
        InvokeDynamicSupport.bootstrap("onConfigurationChange", $$robo$$com_android_internal_policy_BackdropFrameRenderer$onConfigurationChange(), this);
    }

    public void releaseRenderer() {
        InvokeDynamicSupport.bootstrap("releaseRenderer", $$robo$$com_android_internal_policy_BackdropFrameRenderer$releaseRenderer(), this);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_BackdropFrameRenderer$run(), this);
    }

    @Override
    public void doFrame(long l) {
        InvokeDynamicSupport.bootstrap("doFrame", $$robo$$com_android_internal_policy_BackdropFrameRenderer$doFrame(long ), this, l);
    }

    private void doFrameUncheckedLocked() {
        InvokeDynamicSupport.bootstrap("doFrameUncheckedLocked", $$robo$$com_android_internal_policy_BackdropFrameRenderer$doFrameUncheckedLocked(), this);
    }

    public boolean onContentDrawn(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("onContentDrawn", $$robo$$com_android_internal_policy_BackdropFrameRenderer$onContentDrawn(int int int int ), this, n, n2, n3, n4);
    }

    public void onRequestDraw(boolean bl) {
        InvokeDynamicSupport.bootstrap("onRequestDraw", $$robo$$com_android_internal_policy_BackdropFrameRenderer$onRequestDraw(boolean ), this, bl);
    }

    private void redrawLocked(Rect rect, boolean bl, Rect rect2, Rect rect3) {
        InvokeDynamicSupport.bootstrap("redrawLocked", $$robo$$com_android_internal_policy_BackdropFrameRenderer$redrawLocked(android.graphics.Rect boolean android.graphics.Rect android.graphics.Rect ), this, rect, bl, rect2, rect3);
    }

    private void drawColorViews(int n, int n2, int n3, int n4, boolean bl, Rect rect, Rect rect2) {
        InvokeDynamicSupport.bootstrap("drawColorViews", $$robo$$com_android_internal_policy_BackdropFrameRenderer$drawColorViews(int int int int boolean android.graphics.Rect android.graphics.Rect ), this, n, n2, n3, n4, bl, rect, rect2);
    }

    private void reportDrawIfNeeded() {
        InvokeDynamicSupport.bootstrap("reportDrawIfNeeded", $$robo$$com_android_internal_policy_BackdropFrameRenderer$reportDrawIfNeeded(), this);
    }

    private void pingRenderLocked(boolean bl) {
        InvokeDynamicSupport.bootstrap("pingRenderLocked", $$robo$$com_android_internal_policy_BackdropFrameRenderer$pingRenderLocked(boolean ), this, bl);
    }

    void setUserCaptionBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setUserCaptionBackgroundDrawable", $$robo$$com_android_internal_policy_BackdropFrameRenderer$setUserCaptionBackgroundDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public /* synthetic */ BackdropFrameRenderer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BackdropFrameRenderer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

