/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.util.ArrayMap;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WakelockPowerCalculator
extends PowerCalculator
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "WakelockPowerCalculator";
    private static boolean DEBUG = false;
    private double mPowerWakelock;
    private long mTotalAppWakelockTimeMs;

    private void $$robo$$com_android_internal_os_WakelockPowerCalculator$__constructor__(PowerProfile profile) {
        this.mTotalAppWakelockTimeMs = 0L;
        this.mPowerWakelock = profile.getAveragePower("cpu.awake");
    }

    private final void $$robo$$com_android_internal_os_WakelockPowerCalculator$calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        long wakeLockTimeUs = 0L;
        ArrayMap<String, ? extends BatteryStats.Uid.Wakelock> wakelockStats = u.getWakelockStats();
        int wakelockStatsCount = wakelockStats.size();
        for (int i = 0; i < wakelockStatsCount; ++i) {
            BatteryStats.Uid.Wakelock wakelock = wakelockStats.valueAt(i);
            BatteryStats.Timer timer = wakelock.getWakeTime(0);
            if (timer == null) continue;
            wakeLockTimeUs += timer.getTotalTimeLocked(rawRealtimeUs, statsType);
        }
        app.wakeLockTimeMs = wakeLockTimeUs / 1000L;
        this.mTotalAppWakelockTimeMs += app.wakeLockTimeMs;
        app.wakeLockPowerMah = (double)app.wakeLockTimeMs * this.mPowerWakelock / 3600000.0;
    }

    private final void $$robo$$com_android_internal_os_WakelockPowerCalculator$calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        long wakeTimeMillis = stats.getBatteryUptime(rawUptimeUs) / 1000L;
        if ((wakeTimeMillis -= this.mTotalAppWakelockTimeMs + stats.getScreenOnTime(rawRealtimeUs, statsType) / 1000L) > 0L) {
            double power = (double)wakeTimeMillis * this.mPowerWakelock / 3600000.0;
            app.wakeLockTimeMs += wakeTimeMillis;
            app.wakeLockPowerMah += power;
        }
    }

    private final void $$robo$$com_android_internal_os_WakelockPowerCalculator$reset() {
        this.mTotalAppWakelockTimeMs = 0L;
    }

    private void __constructor__(PowerProfile powerProfile) {
        this.$$robo$$com_android_internal_os_WakelockPowerCalculator$__constructor__(powerProfile);
    }

    public WakelockPowerCalculator(PowerProfile powerProfile) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_WakelockPowerCalculator$__constructor__(com.android.internal.os.PowerProfile ), this, powerProfile);
    }

    @Override
    public void calculateApp(BatterySipper batterySipper, BatteryStats.Uid uid, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateApp", $$robo$$com_android_internal_os_WakelockPowerCalculator$calculateApp(com.android.internal.os.BatterySipper android.os.BatteryStats$Uid long long int ), this, batterySipper, uid, l, l2, n);
    }

    @Override
    public void calculateRemaining(BatterySipper batterySipper, BatteryStats batteryStats, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateRemaining", $$robo$$com_android_internal_os_WakelockPowerCalculator$calculateRemaining(com.android.internal.os.BatterySipper android.os.BatteryStats long long int ), this, batterySipper, batteryStats, l, l2, n);
    }

    @Override
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_WakelockPowerCalculator$reset(), this);
    }

    public /* synthetic */ WakelockPowerCalculator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WakelockPowerCalculator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

