/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.FileUtils;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AtomicFile
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private File mBaseName;
    private File mBackupName;

    private void $$robo$$com_android_internal_os_AtomicFile$__constructor__(File baseName) {
        this.mBaseName = baseName;
        this.mBackupName = new File(baseName.getPath() + ".bak");
    }

    private final File $$robo$$com_android_internal_os_AtomicFile$getBaseFile() {
        return this.mBaseName;
    }

    private final FileOutputStream $$robo$$com_android_internal_os_AtomicFile$startWrite() throws IOException {
        if (this.mBaseName.exists()) {
            if (!this.mBackupName.exists()) {
                if (!this.mBaseName.renameTo(this.mBackupName)) {
                    Log.w("AtomicFile", "Couldn't rename file " + this.mBaseName + " to backup file " + this.mBackupName);
                }
            } else {
                this.mBaseName.delete();
            }
        }
        FileOutputStream str = null;
        try {
            str = new FileOutputStream(this.mBaseName);
        }
        catch (FileNotFoundException e) {
            File parent = this.mBaseName.getParentFile();
            if (!parent.mkdir()) {
                throw new IOException("Couldn't create directory " + this.mBaseName);
            }
            FileUtils.setPermissions(parent.getPath(), 505, -1, -1);
            try {
                str = new FileOutputStream(this.mBaseName);
            }
            catch (FileNotFoundException e2) {
                throw new IOException("Couldn't create " + this.mBaseName);
            }
        }
        return str;
    }

    private final void $$robo$$com_android_internal_os_AtomicFile$finishWrite(FileOutputStream str) {
        if (str != null) {
            FileUtils.sync(str);
            try {
                str.close();
                this.mBackupName.delete();
            }
            catch (IOException e) {
                Log.w("AtomicFile", "finishWrite: Got exception:", e);
            }
        }
    }

    private final void $$robo$$com_android_internal_os_AtomicFile$failWrite(FileOutputStream str) {
        if (str != null) {
            FileUtils.sync(str);
            try {
                str.close();
                this.mBaseName.delete();
                this.mBackupName.renameTo(this.mBaseName);
            }
            catch (IOException e) {
                Log.w("AtomicFile", "failWrite: Got exception:", e);
            }
        }
    }

    private final FileOutputStream $$robo$$com_android_internal_os_AtomicFile$openAppend() throws IOException {
        try {
            return new FileOutputStream(this.mBaseName, true);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Couldn't append " + this.mBaseName);
        }
    }

    private final void $$robo$$com_android_internal_os_AtomicFile$truncate() throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(this.mBaseName);
            FileUtils.sync(fos);
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new IOException("Couldn't append " + this.mBaseName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$com_android_internal_os_AtomicFile$exists() {
        return this.mBaseName.exists() || this.mBackupName.exists();
    }

    private final void $$robo$$com_android_internal_os_AtomicFile$delete() {
        this.mBaseName.delete();
        this.mBackupName.delete();
    }

    private final FileInputStream $$robo$$com_android_internal_os_AtomicFile$openRead() throws FileNotFoundException {
        if (this.mBackupName.exists()) {
            this.mBaseName.delete();
            this.mBackupName.renameTo(this.mBaseName);
        }
        return new FileInputStream(this.mBaseName);
    }

    private final byte[] $$robo$$com_android_internal_os_AtomicFile$readFully() throws IOException {
        try (FileInputStream stream = this.openRead();){
            int pos = 0;
            int avail = stream.available();
            byte[] data = new byte[avail];
            while (true) {
                int amt;
                if ((amt = stream.read(data, pos, data.length - pos)) <= 0) {
                    byte[] byArray = data;
                    return byArray;
                }
                avail = stream.available();
                if (avail <= data.length - (pos += amt)) continue;
                byte[] newData = new byte[pos + avail];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)0, (byte[])newData, (int)0, (int)pos);
                data = newData;
            }
        }
    }

    private void __constructor__(File file) {
        this.$$robo$$com_android_internal_os_AtomicFile$__constructor__(file);
    }

    public AtomicFile(File file) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_AtomicFile$__constructor__(java.io.File ), this, file);
    }

    public File getBaseFile() {
        return InvokeDynamicSupport.bootstrap("getBaseFile", $$robo$$com_android_internal_os_AtomicFile$getBaseFile(), this);
    }

    public FileOutputStream startWrite() throws IOException {
        return InvokeDynamicSupport.bootstrap("startWrite", $$robo$$com_android_internal_os_AtomicFile$startWrite(), this);
    }

    public void finishWrite(FileOutputStream fileOutputStream) {
        InvokeDynamicSupport.bootstrap("finishWrite", $$robo$$com_android_internal_os_AtomicFile$finishWrite(java.io.FileOutputStream ), this, fileOutputStream);
    }

    public void failWrite(FileOutputStream fileOutputStream) {
        InvokeDynamicSupport.bootstrap("failWrite", $$robo$$com_android_internal_os_AtomicFile$failWrite(java.io.FileOutputStream ), this, fileOutputStream);
    }

    public FileOutputStream openAppend() throws IOException {
        return InvokeDynamicSupport.bootstrap("openAppend", $$robo$$com_android_internal_os_AtomicFile$openAppend(), this);
    }

    public void truncate() throws IOException {
        InvokeDynamicSupport.bootstrap("truncate", $$robo$$com_android_internal_os_AtomicFile$truncate(), this);
    }

    public boolean exists() {
        return (boolean)InvokeDynamicSupport.bootstrap("exists", $$robo$$com_android_internal_os_AtomicFile$exists(), this);
    }

    public void delete() {
        InvokeDynamicSupport.bootstrap("delete", $$robo$$com_android_internal_os_AtomicFile$delete(), this);
    }

    public FileInputStream openRead() throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openRead", $$robo$$com_android_internal_os_AtomicFile$openRead(), this);
    }

    public byte[] readFully() throws IOException {
        return InvokeDynamicSupport.bootstrap("readFully", $$robo$$com_android_internal_os_AtomicFile$readFully(), this);
    }

    public /* synthetic */ AtomicFile() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AtomicFile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

