/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import android.graphics.Color;
import android.util.TimingLogger;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.palette.Palette;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ColorCutQuantizer
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ColorCutQuantizer";
    private static boolean LOG_TIMINGS = false;
    static int COMPONENT_RED = -3;
    static int COMPONENT_GREEN = -2;
    static int COMPONENT_BLUE = -1;
    private static int QUANTIZE_WORD_WIDTH = 5;
    private static int QUANTIZE_WORD_MASK = 31;
    int[] mColors;
    int[] mHistogram;
    List<Palette.Swatch> mQuantizedColors;
    TimingLogger mTimingLogger;
    Palette.Filter[] mFilters;
    private float[] mTempHsl;
    private static Comparator<Vbox> VBOX_COMPARATOR_VOLUME;

    private void $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$__constructor__(int[] pixels, int maxColors, Palette.Filter[] filters) {
        this.mTempHsl = new float[3];
        this.mTimingLogger = null;
        this.mFilters = filters;
        this.mHistogram = new int[32768];
        int[] hist = this.mHistogram;
        for (int i = 0; i < pixels.length; ++i) {
            int quantizedColor;
            pixels[i] = quantizedColor = ColorCutQuantizer.quantizeFromRgb888(pixels[i]);
            int n = quantizedColor;
            hist[n] = hist[n] + 1;
        }
        int distinctColorCount = 0;
        for (int color2 = 0; color2 < hist.length; ++color2) {
            if (hist[color2] > 0 && this.shouldIgnoreColor(color2)) {
                hist[color2] = 0;
            }
            if (hist[color2] <= 0) continue;
            ++distinctColorCount;
        }
        this.mColors = new int[distinctColorCount];
        int[] colors = this.mColors;
        int distinctColorIndex = 0;
        for (int color3 = 0; color3 < hist.length; ++color3) {
            if (hist[color3] <= 0) continue;
            colors[distinctColorIndex++] = color3;
        }
        if (distinctColorCount <= maxColors) {
            this.mQuantizedColors = new ArrayList<Palette.Swatch>();
            for (int color4 : colors) {
                this.mQuantizedColors.add(new Palette.Swatch(ColorCutQuantizer.approximateToRgb888(color4), hist[color4]));
            }
        } else {
            this.mQuantizedColors = this.quantizePixels(maxColors);
        }
    }

    private final List<Palette.Swatch> $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$getQuantizedColors() {
        return this.mQuantizedColors;
    }

    private final List<Palette.Swatch> $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$quantizePixels(int maxColors) {
        PriorityQueue<Vbox> pq = new PriorityQueue<Vbox>(maxColors, VBOX_COMPARATOR_VOLUME);
        pq.offer(new Vbox(this, 0, this.mColors.length - 1));
        this.splitBoxes(pq, maxColors);
        return this.generateAverageColors(pq);
    }

    private final void $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$splitBoxes(PriorityQueue<Vbox> queue, int maxSize) {
        while (queue.size() < maxSize) {
            Vbox vbox = queue.poll();
            if (vbox != null && vbox.canSplit()) {
                queue.offer(vbox.splitBox());
                queue.offer(vbox);
                continue;
            }
            return;
        }
    }

    private final List<Palette.Swatch> $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$generateAverageColors(Collection<Vbox> vboxes) {
        ArrayList<Palette.Swatch> colors = new ArrayList<Palette.Swatch>(vboxes.size());
        for (Vbox vbox : vboxes) {
            Palette.Swatch swatch = vbox.getAverageColor();
            if (this.shouldIgnoreColor(swatch)) continue;
            colors.add(swatch);
        }
        return colors;
    }

    private static final void $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$modifySignificantOctet(int[] a, int dimension, int lower, int upper) {
        switch (dimension) {
            case -3: {
                break;
            }
            case -2: {
                for (int i = lower; i <= upper; ++i) {
                    int color2 = a[i];
                    a[i] = ColorCutQuantizer.quantizedGreen(color2) << 10 | ColorCutQuantizer.quantizedRed(color2) << 5 | ColorCutQuantizer.quantizedBlue(color2);
                }
                break;
            }
            case -1: {
                for (int i = lower; i <= upper; ++i) {
                    int color3 = a[i];
                    a[i] = ColorCutQuantizer.quantizedBlue(color3) << 10 | ColorCutQuantizer.quantizedGreen(color3) << 5 | ColorCutQuantizer.quantizedRed(color3);
                }
                break;
            }
        }
    }

    private final boolean $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$shouldIgnoreColor(int color565) {
        int rgb = ColorCutQuantizer.approximateToRgb888(color565);
        ColorUtils.colorToHSL(rgb, this.mTempHsl);
        return this.shouldIgnoreColor(rgb, this.mTempHsl);
    }

    private final boolean $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$shouldIgnoreColor(Palette.Swatch color2) {
        return this.shouldIgnoreColor(color2.getRgb(), color2.getHsl());
    }

    private final boolean $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$shouldIgnoreColor(int rgb, float[] hsl) {
        if (this.mFilters != null && this.mFilters.length > 0) {
            int count = this.mFilters.length;
            for (int i = 0; i < count; ++i) {
                if (this.mFilters[i].isAllowed(rgb, hsl)) continue;
                return true;
            }
        }
        return false;
    }

    private static final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$quantizeFromRgb888(int color2) {
        int r = ColorCutQuantizer.modifyWordWidth(Color.red(color2), 8, 5);
        int g = ColorCutQuantizer.modifyWordWidth(Color.green(color2), 8, 5);
        int b = ColorCutQuantizer.modifyWordWidth(Color.blue(color2), 8, 5);
        return r << 10 | g << 5 | b;
    }

    private static final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$approximateToRgb888(int r, int g, int b) {
        return Color.rgb(ColorCutQuantizer.modifyWordWidth(r, 5, 8), ColorCutQuantizer.modifyWordWidth(g, 5, 8), ColorCutQuantizer.modifyWordWidth(b, 5, 8));
    }

    private static final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$approximateToRgb888(int color2) {
        return ColorCutQuantizer.approximateToRgb888(ColorCutQuantizer.quantizedRed(color2), ColorCutQuantizer.quantizedGreen(color2), ColorCutQuantizer.quantizedBlue(color2));
    }

    private static final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$quantizedRed(int color2) {
        return color2 >> 10 & 0x1F;
    }

    private static final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$quantizedGreen(int color2) {
        return color2 >> 5 & 0x1F;
    }

    private static final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$quantizedBlue(int color2) {
        return color2 & 0x1F;
    }

    private static final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$modifyWordWidth(int value, int currentWidth, int targetWidth) {
        int newValue = targetWidth > currentWidth ? value << targetWidth - currentWidth : value >> currentWidth - targetWidth;
        return newValue & (1 << targetWidth) - 1;
    }

    static void __staticInitializer__() {
        VBOX_COMPARATOR_VOLUME = new Comparator<Vbox>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_1$__constructor__() {
            }

            private final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_1$compare(Vbox lhs, Vbox rhs) {
                return rhs.getVolume() - lhs.getVolume();
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_1$__constructor__(), this);
            }

            @Override
            public int compare(Vbox vbox, Vbox vbox2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_1$compare(com.android.internal.graphics.palette.ColorCutQuantizer$Vbox com.android.internal.graphics.palette.ColorCutQuantizer$Vbox ), this, vbox, vbox2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int[] nArray, int n, Palette.Filter[] filterArray) {
        this.$$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$__constructor__(nArray, n, filterArray);
    }

    public ColorCutQuantizer(int[] nArray, int n, Palette.Filter[] filterArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$__constructor__(int[] int com.android.internal.graphics.palette.Palette$Filter[] ), this, nArray, n, filterArray);
    }

    List<Palette.Swatch> getQuantizedColors() {
        return InvokeDynamicSupport.bootstrap("getQuantizedColors", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$getQuantizedColors(), this);
    }

    private List<Palette.Swatch> quantizePixels(int n) {
        return InvokeDynamicSupport.bootstrap("quantizePixels", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$quantizePixels(int ), this, n);
    }

    private void splitBoxes(PriorityQueue<Vbox> priorityQueue, int n) {
        InvokeDynamicSupport.bootstrap("splitBoxes", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$splitBoxes(java.util.PriorityQueue<com.android.internal.graphics.palette.ColorCutQuantizer$Vbox> int ), this, priorityQueue, n);
    }

    private List<Palette.Swatch> generateAverageColors(Collection<Vbox> collection) {
        return InvokeDynamicSupport.bootstrap("generateAverageColors", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$generateAverageColors(java.util.Collection<com.android.internal.graphics.palette.ColorCutQuantizer$Vbox> ), this, collection);
    }

    static void modifySignificantOctet(int[] nArray, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("modifySignificantOctet", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$modifySignificantOctet(int[] int int int ), (int[])nArray, (int)n, (int)n2, (int)n3);
    }

    private boolean shouldIgnoreColor(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldIgnoreColor", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$shouldIgnoreColor(int ), this, n);
    }

    private boolean shouldIgnoreColor(Palette.Swatch swatch) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldIgnoreColor", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$shouldIgnoreColor(com.android.internal.graphics.palette.Palette$Swatch ), this, swatch);
    }

    private boolean shouldIgnoreColor(int n, float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldIgnoreColor", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$shouldIgnoreColor(int float[] ), this, n, fArray);
    }

    private static int quantizeFromRgb888(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("quantizeFromRgb888", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$quantizeFromRgb888(int ), (int)n);
    }

    static int approximateToRgb888(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("approximateToRgb888", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$approximateToRgb888(int int int ), (int)n, (int)n2, (int)n3);
    }

    private static int approximateToRgb888(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("approximateToRgb888", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$approximateToRgb888(int ), (int)n);
    }

    static int quantizedRed(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("quantizedRed", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$quantizedRed(int ), (int)n);
    }

    static int quantizedGreen(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("quantizedGreen", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$quantizedGreen(int ), (int)n);
    }

    static int quantizedBlue(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("quantizedBlue", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$quantizedBlue(int ), (int)n);
    }

    private static int modifyWordWidth(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("modifyWordWidth", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer$modifyWordWidth(int int int ), (int)n, (int)n2, (int)n3);
    }

    static {
        RobolectricInternals.classInitializing(ColorCutQuantizer.class);
    }

    public /* synthetic */ ColorCutQuantizer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ColorCutQuantizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class Vbox
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mLowerIndex;
        private int mUpperIndex;
        private int mPopulation;
        private int mMinRed;
        private int mMaxRed;
        private int mMinGreen;
        private int mMaxGreen;
        private int mMinBlue;
        private int mMaxBlue;
        /* synthetic */ ColorCutQuantizer this$0;

        private void $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$__constructor__(ColorCutQuantizer colorCutQuantizer, int lowerIndex, int upperIndex) {
            this.mLowerIndex = lowerIndex;
            this.mUpperIndex = upperIndex;
            this.fitBox();
        }

        private final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$getVolume() {
            return (this.mMaxRed - this.mMinRed + 1) * (this.mMaxGreen - this.mMinGreen + 1) * (this.mMaxBlue - this.mMinBlue + 1);
        }

        private final boolean $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$canSplit() {
            return this.getColorCount() > 1;
        }

        private final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$getColorCount() {
            return 1 + this.mUpperIndex - this.mLowerIndex;
        }

        private final void $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$fitBox() {
            int[] colors = this.this$0.mColors;
            int[] hist = this.this$0.mHistogram;
            int minBlue = Integer.MAX_VALUE;
            int minGreen = Integer.MAX_VALUE;
            int minRed = Integer.MAX_VALUE;
            int maxBlue = Integer.MIN_VALUE;
            int maxGreen = Integer.MIN_VALUE;
            int maxRed = Integer.MIN_VALUE;
            int count = 0;
            for (int i = this.mLowerIndex; i <= this.mUpperIndex; ++i) {
                int color2 = colors[i];
                count += hist[color2];
                int r = ColorCutQuantizer.quantizedRed(color2);
                int g = ColorCutQuantizer.quantizedGreen(color2);
                int b = ColorCutQuantizer.quantizedBlue(color2);
                if (r > maxRed) {
                    maxRed = r;
                }
                if (r < minRed) {
                    minRed = r;
                }
                if (g > maxGreen) {
                    maxGreen = g;
                }
                if (g < minGreen) {
                    minGreen = g;
                }
                if (b > maxBlue) {
                    maxBlue = b;
                }
                if (b >= minBlue) continue;
                minBlue = b;
            }
            this.mMinRed = minRed;
            this.mMaxRed = maxRed;
            this.mMinGreen = minGreen;
            this.mMaxGreen = maxGreen;
            this.mMinBlue = minBlue;
            this.mMaxBlue = maxBlue;
            this.mPopulation = count;
        }

        private final Vbox $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$splitBox() {
            if (!this.canSplit()) {
                throw new IllegalStateException("Can not split a box with only 1 color");
            }
            int splitPoint = this.findSplitPoint();
            Vbox newBox = new Vbox(this.this$0, splitPoint + 1, this.mUpperIndex);
            this.mUpperIndex = splitPoint;
            this.fitBox();
            return newBox;
        }

        private final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$getLongestColorDimension() {
            int redLength = this.mMaxRed - this.mMinRed;
            int greenLength = this.mMaxGreen - this.mMinGreen;
            int blueLength = this.mMaxBlue - this.mMinBlue;
            if (redLength >= greenLength && redLength >= blueLength) {
                return -3;
            }
            if (greenLength >= redLength && greenLength >= blueLength) {
                return -2;
            }
            return -1;
        }

        private final int $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$findSplitPoint() {
            int longestDimension = this.getLongestColorDimension();
            int[] colors = this.this$0.mColors;
            int[] hist = this.this$0.mHistogram;
            ColorCutQuantizer.modifySignificantOctet(colors, longestDimension, this.mLowerIndex, this.mUpperIndex);
            Arrays.sort(colors, this.mLowerIndex, this.mUpperIndex + 1);
            ColorCutQuantizer.modifySignificantOctet(colors, longestDimension, this.mLowerIndex, this.mUpperIndex);
            int midPoint = this.mPopulation / 2;
            int count = 0;
            for (int i = this.mLowerIndex; i <= this.mUpperIndex; ++i) {
                if ((count += hist[colors[i]]) < midPoint) continue;
                return i;
            }
            return this.mLowerIndex;
        }

        private final Palette.Swatch $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$getAverageColor() {
            int[] colors = this.this$0.mColors;
            int[] hist = this.this$0.mHistogram;
            int redSum = 0;
            int greenSum = 0;
            int blueSum = 0;
            int totalPopulation = 0;
            for (int i = this.mLowerIndex; i <= this.mUpperIndex; ++i) {
                int color2 = colors[i];
                int colorPopulation = hist[color2];
                totalPopulation += colorPopulation;
                redSum += colorPopulation * ColorCutQuantizer.quantizedRed(color2);
                greenSum += colorPopulation * ColorCutQuantizer.quantizedGreen(color2);
                blueSum += colorPopulation * ColorCutQuantizer.quantizedBlue(color2);
            }
            int redMean = Math.round((float)redSum / (float)totalPopulation);
            int greenMean = Math.round((float)greenSum / (float)totalPopulation);
            int blueMean = Math.round((float)blueSum / (float)totalPopulation);
            return new Palette.Swatch(ColorCutQuantizer.approximateToRgb888(redMean, greenMean, blueMean), totalPopulation);
        }

        private void __constructor__(ColorCutQuantizer colorCutQuantizer, int n, int n2) {
            this.$$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$__constructor__(colorCutQuantizer, n, n2);
        }

        public Vbox(ColorCutQuantizer colorCutQuantizer, int n, int n2) {
            this.this$0 = colorCutQuantizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$__constructor__(com.android.internal.graphics.palette.ColorCutQuantizer int int ), this, colorCutQuantizer, n, n2);
        }

        int getVolume() {
            return (int)InvokeDynamicSupport.bootstrap("getVolume", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$getVolume(), this);
        }

        boolean canSplit() {
            return (boolean)InvokeDynamicSupport.bootstrap("canSplit", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$canSplit(), this);
        }

        int getColorCount() {
            return (int)InvokeDynamicSupport.bootstrap("getColorCount", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$getColorCount(), this);
        }

        void fitBox() {
            InvokeDynamicSupport.bootstrap("fitBox", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$fitBox(), this);
        }

        Vbox splitBox() {
            return InvokeDynamicSupport.bootstrap("splitBox", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$splitBox(), this);
        }

        int getLongestColorDimension() {
            return (int)InvokeDynamicSupport.bootstrap("getLongestColorDimension", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$getLongestColorDimension(), this);
        }

        int findSplitPoint() {
            return (int)InvokeDynamicSupport.bootstrap("findSplitPoint", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$findSplitPoint(), this);
        }

        Palette.Swatch getAverageColor() {
            return InvokeDynamicSupport.bootstrap("getAverageColor", $$robo$$com_android_internal_graphics_palette_ColorCutQuantizer_Vbox$getAverageColor(), this);
        }

        public /* synthetic */ Vbox() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Vbox)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

