/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.icu.text.ListFormatter;
import android.icu.util.ULocale;
import android.os.LocaleList;
import android.text.TextUtils;
import com.android.internal.app.LocaleStore;
import com.google.errorprone.annotations.DoNotMock;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import libcore.icu.ICU;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocaleHelper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;

    private void $$robo$$com_android_internal_app_LocaleHelper$__constructor__() {
    }

    private static final String $$robo$$com_android_internal_app_LocaleHelper$toSentenceCase(String str, Locale locale) {
        if (str.isEmpty()) {
            return str;
        }
        int firstCodePointLen = str.offsetByCodePoints(0, 1);
        return str.substring(0, firstCodePointLen).toUpperCase(locale) + str.substring(firstCodePointLen);
    }

    private static final String $$robo$$com_android_internal_app_LocaleHelper$normalizeForSearch(String str, Locale locale) {
        return str.toUpperCase();
    }

    private static final boolean $$robo$$com_android_internal_app_LocaleHelper$shouldUseDialectName(Locale locale) {
        String lang = locale.getLanguage();
        return "fa".equals(lang) || "ro".equals(lang) || "zh".equals(lang);
    }

    private static final String $$robo$$com_android_internal_app_LocaleHelper$getDisplayName(Locale locale, Locale displayLocale, boolean sentenceCase) {
        ULocale displayULocale = ULocale.forLocale(displayLocale);
        String result = LocaleHelper.shouldUseDialectName(locale) ? ULocale.getDisplayNameWithDialect(locale.toLanguageTag(), displayULocale) : ULocale.getDisplayName(locale.toLanguageTag(), displayULocale);
        return sentenceCase ? LocaleHelper.toSentenceCase(result, displayLocale) : result;
    }

    private static final String $$robo$$com_android_internal_app_LocaleHelper$getDisplayName(Locale locale, boolean sentenceCase) {
        return LocaleHelper.getDisplayName(locale, Locale.getDefault(), sentenceCase);
    }

    private static final String $$robo$$com_android_internal_app_LocaleHelper$getDisplayCountry(Locale locale, Locale displayLocale) {
        return ULocale.getDisplayCountry(locale.toLanguageTag(), ULocale.forLocale(displayLocale));
    }

    private static final String $$robo$$com_android_internal_app_LocaleHelper$getDisplayCountry(Locale locale) {
        return ULocale.getDisplayCountry(locale.toLanguageTag(), ULocale.getDefault());
    }

    private static final String $$robo$$com_android_internal_app_LocaleHelper$getDisplayLocaleList(LocaleList locales, Locale displayLocale, int maxLocales) {
        int listCount;
        int localeCount;
        boolean ellipsisNeeded;
        Locale dispLocale = displayLocale == null ? Locale.getDefault() : displayLocale;
        boolean bl = ellipsisNeeded = locales.size() > maxLocales;
        if (ellipsisNeeded) {
            localeCount = maxLocales;
            listCount = maxLocales + 1;
        } else {
            listCount = localeCount = locales.size();
        }
        String[] localeNames = new String[listCount];
        for (int i = 0; i < localeCount; ++i) {
            localeNames[i] = LocaleHelper.getDisplayName(locales.get(i), dispLocale, false);
        }
        if (ellipsisNeeded) {
            localeNames[maxLocales] = TextUtils.ELLIPSIS_STRING;
        }
        ListFormatter lfn = ListFormatter.getInstance(dispLocale);
        return lfn.format(localeNames);
    }

    private static final Locale $$robo$$com_android_internal_app_LocaleHelper$addLikelySubtags(Locale locale) {
        return ICU.addLikelySubtags(locale);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_LocaleHelper$__constructor__();
    }

    public LocaleHelper() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_LocaleHelper$__constructor__(), this);
    }

    public static String toSentenceCase(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("toSentenceCase", $$robo$$com_android_internal_app_LocaleHelper$toSentenceCase(java.lang.String java.util.Locale ), (String)string2, (Locale)locale);
    }

    public static String normalizeForSearch(String string2, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("normalizeForSearch", $$robo$$com_android_internal_app_LocaleHelper$normalizeForSearch(java.lang.String java.util.Locale ), (String)string2, (Locale)locale);
    }

    private static boolean shouldUseDialectName(Locale locale) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldUseDialectName", $$robo$$com_android_internal_app_LocaleHelper$shouldUseDialectName(java.util.Locale ), (Locale)locale);
    }

    public static String getDisplayName(Locale locale, Locale locale2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$com_android_internal_app_LocaleHelper$getDisplayName(java.util.Locale java.util.Locale boolean ), (Locale)locale, (Locale)locale2, (boolean)bl);
    }

    public static String getDisplayName(Locale locale, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayName", $$robo$$com_android_internal_app_LocaleHelper$getDisplayName(java.util.Locale boolean ), (Locale)locale, (boolean)bl);
    }

    public static String getDisplayCountry(Locale locale, Locale locale2) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayCountry", $$robo$$com_android_internal_app_LocaleHelper$getDisplayCountry(java.util.Locale java.util.Locale ), (Locale)locale, (Locale)locale2);
    }

    public static String getDisplayCountry(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayCountry", $$robo$$com_android_internal_app_LocaleHelper$getDisplayCountry(java.util.Locale ), (Locale)locale);
    }

    public static String getDisplayLocaleList(LocaleList localeList, Locale locale, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDisplayLocaleList", $$robo$$com_android_internal_app_LocaleHelper$getDisplayLocaleList(android.os.LocaleList java.util.Locale int ), (LocaleList)localeList, (Locale)locale, (int)n);
    }

    public static Locale addLikelySubtags(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("addLikelySubtags", $$robo$$com_android_internal_app_LocaleHelper$addLikelySubtags(java.util.Locale ), (Locale)locale);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class LocaleInfoComparator
    implements Comparator<LocaleStore.LocaleInfo> {
        public /* synthetic */ Object __robo_data__;
        private Collator mCollator;
        private boolean mCountryMode;
        private static String PREFIX_ARABIC = "\u0627\u0644";

        private void $$robo$$com_android_internal_app_LocaleHelper_LocaleInfoComparator$__constructor__(Locale sortLocale, boolean countryMode) {
            this.mCollator = Collator.getInstance(sortLocale);
            this.mCountryMode = countryMode;
        }

        private final String $$robo$$com_android_internal_app_LocaleHelper_LocaleInfoComparator$removePrefixForCompare(Locale locale, String str) {
            if ("ar".equals(locale.getLanguage()) && str.startsWith("\u0627\u0644")) {
                return str.substring("\u0627\u0644".length());
            }
            return str;
        }

        private final int $$robo$$com_android_internal_app_LocaleHelper_LocaleInfoComparator$compare(LocaleStore.LocaleInfo lhs, LocaleStore.LocaleInfo rhs) {
            if (lhs.isSuggested() == rhs.isSuggested()) {
                return this.mCollator.compare(this.removePrefixForCompare(lhs.getLocale(), lhs.getLabel(this.mCountryMode)), this.removePrefixForCompare(rhs.getLocale(), rhs.getLabel(this.mCountryMode)));
            }
            return lhs.isSuggested() ? -1 : 1;
        }

        private void __constructor__(Locale locale, boolean bl) {
            this.$$robo$$com_android_internal_app_LocaleHelper_LocaleInfoComparator$__constructor__(locale, bl);
        }

        public LocaleInfoComparator(Locale locale, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_LocaleHelper_LocaleInfoComparator$__constructor__(java.util.Locale boolean ), this, locale, bl);
        }

        private String removePrefixForCompare(Locale locale, String string2) {
            return InvokeDynamicSupport.bootstrap("removePrefixForCompare", $$robo$$com_android_internal_app_LocaleHelper_LocaleInfoComparator$removePrefixForCompare(java.util.Locale java.lang.String ), this, locale, string2);
        }

        @Override
        public int compare(LocaleStore.LocaleInfo localeInfo, LocaleStore.LocaleInfo localeInfo2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_app_LocaleHelper_LocaleInfoComparator$compare(com.android.internal.app.LocaleStore$LocaleInfo com.android.internal.app.LocaleStore$LocaleInfo ), this, localeInfo, localeInfo2);
        }

        public /* synthetic */ LocaleInfoComparator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleInfoComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

