/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStub;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.app.MicroAlertController;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AlertController
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int MICRO = 1;
    private Context mContext;
    private DialogInterface mDialogInterface;
    protected Window mWindow;
    private CharSequence mTitle;
    protected CharSequence mMessage;
    protected ListView mListView;
    private View mView;
    private int mViewLayoutResId;
    private int mViewSpacingLeft;
    private int mViewSpacingTop;
    private int mViewSpacingRight;
    private int mViewSpacingBottom;
    private boolean mViewSpacingSpecified;
    private Button mButtonPositive;
    private CharSequence mButtonPositiveText;
    private Message mButtonPositiveMessage;
    private Button mButtonNegative;
    private CharSequence mButtonNegativeText;
    private Message mButtonNegativeMessage;
    private Button mButtonNeutral;
    private CharSequence mButtonNeutralText;
    private Message mButtonNeutralMessage;
    protected ScrollView mScrollView;
    private int mIconId;
    private Drawable mIcon;
    private ImageView mIconView;
    private TextView mTitleView;
    protected TextView mMessageView;
    private View mCustomTitleView;
    private boolean mForceInverseBackground;
    private ListAdapter mAdapter;
    private int mCheckedItem;
    private int mAlertDialogLayout;
    private int mButtonPanelSideLayout;
    private int mListLayout;
    private int mMultiChoiceItemLayout;
    private int mSingleChoiceItemLayout;
    private int mListItemLayout;
    private boolean mShowTitle;
    private int mButtonPanelLayoutHint;
    private Handler mHandler;
    private View.OnClickListener mButtonHandler;

    private static final boolean $$robo$$com_android_internal_app_AlertController$shouldCenterSingleButton(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x111000A, outValue, true);
        return outValue.data != 0;
    }

    private static final AlertController $$robo$$com_android_internal_app_AlertController$create(Context context, DialogInterface di, Window window) {
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.AlertDialog, 16842845, 0);
        int controllerType = a.getInt(12, 0);
        a.recycle();
        switch (controllerType) {
            case 1: {
                return new MicroAlertController(context, di, window);
            }
        }
        return new AlertController(context, di, window);
    }

    private void $$robo$$com_android_internal_app_AlertController$__constructor__(Context context, DialogInterface di, Window window) {
        this.mViewSpacingSpecified = false;
        this.mIconId = 0;
        this.mCheckedItem = -1;
        this.mButtonPanelLayoutHint = 0;
        this.mButtonHandler = new View.OnClickListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AlertController this$0;

            private void $$robo$$com_android_internal_app_AlertController_1$__constructor__(AlertController this$0) {
            }

            private final void $$robo$$com_android_internal_app_AlertController_1$onClick(View v) {
                Message m = v == this.this$0.mButtonPositive && this.this$0.mButtonPositiveMessage != null ? Message.obtain(this.this$0.mButtonPositiveMessage) : (v == this.this$0.mButtonNegative && this.this$0.mButtonNegativeMessage != null ? Message.obtain(this.this$0.mButtonNegativeMessage) : (v == this.this$0.mButtonNeutral && this.this$0.mButtonNeutralMessage != null ? Message.obtain(this.this$0.mButtonNeutralMessage) : null));
                if (m != null) {
                    m.sendToTarget();
                }
                this.this$0.mHandler.obtainMessage(1, this.this$0.mDialogInterface).sendToTarget();
            }

            private void __constructor__(AlertController alertController) {
                this.$$robo$$com_android_internal_app_AlertController_1$__constructor__(alertController);
            }
            {
                this.this$0 = alertController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_1$__constructor__(com.android.internal.app.AlertController ), this, alertController);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_app_AlertController_1$onClick(android.view.View ), this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mDialogInterface = di;
        this.mWindow = window;
        this.mHandler = new ButtonHandler(di);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.AlertDialog, 16842845, 0);
        this.mAlertDialogLayout = a.getResourceId(10, 17367080);
        this.mButtonPanelSideLayout = a.getResourceId(11, 0);
        this.mListLayout = a.getResourceId(15, 17367259);
        this.mMultiChoiceItemLayout = a.getResourceId(16, 17367059);
        this.mSingleChoiceItemLayout = a.getResourceId(21, 17367058);
        this.mListItemLayout = a.getResourceId(14, 0x1090011);
        this.mShowTitle = a.getBoolean(20, true);
        a.recycle();
        window.requestFeature(1);
    }

    private static final boolean $$robo$$com_android_internal_app_AlertController$canTextInput(View v) {
        if (v.onCheckIsTextEditor()) {
            return true;
        }
        if (!(v instanceof ViewGroup)) {
            return false;
        }
        ViewGroup vg = (ViewGroup)v;
        int i = vg.getChildCount();
        while (i > 0) {
            if (!AlertController.canTextInput(v = vg.getChildAt(--i))) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_app_AlertController$installContent(AlertParams params) {
        params.apply(this);
        this.installContent();
    }

    private final void $$robo$$com_android_internal_app_AlertController$installContent() {
        int contentView = this.selectContentView();
        this.mWindow.setContentView(contentView);
        this.setupView();
    }

    private final int $$robo$$com_android_internal_app_AlertController$selectContentView() {
        if (this.mButtonPanelSideLayout == 0) {
            return this.mAlertDialogLayout;
        }
        if (this.mButtonPanelLayoutHint == 1) {
            return this.mButtonPanelSideLayout;
        }
        return this.mAlertDialogLayout;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setTitle(CharSequence title) {
        this.mTitle = title;
        if (this.mTitleView != null) {
            this.mTitleView.setText(title);
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setCustomTitle(View customTitleView) {
        this.mCustomTitleView = customTitleView;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setMessage(CharSequence message) {
        this.mMessage = message;
        if (this.mMessageView != null) {
            this.mMessageView.setText(message);
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setView(int layoutResId) {
        this.mView = null;
        this.mViewLayoutResId = layoutResId;
        this.mViewSpacingSpecified = false;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setView(View view) {
        this.mView = view;
        this.mViewLayoutResId = 0;
        this.mViewSpacingSpecified = false;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setView(View view, int viewSpacingLeft, int viewSpacingTop, int viewSpacingRight, int viewSpacingBottom) {
        this.mView = view;
        this.mViewLayoutResId = 0;
        this.mViewSpacingSpecified = true;
        this.mViewSpacingLeft = viewSpacingLeft;
        this.mViewSpacingTop = viewSpacingTop;
        this.mViewSpacingRight = viewSpacingRight;
        this.mViewSpacingBottom = viewSpacingBottom;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setButtonPanelLayoutHint(int layoutHint) {
        this.mButtonPanelLayoutHint = layoutHint;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setButton(int whichButton, CharSequence text, DialogInterface.OnClickListener listener, Message msg) {
        if (msg == null && listener != null) {
            msg = this.mHandler.obtainMessage(whichButton, listener);
        }
        switch (whichButton) {
            case -1: {
                this.mButtonPositiveText = text;
                this.mButtonPositiveMessage = msg;
                break;
            }
            case -2: {
                this.mButtonNegativeText = text;
                this.mButtonNegativeMessage = msg;
                break;
            }
            case -3: {
                this.mButtonNeutralText = text;
                this.mButtonNeutralMessage = msg;
                break;
            }
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setIcon(int resId) {
        this.mIcon = null;
        this.mIconId = resId;
        if (this.mIconView != null) {
            if (resId != 0) {
                this.mIconView.setVisibility(0);
                this.mIconView.setImageResource(this.mIconId);
            } else {
                this.mIconView.setVisibility(8);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setIcon(Drawable icon) {
        this.mIcon = icon;
        this.mIconId = 0;
        if (this.mIconView != null) {
            if (icon != null) {
                this.mIconView.setVisibility(0);
                this.mIconView.setImageDrawable(icon);
            } else {
                this.mIconView.setVisibility(8);
            }
        }
    }

    private final int $$robo$$com_android_internal_app_AlertController$getIconAttributeResId(int attrId) {
        TypedValue out = new TypedValue();
        this.mContext.getTheme().resolveAttribute(attrId, out, true);
        return out.resourceId;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setInverseBackgroundForced(boolean forceInverseBackground) {
        this.mForceInverseBackground = forceInverseBackground;
    }

    private final ListView $$robo$$com_android_internal_app_AlertController$getListView() {
        return this.mListView;
    }

    private final Button $$robo$$com_android_internal_app_AlertController$getButton(int whichButton) {
        switch (whichButton) {
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: {
                return this.mButtonNeutral;
            }
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_app_AlertController$onKeyDown(int keyCode, KeyEvent event) {
        return this.mScrollView != null && this.mScrollView.executeKeyEvent(event);
    }

    private final boolean $$robo$$com_android_internal_app_AlertController$onKeyUp(int keyCode, KeyEvent event) {
        return this.mScrollView != null && this.mScrollView.executeKeyEvent(event);
    }

    private final ViewGroup $$robo$$com_android_internal_app_AlertController$resolvePanel(View customPanel, View defaultPanel) {
        ViewParent parent;
        if (customPanel == null) {
            if (defaultPanel instanceof ViewStub) {
                defaultPanel = ((ViewStub)defaultPanel).inflate();
            }
            return (ViewGroup)defaultPanel;
        }
        if (defaultPanel != null && (parent = defaultPanel.getParent()) instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(defaultPanel);
        }
        if (customPanel instanceof ViewStub) {
            customPanel = ((ViewStub)customPanel).inflate();
        }
        return (ViewGroup)customPanel;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setupView() {
        Object spacer;
        boolean hasButtonPanel;
        Object parentPanel = this.mWindow.findViewById(16909134);
        Object defaultTopPanel = ((View)parentPanel).findViewById(16909382);
        Object defaultContentPanel = ((View)parentPanel).findViewById(0x1020200);
        Object defaultButtonPanel = ((View)parentPanel).findViewById(16908756);
        ViewGroup customPanel = (ViewGroup)((View)parentPanel).findViewById(16908807);
        this.setupCustomContent(customPanel);
        Object customTopPanel = customPanel.findViewById(16909382);
        Object customContentPanel = customPanel.findViewById(0x1020200);
        Object customButtonPanel = customPanel.findViewById(16908756);
        ViewGroup topPanel = this.resolvePanel((View)customTopPanel, (View)defaultTopPanel);
        ViewGroup contentPanel = this.resolvePanel((View)customContentPanel, (View)defaultContentPanel);
        ViewGroup buttonPanel = this.resolvePanel((View)customButtonPanel, (View)defaultButtonPanel);
        this.setupContent(contentPanel);
        this.setupButtons(buttonPanel);
        this.setupTitle(topPanel);
        boolean hasCustomPanel = customPanel != null && customPanel.getVisibility() != 8;
        boolean hasTopPanel = topPanel != null && topPanel.getVisibility() != 8;
        boolean bl = hasButtonPanel = buttonPanel != null && buttonPanel.getVisibility() != 8;
        if (!hasButtonPanel) {
            if (contentPanel != null && (spacer = contentPanel.findViewById(16909349)) != null) {
                ((View)spacer).setVisibility(0);
            }
            this.mWindow.setCloseOnTouchOutsideIfNotSet(true);
        }
        if (hasTopPanel) {
            if (this.mScrollView != null) {
                this.mScrollView.setClipToPadding(true);
            }
            View divider = null;
            if (this.mMessage != null || this.mListView != null || hasCustomPanel) {
                if (!hasCustomPanel) {
                    divider = (View)topPanel.findViewById(16909367);
                }
                if (divider == null) {
                    divider = (View)topPanel.findViewById(16909366);
                }
            } else {
                divider = (View)topPanel.findViewById(16909368);
            }
            if (divider != null) {
                divider.setVisibility(0);
            }
        } else if (contentPanel != null && (spacer = contentPanel.findViewById(16909350)) != null) {
            ((View)spacer).setVisibility(0);
        }
        if (this.mListView instanceof RecycleListView) {
            ((RecycleListView)this.mListView).setHasDecor(hasTopPanel, hasButtonPanel);
        }
        if (!hasCustomPanel) {
            ViewGroup content;
            ViewGroup viewGroup = content = this.mListView != null ? this.mListView : this.mScrollView;
            if (content != null) {
                int indicators = (hasTopPanel ? 1 : 0) | (hasButtonPanel ? 2 : 0);
                content.setScrollIndicators(indicators, 3);
            }
        }
        TypedArray a = this.mContext.obtainStyledAttributes(null, R.styleable.AlertDialog, 16842845, 0);
        this.setBackground(a, topPanel, contentPanel, customPanel, buttonPanel, hasTopPanel, hasCustomPanel, hasButtonPanel);
        a.recycle();
    }

    private final void $$robo$$com_android_internal_app_AlertController$setupCustomContent(ViewGroup customPanel) {
        boolean hasCustomView;
        View customView;
        if (this.mView != null) {
            customView = this.mView;
        } else if (this.mViewLayoutResId != 0) {
            LayoutInflater inflater = LayoutInflater.from(this.mContext);
            customView = inflater.inflate(this.mViewLayoutResId, customPanel, false);
        } else {
            customView = null;
        }
        boolean bl = hasCustomView = customView != null;
        if (!hasCustomView || !AlertController.canTextInput(customView)) {
            this.mWindow.setFlags(131072, 131072);
        }
        if (hasCustomView) {
            FrameLayout custom = (FrameLayout)this.mWindow.findViewById(16908331);
            custom.addView(customView, new ViewGroup.LayoutParams(-1, -1));
            if (this.mViewSpacingSpecified) {
                custom.setPadding(this.mViewSpacingLeft, this.mViewSpacingTop, this.mViewSpacingRight, this.mViewSpacingBottom);
            }
            if (this.mListView != null) {
                ((LinearLayout.LayoutParams)customPanel.getLayoutParams()).weight = 0.0f;
            }
        } else {
            customPanel.setVisibility(8);
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setupTitle(ViewGroup topPanel) {
        if (this.mCustomTitleView != null && this.mShowTitle) {
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -2);
            topPanel.addView(this.mCustomTitleView, 0, lp);
            Object titleTemplate = this.mWindow.findViewById(16909372);
            ((View)titleTemplate).setVisibility(8);
        } else {
            boolean hasTextTitle;
            this.mIconView = (ImageView)this.mWindow.findViewById(16908294);
            boolean bl = hasTextTitle = !TextUtils.isEmpty(this.mTitle);
            if (hasTextTitle && this.mShowTitle) {
                this.mTitleView = (TextView)this.mWindow.findViewById(16908696);
                this.mTitleView.setText(this.mTitle);
                if (this.mIconId != 0) {
                    this.mIconView.setImageResource(this.mIconId);
                } else if (this.mIcon != null) {
                    this.mIconView.setImageDrawable(this.mIcon);
                } else {
                    this.mTitleView.setPadding(this.mIconView.getPaddingLeft(), this.mIconView.getPaddingTop(), this.mIconView.getPaddingRight(), this.mIconView.getPaddingBottom());
                    this.mIconView.setVisibility(8);
                }
            } else {
                Object titleTemplate = this.mWindow.findViewById(16909372);
                ((View)titleTemplate).setVisibility(8);
                this.mIconView.setVisibility(8);
                topPanel.setVisibility(8);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setupContent(ViewGroup contentPanel) {
        this.mScrollView = (ScrollView)contentPanel.findViewById(16909220);
        this.mScrollView.setFocusable(false);
        this.mMessageView = (TextView)contentPanel.findViewById(16908299);
        if (this.mMessageView == null) {
            return;
        }
        if (this.mMessage != null) {
            this.mMessageView.setText(this.mMessage);
        } else {
            this.mMessageView.setVisibility(8);
            this.mScrollView.removeView(this.mMessageView);
            if (this.mListView != null) {
                ViewGroup scrollParent = (ViewGroup)this.mScrollView.getParent();
                int childIndex = scrollParent.indexOfChild(this.mScrollView);
                scrollParent.removeViewAt(childIndex);
                scrollParent.addView((View)this.mListView, childIndex, new ViewGroup.LayoutParams(-1, -1));
            } else {
                contentPanel.setVisibility(8);
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_AlertController$manageScrollIndicators(View v, View upIndicator, View downIndicator) {
        if (upIndicator != null) {
            upIndicator.setVisibility(v.canScrollVertically(-1) ? 0 : 4);
        }
        if (downIndicator != null) {
            downIndicator.setVisibility(v.canScrollVertically(1) ? 0 : 4);
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setupButtons(ViewGroup buttonPanel) {
        boolean hasButtons;
        int BIT_BUTTON_POSITIVE = 1;
        int BIT_BUTTON_NEGATIVE = 2;
        int BIT_BUTTON_NEUTRAL = 4;
        int whichButtons = 0;
        this.mButtonPositive = (Button)buttonPanel.findViewById(16908313);
        this.mButtonPositive.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonPositiveText)) {
            this.mButtonPositive.setVisibility(8);
        } else {
            this.mButtonPositive.setText(this.mButtonPositiveText);
            this.mButtonPositive.setVisibility(0);
            whichButtons |= BIT_BUTTON_POSITIVE;
        }
        this.mButtonNegative = (Button)buttonPanel.findViewById(16908314);
        this.mButtonNegative.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonNegativeText)) {
            this.mButtonNegative.setVisibility(8);
        } else {
            this.mButtonNegative.setText(this.mButtonNegativeText);
            this.mButtonNegative.setVisibility(0);
            whichButtons |= BIT_BUTTON_NEGATIVE;
        }
        this.mButtonNeutral = (Button)buttonPanel.findViewById(16908315);
        this.mButtonNeutral.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonNeutralText)) {
            this.mButtonNeutral.setVisibility(8);
        } else {
            this.mButtonNeutral.setText(this.mButtonNeutralText);
            this.mButtonNeutral.setVisibility(0);
            whichButtons |= BIT_BUTTON_NEUTRAL;
        }
        if (AlertController.shouldCenterSingleButton(this.mContext)) {
            if (whichButtons == BIT_BUTTON_POSITIVE) {
                this.centerButton(this.mButtonPositive);
            } else if (whichButtons == BIT_BUTTON_NEGATIVE) {
                this.centerButton(this.mButtonNegative);
            } else if (whichButtons == BIT_BUTTON_NEUTRAL) {
                this.centerButton(this.mButtonNeutral);
            }
        }
        boolean bl = hasButtons = whichButtons != 0;
        if (!hasButtons) {
            buttonPanel.setVisibility(8);
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$centerButton(Button button) {
        Object rightSpacer;
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)button.getLayoutParams();
        params.gravity = 1;
        params.weight = 0.5f;
        button.setLayoutParams(params);
        Object leftSpacer = this.mWindow.findViewById(16909005);
        if (leftSpacer != null) {
            ((View)leftSpacer).setVisibility(0);
        }
        if ((rightSpacer = this.mWindow.findViewById(16909202)) != null) {
            ((View)rightSpacer).setVisibility(0);
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setBackground(TypedArray a, View topPanel, View contentPanel, View customPanel, View buttonPanel, boolean hasTitle, boolean hasCustomView, boolean hasButtons) {
        ListView listView;
        int fullDark = 0;
        int topDark = 0;
        int centerDark = 0;
        int bottomDark = 0;
        int fullBright = 0;
        int topBright = 0;
        int centerBright = 0;
        int bottomBright = 0;
        int bottomMedium = 0;
        boolean needsDefaultBackgrounds = a.getBoolean(17, true);
        if (needsDefaultBackgrounds) {
            fullDark = 17303040;
            topDark = 17303054;
            centerDark = 17303037;
            bottomDark = 17303034;
            fullBright = 17303039;
            topBright = 17303053;
            centerBright = 17303036;
            bottomBright = 17303033;
            bottomMedium = 17303035;
        }
        topBright = a.getResourceId(5, topBright);
        topDark = a.getResourceId(1, topDark);
        centerBright = a.getResourceId(6, centerBright);
        centerDark = a.getResourceId(2, centerDark);
        View[] views = new View[4];
        boolean[] light = new boolean[4];
        View lastView = null;
        boolean lastLight = false;
        int pos = 0;
        if (hasTitle) {
            views[pos] = topPanel;
            light[pos] = false;
            ++pos;
        }
        views[pos] = contentPanel.getVisibility() == 8 ? null : contentPanel;
        light[pos] = this.mListView != null;
        ++pos;
        if (hasCustomView) {
            views[pos] = customPanel;
            light[pos] = this.mForceInverseBackground;
            ++pos;
        }
        if (hasButtons) {
            views[pos] = buttonPanel;
            light[pos] = true;
        }
        boolean setView = false;
        for (pos = 0; pos < views.length; ++pos) {
            View v = views[pos];
            if (v == null) continue;
            if (lastView != null) {
                if (!setView) {
                    lastView.setBackgroundResource(lastLight ? topBright : topDark);
                } else {
                    lastView.setBackgroundResource(lastLight ? centerBright : centerDark);
                }
                setView = true;
            }
            lastView = v;
            lastLight = light[pos];
        }
        if (lastView != null) {
            if (setView) {
                bottomBright = a.getResourceId(7, bottomBright);
                bottomMedium = a.getResourceId(8, bottomMedium);
                bottomDark = a.getResourceId(3, bottomDark);
                lastView.setBackgroundResource(lastLight ? (hasButtons ? bottomMedium : bottomBright) : bottomDark);
            } else {
                fullBright = a.getResourceId(4, fullBright);
                fullDark = a.getResourceId(0, fullDark);
                lastView.setBackgroundResource(lastLight ? fullBright : fullDark);
            }
        }
        if ((listView = this.mListView) != null && this.mAdapter != null) {
            listView.setAdapter(this.mAdapter);
            int checkedItem = this.mCheckedItem;
            if (checkedItem > -1) {
                listView.setItemChecked(checkedItem, true);
                listView.setSelectionFromTop(checkedItem, a.getDimensionPixelSize(19, 0));
            }
        }
    }

    private static boolean shouldCenterSingleButton(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldCenterSingleButton", $$robo$$com_android_internal_app_AlertController$shouldCenterSingleButton(android.content.Context ), (Context)context);
    }

    public static AlertController create(Context context, DialogInterface dialogInterface, Window window) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$com_android_internal_app_AlertController$create(android.content.Context android.content.DialogInterface android.view.Window ), (Context)context, (DialogInterface)dialogInterface, (Window)window);
    }

    private void __constructor__(Context context, DialogInterface dialogInterface, Window window) {
        this.$$robo$$com_android_internal_app_AlertController$__constructor__(context, dialogInterface, window);
    }

    public AlertController(Context context, DialogInterface dialogInterface, Window window) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController$__constructor__(android.content.Context android.content.DialogInterface android.view.Window ), this, context, dialogInterface, window);
    }

    static boolean canTextInput(View view) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canTextInput", $$robo$$com_android_internal_app_AlertController$canTextInput(android.view.View ), (View)view);
    }

    public void installContent(AlertParams alertParams) {
        InvokeDynamicSupport.bootstrap("installContent", $$robo$$com_android_internal_app_AlertController$installContent(com.android.internal.app.AlertController$AlertParams ), this, alertParams);
    }

    public void installContent() {
        InvokeDynamicSupport.bootstrap("installContent", $$robo$$com_android_internal_app_AlertController$installContent(), this);
    }

    private int selectContentView() {
        return (int)InvokeDynamicSupport.bootstrap("selectContentView", $$robo$$com_android_internal_app_AlertController$selectContentView(), this);
    }

    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_app_AlertController$setTitle(java.lang.CharSequence ), this, charSequence);
    }

    public void setCustomTitle(View view) {
        InvokeDynamicSupport.bootstrap("setCustomTitle", $$robo$$com_android_internal_app_AlertController$setCustomTitle(android.view.View ), this, view);
    }

    public void setMessage(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setMessage", $$robo$$com_android_internal_app_AlertController$setMessage(java.lang.CharSequence ), this, charSequence);
    }

    public void setView(int n) {
        InvokeDynamicSupport.bootstrap("setView", $$robo$$com_android_internal_app_AlertController$setView(int ), this, n);
    }

    public void setView(View view) {
        InvokeDynamicSupport.bootstrap("setView", $$robo$$com_android_internal_app_AlertController$setView(android.view.View ), this, view);
    }

    public void setView(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setView", $$robo$$com_android_internal_app_AlertController$setView(android.view.View int int int int ), this, view, n, n2, n3, n4);
    }

    public void setButtonPanelLayoutHint(int n) {
        InvokeDynamicSupport.bootstrap("setButtonPanelLayoutHint", $$robo$$com_android_internal_app_AlertController$setButtonPanelLayoutHint(int ), this, n);
    }

    public void setButton(int n, CharSequence charSequence, DialogInterface.OnClickListener onClickListener, Message message) {
        InvokeDynamicSupport.bootstrap("setButton", $$robo$$com_android_internal_app_AlertController$setButton(int java.lang.CharSequence android.content.DialogInterface$OnClickListener android.os.Message ), this, n, charSequence, onClickListener, message);
    }

    public void setIcon(int n) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_app_AlertController$setIcon(int ), this, n);
    }

    public void setIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_app_AlertController$setIcon(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public int getIconAttributeResId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIconAttributeResId", $$robo$$com_android_internal_app_AlertController$getIconAttributeResId(int ), this, n);
    }

    public void setInverseBackgroundForced(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInverseBackgroundForced", $$robo$$com_android_internal_app_AlertController$setInverseBackgroundForced(boolean ), this, bl);
    }

    public ListView getListView() {
        return InvokeDynamicSupport.bootstrap("getListView", $$robo$$com_android_internal_app_AlertController$getListView(), this);
    }

    public Button getButton(int n) {
        return InvokeDynamicSupport.bootstrap("getButton", $$robo$$com_android_internal_app_AlertController$getButton(int ), this, n);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$com_android_internal_app_AlertController$onKeyDown(int android.view.KeyEvent ), this, n, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$com_android_internal_app_AlertController$onKeyUp(int android.view.KeyEvent ), this, n, keyEvent);
    }

    private ViewGroup resolvePanel(View view, View view2) {
        return InvokeDynamicSupport.bootstrap("resolvePanel", $$robo$$com_android_internal_app_AlertController$resolvePanel(android.view.View android.view.View ), this, view, view2);
    }

    private void setupView() {
        InvokeDynamicSupport.bootstrap("setupView", $$robo$$com_android_internal_app_AlertController$setupView(), this);
    }

    private void setupCustomContent(ViewGroup viewGroup) {
        InvokeDynamicSupport.bootstrap("setupCustomContent", $$robo$$com_android_internal_app_AlertController$setupCustomContent(android.view.ViewGroup ), this, viewGroup);
    }

    protected void setupTitle(ViewGroup viewGroup) {
        InvokeDynamicSupport.bootstrap("setupTitle", $$robo$$com_android_internal_app_AlertController$setupTitle(android.view.ViewGroup ), this, viewGroup);
    }

    protected void setupContent(ViewGroup viewGroup) {
        InvokeDynamicSupport.bootstrap("setupContent", $$robo$$com_android_internal_app_AlertController$setupContent(android.view.ViewGroup ), this, viewGroup);
    }

    private static void manageScrollIndicators(View view, View view2, View view3) {
        InvokeDynamicSupport.bootstrapStatic("manageScrollIndicators", $$robo$$com_android_internal_app_AlertController$manageScrollIndicators(android.view.View android.view.View android.view.View ), (View)view, (View)view2, (View)view3);
    }

    protected void setupButtons(ViewGroup viewGroup) {
        InvokeDynamicSupport.bootstrap("setupButtons", $$robo$$com_android_internal_app_AlertController$setupButtons(android.view.ViewGroup ), this, viewGroup);
    }

    private void centerButton(Button button) {
        InvokeDynamicSupport.bootstrap("centerButton", $$robo$$com_android_internal_app_AlertController$centerButton(android.widget.Button ), this, button);
    }

    private void setBackground(TypedArray typedArray, View view, View view2, View view3, View view4, boolean bl, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("setBackground", $$robo$$com_android_internal_app_AlertController$setBackground(android.content.res.TypedArray android.view.View android.view.View android.view.View android.view.View boolean boolean boolean ), this, typedArray, view, view2, view3, view4, bl, bl2, bl3);
    }

    public /* synthetic */ AlertController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlertController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CheckedItemAdapter
    extends ArrayAdapter<CharSequence> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$__constructor__(Context context, int resource, int textViewResourceId, CharSequence[] objects) {
        }

        private final boolean $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$hasStableIds() {
            return true;
        }

        private final long $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$getItemId(int position) {
            return position;
        }

        private void __constructor__(Context context, int n, int n2, CharSequence[] charSequenceArray) {
            this.$$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$__constructor__(context, n, n2, charSequenceArray);
        }

        public CheckedItemAdapter(Context context, int n, int n2, CharSequence[] charSequenceArray) {
            super(context, n, n2, charSequenceArray);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$__constructor__(android.content.Context int int java.lang.CharSequence[] ), this, context, n, n2, charSequenceArray);
        }

        @Override
        public boolean hasStableIds() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$hasStableIds(), this);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$getItemId(int ), this, n);
        }

        public /* synthetic */ CheckedItemAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CheckedItemAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AlertParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public Context mContext;
        public LayoutInflater mInflater;
        public int mIconId;
        public Drawable mIcon;
        public int mIconAttrId;
        public CharSequence mTitle;
        public View mCustomTitleView;
        public CharSequence mMessage;
        public CharSequence mPositiveButtonText;
        public DialogInterface.OnClickListener mPositiveButtonListener;
        public CharSequence mNegativeButtonText;
        public DialogInterface.OnClickListener mNegativeButtonListener;
        public CharSequence mNeutralButtonText;
        public DialogInterface.OnClickListener mNeutralButtonListener;
        public boolean mCancelable;
        public DialogInterface.OnCancelListener mOnCancelListener;
        public DialogInterface.OnDismissListener mOnDismissListener;
        public DialogInterface.OnKeyListener mOnKeyListener;
        public CharSequence[] mItems;
        public ListAdapter mAdapter;
        public DialogInterface.OnClickListener mOnClickListener;
        public int mViewLayoutResId;
        public View mView;
        public int mViewSpacingLeft;
        public int mViewSpacingTop;
        public int mViewSpacingRight;
        public int mViewSpacingBottom;
        public boolean mViewSpacingSpecified;
        public boolean[] mCheckedItems;
        public boolean mIsMultiChoice;
        public boolean mIsSingleChoice;
        public int mCheckedItem;
        public DialogInterface.OnMultiChoiceClickListener mOnCheckboxClickListener;
        public Cursor mCursor;
        public String mLabelColumn;
        public String mIsCheckedColumn;
        public boolean mForceInverseBackground;
        public AdapterView.OnItemSelectedListener mOnItemSelectedListener;
        public OnPrepareListViewListener mOnPrepareListViewListener;
        public boolean mRecycleOnMeasure;

        private void $$robo$$com_android_internal_app_AlertController_AlertParams$__constructor__(Context context) {
            this.mIconId = 0;
            this.mIconAttrId = 0;
            this.mViewSpacingSpecified = false;
            this.mCheckedItem = -1;
            this.mRecycleOnMeasure = true;
            this.mContext = context;
            this.mCancelable = true;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        private final void $$robo$$com_android_internal_app_AlertController_AlertParams$apply(AlertController dialog) {
            if (this.mCustomTitleView != null) {
                dialog.setCustomTitle(this.mCustomTitleView);
            } else {
                if (this.mTitle != null) {
                    dialog.setTitle(this.mTitle);
                }
                if (this.mIcon != null) {
                    dialog.setIcon(this.mIcon);
                }
                if (this.mIconId != 0) {
                    dialog.setIcon(this.mIconId);
                }
                if (this.mIconAttrId != 0) {
                    dialog.setIcon(dialog.getIconAttributeResId(this.mIconAttrId));
                }
            }
            if (this.mMessage != null) {
                dialog.setMessage(this.mMessage);
            }
            if (this.mPositiveButtonText != null) {
                dialog.setButton(-1, this.mPositiveButtonText, this.mPositiveButtonListener, null);
            }
            if (this.mNegativeButtonText != null) {
                dialog.setButton(-2, this.mNegativeButtonText, this.mNegativeButtonListener, null);
            }
            if (this.mNeutralButtonText != null) {
                dialog.setButton(-3, this.mNeutralButtonText, this.mNeutralButtonListener, null);
            }
            if (this.mForceInverseBackground) {
                dialog.setInverseBackgroundForced(true);
            }
            if (this.mItems != null || this.mCursor != null || this.mAdapter != null) {
                this.createListView(dialog);
            }
            if (this.mView != null) {
                if (this.mViewSpacingSpecified) {
                    dialog.setView(this.mView, this.mViewSpacingLeft, this.mViewSpacingTop, this.mViewSpacingRight, this.mViewSpacingBottom);
                } else {
                    dialog.setView(this.mView);
                }
            } else if (this.mViewLayoutResId != 0) {
                dialog.setView(this.mViewLayoutResId);
            }
        }

        private final void $$robo$$com_android_internal_app_AlertController_AlertParams$createListView(AlertController dialog) {
            Object adapter;
            RecycleListView listView = (RecycleListView)this.mInflater.inflate(dialog.mListLayout, null);
            if (this.mIsMultiChoice) {
                adapter = this.mCursor == null ? new ArrayAdapter<CharSequence>(this, this.mContext, dialog.mMultiChoiceItemLayout, 16908308, this.mItems, listView){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ RecycleListView val$listView;
                    /* synthetic */ AlertParams this$0;

                    private void $$robo$$com_android_internal_app_AlertController_AlertParams_1$__constructor__(AlertParams this$0, Context context, int resource, int textViewResourceId, CharSequence[] objects, RecycleListView recycleListView) {
                        this.val$listView = recycleListView;
                    }

                    private final View $$robo$$com_android_internal_app_AlertController_AlertParams_1$getView(int position, View convertView, ViewGroup parent) {
                        boolean isItemChecked;
                        View view = super.getView(position, convertView, parent);
                        if (this.this$0.mCheckedItems != null && (isItemChecked = this.this$0.mCheckedItems[position])) {
                            this.val$listView.setItemChecked(position, true);
                        }
                        return view;
                    }

                    private void __constructor__(AlertParams alertParams, Context context, int n, int n2, CharSequence[] charSequenceArray, RecycleListView recycleListView) {
                        this.$$robo$$com_android_internal_app_AlertController_AlertParams_1$__constructor__(alertParams, context, n, n2, charSequenceArray, recycleListView);
                    }
                    {
                        this.this$0 = alertParams;
                        super(context, n, n2, charSequenceArray);
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_AlertParams_1$__constructor__(com.android.internal.app.AlertController$AlertParams android.content.Context int int java.lang.CharSequence[] com.android.internal.app.AlertController$RecycleListView ), this, alertParams, context, n, n2, charSequenceArray, recycleListView);
                    }

                    @Override
                    public View getView(int n, View view, ViewGroup viewGroup) {
                        return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_app_AlertController_AlertParams_1$getView(int android.view.View android.view.ViewGroup ), this, n, view, viewGroup);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                } : new ShadowedObject(this, this.mContext, this.mCursor, false, listView, dialog){
                    public /* synthetic */ Object __robo_data__;
                    private int mLabelIndex;
                    private int mIsCheckedIndex;
                    /* synthetic */ RecycleListView val$listView;
                    /* synthetic */ AlertController val$dialog;
                    /* synthetic */ AlertParams this$0;

                    private void $$robo$$com_android_internal_app_AlertController_AlertParams_2$__constructor__(AlertParams this$0, Context context, Cursor c, boolean autoRequery, RecycleListView recycleListView, AlertController alertController) {
                        this.val$listView = recycleListView;
                        this.val$dialog = alertController;
                        Cursor cursor = this.getCursor();
                        this.mLabelIndex = cursor.getColumnIndexOrThrow(this.this$0.mLabelColumn);
                        this.mIsCheckedIndex = cursor.getColumnIndexOrThrow(this.this$0.mIsCheckedColumn);
                    }

                    private final void $$robo$$com_android_internal_app_AlertController_AlertParams_2$bindView(View view, Context context, Cursor cursor) {
                        CheckedTextView text = (CheckedTextView)view.findViewById(16908308);
                        text.setText(cursor.getString(this.mLabelIndex));
                        this.val$listView.setItemChecked(cursor.getPosition(), cursor.getInt(this.mIsCheckedIndex) == 1);
                    }

                    private final View $$robo$$com_android_internal_app_AlertController_AlertParams_2$newView(Context context, Cursor cursor, ViewGroup parent) {
                        return this.this$0.mInflater.inflate(this.val$dialog.mMultiChoiceItemLayout, parent, false);
                    }

                    private void __constructor__(AlertParams alertParams, Context context, Cursor cursor, boolean bl, RecycleListView recycleListView, AlertController alertController) {
                        this.$$robo$$com_android_internal_app_AlertController_AlertParams_2$__constructor__(alertParams, context, cursor, bl, recycleListView, alertController);
                    }
                    {
                        this.this$0 = alertParams;
                        super(context, cursor, bl);
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_AlertParams_2$__constructor__(com.android.internal.app.AlertController$AlertParams android.content.Context android.database.Cursor boolean com.android.internal.app.AlertController$RecycleListView com.android.internal.app.AlertController ), this, alertParams, context, cursor, bl, recycleListView, alertController);
                    }

                    @Override
                    public void bindView(View view, Context context, Cursor cursor) {
                        InvokeDynamicSupport.bootstrap("bindView", $$robo$$com_android_internal_app_AlertController_AlertParams_2$bindView(android.view.View android.content.Context android.database.Cursor ), this, view, context, cursor);
                    }

                    @Override
                    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
                        return InvokeDynamicSupport.bootstrap("newView", $$robo$$com_android_internal_app_AlertController_AlertParams_2$newView(android.content.Context android.database.Cursor android.view.ViewGroup ), this, context, cursor, viewGroup);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            } else {
                int layout2 = this.mIsSingleChoice ? dialog.mSingleChoiceItemLayout : dialog.mListItemLayout;
                adapter = this.mCursor != null ? new SimpleCursorAdapter(this.mContext, layout2, this.mCursor, new String[]{this.mLabelColumn}, new int[]{16908308}) : (this.mAdapter != null ? this.mAdapter : new CheckedItemAdapter(this.mContext, layout2, 16908308, this.mItems));
            }
            if (this.mOnPrepareListViewListener != null) {
                this.mOnPrepareListViewListener.onPrepareListView(listView);
            }
            dialog.mAdapter = (ListAdapter)adapter;
            dialog.mCheckedItem = this.mCheckedItem;
            if (this.mOnClickListener != null) {
                listView.setOnItemClickListener(new AdapterView.OnItemClickListener(this, dialog){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ AlertController val$dialog;
                    /* synthetic */ AlertParams this$0;

                    private void $$robo$$com_android_internal_app_AlertController_AlertParams_3$__constructor__(AlertParams this$0, AlertController alertController) {
                        this.val$dialog = alertController;
                    }

                    private final void $$robo$$com_android_internal_app_AlertController_AlertParams_3$onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                        this.this$0.mOnClickListener.onClick(this.val$dialog.mDialogInterface, position);
                        if (!this.this$0.mIsSingleChoice) {
                            this.val$dialog.mDialogInterface.dismiss();
                        }
                    }

                    private void __constructor__(AlertParams alertParams, AlertController alertController) {
                        this.$$robo$$com_android_internal_app_AlertController_AlertParams_3$__constructor__(alertParams, alertController);
                    }
                    {
                        this.this$0 = alertParams;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_AlertParams_3$__constructor__(com.android.internal.app.AlertController$AlertParams com.android.internal.app.AlertController ), this, alertParams, alertController);
                    }

                    @Override
                    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                        InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$com_android_internal_app_AlertController_AlertParams_3$onItemClick(android.widget.AdapterView<?> android.view.View int long ), this, adapterView, view, n, l);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else if (this.mOnCheckboxClickListener != null) {
                listView.setOnItemClickListener(new AdapterView.OnItemClickListener(this, listView, dialog){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ RecycleListView val$listView;
                    /* synthetic */ AlertController val$dialog;
                    /* synthetic */ AlertParams this$0;

                    private void $$robo$$com_android_internal_app_AlertController_AlertParams_4$__constructor__(AlertParams this$0, RecycleListView recycleListView, AlertController alertController) {
                        this.val$listView = recycleListView;
                        this.val$dialog = alertController;
                    }

                    private final void $$robo$$com_android_internal_app_AlertController_AlertParams_4$onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                        if (this.this$0.mCheckedItems != null) {
                            this.this$0.mCheckedItems[position] = this.val$listView.isItemChecked(position);
                        }
                        this.this$0.mOnCheckboxClickListener.onClick(this.val$dialog.mDialogInterface, position, this.val$listView.isItemChecked(position));
                    }

                    private void __constructor__(AlertParams alertParams, RecycleListView recycleListView, AlertController alertController) {
                        this.$$robo$$com_android_internal_app_AlertController_AlertParams_4$__constructor__(alertParams, recycleListView, alertController);
                    }
                    {
                        this.this$0 = alertParams;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_AlertParams_4$__constructor__(com.android.internal.app.AlertController$AlertParams com.android.internal.app.AlertController$RecycleListView com.android.internal.app.AlertController ), this, alertParams, recycleListView, alertController);
                    }

                    @Override
                    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                        InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$com_android_internal_app_AlertController_AlertParams_4$onItemClick(android.widget.AdapterView<?> android.view.View int long ), this, adapterView, view, n, l);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
            if (this.mOnItemSelectedListener != null) {
                listView.setOnItemSelectedListener(this.mOnItemSelectedListener);
            }
            if (this.mIsSingleChoice) {
                listView.setChoiceMode(1);
            } else if (this.mIsMultiChoice) {
                listView.setChoiceMode(2);
            }
            listView.mRecycleOnMeasure = this.mRecycleOnMeasure;
            dialog.mListView = listView;
        }

        private void __constructor__(Context context) {
            this.$$robo$$com_android_internal_app_AlertController_AlertParams$__constructor__(context);
        }

        public AlertParams(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_AlertParams$__constructor__(android.content.Context ), this, context);
        }

        public void apply(AlertController alertController) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$com_android_internal_app_AlertController_AlertParams$apply(com.android.internal.app.AlertController ), this, alertController);
        }

        private void createListView(AlertController alertController) {
            InvokeDynamicSupport.bootstrap("createListView", $$robo$$com_android_internal_app_AlertController_AlertParams$createListView(com.android.internal.app.AlertController ), this, alertController);
        }

        public /* synthetic */ AlertParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlertParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static interface OnPrepareListViewListener
        extends InstrumentedInterface {
            public void onPrepareListView(ListView var1);
        }
    }

    public static class RecycleListView
    extends ListView
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mPaddingTopNoTitle;
        private int mPaddingBottomNoButtons;
        boolean mRecycleOnMeasure;

        private void $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(Context context) {
        }

        private void $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(Context context, AttributeSet attrs) {
            this.mRecycleOnMeasure = true;
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RecycleListView);
            this.mPaddingBottomNoButtons = ta.getDimensionPixelOffset(0, -1);
            this.mPaddingTopNoTitle = ta.getDimensionPixelOffset(1, -1);
        }

        private final void $$robo$$com_android_internal_app_AlertController_RecycleListView$setHasDecor(boolean hasTitle, boolean hasButtons) {
            if (!hasButtons || !hasTitle) {
                int paddingLeft = this.getPaddingLeft();
                int paddingTop = hasTitle ? this.getPaddingTop() : this.mPaddingTopNoTitle;
                int paddingRight = this.getPaddingRight();
                int paddingBottom = hasButtons ? this.getPaddingBottom() : this.mPaddingBottomNoButtons;
                this.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            }
        }

        private final boolean $$robo$$com_android_internal_app_AlertController_RecycleListView$recycleOnMeasure() {
            return this.mRecycleOnMeasure;
        }

        private void __constructor__(Context context) {
            this.$$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(context);
        }

        public RecycleListView(Context context) {
            this(context, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(android.content.Context ), this, context);
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(context, attributeSet);
        }

        public RecycleListView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
        }

        public void setHasDecor(boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("setHasDecor", $$robo$$com_android_internal_app_AlertController_RecycleListView$setHasDecor(boolean boolean ), this, bl, bl2);
        }

        @Override
        protected boolean recycleOnMeasure() {
            return (boolean)InvokeDynamicSupport.bootstrap("recycleOnMeasure", $$robo$$com_android_internal_app_AlertController_RecycleListView$recycleOnMeasure(), this);
        }

        public /* synthetic */ RecycleListView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecycleListView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ButtonHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MSG_DISMISS_DIALOG = 1;
        private WeakReference<DialogInterface> mDialog;

        private void $$robo$$com_android_internal_app_AlertController_ButtonHandler$__constructor__(DialogInterface dialog) {
            this.mDialog = new WeakReference<DialogInterface>(dialog);
        }

        private final void $$robo$$com_android_internal_app_AlertController_ButtonHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case -3: 
                case -2: 
                case -1: {
                    ((DialogInterface.OnClickListener)msg.obj).onClick((DialogInterface)this.mDialog.get(), msg.what);
                    break;
                }
                case 1: {
                    ((DialogInterface)msg.obj).dismiss();
                }
            }
        }

        private void __constructor__(DialogInterface dialogInterface) {
            this.$$robo$$com_android_internal_app_AlertController_ButtonHandler$__constructor__(dialogInterface);
        }

        public ButtonHandler(DialogInterface dialogInterface) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_ButtonHandler$__constructor__(android.content.DialogInterface ), this, dialogInterface);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_app_AlertController_ButtonHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ ButtonHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ButtonHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

