/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityManager;
import android.widget.BaseAdapter;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.widget.ResolverDrawerLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AccessibilityButtonChooserActivity
extends Activity
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String MAGNIFICATION_COMPONENT_ID = "com.android.server.accessibility.MagnificationController";
    private AccessibilityButtonTarget mMagnificationTarget;
    private List<AccessibilityButtonTarget> mTargets;

    private void $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity$__constructor__() {
        this.mMagnificationTarget = null;
        this.mTargets = null;
    }

    private final void $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity$onCreate(Bundle savedInstanceState) {
        String component;
        super.onCreate(savedInstanceState);
        this.setContentView(17367064);
        ResolverDrawerLayout rdl = (ResolverDrawerLayout)this.findViewById(0x1020200);
        if (rdl != null) {
            rdl.setOnDismissedListener(this::finish);
        }
        if (TextUtils.isEmpty(component = Settings.Secure.getString(this.getContentResolver(), "accessibility_button_target_component"))) {
            TextView prompt = (TextView)this.findViewById(16908649);
            prompt.setVisibility(0);
        }
        this.mMagnificationTarget = new AccessibilityButtonTarget(this, "com.android.server.accessibility.MagnificationController", 17039420, 17302254);
        this.mTargets = AccessibilityButtonChooserActivity.getServiceAccessibilityButtonTargets(this);
        if (Settings.Secure.getInt(this.getContentResolver(), "accessibility_display_magnification_navbar_enabled", 0) == 1) {
            this.mTargets.add(this.mMagnificationTarget);
        }
        if (this.mTargets.size() < 2) {
            this.finish();
        }
        GridView gridview = (GridView)this.findViewById(16908648);
        gridview.setAdapter(new TargetAdapter(this, null));
        gridview.setOnItemClickListener((parent, view, position, id2) -> this.onTargetSelected(this.mTargets.get(position)));
    }

    private static final List<AccessibilityButtonTarget> $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity$getServiceAccessibilityButtonTargets(Context context) {
        AccessibilityManager ams = (AccessibilityManager)context.getSystemService("accessibility");
        List<AccessibilityServiceInfo> services = ams.getEnabledAccessibilityServiceList(-1);
        if (services == null) {
            return Collections.emptyList();
        }
        ArrayList<AccessibilityButtonTarget> targets = new ArrayList<AccessibilityButtonTarget>(services.size());
        for (AccessibilityServiceInfo info : services) {
            if ((info.flags & 0x100) == 0) continue;
            targets.add(new AccessibilityButtonTarget(context, info));
        }
        return targets;
    }

    private final void $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity$onTargetSelected(AccessibilityButtonTarget target) {
        Settings.Secure.putString(this.getContentResolver(), "accessibility_button_target_component", target.getId());
        this.finish();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_AccessibilityButtonChooserActivity$__constructor__();
    }

    public AccessibilityButtonChooserActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity$__constructor__(), this);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity$onCreate(android.os.Bundle ), this, bundle);
    }

    private static List<AccessibilityButtonTarget> getServiceAccessibilityButtonTargets(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getServiceAccessibilityButtonTargets", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity$getServiceAccessibilityButtonTargets(android.content.Context ), (Context)context);
    }

    private void onTargetSelected(AccessibilityButtonTarget accessibilityButtonTarget) {
        InvokeDynamicSupport.bootstrap("onTargetSelected", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity$onTargetSelected(com.android.internal.app.AccessibilityButtonChooserActivity$AccessibilityButtonTarget ), this, accessibilityButtonTarget);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityButtonChooserActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class AccessibilityButtonTarget
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String mId;
        public CharSequence mLabel;
        public Drawable mDrawable;

        private void $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$__constructor__(Context context, AccessibilityServiceInfo serviceInfo) {
            this.mId = serviceInfo.getComponentName().flattenToString();
            this.mLabel = serviceInfo.getResolveInfo().loadLabel(context.getPackageManager());
            this.mDrawable = serviceInfo.getResolveInfo().loadIcon(context.getPackageManager());
        }

        private void $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$__constructor__(Context context, String id2, int labelResId, int iconRes) {
            this.mId = id2;
            this.mLabel = context.getText(labelResId);
            this.mDrawable = context.getDrawable(iconRes);
        }

        private final String $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$getId() {
            return this.mId;
        }

        private final CharSequence $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$getLabel() {
            return this.mLabel;
        }

        private final Drawable $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$getDrawable() {
            return this.mDrawable;
        }

        private void __constructor__(Context context, AccessibilityServiceInfo accessibilityServiceInfo) {
            this.$$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$__constructor__(context, accessibilityServiceInfo);
        }

        public AccessibilityButtonTarget(Context context, AccessibilityServiceInfo accessibilityServiceInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$__constructor__(android.content.Context android.accessibilityservice.AccessibilityServiceInfo ), this, context, accessibilityServiceInfo);
        }

        private void __constructor__(Context context, String string2, int n, int n2) {
            this.$$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$__constructor__(context, string2, n, n2);
        }

        public AccessibilityButtonTarget(Context context, String string2, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$__constructor__(android.content.Context java.lang.String int int ), this, context, string2, n, n2);
        }

        public String getId() {
            return InvokeDynamicSupport.bootstrap("getId", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$getId(), this);
        }

        public CharSequence getLabel() {
            return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$getLabel(), this);
        }

        public Drawable getDrawable() {
            return InvokeDynamicSupport.bootstrap("getDrawable", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_AccessibilityButtonTarget$getDrawable(), this);
        }

        public /* synthetic */ AccessibilityButtonTarget() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityButtonTarget)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TargetAdapter
    extends BaseAdapter
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ AccessibilityButtonChooserActivity this$0;

        private void $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$__constructor__(AccessibilityButtonChooserActivity accessibilityButtonChooserActivity) {
        }

        private final int $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$getCount() {
            return this.this$0.mTargets.size();
        }

        private final Object $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$getItem(int position) {
            return null;
        }

        private final long $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$getItemId(int position) {
            return position;
        }

        private final View $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$getView(int position, View convertView, ViewGroup parent) {
            LayoutInflater inflater = this.this$0.getLayoutInflater();
            View root = inflater.inflate(0x1090019, parent, false);
            AccessibilityButtonTarget target = (AccessibilityButtonTarget)this.this$0.mTargets.get(position);
            ImageView iconView = (ImageView)root.findViewById(16908650);
            TextView labelView = (TextView)root.findViewById(16908651);
            iconView.setImageDrawable(target.getDrawable());
            labelView.setText(target.getLabel());
            return root;
        }

        private /* synthetic */ void $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$__constructor__(AccessibilityButtonChooserActivity x0, 1 x1) {
        }

        private void __constructor__(AccessibilityButtonChooserActivity accessibilityButtonChooserActivity) {
            this.$$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$__constructor__(accessibilityButtonChooserActivity);
        }

        public TargetAdapter(AccessibilityButtonChooserActivity accessibilityButtonChooserActivity) {
            this.this$0 = accessibilityButtonChooserActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$__constructor__(com.android.internal.app.AccessibilityButtonChooserActivity ), this, accessibilityButtonChooserActivity);
        }

        @Override
        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$getCount(), this);
        }

        @Override
        public Object getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$getItem(int ), this, n);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$getItemId(int ), this, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$getView(int android.view.View android.view.ViewGroup ), this, n, view, viewGroup);
        }

        private /* synthetic */ void __constructor__(AccessibilityButtonChooserActivity accessibilityButtonChooserActivity, 1 var2_2) {
            this.$$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$__constructor__(accessibilityButtonChooserActivity, var2_2);
        }

        public /* synthetic */ TargetAdapter(AccessibilityButtonChooserActivity accessibilityButtonChooserActivity, 1 var2_2) {
            this(accessibilityButtonChooserActivity);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AccessibilityButtonChooserActivity_TargetAdapter$__constructor__(com.android.internal.app.AccessibilityButtonChooserActivity com.android.internal.app.AccessibilityButtonChooserActivity$1 ), this, accessibilityButtonChooserActivity, var2_2);
        }

        public /* synthetic */ TargetAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TargetAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

