/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.IntDef;
import android.app.INotificationManager;
import android.app.ITransientNotification;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Toast
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "Toast";
    static boolean localLOGV = false;
    public static int LENGTH_SHORT = 0;
    public static int LENGTH_LONG = 1;
    Context mContext;
    TN mTN;
    int mDuration;
    View mNextView;
    private static INotificationManager sService;

    private void $$robo$$android_widget_Toast$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_Toast$__constructor__(Context context, Looper looper) {
        this.mContext = context;
        this.mTN = new TN(context.getPackageName(), looper);
        this.mTN.mY = context.getResources().getDimensionPixelSize(17105277);
        this.mTN.mGravity = context.getResources().getInteger(17694852);
    }

    private final void $$robo$$android_widget_Toast$show() {
        if (this.mNextView == null) {
            throw new RuntimeException("setView must have been called");
        }
        INotificationManager service = Toast.getService();
        String pkg = this.mContext.getOpPackageName();
        TN tn = this.mTN;
        tn.mNextView = this.mNextView;
        try {
            service.enqueueToast(pkg, tn, this.mDuration);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_widget_Toast$cancel() {
        this.mTN.cancel();
    }

    private final void $$robo$$android_widget_Toast$setView(View view) {
        this.mNextView = view;
    }

    private final View $$robo$$android_widget_Toast$getView() {
        return this.mNextView;
    }

    private final void $$robo$$android_widget_Toast$setDuration(int duration) {
        this.mDuration = duration;
        this.mTN.mDuration = duration;
    }

    private final int $$robo$$android_widget_Toast$getDuration() {
        return this.mDuration;
    }

    private final void $$robo$$android_widget_Toast$setMargin(float horizontalMargin, float verticalMargin) {
        this.mTN.mHorizontalMargin = horizontalMargin;
        this.mTN.mVerticalMargin = verticalMargin;
    }

    private final float $$robo$$android_widget_Toast$getHorizontalMargin() {
        return this.mTN.mHorizontalMargin;
    }

    private final float $$robo$$android_widget_Toast$getVerticalMargin() {
        return this.mTN.mVerticalMargin;
    }

    private final void $$robo$$android_widget_Toast$setGravity(int gravity, int xOffset, int yOffset) {
        this.mTN.mGravity = gravity;
        this.mTN.mX = xOffset;
        this.mTN.mY = yOffset;
    }

    private final int $$robo$$android_widget_Toast$getGravity() {
        return this.mTN.mGravity;
    }

    private final int $$robo$$android_widget_Toast$getXOffset() {
        return this.mTN.mX;
    }

    private final int $$robo$$android_widget_Toast$getYOffset() {
        return this.mTN.mY;
    }

    private final WindowManager.LayoutParams $$robo$$android_widget_Toast$getWindowParams() {
        return this.mTN.mParams;
    }

    private static final Toast $$robo$$android_widget_Toast$makeText(Context context, CharSequence text, int duration) {
        return Toast.makeText(context, null, text, duration);
    }

    private static final Toast $$robo$$android_widget_Toast$makeText(Context context, Looper looper, CharSequence text, int duration) {
        Toast result = new Toast(context, looper);
        LayoutInflater inflate = (LayoutInflater)context.getSystemService("layout_inflater");
        View v = inflate.inflate(17367299, null);
        TextView tv = (TextView)v.findViewById(16908299);
        tv.setText(text);
        result.mNextView = v;
        result.mDuration = duration;
        return result;
    }

    private static final Toast $$robo$$android_widget_Toast$makeText(Context context, int resId, int duration) throws Resources.NotFoundException {
        return Toast.makeText(context, context.getResources().getText(resId), duration);
    }

    private final void $$robo$$android_widget_Toast$setText(int resId) {
        this.setText(this.mContext.getText(resId));
    }

    private final void $$robo$$android_widget_Toast$setText(CharSequence s) {
        if (this.mNextView == null) {
            throw new RuntimeException("This Toast was not created with Toast.makeText()");
        }
        TextView tv = (TextView)this.mNextView.findViewById(16908299);
        if (tv == null) {
            throw new RuntimeException("This Toast was not created with Toast.makeText()");
        }
        tv.setText(s);
    }

    private static final INotificationManager $$robo$$android_widget_Toast$getService() {
        if (sService != null) {
            return sService;
        }
        sService = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        return sService;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_Toast$__constructor__(context);
    }

    public Toast(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Toast$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, Looper looper) {
        this.$$robo$$android_widget_Toast$__constructor__(context, looper);
    }

    public Toast(Context context, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Toast$__constructor__(android.content.Context android.os.Looper ), this, context, looper);
    }

    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Toast$show(), this);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_widget_Toast$cancel(), this);
    }

    public void setView(View view) {
        InvokeDynamicSupport.bootstrap("setView", $$robo$$android_widget_Toast$setView(android.view.View ), this, view);
    }

    public View getView() {
        return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_Toast$getView(), this);
    }

    public void setDuration(int n) {
        InvokeDynamicSupport.bootstrap("setDuration", $$robo$$android_widget_Toast$setDuration(int ), this, n);
    }

    public int getDuration() {
        return (int)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_widget_Toast$getDuration(), this);
    }

    public void setMargin(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setMargin", $$robo$$android_widget_Toast$setMargin(float float ), this, f, f2);
    }

    public float getHorizontalMargin() {
        return (float)InvokeDynamicSupport.bootstrap("getHorizontalMargin", $$robo$$android_widget_Toast$getHorizontalMargin(), this);
    }

    public float getVerticalMargin() {
        return (float)InvokeDynamicSupport.bootstrap("getVerticalMargin", $$robo$$android_widget_Toast$getVerticalMargin(), this);
    }

    public void setGravity(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_widget_Toast$setGravity(int int int ), this, n, n2, n3);
    }

    public int getGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$android_widget_Toast$getGravity(), this);
    }

    public int getXOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getXOffset", $$robo$$android_widget_Toast$getXOffset(), this);
    }

    public int getYOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getYOffset", $$robo$$android_widget_Toast$getYOffset(), this);
    }

    public WindowManager.LayoutParams getWindowParams() {
        return InvokeDynamicSupport.bootstrap("getWindowParams", $$robo$$android_widget_Toast$getWindowParams(), this);
    }

    public static Toast makeText(Context context, CharSequence charSequence, int n) {
        return InvokeDynamicSupport.bootstrapStatic("makeText", $$robo$$android_widget_Toast$makeText(android.content.Context java.lang.CharSequence int ), (Context)context, (CharSequence)charSequence, (int)n);
    }

    public static Toast makeText(Context context, Looper looper, CharSequence charSequence, int n) {
        return InvokeDynamicSupport.bootstrapStatic("makeText", $$robo$$android_widget_Toast$makeText(android.content.Context android.os.Looper java.lang.CharSequence int ), (Context)context, (Looper)looper, (CharSequence)charSequence, (int)n);
    }

    public static Toast makeText(Context context, int n, int n2) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("makeText", $$robo$$android_widget_Toast$makeText(android.content.Context int int ), (Context)context, (int)n, (int)n2);
    }

    public void setText(int n) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_widget_Toast$setText(int ), this, n);
    }

    public void setText(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setText", $$robo$$android_widget_Toast$setText(java.lang.CharSequence ), this, charSequence);
    }

    private static INotificationManager getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_widget_Toast$getService());
    }

    public /* synthetic */ Toast() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Toast)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class TN
    extends ITransientNotification.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private WindowManager.LayoutParams mParams;
        private static int SHOW = 0;
        private static int HIDE = 1;
        private static int CANCEL = 2;
        Handler mHandler;
        int mGravity;
        int mX;
        int mY;
        float mHorizontalMargin;
        float mVerticalMargin;
        View mView;
        View mNextView;
        int mDuration;
        WindowManager mWM;
        String mPackageName;
        static long SHORT_DURATION_TIMEOUT = 4000L;
        static long LONG_DURATION_TIMEOUT = 7000L;

        private void $$robo$$android_widget_Toast_TN$__constructor__(String packageName, Looper looper) {
            WindowManager.LayoutParams params = this.mParams = new WindowManager.LayoutParams();
            params.height = -2;
            params.width = -2;
            params.format = -3;
            params.windowAnimations = 16973828;
            params.type = 2005;
            params.setTitle("Toast");
            params.flags = 152;
            this.mPackageName = packageName;
            if (looper == null && (looper = Looper.myLooper()) == null) {
                throw new RuntimeException("Can't toast on a thread that has not called Looper.prepare()");
            }
            this.mHandler = new ShadowedObject(this, looper, null){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ TN this$0;

                private void $$robo$$android_widget_Toast_TN_1$__constructor__(TN this$0, Looper looper, Handler.Callback callback) {
                }

                private final void $$robo$$android_widget_Toast_TN_1$handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            IBinder token = (IBinder)msg.obj;
                            this.this$0.handleShow(token);
                            break;
                        }
                        case 1: {
                            this.this$0.handleHide();
                            this.this$0.mNextView = null;
                            break;
                        }
                        case 2: {
                            this.this$0.handleHide();
                            this.this$0.mNextView = null;
                            try {
                                Toast.getService().cancelToast(this.this$0.mPackageName, this.this$0);
                                break;
                            }
                            catch (RemoteException remoteException) {
                                // empty catch block
                            }
                        }
                    }
                }

                private void __constructor__(TN tN, Looper looper, Handler.Callback callback) {
                    this.$$robo$$android_widget_Toast_TN_1$__constructor__(tN, looper, callback);
                }
                {
                    this.this$0 = tN;
                    super(looper, callback);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Toast_TN_1$__constructor__(android.widget.Toast$TN android.os.Looper android.os.Handler$Callback ), this, tN, looper, callback);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_widget_Toast_TN_1$handleMessage(android.os.Message ), this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final void $$robo$$android_widget_Toast_TN$show(IBinder windowToken) {
            this.mHandler.obtainMessage(0, windowToken).sendToTarget();
        }

        private final void $$robo$$android_widget_Toast_TN$hide() {
            this.mHandler.obtainMessage(1).sendToTarget();
        }

        private final void $$robo$$android_widget_Toast_TN$cancel() {
            this.mHandler.obtainMessage(2).sendToTarget();
        }

        private final void $$robo$$android_widget_Toast_TN$handleShow(IBinder windowToken) {
            if (this.mHandler.hasMessages(2) || this.mHandler.hasMessages(1)) {
                return;
            }
            if (this.mView != this.mNextView) {
                int gravity;
                this.handleHide();
                this.mView = this.mNextView;
                Context context = this.mView.getContext().getApplicationContext();
                String packageName = this.mView.getContext().getOpPackageName();
                if (context == null) {
                    context = this.mView.getContext();
                }
                this.mWM = (WindowManager)context.getSystemService("window");
                Configuration config = this.mView.getContext().getResources().getConfiguration();
                this.mParams.gravity = gravity = Gravity.getAbsoluteGravity(this.mGravity, config.getLayoutDirection());
                if ((gravity & 7) == 7) {
                    this.mParams.horizontalWeight = 1.0f;
                }
                if ((gravity & 0x70) == 112) {
                    this.mParams.verticalWeight = 1.0f;
                }
                this.mParams.x = this.mX;
                this.mParams.y = this.mY;
                this.mParams.verticalMargin = this.mVerticalMargin;
                this.mParams.horizontalMargin = this.mHorizontalMargin;
                this.mParams.packageName = packageName;
                this.mParams.hideTimeoutMilliseconds = this.mDuration == 1 ? 7000L : 4000L;
                this.mParams.token = windowToken;
                if (this.mView.getParent() != null) {
                    this.mWM.removeView(this.mView);
                }
                try {
                    this.mWM.addView(this.mView, this.mParams);
                    this.trySendAccessibilityEvent();
                }
                catch (WindowManager.BadTokenException badTokenException) {
                    // empty catch block
                }
            }
        }

        private final void $$robo$$android_widget_Toast_TN$trySendAccessibilityEvent() {
            AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(this.mView.getContext());
            if (!accessibilityManager.isEnabled()) {
                return;
            }
            AccessibilityEvent event = AccessibilityEvent.obtain(64);
            event.setClassName(this.getClass().getName());
            event.setPackageName(this.mView.getContext().getPackageName());
            this.mView.dispatchPopulateAccessibilityEvent(event);
            accessibilityManager.sendAccessibilityEvent(event);
        }

        private final void $$robo$$android_widget_Toast_TN$handleHide() {
            if (this.mView != null) {
                if (this.mView.getParent() != null) {
                    this.mWM.removeViewImmediate(this.mView);
                }
                this.mView = null;
            }
        }

        private void __constructor__(String string2, Looper looper) {
            this.$$robo$$android_widget_Toast_TN$__constructor__(string2, looper);
        }

        public TN(String string2, Looper looper) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Toast_TN$__constructor__(java.lang.String android.os.Looper ), this, string2, looper);
        }

        @Override
        public void show(IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Toast_TN$show(android.os.IBinder ), this, iBinder);
        }

        @Override
        public void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$android_widget_Toast_TN$hide(), this);
        }

        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_widget_Toast_TN$cancel(), this);
        }

        public void handleShow(IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("handleShow", $$robo$$android_widget_Toast_TN$handleShow(android.os.IBinder ), this, iBinder);
        }

        private void trySendAccessibilityEvent() {
            InvokeDynamicSupport.bootstrap("trySendAccessibilityEvent", $$robo$$android_widget_Toast_TN$trySendAccessibilityEvent(), this);
        }

        public void handleHide() {
            InvokeDynamicSupport.bootstrap("handleHide", $$robo$$android_widget_Toast_TN$handleHide(), this);
        }

        public /* synthetic */ TN() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TN)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    public static @interface Duration {
    }
}

