/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TableRow;
import com.android.internal.R;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TableLayout
extends LinearLayout
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int[] mMaxWidths;
    private SparseBooleanArray mStretchableColumns;
    private SparseBooleanArray mShrinkableColumns;
    private SparseBooleanArray mCollapsedColumns;
    private boolean mShrinkAllColumns;
    private boolean mStretchAllColumns;
    private PassThroughHierarchyChangeListener mPassThroughListener;
    private boolean mInitialized;

    private void $$robo$$android_widget_TableLayout$__constructor__(Context context) {
        this.initTableLayout();
    }

    private void $$robo$$android_widget_TableLayout$__constructor__(Context context, AttributeSet attrs) {
        String collapsedColumns;
        String shrinkedColumns;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TableLayout);
        String stretchedColumns = a.getString(0);
        if (stretchedColumns != null) {
            if (stretchedColumns.charAt(0) == '*') {
                this.mStretchAllColumns = true;
            } else {
                this.mStretchableColumns = TableLayout.parseColumns(stretchedColumns);
            }
        }
        if ((shrinkedColumns = a.getString(1)) != null) {
            if (shrinkedColumns.charAt(0) == '*') {
                this.mShrinkAllColumns = true;
            } else {
                this.mShrinkableColumns = TableLayout.parseColumns(shrinkedColumns);
            }
        }
        if ((collapsedColumns = a.getString(2)) != null) {
            this.mCollapsedColumns = TableLayout.parseColumns(collapsedColumns);
        }
        a.recycle();
        this.initTableLayout();
    }

    private static final SparseBooleanArray $$robo$$android_widget_TableLayout$parseColumns(String sequence) {
        String[] columnDefs;
        SparseBooleanArray columns = new SparseBooleanArray();
        Pattern pattern = Pattern.compile("\\s*,\\s*");
        for (String columnIdentifier : columnDefs = pattern.split(sequence)) {
            try {
                int columnIndex = Integer.parseInt(columnIdentifier);
                if (columnIndex < 0) continue;
                columns.put(columnIndex, true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return columns;
    }

    private final void $$robo$$android_widget_TableLayout$initTableLayout() {
        if (this.mCollapsedColumns == null) {
            this.mCollapsedColumns = new SparseBooleanArray();
        }
        if (this.mStretchableColumns == null) {
            this.mStretchableColumns = new SparseBooleanArray();
        }
        if (this.mShrinkableColumns == null) {
            this.mShrinkableColumns = new SparseBooleanArray();
        }
        this.setOrientation(1);
        this.mPassThroughListener = new PassThroughHierarchyChangeListener(this, null);
        super.setOnHierarchyChangeListener(this.mPassThroughListener);
        this.mInitialized = true;
    }

    private final void $$robo$$android_widget_TableLayout$setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener;
    }

    private final void $$robo$$android_widget_TableLayout$requestRowsLayout() {
        if (this.mInitialized) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).requestLayout();
            }
        }
    }

    private final void $$robo$$android_widget_TableLayout$requestLayout() {
        if (this.mInitialized) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).forceLayout();
            }
        }
        super.requestLayout();
    }

    private final boolean $$robo$$android_widget_TableLayout$isShrinkAllColumns() {
        return this.mShrinkAllColumns;
    }

    private final void $$robo$$android_widget_TableLayout$setShrinkAllColumns(boolean shrinkAllColumns) {
        this.mShrinkAllColumns = shrinkAllColumns;
    }

    private final boolean $$robo$$android_widget_TableLayout$isStretchAllColumns() {
        return this.mStretchAllColumns;
    }

    private final void $$robo$$android_widget_TableLayout$setStretchAllColumns(boolean stretchAllColumns) {
        this.mStretchAllColumns = stretchAllColumns;
    }

    private final void $$robo$$android_widget_TableLayout$setColumnCollapsed(int columnIndex, boolean isCollapsed) {
        this.mCollapsedColumns.put(columnIndex, isCollapsed);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof TableRow)) continue;
            ((TableRow)view).setColumnCollapsed(columnIndex, isCollapsed);
        }
        this.requestRowsLayout();
    }

    private final boolean $$robo$$android_widget_TableLayout$isColumnCollapsed(int columnIndex) {
        return this.mCollapsedColumns.get(columnIndex);
    }

    private final void $$robo$$android_widget_TableLayout$setColumnStretchable(int columnIndex, boolean isStretchable) {
        this.mStretchableColumns.put(columnIndex, isStretchable);
        this.requestRowsLayout();
    }

    private final boolean $$robo$$android_widget_TableLayout$isColumnStretchable(int columnIndex) {
        return this.mStretchAllColumns || this.mStretchableColumns.get(columnIndex);
    }

    private final void $$robo$$android_widget_TableLayout$setColumnShrinkable(int columnIndex, boolean isShrinkable) {
        this.mShrinkableColumns.put(columnIndex, isShrinkable);
        this.requestRowsLayout();
    }

    private final boolean $$robo$$android_widget_TableLayout$isColumnShrinkable(int columnIndex) {
        return this.mShrinkAllColumns || this.mShrinkableColumns.get(columnIndex);
    }

    private final void $$robo$$android_widget_TableLayout$trackCollapsedColumns(View child) {
        if (child instanceof TableRow) {
            TableRow row = (TableRow)child;
            SparseBooleanArray collapsedColumns = this.mCollapsedColumns;
            int count = collapsedColumns.size();
            for (int i = 0; i < count; ++i) {
                int columnIndex = collapsedColumns.keyAt(i);
                boolean isCollapsed = collapsedColumns.valueAt(i);
                if (!isCollapsed) continue;
                row.setColumnCollapsed(columnIndex, isCollapsed);
            }
        }
    }

    private final void $$robo$$android_widget_TableLayout$addView(View child) {
        super.addView(child);
        this.requestRowsLayout();
    }

    private final void $$robo$$android_widget_TableLayout$addView(View child, int index) {
        super.addView(child, index);
        this.requestRowsLayout();
    }

    private final void $$robo$$android_widget_TableLayout$addView(View child, ViewGroup.LayoutParams params) {
        super.addView(child, params);
        this.requestRowsLayout();
    }

    private final void $$robo$$android_widget_TableLayout$addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
        this.requestRowsLayout();
    }

    private final void $$robo$$android_widget_TableLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureVertical(widthMeasureSpec, heightMeasureSpec);
    }

    private final void $$robo$$android_widget_TableLayout$onLayout(boolean changed, int l, int t, int r, int b) {
        this.layoutVertical(l, t, r, b);
    }

    private final void $$robo$$android_widget_TableLayout$measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        if (child instanceof TableRow) {
            ((TableRow)child).setColumnsWidthConstraints(this.mMaxWidths);
        }
        super.measureChildBeforeLayout(child, childIndex, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    private final void $$robo$$android_widget_TableLayout$measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        this.findLargestCells(widthMeasureSpec, heightMeasureSpec);
        this.shrinkAndStretchColumns(widthMeasureSpec);
        super.measureVertical(widthMeasureSpec, heightMeasureSpec);
    }

    private final void $$robo$$android_widget_TableLayout$findLargestCells(int widthMeasureSpec, int heightMeasureSpec) {
        boolean firstRow = true;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8 || !(child instanceof TableRow)) continue;
            TableRow row = (TableRow)child;
            ViewGroup.LayoutParams layoutParams = row.getLayoutParams();
            layoutParams.height = -2;
            int[] widths = row.getColumnsWidths(widthMeasureSpec, heightMeasureSpec);
            int newLength = widths.length;
            if (firstRow) {
                if (this.mMaxWidths == null || this.mMaxWidths.length != newLength) {
                    this.mMaxWidths = new int[newLength];
                }
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])widths, (int)0, (int[])this.mMaxWidths, (int)0, (int)newLength);
                firstRow = false;
                continue;
            }
            int length = this.mMaxWidths.length;
            int difference = newLength - length;
            if (difference > 0) {
                int[] oldMaxWidths = this.mMaxWidths;
                this.mMaxWidths = new int[newLength];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])oldMaxWidths, (int)0, (int[])this.mMaxWidths, (int)0, (int)oldMaxWidths.length);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])widths, (int)oldMaxWidths.length, (int[])this.mMaxWidths, (int)oldMaxWidths.length, (int)difference);
            }
            int[] maxWidths = this.mMaxWidths;
            length = Math.min(length, newLength);
            for (int j = 0; j < length; ++j) {
                maxWidths[j] = Math.max(maxWidths[j], widths[j]);
            }
        }
    }

    private final void $$robo$$android_widget_TableLayout$shrinkAndStretchColumns(int widthMeasureSpec) {
        if (this.mMaxWidths == null) {
            return;
        }
        int totalWidth = 0;
        for (int width : this.mMaxWidths) {
            totalWidth += width;
        }
        int size = View.MeasureSpec.getSize(widthMeasureSpec) - this.mPaddingLeft - this.mPaddingRight;
        if (totalWidth > size && (this.mShrinkAllColumns || this.mShrinkableColumns.size() > 0)) {
            this.mutateColumnsWidth(this.mShrinkableColumns, this.mShrinkAllColumns, size, totalWidth);
        } else if (totalWidth < size && (this.mStretchAllColumns || this.mStretchableColumns.size() > 0)) {
            this.mutateColumnsWidth(this.mStretchableColumns, this.mStretchAllColumns, size, totalWidth);
        }
    }

    private final void $$robo$$android_widget_TableLayout$mutateColumnsWidth(SparseBooleanArray columns, boolean allColumns, int size, int totalWidth) {
        int i;
        int skipped = 0;
        int[] maxWidths = this.mMaxWidths;
        int length = maxWidths.length;
        int count = allColumns ? length : columns.size();
        int totalExtraSpace = size - totalWidth;
        int extraSpace = totalExtraSpace / count;
        int nbChildren = this.getChildCount();
        for (i = 0; i < nbChildren; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof TableRow)) continue;
            child.forceLayout();
        }
        if (!allColumns) {
            for (i = 0; i < count; ++i) {
                int column = columns.keyAt(i);
                if (!columns.valueAt(i)) continue;
                if (column < length) {
                    int n = column;
                    maxWidths[n] = maxWidths[n] + extraSpace;
                    continue;
                }
                ++skipped;
            }
        } else {
            i = 0;
            while (i < count) {
                int n = i++;
                maxWidths[n] = maxWidths[n] + extraSpace;
            }
            return;
        }
        if (skipped > 0 && skipped < count) {
            extraSpace = skipped * extraSpace / (count - skipped);
            for (i = 0; i < count; ++i) {
                int column = columns.keyAt(i);
                if (!columns.valueAt(i) || column >= length) continue;
                if (extraSpace > maxWidths[column]) {
                    maxWidths[column] = 0;
                    continue;
                }
                int n = column;
                maxWidths[n] = maxWidths[n] + extraSpace;
            }
        }
    }

    private final LayoutParams $$robo$$android_widget_TableLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final LinearLayout.LayoutParams $$robo$$android_widget_TableLayout$generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    private final boolean $$robo$$android_widget_TableLayout$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private final LinearLayout.LayoutParams $$robo$$android_widget_TableLayout$generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    private final CharSequence $$robo$$android_widget_TableLayout$getAccessibilityClassName() {
        return TableLayout.class.getName();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_TableLayout$__constructor__(context);
    }

    public TableLayout(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableLayout$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_TableLayout$__constructor__(context, attributeSet);
    }

    public TableLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableLayout$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private static SparseBooleanArray parseColumns(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseColumns", $$robo$$android_widget_TableLayout$parseColumns(java.lang.String ), (String)string2);
    }

    private void initTableLayout() {
        InvokeDynamicSupport.bootstrap("initTableLayout", $$robo$$android_widget_TableLayout$initTableLayout(), this);
    }

    @Override
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnHierarchyChangeListener", $$robo$$android_widget_TableLayout$setOnHierarchyChangeListener(android.view.ViewGroup$OnHierarchyChangeListener ), this, onHierarchyChangeListener);
    }

    private void requestRowsLayout() {
        InvokeDynamicSupport.bootstrap("requestRowsLayout", $$robo$$android_widget_TableLayout$requestRowsLayout(), this);
    }

    @Override
    public void requestLayout() {
        InvokeDynamicSupport.bootstrap("requestLayout", $$robo$$android_widget_TableLayout$requestLayout(), this);
    }

    public boolean isShrinkAllColumns() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShrinkAllColumns", $$robo$$android_widget_TableLayout$isShrinkAllColumns(), this);
    }

    public void setShrinkAllColumns(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShrinkAllColumns", $$robo$$android_widget_TableLayout$setShrinkAllColumns(boolean ), this, bl);
    }

    public boolean isStretchAllColumns() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStretchAllColumns", $$robo$$android_widget_TableLayout$isStretchAllColumns(), this);
    }

    public void setStretchAllColumns(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStretchAllColumns", $$robo$$android_widget_TableLayout$setStretchAllColumns(boolean ), this, bl);
    }

    public void setColumnCollapsed(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setColumnCollapsed", $$robo$$android_widget_TableLayout$setColumnCollapsed(int boolean ), this, n, bl);
    }

    public boolean isColumnCollapsed(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isColumnCollapsed", $$robo$$android_widget_TableLayout$isColumnCollapsed(int ), this, n);
    }

    public void setColumnStretchable(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setColumnStretchable", $$robo$$android_widget_TableLayout$setColumnStretchable(int boolean ), this, n, bl);
    }

    public boolean isColumnStretchable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isColumnStretchable", $$robo$$android_widget_TableLayout$isColumnStretchable(int ), this, n);
    }

    public void setColumnShrinkable(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setColumnShrinkable", $$robo$$android_widget_TableLayout$setColumnShrinkable(int boolean ), this, n, bl);
    }

    public boolean isColumnShrinkable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isColumnShrinkable", $$robo$$android_widget_TableLayout$isColumnShrinkable(int ), this, n);
    }

    private void trackCollapsedColumns(View view) {
        InvokeDynamicSupport.bootstrap("trackCollapsedColumns", $$robo$$android_widget_TableLayout$trackCollapsedColumns(android.view.View ), this, view);
    }

    @Override
    public void addView(View view) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_TableLayout$addView(android.view.View ), this, view);
    }

    @Override
    public void addView(View view, int n) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_TableLayout$addView(android.view.View int ), this, view, n);
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_TableLayout$addView(android.view.View android.view.ViewGroup$LayoutParams ), this, view, layoutParams);
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_TableLayout$addView(android.view.View int android.view.ViewGroup$LayoutParams ), this, view, n, layoutParams);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_TableLayout$onMeasure(int int ), this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_TableLayout$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("measureChildBeforeLayout", $$robo$$android_widget_TableLayout$measureChildBeforeLayout(android.view.View int int int int int ), this, view, n, n2, n3, n4, n5);
    }

    @Override
    void measureVertical(int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureVertical", $$robo$$android_widget_TableLayout$measureVertical(int int ), this, n, n2);
    }

    private void findLargestCells(int n, int n2) {
        InvokeDynamicSupport.bootstrap("findLargestCells", $$robo$$android_widget_TableLayout$findLargestCells(int int ), this, n, n2);
    }

    private void shrinkAndStretchColumns(int n) {
        InvokeDynamicSupport.bootstrap("shrinkAndStretchColumns", $$robo$$android_widget_TableLayout$shrinkAndStretchColumns(int ), this, n);
    }

    private void mutateColumnsWidth(SparseBooleanArray sparseBooleanArray, boolean bl, int n, int n2) {
        InvokeDynamicSupport.bootstrap("mutateColumnsWidth", $$robo$$android_widget_TableLayout$mutateColumnsWidth(android.util.SparseBooleanArray boolean int int ), this, sparseBooleanArray, bl, n, n2);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_TableLayout$generateLayoutParams(android.util.AttributeSet ), this, attributeSet);
    }

    @Override
    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_widget_TableLayout$generateDefaultLayoutParams(), this);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_widget_TableLayout$checkLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    @Override
    protected LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_TableLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_TableLayout$getAccessibilityClassName(), this);
    }

    public /* synthetic */ TableLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TableLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;
        /* synthetic */ TableLayout this$0;

        private void $$robo$$android_widget_TableLayout_PassThroughHierarchyChangeListener$__constructor__(TableLayout tableLayout) {
        }

        private final void $$robo$$android_widget_TableLayout_PassThroughHierarchyChangeListener$onChildViewAdded(View parent, View child) {
            this.this$0.trackCollapsedColumns(child);
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        private final void $$robo$$android_widget_TableLayout_PassThroughHierarchyChangeListener$onChildViewRemoved(View parent, View child) {
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }

        private /* synthetic */ void $$robo$$android_widget_TableLayout_PassThroughHierarchyChangeListener$__constructor__(TableLayout x0, 1 x1) {
        }

        private void __constructor__(TableLayout tableLayout) {
            this.$$robo$$android_widget_TableLayout_PassThroughHierarchyChangeListener$__constructor__(tableLayout);
        }

        public PassThroughHierarchyChangeListener(TableLayout tableLayout) {
            this.this$0 = tableLayout;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableLayout_PassThroughHierarchyChangeListener$__constructor__(android.widget.TableLayout ), this, tableLayout);
        }

        @Override
        public void onChildViewAdded(View view, View view2) {
            InvokeDynamicSupport.bootstrap("onChildViewAdded", $$robo$$android_widget_TableLayout_PassThroughHierarchyChangeListener$onChildViewAdded(android.view.View android.view.View ), this, view, view2);
        }

        @Override
        public void onChildViewRemoved(View view, View view2) {
            InvokeDynamicSupport.bootstrap("onChildViewRemoved", $$robo$$android_widget_TableLayout_PassThroughHierarchyChangeListener$onChildViewRemoved(android.view.View android.view.View ), this, view, view2);
        }

        private /* synthetic */ void __constructor__(TableLayout tableLayout, 1 var2_2) {
            this.$$robo$$android_widget_TableLayout_PassThroughHierarchyChangeListener$__constructor__(tableLayout, var2_2);
        }

        public /* synthetic */ PassThroughHierarchyChangeListener(TableLayout tableLayout, 1 var2_2) {
            this(tableLayout);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableLayout_PassThroughHierarchyChangeListener$__constructor__(android.widget.TableLayout android.widget.TableLayout$1 ), this, tableLayout, var2_2);
        }

        public /* synthetic */ PassThroughHierarchyChangeListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PassThroughHierarchyChangeListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
        }

        private void $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(int w, int h) {
        }

        private void $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(int w, int h, float initWeight) {
        }

        private void $$robo$$android_widget_TableLayout_LayoutParams$__constructor__() {
        }

        private void $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(ViewGroup.LayoutParams p) {
            this.width = -1;
        }

        private void $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(ViewGroup.MarginLayoutParams source) {
            this.width = -1;
            if (source instanceof LayoutParams) {
                this.weight = ((LayoutParams)source).weight;
            }
        }

        private final void $$robo$$android_widget_TableLayout_LayoutParams$setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = -1;
            this.height = a.hasValue(heightAttr) ? a.getLayoutDimension(heightAttr, "layout_height") : -2;
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_TableLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_widget_TableLayout_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(-1, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(int int ), this, n, n2);
        }

        private void __constructor__(int n, int n2, float f) {
            this.$$robo$$android_widget_TableLayout_LayoutParams$__constructor__(n, n2, f);
        }

        public LayoutParams(int n, int n2, float f) {
            super(-1, n2, f);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(int int float ), this, n, n2, f);
        }

        private void __constructor__() {
            this.$$robo$$android_widget_TableLayout_LayoutParams$__constructor__();
        }

        public LayoutParams() {
            super(-1, -2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(), this);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$android_widget_TableLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), this, layoutParams);
        }

        private void __constructor__(ViewGroup.MarginLayoutParams marginLayoutParams) {
            this.$$robo$$android_widget_TableLayout_LayoutParams$__constructor__(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableLayout_LayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), this, marginLayoutParams);
        }

        @Override
        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            InvokeDynamicSupport.bootstrap("setBaseAttributes", $$robo$$android_widget_TableLayout_LayoutParams$setBaseAttributes(android.content.res.TypedArray int int ), this, typedArray, n, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

