/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.text.Editable;
import android.text.Selection;
import android.text.TextUtils;
import android.text.method.WordIterator;
import android.text.style.SpellCheckSpan;
import android.text.style.SuggestionSpan;
import android.util.Log;
import android.util.LruCache;
import android.view.textservice.SentenceSuggestionsInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import android.view.textservice.TextServicesManager;
import android.widget.TextView;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SpellChecker
implements SpellCheckerSession.SpellCheckerSessionListener,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = false;
    public static int MAX_NUMBER_OF_WORDS = 50;
    public static int AVERAGE_WORD_LENGTH = 7;
    public static int WORD_ITERATOR_INTERVAL = 350;
    private static int SPELL_PAUSE_DURATION = 400;
    private static int MIN_SENTENCE_LENGTH = 50;
    private static int USE_SPAN_RANGE = -1;
    private TextView mTextView;
    SpellCheckerSession mSpellCheckerSession;
    private boolean mIsSentenceSpellCheckSupported;
    int mCookie;
    private int[] mIds;
    private SpellCheckSpan[] mSpellCheckSpans;
    private int mLength;
    private SpellParser[] mSpellParsers;
    private int mSpanSequenceCounter;
    private Locale mCurrentLocale;
    private WordIterator mWordIterator;
    private TextServicesManager mTextServicesManager;
    private Runnable mSpellRunnable;
    private static int SUGGESTION_SPAN_CACHE_SIZE = 10;
    private LruCache<Long, SuggestionSpan> mSuggestionSpanCache;

    private void $$robo$$android_widget_SpellChecker$__constructor__(TextView textView) {
        this.mSpellParsers = new SpellParser[0];
        this.mSpanSequenceCounter = 0;
        this.mSuggestionSpanCache = new LruCache(10);
        this.mTextView = textView;
        boolean size = true;
        this.mIds = ArrayUtils.newUnpaddedIntArray(1);
        this.mSpellCheckSpans = new SpellCheckSpan[this.mIds.length];
        this.setLocale(this.mTextView.getSpellCheckerLocale());
        this.mCookie = this.hashCode();
    }

    private final void $$robo$$android_widget_SpellChecker$resetSession() {
        this.closeSession();
        this.mTextServicesManager = (TextServicesManager)this.mTextView.getContext().getSystemService("textservices");
        if (!this.mTextServicesManager.isSpellCheckerEnabled() || this.mCurrentLocale == null || this.mTextServicesManager.getCurrentSpellCheckerSubtype(true) == null) {
            this.mSpellCheckerSession = null;
        } else {
            this.mSpellCheckerSession = this.mTextServicesManager.newSpellCheckerSession(null, this.mCurrentLocale, this, false);
            this.mIsSentenceSpellCheckSupported = true;
        }
        for (int i = 0; i < this.mLength; ++i) {
            this.mIds[i] = -1;
        }
        this.mLength = 0;
        this.mTextView.removeMisspelledSpans((Editable)this.mTextView.getText());
        this.mSuggestionSpanCache.evictAll();
    }

    private final void $$robo$$android_widget_SpellChecker$setLocale(Locale locale) {
        this.mCurrentLocale = locale;
        this.resetSession();
        if (locale != null) {
            this.mWordIterator = new WordIterator(locale);
        }
        this.mTextView.onLocaleChanged();
    }

    private final boolean $$robo$$android_widget_SpellChecker$isSessionActive() {
        return this.mSpellCheckerSession != null;
    }

    private final void $$robo$$android_widget_SpellChecker$closeSession() {
        if (this.mSpellCheckerSession != null) {
            this.mSpellCheckerSession.close();
        }
        int length = this.mSpellParsers.length;
        for (int i = 0; i < length; ++i) {
            this.mSpellParsers[i].stop();
        }
        if (this.mSpellRunnable != null) {
            this.mTextView.removeCallbacks(this.mSpellRunnable);
        }
    }

    private final int $$robo$$android_widget_SpellChecker$nextSpellCheckSpanIndex() {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mIds[i] >= 0) continue;
            return i;
        }
        this.mIds = GrowingArrayUtils.append(this.mIds, this.mLength, 0);
        this.mSpellCheckSpans = GrowingArrayUtils.append(this.mSpellCheckSpans, this.mLength, new SpellCheckSpan());
        ++this.mLength;
        return this.mLength - 1;
    }

    private final void $$robo$$android_widget_SpellChecker$addSpellCheckSpan(Editable editable, int start, int end) {
        int index = this.nextSpellCheckSpanIndex();
        SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[index];
        editable.setSpan(spellCheckSpan, start, end, 33);
        spellCheckSpan.setSpellCheckInProgress(false);
        ++this.mSpanSequenceCounter;
    }

    private final void $$robo$$android_widget_SpellChecker$onSpellCheckSpanRemoved(SpellCheckSpan spellCheckSpan) {
        for (int i = 0; i < this.mLength; ++i) {
            if (this.mSpellCheckSpans[i] != spellCheckSpan) continue;
            this.mIds[i] = -1;
            return;
        }
    }

    private final void $$robo$$android_widget_SpellChecker$onSelectionChanged() {
        this.spellCheck();
    }

    private final void $$robo$$android_widget_SpellChecker$spellCheck(int start, int end) {
        SpellParser spellParser;
        Locale locale = this.mTextView.getSpellCheckerLocale();
        boolean isSessionActive = this.isSessionActive();
        if (locale == null || this.mCurrentLocale == null || !this.mCurrentLocale.equals(locale)) {
            this.setLocale(locale);
            start = 0;
            end = this.mTextView.getText().length();
        } else {
            boolean spellCheckerActivated = this.mTextServicesManager.isSpellCheckerEnabled();
            if (isSessionActive != spellCheckerActivated) {
                this.resetSession();
            }
        }
        if (!isSessionActive) {
            return;
        }
        int length = this.mSpellParsers.length;
        for (int i = 0; i < length; ++i) {
            spellParser = this.mSpellParsers[i];
            if (!spellParser.isFinished()) continue;
            spellParser.parse(start, end);
            return;
        }
        SpellParser[] newSpellParsers = new SpellParser[length + 1];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mSpellParsers, (int)0, (Object)newSpellParsers, (int)0, (int)length);
        this.mSpellParsers = newSpellParsers;
        this.mSpellParsers[length] = spellParser = new SpellParser(this, null);
        spellParser.parse(start, end);
    }

    private final void $$robo$$android_widget_SpellChecker$spellCheck() {
        if (this.mSpellCheckerSession == null) {
            return;
        }
        Editable editable = (Editable)this.mTextView.getText();
        int selectionStart = Selection.getSelectionStart(editable);
        int selectionEnd = Selection.getSelectionEnd(editable);
        TextInfo[] textInfos = new TextInfo[this.mLength];
        int textInfosCount = 0;
        for (int i = 0; i < this.mLength; ++i) {
            boolean isEditing;
            SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[i];
            if (this.mIds[i] < 0 || spellCheckSpan.isSpellCheckInProgress()) continue;
            int start = editable.getSpanStart(spellCheckSpan);
            int end = editable.getSpanEnd(spellCheckSpan);
            if (selectionStart == end + 1 && WordIterator.isMidWordPunctuation(this.mCurrentLocale, Character.codePointBefore(editable, end + 1))) {
                isEditing = false;
            } else if (this.mIsSentenceSpellCheckSupported) {
                isEditing = selectionEnd <= start || selectionStart > end;
            } else {
                boolean bl = isEditing = selectionEnd < start || selectionStart > end;
            }
            if (start < 0 || end <= start || !isEditing) continue;
            spellCheckSpan.setSpellCheckInProgress(true);
            TextInfo textInfo = new TextInfo(editable, start, end, this.mCookie, this.mIds[i]);
            textInfos[textInfosCount++] = textInfo;
        }
        if (textInfosCount > 0) {
            if (textInfosCount < textInfos.length) {
                TextInfo[] textInfosCopy = new TextInfo[textInfosCount];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)textInfos, (int)0, (Object)textInfosCopy, (int)0, (int)textInfosCount);
                textInfos = textInfosCopy;
            }
            if (this.mIsSentenceSpellCheckSupported) {
                this.mSpellCheckerSession.getSentenceSuggestions(textInfos, 5);
            } else {
                this.mSpellCheckerSession.getSuggestions(textInfos, 5, false);
            }
        }
    }

    private final SpellCheckSpan $$robo$$android_widget_SpellChecker$onGetSuggestionsInternal(SuggestionsInfo suggestionsInfo, int offset, int length) {
        if (suggestionsInfo == null || suggestionsInfo.getCookie() != this.mCookie) {
            return null;
        }
        Editable editable = (Editable)this.mTextView.getText();
        int sequenceNumber = suggestionsInfo.getSequence();
        for (int k = 0; k < this.mLength; ++k) {
            if (sequenceNumber != this.mIds[k]) continue;
            int attributes = suggestionsInfo.getSuggestionsAttributes();
            boolean isInDictionary = (attributes & 1) > 0;
            boolean looksLikeTypo = (attributes & 2) > 0;
            SpellCheckSpan spellCheckSpan = this.mSpellCheckSpans[k];
            if (!isInDictionary && looksLikeTypo) {
                this.createMisspelledSuggestionSpan(editable, suggestionsInfo, spellCheckSpan, offset, length);
            } else if (this.mIsSentenceSpellCheckSupported) {
                Long key;
                SuggestionSpan tempSuggestionSpan;
                int end;
                int start;
                int spellCheckSpanStart = editable.getSpanStart(spellCheckSpan);
                int spellCheckSpanEnd = editable.getSpanEnd(spellCheckSpan);
                if (offset != -1 && length != -1) {
                    start = spellCheckSpanStart + offset;
                    end = start + length;
                } else {
                    start = spellCheckSpanStart;
                    end = spellCheckSpanEnd;
                }
                if (spellCheckSpanStart >= 0 && spellCheckSpanEnd > spellCheckSpanStart && end > start && (tempSuggestionSpan = this.mSuggestionSpanCache.get(key = Long.valueOf(TextUtils.packRangeInLong(start, end)))) != null) {
                    editable.removeSpan(tempSuggestionSpan);
                    this.mSuggestionSpanCache.remove(key);
                }
            }
            return spellCheckSpan;
        }
        return null;
    }

    private final void $$robo$$android_widget_SpellChecker$onGetSuggestions(SuggestionsInfo[] results) {
        Editable editable = (Editable)this.mTextView.getText();
        for (int i = 0; i < results.length; ++i) {
            SpellCheckSpan spellCheckSpan = this.onGetSuggestionsInternal(results[i], -1, -1);
            if (spellCheckSpan == null) continue;
            editable.removeSpan(spellCheckSpan);
        }
        this.scheduleNewSpellCheck();
    }

    private final void $$robo$$android_widget_SpellChecker$onGetSentenceSuggestions(SentenceSuggestionsInfo[] results) {
        Editable editable = (Editable)this.mTextView.getText();
        for (int i = 0; i < results.length; ++i) {
            SentenceSuggestionsInfo ssi = results[i];
            if (ssi == null) continue;
            SpellCheckSpan spellCheckSpan = null;
            for (int j = 0; j < ssi.getSuggestionsCount(); ++j) {
                SuggestionsInfo suggestionsInfo = ssi.getSuggestionsInfoAt(j);
                if (suggestionsInfo == null) continue;
                int offset = ssi.getOffsetAt(j);
                int length = ssi.getLengthAt(j);
                SpellCheckSpan scs = this.onGetSuggestionsInternal(suggestionsInfo, offset, length);
                if (spellCheckSpan != null || scs == null) continue;
                spellCheckSpan = scs;
            }
            if (spellCheckSpan == null) continue;
            editable.removeSpan(spellCheckSpan);
        }
        this.scheduleNewSpellCheck();
    }

    private final void $$robo$$android_widget_SpellChecker$scheduleNewSpellCheck() {
        if (this.mSpellRunnable == null) {
            this.mSpellRunnable = new Runnable(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ SpellChecker this$0;

                private void $$robo$$android_widget_SpellChecker_1$__constructor__(SpellChecker this$0) {
                }

                private final void $$robo$$android_widget_SpellChecker_1$run() {
                    int length = this.this$0.mSpellParsers.length;
                    for (int i = 0; i < length; ++i) {
                        SpellParser spellParser = this.this$0.mSpellParsers[i];
                        if (spellParser.isFinished()) continue;
                        spellParser.parse();
                        break;
                    }
                }

                private void __constructor__(SpellChecker spellChecker) {
                    this.$$robo$$android_widget_SpellChecker_1$__constructor__(spellChecker);
                }
                {
                    this.this$0 = spellChecker;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SpellChecker_1$__constructor__(android.widget.SpellChecker ), this, spellChecker);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_SpellChecker_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        } else {
            this.mTextView.removeCallbacks(this.mSpellRunnable);
        }
        this.mTextView.postDelayed(this.mSpellRunnable, 400L);
    }

    private final void $$robo$$android_widget_SpellChecker$createMisspelledSuggestionSpan(Editable editable, SuggestionsInfo suggestionsInfo, SpellCheckSpan spellCheckSpan, int offset, int length) {
        String[] suggestions;
        int end;
        int start;
        int spellCheckSpanStart = editable.getSpanStart(spellCheckSpan);
        int spellCheckSpanEnd = editable.getSpanEnd(spellCheckSpan);
        if (spellCheckSpanStart < 0 || spellCheckSpanEnd <= spellCheckSpanStart) {
            return;
        }
        if (offset != -1 && length != -1) {
            start = spellCheckSpanStart + offset;
            end = start + length;
        } else {
            start = spellCheckSpanStart;
            end = spellCheckSpanEnd;
        }
        int suggestionsCount = suggestionsInfo.getSuggestionsCount();
        if (suggestionsCount > 0) {
            suggestions = new String[suggestionsCount];
            for (int i = 0; i < suggestionsCount; ++i) {
                suggestions[i] = suggestionsInfo.getSuggestionAt(i);
            }
        } else {
            suggestions = ArrayUtils.emptyArray(String.class);
        }
        SuggestionSpan suggestionSpan = new SuggestionSpan(this.mTextView.getContext(), suggestions, 3);
        if (this.mIsSentenceSpellCheckSupported) {
            Long key = TextUtils.packRangeInLong(start, end);
            SuggestionSpan tempSuggestionSpan = this.mSuggestionSpanCache.get(key);
            if (tempSuggestionSpan != null) {
                editable.removeSpan(tempSuggestionSpan);
            }
            this.mSuggestionSpanCache.put(key, suggestionSpan);
        }
        editable.setSpan(suggestionSpan, start, end, 33);
        this.mTextView.invalidateRegion(start, end, false);
    }

    private static final boolean $$robo$$android_widget_SpellChecker$haveWordBoundariesChanged(Editable editable, int start, int end, int spanStart, int spanEnd) {
        boolean haveWordBoundariesChanged;
        if (spanEnd != start && spanStart != end) {
            haveWordBoundariesChanged = true;
        } else if (spanEnd == start && start < editable.length()) {
            int codePoint = Character.codePointAt(editable, start);
            haveWordBoundariesChanged = Character.isLetterOrDigit(codePoint);
        } else if (spanStart == end && end > 0) {
            int codePoint = Character.codePointBefore(editable, end);
            haveWordBoundariesChanged = Character.isLetterOrDigit(codePoint);
        } else {
            haveWordBoundariesChanged = false;
        }
        return haveWordBoundariesChanged;
    }

    static void __staticInitializer__() {
        TAG = SpellChecker.class.getSimpleName();
    }

    private void __constructor__(TextView textView) {
        this.$$robo$$android_widget_SpellChecker$__constructor__(textView);
    }

    public SpellChecker(TextView textView) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SpellChecker$__constructor__(android.widget.TextView ), this, textView);
    }

    private void resetSession() {
        InvokeDynamicSupport.bootstrap("resetSession", $$robo$$android_widget_SpellChecker$resetSession(), this);
    }

    private void setLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setLocale", $$robo$$android_widget_SpellChecker$setLocale(java.util.Locale ), this, locale);
    }

    private boolean isSessionActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSessionActive", $$robo$$android_widget_SpellChecker$isSessionActive(), this);
    }

    public void closeSession() {
        InvokeDynamicSupport.bootstrap("closeSession", $$robo$$android_widget_SpellChecker$closeSession(), this);
    }

    private int nextSpellCheckSpanIndex() {
        return (int)InvokeDynamicSupport.bootstrap("nextSpellCheckSpanIndex", $$robo$$android_widget_SpellChecker$nextSpellCheckSpanIndex(), this);
    }

    private void addSpellCheckSpan(Editable editable, int n, int n2) {
        InvokeDynamicSupport.bootstrap("addSpellCheckSpan", $$robo$$android_widget_SpellChecker$addSpellCheckSpan(android.text.Editable int int ), this, editable, n, n2);
    }

    public void onSpellCheckSpanRemoved(SpellCheckSpan spellCheckSpan) {
        InvokeDynamicSupport.bootstrap("onSpellCheckSpanRemoved", $$robo$$android_widget_SpellChecker$onSpellCheckSpanRemoved(android.text.style.SpellCheckSpan ), this, spellCheckSpan);
    }

    public void onSelectionChanged() {
        InvokeDynamicSupport.bootstrap("onSelectionChanged", $$robo$$android_widget_SpellChecker$onSelectionChanged(), this);
    }

    public void spellCheck(int n, int n2) {
        InvokeDynamicSupport.bootstrap("spellCheck", $$robo$$android_widget_SpellChecker$spellCheck(int int ), this, n, n2);
    }

    private void spellCheck() {
        InvokeDynamicSupport.bootstrap("spellCheck", $$robo$$android_widget_SpellChecker$spellCheck(), this);
    }

    private SpellCheckSpan onGetSuggestionsInternal(SuggestionsInfo suggestionsInfo, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("onGetSuggestionsInternal", $$robo$$android_widget_SpellChecker$onGetSuggestionsInternal(android.view.textservice.SuggestionsInfo int int ), this, suggestionsInfo, n, n2);
    }

    @Override
    public void onGetSuggestions(SuggestionsInfo[] suggestionsInfoArray) {
        InvokeDynamicSupport.bootstrap("onGetSuggestions", $$robo$$android_widget_SpellChecker$onGetSuggestions(android.view.textservice.SuggestionsInfo[] ), this, suggestionsInfoArray);
    }

    @Override
    public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] sentenceSuggestionsInfoArray) {
        InvokeDynamicSupport.bootstrap("onGetSentenceSuggestions", $$robo$$android_widget_SpellChecker$onGetSentenceSuggestions(android.view.textservice.SentenceSuggestionsInfo[] ), this, sentenceSuggestionsInfoArray);
    }

    private void scheduleNewSpellCheck() {
        InvokeDynamicSupport.bootstrap("scheduleNewSpellCheck", $$robo$$android_widget_SpellChecker$scheduleNewSpellCheck(), this);
    }

    private void createMisspelledSuggestionSpan(Editable editable, SuggestionsInfo suggestionsInfo, SpellCheckSpan spellCheckSpan, int n, int n2) {
        InvokeDynamicSupport.bootstrap("createMisspelledSuggestionSpan", $$robo$$android_widget_SpellChecker$createMisspelledSuggestionSpan(android.text.Editable android.view.textservice.SuggestionsInfo android.text.style.SpellCheckSpan int int ), this, editable, suggestionsInfo, spellCheckSpan, n, n2);
    }

    public static boolean haveWordBoundariesChanged(Editable editable, int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("haveWordBoundariesChanged", $$robo$$android_widget_SpellChecker$haveWordBoundariesChanged(android.text.Editable int int int int ), (Editable)editable, (int)n, (int)n2, (int)n3, (int)n4);
    }

    static {
        RobolectricInternals.classInitializing(SpellChecker.class);
    }

    public /* synthetic */ SpellChecker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpellChecker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SpellParser
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Object mRange;
        /* synthetic */ SpellChecker this$0;

        private void $$robo$$android_widget_SpellChecker_SpellParser$__constructor__(SpellChecker spellChecker) {
            this.mRange = new Object();
        }

        private final void $$robo$$android_widget_SpellChecker_SpellParser$parse(int start, int end) {
            int parseEnd;
            int max = this.this$0.mTextView.length();
            if (end > max) {
                Log.w(TAG, "Parse invalid region, from " + start + " to " + end);
                parseEnd = max;
            } else {
                parseEnd = end;
            }
            if (parseEnd > start) {
                this.setRangeSpan((Editable)this.this$0.mTextView.getText(), start, parseEnd);
                this.parse();
            }
        }

        private final boolean $$robo$$android_widget_SpellChecker_SpellParser$isFinished() {
            return ((Editable)this.this$0.mTextView.getText()).getSpanStart(this.mRange) < 0;
        }

        private final void $$robo$$android_widget_SpellChecker_SpellParser$stop() {
            this.removeRangeSpan((Editable)this.this$0.mTextView.getText());
        }

        private final void $$robo$$android_widget_SpellChecker_SpellParser$setRangeSpan(Editable editable, int start, int end) {
            editable.setSpan(this.mRange, start, end, 33);
        }

        private final void $$robo$$android_widget_SpellChecker_SpellParser$removeRangeSpan(Editable editable) {
            editable.removeSpan(this.mRange);
        }

        private final void $$robo$$android_widget_SpellChecker_SpellParser$parse() {
            int wordEnd;
            Editable editable = (Editable)this.this$0.mTextView.getText();
            int start = this.this$0.mIsSentenceSpellCheckSupported ? Math.max(0, editable.getSpanStart(this.mRange) - 50) : editable.getSpanStart(this.mRange);
            int end = editable.getSpanEnd(this.mRange);
            int wordIteratorWindowEnd = Math.min(end, start + 350);
            this.this$0.mWordIterator.setCharSequence(editable, start, wordIteratorWindowEnd);
            int wordStart = this.this$0.mWordIterator.preceding(start);
            if (wordStart == -1) {
                wordEnd = this.this$0.mWordIterator.following(start);
                if (wordEnd != -1) {
                    wordStart = this.this$0.mWordIterator.getBeginning(wordEnd);
                }
            } else {
                wordEnd = this.this$0.mWordIterator.getEnd(wordStart);
            }
            if (wordEnd == -1) {
                this.removeRangeSpan(editable);
                return;
            }
            SpellCheckSpan[] spellCheckSpans = (SpellCheckSpan[])editable.getSpans(start - 1, end + 1, SpellCheckSpan.class);
            SuggestionSpan[] suggestionSpans = (SuggestionSpan[])editable.getSpans(start - 1, end + 1, SuggestionSpan.class);
            int wordCount = 0;
            boolean scheduleOtherSpellCheck = false;
            if (this.this$0.mIsSentenceSpellCheckSupported) {
                int spellCheckEnd;
                boolean correct;
                if (wordIteratorWindowEnd < end) {
                    scheduleOtherSpellCheck = true;
                }
                boolean bl = correct = (spellCheckEnd = this.this$0.mWordIterator.preceding(wordIteratorWindowEnd)) != -1;
                if (correct) {
                    spellCheckEnd = this.this$0.mWordIterator.getEnd(spellCheckEnd);
                    boolean bl2 = correct = spellCheckEnd != -1;
                }
                if (!correct) {
                    this.removeRangeSpan(editable);
                    return;
                }
                int spellCheckStart = wordStart;
                boolean createSpellCheckSpan = true;
                for (int i = 0; i < this.this$0.mLength; ++i) {
                    SpellCheckSpan spellCheckSpan = this.this$0.mSpellCheckSpans[i];
                    if (this.this$0.mIds[i] < 0 || spellCheckSpan.isSpellCheckInProgress()) continue;
                    int spanStart = editable.getSpanStart(spellCheckSpan);
                    int spanEnd = editable.getSpanEnd(spellCheckSpan);
                    if (spanEnd < spellCheckStart || spellCheckEnd < spanStart) continue;
                    if (spanStart <= spellCheckStart && spellCheckEnd <= spanEnd) {
                        createSpellCheckSpan = false;
                        break;
                    }
                    editable.removeSpan(spellCheckSpan);
                    spellCheckStart = Math.min(spanStart, spellCheckStart);
                    spellCheckEnd = Math.max(spanEnd, spellCheckEnd);
                }
                if (spellCheckEnd >= start) {
                    if (spellCheckEnd <= spellCheckStart) {
                        Log.w(TAG, "Trying to spellcheck invalid region, from " + start + " to " + end);
                    } else if (createSpellCheckSpan) {
                        this.this$0.addSpellCheckSpan(editable, spellCheckStart, spellCheckEnd);
                    }
                }
                wordStart = spellCheckEnd;
            } else {
                while (wordStart <= end) {
                    if (wordEnd >= start && wordEnd > wordStart) {
                        int i;
                        if (wordCount >= 50) {
                            scheduleOtherSpellCheck = true;
                            break;
                        }
                        if (wordStart < start && wordEnd > start) {
                            this.removeSpansAt(editable, start, spellCheckSpans);
                            this.removeSpansAt(editable, start, suggestionSpans);
                        }
                        if (wordStart < end && wordEnd > end) {
                            this.removeSpansAt(editable, end, spellCheckSpans);
                            this.removeSpansAt(editable, end, suggestionSpans);
                        }
                        boolean createSpellCheckSpan = true;
                        if (wordEnd == start) {
                            for (i = 0; i < spellCheckSpans.length; ++i) {
                                int spanEnd = editable.getSpanEnd(spellCheckSpans[i]);
                                if (spanEnd != start) continue;
                                createSpellCheckSpan = false;
                                break;
                            }
                        }
                        if (wordStart == end) {
                            for (i = 0; i < spellCheckSpans.length; ++i) {
                                int spanStart = editable.getSpanStart(spellCheckSpans[i]);
                                if (spanStart != end) continue;
                                createSpellCheckSpan = false;
                                break;
                            }
                        }
                        if (createSpellCheckSpan) {
                            this.this$0.addSpellCheckSpan(editable, wordStart, wordEnd);
                        }
                        ++wordCount;
                    }
                    int originalWordEnd = wordEnd;
                    wordEnd = this.this$0.mWordIterator.following(wordEnd);
                    if (wordIteratorWindowEnd < end && (wordEnd == -1 || wordEnd >= wordIteratorWindowEnd)) {
                        wordIteratorWindowEnd = Math.min(end, originalWordEnd + 350);
                        this.this$0.mWordIterator.setCharSequence(editable, originalWordEnd, wordIteratorWindowEnd);
                        wordEnd = this.this$0.mWordIterator.following(originalWordEnd);
                    }
                    if (wordEnd != -1 && (wordStart = this.this$0.mWordIterator.getBeginning(wordEnd)) != -1) continue;
                    break;
                }
            }
            if (scheduleOtherSpellCheck && wordStart != -1 && wordStart <= end) {
                this.setRangeSpan(editable, wordStart, end);
            } else {
                this.removeRangeSpan(editable);
            }
            this.this$0.spellCheck();
        }

        private final <T> void $$robo$$android_widget_SpellChecker_SpellParser$removeSpansAt(Editable editable, int offset, T[] spans) {
            for (T span : spans) {
                int end;
                int start = editable.getSpanStart(span);
                if (start > offset || (end = editable.getSpanEnd(span)) < offset) continue;
                editable.removeSpan(span);
            }
        }

        private /* synthetic */ void $$robo$$android_widget_SpellChecker_SpellParser$__constructor__(SpellChecker x0, 1 x1) {
        }

        private void __constructor__(SpellChecker spellChecker) {
            this.$$robo$$android_widget_SpellChecker_SpellParser$__constructor__(spellChecker);
        }

        public SpellParser(SpellChecker spellChecker) {
            this.this$0 = spellChecker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SpellChecker_SpellParser$__constructor__(android.widget.SpellChecker ), this, spellChecker);
        }

        public void parse(int n, int n2) {
            InvokeDynamicSupport.bootstrap("parse", $$robo$$android_widget_SpellChecker_SpellParser$parse(int int ), this, n, n2);
        }

        public boolean isFinished() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFinished", $$robo$$android_widget_SpellChecker_SpellParser$isFinished(), this);
        }

        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_widget_SpellChecker_SpellParser$stop(), this);
        }

        private void setRangeSpan(Editable editable, int n, int n2) {
            InvokeDynamicSupport.bootstrap("setRangeSpan", $$robo$$android_widget_SpellChecker_SpellParser$setRangeSpan(android.text.Editable int int ), this, editable, n, n2);
        }

        private void removeRangeSpan(Editable editable) {
            InvokeDynamicSupport.bootstrap("removeRangeSpan", $$robo$$android_widget_SpellChecker_SpellParser$removeRangeSpan(android.text.Editable ), this, editable);
        }

        public void parse() {
            InvokeDynamicSupport.bootstrap("parse", $$robo$$android_widget_SpellChecker_SpellParser$parse(), this);
        }

        private <T> void removeSpansAt(Editable editable, int n, T[] TArray) {
            InvokeDynamicSupport.bootstrap("removeSpansAt", $$robo$$android_widget_SpellChecker_SpellParser$removeSpansAt(android.text.Editable int T[] ), this, editable, n, TArray);
        }

        private /* synthetic */ void __constructor__(SpellChecker spellChecker, 1 var2_2) {
            this.$$robo$$android_widget_SpellChecker_SpellParser$__constructor__(spellChecker, var2_2);
        }

        public /* synthetic */ SpellParser(SpellChecker spellChecker, 1 var2_2) {
            this(spellChecker);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SpellChecker_SpellParser$__constructor__(android.widget.SpellChecker android.widget.SpellChecker$1 ), this, spellChecker, var2_2);
        }

        public /* synthetic */ SpellParser() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpellParser)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

