/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.os.AsyncTask;
import android.os.LocaleList;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.ActionMode;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextSelection;
import android.widget.Editor;
import android.widget.TextView;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SelectionActionModeHelper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int TIMEOUT_DURATION = 200;
    private Editor mEditor;
    private TextClassificationHelper mTextClassificationHelper;
    private TextClassification mTextClassification;
    private AsyncTask mTextClassificationAsyncTask;
    private SelectionTracker mSelectionTracker;

    private void $$robo$$android_widget_SelectionActionModeHelper$__constructor__(Editor editor) {
        this.mEditor = Preconditions.checkNotNull(editor);
        TextView textView = this.mEditor.getTextView();
        this.mTextClassificationHelper = new TextClassificationHelper(textView.getTextClassifier(), textView.getText(), 0, 1, textView.getTextLocales());
        this.mSelectionTracker = new SelectionTracker(textView.getTextClassifier());
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$startActionModeAsync(boolean adjustSelection) {
        this.cancelAsyncTask();
        if (this.isNoOpTextClassifier() || !this.hasSelection()) {
            this.startActionMode(null);
        } else {
            this.resetTextClassificationHelper(true);
            TextView tv = this.mEditor.getTextView();
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(tv, 200, adjustSelection ? this.mTextClassificationHelper::suggestSelection : this.mTextClassificationHelper::classifyText, this::startActionMode).execute(new Void[0]);
        }
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$invalidateActionModeAsync() {
        this.cancelAsyncTask();
        if (this.isNoOpTextClassifier() || !this.hasSelection()) {
            this.invalidateActionMode(null);
        } else {
            this.resetTextClassificationHelper(false);
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(this.mEditor.getTextView(), 200, this.mTextClassificationHelper::classifyText, this::invalidateActionMode).execute(new Void[0]);
        }
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$onSelectionAction() {
        this.mSelectionTracker.onSelectionAction(this.mTextClassificationHelper.getSelectionTag());
    }

    private final boolean $$robo$$android_widget_SelectionActionModeHelper$resetSelection(int textIndex) {
        if (this.mSelectionTracker.resetSelection(textIndex, this.mEditor, this.mTextClassificationHelper.getSelectionTag())) {
            this.invalidateActionModeAsync();
            return true;
        }
        return false;
    }

    private final TextClassification $$robo$$android_widget_SelectionActionModeHelper$getTextClassification() {
        return this.mTextClassification;
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$onDestroyActionMode() {
        this.mSelectionTracker.onSelectionDestroyed();
        this.cancelAsyncTask();
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$cancelAsyncTask() {
        if (this.mTextClassificationAsyncTask != null) {
            this.mTextClassificationAsyncTask.cancel(true);
            this.mTextClassificationAsyncTask = null;
        }
        this.mTextClassification = null;
    }

    private final boolean $$robo$$android_widget_SelectionActionModeHelper$isNoOpTextClassifier() {
        return this.mEditor.getTextView().getTextClassifier() == TextClassifier.NO_OP;
    }

    private final boolean $$robo$$android_widget_SelectionActionModeHelper$hasSelection() {
        TextView textView = this.mEditor.getTextView();
        return textView.getSelectionEnd() > textView.getSelectionStart();
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$startActionMode(SelectionResult result) {
        TextView textView = this.mEditor.getTextView();
        CharSequence text = textView.getText();
        this.mSelectionTracker.setOriginalSelection(textView.getSelectionStart(), textView.getSelectionEnd());
        if (result != null && text instanceof Spannable) {
            Selection.setSelection((Spannable)text, result.mStart, result.mEnd);
            this.mTextClassification = result.mClassification;
        } else {
            this.mTextClassification = null;
        }
        if (this.mEditor.startSelectionActionModeInternal()) {
            Editor.SelectionModifierCursorController controller = this.mEditor.getSelectionController();
            if (controller != null) {
                controller.show();
            }
            if (result != null) {
                this.mSelectionTracker.onSelectionStarted(result.mStart, result.mEnd, this.mTextClassificationHelper.getSelectionTag());
            }
        }
        this.mEditor.setRestartActionModeOnNextRefresh(false);
        this.mTextClassificationAsyncTask = null;
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$invalidateActionMode(SelectionResult result) {
        this.mTextClassification = result != null ? result.mClassification : null;
        ActionMode actionMode = this.mEditor.getTextActionMode();
        if (actionMode != null) {
            actionMode.invalidate();
        }
        TextView textView = this.mEditor.getTextView();
        this.mSelectionTracker.onSelectionUpdated(textView.getSelectionStart(), textView.getSelectionEnd(), this.mTextClassificationHelper.getSelectionTag());
        this.mTextClassificationAsyncTask = null;
    }

    private final void $$robo$$android_widget_SelectionActionModeHelper$resetTextClassificationHelper(boolean resetSelectionTag) {
        TextView textView = this.mEditor.getTextView();
        this.mTextClassificationHelper.reset(textView.getTextClassifier(), textView.getText(), textView.getSelectionStart(), textView.getSelectionEnd(), resetSelectionTag, textView.getTextLocales());
    }

    private void __constructor__(Editor editor) {
        this.$$robo$$android_widget_SelectionActionModeHelper$__constructor__(editor);
    }

    public SelectionActionModeHelper(Editor editor) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper$__constructor__(android.widget.Editor ), this, editor);
    }

    public void startActionModeAsync(boolean bl) {
        InvokeDynamicSupport.bootstrap("startActionModeAsync", $$robo$$android_widget_SelectionActionModeHelper$startActionModeAsync(boolean ), this, bl);
    }

    public void invalidateActionModeAsync() {
        InvokeDynamicSupport.bootstrap("invalidateActionModeAsync", $$robo$$android_widget_SelectionActionModeHelper$invalidateActionModeAsync(), this);
    }

    public void onSelectionAction() {
        InvokeDynamicSupport.bootstrap("onSelectionAction", $$robo$$android_widget_SelectionActionModeHelper$onSelectionAction(), this);
    }

    public boolean resetSelection(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("resetSelection", $$robo$$android_widget_SelectionActionModeHelper$resetSelection(int ), this, n);
    }

    public TextClassification getTextClassification() {
        return InvokeDynamicSupport.bootstrap("getTextClassification", $$robo$$android_widget_SelectionActionModeHelper$getTextClassification(), this);
    }

    public void onDestroyActionMode() {
        InvokeDynamicSupport.bootstrap("onDestroyActionMode", $$robo$$android_widget_SelectionActionModeHelper$onDestroyActionMode(), this);
    }

    private void cancelAsyncTask() {
        InvokeDynamicSupport.bootstrap("cancelAsyncTask", $$robo$$android_widget_SelectionActionModeHelper$cancelAsyncTask(), this);
    }

    private boolean isNoOpTextClassifier() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNoOpTextClassifier", $$robo$$android_widget_SelectionActionModeHelper$isNoOpTextClassifier(), this);
    }

    private boolean hasSelection() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasSelection", $$robo$$android_widget_SelectionActionModeHelper$hasSelection(), this);
    }

    private void startActionMode(SelectionResult selectionResult) {
        InvokeDynamicSupport.bootstrap("startActionMode", $$robo$$android_widget_SelectionActionModeHelper$startActionMode(android.widget.SelectionActionModeHelper$SelectionResult ), this, selectionResult);
    }

    private void invalidateActionMode(SelectionResult selectionResult) {
        InvokeDynamicSupport.bootstrap("invalidateActionMode", $$robo$$android_widget_SelectionActionModeHelper$invalidateActionMode(android.widget.SelectionActionModeHelper$SelectionResult ), this, selectionResult);
    }

    private void resetTextClassificationHelper(boolean bl) {
        InvokeDynamicSupport.bootstrap("resetTextClassificationHelper", $$robo$$android_widget_SelectionActionModeHelper$resetTextClassificationHelper(boolean ), this, bl);
    }

    public /* synthetic */ SelectionActionModeHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionActionModeHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SelectionResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mStart;
        private int mEnd;
        private TextClassification mClassification;

        private void $$robo$$android_widget_SelectionActionModeHelper_SelectionResult$__constructor__(int start, int end, TextClassification classification) {
            this.mStart = start;
            this.mEnd = end;
            this.mClassification = Preconditions.checkNotNull(classification);
        }

        private void __constructor__(int n, int n2, TextClassification textClassification) {
            this.$$robo$$android_widget_SelectionActionModeHelper_SelectionResult$__constructor__(n, n2, textClassification);
        }

        public SelectionResult(int n, int n2, TextClassification textClassification) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper_SelectionResult$__constructor__(int int android.view.textclassifier.TextClassification ), this, n, n2, textClassification);
        }

        public /* synthetic */ SelectionResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class TextClassificationHelper
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int TRIM_DELTA = 120;
        private TextClassifier mTextClassifier;
        private String mText;
        private int mSelectionStart;
        private int mSelectionEnd;
        private LocaleList mLocales;
        private String mSelectionTag;
        private CharSequence mTrimmedText;
        private int mTrimStart;
        private int mRelativeStart;
        private int mRelativeEnd;
        private CharSequence mLastClassificationText;
        private int mLastClassificationSelectionStart;
        private int mLastClassificationSelectionEnd;
        private LocaleList mLastClassificationLocales;
        private SelectionResult mLastClassificationResult;

        private void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$__constructor__(TextClassifier textClassifier, CharSequence text, int selectionStart, int selectionEnd, LocaleList locales) {
            this.mSelectionTag = "";
            this.reset(textClassifier, text, selectionStart, selectionEnd, true, locales);
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$reset(TextClassifier textClassifier, CharSequence text, int selectionStart, int selectionEnd, boolean resetSelectionTag, LocaleList locales) {
            this.mTextClassifier = Preconditions.checkNotNull(textClassifier);
            this.mText = Preconditions.checkNotNull(text).toString();
            this.mLastClassificationText = null;
            Preconditions.checkArgument(selectionEnd > selectionStart);
            this.mSelectionStart = selectionStart;
            this.mSelectionEnd = selectionEnd;
            this.mLocales = locales;
            if (resetSelectionTag) {
                this.mSelectionTag = "";
            }
        }

        private final SelectionResult $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$classifyText() {
            if (!Objects.equals(this.mText, this.mLastClassificationText) || this.mSelectionStart != this.mLastClassificationSelectionStart || this.mSelectionEnd != this.mLastClassificationSelectionEnd || !Objects.equals(this.mLocales, this.mLastClassificationLocales)) {
                this.mLastClassificationText = this.mText;
                this.mLastClassificationSelectionStart = this.mSelectionStart;
                this.mLastClassificationSelectionEnd = this.mSelectionEnd;
                this.mLastClassificationLocales = this.mLocales;
                this.trimText();
                this.mLastClassificationResult = new SelectionResult(this.mSelectionStart, this.mSelectionEnd, this.mTextClassifier.classifyText(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mLocales));
            }
            return this.mLastClassificationResult;
        }

        private final SelectionResult $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$suggestSelection() {
            this.trimText();
            TextSelection sel = this.mTextClassifier.suggestSelection(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd, this.mLocales);
            this.mSelectionStart = Math.max(0, sel.getSelectionStartIndex() + this.mTrimStart);
            this.mSelectionEnd = Math.min(this.mText.length(), sel.getSelectionEndIndex() + this.mTrimStart);
            this.mSelectionTag = sel.getSourceClassifier();
            return this.classifyText();
        }

        private final String $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$getSelectionTag() {
            return this.mSelectionTag;
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$trimText() {
            this.mTrimStart = Math.max(0, this.mSelectionStart - 120);
            int referenceEnd = Math.min(this.mText.length(), this.mSelectionEnd + 120);
            this.mTrimmedText = this.mText.subSequence(this.mTrimStart, referenceEnd);
            this.mRelativeStart = this.mSelectionStart - this.mTrimStart;
            this.mRelativeEnd = this.mSelectionEnd - this.mTrimStart;
        }

        private void __constructor__(TextClassifier textClassifier, CharSequence charSequence, int n, int n2, LocaleList localeList) {
            this.$$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$__constructor__(textClassifier, charSequence, n, n2, localeList);
        }

        public TextClassificationHelper(TextClassifier textClassifier, CharSequence charSequence, int n, int n2, LocaleList localeList) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$__constructor__(android.view.textclassifier.TextClassifier java.lang.CharSequence int int android.os.LocaleList ), this, textClassifier, charSequence, n, n2, localeList);
        }

        public void reset(TextClassifier textClassifier, CharSequence charSequence, int n, int n2, boolean bl, LocaleList localeList) {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$reset(android.view.textclassifier.TextClassifier java.lang.CharSequence int int boolean android.os.LocaleList ), this, textClassifier, charSequence, n, n2, bl, localeList);
        }

        public SelectionResult classifyText() {
            return InvokeDynamicSupport.bootstrap("classifyText", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$classifyText(), this);
        }

        public SelectionResult suggestSelection() {
            return InvokeDynamicSupport.bootstrap("suggestSelection", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$suggestSelection(), this);
        }

        String getSelectionTag() {
            return InvokeDynamicSupport.bootstrap("getSelectionTag", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$getSelectionTag(), this);
        }

        private void trimText() {
            InvokeDynamicSupport.bootstrap("trimText", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationHelper$trimText(), this);
        }

        public /* synthetic */ TextClassificationHelper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassificationHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class TextClassificationAsyncTask
    extends AsyncTask<Void, Void, SelectionResult> {
        public /* synthetic */ Object __robo_data__;
        private int mTimeOutDuration;
        private Supplier<SelectionResult> mSelectionResultSupplier;
        private Consumer<SelectionResult> mSelectionResultCallback;
        private TextView mTextView;
        private String mOriginalText;

        private void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$__constructor__(TextView textView, int timeOut, Supplier<SelectionResult> selectionResultSupplier, Consumer<SelectionResult> selectionResultCallback) {
            this.mTextView = Preconditions.checkNotNull(textView);
            this.mTimeOutDuration = timeOut;
            this.mSelectionResultSupplier = Preconditions.checkNotNull(selectionResultSupplier);
            this.mSelectionResultCallback = Preconditions.checkNotNull(selectionResultCallback);
            this.mOriginalText = this.mTextView.getText().toString();
        }

        private final SelectionResult $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$doInBackground(Void ... params) {
            Runnable onTimeOut = this::onTimeOut;
            this.mTextView.postDelayed(onTimeOut, this.mTimeOutDuration);
            SelectionResult result = this.mSelectionResultSupplier.get();
            this.mTextView.removeCallbacks(onTimeOut);
            return result;
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$onPostExecute(SelectionResult result) {
            result = TextUtils.equals(this.mOriginalText, this.mTextView.getText()) ? result : null;
            this.mSelectionResultCallback.accept(result);
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$onTimeOut() {
            if (this.getStatus() == AsyncTask.Status.RUNNING) {
                this.onPostExecute(null);
            }
            this.cancel(true);
        }

        private void __constructor__(TextView textView, int n, Supplier<SelectionResult> supplier, Consumer<SelectionResult> consumer) {
            this.$$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$__constructor__(textView, n, supplier, consumer);
        }

        public TextClassificationAsyncTask(TextView textView, int n, Supplier<SelectionResult> supplier, Consumer<SelectionResult> consumer) {
            super(textView != null ? textView.getHandler() : null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$__constructor__(android.widget.TextView int java.util.function.Supplier<android.widget.SelectionActionModeHelper$SelectionResult> java.util.function.Consumer<android.widget.SelectionActionModeHelper$SelectionResult> ), this, textView, n, supplier, consumer);
        }

        protected SelectionResult doInBackground(Void ... voidArray) {
            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$doInBackground(java.lang.Void[] ), this, voidArray);
        }

        @Override
        protected void onPostExecute(SelectionResult selectionResult) {
            InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$onPostExecute(android.widget.SelectionActionModeHelper$SelectionResult ), this, selectionResult);
        }

        private void onTimeOut() {
            InvokeDynamicSupport.bootstrap("onTimeOut", $$robo$$android_widget_SelectionActionModeHelper_TextClassificationAsyncTask$onTimeOut(), this);
        }

        public /* synthetic */ TextClassificationAsyncTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassificationAsyncTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class SelectionTracker
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static String LOG_EVENT_MULTI_SELECTION = "textClassifier_multiSelection";
        private static String LOG_EVENT_SINGLE_SELECTION = "textClassifier_singleSelection";
        private static String LOG_EVENT_MULTI_SELECTION_ACTION = "textClassifier_multiSelection_action";
        private static String LOG_EVENT_SINGLE_SELECTION_ACTION = "textClassifier_singleSelection_action";
        private static String LOG_EVENT_MULTI_SELECTION_RESET = "textClassifier_multiSelection_reset";
        private static String LOG_EVENT_MULTI_SELECTION_MODIFIED = "textClassifier_multiSelection_modified";
        private static String LOG_EVENT_SINGLE_SELECTION_MODIFIED = "textClassifier_singleSelection_modified";
        private TextClassifier mClassifier;
        private int mOriginalStart;
        private int mOriginalEnd;
        private int mSelectionStart;
        private int mSelectionEnd;
        private boolean mMultiSelection;
        private boolean mClassifierSelection;

        private void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$__constructor__(TextClassifier classifier) {
            this.mClassifier = classifier;
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$setOriginalSelection(int selectionStart, int selectionEnd) {
            this.mOriginalStart = selectionStart;
            this.mOriginalEnd = selectionEnd;
            this.resetSelectionFlags();
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionStarted(int selectionStart, int selectionEnd, String logTag) {
            this.mClassifierSelection = !logTag.isEmpty();
            this.mSelectionStart = selectionStart;
            this.mSelectionEnd = selectionEnd;
            boolean bl = this.mMultiSelection = this.mSelectionStart != this.mOriginalStart || this.mSelectionEnd != this.mOriginalEnd;
            if (this.mMultiSelection) {
                this.mClassifier.logEvent(logTag, "textClassifier_multiSelection");
            } else if (this.mClassifierSelection) {
                this.mClassifier.logEvent(logTag, "textClassifier_singleSelection");
            }
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionUpdated(int selectionStart, int selectionEnd, String logTag) {
            boolean selectionChanged;
            boolean bl = selectionChanged = selectionStart != this.mSelectionStart || selectionEnd != this.mSelectionEnd;
            if (selectionChanged) {
                if (this.mMultiSelection) {
                    this.mClassifier.logEvent(logTag, "textClassifier_multiSelection_modified");
                } else if (this.mClassifierSelection) {
                    this.mClassifier.logEvent(logTag, "textClassifier_singleSelection_modified");
                }
                this.resetSelectionFlags();
            }
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionDestroyed() {
            this.resetSelectionFlags();
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionAction(String logTag) {
            if (this.mMultiSelection) {
                this.mClassifier.logEvent(logTag, "textClassifier_multiSelection_action");
            } else if (this.mClassifierSelection) {
                this.mClassifier.logEvent(logTag, "textClassifier_singleSelection_action");
            }
        }

        private final boolean $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$resetSelection(int textIndex, Editor editor, String logTag) {
            CharSequence text = editor.getTextView().getText();
            if (this.mMultiSelection && textIndex >= this.mSelectionStart && textIndex <= this.mSelectionEnd && text instanceof Spannable) {
                this.resetSelectionFlags();
                this.mClassifier.logEvent(logTag, "textClassifier_multiSelection_reset");
                return editor.selectCurrentWord();
            }
            return false;
        }

        private final void $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$resetSelectionFlags() {
            this.mMultiSelection = false;
            this.mClassifierSelection = false;
        }

        private void __constructor__(TextClassifier textClassifier) {
            this.$$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$__constructor__(textClassifier);
        }

        public SelectionTracker(TextClassifier textClassifier) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$__constructor__(android.view.textclassifier.TextClassifier ), this, textClassifier);
        }

        public void setOriginalSelection(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setOriginalSelection", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$setOriginalSelection(int int ), this, n, n2);
        }

        public void onSelectionStarted(int n, int n2, String string2) {
            InvokeDynamicSupport.bootstrap("onSelectionStarted", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionStarted(int int java.lang.String ), this, n, n2, string2);
        }

        public void onSelectionUpdated(int n, int n2, String string2) {
            InvokeDynamicSupport.bootstrap("onSelectionUpdated", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionUpdated(int int java.lang.String ), this, n, n2, string2);
        }

        public void onSelectionDestroyed() {
            InvokeDynamicSupport.bootstrap("onSelectionDestroyed", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionDestroyed(), this);
        }

        public void onSelectionAction(String string2) {
            InvokeDynamicSupport.bootstrap("onSelectionAction", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$onSelectionAction(java.lang.String ), this, string2);
        }

        public boolean resetSelection(int n, Editor editor, String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("resetSelection", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$resetSelection(int android.widget.Editor java.lang.String ), this, n, editor, string2);
        }

        private void resetSelectionFlags() {
            InvokeDynamicSupport.bootstrap("resetSelectionFlags", $$robo$$android_widget_SelectionActionModeHelper_SelectionTracker$resetSelectionFlags(), this);
        }

        public /* synthetic */ SelectionTracker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

