/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.DropDownListView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import com.android.internal.R;
import com.android.internal.view.menu.ShowableListMenu;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ListPopupWindow
implements ShowableListMenu,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ListPopupWindow";
    private static boolean DEBUG = false;
    private static int EXPAND_LIST_TIMEOUT = 250;
    private Context mContext;
    private ListAdapter mAdapter;
    private DropDownListView mDropDownList;
    private int mDropDownHeight;
    private int mDropDownWidth;
    private int mDropDownHorizontalOffset;
    private int mDropDownVerticalOffset;
    private int mDropDownWindowLayoutType;
    private boolean mDropDownVerticalOffsetSet;
    private boolean mIsAnimatedFromAnchor;
    private boolean mOverlapAnchor;
    private boolean mOverlapAnchorSet;
    private int mDropDownGravity;
    private boolean mDropDownAlwaysVisible;
    private boolean mForceIgnoreOutsideTouch;
    int mListItemExpandMaximum;
    private View mPromptView;
    private int mPromptPosition;
    private DataSetObserver mObserver;
    private View mDropDownAnchorView;
    private Drawable mDropDownListHighlight;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    private ResizePopupRunnable mResizePopupRunnable;
    private PopupTouchInterceptor mTouchInterceptor;
    private PopupScrollListener mScrollListener;
    private ListSelectorHider mHideSelector;
    private Runnable mShowDropDownRunnable;
    private Handler mHandler;
    private Rect mTempRect;
    private Rect mEpicenterBounds;
    private boolean mModal;
    PopupWindow mPopup;
    public static int POSITION_PROMPT_ABOVE = 0;
    public static int POSITION_PROMPT_BELOW = 1;
    public static int MATCH_PARENT = -1;
    public static int WRAP_CONTENT = -2;
    public static int INPUT_METHOD_FROM_FOCUSABLE = 0;
    public static int INPUT_METHOD_NEEDED = 1;
    public static int INPUT_METHOD_NOT_NEEDED = 2;

    private void $$robo$$android_widget_ListPopupWindow$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_ListPopupWindow$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_ListPopupWindow$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_ListPopupWindow$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mDropDownHeight = -2;
        this.mDropDownWidth = -2;
        this.mDropDownWindowLayoutType = 1002;
        this.mIsAnimatedFromAnchor = true;
        this.mDropDownGravity = 0;
        this.mDropDownAlwaysVisible = false;
        this.mForceIgnoreOutsideTouch = false;
        this.mListItemExpandMaximum = Integer.MAX_VALUE;
        this.mPromptPosition = 0;
        this.mResizePopupRunnable = new ResizePopupRunnable(this, null);
        this.mTouchInterceptor = new PopupTouchInterceptor(this, null);
        this.mScrollListener = new PopupScrollListener(this, null);
        this.mHideSelector = new ListSelectorHider(this, null);
        this.mTempRect = new Rect();
        this.mContext = context;
        this.mHandler = new Handler(context.getMainLooper());
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ListPopupWindow, defStyleAttr, defStyleRes);
        this.mDropDownHorizontalOffset = a.getDimensionPixelOffset(0, 0);
        this.mDropDownVerticalOffset = a.getDimensionPixelOffset(1, 0);
        if (this.mDropDownVerticalOffset != 0) {
            this.mDropDownVerticalOffsetSet = true;
        }
        a.recycle();
        this.mPopup = new PopupWindow(context, attrs, defStyleAttr, defStyleRes);
        this.mPopup.setInputMethodMode(1);
    }

    private final void $$robo$$android_widget_ListPopupWindow$setAdapter(ListAdapter adapter) {
        if (this.mObserver == null) {
            this.mObserver = new PopupDataSetObserver(this, null);
        } else if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
        }
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            adapter.registerDataSetObserver(this.mObserver);
        }
        if (this.mDropDownList != null) {
            this.mDropDownList.setAdapter(this.mAdapter);
        }
    }

    private final void $$robo$$android_widget_ListPopupWindow$setPromptPosition(int position) {
        this.mPromptPosition = position;
    }

    private final int $$robo$$android_widget_ListPopupWindow$getPromptPosition() {
        return this.mPromptPosition;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setModal(boolean modal) {
        this.mModal = modal;
        this.mPopup.setFocusable(modal);
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$isModal() {
        return this.mModal;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setForceIgnoreOutsideTouch(boolean forceIgnoreOutsideTouch) {
        this.mForceIgnoreOutsideTouch = forceIgnoreOutsideTouch;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setDropDownAlwaysVisible(boolean dropDownAlwaysVisible) {
        this.mDropDownAlwaysVisible = dropDownAlwaysVisible;
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$isDropDownAlwaysVisible() {
        return this.mDropDownAlwaysVisible;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setSoftInputMode(int mode) {
        this.mPopup.setSoftInputMode(mode);
    }

    private final int $$robo$$android_widget_ListPopupWindow$getSoftInputMode() {
        return this.mPopup.getSoftInputMode();
    }

    private final void $$robo$$android_widget_ListPopupWindow$setListSelector(Drawable selector) {
        this.mDropDownListHighlight = selector;
    }

    private final Drawable $$robo$$android_widget_ListPopupWindow$getBackground() {
        return this.mPopup.getBackground();
    }

    private final void $$robo$$android_widget_ListPopupWindow$setBackgroundDrawable(Drawable d) {
        this.mPopup.setBackgroundDrawable(d);
    }

    private final void $$robo$$android_widget_ListPopupWindow$setAnimationStyle(int animationStyle) {
        this.mPopup.setAnimationStyle(animationStyle);
    }

    private final int $$robo$$android_widget_ListPopupWindow$getAnimationStyle() {
        return this.mPopup.getAnimationStyle();
    }

    private final View $$robo$$android_widget_ListPopupWindow$getAnchorView() {
        return this.mDropDownAnchorView;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setAnchorView(View anchor) {
        this.mDropDownAnchorView = anchor;
    }

    private final int $$robo$$android_widget_ListPopupWindow$getHorizontalOffset() {
        return this.mDropDownHorizontalOffset;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setHorizontalOffset(int offset) {
        this.mDropDownHorizontalOffset = offset;
    }

    private final int $$robo$$android_widget_ListPopupWindow$getVerticalOffset() {
        if (!this.mDropDownVerticalOffsetSet) {
            return 0;
        }
        return this.mDropDownVerticalOffset;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setVerticalOffset(int offset) {
        this.mDropDownVerticalOffset = offset;
        this.mDropDownVerticalOffsetSet = true;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setEpicenterBounds(Rect bounds) {
        this.mEpicenterBounds = bounds;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setDropDownGravity(int gravity) {
        this.mDropDownGravity = gravity;
    }

    private final int $$robo$$android_widget_ListPopupWindow$getWidth() {
        return this.mDropDownWidth;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setWidth(int width) {
        this.mDropDownWidth = width;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setContentWidth(int width) {
        Drawable popupBackground = this.mPopup.getBackground();
        if (popupBackground != null) {
            popupBackground.getPadding(this.mTempRect);
            this.mDropDownWidth = this.mTempRect.left + this.mTempRect.right + width;
        } else {
            this.setWidth(width);
        }
    }

    private final int $$robo$$android_widget_ListPopupWindow$getHeight() {
        return this.mDropDownHeight;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setHeight(int height) {
        if (height < 0 && -2 != height && -1 != height) {
            if (this.mContext.getApplicationInfo().targetSdkVersion < 26) {
                Log.e("ListPopupWindow", "Negative value " + height + " passed to ListPopupWindow#setHeight produces undefined results");
            } else {
                throw new IllegalArgumentException("Invalid height. Must be a positive value, MATCH_PARENT, or WRAP_CONTENT.");
            }
        }
        this.mDropDownHeight = height;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setWindowLayoutType(int layoutType) {
        this.mDropDownWindowLayoutType = layoutType;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setOnItemClickListener(AdapterView.OnItemClickListener clickListener) {
        this.mItemClickListener = clickListener;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setOnItemSelectedListener(AdapterView.OnItemSelectedListener selectedListener) {
        this.mItemSelectedListener = selectedListener;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setPromptView(View prompt) {
        boolean showing = this.isShowing();
        if (showing) {
            this.removePromptView();
        }
        this.mPromptView = prompt;
        if (showing) {
            this.show();
        }
    }

    private final void $$robo$$android_widget_ListPopupWindow$postShow() {
        this.mHandler.post(this.mShowDropDownRunnable);
    }

    private final void $$robo$$android_widget_ListPopupWindow$show() {
        int height = this.buildDropDown();
        boolean noInputMethod = this.isInputMethodNotNeeded();
        this.mPopup.setAllowScrollingAnchorParent(!noInputMethod);
        this.mPopup.setWindowLayoutType(this.mDropDownWindowLayoutType);
        if (this.mPopup.isShowing()) {
            int heightSpec;
            if (!this.getAnchorView().isAttachedToWindow()) {
                return;
            }
            int widthSpec = this.mDropDownWidth == -1 ? -1 : (this.mDropDownWidth == -2 ? this.getAnchorView().getWidth() : this.mDropDownWidth);
            if (this.mDropDownHeight == -1) {
                int n = heightSpec = noInputMethod ? height : -1;
                if (noInputMethod) {
                    this.mPopup.setWidth(this.mDropDownWidth == -1 ? -1 : 0);
                    this.mPopup.setHeight(0);
                } else {
                    this.mPopup.setWidth(this.mDropDownWidth == -1 ? -1 : 0);
                    this.mPopup.setHeight(-1);
                }
            } else {
                heightSpec = this.mDropDownHeight == -2 ? height : this.mDropDownHeight;
            }
            this.mPopup.setOutsideTouchable(!this.mForceIgnoreOutsideTouch && !this.mDropDownAlwaysVisible);
            this.mPopup.update(this.getAnchorView(), this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset, widthSpec < 0 ? -1 : widthSpec, heightSpec < 0 ? -1 : heightSpec);
        } else {
            int widthSpec = this.mDropDownWidth == -1 ? -1 : (this.mDropDownWidth == -2 ? this.getAnchorView().getWidth() : this.mDropDownWidth);
            int heightSpec = this.mDropDownHeight == -1 ? -1 : (this.mDropDownHeight == -2 ? height : this.mDropDownHeight);
            this.mPopup.setWidth(widthSpec);
            this.mPopup.setHeight(heightSpec);
            this.mPopup.setClipToScreenEnabled(true);
            this.mPopup.setOutsideTouchable(!this.mForceIgnoreOutsideTouch && !this.mDropDownAlwaysVisible);
            this.mPopup.setTouchInterceptor(this.mTouchInterceptor);
            this.mPopup.setEpicenterBounds(this.mEpicenterBounds);
            if (this.mOverlapAnchorSet) {
                this.mPopup.setOverlapAnchor(this.mOverlapAnchor);
            }
            this.mPopup.showAsDropDown(this.getAnchorView(), this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset, this.mDropDownGravity);
            this.mDropDownList.setSelection(-1);
            if (!this.mModal || this.mDropDownList.isInTouchMode()) {
                this.clearListSelection();
            }
            if (!this.mModal) {
                this.mHandler.post(this.mHideSelector);
            }
        }
    }

    private final void $$robo$$android_widget_ListPopupWindow$dismiss() {
        this.mPopup.dismiss();
        this.removePromptView();
        this.mPopup.setContentView(null);
        this.mDropDownList = null;
        this.mHandler.removeCallbacks(this.mResizePopupRunnable);
    }

    private final void $$robo$$android_widget_ListPopupWindow$setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mPopup.setOnDismissListener(listener);
    }

    private final void $$robo$$android_widget_ListPopupWindow$removePromptView() {
        ViewParent parent;
        if (this.mPromptView != null && (parent = this.mPromptView.getParent()) instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)parent;
            group.removeView(this.mPromptView);
        }
    }

    private final void $$robo$$android_widget_ListPopupWindow$setInputMethodMode(int mode) {
        this.mPopup.setInputMethodMode(mode);
    }

    private final int $$robo$$android_widget_ListPopupWindow$getInputMethodMode() {
        return this.mPopup.getInputMethodMode();
    }

    private final void $$robo$$android_widget_ListPopupWindow$setSelection(int position) {
        DropDownListView list = this.mDropDownList;
        if (this.isShowing() && list != null) {
            list.setListSelectionHidden(false);
            list.setSelection(position);
            if (list.getChoiceMode() != 0) {
                list.setItemChecked(position, true);
            }
        }
    }

    private final void $$robo$$android_widget_ListPopupWindow$clearListSelection() {
        DropDownListView list = this.mDropDownList;
        if (list != null) {
            list.setListSelectionHidden(true);
            list.hideSelector();
            list.requestLayout();
        }
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$isShowing() {
        return this.mPopup.isShowing();
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$isInputMethodNotNeeded() {
        return this.mPopup.getInputMethodMode() == 2;
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$performItemClick(int position) {
        if (this.isShowing()) {
            if (this.mItemClickListener != null) {
                DropDownListView list = this.mDropDownList;
                View child = list.getChildAt(position - list.getFirstVisiblePosition());
                Adapter adapter = list.getAdapter();
                this.mItemClickListener.onItemClick(list, child, position, adapter.getItemId(position));
            }
            return true;
        }
        return false;
    }

    private final Object $$robo$$android_widget_ListPopupWindow$getSelectedItem() {
        if (!this.isShowing()) {
            return null;
        }
        return this.mDropDownList.getSelectedItem();
    }

    private final int $$robo$$android_widget_ListPopupWindow$getSelectedItemPosition() {
        if (!this.isShowing()) {
            return -1;
        }
        return this.mDropDownList.getSelectedItemPosition();
    }

    private final long $$robo$$android_widget_ListPopupWindow$getSelectedItemId() {
        if (!this.isShowing()) {
            return Long.MIN_VALUE;
        }
        return this.mDropDownList.getSelectedItemId();
    }

    private final View $$robo$$android_widget_ListPopupWindow$getSelectedView() {
        if (!this.isShowing()) {
            return null;
        }
        return this.mDropDownList.getSelectedView();
    }

    private final ListView $$robo$$android_widget_ListPopupWindow$getListView() {
        return this.mDropDownList;
    }

    private final DropDownListView $$robo$$android_widget_ListPopupWindow$createDropDownListView(Context context, boolean hijackFocus) {
        return new DropDownListView(context, hijackFocus);
    }

    private final void $$robo$$android_widget_ListPopupWindow$setListItemExpandMax(int max) {
        this.mListItemExpandMaximum = max;
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$onKeyDown(int keyCode, KeyEvent event) {
        if (this.isShowing() && keyCode != 62 && (this.mDropDownList.getSelectedItemPosition() >= 0 || !KeyEvent.isConfirmKey(keyCode))) {
            int curIndex = this.mDropDownList.getSelectedItemPosition();
            boolean below = !this.mPopup.isAboveAnchor();
            ListAdapter adapter = this.mAdapter;
            int firstItem = Integer.MAX_VALUE;
            int lastItem = Integer.MIN_VALUE;
            if (adapter != null) {
                boolean allEnabled = adapter.areAllItemsEnabled();
                firstItem = allEnabled ? 0 : this.mDropDownList.lookForSelectablePosition(0, true);
                int n = lastItem = allEnabled ? adapter.getCount() - 1 : this.mDropDownList.lookForSelectablePosition(adapter.getCount() - 1, false);
            }
            if (below && keyCode == 19 && curIndex <= firstItem || !below && keyCode == 20 && curIndex >= lastItem) {
                this.clearListSelection();
                this.mPopup.setInputMethodMode(1);
                this.show();
                return true;
            }
            this.mDropDownList.setListSelectionHidden(false);
            boolean consumed = this.mDropDownList.onKeyDown(keyCode, event);
            if (consumed) {
                this.mPopup.setInputMethodMode(2);
                this.mDropDownList.requestFocusFromTouch();
                this.show();
                switch (keyCode) {
                    case 19: 
                    case 20: 
                    case 23: 
                    case 66: {
                        return true;
                    }
                }
            } else if (below && keyCode == 20 ? curIndex == lastItem : !below && keyCode == 19 && curIndex == firstItem) {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$onKeyUp(int keyCode, KeyEvent event) {
        if (this.isShowing() && this.mDropDownList.getSelectedItemPosition() >= 0) {
            boolean consumed = this.mDropDownList.onKeyUp(keyCode, event);
            if (consumed && KeyEvent.isConfirmKey(keyCode)) {
                this.dismiss();
            }
            return consumed;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$onKeyPreIme(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.isShowing()) {
            View anchorView = this.mDropDownAnchorView;
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state = anchorView.getKeyDispatcherState();
                if (state != null) {
                    state.startTracking(event, this);
                }
                return true;
            }
            if (event.getAction() == 1) {
                KeyEvent.DispatcherState state = anchorView.getKeyDispatcherState();
                if (state != null) {
                    state.handleUpEvent(event);
                }
                if (event.isTracking() && !event.isCanceled()) {
                    this.dismiss();
                    return true;
                }
            }
        }
        return false;
    }

    private final View.OnTouchListener $$robo$$android_widget_ListPopupWindow$createDragToOpenListener(View src) {
        return new ShadowedObject(this, src){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ListPopupWindow this$0;

            private void $$robo$$android_widget_ListPopupWindow_1$__constructor__(ListPopupWindow this$0, View src) {
            }

            private final ShowableListMenu $$robo$$android_widget_ListPopupWindow_1$getPopup() {
                return this.this$0;
            }

            private void __constructor__(ListPopupWindow listPopupWindow, View view) {
                this.$$robo$$android_widget_ListPopupWindow_1$__constructor__(listPopupWindow, view);
            }
            {
                this.this$0 = listPopupWindow;
                super(view);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_1$__constructor__(android.widget.ListPopupWindow android.view.View ), this, listPopupWindow, view);
            }

            @Override
            public ShowableListMenu getPopup() {
                return InvokeDynamicSupport.bootstrap("getPopup", $$robo$$android_widget_ListPopupWindow_1$getPopup(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final int $$robo$$android_widget_ListPopupWindow$buildDropDown() {
        int childWidthSpec;
        int padding;
        int otherHeights = 0;
        if (this.mDropDownList == null) {
            Context context = this.mContext;
            this.mShowDropDownRunnable = new Runnable(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ ListPopupWindow this$0;

                private void $$robo$$android_widget_ListPopupWindow_2$__constructor__(ListPopupWindow this$0) {
                }

                private final void $$robo$$android_widget_ListPopupWindow_2$run() {
                    View view = this.this$0.getAnchorView();
                    if (view != null && view.getWindowToken() != null) {
                        this.this$0.show();
                    }
                }

                private void __constructor__(ListPopupWindow listPopupWindow) {
                    this.$$robo$$android_widget_ListPopupWindow_2$__constructor__(listPopupWindow);
                }
                {
                    this.this$0 = listPopupWindow;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_2$__constructor__(android.widget.ListPopupWindow ), this, listPopupWindow);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ListPopupWindow_2$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mDropDownList = this.createDropDownListView(context, !this.mModal);
            if (this.mDropDownListHighlight != null) {
                this.mDropDownList.setSelector(this.mDropDownListHighlight);
            }
            this.mDropDownList.setAdapter(this.mAdapter);
            this.mDropDownList.setOnItemClickListener(this.mItemClickListener);
            this.mDropDownList.setFocusable(true);
            this.mDropDownList.setFocusableInTouchMode(true);
            this.mDropDownList.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ ListPopupWindow this$0;

                private void $$robo$$android_widget_ListPopupWindow_3$__constructor__(ListPopupWindow this$0) {
                }

                private final void $$robo$$android_widget_ListPopupWindow_3$onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                    DropDownListView dropDownList;
                    if (position != -1 && (dropDownList = this.this$0.mDropDownList) != null) {
                        dropDownList.setListSelectionHidden(false);
                    }
                }

                private final void $$robo$$android_widget_ListPopupWindow_3$onNothingSelected(AdapterView<?> parent) {
                }

                private void __constructor__(ListPopupWindow listPopupWindow) {
                    this.$$robo$$android_widget_ListPopupWindow_3$__constructor__(listPopupWindow);
                }
                {
                    this.this$0 = listPopupWindow;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_3$__constructor__(android.widget.ListPopupWindow ), this, listPopupWindow);
                }

                @Override
                public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
                    InvokeDynamicSupport.bootstrap("onItemSelected", $$robo$$android_widget_ListPopupWindow_3$onItemSelected(android.widget.AdapterView<?> android.view.View int long ), this, adapterView, view, n, l);
                }

                @Override
                public void onNothingSelected(AdapterView<?> adapterView) {
                    InvokeDynamicSupport.bootstrap("onNothingSelected", $$robo$$android_widget_ListPopupWindow_3$onNothingSelected(android.widget.AdapterView<?> ), this, adapterView);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mDropDownList.setOnScrollListener(this.mScrollListener);
            if (this.mItemSelectedListener != null) {
                this.mDropDownList.setOnItemSelectedListener(this.mItemSelectedListener);
            }
            ViewGroup dropDownView = this.mDropDownList;
            View hintView = this.mPromptView;
            if (hintView != null) {
                int widthSize;
                int widthMode;
                LinearLayout hintContainer = new LinearLayout(context);
                hintContainer.setOrientation(1);
                LinearLayout.LayoutParams hintParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                switch (this.mPromptPosition) {
                    case 1: {
                        hintContainer.addView((View)dropDownView, hintParams);
                        hintContainer.addView(hintView);
                        break;
                    }
                    case 0: {
                        hintContainer.addView(hintView);
                        hintContainer.addView((View)dropDownView, hintParams);
                        break;
                    }
                    default: {
                        Log.e("ListPopupWindow", "Invalid hint position " + this.mPromptPosition);
                    }
                }
                if (this.mDropDownWidth >= 0) {
                    widthMode = Integer.MIN_VALUE;
                    widthSize = this.mDropDownWidth;
                } else {
                    widthMode = 0;
                    widthSize = 0;
                }
                int widthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, widthMode);
                boolean heightSpec = false;
                hintView.measure(widthSpec, 0);
                hintParams = (LinearLayout.LayoutParams)hintView.getLayoutParams();
                otherHeights = hintView.getMeasuredHeight() + hintParams.topMargin + hintParams.bottomMargin;
                dropDownView = hintContainer;
            }
            this.mPopup.setContentView(dropDownView);
        } else {
            View view = this.mPromptView;
            if (view != null) {
                LinearLayout.LayoutParams hintParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                otherHeights = view.getMeasuredHeight() + hintParams.topMargin + hintParams.bottomMargin;
            }
        }
        Drawable background = this.mPopup.getBackground();
        if (background != null) {
            background.getPadding(this.mTempRect);
            padding = this.mTempRect.top + this.mTempRect.bottom;
            if (!this.mDropDownVerticalOffsetSet) {
                this.mDropDownVerticalOffset = -this.mTempRect.top;
            }
        } else {
            this.mTempRect.setEmpty();
            padding = 0;
        }
        boolean ignoreBottomDecorations = this.mPopup.getInputMethodMode() == 2;
        int maxHeight = this.mPopup.getMaxAvailableHeight(this.getAnchorView(), this.mDropDownVerticalOffset, ignoreBottomDecorations);
        if (this.mDropDownAlwaysVisible || this.mDropDownHeight == -1) {
            return maxHeight + padding;
        }
        switch (this.mDropDownWidth) {
            case -2: {
                childWidthSpec = View.MeasureSpec.makeMeasureSpec(this.mContext.getResources().getDisplayMetrics().widthPixels - (this.mTempRect.left + this.mTempRect.right), Integer.MIN_VALUE);
                break;
            }
            case -1: {
                childWidthSpec = View.MeasureSpec.makeMeasureSpec(this.mContext.getResources().getDisplayMetrics().widthPixels - (this.mTempRect.left + this.mTempRect.right), 0x40000000);
                break;
            }
            default: {
                childWidthSpec = View.MeasureSpec.makeMeasureSpec(this.mDropDownWidth, 0x40000000);
            }
        }
        int listContent = this.mDropDownList.measureHeightOfChildren(childWidthSpec, 0, -1, maxHeight - otherHeights, -1);
        if (listContent > 0) {
            int listPadding = this.mDropDownList.getPaddingTop() + this.mDropDownList.getPaddingBottom();
            otherHeights += padding + listPadding;
        }
        return listContent + otherHeights;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setOverlapAnchor(boolean overlap) {
        this.mOverlapAnchorSet = true;
        this.mOverlapAnchor = overlap;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ListPopupWindow$__constructor__(context);
    }

    public ListPopupWindow(Context context) {
        this(context, null, 16843519, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_ListPopupWindow$__constructor__(context, attributeSet);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843519, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_ListPopupWindow$__constructor__(context, attributeSet, n);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_ListPopupWindow$__constructor__(context, attributeSet, n, n2);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    public void setAdapter(ListAdapter listAdapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_ListPopupWindow$setAdapter(android.widget.ListAdapter ), this, listAdapter);
    }

    public void setPromptPosition(int n) {
        InvokeDynamicSupport.bootstrap("setPromptPosition", $$robo$$android_widget_ListPopupWindow$setPromptPosition(int ), this, n);
    }

    public int getPromptPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getPromptPosition", $$robo$$android_widget_ListPopupWindow$getPromptPosition(), this);
    }

    public void setModal(boolean bl) {
        InvokeDynamicSupport.bootstrap("setModal", $$robo$$android_widget_ListPopupWindow$setModal(boolean ), this, bl);
    }

    public boolean isModal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isModal", $$robo$$android_widget_ListPopupWindow$isModal(), this);
    }

    public void setForceIgnoreOutsideTouch(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceIgnoreOutsideTouch", $$robo$$android_widget_ListPopupWindow$setForceIgnoreOutsideTouch(boolean ), this, bl);
    }

    public void setDropDownAlwaysVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDropDownAlwaysVisible", $$robo$$android_widget_ListPopupWindow$setDropDownAlwaysVisible(boolean ), this, bl);
    }

    public boolean isDropDownAlwaysVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDropDownAlwaysVisible", $$robo$$android_widget_ListPopupWindow$isDropDownAlwaysVisible(), this);
    }

    public void setSoftInputMode(int n) {
        InvokeDynamicSupport.bootstrap("setSoftInputMode", $$robo$$android_widget_ListPopupWindow$setSoftInputMode(int ), this, n);
    }

    public int getSoftInputMode() {
        return (int)InvokeDynamicSupport.bootstrap("getSoftInputMode", $$robo$$android_widget_ListPopupWindow$getSoftInputMode(), this);
    }

    public void setListSelector(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setListSelector", $$robo$$android_widget_ListPopupWindow$setListSelector(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public Drawable getBackground() {
        return InvokeDynamicSupport.bootstrap("getBackground", $$robo$$android_widget_ListPopupWindow$getBackground(), this);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setBackgroundDrawable", $$robo$$android_widget_ListPopupWindow$setBackgroundDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public void setAnimationStyle(int n) {
        InvokeDynamicSupport.bootstrap("setAnimationStyle", $$robo$$android_widget_ListPopupWindow$setAnimationStyle(int ), this, n);
    }

    public int getAnimationStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getAnimationStyle", $$robo$$android_widget_ListPopupWindow$getAnimationStyle(), this);
    }

    public View getAnchorView() {
        return InvokeDynamicSupport.bootstrap("getAnchorView", $$robo$$android_widget_ListPopupWindow$getAnchorView(), this);
    }

    public void setAnchorView(View view) {
        InvokeDynamicSupport.bootstrap("setAnchorView", $$robo$$android_widget_ListPopupWindow$setAnchorView(android.view.View ), this, view);
    }

    public int getHorizontalOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getHorizontalOffset", $$robo$$android_widget_ListPopupWindow$getHorizontalOffset(), this);
    }

    public void setHorizontalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setHorizontalOffset", $$robo$$android_widget_ListPopupWindow$setHorizontalOffset(int ), this, n);
    }

    public int getVerticalOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getVerticalOffset", $$robo$$android_widget_ListPopupWindow$getVerticalOffset(), this);
    }

    public void setVerticalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setVerticalOffset", $$robo$$android_widget_ListPopupWindow$setVerticalOffset(int ), this, n);
    }

    public void setEpicenterBounds(Rect rect) {
        InvokeDynamicSupport.bootstrap("setEpicenterBounds", $$robo$$android_widget_ListPopupWindow$setEpicenterBounds(android.graphics.Rect ), this, rect);
    }

    public void setDropDownGravity(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownGravity", $$robo$$android_widget_ListPopupWindow$setDropDownGravity(int ), this, n);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_widget_ListPopupWindow$getWidth(), this);
    }

    public void setWidth(int n) {
        InvokeDynamicSupport.bootstrap("setWidth", $$robo$$android_widget_ListPopupWindow$setWidth(int ), this, n);
    }

    public void setContentWidth(int n) {
        InvokeDynamicSupport.bootstrap("setContentWidth", $$robo$$android_widget_ListPopupWindow$setContentWidth(int ), this, n);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_widget_ListPopupWindow$getHeight(), this);
    }

    public void setHeight(int n) {
        InvokeDynamicSupport.bootstrap("setHeight", $$robo$$android_widget_ListPopupWindow$setHeight(int ), this, n);
    }

    public void setWindowLayoutType(int n) {
        InvokeDynamicSupport.bootstrap("setWindowLayoutType", $$robo$$android_widget_ListPopupWindow$setWindowLayoutType(int ), this, n);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        InvokeDynamicSupport.bootstrap("setOnItemClickListener", $$robo$$android_widget_ListPopupWindow$setOnItemClickListener(android.widget.AdapterView$OnItemClickListener ), this, onItemClickListener);
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        InvokeDynamicSupport.bootstrap("setOnItemSelectedListener", $$robo$$android_widget_ListPopupWindow$setOnItemSelectedListener(android.widget.AdapterView$OnItemSelectedListener ), this, onItemSelectedListener);
    }

    public void setPromptView(View view) {
        InvokeDynamicSupport.bootstrap("setPromptView", $$robo$$android_widget_ListPopupWindow$setPromptView(android.view.View ), this, view);
    }

    public void postShow() {
        InvokeDynamicSupport.bootstrap("postShow", $$robo$$android_widget_ListPopupWindow$postShow(), this);
    }

    @Override
    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_ListPopupWindow$show(), this);
    }

    @Override
    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$android_widget_ListPopupWindow$dismiss(), this);
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissListener", $$robo$$android_widget_ListPopupWindow$setOnDismissListener(android.widget.PopupWindow$OnDismissListener ), this, onDismissListener);
    }

    private void removePromptView() {
        InvokeDynamicSupport.bootstrap("removePromptView", $$robo$$android_widget_ListPopupWindow$removePromptView(), this);
    }

    public void setInputMethodMode(int n) {
        InvokeDynamicSupport.bootstrap("setInputMethodMode", $$robo$$android_widget_ListPopupWindow$setInputMethodMode(int ), this, n);
    }

    public int getInputMethodMode() {
        return (int)InvokeDynamicSupport.bootstrap("getInputMethodMode", $$robo$$android_widget_ListPopupWindow$getInputMethodMode(), this);
    }

    public void setSelection(int n) {
        InvokeDynamicSupport.bootstrap("setSelection", $$robo$$android_widget_ListPopupWindow$setSelection(int ), this, n);
    }

    public void clearListSelection() {
        InvokeDynamicSupport.bootstrap("clearListSelection", $$robo$$android_widget_ListPopupWindow$clearListSelection(), this);
    }

    @Override
    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$android_widget_ListPopupWindow$isShowing(), this);
    }

    public boolean isInputMethodNotNeeded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInputMethodNotNeeded", $$robo$$android_widget_ListPopupWindow$isInputMethodNotNeeded(), this);
    }

    public boolean performItemClick(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performItemClick", $$robo$$android_widget_ListPopupWindow$performItemClick(int ), this, n);
    }

    public Object getSelectedItem() {
        return InvokeDynamicSupport.bootstrap("getSelectedItem", $$robo$$android_widget_ListPopupWindow$getSelectedItem(), this);
    }

    public int getSelectedItemPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectedItemPosition", $$robo$$android_widget_ListPopupWindow$getSelectedItemPosition(), this);
    }

    public long getSelectedItemId() {
        return (long)InvokeDynamicSupport.bootstrap("getSelectedItemId", $$robo$$android_widget_ListPopupWindow$getSelectedItemId(), this);
    }

    public View getSelectedView() {
        return InvokeDynamicSupport.bootstrap("getSelectedView", $$robo$$android_widget_ListPopupWindow$getSelectedView(), this);
    }

    @Override
    public ListView getListView() {
        return InvokeDynamicSupport.bootstrap("getListView", $$robo$$android_widget_ListPopupWindow$getListView(), this);
    }

    DropDownListView createDropDownListView(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrap("createDropDownListView", $$robo$$android_widget_ListPopupWindow$createDropDownListView(android.content.Context boolean ), this, context, bl);
    }

    void setListItemExpandMax(int n) {
        InvokeDynamicSupport.bootstrap("setListItemExpandMax", $$robo$$android_widget_ListPopupWindow$setListItemExpandMax(int ), this, n);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_widget_ListPopupWindow$onKeyDown(int android.view.KeyEvent ), this, n, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_widget_ListPopupWindow$onKeyUp(int android.view.KeyEvent ), this, n, keyEvent);
    }

    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyPreIme", $$robo$$android_widget_ListPopupWindow$onKeyPreIme(int android.view.KeyEvent ), this, n, keyEvent);
    }

    public View.OnTouchListener createDragToOpenListener(View view) {
        return InvokeDynamicSupport.bootstrap("createDragToOpenListener", $$robo$$android_widget_ListPopupWindow$createDragToOpenListener(android.view.View ), this, view);
    }

    private int buildDropDown() {
        return (int)InvokeDynamicSupport.bootstrap("buildDropDown", $$robo$$android_widget_ListPopupWindow$buildDropDown(), this);
    }

    public void setOverlapAnchor(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOverlapAnchor", $$robo$$android_widget_ListPopupWindow$setOverlapAnchor(boolean ), this, bl);
    }

    public /* synthetic */ ListPopupWindow() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListPopupWindow)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class PopupScrollListener
    implements AbsListView.OnScrollListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ListPopupWindow this$0;

        private void $$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(ListPopupWindow listPopupWindow) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_PopupScrollListener$onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_PopupScrollListener$onScrollStateChanged(AbsListView view, int scrollState) {
            if (scrollState == 1 && !this.this$0.isInputMethodNotNeeded() && this.this$0.mPopup.getContentView() != null) {
                this.this$0.mHandler.removeCallbacks(this.this$0.mResizePopupRunnable);
                this.this$0.mResizePopupRunnable.run();
            }
        }

        private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(ListPopupWindow x0, 1 x1) {
        }

        private void __constructor__(ListPopupWindow listPopupWindow) {
            this.$$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(listPopupWindow);
        }

        public PopupScrollListener(ListPopupWindow listPopupWindow) {
            this.this$0 = listPopupWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(android.widget.ListPopupWindow ), this, listPopupWindow);
        }

        @Override
        public void onScroll(AbsListView absListView, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onScroll", $$robo$$android_widget_ListPopupWindow_PopupScrollListener$onScroll(android.widget.AbsListView int int int ), this, absListView, n, n2, n3);
        }

        @Override
        public void onScrollStateChanged(AbsListView absListView, int n) {
            InvokeDynamicSupport.bootstrap("onScrollStateChanged", $$robo$$android_widget_ListPopupWindow_PopupScrollListener$onScrollStateChanged(android.widget.AbsListView int ), this, absListView, n);
        }

        private /* synthetic */ void __constructor__(ListPopupWindow listPopupWindow, 1 var2_2) {
            this.$$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(listPopupWindow, var2_2);
        }

        public /* synthetic */ PopupScrollListener(ListPopupWindow listPopupWindow, 1 var2_2) {
            this(listPopupWindow);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(android.widget.ListPopupWindow android.widget.ListPopupWindow$1 ), this, listPopupWindow, var2_2);
        }

        public /* synthetic */ PopupScrollListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupScrollListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PopupTouchInterceptor
    implements View.OnTouchListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ListPopupWindow this$0;

        private void $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(ListPopupWindow listPopupWindow) {
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$onTouch(View v, MotionEvent event) {
            int action = event.getAction();
            int x = (int)event.getX();
            int y = (int)event.getY();
            if (action == 0 && this.this$0.mPopup != null && this.this$0.mPopup.isShowing() && x >= 0 && x < this.this$0.mPopup.getWidth() && y >= 0 && y < this.this$0.mPopup.getHeight()) {
                this.this$0.mHandler.postDelayed(this.this$0.mResizePopupRunnable, 250L);
            } else if (action == 1) {
                this.this$0.mHandler.removeCallbacks(this.this$0.mResizePopupRunnable);
            }
            return false;
        }

        private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(ListPopupWindow x0, 1 x1) {
        }

        private void __constructor__(ListPopupWindow listPopupWindow) {
            this.$$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(listPopupWindow);
        }

        public PopupTouchInterceptor(ListPopupWindow listPopupWindow) {
            this.this$0 = listPopupWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(android.widget.ListPopupWindow ), this, listPopupWindow);
        }

        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$onTouch(android.view.View android.view.MotionEvent ), this, view, motionEvent);
        }

        private /* synthetic */ void __constructor__(ListPopupWindow listPopupWindow, 1 var2_2) {
            this.$$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(listPopupWindow, var2_2);
        }

        public /* synthetic */ PopupTouchInterceptor(ListPopupWindow listPopupWindow, 1 var2_2) {
            this(listPopupWindow);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(android.widget.ListPopupWindow android.widget.ListPopupWindow$1 ), this, listPopupWindow, var2_2);
        }

        public /* synthetic */ PopupTouchInterceptor() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupTouchInterceptor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ResizePopupRunnable
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ListPopupWindow this$0;

        private void $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(ListPopupWindow listPopupWindow) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$run() {
            if (this.this$0.mDropDownList != null && this.this$0.mDropDownList.isAttachedToWindow() && this.this$0.mDropDownList.getCount() > this.this$0.mDropDownList.getChildCount() && this.this$0.mDropDownList.getChildCount() <= this.this$0.mListItemExpandMaximum) {
                this.this$0.mPopup.setInputMethodMode(2);
                this.this$0.show();
            }
        }

        private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(ListPopupWindow x0, 1 x1) {
        }

        private void __constructor__(ListPopupWindow listPopupWindow) {
            this.$$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(listPopupWindow);
        }

        public ResizePopupRunnable(ListPopupWindow listPopupWindow) {
            this.this$0 = listPopupWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(android.widget.ListPopupWindow ), this, listPopupWindow);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$run(), this);
        }

        private /* synthetic */ void __constructor__(ListPopupWindow listPopupWindow, 1 var2_2) {
            this.$$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(listPopupWindow, var2_2);
        }

        public /* synthetic */ ResizePopupRunnable(ListPopupWindow listPopupWindow, 1 var2_2) {
            this(listPopupWindow);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(android.widget.ListPopupWindow android.widget.ListPopupWindow$1 ), this, listPopupWindow, var2_2);
        }

        public /* synthetic */ ResizePopupRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResizePopupRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ListSelectorHider
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ListPopupWindow this$0;

        private void $$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(ListPopupWindow listPopupWindow) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_ListSelectorHider$run() {
            this.this$0.clearListSelection();
        }

        private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(ListPopupWindow x0, 1 x1) {
        }

        private void __constructor__(ListPopupWindow listPopupWindow) {
            this.$$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(listPopupWindow);
        }

        public ListSelectorHider(ListPopupWindow listPopupWindow) {
            this.this$0 = listPopupWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(android.widget.ListPopupWindow ), this, listPopupWindow);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ListPopupWindow_ListSelectorHider$run(), this);
        }

        private /* synthetic */ void __constructor__(ListPopupWindow listPopupWindow, 1 var2_2) {
            this.$$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(listPopupWindow, var2_2);
        }

        public /* synthetic */ ListSelectorHider(ListPopupWindow listPopupWindow, 1 var2_2) {
            this(listPopupWindow);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(android.widget.ListPopupWindow android.widget.ListPopupWindow$1 ), this, listPopupWindow, var2_2);
        }

        public /* synthetic */ ListSelectorHider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListSelectorHider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PopupDataSetObserver
    extends DataSetObserver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ListPopupWindow this$0;

        private void $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(ListPopupWindow listPopupWindow) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$onChanged() {
            if (this.this$0.isShowing()) {
                this.this$0.show();
            }
        }

        private final void $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$onInvalidated() {
            this.this$0.dismiss();
        }

        private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(ListPopupWindow x0, 1 x1) {
        }

        private void __constructor__(ListPopupWindow listPopupWindow) {
            this.$$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(listPopupWindow);
        }

        public PopupDataSetObserver(ListPopupWindow listPopupWindow) {
            this.this$0 = listPopupWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(android.widget.ListPopupWindow ), this, listPopupWindow);
        }

        @Override
        public void onChanged() {
            InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$onChanged(), this);
        }

        @Override
        public void onInvalidated() {
            InvokeDynamicSupport.bootstrap("onInvalidated", $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$onInvalidated(), this);
        }

        private /* synthetic */ void __constructor__(ListPopupWindow listPopupWindow, 1 var2_2) {
            this.$$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(listPopupWindow, var2_2);
        }

        public /* synthetic */ PopupDataSetObserver(ListPopupWindow listPopupWindow, 1 var2_2) {
            this(listPopupWindow);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(android.widget.ListPopupWindow android.widget.ListPopupWindow$1 ), this, listPopupWindow, var2_2);
        }

        public /* synthetic */ PopupDataSetObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupDataSetObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

