/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.IntDef;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class LinearLayout
extends ViewGroup
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int HORIZONTAL = 0;
    public static int VERTICAL = 1;
    public static int SHOW_DIVIDER_NONE = 0;
    public static int SHOW_DIVIDER_BEGINNING = 1;
    public static int SHOW_DIVIDER_MIDDLE = 2;
    public static int SHOW_DIVIDER_END = 4;
    private boolean mAllowInconsistentMeasurement;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mBaselineAligned;
    @ViewDebug.ExportedProperty(category="layout")
    private int mBaselineAlignedChildIndex;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mBaselineChildTop;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mOrientation;
    @ViewDebug.ExportedProperty(category="measurement", flagMapping={@ViewDebug.FlagToString(mask=-1, equals=-1, name="NONE"), @ViewDebug.FlagToString(mask=0, equals=0, name="NONE"), @ViewDebug.FlagToString(mask=48, equals=48, name="TOP"), @ViewDebug.FlagToString(mask=80, equals=80, name="BOTTOM"), @ViewDebug.FlagToString(mask=3, equals=3, name="LEFT"), @ViewDebug.FlagToString(mask=5, equals=5, name="RIGHT"), @ViewDebug.FlagToString(mask=0x800003, equals=0x800003, name="START"), @ViewDebug.FlagToString(mask=0x800005, equals=0x800005, name="END"), @ViewDebug.FlagToString(mask=16, equals=16, name="CENTER_VERTICAL"), @ViewDebug.FlagToString(mask=112, equals=112, name="FILL_VERTICAL"), @ViewDebug.FlagToString(mask=1, equals=1, name="CENTER_HORIZONTAL"), @ViewDebug.FlagToString(mask=7, equals=7, name="FILL_HORIZONTAL"), @ViewDebug.FlagToString(mask=17, equals=17, name="CENTER"), @ViewDebug.FlagToString(mask=119, equals=119, name="FILL"), @ViewDebug.FlagToString(mask=0x800000, equals=0x800000, name="RELATIVE")}, formatToHexString=true)
    private int mGravity;
    @ViewDebug.ExportedProperty(category="measurement")
    private int mTotalLength;
    @ViewDebug.ExportedProperty(category="layout")
    private float mWeightSum;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mUseLargestChild;
    private int[] mMaxAscent;
    private int[] mMaxDescent;
    private static int VERTICAL_GRAVITY_COUNT = 4;
    private static int INDEX_CENTER_VERTICAL = 0;
    private static int INDEX_TOP = 1;
    private static int INDEX_BOTTOM = 2;
    private static int INDEX_FILL = 3;
    private Drawable mDivider;
    private int mDividerWidth;
    private int mDividerHeight;
    private int mShowDividers;
    private int mDividerPadding;
    private int mLayoutDirection;

    private void $$robo$$android_widget_LinearLayout$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_LinearLayout$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_LinearLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_LinearLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        boolean baselineAligned;
        this.mBaselineAligned = true;
        this.mBaselineAlignedChildIndex = -1;
        this.mBaselineChildTop = 0;
        this.mGravity = 0x800033;
        this.mLayoutDirection = -1;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LinearLayout, defStyleAttr, defStyleRes);
        int index = a.getInt(1, -1);
        if (index >= 0) {
            this.setOrientation(index);
        }
        if ((index = a.getInt(0, -1)) >= 0) {
            this.setGravity(index);
        }
        if (!(baselineAligned = a.getBoolean(2, true))) {
            this.setBaselineAligned(baselineAligned);
        }
        this.mWeightSum = a.getFloat(4, -1.0f);
        this.mBaselineAlignedChildIndex = a.getInt(3, -1);
        this.mUseLargestChild = a.getBoolean(6, false);
        this.mShowDividers = a.getInt(7, 0);
        this.mDividerPadding = a.getDimensionPixelSize(8, 0);
        this.setDividerDrawable(a.getDrawable(5));
        int version = context.getApplicationInfo().targetSdkVersion;
        this.mAllowInconsistentMeasurement = version <= 23;
        a.recycle();
    }

    private final boolean $$robo$$android_widget_LinearLayout$isShowingDividers() {
        return this.mShowDividers != 0 && this.mDivider != null;
    }

    private final void $$robo$$android_widget_LinearLayout$setShowDividers(int showDividers) {
        if (showDividers == this.mShowDividers) {
            return;
        }
        this.mShowDividers = showDividers;
        this.setWillNotDraw(!this.isShowingDividers());
        this.requestLayout();
    }

    private final boolean $$robo$$android_widget_LinearLayout$shouldDelayChildPressedState() {
        return false;
    }

    private final int $$robo$$android_widget_LinearLayout$getShowDividers() {
        return this.mShowDividers;
    }

    private final Drawable $$robo$$android_widget_LinearLayout$getDividerDrawable() {
        return this.mDivider;
    }

    private final void $$robo$$android_widget_LinearLayout$setDividerDrawable(Drawable divider) {
        if (divider == this.mDivider) {
            return;
        }
        this.mDivider = divider;
        if (divider != null) {
            this.mDividerWidth = divider.getIntrinsicWidth();
            this.mDividerHeight = divider.getIntrinsicHeight();
        } else {
            this.mDividerWidth = 0;
            this.mDividerHeight = 0;
        }
        this.setWillNotDraw(!this.isShowingDividers());
        this.requestLayout();
    }

    private final void $$robo$$android_widget_LinearLayout$setDividerPadding(int padding) {
        if (padding == this.mDividerPadding) {
            return;
        }
        this.mDividerPadding = padding;
        if (this.isShowingDividers()) {
            this.requestLayout();
            this.invalidate();
        }
    }

    private final int $$robo$$android_widget_LinearLayout$getDividerPadding() {
        return this.mDividerPadding;
    }

    private final int $$robo$$android_widget_LinearLayout$getDividerWidth() {
        return this.mDividerWidth;
    }

    private final void $$robo$$android_widget_LinearLayout$onDraw(Canvas canvas) {
        if (this.mDivider == null) {
            return;
        }
        if (this.mOrientation == 1) {
            this.drawDividersVertical(canvas);
        } else {
            this.drawDividersHorizontal(canvas);
        }
    }

    private final void $$robo$$android_widget_LinearLayout$drawDividersVertical(Canvas canvas) {
        LayoutParams lp;
        int count = this.getVirtualChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LayoutParams)child.getLayoutParams();
            int top = child.getTop() - lp.topMargin - this.mDividerHeight;
            this.drawHorizontalDivider(canvas, top);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            View child = this.getLastNonGoneChild();
            int bottom = 0;
            if (child == null) {
                bottom = this.getHeight() - this.getPaddingBottom() - this.mDividerHeight;
            } else {
                lp = (LayoutParams)child.getLayoutParams();
                bottom = child.getBottom() + lp.bottomMargin;
            }
            this.drawHorizontalDivider(canvas, bottom);
        }
    }

    private final View $$robo$$android_widget_LinearLayout$getLastNonGoneChild() {
        for (int i = this.getVirtualChildCount() - 1; i >= 0; --i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            return child;
        }
        return null;
    }

    private final void $$robo$$android_widget_LinearLayout$drawDividersHorizontal(Canvas canvas) {
        LayoutParams lp;
        int count = this.getVirtualChildCount();
        boolean isLayoutRtl = this.isLayoutRtl();
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            lp = (LayoutParams)child.getLayoutParams();
            int position = isLayoutRtl ? child.getRight() + lp.rightMargin : child.getLeft() - lp.leftMargin - this.mDividerWidth;
            this.drawVerticalDivider(canvas, position);
        }
        if (this.hasDividerBeforeChildAt(count)) {
            int position;
            View child = this.getLastNonGoneChild();
            if (child == null) {
                position = isLayoutRtl ? this.getPaddingLeft() : this.getWidth() - this.getPaddingRight() - this.mDividerWidth;
            } else {
                lp = (LayoutParams)child.getLayoutParams();
                position = isLayoutRtl ? child.getLeft() - lp.leftMargin - this.mDividerWidth : child.getRight() + lp.rightMargin;
            }
            this.drawVerticalDivider(canvas, position);
        }
    }

    private final void $$robo$$android_widget_LinearLayout$drawHorizontalDivider(Canvas canvas, int top) {
        this.mDivider.setBounds(this.getPaddingLeft() + this.mDividerPadding, top, this.getWidth() - this.getPaddingRight() - this.mDividerPadding, top + this.mDividerHeight);
        this.mDivider.draw(canvas);
    }

    private final void $$robo$$android_widget_LinearLayout$drawVerticalDivider(Canvas canvas, int left) {
        this.mDivider.setBounds(left, this.getPaddingTop() + this.mDividerPadding, left + this.mDividerWidth, this.getHeight() - this.getPaddingBottom() - this.mDividerPadding);
        this.mDivider.draw(canvas);
    }

    private final boolean $$robo$$android_widget_LinearLayout$isBaselineAligned() {
        return this.mBaselineAligned;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_LinearLayout$setBaselineAligned(boolean baselineAligned) {
        this.mBaselineAligned = baselineAligned;
    }

    private final boolean $$robo$$android_widget_LinearLayout$isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_LinearLayout$setMeasureWithLargestChildEnabled(boolean enabled) {
        this.mUseLargestChild = enabled;
    }

    private final int $$robo$$android_widget_LinearLayout$getBaseline() {
        int majorGravity;
        if (this.mBaselineAlignedChildIndex < 0) {
            return super.getBaseline();
        }
        if (this.getChildCount() <= this.mBaselineAlignedChildIndex) {
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout set to an index that is out of bounds.");
        }
        View child = this.getChildAt(this.mBaselineAlignedChildIndex);
        int childBaseline = child.getBaseline();
        if (childBaseline == -1) {
            if (this.mBaselineAlignedChildIndex == 0) {
                return -1;
            }
            throw new RuntimeException("mBaselineAlignedChildIndex of LinearLayout points to a View that doesn't know how to get its baseline.");
        }
        int childTop = this.mBaselineChildTop;
        if (this.mOrientation == 1 && (majorGravity = this.mGravity & 0x70) != 48) {
            switch (majorGravity) {
                case 80: {
                    childTop = this.mBottom - this.mTop - this.mPaddingBottom - this.mTotalLength;
                    break;
                }
                case 16: {
                    childTop += (this.mBottom - this.mTop - this.mPaddingTop - this.mPaddingBottom - this.mTotalLength) / 2;
                }
            }
        }
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        return childTop + lp.topMargin + childBaseline;
    }

    private final int $$robo$$android_widget_LinearLayout$getBaselineAlignedChildIndex() {
        return this.mBaselineAlignedChildIndex;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_LinearLayout$setBaselineAlignedChildIndex(int i) {
        if (i < 0 || i >= this.getChildCount()) {
            throw new IllegalArgumentException("base aligned child index out of range (0, " + this.getChildCount() + ")");
        }
        this.mBaselineAlignedChildIndex = i;
    }

    private final View $$robo$$android_widget_LinearLayout$getVirtualChildAt(int index) {
        return this.getChildAt(index);
    }

    private final int $$robo$$android_widget_LinearLayout$getVirtualChildCount() {
        return this.getChildCount();
    }

    private final float $$robo$$android_widget_LinearLayout$getWeightSum() {
        return this.mWeightSum;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_LinearLayout$setWeightSum(float weightSum) {
        this.mWeightSum = Math.max(0.0f, weightSum);
    }

    private final void $$robo$$android_widget_LinearLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mOrientation == 1) {
            this.measureVertical(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private final boolean $$robo$$android_widget_LinearLayout$hasDividerBeforeChildAt(int childIndex) {
        if (childIndex == this.getVirtualChildCount()) {
            return (this.mShowDividers & 4) != 0;
        }
        boolean allViewsAreGoneBefore = this.allViewsAreGoneBefore(childIndex);
        if (allViewsAreGoneBefore) {
            return (this.mShowDividers & 1) != 0;
        }
        return (this.mShowDividers & 2) != 0;
    }

    private final boolean $$robo$$android_widget_LinearLayout$allViewsAreGoneBefore(int childIndex) {
        for (int i = childIndex - 1; i >= 0; --i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$android_widget_LinearLayout$measureVertical(int widthMeasureSpec, int heightMeasureSpec) {
        LayoutParams lp;
        View child;
        int i;
        this.mTotalLength = 0;
        int maxWidth = 0;
        int childState = 0;
        int alternativeMaxWidth = 0;
        int weightedMaxWidth = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getVirtualChildCount();
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean matchWidth = false;
        boolean skippedMeasure = false;
        int baselineChildIndex = this.mBaselineAlignedChildIndex;
        boolean useLargestChild = this.mUseLargestChild;
        int largestChildHeight = Integer.MIN_VALUE;
        int consumedExcessSpace = 0;
        int nonSkippedChildCount = 0;
        for (i = 0; i < count; ++i) {
            boolean useExcessSpace;
            child = this.getVirtualChildAt(i);
            if (child == null) {
                this.mTotalLength += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) {
                i += this.getChildrenSkipCount(child, i);
                continue;
            }
            ++nonSkippedChildCount;
            if (this.hasDividerBeforeChildAt(i)) {
                this.mTotalLength += this.mDividerHeight;
            }
            lp = (LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            boolean bl = useExcessSpace = lp.height == 0 && lp.weight > 0.0f;
            if (heightMode == 0x40000000 && useExcessSpace) {
                int totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + lp.topMargin + lp.bottomMargin);
                skippedMeasure = true;
            } else {
                if (useExcessSpace) {
                    lp.height = -2;
                }
                int usedHeight = totalWeight == 0.0f ? this.mTotalLength : 0;
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, 0, heightMeasureSpec, usedHeight);
                int childHeight = child.getMeasuredHeight();
                if (useExcessSpace) {
                    lp.height = 0;
                    consumedExcessSpace += childHeight;
                }
                int totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + childHeight + lp.topMargin + lp.bottomMargin + this.getNextLocationOffset(child));
                if (useLargestChild) {
                    largestChildHeight = Math.max(childHeight, largestChildHeight);
                }
            }
            if (baselineChildIndex >= 0 && baselineChildIndex == i + 1) {
                this.mBaselineChildTop = this.mTotalLength;
            }
            if (i < baselineChildIndex && lp.weight > 0.0f) {
                throw new RuntimeException("A child of LinearLayout with index less than mBaselineAlignedChildIndex has weight > 0, which won't work.  Either remove the weight, or don't set mBaselineAlignedChildIndex.");
            }
            boolean matchWidthLocally = false;
            if (widthMode != 0x40000000 && lp.width == -1) {
                matchWidth = true;
                matchWidthLocally = true;
            }
            int margin = lp.leftMargin + lp.rightMargin;
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
            childState = LinearLayout.combineMeasuredStates(childState, child.getMeasuredState());
            boolean bl2 = allFillParent = allFillParent && lp.width == -1;
            if (lp.weight > 0.0f) {
                weightedMaxWidth = Math.max(weightedMaxWidth, matchWidthLocally ? margin : measuredWidth);
            } else {
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
            }
            i += this.getChildrenSkipCount(child, i);
        }
        if (nonSkippedChildCount > 0 && this.hasDividerBeforeChildAt(count)) {
            this.mTotalLength += this.mDividerHeight;
        }
        if (useLargestChild && (heightMode == Integer.MIN_VALUE || heightMode == 0)) {
            this.mTotalLength = 0;
            for (i = 0; i < count; ++i) {
                child = this.getVirtualChildAt(i);
                if (child == null) {
                    this.mTotalLength += this.measureNullChild(i);
                    continue;
                }
                if (child.getVisibility() == 8) {
                    i += this.getChildrenSkipCount(child, i);
                    continue;
                }
                lp = (LayoutParams)child.getLayoutParams();
                int totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + largestChildHeight + lp.topMargin + lp.bottomMargin + this.getNextLocationOffset(child));
            }
        }
        this.mTotalLength += this.mPaddingTop + this.mPaddingBottom;
        int heightSize = this.mTotalLength;
        heightSize = Math.max(heightSize, this.getSuggestedMinimumHeight());
        int heightSizeAndState = LinearLayout.resolveSizeAndState(heightSize, heightMeasureSpec, 0);
        heightSize = heightSizeAndState & 0xFFFFFF;
        int remainingExcess = heightSize - this.mTotalLength + (this.mAllowInconsistentMeasurement ? 0 : consumedExcessSpace);
        if (skippedMeasure || remainingExcess != 0 && totalWeight > 0.0f) {
            float remainingWeightSum = this.mWeightSum > 0.0f ? this.mWeightSum : totalWeight;
            this.mTotalLength = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                View child2 = this.getVirtualChildAt(i2);
                if (child2 == null || child2.getVisibility() == 8) continue;
                LayoutParams lp2 = (LayoutParams)child2.getLayoutParams();
                float childWeight = lp2.weight;
                if (childWeight > 0.0f) {
                    int share = (int)(childWeight * (float)remainingExcess / remainingWeightSum);
                    remainingExcess -= share;
                    remainingWeightSum -= childWeight;
                    int childHeight = this.mUseLargestChild && heightMode != 0x40000000 ? largestChildHeight : (lp2.height == 0 && (!this.mAllowInconsistentMeasurement || heightMode == 0x40000000) ? share : child2.getMeasuredHeight() + share);
                    int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.max(0, childHeight), 0x40000000);
                    int childWidthMeasureSpec = LinearLayout.getChildMeasureSpec(widthMeasureSpec, this.mPaddingLeft + this.mPaddingRight + lp2.leftMargin + lp2.rightMargin, lp2.width);
                    child2.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    childState = LinearLayout.combineMeasuredStates(childState, child2.getMeasuredState() & 0xFFFFFF00);
                }
                int margin = lp2.leftMargin + lp2.rightMargin;
                int measuredWidth = child2.getMeasuredWidth() + margin;
                maxWidth = Math.max(maxWidth, measuredWidth);
                boolean matchWidthLocally = widthMode != 0x40000000 && lp2.width == -1;
                alternativeMaxWidth = Math.max(alternativeMaxWidth, matchWidthLocally ? margin : measuredWidth);
                allFillParent = allFillParent && lp2.width == -1;
                int totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + child2.getMeasuredHeight() + lp2.topMargin + lp2.bottomMargin + this.getNextLocationOffset(child2));
            }
            this.mTotalLength += this.mPaddingTop + this.mPaddingBottom;
        } else {
            alternativeMaxWidth = Math.max(alternativeMaxWidth, weightedMaxWidth);
            if (useLargestChild && heightMode != 0x40000000) {
                for (int i3 = 0; i3 < count; ++i3) {
                    View child3 = this.getVirtualChildAt(i3);
                    if (child3 == null || child3.getVisibility() == 8) continue;
                    LayoutParams lp3 = (LayoutParams)child3.getLayoutParams();
                    float childExtra = lp3.weight;
                    if (!(childExtra > 0.0f)) continue;
                    child3.measure(View.MeasureSpec.makeMeasureSpec(child3.getMeasuredWidth(), 0x40000000), View.MeasureSpec.makeMeasureSpec(largestChildHeight, 0x40000000));
                }
            }
        }
        if (!allFillParent && widthMode != 0x40000000) {
            maxWidth = alternativeMaxWidth;
        }
        maxWidth += this.mPaddingLeft + this.mPaddingRight;
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(LinearLayout.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), heightSizeAndState);
        if (matchWidth) {
            this.forceUniformWidth(count, heightMeasureSpec);
        }
    }

    private final void $$robo$$android_widget_LinearLayout$forceUniformWidth(int count, int heightMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.getMeasuredWidth(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.width != -1) continue;
            int oldHeight = lp.height;
            lp.height = child.getMeasuredHeight();
            this.measureChildWithMargins(child, uniformMeasureSpec, 0, heightMeasureSpec, 0);
            lp.height = oldHeight;
        }
    }

    private final void $$robo$$android_widget_LinearLayout$measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        LayoutParams lp;
        int i;
        this.mTotalLength = 0;
        int maxHeight = 0;
        int childState = 0;
        int alternativeMaxHeight = 0;
        int weightedMaxHeight = 0;
        boolean allFillParent = true;
        float totalWeight = 0.0f;
        int count = this.getVirtualChildCount();
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean matchHeight = false;
        boolean skippedMeasure = false;
        if (this.mMaxAscent == null || this.mMaxDescent == null) {
            this.mMaxAscent = new int[4];
            this.mMaxDescent = new int[4];
        }
        int[] maxAscent = this.mMaxAscent;
        int[] maxDescent = this.mMaxDescent;
        maxAscent[3] = -1;
        maxAscent[2] = -1;
        maxAscent[1] = -1;
        maxAscent[0] = -1;
        maxDescent[3] = -1;
        maxDescent[2] = -1;
        maxDescent[1] = -1;
        maxDescent[0] = -1;
        boolean baselineAligned = this.mBaselineAligned;
        boolean useLargestChild = this.mUseLargestChild;
        boolean isExactly = widthMode == 0x40000000;
        int largestChildWidth = Integer.MIN_VALUE;
        int usedExcessSpace = 0;
        int nonSkippedChildCount = 0;
        for (i = 0; i < count; ++i) {
            int childBaseline;
            boolean useExcessSpace;
            View child = this.getVirtualChildAt(i);
            if (child == null) {
                this.mTotalLength += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) {
                i += this.getChildrenSkipCount(child, i);
                continue;
            }
            ++nonSkippedChildCount;
            if (this.hasDividerBeforeChildAt(i)) {
                this.mTotalLength += this.mDividerWidth;
            }
            lp = (LayoutParams)child.getLayoutParams();
            totalWeight += lp.weight;
            boolean bl = useExcessSpace = lp.width == 0 && lp.weight > 0.0f;
            if (widthMode == 0x40000000 && useExcessSpace) {
                if (isExactly) {
                    this.mTotalLength += lp.leftMargin + lp.rightMargin;
                } else {
                    int totalLength = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength, totalLength + lp.leftMargin + lp.rightMargin);
                }
                if (baselineAligned) {
                    int freeWidthSpec = View.MeasureSpec.makeSafeMeasureSpec(View.MeasureSpec.getSize(widthMeasureSpec), 0);
                    int freeHeightSpec = View.MeasureSpec.makeSafeMeasureSpec(View.MeasureSpec.getSize(heightMeasureSpec), 0);
                    child.measure(freeWidthSpec, freeHeightSpec);
                } else {
                    skippedMeasure = true;
                }
            } else {
                if (useExcessSpace) {
                    lp.width = -2;
                }
                int usedWidth = totalWeight == 0.0f ? this.mTotalLength : 0;
                this.measureChildBeforeLayout(child, i, widthMeasureSpec, usedWidth, heightMeasureSpec, 0);
                int childWidth = child.getMeasuredWidth();
                if (useExcessSpace) {
                    lp.width = 0;
                    usedExcessSpace += childWidth;
                }
                if (isExactly) {
                    this.mTotalLength += childWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child);
                } else {
                    int totalLength = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength, totalLength + childWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child));
                }
                if (useLargestChild) {
                    largestChildWidth = Math.max(childWidth, largestChildWidth);
                }
            }
            boolean matchHeightLocally = false;
            if (heightMode != 0x40000000 && lp.height == -1) {
                matchHeight = true;
                matchHeightLocally = true;
            }
            int margin = lp.topMargin + lp.bottomMargin;
            int childHeight = child.getMeasuredHeight() + margin;
            childState = LinearLayout.combineMeasuredStates(childState, child.getMeasuredState());
            if (baselineAligned && (childBaseline = child.getBaseline()) != -1) {
                int gravity = (lp.gravity < 0 ? this.mGravity : lp.gravity) & 0x70;
                int index = (gravity >> 4 & 0xFFFFFFFE) >> 1;
                maxAscent[index] = Math.max(maxAscent[index], childBaseline);
                maxDescent[index] = Math.max(maxDescent[index], childHeight - childBaseline);
            }
            maxHeight = Math.max(maxHeight, childHeight);
            boolean bl2 = allFillParent = allFillParent && lp.height == -1;
            if (lp.weight > 0.0f) {
                weightedMaxHeight = Math.max(weightedMaxHeight, matchHeightLocally ? margin : childHeight);
            } else {
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
            }
            i += this.getChildrenSkipCount(child, i);
        }
        if (nonSkippedChildCount > 0 && this.hasDividerBeforeChildAt(count)) {
            this.mTotalLength += this.mDividerWidth;
        }
        if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
            int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
            int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
            maxHeight = Math.max(maxHeight, ascent + descent);
        }
        if (useLargestChild && (widthMode == Integer.MIN_VALUE || widthMode == 0)) {
            this.mTotalLength = 0;
            for (i = 0; i < count; ++i) {
                View child = this.getVirtualChildAt(i);
                if (child == null) {
                    this.mTotalLength += this.measureNullChild(i);
                    continue;
                }
                if (child.getVisibility() == 8) {
                    i += this.getChildrenSkipCount(child, i);
                    continue;
                }
                lp = (LayoutParams)child.getLayoutParams();
                if (isExactly) {
                    this.mTotalLength += largestChildWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child);
                    continue;
                }
                int totalLength = this.mTotalLength;
                this.mTotalLength = Math.max(totalLength, totalLength + largestChildWidth + lp.leftMargin + lp.rightMargin + this.getNextLocationOffset(child));
            }
        }
        this.mTotalLength += this.mPaddingLeft + this.mPaddingRight;
        int widthSize = this.mTotalLength;
        widthSize = Math.max(widthSize, this.getSuggestedMinimumWidth());
        int widthSizeAndState = LinearLayout.resolveSizeAndState(widthSize, widthMeasureSpec, 0);
        widthSize = widthSizeAndState & 0xFFFFFF;
        int remainingExcess = widthSize - this.mTotalLength + (this.mAllowInconsistentMeasurement ? 0 : usedExcessSpace);
        if (skippedMeasure || remainingExcess != 0 && totalWeight > 0.0f) {
            float remainingWeightSum = this.mWeightSum > 0.0f ? this.mWeightSum : totalWeight;
            maxAscent[3] = -1;
            maxAscent[2] = -1;
            maxAscent[1] = -1;
            maxAscent[0] = -1;
            maxDescent[3] = -1;
            maxDescent[2] = -1;
            maxDescent[1] = -1;
            maxDescent[0] = -1;
            maxHeight = -1;
            this.mTotalLength = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                int childBaseline;
                View child = this.getVirtualChildAt(i2);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp2 = (LayoutParams)child.getLayoutParams();
                float childWeight = lp2.weight;
                if (childWeight > 0.0f) {
                    int share = (int)(childWeight * (float)remainingExcess / remainingWeightSum);
                    remainingExcess -= share;
                    remainingWeightSum -= childWeight;
                    int childWidth = this.mUseLargestChild && widthMode != 0x40000000 ? largestChildWidth : (lp2.width == 0 && (!this.mAllowInconsistentMeasurement || widthMode == 0x40000000) ? share : child.getMeasuredWidth() + share);
                    int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.max(0, childWidth), 0x40000000);
                    int childHeightMeasureSpec = LinearLayout.getChildMeasureSpec(heightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp2.topMargin + lp2.bottomMargin, lp2.height);
                    child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                    childState = LinearLayout.combineMeasuredStates(childState, child.getMeasuredState() & 0xFF000000);
                }
                if (isExactly) {
                    this.mTotalLength += child.getMeasuredWidth() + lp2.leftMargin + lp2.rightMargin + this.getNextLocationOffset(child);
                } else {
                    int totalLength = this.mTotalLength;
                    this.mTotalLength = Math.max(totalLength, totalLength + child.getMeasuredWidth() + lp2.leftMargin + lp2.rightMargin + this.getNextLocationOffset(child));
                }
                boolean matchHeightLocally = heightMode != 0x40000000 && lp2.height == -1;
                int margin = lp2.topMargin + lp2.bottomMargin;
                int childHeight = child.getMeasuredHeight() + margin;
                maxHeight = Math.max(maxHeight, childHeight);
                alternativeMaxHeight = Math.max(alternativeMaxHeight, matchHeightLocally ? margin : childHeight);
                boolean bl = allFillParent = allFillParent && lp2.height == -1;
                if (!baselineAligned || (childBaseline = child.getBaseline()) == -1) continue;
                int gravity = (lp2.gravity < 0 ? this.mGravity : lp2.gravity) & 0x70;
                int index = (gravity >> 4 & 0xFFFFFFFE) >> 1;
                maxAscent[index] = Math.max(maxAscent[index], childBaseline);
                maxDescent[index] = Math.max(maxDescent[index], childHeight - childBaseline);
            }
            this.mTotalLength += this.mPaddingLeft + this.mPaddingRight;
            if (maxAscent[1] != -1 || maxAscent[0] != -1 || maxAscent[2] != -1 || maxAscent[3] != -1) {
                int ascent = Math.max(maxAscent[3], Math.max(maxAscent[0], Math.max(maxAscent[1], maxAscent[2])));
                int descent = Math.max(maxDescent[3], Math.max(maxDescent[0], Math.max(maxDescent[1], maxDescent[2])));
                maxHeight = Math.max(maxHeight, ascent + descent);
            }
        } else {
            alternativeMaxHeight = Math.max(alternativeMaxHeight, weightedMaxHeight);
            if (useLargestChild && widthMode != 0x40000000) {
                for (int i3 = 0; i3 < count; ++i3) {
                    View child = this.getVirtualChildAt(i3);
                    if (child == null || child.getVisibility() == 8) continue;
                    LayoutParams lp3 = (LayoutParams)child.getLayoutParams();
                    float childExtra = lp3.weight;
                    if (!(childExtra > 0.0f)) continue;
                    child.measure(View.MeasureSpec.makeMeasureSpec(largestChildWidth, 0x40000000), View.MeasureSpec.makeMeasureSpec(child.getMeasuredHeight(), 0x40000000));
                }
            }
        }
        if (!allFillParent && heightMode != 0x40000000) {
            maxHeight = alternativeMaxHeight;
        }
        maxHeight += this.mPaddingTop + this.mPaddingBottom;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(widthSizeAndState | childState & 0xFF000000, LinearLayout.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
        if (matchHeight) {
            this.forceUniformHeight(count, widthMeasureSpec);
        }
    }

    private final void $$robo$$android_widget_LinearLayout$forceUniformHeight(int count, int widthMeasureSpec) {
        int uniformMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), 0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.height != -1) continue;
            int oldWidth = lp.width;
            lp.width = child.getMeasuredWidth();
            this.measureChildWithMargins(child, widthMeasureSpec, 0, uniformMeasureSpec, 0);
            lp.width = oldWidth;
        }
    }

    private final int $$robo$$android_widget_LinearLayout$getChildrenSkipCount(View child, int index) {
        return 0;
    }

    private final int $$robo$$android_widget_LinearLayout$measureNullChild(int childIndex) {
        return 0;
    }

    private final void $$robo$$android_widget_LinearLayout$measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        this.measureChildWithMargins(child, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    private final int $$robo$$android_widget_LinearLayout$getLocationOffset(View child) {
        return 0;
    }

    private final int $$robo$$android_widget_LinearLayout$getNextLocationOffset(View child) {
        return 0;
    }

    private final void $$robo$$android_widget_LinearLayout$onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mOrientation == 1) {
            this.layoutVertical(l, t, r, b);
        } else {
            this.layoutHorizontal(l, t, r, b);
        }
    }

    private final void $$robo$$android_widget_LinearLayout$layoutVertical(int left, int top, int right, int bottom) {
        int paddingLeft = this.mPaddingLeft;
        int width = right - left;
        int childRight = width - this.mPaddingRight;
        int childSpace = width - paddingLeft - this.mPaddingRight;
        int count = this.getVirtualChildCount();
        int majorGravity = this.mGravity & 0x70;
        int minorGravity = this.mGravity & 0x800007;
        switch (majorGravity) {
            case 80: {
                int childTop = this.mPaddingTop + bottom - top - this.mTotalLength;
                break;
            }
            case 16: {
                int childTop = this.mPaddingTop + (bottom - top - this.mTotalLength) / 2;
                break;
            }
            default: {
                int childTop = this.mPaddingTop;
            }
        }
        for (int i = 0; i < count; ++i) {
            int childLeft;
            View child = this.getVirtualChildAt(i);
            if (child == null) {
                childTop += this.measureNullChild(i);
                continue;
            }
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int gravity = lp.gravity;
            if (gravity < 0) {
                gravity = minorGravity;
            }
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
            switch (absoluteGravity & 7) {
                case 1: {
                    childLeft = paddingLeft + (childSpace - childWidth) / 2 + lp.leftMargin - lp.rightMargin;
                    break;
                }
                case 5: {
                    childLeft = childRight - childWidth - lp.rightMargin;
                    break;
                }
                default: {
                    childLeft = paddingLeft + lp.leftMargin;
                }
            }
            if (this.hasDividerBeforeChildAt(i)) {
                childTop += this.mDividerHeight;
            }
            this.setChildFrame(child, childLeft, (childTop += lp.topMargin) + this.getLocationOffset(child), childWidth, childHeight);
            childTop += childHeight + lp.bottomMargin + this.getNextLocationOffset(child);
            i += this.getChildrenSkipCount(child, i);
        }
    }

    private final void $$robo$$android_widget_LinearLayout$onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (layoutDirection != this.mLayoutDirection) {
            this.mLayoutDirection = layoutDirection;
            if (this.mOrientation == 0) {
                this.requestLayout();
            }
        }
    }

    private final void $$robo$$android_widget_LinearLayout$layoutHorizontal(int left, int top, int right, int bottom) {
        boolean isLayoutRtl = this.isLayoutRtl();
        int paddingTop = this.mPaddingTop;
        int height = bottom - top;
        int childBottom = height - this.mPaddingBottom;
        int childSpace = height - paddingTop - this.mPaddingBottom;
        int count = this.getVirtualChildCount();
        int majorGravity = this.mGravity & 0x800007;
        int minorGravity = this.mGravity & 0x70;
        boolean baselineAligned = this.mBaselineAligned;
        int[] maxAscent = this.mMaxAscent;
        int[] maxDescent = this.mMaxDescent;
        int layoutDirection = this.getLayoutDirection();
        switch (Gravity.getAbsoluteGravity(majorGravity, layoutDirection)) {
            case 5: {
                int childLeft = this.mPaddingLeft + right - left - this.mTotalLength;
                break;
            }
            case 1: {
                int childLeft = this.mPaddingLeft + (right - left - this.mTotalLength) / 2;
                break;
            }
            default: {
                int childLeft = this.mPaddingLeft;
            }
        }
        int start = 0;
        int dir = 1;
        if (isLayoutRtl) {
            start = count - 1;
            dir = -1;
        }
        for (int i = 0; i < count; ++i) {
            int childTop;
            int gravity;
            int childIndex = start + dir * i;
            View child = this.getVirtualChildAt(childIndex);
            if (child == null) {
                childLeft += this.measureNullChild(childIndex);
                continue;
            }
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childBaseline = -1;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (baselineAligned && lp.height != -1) {
                childBaseline = child.getBaseline();
            }
            if ((gravity = lp.gravity) < 0) {
                gravity = minorGravity;
            }
            switch (gravity & 0x70) {
                case 48: {
                    childTop = paddingTop + lp.topMargin;
                    if (childBaseline == -1) break;
                    childTop += maxAscent[1] - childBaseline;
                    break;
                }
                case 16: {
                    childTop = paddingTop + (childSpace - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
                    break;
                }
                case 80: {
                    childTop = childBottom - childHeight - lp.bottomMargin;
                    if (childBaseline == -1) break;
                    int descent = child.getMeasuredHeight() - childBaseline;
                    childTop -= maxDescent[2] - descent;
                    break;
                }
                default: {
                    childTop = paddingTop;
                }
            }
            if (this.hasDividerBeforeChildAt(childIndex)) {
                childLeft += this.mDividerWidth;
            }
            this.setChildFrame(child, (childLeft += lp.leftMargin) + this.getLocationOffset(child), childTop, childWidth, childHeight);
            childLeft += childWidth + lp.rightMargin + this.getNextLocationOffset(child);
            i += this.getChildrenSkipCount(child, childIndex);
        }
    }

    private final void $$robo$$android_widget_LinearLayout$setChildFrame(View child, int left, int top, int width, int height) {
        child.layout(left, top, left + width, top + height);
    }

    private final void $$robo$$android_widget_LinearLayout$setOrientation(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.requestLayout();
        }
    }

    private final int $$robo$$android_widget_LinearLayout$getOrientation() {
        return this.mOrientation;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_LinearLayout$setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 0x800007) == 0) {
                gravity |= 0x800003;
            }
            if ((gravity & 0x70) == 0) {
                gravity |= 0x30;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    private final int $$robo$$android_widget_LinearLayout$getGravity() {
        return this.mGravity;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_LinearLayout$setHorizontalGravity(int horizontalGravity) {
        int gravity = horizontalGravity & 0x800007;
        if ((this.mGravity & 0x800007) != gravity) {
            this.mGravity = this.mGravity & 0xFF7FFFF8 | gravity;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_LinearLayout$setVerticalGravity(int verticalGravity) {
        int gravity = verticalGravity & 0x70;
        if ((this.mGravity & 0x70) != gravity) {
            this.mGravity = this.mGravity & 0xFFFFFF8F | gravity;
            this.requestLayout();
        }
    }

    private final LayoutParams $$robo$$android_widget_LinearLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final LayoutParams $$robo$$android_widget_LinearLayout$generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LayoutParams(-2, -2);
        }
        if (this.mOrientation == 1) {
            return new LayoutParams(-1, -2);
        }
        return null;
    }

    private final LayoutParams $$robo$$android_widget_LinearLayout$generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (sPreserveMarginParamsInLayoutParamConversion) {
            if (lp instanceof LayoutParams) {
                return new LayoutParams((LayoutParams)lp);
            }
            if (lp instanceof ViewGroup.MarginLayoutParams) {
                return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
            }
        }
        return new LayoutParams(lp);
    }

    private final boolean $$robo$$android_widget_LinearLayout$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private final CharSequence $$robo$$android_widget_LinearLayout$getAccessibilityClassName() {
        return LinearLayout.class.getName();
    }

    private final void $$robo$$android_widget_LinearLayout$encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("layout:baselineAligned", this.mBaselineAligned);
        encoder.addProperty("layout:baselineAlignedChildIndex", this.mBaselineAlignedChildIndex);
        encoder.addProperty("measurement:baselineChildTop", this.mBaselineChildTop);
        encoder.addProperty("measurement:orientation", this.mOrientation);
        encoder.addProperty("measurement:gravity", this.mGravity);
        encoder.addProperty("measurement:totalLength", this.mTotalLength);
        encoder.addProperty("layout:totalLength", this.mTotalLength);
        encoder.addProperty("layout:useLargestChild", this.mUseLargestChild);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_LinearLayout$__constructor__(context);
    }

    public LinearLayout(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_LinearLayout$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_LinearLayout$__constructor__(context, attributeSet);
    }

    public LinearLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_LinearLayout$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_LinearLayout$__constructor__(context, attributeSet, n);
    }

    public LinearLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_LinearLayout$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_LinearLayout$__constructor__(context, attributeSet, n, n2);
    }

    public LinearLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_LinearLayout$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private boolean isShowingDividers() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowingDividers", $$robo$$android_widget_LinearLayout$isShowingDividers(), this);
    }

    public void setShowDividers(int n) {
        InvokeDynamicSupport.bootstrap("setShowDividers", $$robo$$android_widget_LinearLayout$setShowDividers(int ), this, n);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$android_widget_LinearLayout$shouldDelayChildPressedState(), this);
    }

    public int getShowDividers() {
        return (int)InvokeDynamicSupport.bootstrap("getShowDividers", $$robo$$android_widget_LinearLayout$getShowDividers(), this);
    }

    public Drawable getDividerDrawable() {
        return InvokeDynamicSupport.bootstrap("getDividerDrawable", $$robo$$android_widget_LinearLayout$getDividerDrawable(), this);
    }

    public void setDividerDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setDividerDrawable", $$robo$$android_widget_LinearLayout$setDividerDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public void setDividerPadding(int n) {
        InvokeDynamicSupport.bootstrap("setDividerPadding", $$robo$$android_widget_LinearLayout$setDividerPadding(int ), this, n);
    }

    public int getDividerPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getDividerPadding", $$robo$$android_widget_LinearLayout$getDividerPadding(), this);
    }

    public int getDividerWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getDividerWidth", $$robo$$android_widget_LinearLayout$getDividerWidth(), this);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_LinearLayout$onDraw(android.graphics.Canvas ), this, canvas);
    }

    void drawDividersVertical(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawDividersVertical", $$robo$$android_widget_LinearLayout$drawDividersVertical(android.graphics.Canvas ), this, canvas);
    }

    private View getLastNonGoneChild() {
        return InvokeDynamicSupport.bootstrap("getLastNonGoneChild", $$robo$$android_widget_LinearLayout$getLastNonGoneChild(), this);
    }

    void drawDividersHorizontal(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawDividersHorizontal", $$robo$$android_widget_LinearLayout$drawDividersHorizontal(android.graphics.Canvas ), this, canvas);
    }

    void drawHorizontalDivider(Canvas canvas, int n) {
        InvokeDynamicSupport.bootstrap("drawHorizontalDivider", $$robo$$android_widget_LinearLayout$drawHorizontalDivider(android.graphics.Canvas int ), this, canvas, n);
    }

    void drawVerticalDivider(Canvas canvas, int n) {
        InvokeDynamicSupport.bootstrap("drawVerticalDivider", $$robo$$android_widget_LinearLayout$drawVerticalDivider(android.graphics.Canvas int ), this, canvas, n);
    }

    public boolean isBaselineAligned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBaselineAligned", $$robo$$android_widget_LinearLayout$isBaselineAligned(), this);
    }

    @RemotableViewMethod
    public void setBaselineAligned(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBaselineAligned", $$robo$$android_widget_LinearLayout$setBaselineAligned(boolean ), this, bl);
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMeasureWithLargestChildEnabled", $$robo$$android_widget_LinearLayout$isMeasureWithLargestChildEnabled(), this);
    }

    @RemotableViewMethod
    public void setMeasureWithLargestChildEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMeasureWithLargestChildEnabled", $$robo$$android_widget_LinearLayout$setMeasureWithLargestChildEnabled(boolean ), this, bl);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_LinearLayout$getBaseline(), this);
    }

    public int getBaselineAlignedChildIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getBaselineAlignedChildIndex", $$robo$$android_widget_LinearLayout$getBaselineAlignedChildIndex(), this);
    }

    @RemotableViewMethod
    public void setBaselineAlignedChildIndex(int n) {
        InvokeDynamicSupport.bootstrap("setBaselineAlignedChildIndex", $$robo$$android_widget_LinearLayout$setBaselineAlignedChildIndex(int ), this, n);
    }

    View getVirtualChildAt(int n) {
        return InvokeDynamicSupport.bootstrap("getVirtualChildAt", $$robo$$android_widget_LinearLayout$getVirtualChildAt(int ), this, n);
    }

    int getVirtualChildCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVirtualChildCount", $$robo$$android_widget_LinearLayout$getVirtualChildCount(), this);
    }

    public float getWeightSum() {
        return (float)InvokeDynamicSupport.bootstrap("getWeightSum", $$robo$$android_widget_LinearLayout$getWeightSum(), this);
    }

    @RemotableViewMethod
    public void setWeightSum(float f) {
        InvokeDynamicSupport.bootstrap("setWeightSum", $$robo$$android_widget_LinearLayout$setWeightSum(float ), this, f);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_LinearLayout$onMeasure(int int ), this, n, n2);
    }

    protected boolean hasDividerBeforeChildAt(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDividerBeforeChildAt", $$robo$$android_widget_LinearLayout$hasDividerBeforeChildAt(int ), this, n);
    }

    private boolean allViewsAreGoneBefore(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("allViewsAreGoneBefore", $$robo$$android_widget_LinearLayout$allViewsAreGoneBefore(int ), this, n);
    }

    void measureVertical(int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureVertical", $$robo$$android_widget_LinearLayout$measureVertical(int int ), this, n, n2);
    }

    private void forceUniformWidth(int n, int n2) {
        InvokeDynamicSupport.bootstrap("forceUniformWidth", $$robo$$android_widget_LinearLayout$forceUniformWidth(int int ), this, n, n2);
    }

    void measureHorizontal(int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureHorizontal", $$robo$$android_widget_LinearLayout$measureHorizontal(int int ), this, n, n2);
    }

    private void forceUniformHeight(int n, int n2) {
        InvokeDynamicSupport.bootstrap("forceUniformHeight", $$robo$$android_widget_LinearLayout$forceUniformHeight(int int ), this, n, n2);
    }

    int getChildrenSkipCount(View view, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getChildrenSkipCount", $$robo$$android_widget_LinearLayout$getChildrenSkipCount(android.view.View int ), this, view, n);
    }

    int measureNullChild(int n) {
        return (int)InvokeDynamicSupport.bootstrap("measureNullChild", $$robo$$android_widget_LinearLayout$measureNullChild(int ), this, n);
    }

    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("measureChildBeforeLayout", $$robo$$android_widget_LinearLayout$measureChildBeforeLayout(android.view.View int int int int int ), this, view, n, n2, n3, n4, n5);
    }

    int getLocationOffset(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getLocationOffset", $$robo$$android_widget_LinearLayout$getLocationOffset(android.view.View ), this, view);
    }

    int getNextLocationOffset(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getNextLocationOffset", $$robo$$android_widget_LinearLayout$getNextLocationOffset(android.view.View ), this, view);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_LinearLayout$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    void layoutVertical(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("layoutVertical", $$robo$$android_widget_LinearLayout$layoutVertical(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRtlPropertiesChanged", $$robo$$android_widget_LinearLayout$onRtlPropertiesChanged(int ), this, n);
    }

    void layoutHorizontal(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("layoutHorizontal", $$robo$$android_widget_LinearLayout$layoutHorizontal(int int int int ), this, n, n2, n3, n4);
    }

    private void setChildFrame(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setChildFrame", $$robo$$android_widget_LinearLayout$setChildFrame(android.view.View int int int int ), this, view, n, n2, n3, n4);
    }

    public void setOrientation(int n) {
        InvokeDynamicSupport.bootstrap("setOrientation", $$robo$$android_widget_LinearLayout$setOrientation(int ), this, n);
    }

    public int getOrientation() {
        return (int)InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_widget_LinearLayout$getOrientation(), this);
    }

    @RemotableViewMethod
    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_widget_LinearLayout$setGravity(int ), this, n);
    }

    public int getGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$android_widget_LinearLayout$getGravity(), this);
    }

    @RemotableViewMethod
    public void setHorizontalGravity(int n) {
        InvokeDynamicSupport.bootstrap("setHorizontalGravity", $$robo$$android_widget_LinearLayout$setHorizontalGravity(int ), this, n);
    }

    @RemotableViewMethod
    public void setVerticalGravity(int n) {
        InvokeDynamicSupport.bootstrap("setVerticalGravity", $$robo$$android_widget_LinearLayout$setVerticalGravity(int ), this, n);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_LinearLayout$generateLayoutParams(android.util.AttributeSet ), this, attributeSet);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_widget_LinearLayout$generateDefaultLayoutParams(), this);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_LinearLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_widget_LinearLayout$checkLayoutParams(android.view.ViewGroup$LayoutParams ), this, layoutParams);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_LinearLayout$getAccessibilityClassName(), this);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_LinearLayout$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
    }

    public /* synthetic */ LinearLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LinearLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        @ViewDebug.ExportedProperty(category="layout")
        public float weight;
        @ViewDebug.ExportedProperty(category="layout", mapping={@ViewDebug.IntToString(from=-1, to="NONE"), @ViewDebug.IntToString(from=0, to="NONE"), @ViewDebug.IntToString(from=48, to="TOP"), @ViewDebug.IntToString(from=80, to="BOTTOM"), @ViewDebug.IntToString(from=3, to="LEFT"), @ViewDebug.IntToString(from=5, to="RIGHT"), @ViewDebug.IntToString(from=0x800003, to="START"), @ViewDebug.IntToString(from=0x800005, to="END"), @ViewDebug.IntToString(from=16, to="CENTER_VERTICAL"), @ViewDebug.IntToString(from=112, to="FILL_VERTICAL"), @ViewDebug.IntToString(from=1, to="CENTER_HORIZONTAL"), @ViewDebug.IntToString(from=7, to="FILL_HORIZONTAL"), @ViewDebug.IntToString(from=17, to="CENTER"), @ViewDebug.IntToString(from=119, to="FILL")})
        public int gravity;

        private void $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            this.gravity = -1;
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.LinearLayout_Layout);
            this.weight = a.getFloat(3, 0.0f);
            this.gravity = a.getInt(0, -1);
            a.recycle();
        }

        private void $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(int width, int height) {
            this.gravity = -1;
            this.weight = 0.0f;
        }

        private void $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(int width, int height, float weight) {
            this.gravity = -1;
            this.weight = weight;
        }

        private void $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(ViewGroup.LayoutParams p) {
            this.gravity = -1;
        }

        private void $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(ViewGroup.MarginLayoutParams source) {
            this.gravity = -1;
        }

        private void $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(LayoutParams source) {
            this.gravity = -1;
            this.weight = source.weight;
            this.gravity = source.gravity;
        }

        private final String $$robo$$android_widget_LinearLayout_LayoutParams$debug(String output) {
            return output + "LinearLayout.LayoutParams={width=" + LayoutParams.sizeToString(this.width) + ", height=" + LayoutParams.sizeToString(this.height) + " weight=" + this.weight + "}";
        }

        private final void $$robo$$android_widget_LinearLayout_LayoutParams$encodeProperties(ViewHierarchyEncoder encoder) {
            super.encodeProperties(encoder);
            encoder.addProperty("layout:weight", this.weight);
            encoder.addProperty("layout:gravity", this.gravity);
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(int int ), this, n, n2);
        }

        private void __constructor__(int n, int n2, float f) {
            this.$$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(n, n2, f);
        }

        public LayoutParams(int n, int n2, float f) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(int int float ), this, n, n2, f);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), this, layoutParams);
        }

        private void __constructor__(ViewGroup.MarginLayoutParams marginLayoutParams) {
            this.$$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), this, marginLayoutParams);
        }

        private void __constructor__(LayoutParams layoutParams) {
            this.$$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_LinearLayout_LayoutParams$__constructor__(android.widget.LinearLayout$LayoutParams ), this, layoutParams);
        }

        @Override
        public String debug(String string2) {
            return InvokeDynamicSupport.bootstrap("debug", $$robo$$android_widget_LinearLayout_LayoutParams$debug(java.lang.String ), this, string2);
        }

        @Override
        protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
            InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_LinearLayout_LayoutParams$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={0L, 1L, 2L, 4L})
    public static @interface DividerMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    public static @interface OrientationMode {
    }
}

