/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.icu.util.Calendar;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.CalendarView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.R;
import java.util.Locale;
import libcore.icu.LocaleData;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CalendarViewLegacyDelegate
extends CalendarView.AbstractCalendarViewDelegate
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEFAULT_SHOW_WEEK_NUMBER = true;
    private static long MILLIS_IN_DAY = 86400000L;
    private static int DAYS_PER_WEEK = 7;
    private static long MILLIS_IN_WEEK = 604800000L;
    private static int SCROLL_HYST_WEEKS = 2;
    private static int GOTO_SCROLL_DURATION = 1000;
    private static int ADJUSTMENT_SCROLL_DURATION = 500;
    private static int SCROLL_CHANGE_DELAY = 40;
    private static int DEFAULT_SHOWN_WEEK_COUNT = 6;
    private static int DEFAULT_DATE_TEXT_SIZE = 14;
    private static int UNSCALED_SELECTED_DATE_VERTICAL_BAR_WIDTH = 6;
    private static int UNSCALED_WEEK_MIN_VISIBLE_HEIGHT = 12;
    private static int UNSCALED_LIST_SCROLL_TOP_OFFSET = 2;
    private static int UNSCALED_BOTTOM_BUFFER = 20;
    private static int UNSCALED_WEEK_SEPARATOR_LINE_WIDTH = 1;
    private static int DEFAULT_WEEK_DAY_TEXT_APPEARANCE_RES_ID = -1;
    private int mWeekSeparatorLineWidth;
    private int mDateTextSize;
    private Drawable mSelectedDateVerticalBar;
    private int mSelectedDateVerticalBarWidth;
    private int mSelectedWeekBackgroundColor;
    private int mFocusedMonthDateColor;
    private int mUnfocusedMonthDateColor;
    private int mWeekSeparatorLineColor;
    private int mWeekNumberColor;
    private int mWeekDayTextAppearanceResId;
    private int mDateTextAppearanceResId;
    private int mListScrollTopOffset;
    private int mWeekMinVisibleHeight;
    private int mBottomBuffer;
    private int mShownWeekCount;
    private boolean mShowWeekNumber;
    private int mDaysPerWeek;
    private float mFriction;
    private float mVelocityScale;
    private WeeksAdapter mAdapter;
    private ListView mListView;
    private TextView mMonthName;
    private ViewGroup mDayNamesHeader;
    private String[] mDayNamesShort;
    private String[] mDayNamesLong;
    private int mFirstDayOfWeek;
    private int mCurrentMonthDisplayed;
    private long mPreviousScrollPosition;
    private boolean mIsScrollingUp;
    private int mPreviousScrollState;
    private int mCurrentScrollState;
    private CalendarView.OnDateChangeListener mOnDateChangeListener;
    private ScrollStateRunnable mScrollStateChangedRunnable;
    private Calendar mTempDate;
    private Calendar mFirstDayOfMonth;
    private Calendar mMinDate;
    private Calendar mMaxDate;

    private void $$robo$$android_widget_CalendarViewLegacyDelegate$__constructor__(CalendarView delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        String maxDate;
        this.mListScrollTopOffset = 2;
        this.mWeekMinVisibleHeight = 12;
        this.mBottomBuffer = 20;
        this.mDaysPerWeek = 7;
        this.mFriction = 0.05f;
        this.mVelocityScale = 0.333f;
        this.mCurrentMonthDisplayed = -1;
        this.mIsScrollingUp = false;
        this.mPreviousScrollState = 0;
        this.mCurrentScrollState = 0;
        this.mScrollStateChangedRunnable = new ScrollStateRunnable(this, null);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CalendarView, defStyleAttr, defStyleRes);
        this.mShowWeekNumber = a.getBoolean(1, true);
        this.mFirstDayOfWeek = a.getInt(0, LocaleData.get((Locale)Locale.getDefault()).firstDayOfWeek);
        String minDate = a.getString(2);
        if (!CalendarView.parseDate(minDate, this.mMinDate)) {
            CalendarView.parseDate("01/01/1900", this.mMinDate);
        }
        if (!CalendarView.parseDate(maxDate = a.getString(3), this.mMaxDate)) {
            CalendarView.parseDate("01/01/2100", this.mMaxDate);
        }
        if (this.mMaxDate.before(this.mMinDate)) {
            throw new IllegalArgumentException("Max date cannot be before min date.");
        }
        this.mShownWeekCount = a.getInt(4, 6);
        this.mSelectedWeekBackgroundColor = a.getColor(5, 0);
        this.mFocusedMonthDateColor = a.getColor(6, 0);
        this.mUnfocusedMonthDateColor = a.getColor(7, 0);
        this.mWeekSeparatorLineColor = a.getColor(9, 0);
        this.mWeekNumberColor = a.getColor(8, 0);
        this.mSelectedDateVerticalBar = a.getDrawable(10);
        this.mDateTextAppearanceResId = a.getResourceId(12, 16973894);
        this.updateDateTextSize();
        this.mWeekDayTextAppearanceResId = a.getResourceId(11, -1);
        a.recycle();
        DisplayMetrics displayMetrics = this.mDelegator.getResources().getDisplayMetrics();
        this.mWeekMinVisibleHeight = (int)TypedValue.applyDimension(1, 12.0f, displayMetrics);
        this.mListScrollTopOffset = (int)TypedValue.applyDimension(1, 2.0f, displayMetrics);
        this.mBottomBuffer = (int)TypedValue.applyDimension(1, 20.0f, displayMetrics);
        this.mSelectedDateVerticalBarWidth = (int)TypedValue.applyDimension(1, 6.0f, displayMetrics);
        this.mWeekSeparatorLineWidth = (int)TypedValue.applyDimension(1, 1.0f, displayMetrics);
        LayoutInflater layoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        View content = layoutInflater.inflate(17367104, null, false);
        this.mDelegator.addView(content);
        this.mListView = (ListView)this.mDelegator.findViewById(16908298);
        this.mDayNamesHeader = (ViewGroup)content.findViewById(16908819);
        this.mMonthName = (TextView)content.findViewById(16909058);
        this.setUpHeader();
        this.setUpListView();
        this.setUpAdapter();
        this.mTempDate.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        if (this.mTempDate.before(this.mMinDate)) {
            this.goTo(this.mMinDate, false, true, true);
        } else if (this.mMaxDate.before(this.mTempDate)) {
            this.goTo(this.mMaxDate, false, true, true);
        } else {
            this.goTo(this.mTempDate, false, true, true);
        }
        this.mDelegator.invalidate();
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setShownWeekCount(int count) {
        if (this.mShownWeekCount != count) {
            this.mShownWeekCount = count;
            this.mDelegator.invalidate();
        }
    }

    private final int $$robo$$android_widget_CalendarViewLegacyDelegate$getShownWeekCount() {
        return this.mShownWeekCount;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setSelectedWeekBackgroundColor(int color2) {
        if (this.mSelectedWeekBackgroundColor != color2) {
            this.mSelectedWeekBackgroundColor = color2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasSelectedDay) continue;
                weekView.invalidate();
            }
        }
    }

    private final int $$robo$$android_widget_CalendarViewLegacyDelegate$getSelectedWeekBackgroundColor() {
        return this.mSelectedWeekBackgroundColor;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setFocusedMonthDateColor(int color2) {
        if (this.mFocusedMonthDateColor != color2) {
            this.mFocusedMonthDateColor = color2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasFocusedDay) continue;
                weekView.invalidate();
            }
        }
    }

    private final int $$robo$$android_widget_CalendarViewLegacyDelegate$getFocusedMonthDateColor() {
        return this.mFocusedMonthDateColor;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setUnfocusedMonthDateColor(int color2) {
        if (this.mUnfocusedMonthDateColor != color2) {
            this.mUnfocusedMonthDateColor = color2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasUnfocusedDay) continue;
                weekView.invalidate();
            }
        }
    }

    private final int $$robo$$android_widget_CalendarViewLegacyDelegate$getUnfocusedMonthDateColor() {
        return this.mUnfocusedMonthDateColor;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setWeekNumberColor(int color2) {
        if (this.mWeekNumberColor != color2) {
            this.mWeekNumberColor = color2;
            if (this.mShowWeekNumber) {
                this.invalidateAllWeekViews();
            }
        }
    }

    private final int $$robo$$android_widget_CalendarViewLegacyDelegate$getWeekNumberColor() {
        return this.mWeekNumberColor;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setWeekSeparatorLineColor(int color2) {
        if (this.mWeekSeparatorLineColor != color2) {
            this.mWeekSeparatorLineColor = color2;
            this.invalidateAllWeekViews();
        }
    }

    private final int $$robo$$android_widget_CalendarViewLegacyDelegate$getWeekSeparatorLineColor() {
        return this.mWeekSeparatorLineColor;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setSelectedDateVerticalBar(int resourceId) {
        Drawable drawable2 = this.mDelegator.getContext().getDrawable(resourceId);
        this.setSelectedDateVerticalBar(drawable2);
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setSelectedDateVerticalBar(Drawable drawable2) {
        if (this.mSelectedDateVerticalBar != drawable2) {
            this.mSelectedDateVerticalBar = drawable2;
            int childCount = this.mListView.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                WeekView weekView = (WeekView)this.mListView.getChildAt(i);
                if (!weekView.mHasSelectedDay) continue;
                weekView.invalidate();
            }
        }
    }

    private final Drawable $$robo$$android_widget_CalendarViewLegacyDelegate$getSelectedDateVerticalBar() {
        return this.mSelectedDateVerticalBar;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setWeekDayTextAppearance(int resourceId) {
        if (this.mWeekDayTextAppearanceResId != resourceId) {
            this.mWeekDayTextAppearanceResId = resourceId;
            this.setUpHeader();
        }
    }

    private final int $$robo$$android_widget_CalendarViewLegacyDelegate$getWeekDayTextAppearance() {
        return this.mWeekDayTextAppearanceResId;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setDateTextAppearance(int resourceId) {
        if (this.mDateTextAppearanceResId != resourceId) {
            this.mDateTextAppearanceResId = resourceId;
            this.updateDateTextSize();
            this.invalidateAllWeekViews();
        }
    }

    private final int $$robo$$android_widget_CalendarViewLegacyDelegate$getDateTextAppearance() {
        return this.mDateTextAppearanceResId;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (CalendarViewLegacyDelegate.isSameDate(this.mTempDate, this.mMinDate)) {
            return;
        }
        this.mMinDate.setTimeInMillis(minDate);
        Calendar date = this.mAdapter.mSelectedDate;
        if (date.before(this.mMinDate)) {
            this.mAdapter.setSelectedDay(this.mMinDate);
        }
        this.mAdapter.init();
        if (date.before(this.mMinDate)) {
            this.setDate(this.mTempDate.getTimeInMillis());
        } else {
            this.goTo(date, false, true, false);
        }
    }

    private final long $$robo$$android_widget_CalendarViewLegacyDelegate$getMinDate() {
        return this.mMinDate.getTimeInMillis();
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (CalendarViewLegacyDelegate.isSameDate(this.mTempDate, this.mMaxDate)) {
            return;
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mAdapter.init();
        Calendar date = this.mAdapter.mSelectedDate;
        if (date.after(this.mMaxDate)) {
            this.setDate(this.mMaxDate.getTimeInMillis());
        } else {
            this.goTo(date, false, true, false);
        }
    }

    private final long $$robo$$android_widget_CalendarViewLegacyDelegate$getMaxDate() {
        return this.mMaxDate.getTimeInMillis();
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setShowWeekNumber(boolean showWeekNumber) {
        if (this.mShowWeekNumber == showWeekNumber) {
            return;
        }
        this.mShowWeekNumber = showWeekNumber;
        this.mAdapter.notifyDataSetChanged();
        this.setUpHeader();
    }

    private final boolean $$robo$$android_widget_CalendarViewLegacyDelegate$getShowWeekNumber() {
        return this.mShowWeekNumber;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setFirstDayOfWeek(int firstDayOfWeek) {
        if (this.mFirstDayOfWeek == firstDayOfWeek) {
            return;
        }
        this.mFirstDayOfWeek = firstDayOfWeek;
        this.mAdapter.init();
        this.mAdapter.notifyDataSetChanged();
        this.setUpHeader();
    }

    private final int $$robo$$android_widget_CalendarViewLegacyDelegate$getFirstDayOfWeek() {
        return this.mFirstDayOfWeek;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setDate(long date) {
        this.setDate(date, false, false);
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setDate(long date, boolean animate, boolean center) {
        this.mTempDate.setTimeInMillis(date);
        if (CalendarViewLegacyDelegate.isSameDate(this.mTempDate, this.mAdapter.mSelectedDate)) {
            return;
        }
        this.goTo(this.mTempDate, animate, true, center);
    }

    private final long $$robo$$android_widget_CalendarViewLegacyDelegate$getDate() {
        return this.mAdapter.mSelectedDate.getTimeInMillis();
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setOnDateChangeListener(CalendarView.OnDateChangeListener listener) {
        this.mOnDateChangeListener = listener;
    }

    private final boolean $$robo$$android_widget_CalendarViewLegacyDelegate$getBoundsForDate(long date, Rect outBounds) {
        Calendar calendarDate = Calendar.getInstance();
        calendarDate.setTimeInMillis(date);
        int listViewEntryCount = this.mListView.getCount();
        for (int i = 0; i < listViewEntryCount; ++i) {
            WeekView currWeekView = (WeekView)this.mListView.getChildAt(i);
            if (!currWeekView.getBoundsForDate(calendarDate, outBounds)) continue;
            int[] weekViewPositionOnScreen = new int[2];
            int[] delegatorPositionOnScreen = new int[2];
            currWeekView.getLocationOnScreen(weekViewPositionOnScreen);
            this.mDelegator.getLocationOnScreen(delegatorPositionOnScreen);
            int extraVerticalOffset = weekViewPositionOnScreen[1] - delegatorPositionOnScreen[1];
            outBounds.top += extraVerticalOffset;
            outBounds.bottom += extraVerticalOffset;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$onConfigurationChanged(Configuration newConfig) {
        this.setCurrentLocale(newConfig.locale);
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setCurrentLocale(Locale locale) {
        super.setCurrentLocale(locale);
        this.mTempDate = CalendarViewLegacyDelegate.getCalendarForLocale(this.mTempDate, locale);
        this.mFirstDayOfMonth = CalendarViewLegacyDelegate.getCalendarForLocale(this.mFirstDayOfMonth, locale);
        this.mMinDate = CalendarViewLegacyDelegate.getCalendarForLocale(this.mMinDate, locale);
        this.mMaxDate = CalendarViewLegacyDelegate.getCalendarForLocale(this.mMaxDate, locale);
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$updateDateTextSize() {
        TypedArray dateTextAppearance = this.mDelegator.getContext().obtainStyledAttributes(this.mDateTextAppearanceResId, R.styleable.TextAppearance);
        this.mDateTextSize = dateTextAppearance.getDimensionPixelSize(0, 14);
        dateTextAppearance.recycle();
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$invalidateAllWeekViews() {
        int childCount = this.mListView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.mListView.getChildAt(i);
            view.invalidate();
        }
    }

    private static final Calendar $$robo$$android_widget_CalendarViewLegacyDelegate$getCalendarForLocale(Calendar oldCalendar, Locale locale) {
        if (oldCalendar == null) {
            return Calendar.getInstance(locale);
        }
        long currentTimeMillis = oldCalendar.getTimeInMillis();
        Calendar newCalendar = Calendar.getInstance(locale);
        newCalendar.setTimeInMillis(currentTimeMillis);
        return newCalendar;
    }

    private static final boolean $$robo$$android_widget_CalendarViewLegacyDelegate$isSameDate(Calendar firstDate, Calendar secondDate) {
        return firstDate.get(6) == secondDate.get(6) && firstDate.get(1) == secondDate.get(1);
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setUpAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new WeeksAdapter(this, this.mContext);
            this.mAdapter.registerDataSetObserver((DataSetObserver)new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ CalendarViewLegacyDelegate this$0;

                private void $$robo$$android_widget_CalendarViewLegacyDelegate_1$__constructor__(CalendarViewLegacyDelegate this$0) {
                }

                private final void $$robo$$android_widget_CalendarViewLegacyDelegate_1$onChanged() {
                    if (this.this$0.mOnDateChangeListener != null) {
                        Calendar selectedDay = this.this$0.mAdapter.getSelectedDay();
                        this.this$0.mOnDateChangeListener.onSelectedDayChange(this.this$0.mDelegator, selectedDay.get(1), selectedDay.get(2), selectedDay.get(5));
                    }
                }

                private void __constructor__(CalendarViewLegacyDelegate calendarViewLegacyDelegate) {
                    this.$$robo$$android_widget_CalendarViewLegacyDelegate_1$__constructor__(calendarViewLegacyDelegate);
                }
                {
                    this.this$0 = calendarViewLegacyDelegate;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CalendarViewLegacyDelegate_1$__constructor__(android.widget.CalendarViewLegacyDelegate ), this, calendarViewLegacyDelegate);
                }

                @Override
                public void onChanged() {
                    InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_CalendarViewLegacyDelegate_1$onChanged(), this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mListView.setAdapter(this.mAdapter);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setUpHeader() {
        this.mDayNamesShort = new String[this.mDaysPerWeek];
        this.mDayNamesLong = new String[this.mDaysPerWeek];
        int count = this.mFirstDayOfWeek + this.mDaysPerWeek;
        for (int i = this.mFirstDayOfWeek; i < count; ++i) {
            int calendarDay = i > 7 ? i - 7 : i;
            this.mDayNamesShort[i - this.mFirstDayOfWeek] = DateUtils.getDayOfWeekString(calendarDay, 50);
            this.mDayNamesLong[i - this.mFirstDayOfWeek] = DateUtils.getDayOfWeekString(calendarDay, 10);
        }
        TextView label = (TextView)this.mDayNamesHeader.getChildAt(0);
        if (this.mShowWeekNumber) {
            label.setVisibility(0);
        } else {
            label.setVisibility(8);
        }
        int count2 = this.mDayNamesHeader.getChildCount();
        for (int i = 1; i < count2; ++i) {
            label = (TextView)this.mDayNamesHeader.getChildAt(i);
            if (this.mWeekDayTextAppearanceResId > -1) {
                label.setTextAppearance(this.mWeekDayTextAppearanceResId);
            }
            if (i < this.mDaysPerWeek + 1) {
                label.setText(this.mDayNamesShort[i - 1]);
                label.setContentDescription(this.mDayNamesLong[i - 1]);
                label.setVisibility(0);
                continue;
            }
            label.setVisibility(8);
        }
        this.mDayNamesHeader.invalidate();
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setUpListView() {
        this.mListView.setDivider(null);
        this.mListView.setItemsCanFocus(true);
        this.mListView.setVerticalScrollBarEnabled(false);
        this.mListView.setOnScrollListener(new AbsListView.OnScrollListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ CalendarViewLegacyDelegate this$0;

            private void $$robo$$android_widget_CalendarViewLegacyDelegate_2$__constructor__(CalendarViewLegacyDelegate this$0) {
            }

            private final void $$robo$$android_widget_CalendarViewLegacyDelegate_2$onScrollStateChanged(AbsListView view, int scrollState) {
                this.this$0.onScrollStateChanged(view, scrollState);
            }

            private final void $$robo$$android_widget_CalendarViewLegacyDelegate_2$onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                this.this$0.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }

            private void __constructor__(CalendarViewLegacyDelegate calendarViewLegacyDelegate) {
                this.$$robo$$android_widget_CalendarViewLegacyDelegate_2$__constructor__(calendarViewLegacyDelegate);
            }
            {
                this.this$0 = calendarViewLegacyDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CalendarViewLegacyDelegate_2$__constructor__(android.widget.CalendarViewLegacyDelegate ), this, calendarViewLegacyDelegate);
            }

            @Override
            public void onScrollStateChanged(AbsListView absListView, int n) {
                InvokeDynamicSupport.bootstrap("onScrollStateChanged", $$robo$$android_widget_CalendarViewLegacyDelegate_2$onScrollStateChanged(android.widget.AbsListView int ), this, absListView, n);
            }

            @Override
            public void onScroll(AbsListView absListView, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onScroll", $$robo$$android_widget_CalendarViewLegacyDelegate_2$onScroll(android.widget.AbsListView int int int ), this, absListView, n, n2, n3);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mListView.setFriction(this.mFriction);
        this.mListView.setVelocityScale(this.mVelocityScale);
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$goTo(Calendar date, boolean animate, boolean setSelected, boolean forceScroll) {
        int position;
        if (date.before(this.mMinDate) || date.after(this.mMaxDate)) {
            throw new IllegalArgumentException("timeInMillis must be between the values of getMinDate() and getMaxDate()");
        }
        int firstFullyVisiblePosition = this.mListView.getFirstVisiblePosition();
        View firstChild = this.mListView.getChildAt(0);
        if (firstChild != null && firstChild.getTop() < 0) {
            ++firstFullyVisiblePosition;
        }
        int lastFullyVisiblePosition = firstFullyVisiblePosition + this.mShownWeekCount - 1;
        if (firstChild != null && firstChild.getTop() > this.mBottomBuffer) {
            --lastFullyVisiblePosition;
        }
        if (setSelected) {
            this.mAdapter.setSelectedDay(date);
        }
        if ((position = this.getWeeksSinceMinDate(date)) < firstFullyVisiblePosition || position > lastFullyVisiblePosition || forceScroll) {
            this.mFirstDayOfMonth.setTimeInMillis(date.getTimeInMillis());
            this.mFirstDayOfMonth.set(5, 1);
            this.setMonthDisplayed(this.mFirstDayOfMonth);
            position = this.mFirstDayOfMonth.before(this.mMinDate) ? 0 : this.getWeeksSinceMinDate(this.mFirstDayOfMonth);
            this.mPreviousScrollState = 2;
            if (animate) {
                this.mListView.smoothScrollToPositionFromTop(position, this.mListScrollTopOffset, 1000);
            } else {
                this.mListView.setSelectionFromTop(position, this.mListScrollTopOffset);
                this.onScrollStateChanged(this.mListView, 0);
            }
        } else if (setSelected) {
            this.setMonthDisplayed(date);
        }
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$onScrollStateChanged(AbsListView view, int scrollState) {
        this.mScrollStateChangedRunnable.doScrollStateChange(view, scrollState);
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        int offset;
        WeekView child = (WeekView)view.getChildAt(0);
        if (child == null) {
            return;
        }
        long currScroll = view.getFirstVisiblePosition() * child.getHeight() - child.getBottom();
        if (currScroll < this.mPreviousScrollPosition) {
            this.mIsScrollingUp = true;
        } else if (currScroll > this.mPreviousScrollPosition) {
            this.mIsScrollingUp = false;
        } else {
            return;
        }
        int n = offset = child.getBottom() < this.mWeekMinVisibleHeight ? 1 : 0;
        if (this.mIsScrollingUp) {
            child = (WeekView)view.getChildAt(2 + offset);
        } else if (offset != 0) {
            child = (WeekView)view.getChildAt(offset);
        }
        if (child != null) {
            int month = this.mIsScrollingUp ? child.getMonthOfFirstWeekDay() : child.getMonthOfLastWeekDay();
            int monthDiff = this.mCurrentMonthDisplayed == 11 && month == 0 ? 1 : (this.mCurrentMonthDisplayed == 0 && month == 11 ? -1 : month - this.mCurrentMonthDisplayed);
            if (!this.mIsScrollingUp && monthDiff > 0 || this.mIsScrollingUp && monthDiff < 0) {
                Calendar firstDay = child.getFirstDay();
                if (this.mIsScrollingUp) {
                    firstDay.add(5, -7);
                } else {
                    firstDay.add(5, 7);
                }
                this.setMonthDisplayed(firstDay);
            }
        }
        this.mPreviousScrollPosition = currScroll;
        this.mPreviousScrollState = this.mCurrentScrollState;
    }

    private final void $$robo$$android_widget_CalendarViewLegacyDelegate$setMonthDisplayed(Calendar calendar) {
        this.mCurrentMonthDisplayed = calendar.get(2);
        this.mAdapter.setFocusMonth(this.mCurrentMonthDisplayed);
        int flags = 52;
        long millis = calendar.getTimeInMillis();
        String newMonthName = DateUtils.formatDateRange(this.mContext, millis, millis, 52);
        this.mMonthName.setText(newMonthName);
        this.mMonthName.invalidate();
    }

    private final int $$robo$$android_widget_CalendarViewLegacyDelegate$getWeeksSinceMinDate(Calendar date) {
        if (date.before(this.mMinDate)) {
            throw new IllegalArgumentException("fromDate: " + this.mMinDate.getTime() + " does not precede toDate: " + date.getTime());
        }
        long endTimeMillis = date.getTimeInMillis() + (long)date.getTimeZone().getOffset(date.getTimeInMillis());
        long startTimeMillis = this.mMinDate.getTimeInMillis() + (long)this.mMinDate.getTimeZone().getOffset(this.mMinDate.getTimeInMillis());
        long dayOffsetMillis = (long)(this.mMinDate.get(7) - this.mFirstDayOfWeek) * 86400000L;
        return (int)((endTimeMillis - startTimeMillis + dayOffsetMillis) / 604800000L);
    }

    private void __constructor__(CalendarView calendarView, Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_CalendarViewLegacyDelegate$__constructor__(calendarView, context, attributeSet, n, n2);
    }

    public CalendarViewLegacyDelegate(CalendarView calendarView, Context context, AttributeSet attributeSet, int n, int n2) {
        super(calendarView, context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CalendarViewLegacyDelegate$__constructor__(android.widget.CalendarView android.content.Context android.util.AttributeSet int int ), this, calendarView, context, attributeSet, n, n2);
    }

    @Override
    public void setShownWeekCount(int n) {
        InvokeDynamicSupport.bootstrap("setShownWeekCount", $$robo$$android_widget_CalendarViewLegacyDelegate$setShownWeekCount(int ), this, n);
    }

    @Override
    public int getShownWeekCount() {
        return (int)InvokeDynamicSupport.bootstrap("getShownWeekCount", $$robo$$android_widget_CalendarViewLegacyDelegate$getShownWeekCount(), this);
    }

    @Override
    public void setSelectedWeekBackgroundColor(int n) {
        InvokeDynamicSupport.bootstrap("setSelectedWeekBackgroundColor", $$robo$$android_widget_CalendarViewLegacyDelegate$setSelectedWeekBackgroundColor(int ), this, n);
    }

    @Override
    public int getSelectedWeekBackgroundColor() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectedWeekBackgroundColor", $$robo$$android_widget_CalendarViewLegacyDelegate$getSelectedWeekBackgroundColor(), this);
    }

    @Override
    public void setFocusedMonthDateColor(int n) {
        InvokeDynamicSupport.bootstrap("setFocusedMonthDateColor", $$robo$$android_widget_CalendarViewLegacyDelegate$setFocusedMonthDateColor(int ), this, n);
    }

    @Override
    public int getFocusedMonthDateColor() {
        return (int)InvokeDynamicSupport.bootstrap("getFocusedMonthDateColor", $$robo$$android_widget_CalendarViewLegacyDelegate$getFocusedMonthDateColor(), this);
    }

    @Override
    public void setUnfocusedMonthDateColor(int n) {
        InvokeDynamicSupport.bootstrap("setUnfocusedMonthDateColor", $$robo$$android_widget_CalendarViewLegacyDelegate$setUnfocusedMonthDateColor(int ), this, n);
    }

    @Override
    public int getUnfocusedMonthDateColor() {
        return (int)InvokeDynamicSupport.bootstrap("getUnfocusedMonthDateColor", $$robo$$android_widget_CalendarViewLegacyDelegate$getUnfocusedMonthDateColor(), this);
    }

    @Override
    public void setWeekNumberColor(int n) {
        InvokeDynamicSupport.bootstrap("setWeekNumberColor", $$robo$$android_widget_CalendarViewLegacyDelegate$setWeekNumberColor(int ), this, n);
    }

    @Override
    public int getWeekNumberColor() {
        return (int)InvokeDynamicSupport.bootstrap("getWeekNumberColor", $$robo$$android_widget_CalendarViewLegacyDelegate$getWeekNumberColor(), this);
    }

    @Override
    public void setWeekSeparatorLineColor(int n) {
        InvokeDynamicSupport.bootstrap("setWeekSeparatorLineColor", $$robo$$android_widget_CalendarViewLegacyDelegate$setWeekSeparatorLineColor(int ), this, n);
    }

    @Override
    public int getWeekSeparatorLineColor() {
        return (int)InvokeDynamicSupport.bootstrap("getWeekSeparatorLineColor", $$robo$$android_widget_CalendarViewLegacyDelegate$getWeekSeparatorLineColor(), this);
    }

    @Override
    public void setSelectedDateVerticalBar(int n) {
        InvokeDynamicSupport.bootstrap("setSelectedDateVerticalBar", $$robo$$android_widget_CalendarViewLegacyDelegate$setSelectedDateVerticalBar(int ), this, n);
    }

    @Override
    public void setSelectedDateVerticalBar(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setSelectedDateVerticalBar", $$robo$$android_widget_CalendarViewLegacyDelegate$setSelectedDateVerticalBar(android.graphics.drawable.Drawable ), this, drawable2);
    }

    @Override
    public Drawable getSelectedDateVerticalBar() {
        return InvokeDynamicSupport.bootstrap("getSelectedDateVerticalBar", $$robo$$android_widget_CalendarViewLegacyDelegate$getSelectedDateVerticalBar(), this);
    }

    @Override
    public void setWeekDayTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setWeekDayTextAppearance", $$robo$$android_widget_CalendarViewLegacyDelegate$setWeekDayTextAppearance(int ), this, n);
    }

    @Override
    public int getWeekDayTextAppearance() {
        return (int)InvokeDynamicSupport.bootstrap("getWeekDayTextAppearance", $$robo$$android_widget_CalendarViewLegacyDelegate$getWeekDayTextAppearance(), this);
    }

    @Override
    public void setDateTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setDateTextAppearance", $$robo$$android_widget_CalendarViewLegacyDelegate$setDateTextAppearance(int ), this, n);
    }

    @Override
    public int getDateTextAppearance() {
        return (int)InvokeDynamicSupport.bootstrap("getDateTextAppearance", $$robo$$android_widget_CalendarViewLegacyDelegate$getDateTextAppearance(), this);
    }

    @Override
    public void setMinDate(long l) {
        InvokeDynamicSupport.bootstrap("setMinDate", $$robo$$android_widget_CalendarViewLegacyDelegate$setMinDate(long ), this, l);
    }

    @Override
    public long getMinDate() {
        return (long)InvokeDynamicSupport.bootstrap("getMinDate", $$robo$$android_widget_CalendarViewLegacyDelegate$getMinDate(), this);
    }

    @Override
    public void setMaxDate(long l) {
        InvokeDynamicSupport.bootstrap("setMaxDate", $$robo$$android_widget_CalendarViewLegacyDelegate$setMaxDate(long ), this, l);
    }

    @Override
    public long getMaxDate() {
        return (long)InvokeDynamicSupport.bootstrap("getMaxDate", $$robo$$android_widget_CalendarViewLegacyDelegate$getMaxDate(), this);
    }

    @Override
    public void setShowWeekNumber(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowWeekNumber", $$robo$$android_widget_CalendarViewLegacyDelegate$setShowWeekNumber(boolean ), this, bl);
    }

    @Override
    public boolean getShowWeekNumber() {
        return (boolean)InvokeDynamicSupport.bootstrap("getShowWeekNumber", $$robo$$android_widget_CalendarViewLegacyDelegate$getShowWeekNumber(), this);
    }

    @Override
    public void setFirstDayOfWeek(int n) {
        InvokeDynamicSupport.bootstrap("setFirstDayOfWeek", $$robo$$android_widget_CalendarViewLegacyDelegate$setFirstDayOfWeek(int ), this, n);
    }

    @Override
    public int getFirstDayOfWeek() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstDayOfWeek", $$robo$$android_widget_CalendarViewLegacyDelegate$getFirstDayOfWeek(), this);
    }

    @Override
    public void setDate(long l) {
        InvokeDynamicSupport.bootstrap("setDate", $$robo$$android_widget_CalendarViewLegacyDelegate$setDate(long ), this, l);
    }

    @Override
    public void setDate(long l, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setDate", $$robo$$android_widget_CalendarViewLegacyDelegate$setDate(long boolean boolean ), this, l, bl, bl2);
    }

    @Override
    public long getDate() {
        return (long)InvokeDynamicSupport.bootstrap("getDate", $$robo$$android_widget_CalendarViewLegacyDelegate$getDate(), this);
    }

    @Override
    public void setOnDateChangeListener(CalendarView.OnDateChangeListener onDateChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnDateChangeListener", $$robo$$android_widget_CalendarViewLegacyDelegate$setOnDateChangeListener(android.widget.CalendarView$OnDateChangeListener ), this, onDateChangeListener);
    }

    @Override
    public boolean getBoundsForDate(long l, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoundsForDate", $$robo$$android_widget_CalendarViewLegacyDelegate$getBoundsForDate(long android.graphics.Rect ), this, l, rect);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_CalendarViewLegacyDelegate$onConfigurationChanged(android.content.res.Configuration ), this, configuration);
    }

    @Override
    protected void setCurrentLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setCurrentLocale", $$robo$$android_widget_CalendarViewLegacyDelegate$setCurrentLocale(java.util.Locale ), this, locale);
    }

    private void updateDateTextSize() {
        InvokeDynamicSupport.bootstrap("updateDateTextSize", $$robo$$android_widget_CalendarViewLegacyDelegate$updateDateTextSize(), this);
    }

    private void invalidateAllWeekViews() {
        InvokeDynamicSupport.bootstrap("invalidateAllWeekViews", $$robo$$android_widget_CalendarViewLegacyDelegate$invalidateAllWeekViews(), this);
    }

    private static Calendar getCalendarForLocale(Calendar calendar, Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getCalendarForLocale", $$robo$$android_widget_CalendarViewLegacyDelegate$getCalendarForLocale(android.icu.util.Calendar java.util.Locale ), (Calendar)calendar, (Locale)locale);
    }

    private static boolean isSameDate(Calendar calendar, Calendar calendar2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSameDate", $$robo$$android_widget_CalendarViewLegacyDelegate$isSameDate(android.icu.util.Calendar android.icu.util.Calendar ), (Calendar)calendar, (Calendar)calendar2);
    }

    private void setUpAdapter() {
        InvokeDynamicSupport.bootstrap("setUpAdapter", $$robo$$android_widget_CalendarViewLegacyDelegate$setUpAdapter(), this);
    }

    private void setUpHeader() {
        InvokeDynamicSupport.bootstrap("setUpHeader", $$robo$$android_widget_CalendarViewLegacyDelegate$setUpHeader(), this);
    }

    private void setUpListView() {
        InvokeDynamicSupport.bootstrap("setUpListView", $$robo$$android_widget_CalendarViewLegacyDelegate$setUpListView(), this);
    }

    private void goTo(Calendar calendar, boolean bl, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("goTo", $$robo$$android_widget_CalendarViewLegacyDelegate$goTo(android.icu.util.Calendar boolean boolean boolean ), this, calendar, bl, bl2, bl3);
    }

    private void onScrollStateChanged(AbsListView absListView, int n) {
        InvokeDynamicSupport.bootstrap("onScrollStateChanged", $$robo$$android_widget_CalendarViewLegacyDelegate$onScrollStateChanged(android.widget.AbsListView int ), this, absListView, n);
    }

    private void onScroll(AbsListView absListView, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onScroll", $$robo$$android_widget_CalendarViewLegacyDelegate$onScroll(android.widget.AbsListView int int int ), this, absListView, n, n2, n3);
    }

    private void setMonthDisplayed(Calendar calendar) {
        InvokeDynamicSupport.bootstrap("setMonthDisplayed", $$robo$$android_widget_CalendarViewLegacyDelegate$setMonthDisplayed(android.icu.util.Calendar ), this, calendar);
    }

    private int getWeeksSinceMinDate(Calendar calendar) {
        return (int)InvokeDynamicSupport.bootstrap("getWeeksSinceMinDate", $$robo$$android_widget_CalendarViewLegacyDelegate$getWeeksSinceMinDate(android.icu.util.Calendar ), this, calendar);
    }

    public /* synthetic */ CalendarViewLegacyDelegate() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarViewLegacyDelegate)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class WeekView
    extends View
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Rect mTempRect;
        private Paint mDrawPaint;
        private Paint mMonthNumDrawPaint;
        private String[] mDayNumbers;
        private boolean[] mFocusDay;
        private boolean mHasFocusedDay;
        private boolean mHasUnfocusedDay;
        private Calendar mFirstDay;
        private int mMonthOfFirstWeekDay;
        private int mLastWeekDayMonth;
        private int mWeek;
        private int mWidth;
        private int mHeight;
        private boolean mHasSelectedDay;
        private int mSelectedDay;
        private int mNumCells;
        private int mSelectedLeft;
        private int mSelectedRight;
        /* synthetic */ CalendarViewLegacyDelegate this$0;

        private void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$__constructor__(CalendarViewLegacyDelegate calendarViewLegacyDelegate, Context context) {
            this.mTempRect = new Rect();
            this.mDrawPaint = new Paint();
            this.mMonthNumDrawPaint = new Paint();
            this.mMonthOfFirstWeekDay = -1;
            this.mLastWeekDayMonth = -1;
            this.mWeek = -1;
            this.mHasSelectedDay = false;
            this.mSelectedDay = -1;
            this.mSelectedLeft = -1;
            this.mSelectedRight = -1;
            this.initializePaints();
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$init(int weekNumber, int selectedWeekDay, int focusedMonth) {
            this.mSelectedDay = selectedWeekDay;
            this.mHasSelectedDay = this.mSelectedDay != -1;
            this.mNumCells = this.this$0.mShowWeekNumber ? this.this$0.mDaysPerWeek + 1 : this.this$0.mDaysPerWeek;
            this.mWeek = weekNumber;
            this.this$0.mTempDate.setTimeInMillis(this.this$0.mMinDate.getTimeInMillis());
            this.this$0.mTempDate.add(3, this.mWeek);
            this.this$0.mTempDate.setFirstDayOfWeek(this.this$0.mFirstDayOfWeek);
            this.mDayNumbers = new String[this.mNumCells];
            this.mFocusDay = new boolean[this.mNumCells];
            int i = 0;
            if (this.this$0.mShowWeekNumber) {
                this.mDayNumbers[0] = String.format(Locale.getDefault(), "%d", this.this$0.mTempDate.get(3));
                ++i;
            }
            int diff = this.this$0.mFirstDayOfWeek - this.this$0.mTempDate.get(7);
            this.this$0.mTempDate.add(5, diff);
            this.mFirstDay = (Calendar)this.this$0.mTempDate.clone();
            this.mMonthOfFirstWeekDay = this.this$0.mTempDate.get(2);
            this.mHasUnfocusedDay = true;
            while (i < this.mNumCells) {
                boolean isFocusedDay;
                this.mFocusDay[i] = isFocusedDay = this.this$0.mTempDate.get(2) == focusedMonth;
                this.mHasFocusedDay |= isFocusedDay;
                this.mHasUnfocusedDay &= !isFocusedDay;
                this.mDayNumbers[i] = this.this$0.mTempDate.before(this.this$0.mMinDate) || this.this$0.mTempDate.after(this.this$0.mMaxDate) ? "" : String.format(Locale.getDefault(), "%d", this.this$0.mTempDate.get(5));
                this.this$0.mTempDate.add(5, 1);
                ++i;
            }
            if (this.this$0.mTempDate.get(5) == 1) {
                this.this$0.mTempDate.add(5, -1);
            }
            this.mLastWeekDayMonth = this.this$0.mTempDate.get(2);
            this.updateSelectionPositions();
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$initializePaints() {
            this.mDrawPaint.setFakeBoldText(false);
            this.mDrawPaint.setAntiAlias(true);
            this.mDrawPaint.setStyle(Paint.Style.FILL);
            this.mMonthNumDrawPaint.setFakeBoldText(true);
            this.mMonthNumDrawPaint.setAntiAlias(true);
            this.mMonthNumDrawPaint.setStyle(Paint.Style.FILL);
            this.mMonthNumDrawPaint.setTextAlign(Paint.Align.CENTER);
            this.mMonthNumDrawPaint.setTextSize(this.this$0.mDateTextSize);
        }

        private final int $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$getMonthOfFirstWeekDay() {
            return this.mMonthOfFirstWeekDay;
        }

        private final int $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$getMonthOfLastWeekDay() {
            return this.mLastWeekDayMonth;
        }

        private final Calendar $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$getFirstDay() {
            return this.mFirstDay;
        }

        private final boolean $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$getDayFromLocation(float x, Calendar outCalendar) {
            int end;
            int start;
            boolean isLayoutRtl = this.isLayoutRtl();
            if (isLayoutRtl) {
                start = 0;
                end = this.this$0.mShowWeekNumber ? this.mWidth - this.mWidth / this.mNumCells : this.mWidth;
            } else {
                start = this.this$0.mShowWeekNumber ? this.mWidth / this.mNumCells : 0;
                end = this.mWidth;
            }
            if (x < (float)start || x > (float)end) {
                outCalendar.clear();
                return false;
            }
            int dayPosition = (int)((x - (float)start) * (float)this.this$0.mDaysPerWeek / (float)(end - start));
            if (isLayoutRtl) {
                dayPosition = this.this$0.mDaysPerWeek - 1 - dayPosition;
            }
            outCalendar.setTimeInMillis(this.mFirstDay.getTimeInMillis());
            outCalendar.add(5, dayPosition);
            return true;
        }

        private final boolean $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$getBoundsForDate(Calendar date, Rect outBounds) {
            Calendar currDay = Calendar.getInstance();
            currDay.setTime(this.mFirstDay.getTime());
            for (int i = 0; i < this.this$0.mDaysPerWeek; ++i) {
                if (date.get(1) == currDay.get(1) && date.get(2) == currDay.get(2) && date.get(5) == currDay.get(5)) {
                    int cellSize = this.mWidth / this.mNumCells;
                    outBounds.left = this.isLayoutRtl() ? cellSize * (this.this$0.mShowWeekNumber ? this.mNumCells - i - 2 : this.mNumCells - i - 1) : cellSize * (this.this$0.mShowWeekNumber ? i + 1 : i);
                    outBounds.top = 0;
                    outBounds.right = outBounds.left + cellSize;
                    outBounds.bottom = this.getHeight();
                    return true;
                }
                currDay.add(5, 1);
            }
            return false;
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$onDraw(Canvas canvas) {
            this.drawBackground(canvas);
            this.drawWeekNumbersAndDates(canvas);
            this.drawWeekSeparators(canvas);
            this.drawSelectedDateVerticalBars(canvas);
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$drawBackground(Canvas canvas) {
            if (!this.mHasSelectedDay) {
                return;
            }
            this.mDrawPaint.setColor(this.this$0.mSelectedWeekBackgroundColor);
            this.mTempRect.top = this.this$0.mWeekSeparatorLineWidth;
            this.mTempRect.bottom = this.mHeight;
            boolean isLayoutRtl = this.isLayoutRtl();
            if (isLayoutRtl) {
                this.mTempRect.left = 0;
                this.mTempRect.right = this.mSelectedLeft - 2;
            } else {
                this.mTempRect.left = this.this$0.mShowWeekNumber ? this.mWidth / this.mNumCells : 0;
                this.mTempRect.right = this.mSelectedLeft - 2;
            }
            canvas.drawRect(this.mTempRect, this.mDrawPaint);
            if (isLayoutRtl) {
                this.mTempRect.left = this.mSelectedRight + 3;
                this.mTempRect.right = this.this$0.mShowWeekNumber ? this.mWidth - this.mWidth / this.mNumCells : this.mWidth;
            } else {
                this.mTempRect.left = this.mSelectedRight + 3;
                this.mTempRect.right = this.mWidth;
            }
            canvas.drawRect(this.mTempRect, this.mDrawPaint);
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$drawWeekNumbersAndDates(Canvas canvas) {
            int i;
            float textHeight = this.mDrawPaint.getTextSize();
            int y = (int)(((float)this.mHeight + textHeight) / 2.0f) - this.this$0.mWeekSeparatorLineWidth;
            int nDays = this.mNumCells;
            int divisor = 2 * nDays;
            this.mDrawPaint.setTextAlign(Paint.Align.CENTER);
            this.mDrawPaint.setTextSize(this.this$0.mDateTextSize);
            if (this.isLayoutRtl()) {
                int x;
                for (i = 0; i < nDays - 1; ++i) {
                    this.mMonthNumDrawPaint.setColor(this.mFocusDay[i] ? this.this$0.mFocusedMonthDateColor : this.this$0.mUnfocusedMonthDateColor);
                    x = (2 * i + 1) * this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[nDays - 1 - i], x, y, this.mMonthNumDrawPaint);
                }
                if (this.this$0.mShowWeekNumber) {
                    this.mDrawPaint.setColor(this.this$0.mWeekNumberColor);
                    x = this.mWidth - this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[0], x, y, this.mDrawPaint);
                }
            } else {
                int x;
                if (this.this$0.mShowWeekNumber) {
                    this.mDrawPaint.setColor(this.this$0.mWeekNumberColor);
                    x = this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[0], x, y, this.mDrawPaint);
                    ++i;
                }
                while (i < nDays) {
                    this.mMonthNumDrawPaint.setColor(this.mFocusDay[i] ? this.this$0.mFocusedMonthDateColor : this.this$0.mUnfocusedMonthDateColor);
                    x = (2 * i + 1) * this.mWidth / divisor;
                    canvas.drawText(this.mDayNumbers[i], x, y, this.mMonthNumDrawPaint);
                    ++i;
                }
            }
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$drawWeekSeparators(Canvas canvas) {
            float stopX;
            float startX;
            int firstFullyVisiblePosition = this.this$0.mListView.getFirstVisiblePosition();
            if (this.this$0.mListView.getChildAt(0).getTop() < 0) {
                ++firstFullyVisiblePosition;
            }
            if (firstFullyVisiblePosition == this.mWeek) {
                return;
            }
            this.mDrawPaint.setColor(this.this$0.mWeekSeparatorLineColor);
            this.mDrawPaint.setStrokeWidth(this.this$0.mWeekSeparatorLineWidth);
            if (this.isLayoutRtl()) {
                startX = 0.0f;
                stopX = this.this$0.mShowWeekNumber ? (float)(this.mWidth - this.mWidth / this.mNumCells) : (float)this.mWidth;
            } else {
                startX = this.this$0.mShowWeekNumber ? (float)(this.mWidth / this.mNumCells) : 0.0f;
                stopX = this.mWidth;
            }
            canvas.drawLine(startX, 0.0f, stopX, 0.0f, this.mDrawPaint);
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$drawSelectedDateVerticalBars(Canvas canvas) {
            if (!this.mHasSelectedDay) {
                return;
            }
            this.this$0.mSelectedDateVerticalBar.setBounds(this.mSelectedLeft - this.this$0.mSelectedDateVerticalBarWidth / 2, this.this$0.mWeekSeparatorLineWidth, this.mSelectedLeft + this.this$0.mSelectedDateVerticalBarWidth / 2, this.mHeight);
            this.this$0.mSelectedDateVerticalBar.draw(canvas);
            this.this$0.mSelectedDateVerticalBar.setBounds(this.mSelectedRight - this.this$0.mSelectedDateVerticalBarWidth / 2, this.this$0.mWeekSeparatorLineWidth, this.mSelectedRight + this.this$0.mSelectedDateVerticalBarWidth / 2, this.mHeight);
            this.this$0.mSelectedDateVerticalBar.draw(canvas);
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$onSizeChanged(int w, int h, int oldw, int oldh) {
            this.mWidth = w;
            this.updateSelectionPositions();
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$updateSelectionPositions() {
            if (this.mHasSelectedDay) {
                boolean isLayoutRtl = this.isLayoutRtl();
                int selectedPosition = this.mSelectedDay - this.this$0.mFirstDayOfWeek;
                if (selectedPosition < 0) {
                    selectedPosition += 7;
                }
                if (this.this$0.mShowWeekNumber && !isLayoutRtl) {
                    ++selectedPosition;
                }
                this.mSelectedLeft = isLayoutRtl ? (this.this$0.mDaysPerWeek - 1 - selectedPosition) * this.mWidth / this.mNumCells : selectedPosition * this.mWidth / this.mNumCells;
                this.mSelectedRight = this.mSelectedLeft + this.mWidth / this.mNumCells;
            }
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.mHeight = (this.this$0.mListView.getHeight() - this.this$0.mListView.getPaddingTop() - this.this$0.mListView.getPaddingBottom()) / this.this$0.mShownWeekCount;
            this.setMeasuredDimension(View.MeasureSpec.getSize(widthMeasureSpec), this.mHeight);
        }

        private void __constructor__(CalendarViewLegacyDelegate calendarViewLegacyDelegate, Context context) {
            this.$$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$__constructor__(calendarViewLegacyDelegate, context);
        }

        public WeekView(CalendarViewLegacyDelegate calendarViewLegacyDelegate, Context context) {
            this.this$0 = calendarViewLegacyDelegate;
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$__constructor__(android.widget.CalendarViewLegacyDelegate android.content.Context ), this, calendarViewLegacyDelegate, context);
        }

        public void init(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$init(int int int ), this, n, n2, n3);
        }

        private void initializePaints() {
            InvokeDynamicSupport.bootstrap("initializePaints", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$initializePaints(), this);
        }

        public int getMonthOfFirstWeekDay() {
            return (int)InvokeDynamicSupport.bootstrap("getMonthOfFirstWeekDay", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$getMonthOfFirstWeekDay(), this);
        }

        public int getMonthOfLastWeekDay() {
            return (int)InvokeDynamicSupport.bootstrap("getMonthOfLastWeekDay", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$getMonthOfLastWeekDay(), this);
        }

        public Calendar getFirstDay() {
            return InvokeDynamicSupport.bootstrap("getFirstDay", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$getFirstDay(), this);
        }

        public boolean getDayFromLocation(float f, Calendar calendar) {
            return (boolean)InvokeDynamicSupport.bootstrap("getDayFromLocation", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$getDayFromLocation(float android.icu.util.Calendar ), this, f, calendar);
        }

        public boolean getBoundsForDate(Calendar calendar, Rect rect) {
            return (boolean)InvokeDynamicSupport.bootstrap("getBoundsForDate", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$getBoundsForDate(android.icu.util.Calendar android.graphics.Rect ), this, calendar, rect);
        }

        @Override
        protected void onDraw(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$onDraw(android.graphics.Canvas ), this, canvas);
        }

        private void drawBackground(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("drawBackground", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$drawBackground(android.graphics.Canvas ), this, canvas);
        }

        private void drawWeekNumbersAndDates(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("drawWeekNumbersAndDates", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$drawWeekNumbersAndDates(android.graphics.Canvas ), this, canvas);
        }

        private void drawWeekSeparators(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("drawWeekSeparators", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$drawWeekSeparators(android.graphics.Canvas ), this, canvas);
        }

        private void drawSelectedDateVerticalBars(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("drawSelectedDateVerticalBars", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$drawSelectedDateVerticalBars(android.graphics.Canvas ), this, canvas);
        }

        @Override
        protected void onSizeChanged(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$onSizeChanged(int int int int ), this, n, n2, n3, n4);
        }

        private void updateSelectionPositions() {
            InvokeDynamicSupport.bootstrap("updateSelectionPositions", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$updateSelectionPositions(), this);
        }

        @Override
        protected void onMeasure(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_CalendarViewLegacyDelegate_WeekView$onMeasure(int int ), this, n, n2);
        }

        public /* synthetic */ WeekView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WeekView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class WeeksAdapter
    extends BaseAdapter
    implements View.OnTouchListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mSelectedWeek;
        private GestureDetector mGestureDetector;
        private int mFocusedMonth;
        private Calendar mSelectedDate;
        private int mTotalWeekCount;
        /* synthetic */ CalendarViewLegacyDelegate this$0;

        private void $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$__constructor__(CalendarViewLegacyDelegate calendarViewLegacyDelegate, Context context) {
            this.mSelectedDate = Calendar.getInstance();
            calendarViewLegacyDelegate.mContext = context;
            this.mGestureDetector = new GestureDetector(calendarViewLegacyDelegate.mContext, new CalendarGestureListener(this));
            this.init();
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$init() {
            this.mSelectedWeek = this.this$0.getWeeksSinceMinDate(this.mSelectedDate);
            this.mTotalWeekCount = this.this$0.getWeeksSinceMinDate(this.this$0.mMaxDate);
            if (this.this$0.mMinDate.get(7) != this.this$0.mFirstDayOfWeek || this.this$0.mMaxDate.get(7) != this.this$0.mFirstDayOfWeek) {
                ++this.mTotalWeekCount;
            }
            this.notifyDataSetChanged();
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$setSelectedDay(Calendar selectedDay) {
            if (selectedDay.get(6) == this.mSelectedDate.get(6) && selectedDay.get(1) == this.mSelectedDate.get(1)) {
                return;
            }
            this.mSelectedDate.setTimeInMillis(selectedDay.getTimeInMillis());
            this.mSelectedWeek = this.this$0.getWeeksSinceMinDate(this.mSelectedDate);
            this.mFocusedMonth = this.mSelectedDate.get(2);
            this.notifyDataSetChanged();
        }

        private final Calendar $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$getSelectedDay() {
            return this.mSelectedDate;
        }

        private final int $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$getCount() {
            return this.mTotalWeekCount;
        }

        private final Object $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$getItem(int position) {
            return null;
        }

        private final long $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$getItemId(int position) {
            return position;
        }

        private final View $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$getView(int position, View convertView, ViewGroup parent) {
            WeekView weekView = null;
            if (convertView != null) {
                weekView = (WeekView)convertView;
            } else {
                weekView = new WeekView(this.this$0, this.this$0.mContext);
                AbsListView.LayoutParams params = new AbsListView.LayoutParams(-2, -2);
                weekView.setLayoutParams(params);
                weekView.setClickable(true);
                weekView.setOnTouchListener(this);
            }
            int selectedWeekDay = this.mSelectedWeek == position ? this.mSelectedDate.get(7) : -1;
            weekView.init(position, selectedWeekDay, this.mFocusedMonth);
            return weekView;
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$setFocusMonth(int month) {
            if (this.mFocusedMonth == month) {
                return;
            }
            this.mFocusedMonth = month;
            this.notifyDataSetChanged();
        }

        private final boolean $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$onTouch(View v, MotionEvent event) {
            if (this.this$0.mListView.isEnabled() && this.mGestureDetector.onTouchEvent(event)) {
                WeekView weekView = (WeekView)v;
                if (!weekView.getDayFromLocation(event.getX(), this.this$0.mTempDate)) {
                    return true;
                }
                if (this.this$0.mTempDate.before(this.this$0.mMinDate) || this.this$0.mTempDate.after(this.this$0.mMaxDate)) {
                    return true;
                }
                this.onDateTapped(this.this$0.mTempDate);
                return true;
            }
            return false;
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$onDateTapped(Calendar day) {
            this.setSelectedDay(day);
            this.this$0.setMonthDisplayed(day);
        }

        private void __constructor__(CalendarViewLegacyDelegate calendarViewLegacyDelegate, Context context) {
            this.$$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$__constructor__(calendarViewLegacyDelegate, context);
        }

        public WeeksAdapter(CalendarViewLegacyDelegate calendarViewLegacyDelegate, Context context) {
            this.this$0 = calendarViewLegacyDelegate;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$__constructor__(android.widget.CalendarViewLegacyDelegate android.content.Context ), this, calendarViewLegacyDelegate, context);
        }

        private void init() {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$init(), this);
        }

        public void setSelectedDay(Calendar calendar) {
            InvokeDynamicSupport.bootstrap("setSelectedDay", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$setSelectedDay(android.icu.util.Calendar ), this, calendar);
        }

        public Calendar getSelectedDay() {
            return InvokeDynamicSupport.bootstrap("getSelectedDay", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$getSelectedDay(), this);
        }

        @Override
        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$getCount(), this);
        }

        @Override
        public Object getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$getItem(int ), this, n);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$getItemId(int ), this, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$getView(int android.view.View android.view.ViewGroup ), this, n, view, viewGroup);
        }

        public void setFocusMonth(int n) {
            InvokeDynamicSupport.bootstrap("setFocusMonth", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$setFocusMonth(int ), this, n);
        }

        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$onTouch(android.view.View android.view.MotionEvent ), this, view, motionEvent);
        }

        private void onDateTapped(Calendar calendar) {
            InvokeDynamicSupport.bootstrap("onDateTapped", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter$onDateTapped(android.icu.util.Calendar ), this, calendar);
        }

        public /* synthetic */ WeeksAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WeeksAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public class CalendarGestureListener
        extends GestureDetector.SimpleOnGestureListener
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ WeeksAdapter this$1;

            private void $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter_CalendarGestureListener$__constructor__(WeeksAdapter this$1) {
                this.this$1 = this$1;
            }

            private final boolean $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter_CalendarGestureListener$onSingleTapUp(MotionEvent e) {
                return true;
            }

            private void __constructor__(WeeksAdapter weeksAdapter) {
                this.$$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter_CalendarGestureListener$__constructor__(weeksAdapter);
            }

            public CalendarGestureListener(WeeksAdapter weeksAdapter) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter_CalendarGestureListener$__constructor__(android.widget.CalendarViewLegacyDelegate$WeeksAdapter ), this, weeksAdapter);
            }

            @Override
            public boolean onSingleTapUp(MotionEvent motionEvent) {
                return (boolean)InvokeDynamicSupport.bootstrap("onSingleTapUp", $$robo$$android_widget_CalendarViewLegacyDelegate_WeeksAdapter_CalendarGestureListener$onSingleTapUp(android.view.MotionEvent ), this, motionEvent);
            }

            public /* synthetic */ CalendarGestureListener() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CalendarGestureListener)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private class ScrollStateRunnable
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private AbsListView mView;
        private int mNewState;
        /* synthetic */ CalendarViewLegacyDelegate this$0;

        private void $$robo$$android_widget_CalendarViewLegacyDelegate_ScrollStateRunnable$__constructor__(CalendarViewLegacyDelegate calendarViewLegacyDelegate) {
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_ScrollStateRunnable$doScrollStateChange(AbsListView view, int scrollState) {
            this.mView = view;
            this.mNewState = scrollState;
            this.this$0.mDelegator.removeCallbacks(this);
            this.this$0.mDelegator.postDelayed(this, 40L);
        }

        private final void $$robo$$android_widget_CalendarViewLegacyDelegate_ScrollStateRunnable$run() {
            this.this$0.mCurrentScrollState = this.mNewState;
            if (this.mNewState == 0 && this.this$0.mPreviousScrollState != 0) {
                View child = this.mView.getChildAt(0);
                if (child == null) {
                    return;
                }
                int dist = child.getBottom() - this.this$0.mListScrollTopOffset;
                if (dist > this.this$0.mListScrollTopOffset) {
                    if (this.this$0.mIsScrollingUp) {
                        this.mView.smoothScrollBy(dist - child.getHeight(), 500);
                    } else {
                        this.mView.smoothScrollBy(dist, 500);
                    }
                }
            }
            this.this$0.mPreviousScrollState = this.mNewState;
        }

        private /* synthetic */ void $$robo$$android_widget_CalendarViewLegacyDelegate_ScrollStateRunnable$__constructor__(CalendarViewLegacyDelegate x0, 1 x1) {
        }

        private void __constructor__(CalendarViewLegacyDelegate calendarViewLegacyDelegate) {
            this.$$robo$$android_widget_CalendarViewLegacyDelegate_ScrollStateRunnable$__constructor__(calendarViewLegacyDelegate);
        }

        public ScrollStateRunnable(CalendarViewLegacyDelegate calendarViewLegacyDelegate) {
            this.this$0 = calendarViewLegacyDelegate;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CalendarViewLegacyDelegate_ScrollStateRunnable$__constructor__(android.widget.CalendarViewLegacyDelegate ), this, calendarViewLegacyDelegate);
        }

        public void doScrollStateChange(AbsListView absListView, int n) {
            InvokeDynamicSupport.bootstrap("doScrollStateChange", $$robo$$android_widget_CalendarViewLegacyDelegate_ScrollStateRunnable$doScrollStateChange(android.widget.AbsListView int ), this, absListView, n);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_CalendarViewLegacyDelegate_ScrollStateRunnable$run(), this);
        }

        private /* synthetic */ void __constructor__(CalendarViewLegacyDelegate calendarViewLegacyDelegate, 1 var2_2) {
            this.$$robo$$android_widget_CalendarViewLegacyDelegate_ScrollStateRunnable$__constructor__(calendarViewLegacyDelegate, var2_2);
        }

        public /* synthetic */ ScrollStateRunnable(CalendarViewLegacyDelegate calendarViewLegacyDelegate, 1 var2_2) {
            this(calendarViewLegacyDelegate);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CalendarViewLegacyDelegate_ScrollStateRunnable$__constructor__(android.widget.CalendarViewLegacyDelegate android.widget.CalendarViewLegacyDelegate$1 ), this, calendarViewLegacyDelegate, var2_2);
        }

        public /* synthetic */ ScrollStateRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScrollStateRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

