/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.database.DataSetObservable;
import android.os.AsyncTask;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import com.android.internal.content.PackageMonitor;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ActivityChooserModel
extends DataSetObservable
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String LOG_TAG;
    private static String TAG_HISTORICAL_RECORDS = "historical-records";
    private static String TAG_HISTORICAL_RECORD = "historical-record";
    private static String ATTRIBUTE_ACTIVITY = "activity";
    private static String ATTRIBUTE_TIME = "time";
    private static String ATTRIBUTE_WEIGHT = "weight";
    public static String DEFAULT_HISTORY_FILE_NAME = "activity_choser_model_history.xml";
    public static int DEFAULT_HISTORY_MAX_LENGTH = 50;
    private static int DEFAULT_ACTIVITY_INFLATION = 5;
    private static float DEFAULT_HISTORICAL_RECORD_WEIGHT = 1.0f;
    private static String HISTORY_FILE_EXTENSION = ".xml";
    private static int INVALID_INDEX = -1;
    private static Object sRegistryLock;
    private static Map<String, ActivityChooserModel> sDataModelRegistry;
    private Object mInstanceLock;
    private List<ActivityResolveInfo> mActivities;
    private List<HistoricalRecord> mHistoricalRecords;
    private PackageMonitor mPackageMonitor;
    private Context mContext;
    private String mHistoryFileName;
    private Intent mIntent;
    private ActivitySorter mActivitySorter;
    private int mHistoryMaxSize;
    private boolean mCanReadHistoricalData;
    private boolean mReadShareHistoryCalled;
    private boolean mHistoricalRecordsChanged;
    private boolean mReloadActivities;
    private OnChooseActivityListener mActivityChoserModelPolicy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ActivityChooserModel $$robo$$android_widget_ActivityChooserModel$get(Context context, String historyFileName) {
        Object object = sRegistryLock;
        synchronized (object) {
            ActivityChooserModel dataModel = sDataModelRegistry.get(historyFileName);
            if (dataModel == null) {
                dataModel = new ActivityChooserModel(context, historyFileName);
                sDataModelRegistry.put(historyFileName, dataModel);
            }
            return dataModel;
        }
    }

    private void $$robo$$android_widget_ActivityChooserModel$__constructor__(Context context, String historyFileName) {
        this.mInstanceLock = new Object();
        this.mActivities = new ArrayList<ActivityResolveInfo>();
        this.mHistoricalRecords = new ArrayList<HistoricalRecord>();
        this.mPackageMonitor = new DataModelPackageMonitor(this, null);
        this.mActivitySorter = new DefaultSorter(this, null);
        this.mHistoryMaxSize = 50;
        this.mCanReadHistoricalData = true;
        this.mReadShareHistoryCalled = false;
        this.mHistoricalRecordsChanged = true;
        this.mReloadActivities = false;
        this.mContext = context.getApplicationContext();
        this.mHistoryFileName = !TextUtils.isEmpty(historyFileName) && !historyFileName.endsWith(".xml") ? historyFileName + ".xml" : historyFileName;
        this.mPackageMonitor.register(this.mContext, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_ActivityChooserModel$setIntent(Intent intent) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mIntent == intent) {
                return;
            }
            this.mIntent = intent;
            this.mReloadActivities = true;
            this.ensureConsistentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Intent $$robo$$android_widget_ActivityChooserModel$getIntent() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mIntent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_widget_ActivityChooserModel$getActivityCount() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mActivities.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResolveInfo $$robo$$android_widget_ActivityChooserModel$getActivity(int index) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mActivities.get((int)index).resolveInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_widget_ActivityChooserModel$getActivityIndex(ResolveInfo activity) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            List<ActivityResolveInfo> activities = this.mActivities;
            int activityCount = activities.size();
            for (int i = 0; i < activityCount; ++i) {
                ActivityResolveInfo currentActivity = activities.get(i);
                if (currentActivity.resolveInfo != activity) continue;
                return i;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Intent $$robo$$android_widget_ActivityChooserModel$chooseActivity(int index) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Intent choiceIntentCopy;
            boolean handled;
            if (this.mIntent == null) {
                return null;
            }
            this.ensureConsistentState();
            ActivityResolveInfo chosenActivity = this.mActivities.get(index);
            ComponentName chosenName = new ComponentName(chosenActivity.resolveInfo.activityInfo.packageName, chosenActivity.resolveInfo.activityInfo.name);
            Intent choiceIntent = new Intent(this.mIntent);
            choiceIntent.setComponent(chosenName);
            if (this.mActivityChoserModelPolicy != null && (handled = this.mActivityChoserModelPolicy.onChooseActivity(this, choiceIntentCopy = new Intent(choiceIntent)))) {
                return null;
            }
            HistoricalRecord historicalRecord = new HistoricalRecord(chosenName, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), 1.0f);
            this.addHisoricalRecord(historicalRecord);
            return choiceIntent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_ActivityChooserModel$setOnChooseActivityListener(OnChooseActivityListener listener) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mActivityChoserModelPolicy = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResolveInfo $$robo$$android_widget_ActivityChooserModel$getDefaultActivity() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            if (!this.mActivities.isEmpty()) {
                return this.mActivities.get((int)0).resolveInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_ActivityChooserModel$setDefaultActivity(int index) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            ActivityResolveInfo newDefaultActivity = this.mActivities.get(index);
            ActivityResolveInfo oldDefaultActivity = this.mActivities.get(0);
            float weight = oldDefaultActivity != null ? oldDefaultActivity.weight - newDefaultActivity.weight + 5.0f : 1.0f;
            ComponentName defaultName = new ComponentName(newDefaultActivity.resolveInfo.activityInfo.packageName, newDefaultActivity.resolveInfo.activityInfo.name);
            HistoricalRecord historicalRecord = new HistoricalRecord(defaultName, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), weight);
            this.addHisoricalRecord(historicalRecord);
        }
    }

    private final void $$robo$$android_widget_ActivityChooserModel$persistHistoricalDataIfNeeded() {
        if (!this.mReadShareHistoryCalled) {
            throw new IllegalStateException("No preceding call to #readHistoricalData");
        }
        if (!this.mHistoricalRecordsChanged) {
            return;
        }
        this.mHistoricalRecordsChanged = false;
        if (!TextUtils.isEmpty(this.mHistoryFileName)) {
            new PersistHistoryAsyncTask(this, null).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new ArrayList<HistoricalRecord>(this.mHistoricalRecords), this.mHistoryFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_ActivityChooserModel$setActivitySorter(ActivitySorter activitySorter) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mActivitySorter == activitySorter) {
                return;
            }
            this.mActivitySorter = activitySorter;
            if (this.sortActivitiesIfNeeded()) {
                this.notifyChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_ActivityChooserModel$setHistoryMaxSize(int historyMaxSize) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mHistoryMaxSize == historyMaxSize) {
                return;
            }
            this.mHistoryMaxSize = historyMaxSize;
            this.pruneExcessiveHistoricalRecordsIfNeeded();
            if (this.sortActivitiesIfNeeded()) {
                this.notifyChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_widget_ActivityChooserModel$getHistoryMaxSize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mHistoryMaxSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_widget_ActivityChooserModel$getHistorySize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.ensureConsistentState();
            return this.mHistoricalRecords.size();
        }
    }

    private final void $$robo$$android_widget_ActivityChooserModel$finalize() throws Throwable {
        super.finalize();
        this.mPackageMonitor.unregister();
    }

    private final void $$robo$$android_widget_ActivityChooserModel$ensureConsistentState() {
        boolean stateChanged = this.loadActivitiesIfNeeded();
        this.pruneExcessiveHistoricalRecordsIfNeeded();
        if (stateChanged |= this.readHistoricalDataIfNeeded()) {
            this.sortActivitiesIfNeeded();
            this.notifyChanged();
        }
    }

    private final boolean $$robo$$android_widget_ActivityChooserModel$sortActivitiesIfNeeded() {
        if (this.mActivitySorter != null && this.mIntent != null && !this.mActivities.isEmpty() && !this.mHistoricalRecords.isEmpty()) {
            this.mActivitySorter.sort(this.mIntent, this.mActivities, Collections.unmodifiableList(this.mHistoricalRecords));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ActivityChooserModel$loadActivitiesIfNeeded() {
        if (this.mReloadActivities && this.mIntent != null) {
            this.mReloadActivities = false;
            this.mActivities.clear();
            List<ResolveInfo> resolveInfos = this.mContext.getPackageManager().queryIntentActivities(this.mIntent, 0);
            int resolveInfoCount = resolveInfos.size();
            for (int i = 0; i < resolveInfoCount; ++i) {
                ResolveInfo resolveInfo = resolveInfos.get(i);
                ActivityInfo activityInfo = resolveInfo.activityInfo;
                if (ActivityManager.checkComponentPermission(activityInfo.permission, Process.myUid(), activityInfo.applicationInfo.uid, activityInfo.exported) != 0) continue;
                this.mActivities.add(new ActivityResolveInfo(this, resolveInfo));
            }
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ActivityChooserModel$readHistoricalDataIfNeeded() {
        if (this.mCanReadHistoricalData && this.mHistoricalRecordsChanged && !TextUtils.isEmpty(this.mHistoryFileName)) {
            this.mCanReadHistoricalData = false;
            this.mReadShareHistoryCalled = true;
            this.readHistoricalDataImpl();
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ActivityChooserModel$addHisoricalRecord(HistoricalRecord historicalRecord) {
        boolean added = this.mHistoricalRecords.add(historicalRecord);
        if (added) {
            this.mHistoricalRecordsChanged = true;
            this.pruneExcessiveHistoricalRecordsIfNeeded();
            this.persistHistoricalDataIfNeeded();
            this.sortActivitiesIfNeeded();
            this.notifyChanged();
        }
        return added;
    }

    private final void $$robo$$android_widget_ActivityChooserModel$pruneExcessiveHistoricalRecordsIfNeeded() {
        int pruneCount = this.mHistoricalRecords.size() - this.mHistoryMaxSize;
        if (pruneCount <= 0) {
            return;
        }
        this.mHistoricalRecordsChanged = true;
        for (int i = 0; i < pruneCount; ++i) {
            HistoricalRecord historicalRecord = this.mHistoricalRecords.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_ActivityChooserModel$readHistoricalDataImpl() {
        FileInputStream fis = null;
        try {
            fis = this.mContext.openFileInput(this.mHistoryFileName);
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            int type = 0;
            while (type != 1 && type != 2) {
                type = parser.next();
            }
            if (!"historical-records".equals(parser.getName())) {
                throw new XmlPullParserException("Share records file does not start with historical-records tag.");
            }
            List<HistoricalRecord> historicalRecords = this.mHistoricalRecords;
            historicalRecords.clear();
            while ((type = parser.next()) != 1) {
                if (type == 3 || type == 4) continue;
                String nodeName = parser.getName();
                if (!"historical-record".equals(nodeName)) {
                    throw new XmlPullParserException("Share records file not well-formed.");
                }
                String activity = parser.getAttributeValue(null, "activity");
                long time = Long.parseLong(parser.getAttributeValue(null, "time"));
                float weight = Float.parseFloat(parser.getAttributeValue(null, "weight"));
                HistoricalRecord readRecord = new HistoricalRecord(activity, time, weight);
                historicalRecords.add(readRecord);
            }
        }
        catch (XmlPullParserException xppe) {
            Log.e(LOG_TAG, "Error reading historical recrod file: " + this.mHistoryFileName, xppe);
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Error reading historical recrod file: " + this.mHistoryFileName, ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException xppe) {}
            }
        }
    }

    static void __staticInitializer__() {
        LOG_TAG = ActivityChooserModel.class.getSimpleName();
        sRegistryLock = new Object();
        sDataModelRegistry = new HashMap<String, ActivityChooserModel>();
    }

    public static ActivityChooserModel get(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_widget_ActivityChooserModel$get(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    private void __constructor__(Context context, String string2) {
        this.$$robo$$android_widget_ActivityChooserModel$__constructor__(context, string2);
    }

    public ActivityChooserModel(Context context, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActivityChooserModel$__constructor__(android.content.Context java.lang.String ), this, context, string2);
    }

    public void setIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("setIntent", $$robo$$android_widget_ActivityChooserModel$setIntent(android.content.Intent ), this, intent);
    }

    public Intent getIntent() {
        return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$android_widget_ActivityChooserModel$getIntent(), this);
    }

    public int getActivityCount() {
        return (int)InvokeDynamicSupport.bootstrap("getActivityCount", $$robo$$android_widget_ActivityChooserModel$getActivityCount(), this);
    }

    public ResolveInfo getActivity(int n) {
        return InvokeDynamicSupport.bootstrap("getActivity", $$robo$$android_widget_ActivityChooserModel$getActivity(int ), this, n);
    }

    public int getActivityIndex(ResolveInfo resolveInfo) {
        return (int)InvokeDynamicSupport.bootstrap("getActivityIndex", $$robo$$android_widget_ActivityChooserModel$getActivityIndex(android.content.pm.ResolveInfo ), this, resolveInfo);
    }

    public Intent chooseActivity(int n) {
        return InvokeDynamicSupport.bootstrap("chooseActivity", $$robo$$android_widget_ActivityChooserModel$chooseActivity(int ), this, n);
    }

    public void setOnChooseActivityListener(OnChooseActivityListener onChooseActivityListener) {
        InvokeDynamicSupport.bootstrap("setOnChooseActivityListener", $$robo$$android_widget_ActivityChooserModel$setOnChooseActivityListener(android.widget.ActivityChooserModel$OnChooseActivityListener ), this, onChooseActivityListener);
    }

    public ResolveInfo getDefaultActivity() {
        return InvokeDynamicSupport.bootstrap("getDefaultActivity", $$robo$$android_widget_ActivityChooserModel$getDefaultActivity(), this);
    }

    public void setDefaultActivity(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultActivity", $$robo$$android_widget_ActivityChooserModel$setDefaultActivity(int ), this, n);
    }

    private void persistHistoricalDataIfNeeded() {
        InvokeDynamicSupport.bootstrap("persistHistoricalDataIfNeeded", $$robo$$android_widget_ActivityChooserModel$persistHistoricalDataIfNeeded(), this);
    }

    public void setActivitySorter(ActivitySorter activitySorter) {
        InvokeDynamicSupport.bootstrap("setActivitySorter", $$robo$$android_widget_ActivityChooserModel$setActivitySorter(android.widget.ActivityChooserModel$ActivitySorter ), this, activitySorter);
    }

    public void setHistoryMaxSize(int n) {
        InvokeDynamicSupport.bootstrap("setHistoryMaxSize", $$robo$$android_widget_ActivityChooserModel$setHistoryMaxSize(int ), this, n);
    }

    public int getHistoryMaxSize() {
        return (int)InvokeDynamicSupport.bootstrap("getHistoryMaxSize", $$robo$$android_widget_ActivityChooserModel$getHistoryMaxSize(), this);
    }

    public int getHistorySize() {
        return (int)InvokeDynamicSupport.bootstrap("getHistorySize", $$robo$$android_widget_ActivityChooserModel$getHistorySize(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_widget_ActivityChooserModel$finalize(), this);
    }

    private void ensureConsistentState() {
        InvokeDynamicSupport.bootstrap("ensureConsistentState", $$robo$$android_widget_ActivityChooserModel$ensureConsistentState(), this);
    }

    private boolean sortActivitiesIfNeeded() {
        return (boolean)InvokeDynamicSupport.bootstrap("sortActivitiesIfNeeded", $$robo$$android_widget_ActivityChooserModel$sortActivitiesIfNeeded(), this);
    }

    private boolean loadActivitiesIfNeeded() {
        return (boolean)InvokeDynamicSupport.bootstrap("loadActivitiesIfNeeded", $$robo$$android_widget_ActivityChooserModel$loadActivitiesIfNeeded(), this);
    }

    private boolean readHistoricalDataIfNeeded() {
        return (boolean)InvokeDynamicSupport.bootstrap("readHistoricalDataIfNeeded", $$robo$$android_widget_ActivityChooserModel$readHistoricalDataIfNeeded(), this);
    }

    private boolean addHisoricalRecord(HistoricalRecord historicalRecord) {
        return (boolean)InvokeDynamicSupport.bootstrap("addHisoricalRecord", $$robo$$android_widget_ActivityChooserModel$addHisoricalRecord(android.widget.ActivityChooserModel$HistoricalRecord ), this, historicalRecord);
    }

    private void pruneExcessiveHistoricalRecordsIfNeeded() {
        InvokeDynamicSupport.bootstrap("pruneExcessiveHistoricalRecordsIfNeeded", $$robo$$android_widget_ActivityChooserModel$pruneExcessiveHistoricalRecordsIfNeeded(), this);
    }

    private void readHistoricalDataImpl() {
        InvokeDynamicSupport.bootstrap("readHistoricalDataImpl", $$robo$$android_widget_ActivityChooserModel$readHistoricalDataImpl(), this);
    }

    static {
        RobolectricInternals.classInitializing(ActivityChooserModel.class);
    }

    public /* synthetic */ ActivityChooserModel() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityChooserModel)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class DataModelPackageMonitor
    extends PackageMonitor
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ActivityChooserModel this$0;

        private void $$robo$$android_widget_ActivityChooserModel_DataModelPackageMonitor$__constructor__(ActivityChooserModel activityChooserModel) {
        }

        private final void $$robo$$android_widget_ActivityChooserModel_DataModelPackageMonitor$onSomePackagesChanged() {
            this.this$0.mReloadActivities = true;
        }

        private /* synthetic */ void $$robo$$android_widget_ActivityChooserModel_DataModelPackageMonitor$__constructor__(ActivityChooserModel x0, 1 x1) {
        }

        private void __constructor__(ActivityChooserModel activityChooserModel) {
            this.$$robo$$android_widget_ActivityChooserModel_DataModelPackageMonitor$__constructor__(activityChooserModel);
        }

        public DataModelPackageMonitor(ActivityChooserModel activityChooserModel) {
            this.this$0 = activityChooserModel;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActivityChooserModel_DataModelPackageMonitor$__constructor__(android.widget.ActivityChooserModel ), this, activityChooserModel);
        }

        @Override
        public void onSomePackagesChanged() {
            InvokeDynamicSupport.bootstrap("onSomePackagesChanged", $$robo$$android_widget_ActivityChooserModel_DataModelPackageMonitor$onSomePackagesChanged(), this);
        }

        private /* synthetic */ void __constructor__(ActivityChooserModel activityChooserModel, 1 var2_2) {
            this.$$robo$$android_widget_ActivityChooserModel_DataModelPackageMonitor$__constructor__(activityChooserModel, var2_2);
        }

        public /* synthetic */ DataModelPackageMonitor(ActivityChooserModel activityChooserModel, 1 var2_2) {
            this(activityChooserModel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActivityChooserModel_DataModelPackageMonitor$__constructor__(android.widget.ActivityChooserModel android.widget.ActivityChooserModel$1 ), this, activityChooserModel, var2_2);
        }

        public /* synthetic */ DataModelPackageMonitor() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataModelPackageMonitor)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class PersistHistoryAsyncTask
    extends AsyncTask<Object, Void, Void> {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ActivityChooserModel this$0;

        private void $$robo$$android_widget_ActivityChooserModel_PersistHistoryAsyncTask$__constructor__(ActivityChooserModel activityChooserModel) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Void $$robo$$android_widget_ActivityChooserModel_PersistHistoryAsyncTask$doInBackground(Object ... args) {
            List historicalRecords = (List)args[0];
            String hostoryFileName = (String)args[1];
            FileOutputStream fos = null;
            try {
                fos = this.this$0.mContext.openFileOutput(hostoryFileName, 0);
            }
            catch (FileNotFoundException fnfe) {
                Log.e(LOG_TAG, "Error writing historical recrod file: " + hostoryFileName, fnfe);
                return null;
            }
            XmlSerializer serializer = Xml.newSerializer();
            try {
                serializer.setOutput(fos, null);
                serializer.startDocument(StandardCharsets.UTF_8.name(), true);
                serializer.startTag(null, "historical-records");
                int recordCount = historicalRecords.size();
                for (int i = 0; i < recordCount; ++i) {
                    HistoricalRecord record = (HistoricalRecord)historicalRecords.remove(0);
                    serializer.startTag(null, "historical-record");
                    serializer.attribute(null, "activity", record.activity.flattenToString());
                    serializer.attribute(null, "time", String.valueOf(record.time));
                    serializer.attribute(null, "weight", String.valueOf(record.weight));
                    serializer.endTag(null, "historical-record");
                }
                serializer.endTag(null, "historical-records");
                serializer.endDocument();
            }
            catch (IllegalArgumentException iae) {
                Log.e(LOG_TAG, "Error writing historical recrod file: " + this.this$0.mHistoryFileName, iae);
            }
            catch (IllegalStateException ise) {
                Log.e(LOG_TAG, "Error writing historical recrod file: " + this.this$0.mHistoryFileName, ise);
            }
            catch (IOException ioe) {
                Log.e(LOG_TAG, "Error writing historical recrod file: " + this.this$0.mHistoryFileName, ioe);
            }
            finally {
                this.this$0.mCanReadHistoricalData = true;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iae) {}
                }
            }
            return null;
        }

        private /* synthetic */ void $$robo$$android_widget_ActivityChooserModel_PersistHistoryAsyncTask$__constructor__(ActivityChooserModel x0, 1 x1) {
        }

        private void __constructor__(ActivityChooserModel activityChooserModel) {
            this.$$robo$$android_widget_ActivityChooserModel_PersistHistoryAsyncTask$__constructor__(activityChooserModel);
        }

        public PersistHistoryAsyncTask(ActivityChooserModel activityChooserModel) {
            this.this$0 = activityChooserModel;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActivityChooserModel_PersistHistoryAsyncTask$__constructor__(android.widget.ActivityChooserModel ), this, activityChooserModel);
        }

        @Override
        public Void doInBackground(Object ... objectArray) {
            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$android_widget_ActivityChooserModel_PersistHistoryAsyncTask$doInBackground(java.lang.Object[] ), this, objectArray);
        }

        private /* synthetic */ void __constructor__(ActivityChooserModel activityChooserModel, 1 var2_2) {
            this.$$robo$$android_widget_ActivityChooserModel_PersistHistoryAsyncTask$__constructor__(activityChooserModel, var2_2);
        }

        public /* synthetic */ PersistHistoryAsyncTask(ActivityChooserModel activityChooserModel, 1 var2_2) {
            this(activityChooserModel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActivityChooserModel_PersistHistoryAsyncTask$__constructor__(android.widget.ActivityChooserModel android.widget.ActivityChooserModel$1 ), this, activityChooserModel, var2_2);
        }

        public /* synthetic */ PersistHistoryAsyncTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PersistHistoryAsyncTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class DefaultSorter
    implements ActivitySorter,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static float WEIGHT_DECAY_COEFFICIENT = 0.95f;
        private Map<ComponentName, ActivityResolveInfo> mPackageNameToActivityMap;
        /* synthetic */ ActivityChooserModel this$0;

        private void $$robo$$android_widget_ActivityChooserModel_DefaultSorter$__constructor__(ActivityChooserModel activityChooserModel) {
            this.mPackageNameToActivityMap = new HashMap<ComponentName, ActivityResolveInfo>();
        }

        private final void $$robo$$android_widget_ActivityChooserModel_DefaultSorter$sort(Intent intent, List<ActivityResolveInfo> activities, List<HistoricalRecord> historicalRecords) {
            Map<ComponentName, ActivityResolveInfo> componentNameToActivityMap = this.mPackageNameToActivityMap;
            componentNameToActivityMap.clear();
            int activityCount = activities.size();
            for (int i = 0; i < activityCount; ++i) {
                ActivityResolveInfo activity = activities.get(i);
                activity.weight = 0.0f;
                ComponentName componentName = new ComponentName(activity.resolveInfo.activityInfo.packageName, activity.resolveInfo.activityInfo.name);
                componentNameToActivityMap.put(componentName, activity);
            }
            int lastShareIndex = historicalRecords.size() - 1;
            float nextRecordWeight = 1.0f;
            for (int i = lastShareIndex; i >= 0; --i) {
                HistoricalRecord historicalRecord = historicalRecords.get(i);
                ComponentName componentName = historicalRecord.activity;
                ActivityResolveInfo activity = componentNameToActivityMap.get(componentName);
                if (activity == null) continue;
                activity.weight += historicalRecord.weight * nextRecordWeight;
                nextRecordWeight *= 0.95f;
            }
            Collections.sort(activities);
        }

        private /* synthetic */ void $$robo$$android_widget_ActivityChooserModel_DefaultSorter$__constructor__(ActivityChooserModel x0, 1 x1) {
        }

        private void __constructor__(ActivityChooserModel activityChooserModel) {
            this.$$robo$$android_widget_ActivityChooserModel_DefaultSorter$__constructor__(activityChooserModel);
        }

        public DefaultSorter(ActivityChooserModel activityChooserModel) {
            this.this$0 = activityChooserModel;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActivityChooserModel_DefaultSorter$__constructor__(android.widget.ActivityChooserModel ), this, activityChooserModel);
        }

        @Override
        public void sort(Intent intent, List<ActivityResolveInfo> list, List<HistoricalRecord> list2) {
            InvokeDynamicSupport.bootstrap("sort", $$robo$$android_widget_ActivityChooserModel_DefaultSorter$sort(android.content.Intent java.util.List<android.widget.ActivityChooserModel$ActivityResolveInfo> java.util.List<android.widget.ActivityChooserModel$HistoricalRecord> ), this, intent, list, list2);
        }

        private /* synthetic */ void __constructor__(ActivityChooserModel activityChooserModel, 1 var2_2) {
            this.$$robo$$android_widget_ActivityChooserModel_DefaultSorter$__constructor__(activityChooserModel, var2_2);
        }

        public /* synthetic */ DefaultSorter(ActivityChooserModel activityChooserModel, 1 var2_2) {
            this(activityChooserModel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActivityChooserModel_DefaultSorter$__constructor__(android.widget.ActivityChooserModel android.widget.ActivityChooserModel$1 ), this, activityChooserModel, var2_2);
        }

        public /* synthetic */ DefaultSorter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultSorter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class ActivityResolveInfo
    implements Comparable<ActivityResolveInfo> {
        public /* synthetic */ Object __robo_data__;
        public ResolveInfo resolveInfo;
        public float weight;
        /* synthetic */ ActivityChooserModel this$0;

        private void $$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$__constructor__(ActivityChooserModel this$0, ResolveInfo resolveInfo) {
            this.resolveInfo = resolveInfo;
        }

        private final int $$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$hashCode() {
            return 31 + Float.floatToIntBits(this.weight);
        }

        private final boolean $$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ActivityResolveInfo other = (ActivityResolveInfo)obj;
            return Float.floatToIntBits(this.weight) == Float.floatToIntBits(other.weight);
        }

        private final int $$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$compareTo(ActivityResolveInfo another) {
            return Float.floatToIntBits(another.weight) - Float.floatToIntBits(this.weight);
        }

        private final String $$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append("resolveInfo:").append(this.resolveInfo.toString());
            builder.append("; weight:").append(new BigDecimal(this.weight));
            builder.append("]");
            return builder.toString();
        }

        private void __constructor__(ActivityChooserModel activityChooserModel, ResolveInfo resolveInfo) {
            this.$$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$__constructor__(activityChooserModel, resolveInfo);
        }

        public ActivityResolveInfo(ActivityChooserModel activityChooserModel, ResolveInfo resolveInfo) {
            this.this$0 = activityChooserModel;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$__constructor__(android.widget.ActivityChooserModel android.content.pm.ResolveInfo ), this, activityChooserModel, resolveInfo);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$equals(java.lang.Object ), this, object);
        }

        @Override
        public int compareTo(ActivityResolveInfo activityResolveInfo) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$compareTo(android.widget.ActivityChooserModel$ActivityResolveInfo ), this, activityResolveInfo);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_ActivityChooserModel_ActivityResolveInfo$toString(), this);
        }

        public /* synthetic */ ActivityResolveInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivityResolveInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class HistoricalRecord
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ComponentName activity;
        public long time;
        public float weight;

        private void $$robo$$android_widget_ActivityChooserModel_HistoricalRecord$__constructor__(String activityName, long time, float weight) {
        }

        private void $$robo$$android_widget_ActivityChooserModel_HistoricalRecord$__constructor__(ComponentName activityName, long time, float weight) {
            this.activity = activityName;
            this.time = time;
            this.weight = weight;
        }

        private final int $$robo$$android_widget_ActivityChooserModel_HistoricalRecord$hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.activity == null ? 0 : this.activity.hashCode());
            result = 31 * result + (int)(this.time ^ this.time >>> 32);
            result = 31 * result + Float.floatToIntBits(this.weight);
            return result;
        }

        private final boolean $$robo$$android_widget_ActivityChooserModel_HistoricalRecord$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalRecord other = (HistoricalRecord)obj;
            if (this.activity == null ? other.activity != null : !this.activity.equals(other.activity)) {
                return false;
            }
            if (this.time != other.time) {
                return false;
            }
            return Float.floatToIntBits(this.weight) == Float.floatToIntBits(other.weight);
        }

        private final String $$robo$$android_widget_ActivityChooserModel_HistoricalRecord$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append("; activity:").append(this.activity);
            builder.append("; time:").append(this.time);
            builder.append("; weight:").append(new BigDecimal(this.weight));
            builder.append("]");
            return builder.toString();
        }

        private void __constructor__(String string2, long l, float f) {
            this.$$robo$$android_widget_ActivityChooserModel_HistoricalRecord$__constructor__(string2, l, f);
        }

        public HistoricalRecord(String string2, long l, float f) {
            this(ComponentName.unflattenFromString(string2), l, f);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActivityChooserModel_HistoricalRecord$__constructor__(java.lang.String long float ), this, string2, l, f);
        }

        private void __constructor__(ComponentName componentName, long l, float f) {
            this.$$robo$$android_widget_ActivityChooserModel_HistoricalRecord$__constructor__(componentName, l, f);
        }

        public HistoricalRecord(ComponentName componentName, long l, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ActivityChooserModel_HistoricalRecord$__constructor__(android.content.ComponentName long float ), this, componentName, l, f);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_widget_ActivityChooserModel_HistoricalRecord$hashCode(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_widget_ActivityChooserModel_HistoricalRecord$equals(java.lang.Object ), this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_ActivityChooserModel_HistoricalRecord$toString(), this);
        }

        public /* synthetic */ HistoricalRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HistoricalRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnChooseActivityListener
    extends InstrumentedInterface {
        public boolean onChooseActivity(ActivityChooserModel var1, Intent var2);
    }

    public static interface ActivitySorter
    extends InstrumentedInterface {
        public void sort(Intent var1, List<ActivityResolveInfo> var2, List<HistoricalRecord> var3);
    }

    public static interface ActivityChooserModelClient
    extends InstrumentedInterface {
        public void setActivityChooserModel(ActivityChooserModel var1);
    }
}

