/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.textclassifier.LangId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierImpl;
import android.view.textclassifier.TextLanguage;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextClassificationManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "TextClassificationManager";
    private Object mTextClassifierLock;
    private Object mLangIdLock;
    private Context mContext;
    private ParcelFileDescriptor mLangIdFd;
    private TextClassifier mTextClassifier;
    private LangId mLangId;

    private void $$robo$$android_view_textclassifier_TextClassificationManager$__constructor__(Context context) {
        this.mTextClassifierLock = new Object();
        this.mLangIdLock = new Object();
        this.mContext = Preconditions.checkNotNull(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TextClassifier $$robo$$android_view_textclassifier_TextClassificationManager$getTextClassifier() {
        Object object = this.mTextClassifierLock;
        synchronized (object) {
            if (this.mTextClassifier == null) {
                this.mTextClassifier = new TextClassifierImpl(this.mContext);
            }
            return this.mTextClassifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_textclassifier_TextClassificationManager$setTextClassifier(TextClassifier textClassifier) {
        Object object = this.mTextClassifierLock;
        synchronized (object) {
            this.mTextClassifier = textClassifier;
        }
    }

    private final List<TextLanguage> $$robo$$android_view_textclassifier_TextClassificationManager$detectLanguages(CharSequence text) {
        Preconditions.checkArgument(text != null);
        try {
            if (text.length() > 0) {
                LangId.ClassificationResult[] results = this.getLanguageDetector().findLanguages(text.toString());
                TextLanguage.Builder tlBuilder = new TextLanguage.Builder(0, text.length());
                int size = results.length;
                for (int i = 0; i < size; ++i) {
                    tlBuilder.setLanguage(new Locale.Builder().setLanguageTag(results[i].mLanguage).build(), results[i].mScore);
                }
                return Collections.unmodifiableList(Arrays.asList(tlBuilder.build()));
            }
        }
        catch (Throwable t) {
            Log.e("TextClassificationManager", "Error detecting languages for text. Returning empty result.", t);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LangId $$robo$$android_view_textclassifier_TextClassificationManager$getLanguageDetector() throws FileNotFoundException {
        Object object = this.mLangIdLock;
        synchronized (object) {
            if (this.mLangId == null) {
                this.mLangIdFd = ParcelFileDescriptor.open(new File("/etc/textclassifier/textclassifier.langid.model"), 0x10000000);
                this.mLangId = new LangId(this.mLangIdFd.getFd());
            }
            return this.mLangId;
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_textclassifier_TextClassificationManager$__constructor__(context);
    }

    public TextClassificationManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassificationManager$__constructor__(android.content.Context ), this, context);
    }

    public TextClassifier getTextClassifier() {
        return InvokeDynamicSupport.bootstrap("getTextClassifier", $$robo$$android_view_textclassifier_TextClassificationManager$getTextClassifier(), this);
    }

    public void setTextClassifier(TextClassifier textClassifier) {
        InvokeDynamicSupport.bootstrap("setTextClassifier", $$robo$$android_view_textclassifier_TextClassificationManager$setTextClassifier(android.view.textclassifier.TextClassifier ), this, textClassifier);
    }

    public List<TextLanguage> detectLanguages(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("detectLanguages", $$robo$$android_view_textclassifier_TextClassificationManager$detectLanguages(java.lang.CharSequence ), this, charSequence);
    }

    private LangId getLanguageDetector() throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("getLanguageDetector", $$robo$$android_view_textclassifier_TextClassificationManager$getLanguageDetector(), this);
    }

    public /* synthetic */ TextClassificationManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassificationManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

