/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BaseInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.GridLayoutAnimationController;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.PathInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int TOGETHER = 0;
    private static int SEQUENTIALLY = 1;
    private static ThreadLocal<AnimationState> sAnimationState;

    private void $$robo$$android_view_animation_AnimationUtils$__constructor__() {
    }

    private static final void $$robo$$android_view_animation_AnimationUtils$lockAnimationClock(long vsyncMillis) {
        AnimationState state = sAnimationState.get();
        state.animationClockLocked = true;
        state.currentVsyncTimeMillis = vsyncMillis;
    }

    private static final void $$robo$$android_view_animation_AnimationUtils$unlockAnimationClock() {
        AnimationUtils.sAnimationState.get().animationClockLocked = false;
    }

    private static final long $$robo$$android_view_animation_AnimationUtils$currentAnimationTimeMillis() {
        AnimationState state = sAnimationState.get();
        if (state.animationClockLocked) {
            return Math.max(state.currentVsyncTimeMillis, state.lastReportedTimeMillis);
        }
        state.lastReportedTimeMillis = SystemClock.uptimeMillis();
        return state.lastReportedTimeMillis;
    }

    private static final Animation $$robo$$android_view_animation_AnimationUtils$loadAnimation(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            Animation animation = AnimationUtils.createAnimationFromXml(context, parser);
            return animation;
        }
    }

    private static final Animation $$robo$$android_view_animation_AnimationUtils$createAnimationFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return AnimationUtils.createAnimationFromXml(c, parser, null, Xml.asAttributeSet(parser));
    }

    private static final Animation $$robo$$android_view_animation_AnimationUtils$createAnimationFromXml(Context c, XmlPullParser parser, AnimationSet parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        Animation anim2 = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("set")) {
                anim2 = new AnimationSet(c, attrs);
                AnimationUtils.createAnimationFromXml(c, parser, anim2, attrs);
            } else if (name.equals("alpha")) {
                anim2 = new AlphaAnimation(c, attrs);
            } else if (name.equals("scale")) {
                anim2 = new ScaleAnimation(c, attrs);
            } else if (name.equals("rotate")) {
                anim2 = new RotateAnimation(c, attrs);
            } else if (name.equals("translate")) {
                anim2 = new TranslateAnimation(c, attrs);
            } else {
                throw new RuntimeException("Unknown animation name: " + parser.getName());
            }
            if (parent == null) continue;
            parent.addAnimation(anim2);
        }
        return anim2;
    }

    private static final LayoutAnimationController $$robo$$android_view_animation_AnimationUtils$loadLayoutAnimation(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            LayoutAnimationController layoutAnimationController = AnimationUtils.createLayoutAnimationFromXml(context, parser);
            return layoutAnimationController;
        }
    }

    private static final LayoutAnimationController $$robo$$android_view_animation_AnimationUtils$createLayoutAnimationFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return AnimationUtils.createLayoutAnimationFromXml(c, parser, Xml.asAttributeSet(parser));
    }

    private static final LayoutAnimationController $$robo$$android_view_animation_AnimationUtils$createLayoutAnimationFromXml(Context c, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        LayoutAnimationController controller = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if ("layoutAnimation".equals(name)) {
                controller = new LayoutAnimationController(c, attrs);
                continue;
            }
            if ("gridLayoutAnimation".equals(name)) {
                controller = new GridLayoutAnimationController(c, attrs);
                continue;
            }
            throw new RuntimeException("Unknown layout animation name: " + name);
        }
        return controller;
    }

    private static final Animation $$robo$$android_view_animation_AnimationUtils$makeInAnimation(Context c, boolean fromLeft) {
        Animation a = fromLeft ? AnimationUtils.loadAnimation(c, 17432578) : AnimationUtils.loadAnimation(c, 17432717);
        a.setInterpolator(new DecelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    private static final Animation $$robo$$android_view_animation_AnimationUtils$makeOutAnimation(Context c, boolean toRight) {
        Animation a = toRight ? AnimationUtils.loadAnimation(c, 17432579) : AnimationUtils.loadAnimation(c, 17432720);
        a.setInterpolator(new AccelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    private static final Animation $$robo$$android_view_animation_AnimationUtils$makeInChildBottomAnimation(Context c) {
        Animation a = AnimationUtils.loadAnimation(c, 17432714);
        a.setInterpolator(new AccelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    private static final Interpolator $$robo$$android_view_animation_AnimationUtils$loadInterpolator(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            Interpolator interpolator2 = AnimationUtils.createInterpolatorFromXml(context.getResources(), context.getTheme(), parser);
            return interpolator2;
        }
    }

    private static final Interpolator $$robo$$android_view_animation_AnimationUtils$loadInterpolator(Resources res, Resources.Theme theme, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = res.getAnimation(id2);
            Interpolator interpolator2 = AnimationUtils.createInterpolatorFromXml(res, theme, parser);
            return interpolator2;
        }
    }

    private static final Interpolator $$robo$$android_view_animation_AnimationUtils$createInterpolatorFromXml(Resources res, Resources.Theme theme, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        BaseInterpolator interpolator2 = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            AttributeSet attrs = Xml.asAttributeSet(parser);
            String name = parser.getName();
            if (name.equals("linearInterpolator")) {
                interpolator2 = new LinearInterpolator();
                continue;
            }
            if (name.equals("accelerateInterpolator")) {
                interpolator2 = new AccelerateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("decelerateInterpolator")) {
                interpolator2 = new DecelerateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("accelerateDecelerateInterpolator")) {
                interpolator2 = new AccelerateDecelerateInterpolator();
                continue;
            }
            if (name.equals("cycleInterpolator")) {
                interpolator2 = new CycleInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("anticipateInterpolator")) {
                interpolator2 = new AnticipateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("overshootInterpolator")) {
                interpolator2 = new OvershootInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("anticipateOvershootInterpolator")) {
                interpolator2 = new AnticipateOvershootInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("bounceInterpolator")) {
                interpolator2 = new BounceInterpolator();
                continue;
            }
            if (name.equals("pathInterpolator")) {
                interpolator2 = new PathInterpolator(res, theme, attrs);
                continue;
            }
            throw new RuntimeException("Unknown interpolator name: " + parser.getName());
        }
        return interpolator2;
    }

    static void __staticInitializer__() {
        sAnimationState = new ThreadLocal<AnimationState>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_animation_AnimationUtils_1$__constructor__() {
            }

            private final AnimationState $$robo$$android_view_animation_AnimationUtils_1$initialValue() {
                return new AnimationState(null);
            }

            private void __constructor__() {
                this.$$robo$$android_view_animation_AnimationUtils_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_AnimationUtils_1$__constructor__(), this);
            }

            @Override
            protected AnimationState initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_view_animation_AnimationUtils_1$initialValue(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_view_animation_AnimationUtils$__constructor__();
    }

    public AnimationUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_AnimationUtils$__constructor__(), this);
    }

    public static void lockAnimationClock(long l) {
        InvokeDynamicSupport.bootstrapStatic("lockAnimationClock", $$robo$$android_view_animation_AnimationUtils$lockAnimationClock(long ), (long)l);
    }

    public static void unlockAnimationClock() {
        InvokeDynamicSupport.bootstrapStatic("unlockAnimationClock", $$robo$$android_view_animation_AnimationUtils$unlockAnimationClock());
    }

    public static long currentAnimationTimeMillis() {
        return (long)InvokeDynamicSupport.bootstrapStatic("currentAnimationTimeMillis", $$robo$$android_view_animation_AnimationUtils$currentAnimationTimeMillis());
    }

    public static Animation loadAnimation(Context context, int n) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("loadAnimation", $$robo$$android_view_animation_AnimationUtils$loadAnimation(android.content.Context int ), (Context)context, (int)n);
    }

    private static Animation createAnimationFromXml(Context context, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createAnimationFromXml", $$robo$$android_view_animation_AnimationUtils$createAnimationFromXml(android.content.Context org.xmlpull.v1.XmlPullParser ), (Context)context, (XmlPullParser)xmlPullParser);
    }

    private static Animation createAnimationFromXml(Context context, XmlPullParser xmlPullParser, AnimationSet animationSet, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createAnimationFromXml", $$robo$$android_view_animation_AnimationUtils$createAnimationFromXml(android.content.Context org.xmlpull.v1.XmlPullParser android.view.animation.AnimationSet android.util.AttributeSet ), (Context)context, (XmlPullParser)xmlPullParser, (AnimationSet)animationSet, (AttributeSet)attributeSet);
    }

    public static LayoutAnimationController loadLayoutAnimation(Context context, int n) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("loadLayoutAnimation", $$robo$$android_view_animation_AnimationUtils$loadLayoutAnimation(android.content.Context int ), (Context)context, (int)n);
    }

    private static LayoutAnimationController createLayoutAnimationFromXml(Context context, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createLayoutAnimationFromXml", $$robo$$android_view_animation_AnimationUtils$createLayoutAnimationFromXml(android.content.Context org.xmlpull.v1.XmlPullParser ), (Context)context, (XmlPullParser)xmlPullParser);
    }

    private static LayoutAnimationController createLayoutAnimationFromXml(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createLayoutAnimationFromXml", $$robo$$android_view_animation_AnimationUtils$createLayoutAnimationFromXml(android.content.Context org.xmlpull.v1.XmlPullParser android.util.AttributeSet ), (Context)context, (XmlPullParser)xmlPullParser, (AttributeSet)attributeSet);
    }

    public static Animation makeInAnimation(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("makeInAnimation", $$robo$$android_view_animation_AnimationUtils$makeInAnimation(android.content.Context boolean ), (Context)context, (boolean)bl);
    }

    public static Animation makeOutAnimation(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("makeOutAnimation", $$robo$$android_view_animation_AnimationUtils$makeOutAnimation(android.content.Context boolean ), (Context)context, (boolean)bl);
    }

    public static Animation makeInChildBottomAnimation(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("makeInChildBottomAnimation", $$robo$$android_view_animation_AnimationUtils$makeInChildBottomAnimation(android.content.Context ), (Context)context);
    }

    public static Interpolator loadInterpolator(Context context, int n) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("loadInterpolator", $$robo$$android_view_animation_AnimationUtils$loadInterpolator(android.content.Context int ), (Context)context, (int)n);
    }

    public static Interpolator loadInterpolator(Resources resources, Resources.Theme theme, int n) throws Resources.NotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("loadInterpolator", $$robo$$android_view_animation_AnimationUtils$loadInterpolator(android.content.res.Resources android.content.res.Resources$Theme int ), (Resources)resources, (Resources.Theme)theme, (int)n);
    }

    private static Interpolator createInterpolatorFromXml(Resources resources, Resources.Theme theme, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("createInterpolatorFromXml", $$robo$$android_view_animation_AnimationUtils$createInterpolatorFromXml(android.content.res.Resources android.content.res.Resources$Theme org.xmlpull.v1.XmlPullParser ), (Resources)resources, (Resources.Theme)theme, (XmlPullParser)xmlPullParser);
    }

    static {
        RobolectricInternals.classInitializing(AnimationUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class AnimationState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        boolean animationClockLocked;
        long currentVsyncTimeMillis;
        long lastReportedTimeMillis;

        private void $$robo$$android_view_animation_AnimationUtils_AnimationState$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_view_animation_AnimationUtils_AnimationState$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_animation_AnimationUtils_AnimationState$__constructor__();
        }

        public AnimationState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_AnimationUtils_AnimationState$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_view_animation_AnimationUtils_AnimationState$__constructor__(var1_1);
        }

        public /* synthetic */ AnimationState(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_animation_AnimationUtils_AnimationState$__constructor__(android.view.animation.AnimationUtils$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

