/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.IntDef;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.KeyboardShortcutGroup;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface WindowManager
extends ViewManager,
InstrumentedInterface {
    public static final int DOCKED_INVALID = -1;
    public static final int DOCKED_LEFT = 1;
    public static final int DOCKED_TOP = 2;
    public static final int DOCKED_RIGHT = 3;
    public static final int DOCKED_BOTTOM = 4;
    public static final String INPUT_CONSUMER_PIP = "pip_input_consumer";
    public static final String INPUT_CONSUMER_NAVIGATION = "nav_input_consumer";
    public static final String INPUT_CONSUMER_WALLPAPER = "wallpaper_input_consumer";
    public static final int TAKE_SCREENSHOT_FULLSCREEN = 1;
    public static final int TAKE_SCREENSHOT_SELECTED_REGION = 2;
    public static final String PARCEL_KEY_SHORTCUTS_ARRAY = "shortcuts_array";

    public Display getDefaultDisplay();

    public void removeViewImmediate(View var1);

    public void requestAppKeyboardShortcuts(KeyboardShortcutsReceiver var1, int var2);

    public static class LayoutParams
    extends ViewGroup.LayoutParams
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        @ViewDebug.ExportedProperty
        public int x;
        @ViewDebug.ExportedProperty
        public int y;
        @ViewDebug.ExportedProperty
        public float horizontalWeight;
        @ViewDebug.ExportedProperty
        public float verticalWeight;
        @ViewDebug.ExportedProperty(mapping={@ViewDebug.IntToString(from=1, to="TYPE_BASE_APPLICATION"), @ViewDebug.IntToString(from=2, to="TYPE_APPLICATION"), @ViewDebug.IntToString(from=3, to="TYPE_APPLICATION_STARTING"), @ViewDebug.IntToString(from=4, to="TYPE_DRAWN_APPLICATION"), @ViewDebug.IntToString(from=1000, to="TYPE_APPLICATION_PANEL"), @ViewDebug.IntToString(from=1001, to="TYPE_APPLICATION_MEDIA"), @ViewDebug.IntToString(from=1002, to="TYPE_APPLICATION_SUB_PANEL"), @ViewDebug.IntToString(from=1005, to="TYPE_APPLICATION_ABOVE_SUB_PANEL"), @ViewDebug.IntToString(from=1003, to="TYPE_APPLICATION_ATTACHED_DIALOG"), @ViewDebug.IntToString(from=1004, to="TYPE_APPLICATION_MEDIA_OVERLAY"), @ViewDebug.IntToString(from=2000, to="TYPE_STATUS_BAR"), @ViewDebug.IntToString(from=2001, to="TYPE_SEARCH_BAR"), @ViewDebug.IntToString(from=2002, to="TYPE_PHONE"), @ViewDebug.IntToString(from=2003, to="TYPE_SYSTEM_ALERT"), @ViewDebug.IntToString(from=2005, to="TYPE_TOAST"), @ViewDebug.IntToString(from=2006, to="TYPE_SYSTEM_OVERLAY"), @ViewDebug.IntToString(from=2007, to="TYPE_PRIORITY_PHONE"), @ViewDebug.IntToString(from=2008, to="TYPE_SYSTEM_DIALOG"), @ViewDebug.IntToString(from=2009, to="TYPE_KEYGUARD_DIALOG"), @ViewDebug.IntToString(from=2010, to="TYPE_SYSTEM_ERROR"), @ViewDebug.IntToString(from=2011, to="TYPE_INPUT_METHOD"), @ViewDebug.IntToString(from=2012, to="TYPE_INPUT_METHOD_DIALOG"), @ViewDebug.IntToString(from=2013, to="TYPE_WALLPAPER"), @ViewDebug.IntToString(from=2014, to="TYPE_STATUS_BAR_PANEL"), @ViewDebug.IntToString(from=2015, to="TYPE_SECURE_SYSTEM_OVERLAY"), @ViewDebug.IntToString(from=2016, to="TYPE_DRAG"), @ViewDebug.IntToString(from=2017, to="TYPE_STATUS_BAR_SUB_PANEL"), @ViewDebug.IntToString(from=2018, to="TYPE_POINTER"), @ViewDebug.IntToString(from=2019, to="TYPE_NAVIGATION_BAR"), @ViewDebug.IntToString(from=2020, to="TYPE_VOLUME_OVERLAY"), @ViewDebug.IntToString(from=2021, to="TYPE_BOOT_PROGRESS"), @ViewDebug.IntToString(from=2022, to="TYPE_INPUT_CONSUMER"), @ViewDebug.IntToString(from=2023, to="TYPE_DREAM"), @ViewDebug.IntToString(from=2024, to="TYPE_NAVIGATION_BAR_PANEL"), @ViewDebug.IntToString(from=2026, to="TYPE_DISPLAY_OVERLAY"), @ViewDebug.IntToString(from=2027, to="TYPE_MAGNIFICATION_OVERLAY"), @ViewDebug.IntToString(from=2037, to="TYPE_PRESENTATION"), @ViewDebug.IntToString(from=2030, to="TYPE_PRIVATE_PRESENTATION"), @ViewDebug.IntToString(from=2031, to="TYPE_VOICE_INTERACTION"), @ViewDebug.IntToString(from=2033, to="TYPE_VOICE_INTERACTION_STARTING"), @ViewDebug.IntToString(from=2034, to="TYPE_DOCK_DIVIDER"), @ViewDebug.IntToString(from=2035, to="TYPE_QS_DIALOG"), @ViewDebug.IntToString(from=2036, to="TYPE_SCREENSHOT"), @ViewDebug.IntToString(from=2038, to="TYPE_APPLICATION_OVERLAY")})
        public int type;
        public static int FIRST_APPLICATION_WINDOW = 1;
        public static int TYPE_BASE_APPLICATION = 1;
        public static int TYPE_APPLICATION = 2;
        public static int TYPE_APPLICATION_STARTING = 3;
        public static int TYPE_DRAWN_APPLICATION = 4;
        public static int LAST_APPLICATION_WINDOW = 99;
        public static int FIRST_SUB_WINDOW = 1000;
        public static int TYPE_APPLICATION_PANEL = 1000;
        public static int TYPE_APPLICATION_MEDIA = 1001;
        public static int TYPE_APPLICATION_SUB_PANEL = 1002;
        public static int TYPE_APPLICATION_ATTACHED_DIALOG = 1003;
        public static int TYPE_APPLICATION_MEDIA_OVERLAY = 1004;
        public static int TYPE_APPLICATION_ABOVE_SUB_PANEL = 1005;
        public static int LAST_SUB_WINDOW = 1999;
        public static int FIRST_SYSTEM_WINDOW = 2000;
        public static int TYPE_STATUS_BAR = 2000;
        public static int TYPE_SEARCH_BAR = 2001;
        @Deprecated
        public static int TYPE_PHONE = 2002;
        @Deprecated
        public static int TYPE_SYSTEM_ALERT = 2003;
        public static int TYPE_KEYGUARD = 2004;
        @Deprecated
        public static int TYPE_TOAST = 2005;
        @Deprecated
        public static int TYPE_SYSTEM_OVERLAY = 2006;
        @Deprecated
        public static int TYPE_PRIORITY_PHONE = 2007;
        public static int TYPE_SYSTEM_DIALOG = 2008;
        public static int TYPE_KEYGUARD_DIALOG = 2009;
        @Deprecated
        public static int TYPE_SYSTEM_ERROR = 2010;
        public static int TYPE_INPUT_METHOD = 2011;
        public static int TYPE_INPUT_METHOD_DIALOG = 2012;
        public static int TYPE_WALLPAPER = 2013;
        public static int TYPE_STATUS_BAR_PANEL = 2014;
        public static int TYPE_SECURE_SYSTEM_OVERLAY = 2015;
        public static int TYPE_DRAG = 2016;
        public static int TYPE_STATUS_BAR_SUB_PANEL = 2017;
        public static int TYPE_POINTER = 2018;
        public static int TYPE_NAVIGATION_BAR = 2019;
        public static int TYPE_VOLUME_OVERLAY = 2020;
        public static int TYPE_BOOT_PROGRESS = 2021;
        public static int TYPE_INPUT_CONSUMER = 2022;
        public static int TYPE_DREAM = 2023;
        public static int TYPE_NAVIGATION_BAR_PANEL = 2024;
        public static int TYPE_DISPLAY_OVERLAY = 2026;
        public static int TYPE_MAGNIFICATION_OVERLAY = 2027;
        public static int TYPE_PRIVATE_PRESENTATION = 2030;
        public static int TYPE_VOICE_INTERACTION = 2031;
        public static int TYPE_ACCESSIBILITY_OVERLAY = 2032;
        public static int TYPE_VOICE_INTERACTION_STARTING = 2033;
        public static int TYPE_DOCK_DIVIDER = 2034;
        public static int TYPE_QS_DIALOG = 2035;
        public static int TYPE_SCREENSHOT = 2036;
        public static int TYPE_PRESENTATION = 2037;
        public static int TYPE_APPLICATION_OVERLAY = 2038;
        public static int LAST_SYSTEM_WINDOW = 2999;
        public static int INVALID_WINDOW_TYPE = -1;
        @Deprecated
        public static int MEMORY_TYPE_NORMAL = 0;
        @Deprecated
        public static int MEMORY_TYPE_HARDWARE = 1;
        @Deprecated
        public static int MEMORY_TYPE_GPU = 2;
        @Deprecated
        public static int MEMORY_TYPE_PUSH_BUFFERS = 3;
        @Deprecated
        public int memoryType;
        public static int FLAG_ALLOW_LOCK_WHILE_SCREEN_ON = 1;
        public static int FLAG_DIM_BEHIND = 2;
        @Deprecated
        public static int FLAG_BLUR_BEHIND = 4;
        public static int FLAG_NOT_FOCUSABLE = 8;
        public static int FLAG_NOT_TOUCHABLE = 16;
        public static int FLAG_NOT_TOUCH_MODAL = 32;
        @Deprecated
        public static int FLAG_TOUCHABLE_WHEN_WAKING = 64;
        public static int FLAG_KEEP_SCREEN_ON = 128;
        public static int FLAG_LAYOUT_IN_SCREEN = 256;
        public static int FLAG_LAYOUT_NO_LIMITS = 512;
        public static int FLAG_FULLSCREEN = 1024;
        public static int FLAG_FORCE_NOT_FULLSCREEN = 2048;
        @Deprecated
        public static int FLAG_DITHER = 4096;
        public static int FLAG_SECURE = 8192;
        public static int FLAG_SCALED = 16384;
        public static int FLAG_IGNORE_CHEEK_PRESSES = 32768;
        public static int FLAG_LAYOUT_INSET_DECOR = 65536;
        public static int FLAG_ALT_FOCUSABLE_IM = 131072;
        public static int FLAG_WATCH_OUTSIDE_TOUCH = 262144;
        public static int FLAG_SHOW_WHEN_LOCKED = 524288;
        public static int FLAG_SHOW_WALLPAPER = 0x100000;
        public static int FLAG_TURN_SCREEN_ON = 0x200000;
        @Deprecated
        public static int FLAG_DISMISS_KEYGUARD = 0x400000;
        public static int FLAG_SPLIT_TOUCH = 0x800000;
        public static int FLAG_HARDWARE_ACCELERATED = 0x1000000;
        public static int FLAG_LAYOUT_IN_OVERSCAN = 0x2000000;
        public static int FLAG_TRANSLUCENT_STATUS = 0x4000000;
        public static int FLAG_TRANSLUCENT_NAVIGATION = 0x8000000;
        public static int FLAG_LOCAL_FOCUS_MODE = 0x10000000;
        public static int FLAG_SLIPPERY = 0x20000000;
        public static int FLAG_LAYOUT_ATTACHED_IN_DECOR = 0x40000000;
        public static int FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS = Integer.MIN_VALUE;
        @ViewDebug.ExportedProperty(flagMapping={@ViewDebug.FlagToString(mask=1, equals=1, name="FLAG_ALLOW_LOCK_WHILE_SCREEN_ON"), @ViewDebug.FlagToString(mask=2, equals=2, name="FLAG_DIM_BEHIND"), @ViewDebug.FlagToString(mask=4, equals=4, name="FLAG_BLUR_BEHIND"), @ViewDebug.FlagToString(mask=8, equals=8, name="FLAG_NOT_FOCUSABLE"), @ViewDebug.FlagToString(mask=16, equals=16, name="FLAG_NOT_TOUCHABLE"), @ViewDebug.FlagToString(mask=32, equals=32, name="FLAG_NOT_TOUCH_MODAL"), @ViewDebug.FlagToString(mask=64, equals=64, name="FLAG_TOUCHABLE_WHEN_WAKING"), @ViewDebug.FlagToString(mask=128, equals=128, name="FLAG_KEEP_SCREEN_ON"), @ViewDebug.FlagToString(mask=256, equals=256, name="FLAG_LAYOUT_IN_SCREEN"), @ViewDebug.FlagToString(mask=512, equals=512, name="FLAG_LAYOUT_NO_LIMITS"), @ViewDebug.FlagToString(mask=1024, equals=1024, name="FLAG_FULLSCREEN"), @ViewDebug.FlagToString(mask=2048, equals=2048, name="FLAG_FORCE_NOT_FULLSCREEN"), @ViewDebug.FlagToString(mask=4096, equals=4096, name="FLAG_DITHER"), @ViewDebug.FlagToString(mask=8192, equals=8192, name="FLAG_SECURE"), @ViewDebug.FlagToString(mask=16384, equals=16384, name="FLAG_SCALED"), @ViewDebug.FlagToString(mask=32768, equals=32768, name="FLAG_IGNORE_CHEEK_PRESSES"), @ViewDebug.FlagToString(mask=65536, equals=65536, name="FLAG_LAYOUT_INSET_DECOR"), @ViewDebug.FlagToString(mask=131072, equals=131072, name="FLAG_ALT_FOCUSABLE_IM"), @ViewDebug.FlagToString(mask=262144, equals=262144, name="FLAG_WATCH_OUTSIDE_TOUCH"), @ViewDebug.FlagToString(mask=524288, equals=524288, name="FLAG_SHOW_WHEN_LOCKED"), @ViewDebug.FlagToString(mask=0x100000, equals=0x100000, name="FLAG_SHOW_WALLPAPER"), @ViewDebug.FlagToString(mask=0x200000, equals=0x200000, name="FLAG_TURN_SCREEN_ON"), @ViewDebug.FlagToString(mask=0x400000, equals=0x400000, name="FLAG_DISMISS_KEYGUARD"), @ViewDebug.FlagToString(mask=0x800000, equals=0x800000, name="FLAG_SPLIT_TOUCH"), @ViewDebug.FlagToString(mask=0x1000000, equals=0x1000000, name="FLAG_HARDWARE_ACCELERATED"), @ViewDebug.FlagToString(mask=0x10000000, equals=0x10000000, name="FLAG_LOCAL_FOCUS_MODE"), @ViewDebug.FlagToString(mask=0x4000000, equals=0x4000000, name="FLAG_TRANSLUCENT_STATUS"), @ViewDebug.FlagToString(mask=0x8000000, equals=0x8000000, name="FLAG_TRANSLUCENT_NAVIGATION"), @ViewDebug.FlagToString(mask=-2147483648, equals=-2147483648, name="FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS")}, formatToHexString=true)
        public int flags;
        public static int PRIVATE_FLAG_FAKE_HARDWARE_ACCELERATED = 1;
        public static int PRIVATE_FLAG_FORCE_HARDWARE_ACCELERATED = 2;
        public static int PRIVATE_FLAG_WANTS_OFFSET_NOTIFICATIONS = 4;
        public static int PRIVATE_FLAG_SHOW_FOR_ALL_USERS = 16;
        public static int PRIVATE_FLAG_NO_MOVE_ANIMATION = 64;
        public static int PRIVATE_FLAG_COMPATIBLE_WINDOW = 128;
        public static int PRIVATE_FLAG_SYSTEM_ERROR = 256;
        public static int PRIVATE_FLAG_INHERIT_TRANSLUCENT_DECOR = 512;
        public static int PRIVATE_FLAG_KEYGUARD = 1024;
        public static int PRIVATE_FLAG_DISABLE_WALLPAPER_TOUCH_EVENTS = 2048;
        public static int PRIVATE_FLAG_FORCE_STATUS_BAR_VISIBLE_TRANSPARENT = 4096;
        public static int PRIVATE_FLAG_PRESERVE_GEOMETRY = 8192;
        public static int PRIVATE_FLAG_FORCE_DECOR_VIEW_VISIBILITY = 16384;
        public static int PRIVATE_FLAG_WILL_NOT_REPLACE_ON_RELAUNCH = 32768;
        public static int PRIVATE_FLAG_LAYOUT_CHILD_WINDOW_IN_PARENT_FRAME = 65536;
        public static int PRIVATE_FLAG_FORCE_DRAW_STATUS_BAR_BACKGROUND = 131072;
        public static int PRIVATE_FLAG_SUSTAINED_PERFORMANCE_MODE = 262144;
        public static int PRIVATE_FLAG_TASK_SNAPSHOT = 524288;
        public int privateFlags;
        public static int NEEDS_MENU_UNSET = 0;
        public static int NEEDS_MENU_SET_TRUE = 1;
        public static int NEEDS_MENU_SET_FALSE = 2;
        public int needsMenuKey;
        public static int SOFT_INPUT_MASK_STATE = 15;
        public static int SOFT_INPUT_STATE_UNSPECIFIED = 0;
        public static int SOFT_INPUT_STATE_UNCHANGED = 1;
        public static int SOFT_INPUT_STATE_HIDDEN = 2;
        public static int SOFT_INPUT_STATE_ALWAYS_HIDDEN = 3;
        public static int SOFT_INPUT_STATE_VISIBLE = 4;
        public static int SOFT_INPUT_STATE_ALWAYS_VISIBLE = 5;
        public static int SOFT_INPUT_MASK_ADJUST = 240;
        public static int SOFT_INPUT_ADJUST_UNSPECIFIED = 0;
        public static int SOFT_INPUT_ADJUST_RESIZE = 16;
        public static int SOFT_INPUT_ADJUST_PAN = 32;
        public static int SOFT_INPUT_ADJUST_NOTHING = 48;
        public static int SOFT_INPUT_IS_FORWARD_NAVIGATION = 256;
        public int softInputMode;
        public int gravity;
        public float horizontalMargin;
        public float verticalMargin;
        public Rect surfaceInsets;
        public boolean hasManualSurfaceInsets;
        public boolean preservePreviousSurfaceInsets;
        public int format;
        public int windowAnimations;
        public float alpha;
        public float dimAmount;
        public static float BRIGHTNESS_OVERRIDE_NONE = -1.0f;
        public static float BRIGHTNESS_OVERRIDE_OFF = 0.0f;
        public static float BRIGHTNESS_OVERRIDE_FULL = 1.0f;
        public float screenBrightness;
        public float buttonBrightness;
        public static int ROTATION_ANIMATION_ROTATE = 0;
        public static int ROTATION_ANIMATION_CROSSFADE = 1;
        public static int ROTATION_ANIMATION_JUMPCUT = 2;
        public static int ROTATION_ANIMATION_SEAMLESS = 3;
        public int rotationAnimation;
        public IBinder token;
        public String packageName;
        public int screenOrientation;
        @Deprecated
        public float preferredRefreshRate;
        public int preferredDisplayModeId;
        public int systemUiVisibility;
        public int subtreeSystemUiVisibility;
        public boolean hasSystemUiListeners;
        public static int INPUT_FEATURE_DISABLE_POINTER_GESTURES = 1;
        public static int INPUT_FEATURE_NO_INPUT_CHANNEL = 2;
        public static int INPUT_FEATURE_DISABLE_USER_ACTIVITY = 4;
        public int inputFeatures;
        public long userActivityTimeout;
        public int accessibilityIdOfAnchor;
        public CharSequence accessibilityTitle;
        public long hideTimeoutMilliseconds;
        private int mColorMode;
        public static Parcelable.Creator<LayoutParams> CREATOR;
        public static int LAYOUT_CHANGED = 1;
        public static int TYPE_CHANGED = 2;
        public static int FLAGS_CHANGED = 4;
        public static int FORMAT_CHANGED = 8;
        public static int ANIMATION_CHANGED = 16;
        public static int DIM_AMOUNT_CHANGED = 32;
        public static int TITLE_CHANGED = 64;
        public static int ALPHA_CHANGED = 128;
        public static int MEMORY_TYPE_CHANGED = 256;
        public static int SOFT_INPUT_MODE_CHANGED = 512;
        public static int SCREEN_ORIENTATION_CHANGED = 1024;
        public static int SCREEN_BRIGHTNESS_CHANGED = 2048;
        public static int ROTATION_ANIMATION_CHANGED = 4096;
        public static int BUTTON_BRIGHTNESS_CHANGED = 8192;
        public static int SYSTEM_UI_VISIBILITY_CHANGED = 16384;
        public static int SYSTEM_UI_LISTENER_CHANGED = 32768;
        public static int INPUT_FEATURES_CHANGED = 65536;
        public static int PRIVATE_FLAGS_CHANGED = 131072;
        public static int USER_ACTIVITY_TIMEOUT_CHANGED = 262144;
        public static int TRANSLUCENT_FLAGS_CHANGED = 524288;
        public static int SURFACE_INSETS_CHANGED = 0x100000;
        public static int PREFERRED_REFRESH_RATE_CHANGED = 0x200000;
        public static int NEEDS_MENU_KEY_CHANGED = 0x400000;
        public static int PREFERRED_DISPLAY_MODE_ID = 0x800000;
        public static int ACCESSIBILITY_ANCHOR_CHANGED = 0x1000000;
        public static int ACCESSIBILITY_TITLE_CHANGED = 0x2000000;
        public static int EVERYTHING_CHANGED = -1;
        private int[] mCompatibilityParamsBackup;
        private CharSequence mTitle;

        private static final boolean $$robo$$android_view_WindowManager_LayoutParams$isSystemAlertWindowType(int type) {
            switch (type) {
                case 2002: 
                case 2003: 
                case 2006: 
                case 2007: 
                case 2010: 
                case 2038: {
                    return true;
                }
            }
            return false;
        }

        private static final boolean $$robo$$android_view_WindowManager_LayoutParams$mayUseInputMethod(int flags) {
            switch (flags & 0x20008) {
                case 0: 
                case 131080: {
                    return true;
                }
            }
            return false;
        }

        private void $$robo$$android_view_WindowManager_LayoutParams$__constructor__() {
            this.needsMenuKey = 0;
            this.surfaceInsets = new Rect();
            this.preservePreviousSurfaceInsets = true;
            this.alpha = 1.0f;
            this.dimAmount = 1.0f;
            this.screenBrightness = -1.0f;
            this.buttonBrightness = -1.0f;
            this.rotationAnimation = 0;
            this.token = null;
            this.packageName = null;
            this.screenOrientation = -1;
            this.userActivityTimeout = -1L;
            this.accessibilityIdOfAnchor = -1;
            this.hideTimeoutMilliseconds = -1L;
            this.mColorMode = 0;
            this.mCompatibilityParamsBackup = null;
            this.mTitle = null;
            this.type = 2;
            this.format = -1;
        }

        private void $$robo$$android_view_WindowManager_LayoutParams$__constructor__(int _type) {
            this.needsMenuKey = 0;
            this.surfaceInsets = new Rect();
            this.preservePreviousSurfaceInsets = true;
            this.alpha = 1.0f;
            this.dimAmount = 1.0f;
            this.screenBrightness = -1.0f;
            this.buttonBrightness = -1.0f;
            this.rotationAnimation = 0;
            this.token = null;
            this.packageName = null;
            this.screenOrientation = -1;
            this.userActivityTimeout = -1L;
            this.accessibilityIdOfAnchor = -1;
            this.hideTimeoutMilliseconds = -1L;
            this.mColorMode = 0;
            this.mCompatibilityParamsBackup = null;
            this.mTitle = null;
            this.type = _type;
            this.format = -1;
        }

        private void $$robo$$android_view_WindowManager_LayoutParams$__constructor__(int _type, int _flags) {
            this.needsMenuKey = 0;
            this.surfaceInsets = new Rect();
            this.preservePreviousSurfaceInsets = true;
            this.alpha = 1.0f;
            this.dimAmount = 1.0f;
            this.screenBrightness = -1.0f;
            this.buttonBrightness = -1.0f;
            this.rotationAnimation = 0;
            this.token = null;
            this.packageName = null;
            this.screenOrientation = -1;
            this.userActivityTimeout = -1L;
            this.accessibilityIdOfAnchor = -1;
            this.hideTimeoutMilliseconds = -1L;
            this.mColorMode = 0;
            this.mCompatibilityParamsBackup = null;
            this.mTitle = null;
            this.type = _type;
            this.flags = _flags;
            this.format = -1;
        }

        private void $$robo$$android_view_WindowManager_LayoutParams$__constructor__(int _type, int _flags, int _format) {
            this.needsMenuKey = 0;
            this.surfaceInsets = new Rect();
            this.preservePreviousSurfaceInsets = true;
            this.alpha = 1.0f;
            this.dimAmount = 1.0f;
            this.screenBrightness = -1.0f;
            this.buttonBrightness = -1.0f;
            this.rotationAnimation = 0;
            this.token = null;
            this.packageName = null;
            this.screenOrientation = -1;
            this.userActivityTimeout = -1L;
            this.accessibilityIdOfAnchor = -1;
            this.hideTimeoutMilliseconds = -1L;
            this.mColorMode = 0;
            this.mCompatibilityParamsBackup = null;
            this.mTitle = null;
            this.type = _type;
            this.flags = _flags;
            this.format = _format;
        }

        private void $$robo$$android_view_WindowManager_LayoutParams$__constructor__(int w, int h, int _type, int _flags, int _format) {
            this.needsMenuKey = 0;
            this.surfaceInsets = new Rect();
            this.preservePreviousSurfaceInsets = true;
            this.alpha = 1.0f;
            this.dimAmount = 1.0f;
            this.screenBrightness = -1.0f;
            this.buttonBrightness = -1.0f;
            this.rotationAnimation = 0;
            this.token = null;
            this.packageName = null;
            this.screenOrientation = -1;
            this.userActivityTimeout = -1L;
            this.accessibilityIdOfAnchor = -1;
            this.hideTimeoutMilliseconds = -1L;
            this.mColorMode = 0;
            this.mCompatibilityParamsBackup = null;
            this.mTitle = null;
            this.type = _type;
            this.flags = _flags;
            this.format = _format;
        }

        private void $$robo$$android_view_WindowManager_LayoutParams$__constructor__(int w, int h, int xpos, int ypos, int _type, int _flags, int _format) {
            this.needsMenuKey = 0;
            this.surfaceInsets = new Rect();
            this.preservePreviousSurfaceInsets = true;
            this.alpha = 1.0f;
            this.dimAmount = 1.0f;
            this.screenBrightness = -1.0f;
            this.buttonBrightness = -1.0f;
            this.rotationAnimation = 0;
            this.token = null;
            this.packageName = null;
            this.screenOrientation = -1;
            this.userActivityTimeout = -1L;
            this.accessibilityIdOfAnchor = -1;
            this.hideTimeoutMilliseconds = -1L;
            this.mColorMode = 0;
            this.mCompatibilityParamsBackup = null;
            this.mTitle = null;
            this.x = xpos;
            this.y = ypos;
            this.type = _type;
            this.flags = _flags;
            this.format = _format;
        }

        private final void $$robo$$android_view_WindowManager_LayoutParams$setTitle(CharSequence title) {
            if (null == title) {
                title = "";
            }
            this.mTitle = TextUtils.stringOrSpannedString(title);
        }

        private final CharSequence $$robo$$android_view_WindowManager_LayoutParams$getTitle() {
            return this.mTitle != null ? this.mTitle : "";
        }

        private final void $$robo$$android_view_WindowManager_LayoutParams$setSurfaceInsets(View view, boolean manual, boolean preservePrevious) {
            int surfaceInset = (int)Math.ceil(view.getZ() * 2.0f);
            if (surfaceInset == 0) {
                this.surfaceInsets.set(0, 0, 0, 0);
            } else {
                this.surfaceInsets.set(Math.max(surfaceInset, this.surfaceInsets.left), Math.max(surfaceInset, this.surfaceInsets.top), Math.max(surfaceInset, this.surfaceInsets.right), Math.max(surfaceInset, this.surfaceInsets.bottom));
            }
            this.hasManualSurfaceInsets = manual;
            this.preservePreviousSurfaceInsets = preservePrevious;
        }

        private final void $$robo$$android_view_WindowManager_LayoutParams$setColorMode(int colorMode) {
            this.mColorMode = colorMode;
        }

        private final int $$robo$$android_view_WindowManager_LayoutParams$getColorMode() {
            return this.mColorMode;
        }

        private final void $$robo$$android_view_WindowManager_LayoutParams$setUserActivityTimeout(long timeout) {
            this.userActivityTimeout = timeout;
        }

        private final long $$robo$$android_view_WindowManager_LayoutParams$getUserActivityTimeout() {
            return this.userActivityTimeout;
        }

        private final int $$robo$$android_view_WindowManager_LayoutParams$describeContents() {
            return 0;
        }

        private final void $$robo$$android_view_WindowManager_LayoutParams$writeToParcel(Parcel out, int parcelableFlags) {
            out.writeInt(this.width);
            out.writeInt(this.height);
            out.writeInt(this.x);
            out.writeInt(this.y);
            out.writeInt(this.type);
            out.writeInt(this.flags);
            out.writeInt(this.privateFlags);
            out.writeInt(this.softInputMode);
            out.writeInt(this.gravity);
            out.writeFloat(this.horizontalMargin);
            out.writeFloat(this.verticalMargin);
            out.writeInt(this.format);
            out.writeInt(this.windowAnimations);
            out.writeFloat(this.alpha);
            out.writeFloat(this.dimAmount);
            out.writeFloat(this.screenBrightness);
            out.writeFloat(this.buttonBrightness);
            out.writeInt(this.rotationAnimation);
            out.writeStrongBinder(this.token);
            out.writeString(this.packageName);
            TextUtils.writeToParcel(this.mTitle, out, parcelableFlags);
            out.writeInt(this.screenOrientation);
            out.writeFloat(this.preferredRefreshRate);
            out.writeInt(this.preferredDisplayModeId);
            out.writeInt(this.systemUiVisibility);
            out.writeInt(this.subtreeSystemUiVisibility);
            out.writeInt(this.hasSystemUiListeners ? 1 : 0);
            out.writeInt(this.inputFeatures);
            out.writeLong(this.userActivityTimeout);
            out.writeInt(this.surfaceInsets.left);
            out.writeInt(this.surfaceInsets.top);
            out.writeInt(this.surfaceInsets.right);
            out.writeInt(this.surfaceInsets.bottom);
            out.writeInt(this.hasManualSurfaceInsets ? 1 : 0);
            out.writeInt(this.preservePreviousSurfaceInsets ? 1 : 0);
            out.writeInt(this.needsMenuKey);
            out.writeInt(this.accessibilityIdOfAnchor);
            TextUtils.writeToParcel(this.accessibilityTitle, out, parcelableFlags);
            out.writeLong(this.hideTimeoutMilliseconds);
        }

        private void $$robo$$android_view_WindowManager_LayoutParams$__constructor__(Parcel in) {
            this.needsMenuKey = 0;
            this.surfaceInsets = new Rect();
            this.preservePreviousSurfaceInsets = true;
            this.alpha = 1.0f;
            this.dimAmount = 1.0f;
            this.screenBrightness = -1.0f;
            this.buttonBrightness = -1.0f;
            this.rotationAnimation = 0;
            this.token = null;
            this.packageName = null;
            this.screenOrientation = -1;
            this.userActivityTimeout = -1L;
            this.accessibilityIdOfAnchor = -1;
            this.hideTimeoutMilliseconds = -1L;
            this.mColorMode = 0;
            this.mCompatibilityParamsBackup = null;
            this.mTitle = null;
            this.width = in.readInt();
            this.height = in.readInt();
            this.x = in.readInt();
            this.y = in.readInt();
            this.type = in.readInt();
            this.flags = in.readInt();
            this.privateFlags = in.readInt();
            this.softInputMode = in.readInt();
            this.gravity = in.readInt();
            this.horizontalMargin = in.readFloat();
            this.verticalMargin = in.readFloat();
            this.format = in.readInt();
            this.windowAnimations = in.readInt();
            this.alpha = in.readFloat();
            this.dimAmount = in.readFloat();
            this.screenBrightness = in.readFloat();
            this.buttonBrightness = in.readFloat();
            this.rotationAnimation = in.readInt();
            this.token = in.readStrongBinder();
            this.packageName = in.readString();
            this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.screenOrientation = in.readInt();
            this.preferredRefreshRate = in.readFloat();
            this.preferredDisplayModeId = in.readInt();
            this.systemUiVisibility = in.readInt();
            this.subtreeSystemUiVisibility = in.readInt();
            this.hasSystemUiListeners = in.readInt() != 0;
            this.inputFeatures = in.readInt();
            this.userActivityTimeout = in.readLong();
            this.surfaceInsets.left = in.readInt();
            this.surfaceInsets.top = in.readInt();
            this.surfaceInsets.right = in.readInt();
            this.surfaceInsets.bottom = in.readInt();
            this.hasManualSurfaceInsets = in.readInt() != 0;
            this.preservePreviousSurfaceInsets = in.readInt() != 0;
            this.needsMenuKey = in.readInt();
            this.accessibilityIdOfAnchor = in.readInt();
            this.accessibilityTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            this.hideTimeoutMilliseconds = in.readLong();
        }

        private final int $$robo$$android_view_WindowManager_LayoutParams$copyFrom(LayoutParams o) {
            int changes = 0;
            if (this.width != o.width) {
                this.width = o.width;
                changes |= 1;
            }
            if (this.height != o.height) {
                this.height = o.height;
                changes |= 1;
            }
            if (this.x != o.x) {
                this.x = o.x;
                changes |= 1;
            }
            if (this.y != o.y) {
                this.y = o.y;
                changes |= 1;
            }
            if (this.horizontalWeight != o.horizontalWeight) {
                this.horizontalWeight = o.horizontalWeight;
                changes |= 1;
            }
            if (this.verticalWeight != o.verticalWeight) {
                this.verticalWeight = o.verticalWeight;
                changes |= 1;
            }
            if (this.horizontalMargin != o.horizontalMargin) {
                this.horizontalMargin = o.horizontalMargin;
                changes |= 1;
            }
            if (this.verticalMargin != o.verticalMargin) {
                this.verticalMargin = o.verticalMargin;
                changes |= 1;
            }
            if (this.type != o.type) {
                this.type = o.type;
                changes |= 2;
            }
            if (this.flags != o.flags) {
                int diff = this.flags ^ o.flags;
                if ((diff & 0xC000000) != 0) {
                    changes |= 0x80000;
                }
                this.flags = o.flags;
                changes |= 4;
            }
            if (this.privateFlags != o.privateFlags) {
                this.privateFlags = o.privateFlags;
                changes |= 0x20000;
            }
            if (this.softInputMode != o.softInputMode) {
                this.softInputMode = o.softInputMode;
                changes |= 0x200;
            }
            if (this.gravity != o.gravity) {
                this.gravity = o.gravity;
                changes |= 1;
            }
            if (this.format != o.format) {
                this.format = o.format;
                changes |= 8;
            }
            if (this.windowAnimations != o.windowAnimations) {
                this.windowAnimations = o.windowAnimations;
                changes |= 0x10;
            }
            if (this.token == null) {
                this.token = o.token;
            }
            if (this.packageName == null) {
                this.packageName = o.packageName;
            }
            if (!Objects.equals(this.mTitle, o.mTitle) && o.mTitle != null) {
                this.mTitle = o.mTitle;
                changes |= 0x40;
            }
            if (this.alpha != o.alpha) {
                this.alpha = o.alpha;
                changes |= 0x80;
            }
            if (this.dimAmount != o.dimAmount) {
                this.dimAmount = o.dimAmount;
                changes |= 0x20;
            }
            if (this.screenBrightness != o.screenBrightness) {
                this.screenBrightness = o.screenBrightness;
                changes |= 0x800;
            }
            if (this.buttonBrightness != o.buttonBrightness) {
                this.buttonBrightness = o.buttonBrightness;
                changes |= 0x2000;
            }
            if (this.rotationAnimation != o.rotationAnimation) {
                this.rotationAnimation = o.rotationAnimation;
                changes |= 0x1000;
            }
            if (this.screenOrientation != o.screenOrientation) {
                this.screenOrientation = o.screenOrientation;
                changes |= 0x400;
            }
            if (this.preferredRefreshRate != o.preferredRefreshRate) {
                this.preferredRefreshRate = o.preferredRefreshRate;
                changes |= 0x200000;
            }
            if (this.preferredDisplayModeId != o.preferredDisplayModeId) {
                this.preferredDisplayModeId = o.preferredDisplayModeId;
                changes |= 0x800000;
            }
            if (this.systemUiVisibility != o.systemUiVisibility || this.subtreeSystemUiVisibility != o.subtreeSystemUiVisibility) {
                this.systemUiVisibility = o.systemUiVisibility;
                this.subtreeSystemUiVisibility = o.subtreeSystemUiVisibility;
                changes |= 0x4000;
            }
            if (this.hasSystemUiListeners != o.hasSystemUiListeners) {
                this.hasSystemUiListeners = o.hasSystemUiListeners;
                changes |= 0x8000;
            }
            if (this.inputFeatures != o.inputFeatures) {
                this.inputFeatures = o.inputFeatures;
                changes |= 0x10000;
            }
            if (this.userActivityTimeout != o.userActivityTimeout) {
                this.userActivityTimeout = o.userActivityTimeout;
                changes |= 0x40000;
            }
            if (!this.surfaceInsets.equals(o.surfaceInsets)) {
                this.surfaceInsets.set(o.surfaceInsets);
                changes |= 0x100000;
            }
            if (this.hasManualSurfaceInsets != o.hasManualSurfaceInsets) {
                this.hasManualSurfaceInsets = o.hasManualSurfaceInsets;
                changes |= 0x100000;
            }
            if (this.preservePreviousSurfaceInsets != o.preservePreviousSurfaceInsets) {
                this.preservePreviousSurfaceInsets = o.preservePreviousSurfaceInsets;
                changes |= 0x100000;
            }
            if (this.needsMenuKey != o.needsMenuKey) {
                this.needsMenuKey = o.needsMenuKey;
                changes |= 0x400000;
            }
            if (this.accessibilityIdOfAnchor != o.accessibilityIdOfAnchor) {
                this.accessibilityIdOfAnchor = o.accessibilityIdOfAnchor;
                changes |= 0x1000000;
            }
            if (!Objects.equals(this.accessibilityTitle, o.accessibilityTitle) && o.accessibilityTitle != null) {
                this.accessibilityTitle = o.accessibilityTitle;
                changes |= 0x2000000;
            }
            this.hideTimeoutMilliseconds = o.hideTimeoutMilliseconds;
            return changes;
        }

        private final String $$robo$$android_view_WindowManager_LayoutParams$debug(String output) {
            output = output + "Contents of " + this + ":";
            Log.d("Debug", output);
            output = super.debug("");
            Log.d("Debug", output);
            Log.d("Debug", "");
            Log.d("Debug", "WindowManager.LayoutParams={title=" + this.mTitle + "}");
            return "";
        }

        private final String $$robo$$android_view_WindowManager_LayoutParams$toString() {
            StringBuilder sb = new StringBuilder(256);
            sb.append("WM.LayoutParams{");
            sb.append("(");
            sb.append(this.x);
            sb.append(',');
            sb.append(this.y);
            sb.append(")(");
            sb.append(this.width == -1 ? "fill" : (this.width == -2 ? "wrap" : String.valueOf(this.width)));
            sb.append('x');
            sb.append(this.height == -1 ? "fill" : (this.height == -2 ? "wrap" : String.valueOf(this.height)));
            sb.append(")");
            if (this.horizontalMargin != 0.0f) {
                sb.append(" hm=");
                sb.append(this.horizontalMargin);
            }
            if (this.verticalMargin != 0.0f) {
                sb.append(" vm=");
                sb.append(this.verticalMargin);
            }
            if (this.gravity != 0) {
                sb.append(" gr=#");
                sb.append(Integer.toHexString(this.gravity));
            }
            if (this.softInputMode != 0) {
                sb.append(" sim=#");
                sb.append(Integer.toHexString(this.softInputMode));
            }
            sb.append(" ty=");
            sb.append(this.type);
            sb.append(" fl=#");
            sb.append(Integer.toHexString(this.flags));
            if (this.privateFlags != 0) {
                if ((this.privateFlags & 0x80) != 0) {
                    sb.append(" compatible=true");
                }
                sb.append(" pfl=0x").append(Integer.toHexString(this.privateFlags));
            }
            if (this.format != -1) {
                sb.append(" fmt=");
                sb.append(this.format);
            }
            if (this.windowAnimations != 0) {
                sb.append(" wanim=0x");
                sb.append(Integer.toHexString(this.windowAnimations));
            }
            if (this.screenOrientation != -1) {
                sb.append(" or=");
                sb.append(this.screenOrientation);
            }
            if (this.alpha != 1.0f) {
                sb.append(" alpha=");
                sb.append(this.alpha);
            }
            if (this.screenBrightness != -1.0f) {
                sb.append(" sbrt=");
                sb.append(this.screenBrightness);
            }
            if (this.buttonBrightness != -1.0f) {
                sb.append(" bbrt=");
                sb.append(this.buttonBrightness);
            }
            if (this.rotationAnimation != 0) {
                sb.append(" rotAnim=");
                sb.append(this.rotationAnimation);
            }
            if (this.preferredRefreshRate != 0.0f) {
                sb.append(" preferredRefreshRate=");
                sb.append(this.preferredRefreshRate);
            }
            if (this.preferredDisplayModeId != 0) {
                sb.append(" preferredDisplayMode=");
                sb.append(this.preferredDisplayModeId);
            }
            if (this.systemUiVisibility != 0) {
                sb.append(" sysui=0x");
                sb.append(Integer.toHexString(this.systemUiVisibility));
            }
            if (this.subtreeSystemUiVisibility != 0) {
                sb.append(" vsysui=0x");
                sb.append(Integer.toHexString(this.subtreeSystemUiVisibility));
            }
            if (this.hasSystemUiListeners) {
                sb.append(" sysuil=");
                sb.append(this.hasSystemUiListeners);
            }
            if (this.inputFeatures != 0) {
                sb.append(" if=0x").append(Integer.toHexString(this.inputFeatures));
            }
            if (this.userActivityTimeout >= 0L) {
                sb.append(" userActivityTimeout=").append(this.userActivityTimeout);
            }
            if (this.surfaceInsets.left != 0 || this.surfaceInsets.top != 0 || this.surfaceInsets.right != 0 || this.surfaceInsets.bottom != 0 || this.hasManualSurfaceInsets || !this.preservePreviousSurfaceInsets) {
                sb.append(" surfaceInsets=").append(this.surfaceInsets);
                if (this.hasManualSurfaceInsets) {
                    sb.append(" (manual)");
                }
                if (!this.preservePreviousSurfaceInsets) {
                    sb.append(" (!preservePreviousSurfaceInsets)");
                }
            }
            if (this.needsMenuKey != 0) {
                sb.append(" needsMenuKey=");
                sb.append(this.needsMenuKey);
            }
            sb.append(" colorMode=").append(this.mColorMode);
            sb.append('}');
            return sb.toString();
        }

        private final void $$robo$$android_view_WindowManager_LayoutParams$scale(float scale) {
            this.x = (int)((float)this.x * scale + 0.5f);
            this.y = (int)((float)this.y * scale + 0.5f);
            if (this.width > 0) {
                this.width = (int)((float)this.width * scale + 0.5f);
            }
            if (this.height > 0) {
                this.height = (int)((float)this.height * scale + 0.5f);
            }
        }

        private final void $$robo$$android_view_WindowManager_LayoutParams$backup() {
            int[] backup = this.mCompatibilityParamsBackup;
            if (backup == null) {
                backup = this.mCompatibilityParamsBackup = new int[4];
            }
            backup[0] = this.x;
            backup[1] = this.y;
            backup[2] = this.width;
            backup[3] = this.height;
        }

        private final void $$robo$$android_view_WindowManager_LayoutParams$restore() {
            int[] backup = this.mCompatibilityParamsBackup;
            if (backup != null) {
                this.x = backup[0];
                this.y = backup[1];
                this.width = backup[2];
                this.height = backup[3];
            }
        }

        private final void $$robo$$android_view_WindowManager_LayoutParams$encodeProperties(ViewHierarchyEncoder encoder) {
            super.encodeProperties(encoder);
            encoder.addProperty("x", this.x);
            encoder.addProperty("y", this.y);
            encoder.addProperty("horizontalWeight", this.horizontalWeight);
            encoder.addProperty("verticalWeight", this.verticalWeight);
            encoder.addProperty("type", this.type);
            encoder.addProperty("flags", this.flags);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<LayoutParams>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_view_WindowManager_LayoutParams_1$__constructor__() {
                }

                private final LayoutParams $$robo$$android_view_WindowManager_LayoutParams_1$createFromParcel(Parcel in) {
                    return new LayoutParams(in);
                }

                private final LayoutParams[] $$robo$$android_view_WindowManager_LayoutParams_1$newArray(int size) {
                    return new LayoutParams[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_view_WindowManager_LayoutParams_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_LayoutParams_1$__constructor__(), this);
                }

                @Override
                public LayoutParams createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_WindowManager_LayoutParams_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public LayoutParams[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_WindowManager_LayoutParams_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        public static boolean isSystemAlertWindowType(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemAlertWindowType", $$robo$$android_view_WindowManager_LayoutParams$isSystemAlertWindowType(int ), (int)n);
        }

        public static boolean mayUseInputMethod(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("mayUseInputMethod", $$robo$$android_view_WindowManager_LayoutParams$mayUseInputMethod(int ), (int)n);
        }

        private void __constructor__() {
            this.$$robo$$android_view_WindowManager_LayoutParams$__constructor__();
        }

        public LayoutParams() {
            super(-1, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_LayoutParams$__constructor__(), this);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_view_WindowManager_LayoutParams$__constructor__(n);
        }

        public LayoutParams(int n) {
            super(-1, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_LayoutParams$__constructor__(int ), this, n);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_view_WindowManager_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(-1, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_LayoutParams$__constructor__(int int ), this, n, n2);
        }

        private void __constructor__(int n, int n2, int n3) {
            this.$$robo$$android_view_WindowManager_LayoutParams$__constructor__(n, n2, n3);
        }

        public LayoutParams(int n, int n2, int n3) {
            super(-1, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_LayoutParams$__constructor__(int int int ), this, n, n2, n3);
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5) {
            this.$$robo$$android_view_WindowManager_LayoutParams$__constructor__(n, n2, n3, n4, n5);
        }

        public LayoutParams(int n, int n2, int n3, int n4, int n5) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_LayoutParams$__constructor__(int int int int int ), this, n, n2, n3, n4, n5);
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.$$robo$$android_view_WindowManager_LayoutParams$__constructor__(n, n2, n3, n4, n5, n6, n7);
        }

        public LayoutParams(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_LayoutParams$__constructor__(int int int int int int int ), this, n, n2, n3, n4, n5, n6, n7);
        }

        public void setTitle(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_view_WindowManager_LayoutParams$setTitle(java.lang.CharSequence ), this, charSequence);
        }

        public CharSequence getTitle() {
            return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_view_WindowManager_LayoutParams$getTitle(), this);
        }

        public void setSurfaceInsets(View view, boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("setSurfaceInsets", $$robo$$android_view_WindowManager_LayoutParams$setSurfaceInsets(android.view.View boolean boolean ), this, view, bl, bl2);
        }

        public void setColorMode(int n) {
            InvokeDynamicSupport.bootstrap("setColorMode", $$robo$$android_view_WindowManager_LayoutParams$setColorMode(int ), this, n);
        }

        public int getColorMode() {
            return (int)InvokeDynamicSupport.bootstrap("getColorMode", $$robo$$android_view_WindowManager_LayoutParams$getColorMode(), this);
        }

        public void setUserActivityTimeout(long l) {
            InvokeDynamicSupport.bootstrap("setUserActivityTimeout", $$robo$$android_view_WindowManager_LayoutParams$setUserActivityTimeout(long ), this, l);
        }

        public long getUserActivityTimeout() {
            return (long)InvokeDynamicSupport.bootstrap("getUserActivityTimeout", $$robo$$android_view_WindowManager_LayoutParams$getUserActivityTimeout(), this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_WindowManager_LayoutParams$describeContents(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_WindowManager_LayoutParams$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_view_WindowManager_LayoutParams$__constructor__(parcel);
        }

        public LayoutParams(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_LayoutParams$__constructor__(android.os.Parcel ), this, parcel);
        }

        public int copyFrom(LayoutParams layoutParams) {
            return (int)InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_view_WindowManager_LayoutParams$copyFrom(android.view.WindowManager$LayoutParams ), this, layoutParams);
        }

        @Override
        public String debug(String string2) {
            return InvokeDynamicSupport.bootstrap("debug", $$robo$$android_view_WindowManager_LayoutParams$debug(java.lang.String ), this, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_WindowManager_LayoutParams$toString(), this);
        }

        public void scale(float f) {
            InvokeDynamicSupport.bootstrap("scale", $$robo$$android_view_WindowManager_LayoutParams$scale(float ), this, f);
        }

        void backup() {
            InvokeDynamicSupport.bootstrap("backup", $$robo$$android_view_WindowManager_LayoutParams$backup(), this);
        }

        void restore() {
            InvokeDynamicSupport.bootstrap("restore", $$robo$$android_view_WindowManager_LayoutParams$restore(), this);
        }

        @Override
        protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
            InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_view_WindowManager_LayoutParams$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
        }

        static {
            RobolectricInternals.classInitializing(LayoutParams.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(flag=true, value={0L, 1L, 2L, 3L, 4L, 5L, 0L, 16L, 32L, 48L, 256L})
        public static @interface SoftInputModeFlags {
        }
    }

    public static interface KeyboardShortcutsReceiver
    extends InstrumentedInterface {
        public void onKeyboardShortcutsReceived(List<KeyboardShortcutGroup> var1);
    }

    public static class InvalidDisplayException
    extends RuntimeException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_WindowManager_InvalidDisplayException$__constructor__() {
        }

        private void $$robo$$android_view_WindowManager_InvalidDisplayException$__constructor__(String name) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_WindowManager_InvalidDisplayException$__constructor__();
        }

        public InvalidDisplayException() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_InvalidDisplayException$__constructor__(), this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_view_WindowManager_InvalidDisplayException$__constructor__(string2);
        }

        public InvalidDisplayException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_InvalidDisplayException$__constructor__(java.lang.String ), this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InvalidDisplayException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BadTokenException
    extends RuntimeException
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_WindowManager_BadTokenException$__constructor__() {
        }

        private void $$robo$$android_view_WindowManager_BadTokenException$__constructor__(String name) {
        }

        private void __constructor__() {
            this.$$robo$$android_view_WindowManager_BadTokenException$__constructor__();
        }

        public BadTokenException() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_BadTokenException$__constructor__(), this);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_view_WindowManager_BadTokenException$__constructor__(string2);
        }

        public BadTokenException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_WindowManager_BadTokenException$__constructor__(java.lang.String ), this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BadTokenException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

